/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.CellularFilter;
import com.jhlabs.image.ImageMath;

public class CrystalizeFilter
extends CellularFilter {
    private double edgeThickness = 0.4;
    private boolean fadeEdges = false;

    public CrystalizeFilter() {
        this.setScale(16.0);
        this.setRandomness(0.0);
    }

    public void setEdgeThickness(double d) {
        this.edgeThickness = d;
    }

    public double getEdgeThickness() {
        return this.edgeThickness;
    }

    public void setFadeEdges(boolean bl) {
        this.fadeEdges = bl;
    }

    public boolean getFadeEdges() {
        return this.fadeEdges;
    }

    public int getPixel(int n, int n2, int[] nArray, int n3, int n4) {
        double d = this.m00 * (double)n + this.m01 * (double)n2;
        double d2 = this.m10 * (double)n + this.m11 * (double)n2;
        d /= this.scale;
        d2 /= this.scale * this.stretch;
        double d3 = this.distance(d += 1000.0, d2 += 1000.0);
        double d4 = this.results[0].distance;
        double d5 = this.results[1].distance;
        int n5 = ImageMath.clamp((int)((this.results[0].x - 1000.0) * this.scale), 0, n3 - 1);
        int n6 = ImageMath.clamp((int)((this.results[0].y - 1000.0) * this.scale), 0, n4 - 1);
        int n7 = nArray[n6 * n3 + n5];
        d3 = (d5 - d4) / this.edgeThickness;
        d3 = ImageMath.smoothStep(0.0, this.edgeThickness, d3);
        if (this.fadeEdges) {
            n5 = ImageMath.clamp((int)((this.results[1].x - 1000.0) * this.scale), 0, n3 - 1);
            n6 = ImageMath.clamp((int)((this.results[1].y - 1000.0) * this.scale), 0, n4 - 1);
            int n8 = nArray[n6 * n3 + n5];
            n8 = ImageMath.mixColors(0.5, n8, n7);
            n7 = ImageMath.mixColors(d3, n8, n7);
        } else {
            n7 = ImageMath.mixColors(d3, -16777216, n7);
        }
        return n7;
    }

    public String toString() {
        return "Stylize/Crystallize...";
    }
}

