/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.util;

import java.util.Objects;

public class OpenUtil {
    private OpenUtil() {
    }

    public static boolean isCodePointPrintable(int codePoint) {
        if (Character.isISOControl(codePoint)) {
            return false;
        }
        int category = Character.getType(codePoint);
        return category != 15 && category != 16 && category != 0 && category != 18 && category != 19;
    }

    public static boolean isSafeFontCodePointToPrint(int codePoint) {
        switch (codePoint) {
            case 173: 
            case 65532: {
                return false;
            }
        }
        return true;
    }

    public static boolean areAllCharactersPrintable(String str) {
        Objects.requireNonNull(str, "str");
        return str.codePoints().allMatch(OpenUtil::isSafeFontCodePointToPrint);
    }

    public static Integer parseIntegerOrNull(String possibleInteger) {
        try {
            return Integer.parseInt(possibleInteger);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static int firstNonZero(int ... values) {
        for (int value : values) {
            if (value == 0) continue;
            return value;
        }
        return 0;
    }
}

