/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import oracle.ons.CallBackMode;
import oracle.ons.Closable;
import oracle.ons.ConfigurationException;
import oracle.ons.NotificationManager;
import oracle.ons.NotificationNetwork;
import oracle.ons.ONSConfiguration;
import oracle.ons.ONSException;
import oracle.ons.Publisher;
import oracle.ons.Subscriber;
import oracle.ons.rpc.RpcServer;
import oracle.ons.rpc.impl.RpcServerImpl;

public class ONS
implements Closable {
    public static final String ONS_PERM_STRING = "ONSUser";
    public static final int ONS_ORACLE_HOME = 1;
    public static final int ONS_CONFIG_FILE = 2;
    public static final int ONS_ORACLE_INSTANCE = 3;
    public static final int ONS_PROTOCOL_VERSION = 4;
    public final ONSConfiguration config;
    private boolean adoptObjects = true;
    private List<WeakReference<Closable>> children = new ArrayList<WeakReference<Closable>>(2);
    private StreamHandler errorStreamHandler = null;
    private StreamHandler outStreamHandler = null;
    private static volatile ONS someONS = null;
    public PrintStream errstream;
    private PrintStream outstream;
    @Deprecated
    public boolean debug;

    public void setAdoptObjects(boolean adoptObjects) {
        this.adoptObjects = adoptObjects;
    }

    protected synchronized void addChildObject(Closable object) {
        if (this.adoptObjects) {
            this.children.add(new WeakReference<Closable>(object));
        }
    }

    public ONSConfiguration getConfiguration() {
        return this.config;
    }

    public NotificationNetwork getNetwork() {
        return this.config.getNetwork();
    }

    public void connectionDownReceived() {
        this.config.getNetwork().ping();
    }

    private void init() throws ONSException {
        NotificationNetwork network = this.config.getNetwork();
        try {
            network.lazyDemand().waitUntilOnline(this.config.getSocketTimeout(), true);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public ONS(int mode, String onsInitValue) throws ONSException {
        switch (mode) {
            case 2: {
                this.config = ONSConfiguration.getLocalConfigFromFile(null, new File(onsInitValue), null);
                break;
            }
            case 3: {
                this.config = ONSConfiguration.getConfigFromOPMN(onsInitValue);
                break;
            }
            case 1: {
                this.config = ONSConfiguration.getLocalConfigFromFile(onsInitValue, null, null);
                break;
            }
            default: {
                throw new ConfigurationException("Unknown parameter for ONS initialization");
            }
        }
        this.init();
    }

    public ONS(ONSConfiguration config) {
        this.config = config;
        someONS = this;
    }

    public ONS() {
        this.config = ONSConfiguration.initDefaultConfig();
        someONS = this;
    }

    public ONS(String config) throws ONSException {
        this.config = ONSConfiguration.getRemoteConfigFromString(config);
        this.init();
        someONS = this;
    }

    public synchronized void shutdown() {
        if (someONS == this) {
            someONS = null;
        }
        for (WeakReference<Closable> c : this.children) {
            Closable inner = (Closable)c.get();
            if (inner == null) continue;
            inner.close();
        }
    }

    @Override
    public void close() {
        this.shutdown();
    }

    @Deprecated
    public static ONS getRunningONS() {
        return someONS;
    }

    @Deprecated
    public void shutdown(long timeout) {
        this.shutdown();
    }

    public Subscriber createNewSubscriber(String s, String c) {
        return new Subscriber(this, s, c, this.config.getSocketTimeout());
    }

    public Subscriber createNewSubscriber(String s, String c, long timeout) {
        return new Subscriber(this, s, c, timeout);
    }

    public Publisher createNewPublisher(String c) {
        return new Publisher(this, c);
    }

    public int readLocalPort(String oracleinst) throws ONSException {
        return this.config.getLocalPort();
    }

    public int readRemotePort(String oracleinst) throws ONSException {
        return this.config.getRemotePort();
    }

    public int readRequestPort(String oracleinst) throws ONSException {
        return this.config.getRequestPort();
    }

    public static String readFormFactor(String path) throws ONSException {
        try {
            return ONSConfiguration.getFormFactor(path);
        }
        catch (IOException e) {
            throw new ConfigurationException("Error reading form factor file");
        }
    }

    public Object getNodeLists() {
        return null;
    }

    public Object getConnections() {
        return null;
    }

    public static void error(String message) {
        NotificationManager.getNotificationManager().logger.fine(message);
    }

    public static void debug(String message) {
        NotificationManager.getNotificationManager().logger.info(message);
    }

    public static void debugRaw(String message) {
        NotificationManager.getNotificationManager().logger.info(message);
    }

    public void printLists() {
    }

    public static Logger getLogger() {
        return NotificationManager.getNotificationManager().logger;
    }

    public RpcServer createRpcServer(String rpcServerName, String component, Map<String, String> addrProperties, CallBackMode cbMode) {
        return new RpcServerImpl(this, rpcServerName, component, addrProperties, cbMode);
    }

    @Deprecated
    public void setLogStream(PrintStream out, PrintStream err) {
    }

    static ONS getONS() throws ConfigurationException {
        return new ONS(ONSConfiguration.initDefaultConfig());
    }
}

