/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.jdbc.oracle.OracleLoadBalancingEvent;
import oracle.ucp.jdbc.oracle.RACInstance;
import oracle.ucp.jdbc.oracle.RACInstanceImpl;
import oracle.ucp.util.logging.UCPLoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ONSRuntimeLoadBalancingEvent
implements OracleLoadBalancingEvent {
    private static final Logger logger = UCPLoggerFactory.createLogger(ONSRuntimeLoadBalancingEvent.class.getCanonicalName());
    private static final String ONS_RCLB_EVENT_DELIMITER = "{} =";
    public static final int RLB_INSTANCE_GOOD = 1;
    public static final int RLB_INSTANCE_UNKNOWN = 2;
    public static final int RLB_INSTANCE_VIOLATING = 3;
    public static final int RLB_INSTANCE_NO_DATA = 4;
    public static final int RLB_INSTANCE_BLOCKED = 5;
    public static final int RLB_NUMBER_OF_HITS_PER_INSTANCE = 1000;
    private Set<RACInstance> m_racInstances = Collections.synchronizedSet(new HashSet());
    private byte[] m_eventBody = null;
    private final String m_serviceName;

    ONSRuntimeLoadBalancingEvent(String serviceName, byte[] eventBody) throws UniversalConnectionPoolException {
        logger.log(Level.FINEST, "serviceName: {0}, eventBody: {1}", new Object[]{serviceName, new String(eventBody)});
        this.m_serviceName = serviceName;
        this.m_eventBody = eventBody;
        StringTokenizer strTokens = null;
        String instNameKey = null;
        String dbUniqNameKey = null;
        int percent = 0;
        OracleLoadBalancingEvent.InstanceStatus flag = OracleLoadBalancingEvent.InstanceStatus.UNKNOWN;
        boolean updateNecessary = false;
        boolean isAffinityEnabledForThisInstance = false;
        try {
            strTokens = new StringTokenizer(new String(eventBody, "UTF-8"), ONS_RCLB_EVENT_DELIMITER, true);
        }
        catch (UnsupportedEncodingException e) {
            logger.log(Level.FINEST, "tokenizer encoding", e);
        }
        String st = null;
        String val = null;
        String key = null;
        while (strTokens.hasMoreTokens()) {
            val = null;
            st = strTokens.nextToken();
            if (st.equals("=") && strTokens.hasMoreTokens()) {
                val = strTokens.nextToken();
            } else {
                if (st.equals("}")) {
                    if (!updateNecessary) continue;
                    RACInstanceImpl racInstance = new RACInstanceImpl(this.m_serviceName, instNameKey, "", dbUniqNameKey);
                    racInstance.setPercent(percent);
                    racInstance.setStatus(flag);
                    racInstance.setAffinityHint(isAffinityEnabledForThisInstance);
                    this.m_racInstances.add(racInstance);
                    updateNecessary = false;
                    isAffinityEnabledForThisInstance = false;
                    continue;
                }
                if (st.equals("{") || st.equals(" ")) continue;
                key = st;
                updateNecessary = true;
            }
            if (key.equalsIgnoreCase("version") && val != null) {
                if (val.equals("1.0")) continue;
                logger.log(Level.FINE, "Invalid Event version {0}", val);
                break;
            }
            if (key.equalsIgnoreCase("database") && val != null) {
                dbUniqNameKey = val.trim().toLowerCase();
                continue;
            }
            if (key.equalsIgnoreCase("instance") && val != null) {
                instNameKey = val.trim().toLowerCase();
                continue;
            }
            if (key.equalsIgnoreCase("percent") && val != null) {
                try {
                    percent = Integer.parseInt(val);
                    if (percent != 0) continue;
                    percent = 1;
                }
                catch (NumberFormatException nfe) {
                    logger.log(Level.FINE, "parseInt", nfe);
                }
                continue;
            }
            if (key.equalsIgnoreCase("flag") && val != null) {
                if (val.equalsIgnoreCase("good")) {
                    flag = OracleLoadBalancingEvent.InstanceStatus.GOOD;
                    continue;
                }
                if (val.equalsIgnoreCase("violating")) {
                    flag = OracleLoadBalancingEvent.InstanceStatus.VIOLATING;
                    continue;
                }
                if (val.equalsIgnoreCase("NO_DATA")) {
                    flag = OracleLoadBalancingEvent.InstanceStatus.NO_DATA;
                    continue;
                }
                if (val.equalsIgnoreCase("UNKNOWN")) {
                    flag = OracleLoadBalancingEvent.InstanceStatus.UNKNOWN;
                    continue;
                }
                if (!val.equalsIgnoreCase("BLOCKED")) continue;
                flag = OracleLoadBalancingEvent.InstanceStatus.BLOCKED;
                continue;
            }
            if (!key.equalsIgnoreCase("aff") || val == null) continue;
            if (val.equalsIgnoreCase("true")) {
                isAffinityEnabledForThisInstance = true;
                continue;
            }
            isAffinityEnabledForThisInstance = false;
        }
    }

    @Override
    public Set<RACInstance> getRACInstances() {
        return this.m_racInstances;
    }

    @Override
    public byte[] getEventBody() {
        return this.m_eventBody;
    }
}

