/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki;

import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Set;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.cert.ext.BasicConstraintsExtension;
import oracle.security.crypto.cert.ext.KeyUsageExtension;
import oracle.security.crypto.core.MD5;
import oracle.security.crypto.core.RSAPublicKey;
import oracle.security.crypto.core.SHA;
import oracle.security.pki.OraclePKIDebug;
import oracle.security.pki.OraclePKIPrincipalImpl;
import oracle.security.pki.i;

public final class OraclePKIX509CertImpl
extends X509Certificate {
    private final X509 a;

    public OraclePKIX509CertImpl(X509 x509) {
        this.a = x509;
    }

    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        this.checkValidity(new Date());
    }

    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        if (this.a.getNotAfterDate().compareTo(date) < 0) {
            OraclePKIDebug.a("Certificate expired on " + this.a.getNotAfterDate());
            throw new CertificateExpiredException();
        }
        if (this.a.getNotBeforeDate().compareTo(date) > 0) {
            OraclePKIDebug.a("Certificate not valid until " + this.a.getNotBeforeDate());
            throw new CertificateNotYetValidException();
        }
    }

    public int getVersion() {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(this.a.getEncoded()));
            return x509Certificate.getVersion();
        }
        catch (Throwable throwable) {
            OraclePKIDebug.a("Java can't parse this cert");
            return 0;
        }
    }

    public BigInteger getSerialNumber() {
        return this.a.getSerialNo();
    }

    public Principal getIssuerDN() {
        return new OraclePKIPrincipalImpl(this.a.getIssuer());
    }

    public Principal getSubjectDN() {
        return new OraclePKIPrincipalImpl(this.a.getSubject());
    }

    public Date getNotBefore() {
        return this.a.getNotBeforeDate();
    }

    public Date getNotAfter() {
        return this.a.getNotAfterDate();
    }

    public byte[] getTBSCertificate() throws CertificateEncodingException {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(this.a.getEncoded()));
            return x509Certificate.getTBSCertificate();
        }
        catch (Throwable throwable) {
            throw new CertificateEncodingException();
        }
    }

    public byte[] getSignature() {
        try {
            return this.a.getSigBytes();
        }
        catch (oracle.security.crypto.core.SignatureException signatureException) {
            return null;
        }
    }

    public String getSigAlgName() {
        return this.a.getSigAlgString();
    }

    public String getSigAlgOID() {
        return this.a.getSigAlgOID().toString();
    }

    public byte[] getSigAlgParams() {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(this.a.getEncoded()));
            return x509Certificate.getSigAlgParams();
        }
        catch (Throwable throwable) {
            OraclePKIDebug.a("Java can't parse this cert");
            return null;
        }
    }

    public boolean[] getIssuerUniqueID() {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(this.a.getEncoded()));
            return x509Certificate.getIssuerUniqueID();
        }
        catch (Throwable throwable) {
            OraclePKIDebug.a("Java can't parse this cert");
            return null;
        }
    }

    public boolean[] getSubjectUniqueID() {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(this.a.getEncoded()));
            return x509Certificate.getSubjectUniqueID();
        }
        catch (Throwable throwable) {
            OraclePKIDebug.a("Java can't parse this cert");
            return null;
        }
    }

    public boolean[] getKeyUsage() {
        KeyUsageExtension keyUsageExtension = (KeyUsageExtension)this.a.getExtension(PKIX.id_ce_keyUsage);
        if (keyUsageExtension == null) {
            return null;
        }
        return new boolean[]{keyUsageExtension.hasUsageFlag(0), keyUsageExtension.hasUsageFlag(1), keyUsageExtension.hasUsageFlag(2), keyUsageExtension.hasUsageFlag(3), keyUsageExtension.hasUsageFlag(4), keyUsageExtension.hasUsageFlag(5), keyUsageExtension.hasUsageFlag(6), keyUsageExtension.hasUsageFlag(7), keyUsageExtension.hasUsageFlag(8)};
    }

    public int getBasicConstraints() {
        BasicConstraintsExtension basicConstraintsExtension = (BasicConstraintsExtension)this.a.getExtension(PKIX.id_ce_basicConstraints);
        if (basicConstraintsExtension == null) {
            return -1;
        }
        if (!basicConstraintsExtension.getCA()) {
            return -1;
        }
        BigInteger bigInteger = basicConstraintsExtension.getPathLen();
        if (bigInteger == null) {
            return Integer.MAX_VALUE;
        }
        return bigInteger.intValue();
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        return this.a.getEncoded();
    }

    public String getMD5Digest() throws CertificateEncodingException {
        byte[] byArray = this.getEncoded();
        MD5 mD5 = new MD5();
        byte[] byArray2 = mD5.computeDigest(byArray);
        return this.a(byArray2);
    }

    public String getSHADigest() throws CertificateEncodingException {
        byte[] byArray = this.getEncoded();
        SHA sHA = new SHA();
        byte[] byArray2 = sHA.computeDigest(byArray);
        return this.a(byArray2);
    }

    String a(byte[] byArray) {
        int n2 = 0;
        int n3 = 0;
        byte by = 0;
        n2 = byArray.length * 2 + (byArray.length - 1);
        byte[] byArray2 = new byte[n2];
        byte[] byArray3 = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
        for (n3 = 0; n3 < n2 - 2; n3 += 3) {
            by = byArray[n3 / 3];
            byArray2[n3] = byArray3[(by & 0xF0) >> 4];
            byArray2[n3 + 1] = byArray3[by & 0xF];
            byArray2[n3 + 2] = 58;
        }
        by = byArray[n2 / 3];
        n3 = n2 - 2;
        byArray2[n3] = byArray3[(by & 0xF0) >> 4];
        byArray2[n3 + 1] = byArray3[by & 0xF];
        return new String(byArray2);
    }

    public void verify(PublicKey publicKey) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        throw new CertificateException("Not implemented");
    }

    public void verify(PublicKey publicKey, String string) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        throw new CertificateException("Not implemented");
    }

    public String toString() {
        return this.a.toString();
    }

    public PublicKey getPublicKey() {
        oracle.security.crypto.core.PublicKey publicKey = this.a.getPublicKey();
        if (publicKey instanceof RSAPublicKey) {
            return new i((RSAPublicKey)publicKey);
        }
        return null;
    }

    public boolean hasUnsupportedCriticalExtension() {
        return this.a.getExtensionSet().hasUnrecognizedCriticalExtension();
    }

    public Set getCriticalExtensionOIDs() {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(this.a.getEncoded()));
            return x509Certificate.getCriticalExtensionOIDs();
        }
        catch (Throwable throwable) {
            OraclePKIDebug.a("Java can't parse this cert");
            return null;
        }
    }

    public Set getNonCriticalExtensionOIDs() {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(this.a.getEncoded()));
            return x509Certificate.getCriticalExtensionOIDs();
        }
        catch (Throwable throwable) {
            OraclePKIDebug.a("Java can't parse this cert");
            return null;
        }
    }

    public byte[] getExtensionValue(String string) {
        if (this.a.getExtension(new ASN1ObjectID(string)) == null) {
            return null;
        }
        return this.a.getExtension(new ASN1ObjectID(string)).getValue();
    }

    public X509 getX509() {
        return this.a;
    }
}

