/*
 * Decompiled with CFR 0.152.
 */
package com.plumelog.log4j2.appender;

import com.plumelog.core.MessageAppenderFactory;
import com.plumelog.core.client.AbstractClient;
import com.plumelog.core.constant.LogMessageConstant;
import com.plumelog.core.dto.BaseLogMessage;
import com.plumelog.core.dto.RunLogMessage;
import com.plumelog.core.redis.RedisClient;
import com.plumelog.core.redis.RedisSentinelClient;
import com.plumelog.core.util.GfJsonUtil;
import com.plumelog.core.util.StringUtils;
import com.plumelog.core.util.ThreadPoolUtil;
import com.plumelog.log4j2.util.LogMessageUtil;
import java.io.Serializable;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;

@Plugin(name="RedisAppender", category="Core", elementType="appender", printObject=true)
public class RedisAppender
extends AbstractAppender {
    private static AbstractClient redisClient;
    private static final ThreadPoolExecutor threadPoolExecutor;
    private final String appName;
    private final String env;
    private final String redisHost;
    private final String redisPort;
    private final String redisAuth;
    private final String runModel;
    private final String expand;
    private int redisDb = 0;
    private int maxCount = 500;
    private int logQueueSize = 10000;
    private int threadPoolSize = 5;
    private boolean compressor = false;
    private String model = "standalone";
    private final String masterName;

    protected RedisAppender(String name, String appName, String env, String redisHost, String redisPort, String redisAuth, String runModel, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions, String expand, int maxCount, int logQueueSize, int redisDb, int threadPoolSize, boolean compressor, String model, String masterName) {
        super(name, filter, layout, ignoreExceptions);
        this.appName = appName;
        this.env = env;
        this.redisHost = redisHost;
        this.redisPort = redisPort;
        this.redisAuth = redisAuth;
        this.runModel = runModel;
        this.expand = expand;
        this.maxCount = maxCount;
        this.logQueueSize = logQueueSize;
        this.redisDb = redisDb;
        this.threadPoolSize = threadPoolSize;
        this.compressor = compressor;
        this.model = model;
        this.masterName = masterName;
    }

    @PluginFactory
    public static RedisAppender createAppender(@PluginAttribute(value="name") String name, @PluginAttribute(value="appName") String appName, @PluginAttribute(value="env") String env, @PluginAttribute(value="redisHost") String redisHost, @PluginAttribute(value="redisPort") String redisPort, @PluginAttribute(value="redisAuth") String redisAuth, @PluginAttribute(value="maxCount") int maxCount, @PluginAttribute(value="runModel") String runModel, @PluginAttribute(value="expand") String expand, @PluginAttribute(value="redisDb") int redisDb, @PluginAttribute(value="logQueueSize") int logQueueSize, @PluginAttribute(value="threadPoolSize") int threadPoolSize, @PluginAttribute(value="compressor") boolean compressor, @PluginAttribute(value="model") String model, @PluginAttribute(value="masterName") String masterName, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginElement(value="Filter") Filter filter) {
        if (env == null) {
            env = "default";
        }
        if (runModel != null) {
            LogMessageConstant.RUN_MODEL = Integer.parseInt(runModel);
        }
        if (expand != null && LogMessageConstant.EXPANDS.contains(expand)) {
            LogMessageConstant.EXPAND = expand;
        }
        if (model == null) {
            model = "standalone";
        }
        if (StringUtils.isNotEmpty((String)masterName)) {
            redisClient = RedisSentinelClient.getInstance((String)redisHost, (String)masterName, (String)redisAuth, (int)redisDb);
        } else {
            int port = 6379;
            String ip = "127.0.0.1";
            if (redisPort == null) {
                if (redisHost.contains(":")) {
                    String[] hs = redisHost.split(":");
                    if (hs.length == 2) {
                        ip = hs[0];
                        port = Integer.parseInt(hs[1]);
                    }
                } else {
                    ip = redisHost;
                }
            } else {
                ip = redisHost;
                port = Integer.parseInt(redisPort);
            }
            redisClient = RedisClient.getInstance((String)ip, (int)port, (String)redisAuth, (int)redisDb);
        }
        if (maxCount == 0) {
            maxCount = 100;
        }
        if (logQueueSize == 0) {
            logQueueSize = 10000;
        }
        if (threadPoolSize == 0) {
            threadPoolSize = 1;
        }
        int count = maxCount;
        MessageAppenderFactory.initQueue((int)logQueueSize);
        for (int a = 0; a < threadPoolSize; ++a) {
            threadPoolExecutor.execute(() -> MessageAppenderFactory.startRunLog((AbstractClient)redisClient, (int)count, (String)(compressor ? "plume_log_list_compress" : "plume_log_list"), (boolean)compressor));
            threadPoolExecutor.execute(() -> MessageAppenderFactory.startTraceLog((AbstractClient)redisClient, (int)count, (String)(compressor ? "plume_trace_list_compress" : "plume_trace_list"), (boolean)compressor));
        }
        return new RedisAppender(name, appName, env, redisHost, redisPort, redisAuth, runModel, filter, layout, true, expand, maxCount, logQueueSize, redisDb, threadPoolSize, compressor, model, masterName);
    }

    public void append(LogEvent logEvent) {
        if (logEvent != null) {
            this.send(logEvent);
        }
    }

    protected void send(LogEvent logEvent) {
        BaseLogMessage logMessage = LogMessageUtil.getLogMessage(this.appName, this.env, logEvent, this.runModel);
        if (logMessage instanceof RunLogMessage) {
            String message = LogMessageUtil.getLogMessage((RunLogMessage)logMessage, logEvent);
            MessageAppenderFactory.pushRundataQueue((String)message);
        } else {
            MessageAppenderFactory.pushTracedataQueue((String)GfJsonUtil.toJSONString((Object)logMessage));
        }
    }

    public String getAppName() {
        return this.appName;
    }

    public String getModel() {
        return this.model;
    }

    public String getRunModel() {
        return this.runModel;
    }

    public String getMasterName() {
        return this.masterName;
    }

    public String getRedisHost() {
        return this.redisHost;
    }

    public String getRedisPort() {
        return this.redisPort;
    }

    public int getRedisDb() {
        return this.redisDb;
    }

    public String getRedisAuth() {
        return this.redisAuth;
    }

    public String getExpand() {
        return this.expand;
    }

    public String getEnv() {
        return this.env;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public int getLogQueueSize() {
        return this.logQueueSize;
    }

    public boolean isCompressor() {
        return this.compressor;
    }

    static {
        threadPoolExecutor = ThreadPoolUtil.getPool();
    }
}

