/*
 * Decompiled with CFR 0.152.
 */
package com.plumelog.log4j2.util;

import com.plumelog.core.LogMessageThreadLocal;
import com.plumelog.core.TraceId;
import com.plumelog.core.TraceMessage;
import com.plumelog.core.dto.BaseLogMessage;
import com.plumelog.core.dto.RunLogMessage;
import com.plumelog.core.util.DateUtil;
import com.plumelog.core.util.GfJsonUtil;
import com.plumelog.core.util.LogExceptionStackTrace;
import com.plumelog.core.util.StringUtils;
import com.plumelog.core.util.TraceLogMessageFactory;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.message.ParameterizedMessageFactory;

public class LogMessageUtil {
    private static final AtomicLong SEQ_BUILDER = new AtomicLong();

    private static String isExpandRunLog(LogEvent logEvent) {
        String traceId = null;
        if (!logEvent.getContextData().isEmpty() && (traceId = (String)logEvent.getContextData().toMap().get("traceId")) != null) {
            TraceId.logTraceID.set((Object)traceId);
        }
        return traceId;
    }

    public static String getLogMessage(RunLogMessage runLogMessage, LogEvent logEvent) {
        Map mdc = logEvent.getContextData().toMap();
        Map map = StringUtils.entityToMap((Object)runLogMessage);
        if (mdc != null) {
            map.putAll(mdc);
        }
        return GfJsonUtil.toJSONString((Object)map);
    }

    public static BaseLogMessage getLogMessage(String appName, String env, LogEvent logEvent, String runModel) {
        LogMessageUtil.isExpandRunLog(logEvent);
        TraceMessage traceMessage = (TraceMessage)LogMessageThreadLocal.logMessageThreadLocal.get();
        String formattedMessage = LogMessageUtil.getMessage(logEvent);
        if (formattedMessage.startsWith("TRACE:")) {
            return TraceLogMessageFactory.getTraceLogMessage((TraceMessage)traceMessage, (String)appName, (String)env, (long)logEvent.getTimeMillis());
        }
        RunLogMessage logMessage = TraceLogMessageFactory.getLogMessage((String)appName, (String)env, (String)formattedMessage, (long)logEvent.getTimeMillis());
        logMessage.setClassName(logEvent.getLoggerName());
        logMessage.setThreadName(logEvent.getThreadName());
        logMessage.setSeq(Long.valueOf(SEQ_BUILDER.getAndIncrement()));
        StackTraceElement stackTraceElement = null;
        if ("2".equals(runModel)) {
            stackTraceElement = logEvent.getSource();
        }
        if (stackTraceElement != null) {
            String method = stackTraceElement.getMethodName();
            String line = String.valueOf(stackTraceElement.getLineNumber());
            logMessage.setMethod(method + "(" + stackTraceElement.getFileName() + ":" + line + ")");
        } else {
            logMessage.setMethod(logEvent.getThreadName());
        }
        logMessage.setDateTime(DateUtil.getDatetimeNormalStrWithMills((long)logEvent.getTimeMillis()));
        logMessage.setLogLevel(logEvent.getLevel().toString());
        return logMessage;
    }

    private static String getMessage(LogEvent logEvent) {
        if (logEvent.getLevel().equals((Object)Level.ERROR)) {
            Throwable thrown = logEvent.getThrown();
            String formatMessage = logEvent.getMessage().getFormat();
            Object[] args = logEvent.getMessage().getParameters();
            if (args != null) {
                int l = args.length;
                for (int i = 0; i < l; ++i) {
                    if (i == l - 1 && args[i] == thrown || !(args[i] instanceof Throwable)) continue;
                    args[i] = LogExceptionStackTrace.erroStackTrace((Object)args[i]);
                }
                formatMessage = LogMessageUtil.packageMessage(formatMessage, args);
            }
            if (thrown != null) {
                return LogMessageUtil.packageMessage(formatMessage, new String[]{LogExceptionStackTrace.erroStackTrace((Object)thrown).toString()});
            }
            return formatMessage;
        }
        return logEvent.getMessage().getFormattedMessage();
    }

    private static String packageMessage(String message, Object[] args) {
        if (message != null && message.contains("{}")) {
            return ParameterizedMessageFactory.INSTANCE.newMessage(message, args).getFormattedMessage();
        }
        return TraceLogMessageFactory.packageMessage((String)message, (Object[])args);
    }
}

