/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.modules.base.types;

import com.rometools.modules.base.io.GoogleBaseParser;
import com.rometools.modules.base.types.CloneableType;

public class IntUnit
implements CloneableType {
    private String units;
    private final int value;

    private boolean inCharArray(char find, char[] array) {
        for (char element : array) {
            if (find != element) continue;
            return true;
        }
        return false;
    }

    public IntUnit(String source) {
        String parse = source.trim();
        int space = -1;
        for (int i = 0; i < parse.length(); ++i) {
            if (this.inCharArray(parse.charAt(i), GoogleBaseParser.INTEGER_CHARS)) continue;
            space = i;
            break;
        }
        if (space == -1) {
            space = parse.length();
        }
        this.value = Integer.parseInt(GoogleBaseParser.stripNonValidCharacters(GoogleBaseParser.INTEGER_CHARS, parse.substring(0, space)));
        if (space != parse.length()) {
            this.units = parse.substring(space, parse.length()).trim();
        }
    }

    public IntUnit(int value, String units) {
        this.value = value;
        this.units = units;
    }

    public String getUnits() {
        return this.units;
    }

    public int getValue() {
        return this.value;
    }

    @Override
    public Object clone() {
        return new IntUnit(this.value, this.units);
    }

    public String toString() {
        if (this.units != null && this.units.trim().length() > 0) {
            return this.value + " " + this.units;
        }
        return Integer.toString(this.value);
    }

    public boolean equals(Object o) {
        if (!(o instanceof IntUnit)) {
            return false;
        }
        IntUnit f = (IntUnit)o;
        if (f.getValue() != this.value) {
            return false;
        }
        return this.units == f.getUnits() || this.units != null && this.units.equals(f.getUnits());
    }
}

