/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.modules.georss;

import com.rometools.modules.georss.GeoRSSModule;
import com.rometools.modules.georss.geometries.AbstractGeometry;
import com.rometools.modules.georss.geometries.AbstractRing;
import com.rometools.modules.georss.geometries.Envelope;
import com.rometools.modules.georss.geometries.LineString;
import com.rometools.modules.georss.geometries.LinearRing;
import com.rometools.modules.georss.geometries.Point;
import com.rometools.modules.georss.geometries.Polygon;
import com.rometools.modules.georss.geometries.Position;
import com.rometools.modules.georss.geometries.PositionList;
import com.rometools.rome.feed.module.Module;
import com.rometools.rome.io.ModuleGenerator;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleGenerator
implements ModuleGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleGenerator.class);
    private static final Set<Namespace> NAMESPACES;

    private String posListToString(PositionList posList) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < posList.size(); ++i) {
            sb.append(posList.getLatitude(i)).append(" ").append(posList.getLongitude(i)).append(" ");
        }
        return sb.toString();
    }

    public String getNamespaceUri() {
        return "http://www.georss.org/georss";
    }

    public Set<Namespace> getNamespaces() {
        return NAMESPACES;
    }

    public void generate(Module module, Element element) {
        Element root = element;
        while (root.getParent() != null && root.getParent() instanceof Element) {
            root = (Element)element.getParent();
        }
        root.addNamespaceDeclaration(GeoRSSModule.SIMPLE_NS);
        GeoRSSModule geoRSSModule = (GeoRSSModule)module;
        AbstractGeometry geometry = geoRSSModule.getGeometry();
        if (geometry instanceof Point) {
            Position pos = ((Point)geometry).getPosition();
            Element pointElement = new Element("point", GeoRSSModule.SIMPLE_NS);
            pointElement.addContent(pos.getLatitude() + " " + pos.getLongitude());
            element.addContent((Content)pointElement);
        } else if (geometry instanceof LineString) {
            PositionList posList = ((LineString)geometry).getPositionList();
            Element lineElement = new Element("line", GeoRSSModule.SIMPLE_NS);
            lineElement.addContent(this.posListToString(posList));
            element.addContent((Content)lineElement);
        } else if (geometry instanceof Polygon) {
            AbstractRing ring = ((Polygon)geometry).getExterior();
            if (ring instanceof LinearRing) {
                PositionList posList = ((LinearRing)ring).getPositionList();
                Element polygonElement = new Element("polygon", GeoRSSModule.SIMPLE_NS);
                polygonElement.addContent(this.posListToString(posList));
                element.addContent((Content)polygonElement);
            } else {
                LOG.error("GeoRSS simple format can't handle rings of type: " + ring.getClass().getName());
            }
            if (((Polygon)geometry).getInterior() != null && !((Polygon)geometry).getInterior().isEmpty()) {
                LOG.error("GeoRSS simple format can't handle interior rings (ignored)");
            }
        } else if (geometry instanceof Envelope) {
            Envelope envelope = (Envelope)geometry;
            Element boxElement = new Element("box", GeoRSSModule.SIMPLE_NS);
            boxElement.addContent(envelope.getMinLatitude() + " " + envelope.getMinLongitude() + " " + envelope.getMaxLatitude() + " " + envelope.getMaxLongitude());
            element.addContent((Content)boxElement);
        } else {
            LOG.error("GeoRSS simple format can't handle geometries of type: " + geometry.getClass().getName());
        }
        if (geoRSSModule.getFeatureNameTag() != null) {
            Element featureNameElement = new Element("featurename", GeoRSSModule.SIMPLE_NS);
            featureNameElement.addContent(geoRSSModule.getFeatureNameTag());
            element.addContent((Content)featureNameElement);
        }
    }

    static {
        HashSet<Namespace> nss = new HashSet<Namespace>();
        nss.add(GeoRSSModule.SIMPLE_NS);
        NAMESPACES = Collections.unmodifiableSet(nss);
    }
}

