/*
 * Decompiled with CFR 0.152.
 */
package com.rometools.modules.sle.io;

import com.rometools.modules.sle.SimpleListExtension;
import com.rometools.modules.sle.SimpleListExtensionImpl;
import com.rometools.modules.sle.types.Group;
import com.rometools.modules.sle.types.Sort;
import com.rometools.rome.feed.module.Module;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleParser
implements com.rometools.rome.io.ModuleParser {
    private static final Logger LOG = LoggerFactory.getLogger(ModuleParser.class);
    static final Namespace NS = Namespace.getNamespace((String)"cf", (String)"http://www.microsoft.com/schemas/rss/core/2005");
    public static final Namespace TEMP = Namespace.getNamespace((String)"rome-sle", (String)"urn:rome:sle");

    public String getNamespaceUri() {
        return "http://www.microsoft.com/schemas/rss/core/2005";
    }

    public Module parse(Element element, Locale locale) {
        String label;
        String elementName;
        Namespace ns;
        if (element.getChild("treatAs", NS) == null) {
            return null;
        }
        SimpleListExtensionImpl sle = new SimpleListExtensionImpl();
        sle.setTreatAs(element.getChildText("treatAs", NS));
        Element listInfo = element.getChild("listinfo", NS);
        ArrayList<Cloneable> values = new ArrayList<Cloneable>();
        for (Element ge : listInfo.getChildren("group", NS)) {
            ns = ge.getAttribute("ns") == null ? element.getNamespace() : Namespace.getNamespace((String)ge.getAttributeValue("ns"));
            elementName = ge.getAttributeValue("element");
            label = ge.getAttributeValue("label");
            values.add(new Group(ns, elementName, label));
        }
        sle.setGroupFields(values.toArray(new Group[values.size()]));
        values = values.size() == 0 ? values : new ArrayList<Cloneable>();
        for (Element se : listInfo.getChildren("sort", NS)) {
            LOG.debug("Parse cf:sort {}{}", (Object)se.getAttributeValue("element"), (Object)se.getAttributeValue("data-type"));
            ns = se.getAttributeValue("ns") == null ? element.getNamespace() : Namespace.getNamespace((String)se.getAttributeValue("ns"));
            elementName = se.getAttributeValue("element");
            label = se.getAttributeValue("label");
            String dataType = se.getAttributeValue("data-type");
            boolean defaultOrder = se.getAttributeValue("default") == null ? false : new Boolean(se.getAttributeValue("default"));
            values.add(new Sort(ns, elementName, dataType, label, defaultOrder));
        }
        sle.setSortFields(values.toArray(new Sort[values.size()]));
        this.insertValues(sle, element.getChildren());
        return sle;
    }

    protected void addNotNullAttribute(Element target, String name, Object value) {
        if (target == null || value == null) {
            return;
        }
        target.setAttribute(name, value.toString());
    }

    public void insertValues(SimpleListExtension sle, List<Element> elements) {
        for (int i = 0; elements != null && i < elements.size(); ++i) {
            Sort[] sorts;
            Group[] groups;
            Element e = elements.get(i);
            for (Group group2 : groups = sle.getGroupFields()) {
                Element value = e.getChild(group2.getElement(), group2.getNamespace());
                if (value == null) continue;
                Element group = new Element("group", TEMP);
                this.addNotNullAttribute(group, "element", group2.getElement());
                this.addNotNullAttribute(group, "label", group2.getLabel());
                this.addNotNullAttribute(group, "value", value.getText());
                this.addNotNullAttribute(group, "ns", group2.getNamespace().getURI());
                e.addContent((Content)group);
            }
            for (Sort sort2 : sorts = sle.getSortFields()) {
                LOG.debug("Inserting for {} {}", (Object)sort2.getElement(), (Object)sort2.getDataType());
                Element sort = new Element("sort", TEMP);
                if (sort2.getDefaultOrder()) {
                    sort.setAttribute("label", sort2.getLabel());
                    sort.setAttribute("value", Integer.toString(i));
                    sort.setAttribute("data-type", "number");
                    e.addContent((Content)sort);
                    continue;
                }
                Element value = e.getChild(sort2.getElement(), sort2.getNamespace());
                if (value == null) {
                    LOG.debug("No value for {} : {}", (Object)sort2.getElement(), (Object)sort2.getNamespace());
                } else {
                    LOG.debug("{} value: {}", (Object)sort2.getElement(), (Object)value.getText());
                }
                if (value == null) continue;
                this.addNotNullAttribute(sort, "label", sort2.getLabel());
                this.addNotNullAttribute(sort, "element", sort2.getElement());
                this.addNotNullAttribute(sort, "value", value.getText());
                this.addNotNullAttribute(sort, "data-type", sort2.getDataType());
                this.addNotNullAttribute(sort, "ns", sort2.getNamespace().getURI());
                e.addContent((Content)sort);
                LOG.debug("Added {} {} = {}", new Object[]{sort, sort2.getLabel(), value.getText()});
            }
        }
    }
}

