/*
 * Decompiled with CFR 0.152.
 */
package org.sagacity.sqltoy.configure;

import java.util.ArrayList;
import org.sagacity.sqltoy.SqlToyContext;
import org.sagacity.sqltoy.config.model.ElasticEndpoint;
import org.sagacity.sqltoy.configure.Elastic;
import org.sagacity.sqltoy.configure.ElasticConfig;
import org.sagacity.sqltoy.configure.SqlToyContextProperties;
import org.sagacity.sqltoy.dao.SqlToyLazyDao;
import org.sagacity.sqltoy.dao.impl.SqlToyLazyDaoImpl;
import org.sagacity.sqltoy.plugins.IUnifyFieldsHandler;
import org.sagacity.sqltoy.plugins.TypeHandler;
import org.sagacity.sqltoy.plugins.datasource.ConnectionFactory;
import org.sagacity.sqltoy.plugins.datasource.DataSourceSelector;
import org.sagacity.sqltoy.service.SqlToyCRUDService;
import org.sagacity.sqltoy.service.impl.SqlToyCRUDServiceImpl;
import org.sagacity.sqltoy.translate.cache.TranslateCacheManager;
import org.sagacity.sqltoy.utils.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={SqlToyContextProperties.class})
public class SqltoyAutoConfiguration {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private SqlToyContextProperties properties;
    @Value(value="${sqltoy.sqlResourcesDir:}")
    private String sqlResourcesDir;

    @Bean(name={"sqlToyContext"}, initMethod="initialize", destroyMethod="destroy")
    @ConditionalOnMissingBean
    SqlToyContext sqlToyContext() throws Exception {
        String connectionFactory;
        String dataSourceSelector;
        String typeHandler;
        String translateCacheManager;
        Elastic es;
        if (StringUtil.isBlank((Object)this.properties.getSqlResourcesDir()) && StringUtil.isNotBlank((Object)this.sqlResourcesDir)) {
            throw new IllegalArgumentException("\u8bf7\u68c0\u67e5sqltoy\u914d\u7f6e,\u662fspring.sqltoy\u4f5c\u4e3a\u524d\u7f00,\u800c\u4e0d\u662fsqltoy!\n\u6b63\u786e\u8303\u4f8b: spring.sqltoy.sqlResourcesDir=classpath:com/sagframe/modules");
        }
        SqlToyContext sqlToyContext = new SqlToyContext();
        sqlToyContext.setBreakWhenSqlRepeat(this.properties.isBreakWhenSqlRepeat());
        sqlToyContext.setSqlResourcesDir(this.properties.getSqlResourcesDir());
        if (this.properties.getSqlResources() != null && this.properties.getSqlResources().length > 0) {
            ArrayList<String> resList = new ArrayList<String>();
            for (String prop : this.properties.getSqlResources()) {
                resList.add(prop);
            }
            sqlToyContext.setSqlResources(resList);
        }
        if (this.properties.getEncoding() != null) {
            sqlToyContext.setEncoding(this.properties.getEncoding());
        }
        if (this.properties.getPackagesToScan() != null) {
            sqlToyContext.setPackagesToScan(this.properties.getPackagesToScan());
        }
        if (this.properties.getAnnotatedClasses() != null) {
            sqlToyContext.setAnnotatedClasses(this.properties.getAnnotatedClasses());
        }
        if (this.properties.getBatchSize() != null) {
            sqlToyContext.setBatchSize(this.properties.getBatchSize().intValue());
        }
        if (this.properties.getFetchSize() > 0) {
            sqlToyContext.setFetchSize(this.properties.getFetchSize());
        }
        if (this.properties.getPageFetchSizeLimit() != null) {
            sqlToyContext.setPageFetchSizeLimit(this.properties.getPageFetchSizeLimit().intValue());
        }
        if (this.properties.getScriptCheckIntervalSeconds() != null) {
            sqlToyContext.setScriptCheckIntervalSeconds(this.properties.getScriptCheckIntervalSeconds().intValue());
        }
        if (this.properties.getDelayCheckSeconds() != null) {
            sqlToyContext.setDelayCheckSeconds(this.properties.getDelayCheckSeconds().intValue());
        }
        if (this.properties.getDebug() != null) {
            sqlToyContext.setDebug(this.properties.getDebug().booleanValue());
        }
        if (this.properties.getPrintSqlTimeoutMillis() != null) {
            sqlToyContext.setPrintSqlTimeoutMillis(this.properties.getPrintSqlTimeoutMillis().intValue());
        }
        if (this.properties.getFunctionConverts() != null) {
            sqlToyContext.setFunctionConverts(this.properties.getFunctionConverts());
        }
        if (this.properties.getTranslateConfig() != null) {
            sqlToyContext.setTranslateConfig(this.properties.getTranslateConfig());
        }
        if (this.properties.getReservedWords() != null) {
            sqlToyContext.setReservedWords(this.properties.getReservedWords());
        }
        sqlToyContext.setPageOverToFirst(this.properties.isPageOverToFirst());
        sqlToyContext.setDialect(this.properties.getDialect());
        sqlToyContext.setDialectConfig(this.properties.getDialectConfig());
        sqlToyContext.setCacheType(this.properties.getCacheType());
        String unfiyHandler = this.properties.getUnifyFieldsHandler();
        if (StringUtil.isNotBlank((Object)unfiyHandler)) {
            try {
                IUnifyFieldsHandler handler = null;
                if (unfiyHandler.contains(".")) {
                    handler = (IUnifyFieldsHandler)Class.forName(unfiyHandler).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                } else if (this.applicationContext.containsBean(unfiyHandler) && (handler = (IUnifyFieldsHandler)this.applicationContext.getBean(unfiyHandler)) == null) {
                    throw new ClassNotFoundException("\u9879\u76ee\u4e2d\u672a\u5b9a\u4e49unifyFieldsHandler=" + unfiyHandler + " \u5bf9\u5e94\u7684bean!");
                }
                if (handler != null) {
                    sqlToyContext.setUnifyFieldsHandler(handler);
                }
            }
            catch (ClassNotFoundException cne) {
                System.err.println("------------------- \u9519\u8bef\u63d0\u793a ------------------------------------------- ");
                System.err.println("spring.sqltoy.unifyFieldsHandler=" + unfiyHandler + " \u5bf9\u5e94\u7c7b\u4e0d\u5b58\u5728,\u9519\u8bef\u539f\u56e0:");
                System.err.println("--1.\u60a8\u53ef\u80fd\u76f4\u63a5copy\u4e86\u53c2\u7167\u9879\u76ee\u7684\u914d\u7f6e\u6587\u4ef6,\u4f46\u6ca1\u6709\u5c06\u5177\u4f53\u7684\u7c7b\u4e5f\u540c\u6b65copy\u8fc7\u6765!");
                System.err.println("--2.\u5982\u60a8\u5e76\u4e0d\u9700\u8981\u6b64\u529f\u80fd\uff0c\u8bf7\u5c06\u914d\u7f6e\u6587\u4ef6\u4e2d\u6ce8\u91ca\u6389spring.sqltoy.unifyFieldsHandler");
                System.err.println("------------------------------------------------");
                cne.printStackTrace();
                throw cne;
            }
        }
        if ((es = this.properties.getElastic()) != null && es.getEndpoints() != null && !es.getEndpoints().isEmpty()) {
            sqlToyContext.setDefaultElastic(es.getDefaultId());
            ArrayList<ElasticEndpoint> endpoints = new ArrayList<ElasticEndpoint>();
            for (ElasticConfig esconfig : es.getEndpoints()) {
                ElasticEndpoint ep = new ElasticEndpoint(esconfig.getUrl(), esconfig.getSqlPath());
                ep.setId(esconfig.getId());
                if (esconfig.getCharset() != null) {
                    ep.setCharset(esconfig.getCharset());
                }
                if (esconfig.getRequestTimeout() != null) {
                    ep.setRequestTimeout(esconfig.getRequestTimeout().intValue());
                }
                if (esconfig.getConnectTimeout() != null) {
                    ep.setConnectTimeout(esconfig.getConnectTimeout().intValue());
                }
                if (esconfig.getSocketTimeout() != null) {
                    ep.setSocketTimeout(esconfig.getSocketTimeout().intValue());
                }
                ep.setAuthCaching(esconfig.isAuthCaching());
                ep.setUsername(esconfig.getUsername());
                ep.setPassword(esconfig.getPassword());
                ep.setKeyStore(esconfig.getKeyStore());
                ep.setKeyStorePass(esconfig.getKeyStorePass());
                ep.setKeyStoreSelfSign(esconfig.isKeyStoreSelfSign());
                ep.setKeyStoreType(esconfig.getKeyStoreType());
                endpoints.add(ep);
            }
            sqlToyContext.setElasticEndpoints(endpoints);
        }
        if (this.properties.getDefaultDataSource() != null) {
            sqlToyContext.setDefaultDataSourceName(this.properties.getDefaultDataSource());
        }
        if (StringUtil.isNotBlank((Object)(translateCacheManager = this.properties.getTranslateCacheManager()))) {
            if (this.applicationContext.containsBean(translateCacheManager)) {
                sqlToyContext.setTranslateCacheManager((TranslateCacheManager)this.applicationContext.getBean(translateCacheManager));
            } else if (translateCacheManager.contains(".")) {
                sqlToyContext.setTranslateCacheManager((TranslateCacheManager)Class.forName(translateCacheManager).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
        }
        if (StringUtil.isNotBlank((Object)(typeHandler = this.properties.getTypeHandler()))) {
            if (this.applicationContext.containsBean(typeHandler)) {
                sqlToyContext.setTypeHandler((TypeHandler)this.applicationContext.getBean(typeHandler));
            } else if (typeHandler.contains(".")) {
                sqlToyContext.setTypeHandler((TypeHandler)Class.forName(typeHandler).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
        }
        if (StringUtil.isNotBlank((Object)(dataSourceSelector = this.properties.getDataSourceSelector()))) {
            if (this.applicationContext.containsBean(dataSourceSelector)) {
                sqlToyContext.setDataSourceSelector((DataSourceSelector)this.applicationContext.getBean(dataSourceSelector));
            } else if (dataSourceSelector.contains(".")) {
                sqlToyContext.setDataSourceSelector((DataSourceSelector)Class.forName(dataSourceSelector).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
        }
        if (StringUtil.isNotBlank((Object)(connectionFactory = this.properties.getConnectionFactory()))) {
            if (this.applicationContext.containsBean(connectionFactory)) {
                sqlToyContext.setConnectionFactory((ConnectionFactory)this.applicationContext.getBean(connectionFactory));
            } else if (connectionFactory.contains(".")) {
                sqlToyContext.setConnectionFactory((ConnectionFactory)Class.forName(connectionFactory).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
        }
        return sqlToyContext;
    }

    @Bean(name={"sqlToyLazyDao"})
    @ConditionalOnMissingBean
    SqlToyLazyDao sqlToyLazyDao() {
        return new SqlToyLazyDaoImpl();
    }

    @Bean(name={"sqlToyCRUDService"})
    @ConditionalOnMissingBean
    SqlToyCRUDService sqlToyCRUDService() {
        return new SqlToyCRUDServiceImpl();
    }
}

