/*
 * Decompiled with CFR 0.152.
 */
package com.meituan.sdk.internal.http;

import com.meituan.sdk.internal.enums.SdkError;
import com.meituan.sdk.internal.exceptions.MtSdkException;
import com.meituan.sdk.internal.http.HttpClient;
import com.meituan.sdk.internal.http.HttpConfig;
import com.meituan.sdk.internal.utils.JsonUtil;
import com.meituan.sdk.internal.utils.StringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Objects;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttpClient
implements HttpClient {
    private static final String POST = "POST";
    private static final String HTTPS = "https";
    private static SSLContext ctx = null;
    private static HostnameVerifier verifier;
    private static final boolean needSSLCheck = true;
    private static final Logger logger;

    @Override
    public String postWithUrlEncoded(String url, Map<String, String> requestParams, Map<String, String> headers, HttpConfig httpConfig) throws MtSdkException {
        String charset = requestParams.get("charset");
        String ctype = "application/x-www-form-urlencoded;charset=" + charset;
        byte[] content = DefaultHttpClient.buildQuery(requestParams, charset);
        return DefaultHttpClient.doPost(url, ctype, content, headers, httpConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String doPost(String url, String ctype, byte[] content, Map<String, String> headerMap, HttpConfig httpConfig) throws MtSdkException {
        String resp;
        HttpURLConnection conn = null;
        OutputStream out = null;
        try {
            try {
                conn = DefaultHttpClient.getConnection(new URL(url), ctype, headerMap);
                conn.setConnectTimeout(httpConfig.getConnectTimeout());
                conn.setReadTimeout(httpConfig.getReadTimeout());
                out = conn.getOutputStream();
                out.write(content);
                if (200 != conn.getResponseCode()) {
                    logger.error("\u8bf7\u6c42\u8fd4\u56de\u72b6\u6001\u7801\u5f02\u5e38\uff0curl:{}, connectTimeout:{}, readTimeout:{}, headerMap:{}, resPonseCode:{}", new Object[]{url, httpConfig.getConnectTimeout(), httpConfig.getReadTimeout(), JsonUtil.toJson(headerMap), conn.getResponseCode()});
                    throw new MtSdkException(SdkError.HTTPCLIENT_ERROR.getCode(), "\u8bf7\u6c42\u8fd4\u56de\u72b6\u6001\u7801\u5f02\u5e38,ResponseCode:" + conn.getResponseCode());
                }
                resp = DefaultHttpClient.getResponseAsString(conn);
            }
            finally {
                if (out != null) {
                    out.close();
                }
                if (conn != null) {
                    conn.disconnect();
                }
            }
        }
        catch (IOException e) {
            logger.error("\u6267\u884cpost\u8bf7\u6c42\u65f6\u53d1\u751f\u5f02\u5e38\uff0curl:{}, connectTimeout:{}, readTimeout:{}, headerMap:{}", new Object[]{url, httpConfig.getConnectTimeout(), httpConfig.getReadTimeout(), JsonUtil.toJson(headerMap), e});
            throw new MtSdkException(SdkError.HTTPCLIENT_ERROR, (Throwable)e);
        }
        return resp;
    }

    private static String getResponseAsString(HttpURLConnection conn) throws IOException {
        String charset = DefaultHttpClient.getResponseCharset(conn.getContentType());
        InputStream es = conn.getErrorStream();
        if (es == null) {
            return DefaultHttpClient.getStreamAsString(conn.getInputStream(), charset);
        }
        String msg = DefaultHttpClient.getStreamAsString(es, charset);
        if (StringUtil.isEmpty(msg)) {
            throw new IOException(conn.getResponseCode() + ":" + conn.getResponseMessage());
        }
        throw new IOException(msg);
    }

    private static byte[] buildQuery(Map<String, String> params, String charset) throws MtSdkException {
        if (params == null || params.isEmpty() || StringUtil.isEmpty(charset)) {
            return null;
        }
        StringBuilder query = new StringBuilder();
        boolean flag = false;
        try {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                String value;
                String name = entry.getKey();
                if (!StringUtil.areNotEmpty(name, value = entry.getValue())) continue;
                if (flag) {
                    query.append("&");
                } else {
                    flag = true;
                }
                query.append(name).append("=").append(URLEncoder.encode(value, charset));
            }
            if (!StringUtil.isEmpty(query.toString())) {
                return query.toString().getBytes(charset);
            }
            return new byte[0];
        }
        catch (IOException e) {
            throw new MtSdkException(SdkError.HTTPCLIENT_ERROR, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStreamAsString(InputStream inputStream, String charset) throws IOException {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, charset));
            StringWriter writer = new StringWriter();
            char[] chars = new char[256];
            int count = 0;
            while ((count = reader.read(chars)) > 0) {
                writer.write(chars, 0, count);
            }
            String string = writer.toString();
            return string;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    private static String getResponseCharset(String ctype) {
        String charset = "UTF-8";
        if (!StringUtil.isEmpty(ctype)) {
            String[] params;
            for (String param : params = ctype.split(";")) {
                if (!(param = param.trim()).startsWith("charset")) continue;
                String[] pair = param.split("=", 2);
                if (pair.length != 2 || StringUtil.isEmpty(pair[1])) break;
                charset = pair[1].trim();
                break;
            }
        }
        return charset;
    }

    private static HttpURLConnection getConnection(URL url, String ctype, Map<String, String> headers) throws IOException {
        HttpURLConnection conn;
        if (HTTPS.equals(url.getProtocol())) {
            HttpsURLConnection connHttps = (HttpsURLConnection)url.openConnection();
            conn = connHttps;
        } else {
            conn = (HttpURLConnection)url.openConnection();
        }
        conn.setRequestMethod(POST);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setRequestProperty("Accept", "application/json");
        conn.setRequestProperty("User-Agent", "mt-sdk-java");
        conn.setRequestProperty("Content-Type", ctype);
        if (Objects.nonNull(headers)) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                conn.setRequestProperty(header.getKey(), header.getValue());
            }
        }
        return conn;
    }

    static {
        logger = LoggerFactory.getLogger(DefaultHttpClient.class);
        try {
            ctx = SSLContext.getInstance("TLS");
            ctx.init(new KeyManager[0], new TrustManager[]{new DefaultTrustManager()}, new SecureRandom());
        }
        catch (Exception e) {
            logger.error("\u521d\u59cb\u5316SSLContext\u5931\u8d25\uff0cerrMsg:{}", (Object)e.getMessage());
        }
        verifier = new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
    }

    private static class DefaultTrustManager
    implements X509TrustManager {
        private DefaultTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }
    }
}

