/*
 * Decompiled with CFR 0.152.
 */
package com.meituan.sdk.internal.utils;

import com.meituan.sdk.MeituanRequest;
import com.meituan.sdk.annotations.ApiMeta;
import com.meituan.sdk.domain.ApiMetaInfo;
import com.meituan.sdk.internal.exceptions.MtSdkException;
import com.meituan.sdk.internal.utils.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationUtil {
    private static final Logger logger = LoggerFactory.getLogger(AnnotationUtil.class);

    public static <T> ApiMetaInfo getApiMeta(MeituanRequest<T> req) throws MtSdkException {
        ApiMetaInfo metaDO = new ApiMetaInfo();
        Class<?> clazz = req.getClass();
        if (!clazz.isAnnotationPresent(ApiMeta.class)) {
            logger.error("\u83b7\u53d6request\u5143\u6570\u636e\u5931\u8d25\uff0crequest:{}", (Object)JsonUtil.toJson(req));
            throw new MtSdkException("SDK_GET_APIMETA_ERROR", "\u83b7\u53d6request\u5143\u6570\u636e\u5f02\u5e38");
        }
        ApiMeta apiMeta = clazz.getDeclaredAnnotation(ApiMeta.class);
        metaDO.setApiName(apiMeta.apiName());
        metaDO.setApiVersion(apiMeta.apiVersion());
        metaDO.setBusinessId(apiMeta.businessId());
        metaDO.setNeedAuth(apiMeta.needAuth());
        metaDO.setPath(apiMeta.path());
        return metaDO;
    }
}

