/*
 * Decompiled with CFR 0.152.
 */
package com.meituan.sdk.internal.utils;

import com.meituan.sdk.internal.enums.SdkError;
import com.meituan.sdk.internal.exceptions.MtSdkException;
import java.security.MessageDigest;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;

public class SignerUtil {
    public static String getSign(String signKey, Map<String, String> params) throws MtSdkException {
        try {
            String sortedStr = SignerUtil.getSortedParamStr(params);
            String paraStr = signKey + sortedStr;
            return SignerUtil.createSign(paraStr);
        }
        catch (Exception e) {
            throw new MtSdkException(SdkError.SIGNNER_UTIL_ERROR, (Throwable)e);
        }
    }

    private static String getSortedParamStr(Map<String, String> params) {
        TreeSet<String> sortedParams = new TreeSet<String>(params.keySet());
        StringBuilder strB = new StringBuilder();
        for (String key : sortedParams) {
            String value;
            if ("sign".equalsIgnoreCase(key) || !Objects.nonNull(value = params.get(key)) || value.isEmpty()) continue;
            strB.append(key).append(value);
        }
        return strB.toString();
    }

    private static String createSign(String str) throws Exception {
        if (str == null || str.length() == 0) {
            return null;
        }
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        MessageDigest mdTemp = MessageDigest.getInstance("SHA1");
        mdTemp.update(str.getBytes("UTF-8"));
        byte[] md = mdTemp.digest();
        int j = md.length;
        char[] buf = new char[j * 2];
        int k = 0;
        for (int i = 0; i < j; ++i) {
            byte byte0 = md[i];
            buf[k++] = hexDigits[byte0 >>> 4 & 0xF];
            buf[k++] = hexDigits[byte0 & 0xF];
        }
        return new String(buf);
    }
}

