/*
 * Decompiled with CFR 0.152.
 */
package com.shiji.health.component;

import com.shiji.health.component.SourceHealthService;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;

public class DataSourceHealthServiceImpl
implements SourceHealthService<DataSource> {
    private static final Logger log = LoggerFactory.getLogger(DataSourceHealthServiceImpl.class);
    @Value(value="${spring.datasource.health.sql:none}")
    private String healthSQL;
    @Value(value="${spring.datasource.health.bean:none}")
    private String healthBean;
    @Autowired
    private BeanFactory beanFactory;

    @Override
    public void onValid() {
        log.warn("--->onValidDataSource");
        if (!StringUtils.isEmpty((Object)this.healthSQL) && !this.healthSQL.equals("none")) {
            DataSource source = null;
            source = !StringUtils.isEmpty((Object)this.healthBean) && !this.healthBean.equalsIgnoreCase("none") ? (DataSource)this.beanFactory.getBean(this.healthBean) : (DataSource)this.beanFactory.getBean(DataSource.class);
            try (Connection conn = source.getConnection();
                 Statement statement = conn.createStatement();
                 ResultSet resultSet = statement.executeQuery(this.healthSQL);){
                log.warn("--->successful");
                resultSet.close();
                statement.close();
                conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }
}

