/*
 * Decompiled with CFR 0.152.
 */
package com.shiji.health.component;

import com.shiji.health.component.SourceHealthService;
import com.shiji.health.utils.RandomGUID;
import java.io.IOException;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.data.redis.connection.RedisClusterConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisSentinelConnection;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.util.StringUtils;

public class RedisSourceHealthServiceImpl
implements SourceHealthService<RedisConnectionFactory> {
    private static final Logger log = LoggerFactory.getLogger(RedisSourceHealthServiceImpl.class);
    @Autowired
    private BeanFactory beanFactory;
    @Value(value="${spring.redis.health.bean:none}")
    private String healthBean;

    private String getRedisType(RedisConnectionFactory factory) {
        String response = "Cluster";
        try (RedisClusterConnection cluster = factory.getClusterConnection();){
            response = "Cluster";
        }
        catch (InvalidDataAccessApiUsageException idaae) {
            try (RedisSentinelConnection sentinel = factory.getSentinelConnection();){
                response = "Sentinel";
            }
            catch (IOException | InvalidDataAccessResourceUsageException e) {
                response = "Standalone";
            }
        }
        return response;
    }

    @Override
    public void onValid() {
        RedisConnectionFactory factory = null;
        factory = !StringUtils.isEmpty((Object)this.healthBean) && !this.healthBean.equalsIgnoreCase("none") ? (RedisConnectionFactory)this.beanFactory.getBean(this.healthBean) : (RedisConnectionFactory)this.beanFactory.getBean(RedisConnectionFactory.class);
        log.warn("--->onValidRedis is null {} classname:{}", (Object)(factory == null ? 1 : 0), (Object)factory.getClass().getName());
        log.warn("--->onValidRedis type:{}", (Object)this.getRedisType(factory));
        RedisTemplate template = new RedisTemplate();
        template.setConnectionFactory(factory);
        template.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        template.setHashKeySerializer((RedisSerializer)new StringRedisSerializer());
        template.setValueSerializer((RedisSerializer)new Jackson2JsonRedisSerializer(Object.class));
        template.setHashValueSerializer((RedisSerializer)new Jackson2JsonRedisSerializer(Object.class));
        template.afterPropertiesSet();
        ValueOperations vop = template.opsForValue();
        String dataKey = String.format("com.shiji.health:%1$s", new RandomGUID().toString());
        log.warn("--->onValidRedis Set({},{})", (Object)dataKey, (Object)dataKey);
        boolean successful = vop.setIfAbsent((Object)dataKey, (Object)dataKey, Duration.ofMillis(1L));
        if (!successful) {
            vop.set((Object)dataKey, (Object)dataKey, Duration.ofMinutes(1L));
        }
    }
}

