/*
 * Decompiled with CFR 0.152.
 */
package com.shiji.health.configer;

import com.shiji.health.component.DataSourceHealthServiceImpl;
import com.shiji.health.component.RedisSourceHealthServiceImpl;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;

@Configuration
public class HealthConfig {
    private static final Logger log = LoggerFactory.getLogger(HealthConfig.class);

    @Bean(value={"dsHealth"})
    @ConditionalOnProperty(prefix="spring.datasource.health", name={"enable"}, havingValue="true")
    @ConditionalOnBean(value={DataSource.class})
    public DataSourceHealthServiceImpl dataHealthFactory() {
        log.info("HealthConfig::dataConnectionFactory");
        DataSourceHealthServiceImpl service = new DataSourceHealthServiceImpl();
        return service;
    }

    @Bean(name={"redisHealth"})
    @ConditionalOnProperty(prefix="spring.redis.health", name={"enable"}, havingValue="true")
    @ConditionalOnBean(value={RedisConnectionFactory.class})
    public RedisSourceHealthServiceImpl redisHealthFactory() {
        log.info("HealthConfig::redisConnectionFactory");
        RedisSourceHealthServiceImpl service = new RedisSourceHealthServiceImpl();
        return service;
    }
}

