# 石基服务心跳检查工程说明

## 1、检查范围

* Redis是否存活
* 数据库是否存活

## 2、检查办法

| 分类 | 说明 | 备注 |
|---|---|---|
| Redis检查 | 执行Redis写入 | 是否成功 |
| 数据库检查 | 执行数据库查询 | 是否成功 |

## 3、检查判断

| 分类 | 说明 | 备注 |
|---|---|---|
| Redis检查 | Redis心跳启动配置 | spring.redis.health.enable=true |
|  | Redis多Bean时配置 | spring.redis.health.bean=bean名称 |
| 数据库检查 | 数据库心跳启动配置 | spring.datasource.health.enable=true |
|  | 数据库多Bean时配置 | spring.datasource.health.bean=bean名称 |
|  | 数据库心跳配置SQL | spring.datasource.health.sql=select 1 as x |
| 心跳探针| http://ip:port/health | http://127.0.0.1:8080/health|

* 备注：
    * Redis多Bean时配置的bean名称为：DataSource的Bean名称
    * 数据库多Bean时配置的bean名称为：RedisConnectionFactory的Bean名称
    * 数据库心跳配置SQL为：执行该SQL成功为数据库访问成功


## 4、注意事项
### 4.1、注册中心

* 注册中心未引入工程需要增加引用

```
<dependency>
    <groupId>com.shiji</groupId>
    <artifactId>HealthLib</artifactId>
    <version>0.0.2</version>
</dependency>
```

* 注册中心冲突需要修改pom.xml

```
<dependency>
    <groupId>org.springframework.boot</groupId>
    <artifactId>spring-boot-starter-data-redis</artifactId>
    <exclusions>
        <exclusion>
            <groupId>org.slf4j</groupId>
            <artifactId>slf4j-api</artifactId>
        </exclusion>
        <exclusion>
            <groupId>ch.qos.logback</groupId>
            <artifactId>logback-classic</artifactId>
        </exclusion>
    </exclusions>
</dependency>
```

* 注册中心需要增加扫描

```
@SpringBootApplication(exclude={DataSourceAutoConfiguration.class})
@ComponentScan({"com.efuture.eureka.server","com.shiji.health.*"})
@EnableEurekaServer  // 启动服务发现服务，配置信息见application.yml
public class BootEurekaServer {
   ...
}
```

### 4.2、网关gateway

* 应用网关需要增加扫描

```
@ComponentScan(excludeFilters= {@ComponentScan.Filter(type=FilterType.ASSIGNABLE_TYPE, value= {DataRestController.class,SwaggerController.class, DynamicDeployRunner.class})},value = {"com.shiji.gateway","com.shiji.health.*","com.shiji.core"})
@EnableDiscoveryClient
@SpringBootApplication
public class GatewayApplication {
    ...
}
```


* 然后引用库

```
<dependency>
    <groupId>com.shiji</groupId>
    <artifactId>HealthLib</artifactId>
    <version>0.0.2</version>
</dependency>
```
  
### 4.3、认证oauth2

* 应用认证需要增加扫描

```
@SpringBootApplication(exclude = { HibernateJpaAutoConfiguration.class,MongoAutoConfiguration.class, MongoDataAutoConfiguration.class,MongoReactiveAutoConfiguration.class })
@EnableDiscoveryClient
@ComponentScan(excludeFilters= {@ComponentScan.Filter(type=FilterType.ASSIGNABLE_TYPE, value= {DataRestController.class,SwaggerController.class,DynamicDeployRunner.class})},value = {"com.product","com.efuture","com.shiji","com.shiji.health.*"})
public class SecurityApplication {
   ...
}
```

* 应用认证需要增加URL忽略

```
@Configuration
public class WebSecurityConfig extends WebSecurityConfigurerAdapter {
    ...
    
    @Override
    public void configure(WebSecurity web) throws Exception {
     // 配置跳过访问连接
        web.ignoring().antMatchers("/favor.ioc","/health");
    }
}
```



