/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pos.component;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.pos.component.OrderServiceImpl;
import com.efuture.pos.component.PosLogicServiceImpl;
import com.efuture.pos.component.common.SellType;
import com.efuture.pos.component.service.AeonAcsService;
import com.efuture.pos.model.CacheModel;
import com.efuture.pos.model.Payment;
import com.efuture.pos.model.aeonacs.request.AcsPayIn;
import com.efuture.pos.model.aeonacs.request.GetTrackDataIn;
import com.efuture.pos.model.aeonacs.response.AcsPayOut;
import com.efuture.pos.model.aeonacs.response.GetTrackDataOut;
import com.efuture.pos.model.posManager.BankCardInfoDef;
import com.efuture.pos.model.request.CipPayIn;
import com.efuture.pos.model.response.PaymentOut;
import com.efuture.pos.model.response.TransferAeonCardNoOut;
import com.efuture.pos.service.AcsPayService;
import com.efuture.pos.service.common.CacheModelService;
import com.efuture.pos.util.Convert;
import com.efuture.pos.util.ParamsValidateUtils;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.client.RestTemplate;

public class AcsPayServiceImpl
implements AcsPayService {
    @Autowired
    CacheModelService cacheModelService;
    @Autowired
    PosLogicServiceImpl posLogicServiceImpl;
    @Autowired
    public AeonAcsService aeonAcsService;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    OrderServiceImpl orderService;

    public ServiceResponse cipPay(ServiceSession session, JSONObject paramsObject) {
        Payment payment;
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        if (!paramsObject.containsKey((Object)"amount") || paramsObject.getString("amount").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"ACS\u5206\u671f\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u4ed8\u6b3e\u91d1\u989d"});
        }
        if (!paramsObject.containsKey((Object)"payCode") || paramsObject.getString("payCode").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"ACS\u5206\u671f\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u4ed8\u6b3e\u65b9\u5f0f\u4ee3\u7801"});
        }
        if (!paramsObject.containsKey((Object)"payName") || paramsObject.getString("payName").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"ACS\u5206\u671f\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u4ed8\u6b3e\u65b9\u5f0f\u540d\u79f0"});
        }
        if (!paramsObject.containsKey((Object)"scene") || paramsObject.getString("scene").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"ACS\u5206\u671f\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"scene"});
        }
        if (!paramsObject.containsKey((Object)"rate") || paramsObject.getString("rate").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"ACS\u5206\u671f\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u6c47\u7387"});
        }
        if (!paramsObject.containsKey((Object)"chargeRate") || paramsObject.getString("chargeRate").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"ACS\u5206\u671f\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u627e\u96f6\u6c47\u7387"});
        }
        if (!paramsObject.containsKey((Object)"precision") || paramsObject.getString("precision").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"ACS\u5206\u671f\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u56db\u820d\u4e94\u5165\u7cbe\u5ea6"});
        }
        if (!paramsObject.containsKey((Object)"cutMode") || paramsObject.getString("cutMode").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"ACS\u5206\u671f\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u56db\u820d\u4e94\u5165\u65b9\u5f0f"});
        }
        if (!paramsObject.containsKey((Object)"maxVal") || paramsObject.getDouble("maxVal").isNaN()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"ACS\u5206\u671f\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u6700\u5927\u6210\u4ea4\u91d1\u989d"});
        }
        if (!paramsObject.containsKey((Object)"isAllowCharge") || paramsObject.getString("isAllowCharge").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"ACS\u5206\u671f\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u662f\u5426\u627e\u96f6"});
        }
        if (!paramsObject.containsKey((Object)"isOverage") || paramsObject.getString("isOverage").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"ACS\u5206\u671f\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u662f\u5426\u6ea2\u4f59"});
        }
        if (!paramsObject.containsKey((Object)"minVal") || paramsObject.getDouble("minVal").isNaN()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"ACS\u5206\u671f\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u6700\u5c0f\u6210\u4ea4\u91d1\u989d"});
        }
        if (!paramsObject.containsKey((Object)"payType") || paramsObject.getString("payType").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"ACS\u5206\u671f\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u4ed8\u6b3e\u5927\u7c7b"});
        }
        if (!paramsObject.containsKey((Object)"installmentTerms") || paramsObject.getIntValue("installmentTerms") <= 0) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"ACS\u5206\u671f\u4ed8\u6b3e\u53c2\u6570[{0}]\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u5408\u6cd5", (Object[])new Object[]{"\u5206\u671f\u6570"});
        }
        if (!paramsObject.containsKey((Object)"firstInstallmentAmount") || paramsObject.getDouble("firstInstallmentAmount").isNaN()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"ACS\u5206\u671f\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u7b2c1\u671f\u5206\u671f\u989d"});
        }
        if (!paramsObject.containsKey((Object)"posEntryMode") || paramsObject.getString("posEntryMode").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"ACS\u5206\u671f\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u5237\u5361\u6a21\u5f0f"});
        }
        if (!paramsObject.containsKey((Object)"messageType") || paramsObject.getString("messageType").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"ACS\u5206\u671f\u4ed8\u6b3e\u53c2\u6570[{0}]\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u5408\u6cd5", (Object[])new Object[]{"\u6d88\u606f\u7c7b\u578b"});
        }
        if (!paramsObject.getString("messageType").equals("10") && !paramsObject.getString("messageType").equals("20")) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"ACS\u5206\u671f\u4ed8\u6b3e\u53c2\u6570[{0}]\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u5408\u6cd5", (Object[])new Object[]{"\u6d88\u606f\u7c7b\u578b"});
        }
        CipPayIn in = (CipPayIn)JSON.parseObject((String)paramsObject.toJSONString(), CipPayIn.class);
        CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(in.getFlowNo());
        if (cacheModel == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355", (Object[])new Object[]{in.getFlowNo()});
        }
        if (SellType.ISSALE(cacheModel.getOrder().getOrderType()) || "2".equals(cacheModel.getOrder().getOrderType())) {
            if (!paramsObject.containsKey((Object)"payNo") || paramsObject.getString("payNo").isEmpty() || paramsObject.getString("payNo").length() != 16) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"ACS\u5206\u671f\u4ed8\u6b3e\u53c2\u6570[{0}]\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u5408\u6cd5", (Object[])new Object[]{"\u4ed8\u6b3e\u8d26\u53f7"});
            }
            if (!paramsObject.containsKey((Object)"expiryDate") || paramsObject.getString("expiryDate").isEmpty() || paramsObject.getString("expiryDate").length() != 4) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"ACS\u5206\u671f\u4ed8\u6b3e\u53c2\u6570[{0}]\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u5408\u6cd5", (Object[])new Object[]{"\u5230\u671f\u65f6\u95f4"});
            }
        }
        session.setEnt_id(cacheModel.getOrder().getEntId());
        if (SellType.ISSALE(cacheModel.getOrder().getOrderType())) {
            if (!paramsObject.containsKey((Object)"trackData") || paramsObject.getString("trackData").isEmpty() || paramsObject.getString("trackData").length() != 37) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"ACS\u5206\u671f\u4ed8\u6b3e\u53c2\u6570[{0}]\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u5408\u6cd5", (Object[])new Object[]{"\u78c1\u5361\u8f68\u9053\u53f7"});
            }
        } else if ("2".equals(cacheModel.getOrder().getOrderType())) {
            GetTrackDataIn getTrackIn = new GetTrackDataIn();
            getTrackIn.setFlowNo(cacheModel.getOrder().getOriginFlowNo());
            ServiceResponse trackDataResponse = this.aeonAcsService.getTrackData(this.restTemplate, session, getTrackIn);
            GetTrackDataOut trackDataOut = (GetTrackDataOut)trackDataResponse.getData();
            if (null == trackDataOut || null == trackDataOut.getCiplog() || trackDataOut.getCiplog().size() == 0) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u6d88\u5355\u65e0\u6cd5\u67e5\u5230\u539f\u4ea4\u6613trackData,\u8bf7\u4f7f\u7528\u9000\u8d27\u529f\u80fd");
            }
            in.setTrackData(trackDataOut.getCiplog().get(0).getTrackData());
        }
        if (in.getAmount() < in.getMinVal() || in.getAmount() > in.getMaxVal()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8be5\u4ed8\u6b3e\u65b9\u5f0f\u914d\u7f6e\u4e86\u6700\u5c0f\u548c\u6700\u5927\u6210\u4ea4\u91d1\u989d\uff0c\u4ed8\u6b3e\u91d1\u989d\u4e0d\u5728\u914d\u7f6e\u8303\u56f4\u5185\uff0c[{0}],{0}]\u8bf7\u68c0\u67e5\u4ed8\u6b3e\u65b9\u5f0f\u53c2\u6570\u914d\u7f6e", (Object[])new Object[]{in.getMinVal(), in.getMaxVal()});
        }
        boolean b = this.posLogicServiceImpl.isNoYpopPay(cacheModel.getLimitedPayCodes(), in.getPayCode());
        if ("0".equals(in.getScene())) {
            if (b) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u666e\u901a\u4ed8\u6b3e\uff0c\u8be5\u4ed8\u6b3e\u65b9\u5f0f\u5728\u53d7\u9650\u4ed8\u6b3e\u4e2d\uff0c\u8bf7\u68c0\u67e5\u4ed8\u6b3e\u914d\u7f6e\u5408\u6cd5\u6027");
            }
        } else if ("1".equals(in.getScene()) && !b) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u9664\u5916\u4ed8\u6b3e\uff0c\u8be5\u4ed8\u6b3e\u65b9\u5f0f\u4e0d\u5728\u53d7\u9650\u4ed8\u6b3e\u4e2d\uff0c\u8bf7\u68c0\u67e5\u4ed8\u6b3e\u914d\u7f6e\u5408\u6cd5\u6027");
        }
        if ((cacheModel = this.posLogicServiceImpl.CalcOrderAmountByPayReturn(cacheModel, payment = CipPayIn.creatPayment(in, cacheModel))).getCalcResult() == -1) {
            String errCode = "100000";
            if (cacheModel.getErrCode().length() > 0) {
                errCode = cacheModel.getErrCode();
            }
            return ServiceResponse.buildFailure((ServiceSession)session, (String)errCode, (String)cacheModel.getErrMsg());
        }
        List<BankCardInfoDef> bankInfoList = this.orderService.getBankCardInfo(session);
        String payNo = in.getPayNo();
        if (payNo.length() > 0) {
            TransferAeonCardNoOut bankInfo = this.orderService.getBankCardPrintInfo(bankInfoList, payNo, payment.getPayName());
            if (null == bankInfo) {
                payment.setPrintPayNo(Convert.hideCodeNo(payNo, 0, payNo.length() - 4));
            } else {
                payment.setPrintPayNo(bankInfo.getBankCardNo());
                payment.setBankType(bankInfo.getBankType());
            }
        }
        if (!SellType.ISBACK(cacheModel.getOrder().getOrderType()) || "2".equals(cacheModel.getOrder().getOrderType())) {
            AcsPayIn acsPayIn = new AcsPayIn();
            acsPayIn = acsPayIn.transfer(in, cacheModel);
            acsPayIn.setMkt(in.getShopCode());
            acsPayIn.setErpCode(cacheModel.getOrder().getErpCode());
            ServiceResponse acsResponse = this.aeonAcsService.cipPay(this.restTemplate, session, acsPayIn);
            if (!"0".equals(acsResponse.getReturncode())) {
                return acsResponse;
            }
            AcsPayOut acsPayOut = (AcsPayOut)acsResponse.getData();
            payment = acsPayOut.transfer(payment);
        }
        cacheModel = this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
        PaymentOut out = new PaymentOut();
        out.setExistPay(cacheModel.getOrder().getExistPay());
        out.setOughtPay(cacheModel.getOrder().getOughtPay());
        out.setOverageValue(cacheModel.getOrder().getOverageValue());
        out.setRemainValue(cacheModel.getOrder().getRemainValue());
        out.setSalePayments(cacheModel.getPayments());
        return ServiceResponse.buildSuccess((Object)out);
    }
}

