/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pos.component;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.pos.component.CommonService;
import com.efuture.pos.component.CouponServiceImpl;
import com.efuture.pos.component.PosLogicCompoment;
import com.efuture.pos.component.PosLogicServiceImpl;
import com.efuture.pos.model.CacheModel;
import com.efuture.pos.model.Goods;
import com.efuture.pos.model.posManager.request.QueryAeonCouponIn;
import com.efuture.pos.model.posManager.response.QueryAeonCouponOut;
import com.efuture.pos.model.request.AeonOldCouponIn;
import com.efuture.pos.model.request.AeonPrivilegeCouponIn;
import com.efuture.pos.model.response.AeonOldCouponOut;
import com.efuture.pos.service.AeonCouponService;
import com.efuture.pos.service.common.CacheModelService;
import com.efuture.pos.util.ParamsValidateUtils;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.client.RestTemplate;

public class AeonCouponServiceImpl
extends CommonService
implements AeonCouponService {
    private static final Logger logger = LoggerFactory.getLogger(CouponServiceImpl.class);
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    CacheModelService cacheModelService;
    @Autowired
    PosLogicCompoment posLogicCompoment;
    @Autowired
    PosLogicServiceImpl posLogicServiceImpl;

    public ServiceResponse checkCoupon(ServiceSession session, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        if (!paramsObject.containsKey((Object)"couponCode") || paramsObject.getString("couponCode").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5238\u6838\u9500\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u5238\u53f7\u7801"});
        }
        AeonOldCouponIn in = (AeonOldCouponIn)JSON.toJavaObject((JSON)paramsObject, AeonOldCouponIn.class);
        CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(in.getFlowNo());
        if (cacheModel == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u627e\u4e0d\u5230[{0}]\uff01", (Object[])new Object[]{"\u7f13\u5b58"});
        }
        if (null == cacheModel.getGoodsList() || cacheModel.getGoodsList().size() <= 0) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8bf7\u5728\u5546\u54c1\u5f55\u5165\u5b8c\u6bd5\u540e\u4f7f\u7528Discount barcode");
        }
        int existNum = 0;
        int maxNum = 3;
        if (0 != cacheModel.getOrder().getSysPara().getMaxCoupon()) {
            maxNum = cacheModel.getOrder().getSysPara().getMaxCoupon();
        }
        for (Goods g : cacheModel.getGoodsList()) {
            if (!"98".equals(g.getGoodsType()) && !"99".equals(g.getGoodsType()) || ++existNum < maxNum) continue;
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)("\u5355\u7b14\u8ba2\u5355\u6700\u591a\u53ea\u80fd\u4f7f\u7528" + maxNum + "\u4e2aDiscount Barcode\u6216\u5168\u65e5\u901a"));
        }
        QueryAeonCouponIn queryAeonCouponIn = new QueryAeonCouponIn();
        queryAeonCouponIn.setCoupon(in.getCouponCode());
        queryAeonCouponIn.setMkt(in.getShopCode());
        ServiceResponse resp = this.posManagerService.oldCouponQuery(this.restTemplate, session, queryAeonCouponIn);
        if (!"0".equals(resp.getReturncode())) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)resp.getData().toString());
        }
        QueryAeonCouponOut queryAeonCouponOut = (QueryAeonCouponOut)resp.getData();
        if (null == queryAeonCouponOut.getCouponDetailModel()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8be5\u5238\u65e0\u5339\u914d\u89c4\u5219");
        }
        this.posLogicServiceImpl.CalcAeonOldCouponAmount(cacheModel, queryAeonCouponOut);
        if (-1 == cacheModel.getCalcResult()) {
            String errCode = "100000";
            if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                errCode = cacheModel.getErrCode();
            }
            return ServiceResponse.buildFailure((ServiceSession)session, (String)errCode, (String)cacheModel.getErrMsg());
        }
        this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
        AeonOldCouponOut out = new AeonOldCouponOut();
        int index = cacheModel.getGoodsList().size() - 1;
        out.setFlowNo(cacheModel.getFlowNo());
        out.setGoods(cacheModel.getGoodsList().get(index));
        out.setDiscountValue(cacheModel.getOrder().getTotalDiscountValue());
        out.setTotalValue(cacheModel.getOrder().getSaleValue());
        out.setOughtPay(cacheModel.getOrder().getOughtPay());
        return ServiceResponse.buildSuccess((Object)out);
    }

    public ServiceResponse queryAeonPrivilegeCoupon(ServiceSession session, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        if (!paramsObject.containsKey((Object)"couponCode") || paramsObject.getString("couponCode").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5238\u6838\u9500\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u5238\u53f7\u7801"});
        }
        if (!paramsObject.containsKey((Object)"code1") || paramsObject.getString("code1").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5238\u6838\u9500\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u5168\u65e5\u901a\u7f16\u7801"});
        }
        if (!paramsObject.containsKey((Object)"code2") || paramsObject.getString("code2").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5238\u6838\u9500\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u6807\u8bc6\u7b26"});
        }
        AeonPrivilegeCouponIn in = (AeonPrivilegeCouponIn)JSON.toJavaObject((JSON)paramsObject, AeonPrivilegeCouponIn.class);
        CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(in.getFlowNo());
        if (cacheModel == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u627e\u4e0d\u5230[{0}]\uff01", (Object[])new Object[]{"\u7f13\u5b58"});
        }
        if (null == cacheModel.getGoodsList() || cacheModel.getGoodsList().size() <= 0) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8bf7\u5728\u5546\u54c1\u5f55\u5165\u5b8c\u6bd5\u540e\u4f7f\u7528\u5168\u65e5\u901a\u5238");
        }
        int existNum = 0;
        int maxNum = 3;
        if (0 != cacheModel.getOrder().getSysPara().getMaxCoupon()) {
            maxNum = cacheModel.getOrder().getSysPara().getMaxCoupon();
        }
        for (Goods g : cacheModel.getGoodsList()) {
            if ("98".equals(g.getGoodsType())) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5355\u7b14\u8ba2\u5355\u53ea\u80fd\u4f7f\u75281\u4e2a\u5168\u65e5\u901a");
            }
            if ("98".equals(g.getGoodsType()) || "99".equals(g.getGoodsType())) {
                ++existNum;
            }
            if (existNum < maxNum) continue;
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)("\u5355\u7b14\u8ba2\u5355\u6700\u591a\u53ea\u80fd\u4f7f\u7528" + maxNum + "\u4e2aDiscount Barcode\u6216\u5168\u65e5\u901a"));
        }
        QueryAeonCouponIn queryAeonCouponIn = new QueryAeonCouponIn();
        queryAeonCouponIn.setCoupon(in.getCouponCode());
        queryAeonCouponIn.setMkt(cacheModel.getOrder().getShopCode());
        ServiceResponse resp = this.posManagerService.oldCouponQuery(this.restTemplate, session, queryAeonCouponIn);
        if (!"0".equals(resp.getReturncode())) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)resp.getData().toString());
        }
        QueryAeonCouponOut queryAeonCouponOut = (QueryAeonCouponOut)resp.getData();
        if (null == queryAeonCouponOut.getCouponDetailModel()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8be5\u5238\u65e0\u6cd5\u627e\u5230");
        }
        this.posLogicServiceImpl.CalcAeonPrivilegeCouponAmount(cacheModel, queryAeonCouponOut, in.getCode1(), in.getCode2());
        if (-1 == cacheModel.getCalcResult()) {
            String errCode = "100000";
            if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                errCode = cacheModel.getErrCode();
            }
            return ServiceResponse.buildFailure((ServiceSession)session, (String)errCode, (String)cacheModel.getErrMsg());
        }
        this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
        AeonOldCouponOut out = new AeonOldCouponOut();
        int index = cacheModel.getGoodsList().size() - 1;
        out.setFlowNo(cacheModel.getFlowNo());
        out.setGoods(cacheModel.getGoodsList().get(index));
        out.setDiscountValue(cacheModel.getOrder().getTotalDiscountValue());
        out.setTotalValue(cacheModel.getOrder().getSaleValue());
        out.setOughtPay(cacheModel.getOrder().getOughtPay());
        return ServiceResponse.buildSuccess((Object)out);
    }
}

