/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pos.component;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.pos.model.CacheModel;
import com.efuture.pos.model.SyncTradeModel;
import com.efuture.pos.model.request.CartGetIn;
import com.efuture.pos.model.request.CartSynIn;
import com.efuture.pos.model.response.CartGetOut;
import com.efuture.pos.service.CartService;
import com.efuture.pos.service.common.CacheModelService;
import com.efuture.pos.service.sync.SyncTradeService;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class CartServiceImpl
implements CartService {
    @Autowired
    SyncTradeService syncTradeService;
    @Autowired
    CacheModelService cacheModelService;
    @Value(value="${server.route.mode}")
    private String routeMode;
    private static final Logger LOGGER = LoggerFactory.getLogger(CartServiceImpl.class);

    public ServiceResponse synTradeNo(ServiceSession session, JSONObject paramobject) {
        if (!"0".equals(this.routeMode)) {
            LOGGER.info("..............  \u8bf7\u6c42\u5728\u7ebf\u6216\u524d\u7f6e\u63a5\u53e3-synTradeNo\uff08\u672a\u7ecf\u8fc7\u672c\u5730\u8def\u7531\uff09\uff0c\u65e0\u9700\u540c\u6b65\u6570\u636e..........");
            JSONObject json = new JSONObject();
            json.put("status", (Object)"success");
            return ServiceResponse.buildSuccess((Object)json);
        }
        List<SyncTradeModel> tradeList = null;
        try {
            tradeList = this.syncTradeService.getSyncTradeList();
        }
        catch (Exception e) {
            ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u83b7\u53d6\u540c\u6b65\u5355\u53f7\u5931\u8d25\uff1a[{0}]", (Object[])new Object[]{e.getMessage()});
        }
        if (null == tradeList) {
            tradeList = Collections.emptyList();
        }
        JSONObject result = new JSONObject();
        result.put("tradeList", tradeList);
        result.put("total", (Object)tradeList.size());
        return ServiceResponse.buildSuccess((Object)result);
    }

    public ServiceResponse delTradeNo(ServiceSession session, JSONObject paramobject) {
        boolean isDeleteSuccess;
        if (!paramobject.containsKey((Object)"tradeNoList") || paramobject.getJSONArray("tradeNoList").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5220\u9664\u540c\u6b65\u5355\u53f7\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u540c\u6b65\u5355\u53f7\u5217\u8868"});
        }
        JSONArray array = paramobject.getJSONArray("tradeNoList");
        try {
            isDeleteSuccess = this.syncTradeService.deleteSyncTrade(JSON.parseArray((String)array.toJSONString(), String.class));
        }
        catch (Exception e) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5220\u9664\u540c\u6b65\u5355\u53f7\u5931\u8d25\uff1a[{0}]", (Object[])new Object[]{e.getMessage()});
        }
        if (!isDeleteSuccess) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5220\u9664\u540c\u6b65\u5355\u53f7\u5931\u8d25");
        }
        return ServiceResponse.buildSuccess((Object)new JSONObject());
    }

    public ServiceResponse addTradeNo(ServiceSession session, JSONObject paramobject) {
        boolean isAddSuccess;
        if (!paramobject.containsKey((Object)"tradeNo") || paramobject.getString("tradeNo").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u589e\u52a0\u540c\u6b65\u5355\u53f7\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u540c\u6b65\u8ba2\u5355\u53f7"});
        }
        if (!paramobject.containsKey((Object)"type") || paramobject.getString("type").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u589e\u52a0\u540c\u6b65\u5355\u53f7\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u540c\u6b65\u5355\u7c7b\u578b"});
        }
        try {
            isAddSuccess = this.syncTradeService.addSyncTrade(paramobject.getString("tradeNo"), paramobject.getString("type"), paramobject.getString("billDate"));
        }
        catch (Exception e) {
            e.printStackTrace();
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stringWriter));
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u589e\u52a0\u540c\u6b65\u5355\u53f7\u5931\u8d25\uff1a[{0}]", (Object[])new Object[]{e.getMessage()});
        }
        if (!isAddSuccess) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u589e\u52a0\u540c\u6b65\u5355\u53f7\u5931\u8d25");
        }
        return ServiceResponse.buildSuccess((Object)new JSONObject());
    }

    public ServiceResponse syn(ServiceSession session, JSONObject paramobject) {
        if (!paramobject.containsKey((Object)"orderInfo")) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u540c\u6b65\u8d2d\u7269\u8f66\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u5168\u8ba2\u5355\u4fe1\u606f"});
        }
        CartSynIn synIn = null;
        try {
            synIn = (CartSynIn)JSON.parseObject((String)paramobject.toJSONString(), CartSynIn.class);
        }
        catch (Exception e) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u540c\u6b65\u8d2d\u7269\u8f66[{0}]", (Object[])new Object[]{e.getMessage()});
        }
        if (synIn.getOrderInfo() == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u540c\u6b65\u8d2d\u7269\u8f66\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u5168\u8ba2\u5355\u4fe1\u606f"});
        }
        this.cacheModelService.saveOrUpdateCacheModel(synIn.getOrderInfo());
        return ServiceResponse.buildSuccess((Object)"\u540c\u6b65\u6210\u529f");
    }

    public ServiceResponse get(ServiceSession session, JSONObject paramobject) {
        if (StringUtils.isBlank((String)paramobject.getString("flowNo"))) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u6240\u9700\u516c\u5171\u5b57\u6bb5\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u6d41\u6c34\u53f7"});
        }
        CartGetIn in = null;
        try {
            in = (CartGetIn)JSON.parseObject((String)paramobject.toJSONString(), CartGetIn.class);
        }
        catch (Exception e) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u83b7\u53d6\u8d2d\u7269\u8f66[{0}]", (Object[])new Object[]{e.getMessage()});
        }
        CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(in.getFlowNo());
        if (cacheModel == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355", (Object[])new Object[]{in.getFlowNo()});
        }
        CartGetOut out = new CartGetOut();
        out.setOrderInfo(cacheModel);
        return ServiceResponse.buildSuccess((Object)out);
    }

    public ServiceResponse synPosCenterData(ServiceSession session, JSONObject paramobject) {
        List<SyncTradeModel> tradeList = null;
        try {
            tradeList = this.syncTradeService.getSyncTradeList();
        }
        catch (Exception e) {
            ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u83b7\u53d6\u540c\u6b65\u5355\u53f7\u5931\u8d25\uff1a[{0}]", (Object[])new Object[]{e.getMessage()});
        }
        if (null == tradeList) {
            tradeList = Collections.emptyList();
        }
        JSONObject result = new JSONObject();
        result.put("tradeList", tradeList);
        result.put("total", (Object)tradeList.size());
        return ServiceResponse.buildSuccess((Object)result);
    }
}

