/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pos.component;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.pos.component.CommonService;
import com.efuture.pos.component.CouponReverseServiceImpl;
import com.efuture.pos.component.OrderServiceImpl;
import com.efuture.pos.component.PosLogicServiceImpl;
import com.efuture.pos.component.service.CnaeonCentreService;
import com.efuture.pos.model.BaseOutModel;
import com.efuture.pos.model.CacheModel;
import com.efuture.pos.model.OrderForPos;
import com.efuture.pos.model.Payment;
import com.efuture.pos.model.cnaeon.BaseResponse;
import com.efuture.pos.model.cnaeon.request.CouponBackPayReqest;
import com.efuture.pos.model.cnaeon.request.CouponCannelPayReqest;
import com.efuture.pos.model.cnaeon.request.CouponCheckReqest;
import com.efuture.pos.model.cnaeon.request.CouponPayReqest;
import com.efuture.pos.model.cnaeon.request.CouponQueryReqest;
import com.efuture.pos.model.cnaeon.request.CouponScanPayReqest;
import com.efuture.pos.model.cnaeon.response.AvailableCoupon;
import com.efuture.pos.model.cnaeon.response.CnaeonCouponData;
import com.efuture.pos.model.cnaeon.response.CouponPayData;
import com.efuture.pos.model.cnaeon.response.SubCompany;
import com.efuture.pos.model.promotionCentre.request.RemovePayIn;
import com.efuture.pos.model.request.CnaeonCouponBackPayIn;
import com.efuture.pos.model.request.CnaeonCouponCheckIn;
import com.efuture.pos.model.request.CnaeonCouponPayIn;
import com.efuture.pos.model.request.CnaeonCouponQueryIn;
import com.efuture.pos.model.request.CnaeonCouponScanPayIn;
import com.efuture.pos.service.CnaeonCouponService;
import com.efuture.pos.service.common.CacheModelService;
import com.efuture.pos.util.CnaeonSignature;
import com.efuture.pos.util.ManipulatePrecision;
import com.efuture.pos.util.ParamsValidateUtils;
import com.efuture.pos.util.UUIDUtils;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.client.RestTemplate;

public class CnaeonCouponServiceImpl
extends CommonService
implements CnaeonCouponService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CnaeonCouponServiceImpl.class);
    @Autowired
    CacheModelService cacheModelService;
    @Autowired
    PosLogicServiceImpl posLogicServiceImpl;
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    CnaeonCentreService cnaeonCentreService;
    @Autowired
    OrderServiceImpl orderService;
    @Autowired
    CouponReverseServiceImpl couponReverseService;
    private String salt = "";

    @Override
    public ServiceResponse saleQuery(ServiceSession session, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        CnaeonCouponQueryIn in = (CnaeonCouponQueryIn)JSON.parseObject((String)paramsObject.toJSONString(), CnaeonCouponQueryIn.class);
        String emptypara = ParamsValidateUtils.getNullField(in);
        if (!StringUtils.isEmpty((String)emptypara)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u67e5\u8be2\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{emptypara});
        }
        CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(in.getFlowNo());
        if (null == cacheModel) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\u8ba2\u5355\u6d41\u6c34\u53f7\uff01");
        }
        if (null == cacheModel.getOrder().getConsumersData()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u672a\u767b\u5f55\u4f1a\u5458,\u4e0d\u53ef\u7528\u5238");
        }
        if ("1".equals(cacheModel.getOrder().getConsumersData().getConsumsersStatus())) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8be5\u4f1a\u5458\u5df2\u6ce8\u9500,\u4e0d\u53ef\u7528\u5238");
        }
        if ("2".equals(cacheModel.getOrder().getConsumersData().getConsumsersStatus())) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4f1a\u5458\u5361\u5f02\u5e38\uff0c\u4e0d\u53ef\u7528\u5238");
        }
        if (cacheModel.getOrder().getConsumersData().getBlackFlag() == 1) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4f1a\u5458\u5361\u5f02\u5e38\u4e0d\u53ef\u7528\u5238");
        }
        String orgId = cacheModel.getOrder().getOrgId();
        if (StringUtils.isEmpty((String)orgId)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4ece\u603b\u90e8\u83b7\u53d6\u6cd5\u4eba\u516c\u53f8\u4ee3\u7801\u5931\u8d25");
        }
        this.salt = cacheModel.getOrder().getSysPara().getZtKey();
        if (StringUtils.isEmpty((String)this.salt)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4ece\u603b\u90e8\u83b7\u53d6\u4e2d\u53f0\u7b7e\u540dkey\u5931\u8d25");
        }
        ServiceResponse response = null;
        try {
            CouponQueryReqest queryRequest = new CouponQueryReqest(in, cacheModel);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("tokenId", queryRequest.getTokenId());
            params.put("timestamp", queryRequest.getTimestamp());
            params.put("orgId", queryRequest.getOrgId());
            params.put("regionalCode", queryRequest.getRegionalCode());
            params.put("storeCode", queryRequest.getStoreCode());
            params.put("orderNo", queryRequest.getOrderNo());
            queryRequest.setSign(CnaeonSignature.sign(params, this.salt));
            response = this.cnaeonCentreService.couponQuery(this.restTemplate, session, JSON.toJSONString((Object)queryRequest));
        }
        catch (Exception e) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u6570\u636e\u5f02\u5e38");
        }
        return this.callTransQueryServiceHandle(response, session, in.getQueryNum(), cacheModel);
    }

    private ServiceResponse callTransQueryServiceHandle(ServiceResponse response, ServiceSession session, int queryTimes, CacheModel cacheModel) {
        LOGGER.info("callTransQueryServiceHandle start !queryTimes =[{}] ,serviceType=[{}]", (Object)queryTimes);
        if ("0".equals(response.getReturncode())) {
            BaseResponse cnaeonResp = (BaseResponse)response.getData();
            if ("200".equals(cnaeonResp.getCode().toString())) {
                CnaeonCouponData cnaeonCouponData = (CnaeonCouponData)JSON.parseObject((String)cnaeonResp.getData().toJSONString(), CnaeonCouponData.class);
                List<AvailableCoupon> sortList = cnaeonCouponData.getAvailableCouponList();
                if (queryTimes > 1) {
                    ArrayList<AvailableCoupon> coupons = new ArrayList<AvailableCoupon>();
                    Iterator<AvailableCoupon> iterator = sortList.iterator();
                    while (iterator.hasNext()) {
                        AvailableCoupon coupon;
                        AvailableCoupon ac = coupon = iterator.next();
                        ac.setChecked(false);
                        coupons.add(ac);
                    }
                    cnaeonCouponData.setAvailableCouponList(coupons);
                }
                double couponAmount = 0.0;
                for (AvailableCoupon coupon : cnaeonCouponData.getAvailableCouponList()) {
                    if (!coupon.getChecked().booleanValue()) continue;
                    couponAmount = ManipulatePrecision.add(couponAmount, coupon.getParValue().doubleValue());
                }
                cacheModel.getOrder().setCouponAmount(couponAmount);
                this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
                return ServiceResponse.buildSuccess((Object)cnaeonCouponData);
            }
            return ServiceResponse.buildFailure((ServiceSession)session, (String)cnaeonResp.getCode().toString(), (String)("\u83b7\u53d6\u5238\u4fe1\u606f\u5931\u8d25\uff1a" + cnaeonResp.getMessage()));
        }
        return ServiceResponse.buildFailure((ServiceSession)session, (String)response.getReturncode(), (String)"\u4e2d\u53f0\u8fde\u4e0d\u4e0a \u83b7\u53d6\u5238\u4fe1\u606f\u5f02\u5e38");
    }

    @Override
    public ServiceResponse saleCheck(ServiceSession session, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        CnaeonCouponCheckIn in = (CnaeonCouponCheckIn)JSON.parseObject((String)paramsObject.toJSONString(), CnaeonCouponCheckIn.class);
        String emptypara = ParamsValidateUtils.getNullField(in);
        if (!StringUtils.isEmpty((String)emptypara)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5238\u9a8c\u8bc1\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{emptypara});
        }
        CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(in.getFlowNo());
        if (null == cacheModel) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\u8ba2\u5355\u6d41\u6c34\u53f7\uff01");
        }
        String orgId = cacheModel.getOrder().getOrgId();
        if (StringUtils.isEmpty((String)orgId)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4ece\u603b\u90e8\u83b7\u53d6\u6cd5\u4eba\u516c\u53f8\u4ee3\u7801\u5931\u8d25");
        }
        this.salt = cacheModel.getOrder().getSysPara().getZtKey();
        if (StringUtils.isEmpty((String)this.salt)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4ece\u603b\u90e8\u83b7\u53d6\u4e2d\u53f0\u7b7e\u540dkey\u5931\u8d25");
        }
        CouponCheckReqest checkReqest = new CouponCheckReqest(in, cacheModel);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tokenId", checkReqest.getTokenId());
        params.put("timestamp", checkReqest.getTimestamp());
        params.put("orgId", checkReqest.getOrgId());
        params.put("regionalCode", checkReqest.getRegionalCode());
        params.put("storeCode", checkReqest.getStoreCode());
        params.put("orderNo", checkReqest.getOrderNo());
        checkReqest.setSign(CnaeonSignature.sign(params, this.salt));
        ServiceResponse response = this.cnaeonCentreService.verifyCoupon(this.restTemplate, session, JSON.toJSONString((Object)checkReqest));
        return this.callTransCheckServiceHandle(response, session, 0, cacheModel);
    }

    private ServiceResponse callTransCheckServiceHandle(ServiceResponse response, ServiceSession session, int queryTimes, CacheModel cacheModel) {
        LOGGER.info("callTransQueryServiceHandle start !queryTimes =[{}] ,serviceType=[{}]", (Object)queryTimes);
        if ("0".equals(response.getReturncode())) {
            BaseResponse cnaeonResp = (BaseResponse)response.getData();
            if ("200".equals(cnaeonResp.getCode().toString())) {
                CnaeonCouponData cnaeonCouponData = (CnaeonCouponData)JSON.parseObject((String)cnaeonResp.getData().toJSONString(), CnaeonCouponData.class);
                double couponAmount = 0.0;
                for (AvailableCoupon coupon : cnaeonCouponData.getAvailableCouponList()) {
                    if (!coupon.getChecked().booleanValue()) continue;
                    couponAmount = ManipulatePrecision.add(couponAmount, coupon.getParValue().doubleValue());
                }
                cacheModel.getOrder().setCouponAmount(couponAmount);
                this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
                return ServiceResponse.buildSuccess((Object)cnaeonCouponData);
            }
            return ServiceResponse.buildFailure((ServiceSession)session, (String)cnaeonResp.getCode().toString(), (String)("\u5238\u4e0d\u53ef\u4f7f\u7528\uff1a" + cnaeonResp.getMessage()));
        }
        return ServiceResponse.buildFailure((ServiceSession)session, (String)response.getReturncode(), (String)"\u4e2d\u53f0\u8fde\u4e0d\u4e0a \u83b7\u53d6\u5238\u4fe1\u606f\u5f02\u5e38");
    }

    @Override
    public ServiceResponse salePay(ServiceSession session, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        CnaeonCouponPayIn in = (CnaeonCouponPayIn)JSON.parseObject((String)paramsObject.toJSONString(), CnaeonCouponPayIn.class);
        String emptypara = ParamsValidateUtils.getNullField(in);
        if (!StringUtils.isEmpty((String)emptypara)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5238\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{emptypara});
        }
        CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(in.getFlowNo());
        if (null == cacheModel) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\u8ba2\u5355\u6d41\u6c34\u53f7\uff01");
        }
        if (cacheModel.getOrder().getSendSuccess()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u63d0\u4ea4\u6210\u529f\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u4ed8\u6b3e\u8d44\u8baf", (Object[])new Object[]{in.getFlowNo()});
        }
        if (null == cacheModel.getOrder().getConsumersData()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u672a\u767b\u5f55\u4f1a\u5458,\u4e0d\u53ef\u7528\u5238");
        }
        if ("1".equals(cacheModel.getOrder().getConsumersData().getConsumsersStatus())) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8be5\u4f1a\u5458\u5df2\u6ce8\u9500,\u4e0d\u53ef\u7528\u5238");
        }
        if ("2".equals(cacheModel.getOrder().getConsumersData().getConsumsersStatus())) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4f1a\u5458\u5361\u5f02\u5e38\uff0c\u4e0d\u53ef\u7528\u5238");
        }
        if (cacheModel.getOrder().getConsumersData().getBlackFlag() == 1) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4f1a\u5458\u5361\u5f02\u5e38\u4e0d\u53ef\u7528\u5238");
        }
        String orgId = cacheModel.getOrder().getOrgId();
        if (StringUtils.isEmpty((String)orgId)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4ece\u603b\u90e8\u83b7\u53d6\u6cd5\u4eba\u516c\u53f8\u4ee3\u7801\u5931\u8d25");
        }
        this.salt = cacheModel.getOrder().getSysPara().getZtKey();
        if (StringUtils.isEmpty((String)this.salt)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4ece\u603b\u90e8\u83b7\u53d6\u4e2d\u53f0\u7b7e\u540dkey\u5931\u8d25");
        }
        session.setEnt_id(cacheModel.getOrder().getEntId());
        cacheModel = this.posLogicServiceImpl.calcBalance(cacheModel);
        double remainValue = cacheModel.getOrder().getRemainValue();
        if (remainValue <= 0.0) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5df2\u4ed8\u6e05\u6b3e\u9879\uff0c\u65e0\u9700\u518d\u652f\u4ed8\uff01");
        }
        if (remainValue - in.getAmount() < 0.0) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u652f\u4ed8\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5269\u4f59\u4ed8\u6b3e\uff01");
        }
        String payNo = UUIDUtils.buildFlowNo("", in.getShopCode(), in.getTerminalNo());
        in.setPayNO(payNo);
        if ("1".equals(cacheModel.getOrder().getExerciseMode())) {
            Payment pay = CnaeonCouponPayIn.creatPrePayment(in, cacheModel);
            this.callTestTransServiceHandle(pay, cacheModel, in.getCouponNoList().get(0));
        }
        CouponPayReqest payReqest = new CouponPayReqest(in, cacheModel);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tokenId", payReqest.getTokenId());
        params.put("timestamp", payReqest.getTimestamp());
        params.put("orgId", payReqest.getOrgId());
        params.put("regionalCode", payReqest.getRegionalCode());
        params.put("storeCode", payReqest.getStoreCode());
        params.put("orderNo", payReqest.getOrderNo());
        params.put("payNO", payReqest.getPayNO());
        payReqest.setSign(CnaeonSignature.sign(params, this.salt));
        ServiceResponse response = this.cnaeonCentreService.couponPay(this.restTemplate, session, JSON.toJSONString((Object)payReqest));
        return this.callTransPayServiceHandle(response, session, 0, cacheModel, in);
    }

    private ServiceResponse callTransPayServiceHandle(ServiceResponse response, ServiceSession session, int queryTimes, CacheModel cacheModel, CnaeonCouponPayIn in) {
        LOGGER.info("callTransQueryServiceHandle start !queryTimes =[{}] ,serviceType=[{}]", (Object)queryTimes);
        if ("0".equals(response.getReturncode())) {
            BaseResponse cnaeonResp = (BaseResponse)response.getData();
            if ("200".equals(cnaeonResp.getCode().toString())) {
                cacheModel.getOrder().setPayNO(in.getPayNO());
                CouponPayData couponPayData = (CouponPayData)JSON.parseObject((String)cnaeonResp.getData().toJSONString(), CouponPayData.class);
                LOGGER.info("\u4e2d\u53f0\u53c2\u6570\u8f6c\u6362\uff1a" + JSON.toJSONString((Object)couponPayData));
                Payment pay = CnaeonCouponPayIn.creatPrePayment(in, cacheModel);
                List<Payment> realPayList = CnaeonCouponPayIn.creatPayment(pay, couponPayData);
                for (int i = 0; i < realPayList.size(); ++i) {
                    cacheModel = this.posLogicServiceImpl.calcPayAmout(cacheModel, realPayList.get(i));
                }
                LOGGER.info("\u8bb0\u5f55\u5238\u5206\u644a\u524dcacheModel" + JSON.toJSONString((Object)cacheModel));
                CnaeonCouponPayIn.creatPopUseList(cacheModel, couponPayData, in, realPayList);
                LOGGER.info("\u8bb0\u5f55\u5238\u5206\u644a\u4e4b\u540e\u524dcacheModel" + JSON.toJSONString((Object)cacheModel));
                this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
                BaseOutModel out = new BaseOutModel();
                out.setOrder(OrderForPos.toOrderForPos(cacheModel));
                return ServiceResponse.buildSuccess((Object)out);
            }
            CouponBackPayReqest backPayReqest = new CouponBackPayReqest(in, cacheModel);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("tokenId", backPayReqest.getTokenId());
            params.put("timestamp", backPayReqest.getTimestamp());
            params.put("orgId", backPayReqest.getOrgId());
            params.put("regionalCode", backPayReqest.getRegionalCode());
            params.put("storeCode", backPayReqest.getStoreCode());
            params.put("orderNo", backPayReqest.getOrderNo());
            params.put("payNO", backPayReqest.getPayNO());
            backPayReqest.setSign(CnaeonSignature.sign(params, this.salt));
            response = this.cnaeonCentreService.couponBackPay(this.restTemplate, session, JSON.toJSONString((Object)backPayReqest));
            BaseResponse cnaeonBackResp = (BaseResponse)response.getData();
            if (!"200".equals(cnaeonBackResp.getCode().toString())) {
                LOGGER.info("\u4e2d\u53f0\u63a5\u53e3\u8fd4\u56de\u5931\u8d25-\u5c1d\u8bd5\u53d1\u9001MQ");
                response = this.cnaeonCentreService.couponBackPayMQ(this.restTemplate, session, JSON.toJSONString((Object)backPayReqest));
                if (!"0".equals(response.getReturncode())) {
                    LOGGER.info("MQ\u8c03\u7528\u5931\u8d25-\u8bb0\u5f55\u672c\u5730\u6587\u4ef6");
                    this.couponReverseService.save(session, (JSONObject)JSONObject.toJSON((Object)backPayReqest));
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)cnaeonResp.getCode().toString(), (String)"\u8bf7\u6c42\u5f02\u5e38\u6838\u9500\u5931\u8d25");
                }
            }
        } else {
            BaseResponse cnaeonBackResp;
            CouponBackPayReqest backPayReqest = new CouponBackPayReqest(in, cacheModel);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("tokenId", backPayReqest.getTokenId());
            params.put("timestamp", backPayReqest.getTimestamp());
            params.put("orgId", backPayReqest.getOrgId());
            params.put("regionalCode", backPayReqest.getRegionalCode());
            params.put("storeCode", backPayReqest.getStoreCode());
            params.put("orderNo", backPayReqest.getOrderNo());
            params.put("payNO", backPayReqest.getPayNO());
            backPayReqest.setSign(CnaeonSignature.sign(params, this.salt));
            response = this.cnaeonCentreService.couponBackPay(this.restTemplate, session, JSON.toJSONString((Object)backPayReqest));
            if ("0".equals(response.getReturncode()) && "200".equals((cnaeonBackResp = (BaseResponse)response.getData()).getCode().toString())) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)response.getReturncode(), (String)"\u4e2d\u53f0\u8fde\u63a5\u4e0d\u4e0a \u6838\u9500\u5931\u8d25,\u51b2\u6b63\u6210\u529f");
            }
            LOGGER.info("\u4e2d\u53f0\u63a5\u53e3\u8fd4\u56de\u5931\u8d25-\u5c1d\u8bd5\u53d1\u9001MQ");
            response = this.cnaeonCentreService.couponBackPayMQ(this.restTemplate, session, JSON.toJSONString((Object)backPayReqest));
            if (!"0".equals(response.getReturncode())) {
                LOGGER.info("MQ\u8c03\u7528\u5931\u8d25-\u8bb0\u5f55\u672c\u5730\u6587\u4ef6");
                this.couponReverseService.save(session, (JSONObject)JSONObject.toJSON((Object)backPayReqest));
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8bf7\u6c42\u5f02\u5e38\u6838\u9500\u5931\u8d25");
            }
        }
        return ServiceResponse.buildFailure((ServiceSession)session, (String)response.getReturncode(), (String)"\u6838\u9500\u5931\u8d25\uff0c\u5df2\u51b2\u6b63");
    }

    @Override
    public ServiceResponse scanPay(ServiceSession session, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        CnaeonCouponScanPayIn in = (CnaeonCouponScanPayIn)JSON.parseObject((String)paramsObject.toJSONString(), CnaeonCouponScanPayIn.class);
        String emptypara = ParamsValidateUtils.getNullField(in);
        if (!StringUtils.isEmpty((String)emptypara)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u626b\u7801\u7528\u5238\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{emptypara});
        }
        CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(in.getFlowNo());
        if (null == cacheModel) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\u8ba2\u5355\u6d41\u6c34\u53f7\uff01");
        }
        if (cacheModel.getOrder().getSendSuccess()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u63d0\u4ea4\u6210\u529f\uff0c\u4e0d\u5141\u8a31\u4fee\u6539\u4ed8\u6b3e\u8d44\u8baf", (Object[])new Object[]{in.getFlowNo()});
        }
        if (null == cacheModel.getOrder().getConsumersData()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u672a\u767b\u5f55\u4f1a\u5458,\u4e0d\u53ef\u7528\u5238");
        }
        if ("1".equals(cacheModel.getOrder().getConsumersData().getConsumsersStatus())) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8be5\u4f1a\u5458\u5df2\u6ce8\u9500,\u4e0d\u53ef\u7528\u5238");
        }
        if ("2".equals(cacheModel.getOrder().getConsumersData().getConsumsersStatus())) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4f1a\u5458\u5361\u5f02\u5e38\uff0c\u4e0d\u53ef\u7528\u5238");
        }
        if (cacheModel.getOrder().getConsumersData().getBlackFlag() == 1) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4f1a\u5458\u5361\u5f02\u5e38\u4e0d\u53ef\u7528\u5238");
        }
        session.setEnt_id(cacheModel.getOrder().getEntId());
        String orgId = cacheModel.getOrder().getOrgId();
        if (StringUtils.isEmpty((String)orgId)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4ece\u603b\u90e8\u83b7\u53d6\u6cd5\u4eba\u516c\u53f8\u4ee3\u7801\u5931\u8d25");
        }
        this.salt = cacheModel.getOrder().getSysPara().getZtKey();
        if (StringUtils.isEmpty((String)this.salt)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4ece\u603b\u90e8\u83b7\u53d6\u4e2d\u53f0\u7b7e\u540dkey\u5931\u8d25");
        }
        double remainValue = (cacheModel = this.posLogicServiceImpl.calcBalance(cacheModel)).getOrder().getRemainValue();
        if (remainValue <= 0.0) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5df2\u4ed8\u6e05\u6b3e\u9805\uff0c\u7121\u9700\u518d\u652f\u4ed8\uff01");
        }
        if (remainValue - in.getAmount() < 0.0) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u652f\u4ed8\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5269\u4f59\u4ed8\u6b3e\uff01");
        }
        String payNo = UUIDUtils.buildFlowNo("", in.getShopCode(), in.getTerminalNo());
        in.setPayNO(payNo);
        if ("1".equals(cacheModel.getOrder().getExerciseMode())) {
            Payment pay = CnaeonCouponScanPayIn.creatPrePayment(in, cacheModel);
            this.callTestTransServiceHandle(pay, cacheModel, in.getCouponNo());
        }
        CouponScanPayReqest payReqest = new CouponScanPayReqest(in, cacheModel);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tokenId", payReqest.getTokenId());
        params.put("timestamp", payReqest.getTimestamp());
        params.put("orgId", payReqest.getOrgId());
        params.put("regionalCode", payReqest.getRegionalCode());
        params.put("storeCode", payReqest.getStoreCode());
        params.put("orderNo", payReqest.getOrderNo());
        params.put("payNO", payReqest.getPayNO());
        payReqest.setSign(CnaeonSignature.sign(params, this.salt));
        ServiceResponse response = this.cnaeonCentreService.couponPayScan(this.restTemplate, session, JSON.toJSONString((Object)payReqest));
        return this.callScanPayServiceHandle(response, session, 0, cacheModel, in, this.salt);
    }

    private ServiceResponse callScanPayServiceHandle(ServiceResponse response, ServiceSession session, int queryTimes, CacheModel cacheModel, CnaeonCouponScanPayIn in, String salt) {
        LOGGER.info("callTransQueryServiceHandle start !queryTimes =[{}] ,serviceType=[{}]", (Object)queryTimes);
        if ("0".equals(response.getReturncode())) {
            BaseResponse cnaeonResp = (BaseResponse)response.getData();
            if ("200".equals(cnaeonResp.getCode().toString())) {
                cacheModel.getOrder().setPayNO(in.getPayNO());
                CouponPayData couponPayData = (CouponPayData)JSON.parseObject((String)cnaeonResp.getData().toJSONString(), CouponPayData.class);
                if (couponPayData.getMemberId().toString().equals(cacheModel.getOrder().getConsumersData().getConsumersId())) {
                    Payment pay = CnaeonCouponScanPayIn.creatPrePayment(in, cacheModel);
                    List<Payment> realPayList = CnaeonCouponScanPayIn.creatPayment(pay, couponPayData);
                    for (int i = 0; i < realPayList.size(); ++i) {
                        cacheModel = this.posLogicServiceImpl.calcPayAmout(cacheModel, realPayList.get(i));
                    }
                    LOGGER.info("\u8bb0\u5f55\u5238\u5206\u644a\u524dcacheModel" + JSON.toJSONString((Object)cacheModel));
                    CnaeonCouponScanPayIn.creatPopUseList(cacheModel, couponPayData, in, realPayList);
                    LOGGER.info("\u8bb0\u5f55\u5238\u5206\u644a\u540ecacheModel" + JSON.toJSONString((Object)cacheModel));
                    this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
                    BaseOutModel out = new BaseOutModel();
                    out.setOrder(OrderForPos.toOrderForPos(cacheModel));
                    return ServiceResponse.buildSuccess((Object)out);
                }
                CouponBackPayReqest backPayReqest = new CouponBackPayReqest(in, cacheModel);
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("tokenId", backPayReqest.getTokenId());
                params.put("timestamp", backPayReqest.getTimestamp());
                params.put("orgId", backPayReqest.getOrgId());
                params.put("regionalCode", backPayReqest.getRegionalCode());
                params.put("storeCode", backPayReqest.getStoreCode());
                params.put("orderNo", backPayReqest.getOrderNo());
                params.put("payNO", backPayReqest.getPayNO());
                backPayReqest.setSign(CnaeonSignature.sign(params, salt));
                response = this.cnaeonCentreService.couponBackPay(this.restTemplate, session, JSON.toJSONString((Object)backPayReqest));
                CnaeonCouponPayIn.removePopUseList(cacheModel, in.getCouponNo());
                if ("0".equals(response.getReturncode())) {
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"\u4f1a\u5458\u5361\u4e0d\u4e00\u81f4\u4e0d\u5141\u8bb8\u7528\u5238", (Object[])new Object[]{response});
                }
                response = this.cnaeonCentreService.couponBackPayMQ(this.restTemplate, session, JSON.toJSONString((Object)backPayReqest));
                if (!"0".equals(response.getReturncode())) {
                    LOGGER.info("MQ\u8c03\u7528\u5931\u8d25-\u8bb0\u5f55\u672c\u5730\u6587\u4ef6");
                    this.couponReverseService.save(session, (JSONObject)JSONObject.toJSON((Object)backPayReqest));
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"\u4f1a\u5458\u5361\u4e0d\u4e00\u81f4\u4e0d\u5141\u8bb8\u7528\u5238\uff0cMQ\u51b2\u6b63\u5931\u8d25\uff0c\u5df2\u8bb0\u5f55\u672c\u5730\u51b2\u6b63\u6587\u4ef6");
                }
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"\u4f1a\u5458\u5361\u4e0d\u4e00\u81f4\u4e0d\u5141\u8bb8\u7528\u5238,MQ\u5df2\u51b2\u6b63");
            }
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)cnaeonResp.getMessage());
        }
        CouponBackPayReqest backPayReqest = new CouponBackPayReqest(in, cacheModel);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tokenId", backPayReqest.getTokenId());
        params.put("timestamp", backPayReqest.getTimestamp());
        params.put("orgId", backPayReqest.getOrgId());
        params.put("regionalCode", backPayReqest.getRegionalCode());
        params.put("storeCode", backPayReqest.getStoreCode());
        params.put("orderNo", backPayReqest.getOrderNo());
        params.put("payNO", backPayReqest.getPayNO());
        backPayReqest.setSign(CnaeonSignature.sign(params, salt));
        response = this.cnaeonCentreService.couponBackPay(this.restTemplate, session, JSON.toJSONString((Object)backPayReqest));
        if ("0".equals(response.getReturncode())) {
            BaseResponse cnaeonBackResp = (BaseResponse)response.getData();
            if (!"200".equals(cnaeonBackResp.getCode().toString())) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)("\u5238\u6838\u9500\u5f02\u5e38,\u51b2\u6b63\u5931\u8d25" + cnaeonBackResp.getMessage()));
            }
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"\u5238\u6838\u9500\u5f02\u5e38,\u51b2\u6b63\u6210\u529f");
        }
        LOGGER.info("\u4e2d\u53f0\u63a5\u53e3\u8bf7\u6c42\u5931\u8d25-\u5c1d\u8bd5\u53d1\u9001MQ");
        response = this.cnaeonCentreService.couponBackPayMQ(this.restTemplate, session, JSON.toJSONString((Object)backPayReqest));
        if (!"0".equals(response.getReturncode())) {
            LOGGER.info("MQ\u8c03\u7528\u5931\u8d25-\u8bb0\u5f55\u672c\u5730\u6587\u4ef6");
            this.couponReverseService.save(session, (JSONObject)JSONObject.toJSON((Object)backPayReqest));
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"\u5238\u6838\u9500\u5f02\u5e38\uff0cMQ\u51b2\u6b63\u5931\u8d25\uff0c\u5df2\u8bb0\u5f55\u672c\u5730\u51b2\u6b63\u6587\u4ef6");
        }
        return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"\u5238\u6838\u9500\u5f02\u5e38,MQ\u5df2\u51b2\u6b63");
    }

    @Override
    public ServiceResponse saleRefund(ServiceSession session, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        CnaeonCouponBackPayIn in = (CnaeonCouponBackPayIn)JSON.parseObject((String)paramsObject.toJSONString(), CnaeonCouponBackPayIn.class);
        String emptypara = ParamsValidateUtils.getNullField(in);
        if (!StringUtils.isEmpty((String)emptypara)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u51b2\u6b63\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{emptypara});
        }
        CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(in.getFlowNo());
        if (null == cacheModel) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8a02\u55ae\u5df2\u5931\u6548\uff0c\u8acb\u91cd\u65b0\u7372\u53d6\u8a02\u55ae\u6d41\u6c34\u865f\uff01");
        }
        String orgId = cacheModel.getOrder().getOrgId();
        if (StringUtils.isEmpty((String)orgId)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4ece\u603b\u90e8\u83b7\u53d6\u6cd5\u4eba\u516c\u53f8\u4ee3\u7801\u5931\u8d25");
        }
        this.salt = cacheModel.getOrder().getSysPara().getZtKey();
        if (StringUtils.isEmpty((String)this.salt)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4ece\u603b\u90e8\u83b7\u53d6\u4e2d\u53f0\u7b7e\u540dkey\u5931\u8d25");
        }
        CouponBackPayReqest backPayReqest = new CouponBackPayReqest(in, cacheModel);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tokenId", backPayReqest.getTokenId());
        params.put("timestamp", backPayReqest.getTimestamp());
        params.put("orgId", backPayReqest.getOrgId());
        params.put("regionalCode", backPayReqest.getRegionalCode());
        params.put("storeCode", backPayReqest.getStoreCode());
        params.put("orderNo", backPayReqest.getOrderNo());
        params.put("payNO", backPayReqest.getPayNO());
        backPayReqest.setSign(CnaeonSignature.sign(params, this.salt));
        ServiceResponse response = this.cnaeonCentreService.couponBackPay(this.restTemplate, session, JSON.toJSONString((Object)backPayReqest));
        return this.callBackPayServiceHandle(response, session, 0, cacheModel, in, backPayReqest);
    }

    private ServiceResponse callBackPayServiceHandle(ServiceResponse response, ServiceSession session, int queryTimes, CacheModel cacheModel, CnaeonCouponBackPayIn in, CouponBackPayReqest backPayReqest) {
        LOGGER.info("callTransQueryServiceHandle start !queryTimes =[{}] ,serviceType=[{}]", (Object)queryTimes);
        boolean flag = true;
        if ("0".equals(response.getReturncode())) {
            BaseResponse cnaeonResp = (BaseResponse)response.getData();
            if (!"200".equals(cnaeonResp.getCode().toString())) {
                LOGGER.info("\u4e2d\u53f0\u63a5\u53e3\u8fd4\u56de\u5931\u8d25-\u5c1d\u8bd5\u53d1\u9001MQ");
                response = this.cnaeonCentreService.couponBackPayMQ(this.restTemplate, session, JSON.toJSONString((Object)backPayReqest));
                if (!"0".equals(response.getReturncode())) {
                    LOGGER.info("MQ\u8c03\u7528\u5931\u8d25-\u8bb0\u5f55\u672c\u5730\u6587\u4ef6");
                    flag = this.couponReverseService.save(session, (JSONObject)JSONObject.toJSON((Object)backPayReqest));
                }
            }
        } else {
            LOGGER.info("\u4e2d\u53f0\u63a5\u53e3\u8c03\u7528\u5931\u8d25-\u5c1d\u8bd5\u53d1\u9001MQ");
            response = this.cnaeonCentreService.couponBackPayMQ(this.restTemplate, session, JSON.toJSONString((Object)backPayReqest));
            if (!"0".equals(response.getReturncode())) {
                LOGGER.info("MQ\u8c03\u7528\u5931\u8d25-\u8bb0\u5f55\u672c\u5730\u6587\u4ef6");
                flag = this.couponReverseService.save(session, (JSONObject)JSONObject.toJSON((Object)backPayReqest));
            }
        }
        if (!flag) {
            LOGGER.info("MQ\u8bb0\u5f55\u672c\u5730\u6587\u4ef6\u5931\u8d25");
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u7535\u5b50\u5238\u5220\u9664\u5931\u8d25");
        }
        LOGGER.info("\u5220\u9664\u4ed8\u6b3e\u884c\u548c\u5238\u5206\u644a");
        cacheModel = this.delPayment(cacheModel, session, in);
        if (cacheModel.getCalcResult() == -1) {
            String errCode = "100000";
            if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                errCode = cacheModel.getErrCode();
            }
            return ServiceResponse.buildFailure((ServiceSession)session, (String)errCode, (String)cacheModel.getErrMsg());
        }
        LOGGER.info("\u5238\u51b2\u6b63\u66f4\u65b0\u7f13\u5b58");
        this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
        BaseOutModel out = new BaseOutModel();
        out.setOrder(OrderForPos.toOrderForPos(cacheModel));
        return ServiceResponse.buildSuccess((Object)out);
    }

    public CacheModel delPayment(CacheModel cacheModel, ServiceSession session, CnaeonCouponBackPayIn in) {
        for (String puid : in.getPuidlist()) {
            Payment PreDeletePayment = new Payment();
            for (Payment p : cacheModel.getPayments()) {
                if (!p.getPuid().equals(puid)) continue;
                PreDeletePayment = (Payment)p.clone();
                break;
            }
            LOGGER.info("\u64a4\u9500\u5220\u9664Payment[{}]", (Object)JSON.toJSONString((Object)PreDeletePayment));
            if (StringUtils.isEmpty((String)PreDeletePayment.getPuid())) continue;
            RemovePayIn removePayIn = new RemovePayIn();
            removePayIn.setCalcBillid(cacheModel.getOrder().getSeqNo());
            removePayIn.setChannelId(cacheModel.getOrder().getChannel());
            removePayIn.setRownoId(PreDeletePayment.getRownoId());
            this.promotionCentreService.removePay(this.restTemplate, session, removePayIn);
            LOGGER.info("\u8425\u9500\u5238\u652f\u4ed8\u884c\u5220\u9664PayNo=[{}]", (Object)PreDeletePayment.getPayNo());
            Iterator<Payment> it = cacheModel.getPayments().iterator();
            if (it.hasNext()) {
                Payment itPay = it.next();
                LOGGER.info("\u539fPayment[{}]", (Object)JSON.toJSONString((Object)itPay));
                if (PreDeletePayment.getPuid().equals(itPay.getPuid())) {
                    LOGGER.info("\u64a4\u9500\u4ed8\u6b3e\u884cpuid=[{}]", (Object)itPay.getPuid());
                    it.remove();
                }
            }
            LOGGER.info("\u64a4\u9500\u5238\u5206\u644aPayNo=[{}]", (Object)PreDeletePayment.getPayNo());
            CnaeonCouponPayIn.removePopUseList(cacheModel, PreDeletePayment.getPayNo());
        }
        LOGGER.info("\u8ba1\u7b97\u5269\u4f59\u5f85\u652f\u4ed8");
        cacheModel = this.posLogicServiceImpl.CalcOrderAmountByDeletePayReturn(cacheModel);
        this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
        return cacheModel;
    }

    @Override
    public ServiceResponse saleRepealPay(ServiceSession session, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        CnaeonCouponBackPayIn in = (CnaeonCouponBackPayIn)JSON.parseObject((String)paramsObject.toJSONString(), CnaeonCouponBackPayIn.class);
        String emptypara = ParamsValidateUtils.getNullField(in);
        if (!StringUtils.isEmpty((String)emptypara)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u64a4\u9500\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{emptypara});
        }
        if (StringUtils.isEmpty((String)in.getOrderNo()) && StringUtils.isEmpty((String)in.getRefundNo())) {
            ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u64a4\u9500\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u8ba2\u5355\u53f7\u6216\u8005\u9000\u6b3e\u8ba2\u5355\u53f7"});
        }
        LOGGER.info("saleRepealPay,\u5165\u53c2\u2014\u2014\u2014\u2014>[{}]", (Object)JSON.toJSONString((Object)in));
        CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(paramsObject.getString("flowNo"));
        String orgId = cacheModel.getOrder().getOrgId();
        if (StringUtils.isEmpty((String)orgId)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4ece\u603b\u90e8\u83b7\u53d6\u6cd5\u4eba\u516c\u53f8\u4ee3\u7801\u5931\u8d25");
        }
        this.salt = cacheModel.getOrder().getSysPara().getZtKey();
        if (StringUtils.isEmpty((String)this.salt)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4ece\u603b\u90e8\u83b7\u53d6\u4e2d\u53f0\u7b7e\u540dkey\u5931\u8d25");
        }
        cacheModel = this.posLogicServiceImpl.calcBalance(cacheModel);
        CouponCannelPayReqest backPayReqest = new CouponCannelPayReqest(in, cacheModel);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tokenId", backPayReqest.getTokenId());
        params.put("timestamp", backPayReqest.getTimestamp());
        params.put("orgId", backPayReqest.getOrgId());
        params.put("regionalCode", backPayReqest.getRegionalCode());
        params.put("storeCode", backPayReqest.getStoreCode());
        params.put("orderNo", backPayReqest.getOrderNo());
        params.put("originalOrderNo", backPayReqest.getOriginalOrderNo());
        backPayReqest.setSign(CnaeonSignature.sign(params, this.salt));
        ServiceResponse response = this.cnaeonCentreService.couponCannelPay(this.restTemplate, session, JSON.toJSONString((Object)backPayReqest));
        return this.callCannelPayServiceHandle(response, session, 0, cacheModel, in);
    }

    private ServiceResponse callCannelPayServiceHandle(ServiceResponse response, ServiceSession session, int queryTimes, CacheModel cacheModel, CnaeonCouponBackPayIn in) {
        LOGGER.info("callCannelPayServiceHandle start !queryTimes =[{}] ,serviceType=[{}]", (Object)queryTimes);
        List<Payment> voidPayList = cacheModel.getReturnPayments();
        LOGGER.info("[" + in.getFlowNo() + "]saleRepealPay returnPayments-->[{}]", (Object)JSON.toJSONString(voidPayList));
        List<Payment> voidPay = CnaeonCouponBackPayIn.creatVoidPayment(in, voidPayList, cacheModel);
        LOGGER.info("\u6d88\u5355\u9000\u8d27\u7c7b\u578b\uff1a" + cacheModel.getOrder().getOrderType());
        if (!"4".equals(cacheModel.getOrder().getOrderType())) {
            LOGGER.info("\u6839\u636e\u5238\u5e73\u53f0\u8fd4\u56de\u4fe1\u606f\u751f\u6210\u652f\u4ed8\u884c");
            for (int i = 0; i < voidPay.size(); ++i) {
                LOGGER.info("\u5238\u5e73\u53f0\u8fd4\u56de\u4fe1\u606f\u751f\u6210Payment[{}]", (Object)JSON.toJSONString((Object)voidPay.get(i)));
                cacheModel = this.posLogicServiceImpl.calcPayAmout(cacheModel, voidPay.get(i));
            }
        }
        if ("0".equals(response.getReturncode())) {
            BaseResponse cnaeonResp = (BaseResponse)response.getData();
            if (!"200".equals(cnaeonResp.getCode().toString())) {
                cacheModel.getOrder().setReturnCouponFlag(1);
                LOGGER.info("\u5238\u64a4\u9500\u5f02\u5e38\uff1a" + cnaeonResp.getMessage());
            }
        } else {
            cacheModel.getOrder().setReturnCouponFlag(1);
        }
        this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
        BaseOutModel out = new BaseOutModel();
        out.setOrder(OrderForPos.toOrderForPos(cacheModel));
        return ServiceResponse.buildSuccess((Object)out);
    }

    private String getOrgid(ServiceSession session, String erpCode, String shopCode) {
        HashMap<String, String> params = new HashMap<String, String>();
        String orgid = "";
        params.put("erpCode", erpCode);
        params.put("shopCode", shopCode);
        try {
            ServiceResponse resp = this.mainDataCentreService.getSubCompanyByShop(this.restTemplate, session, JSON.toJSONString(params));
            if ("0".equals(resp.getReturncode())) {
                List subCompanys = (List)resp.getData();
                orgid = ((SubCompany)subCompanys.get(0)).getCompanyCode();
            }
        }
        catch (Exception e) {
            LOGGER.info("\u83b7\u53d6\u5b50\u516c\u53f8\u7f16\u7801\u5f02\u5e38:" + e.getMessage());
        }
        return orgid;
    }

    public static List<Payment> creatPayment(Payment paymentTemp, String CouponNo) {
        ArrayList<Payment> payments = new ArrayList<Payment>();
        Payment pay = (Payment)paymentTemp.clone();
        pay.setPuid(UUIDUtils.buildPuid());
        pay.setRownoId(pay.getPuid());
        pay.setCreditsFlag(paymentTemp.getCreditsFlag());
        pay.setInvoiceFlag(paymentTemp.getInvoiceFlag());
        pay.setPayCode(paymentTemp.getPayCode());
        pay.setPayName(paymentTemp.getPayName());
        pay.setMoney(1.0);
        pay.setAmount(1.0);
        pay.setPayNo(CouponNo);
        pay.setAccntNo(CouponNo);
        pay.setCouponGroup("A02");
        pay.setCouponType("2");
        pay.setCouponEventId(172L);
        pay.setRefCode(paymentTemp.getRefCode());
        pay.setAlreadyAllot(true);
        pay.setRowno(pay.getRowno());
        pay.setDescription("\u7535\u5b50\u5238");
        payments.add(pay);
        return payments;
    }

    private ServiceResponse callTestTransServiceHandle(Payment pay, CacheModel cacheModel, String Coupon2) {
        LOGGER.info("callTransQueryServiceHandle start !queryTimes =[{}] ,serviceType=[{}]", (Object)0);
        List<Payment> realPayList = CnaeonCouponServiceImpl.creatPayment(pay, Coupon2);
        for (int i = 0; i < realPayList.size(); ++i) {
            cacheModel = this.posLogicServiceImpl.calcPayAmout(cacheModel, realPayList.get(i));
        }
        this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
        BaseOutModel out = new BaseOutModel();
        out.setOrder(OrderForPos.toOrderForPos(cacheModel));
        return ServiceResponse.buildSuccess((Object)out);
    }
}

