/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pos.component;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.pos.component.CommonService;
import com.efuture.pos.component.PosLogicCompoment;
import com.efuture.pos.component.PosLogicServiceImpl;
import com.efuture.pos.model.BaseOutModel;
import com.efuture.pos.model.CacheModel;
import com.efuture.pos.model.Coupon;
import com.efuture.pos.model.DeductedCoupon;
import com.efuture.pos.model.Goods;
import com.efuture.pos.model.Order;
import com.efuture.pos.model.OrderForPos;
import com.efuture.pos.model.Payment;
import com.efuture.pos.model.promotionCentre.SellCoupon;
import com.efuture.pos.model.promotionCentre.request.CouponActivatePIn;
import com.efuture.pos.model.promotionCentre.request.CouponPayIn;
import com.efuture.pos.model.promotionCentre.request.CouponPromotionDelayIn;
import com.efuture.pos.model.promotionCentre.request.CouponuseGetOnlineIn;
import com.efuture.pos.model.promotionCentre.response.CouponBuyQueryOut;
import com.efuture.pos.model.promotionCentre.response.CouponPayOut;
import com.efuture.pos.model.promotionCentre.response.CouponuseGetOnlineOut;
import com.efuture.pos.model.request.AddQrCodeTicketIn;
import com.efuture.pos.model.request.AddStampaCodeIn;
import com.efuture.pos.model.request.AddStampaTicketIn;
import com.efuture.pos.model.request.CouponActivateIn;
import com.efuture.pos.model.request.CouponActivitySearchIn;
import com.efuture.pos.model.request.CouponComsumeIn;
import com.efuture.pos.model.request.CouponDelayIn;
import com.efuture.pos.model.request.CouponQueryIn;
import com.efuture.pos.model.response.AddQrCodeOut;
import com.efuture.pos.model.response.AddStampaTicketOut;
import com.efuture.pos.model.response.CouponActivateOut;
import com.efuture.pos.model.response.CouponActivitySearchOut;
import com.efuture.pos.model.response.CouponComsumeOut;
import com.efuture.pos.service.CouponService;
import com.efuture.pos.service.common.CacheModelService;
import com.efuture.pos.util.ManipulatePrecision;
import com.efuture.pos.util.ParamsValidateUtils;
import com.efuture.pos.util.UUIDUtils;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.client.RestTemplate;

public class CouponServiceImpl
extends CommonService
implements CouponService {
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    CacheModelService cacheModelService;
    @Autowired
    PosLogicCompoment posLogicCompoment;
    @Autowired
    PosLogicServiceImpl posLogicServiceImpl;
    private static final Logger logger = LoggerFactory.getLogger(CouponServiceImpl.class);

    public ServiceResponse activitySearch(ServiceSession session, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        if (!paramsObject.containsKey((Object)"consumersId") || paramsObject.getString("consumersId").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4e70\u5238\u6d3b\u52a8\u67e5\u8be2\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u4f1a\u5458id"});
        }
        if (!paramsObject.containsKey((Object)"consumersType") || paramsObject.getString("consumersType").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4e70\u5238\u6d3b\u52a8\u67e5\u8be2\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u4f1a\u5458\u7c7b\u578b"});
        }
        if (!paramsObject.containsKey((Object)"promotionType") || paramsObject.getString("promotionType").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4e70\u5238\u6d3b\u52a8\u67e5\u8be2\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u6d3b\u52a8\u7c7b\u578b"});
        }
        if (!paramsObject.containsKey((Object)"certifyType") || paramsObject.getString("certifyType").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4e70\u5238\u6d3b\u52a8\u67e5\u8be2\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}],\u9ed8\u8ba4\u4f20ERP", (Object[])new Object[]{"certifyType"});
        }
        CouponActivitySearchIn couponActivitySearchIn = (CouponActivitySearchIn)JSON.parseObject((String)paramsObject.toJSONString(), CouponActivitySearchIn.class);
        String flowNo = couponActivitySearchIn.getFlowNo();
        CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(flowNo);
        if (null == cacheModel) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u7f13\u5b58\u4e0d\u5b58\u5728\uff01");
        }
        ServiceResponse resp = this.promotionCentreService.couponBuyQuery(this.restTemplate, session, couponActivitySearchIn);
        if (!"0".equals(resp.getReturncode())) {
            return resp;
        }
        JSONObject obj = (JSONObject)resp.getData();
        List buyCouponList = JSON.parseArray((String)obj.getJSONArray("datalist").toJSONString(), CouponBuyQueryOut.class);
        if (CollectionUtils.isNotEmpty((Collection)buyCouponList)) {
            ArrayList<Coupon> couponList = new ArrayList<Coupon>(buyCouponList.size());
            Coupon coupon = null;
            for (CouponBuyQueryOut c : buyCouponList) {
                coupon = new Coupon();
                coupon.setGuid(UUIDUtils.buildGuid());
                coupon.setCash(c.getCash());
                coupon.setCouponDesc(c.getCouponDesc());
                coupon.setCouponExp(c.getCouponExp());
                coupon.setCouponName(c.getCouponName());
                coupon.setRestNumDay(c.getRestNumDay());
                coupon.setFaceValue(c.getFaceValue());
                coupon.setExpDate(c.getEventExpDate());
                coupon.setEventId(Long.parseLong(c.getEventId()));
                coupon.setTotnum(c.getTotnum());
                coupon.setCouponRule(c.getCouponRule());
                couponList.add(coupon);
            }
            cacheModel.setQueryBuyCouponList(couponList);
            this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
            CouponActivitySearchOut couponActivitySearchOut = new CouponActivitySearchOut(couponList);
            return ServiceResponse.buildSuccess((Object)couponActivitySearchOut);
        }
        return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u6ca1\u6709\u67e5\u5230\u53ef\u4e70\u5238\u5217\u8868");
    }

    public ServiceResponse pay(ServiceSession session, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        if (!paramsObject.containsKey((Object)"buyCouponList") || paramsObject.getJSONArray("buyCouponList").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4e70\u5238\u6d3b\u52a8\u67e5\u8be2\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u4e70\u5238\u5217\u8868"});
        }
        String flowNo = paramsObject.getString("flowNo");
        CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(flowNo);
        if (null == cacheModel) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u7f13\u5b58\u4e0d\u5b58\u5728\uff01");
        }
        JSONArray buyCouponArr = paramsObject.getJSONArray("buyCouponList");
        JSONObject buyCouponObj = buyCouponArr.getJSONObject(0);
        Integer qty = buyCouponObj.getInteger("qty");
        String guid = buyCouponObj.getString("guid");
        List<Coupon> buyCouponList = cacheModel.getQueryBuyCouponList();
        if (null == buyCouponList) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4e70\u5238\u5217\u8868\u4e3a\u7a7a\uff01");
        }
        Coupon buyCoupon = buyCouponList.parallelStream().filter(c -> c.getGuid().equals(guid)).findFirst().get();
        if (null == buyCoupon) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u627e\u4e0d\u5230\u6307\u5b9a\u7684\u5238\uff01");
        }
        double amount = buyCoupon.getCash() * (double)qty.intValue();
        Goods couponGoods = new Goods();
        couponGoods.setGuid(buyCoupon.getGuid());
        couponGoods.setGoodsCode(String.valueOf(buyCoupon.getEventId()));
        couponGoods.setGoodsName(buyCoupon.getCouponName());
        couponGoods.setSalePrice(buyCoupon.getCash());
        couponGoods.setGoodsType("0");
        couponGoods.setGoodsNo(String.valueOf(buyCoupon.getEventId()));
        couponGoods.setQty(qty.intValue());
        couponGoods.setSaleValue(amount);
        buyCoupon.setQty(qty.intValue());
        buyCoupon.setAmount(amount);
        List<Goods> cachedGoodsList = cacheModel.getGoodsList();
        if (cachedGoodsList == null) {
            cachedGoodsList = new ArrayList<Goods>();
        }
        cachedGoodsList.add(couponGoods);
        cacheModel.setGoodsList(cachedGoodsList);
        cacheModel.setQueryBuyCouponList(new ArrayList<Coupon>());
        this.posLogicCompoment.calcOrderAmount(cacheModel);
        this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
        BaseOutModel out = new BaseOutModel();
        out.setOrder(OrderForPos.toOrderForPos(cacheModel));
        return ServiceResponse.buildSuccess((Object)out);
    }

    public ServiceResponse consume(ServiceSession session, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        if (!paramsObject.containsKey((Object)"sellPayment") || paramsObject.getJSONArray("sellPayment").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5238\u6838\u9500\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u652f\u4ed8\u5217\u8868"});
        }
        if (!paramsObject.containsKey((Object)"scene") || paramsObject.getString("scene").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5238\u6838\u9500\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u652f\u4ed8\u7c7b\u578b"});
        }
        CouponComsumeIn in = (CouponComsumeIn)JSON.toJavaObject((JSON)paramsObject, CouponComsumeIn.class);
        if (CollectionUtils.isEmpty(in.getSellPayment())) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5238\u6838\u9500\u4f20\u5165\u53c2\u6570[{0}]\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{"\u79ef\u5206\u5217\u8868"});
        }
        CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(in.getFlowNo());
        if (cacheModel == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u627e\u4e0d\u5230[{0}]\uff01", (Object[])new Object[]{"\u7f13\u5b58"});
        }
        List<Payment> inPayment = in.getSellPayment();
        List<Payment> cachePayments = cacheModel.getPayments();
        if (null == cachePayments) {
            cachePayments = new ArrayList<Payment>();
        }
        int offset = cachePayments.size();
        ArrayList<DeductedCoupon> coupons = new ArrayList<DeductedCoupon>();
        if (null != cacheModel.getDeductedCoupons()) {
            for (int i = 0; i < cacheModel.getDeductedCoupons().size(); ++i) {
                coupons.add((DeductedCoupon)cacheModel.getDeductedCoupons().get(i).clone());
            }
        }
        String scene = in.getScene();
        for (Payment p : inPayment) {
            if ("3".equals(scene)) {
                if (null == coupons || coupons.size() <= 0) continue;
                for (int i = 0; i < coupons.size(); ++i) {
                    DeductedCoupon deductedCoupon = (DeductedCoupon)coupons.get(i);
                    if (!deductedCoupon.getCoptype().equals(p.getCouponType())) continue;
                    if (p.getMoney() > deductedCoupon.getMoney()) {
                        return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)("\u5238" + p.getPayName() + "\u6263\u56de\u91d1\u989d\u5927\u4e8e" + deductedCoupon.getMoney() + ",\u4e0d\u5141\u8bb8\u6263\u56de"));
                    }
                    deductedCoupon.setMoney(deductedCoupon.getMoney() - p.getMoney());
                    break;
                }
            }
            p.setPuid(UUIDUtils.buildPuid());
            p.setRownoId(p.getPuid());
            p.setIsCoupon("Y");
            p.setRowno(++offset);
            p.setIsDirectDel(true);
            if ("3".equals(scene)) {
                p.setFlag("3");
            } else {
                p.setFlag("1");
            }
            if (null != p.getPaymentSource()) {
                String PaymentSource = "";
                if (p.getPaymentSource().length() <= 1) {
                    PaymentSource = " ";
                } else if (p.getPaymentSource().length() > 1) {
                    PaymentSource = "" + p.getPaymentSource().charAt(1);
                }
                p.setPaymentSource("Y" + PaymentSource);
            } else {
                p.setPaymentSource("Y ");
            }
            cachePayments.add(p);
            double khAmount = p.getMoney();
            String poptype = "";
            for (int i = 0; i < cacheModel.getTempSalePayments().size() && p.getMoney() > 0.0; ++i) {
                Payment sp = cacheModel.getTempSalePayments().get(i);
                if (!sp.getPopFlag().equals("1") || null == sp.getPayType() || !sp.getPayType().equals("FQKH") || !sp.getPayCode().equals("SYTK") || !sp.getCouponType().equals(p.getCouponType()) || !(sp.getMoney() > 0.0)) continue;
                if (ManipulatePrecision.doubleCompare(sp.getMoney() + (khAmount += sp.getMoney()), 0.0, 2) < 0) {
                    sp.setMoney(sp.getMoney() + p.getMoney());
                    sp.setAmount(sp.getAmount() + p.getAmount());
                } else {
                    sp.setMoney(0.0);
                    sp.setAmount(0.0);
                }
                if (!StringUtils.isNotBlank((String)sp.getPopFlag())) continue;
                poptype = "" + sp.getPopFlag().charAt(0);
            }
            Payment spkh = (Payment)p.clone();
            spkh.setPayType("FQKH");
            spkh.setPayCode("FQKH");
            spkh.setAmount(spkh.getAmount() * -1.0);
            spkh.setMoney(spkh.getMoney() * -1.0);
            spkh.setFlag(poptype);
            spkh.setPopFlag(poptype);
            spkh.setRowno(cacheModel.getTempSalePayments().size() + 1);
            cacheModel.getTempSalePayments().add(spkh);
        }
        Integer calcResult = (cacheModel = this.posLogicCompoment.calcPayBalance(cacheModel)).getCalcResult();
        if (calcResult != null && calcResult == -1) {
            String errCode = "100000";
            if (cacheModel.getErrCode().length() > 0) {
                errCode = cacheModel.getErrCode();
            }
            return ServiceResponse.buildFailure((ServiceSession)session, (String)errCode, (String)cacheModel.getErrMsg());
        }
        Order order = cacheModel.getOrder();
        CouponComsumeOut couponComsumeOut = new CouponComsumeOut();
        couponComsumeOut.setExistPay(order.getExistPay());
        couponComsumeOut.setOughtPay(order.getOughtPay());
        couponComsumeOut.setOverageValue(order.getOverageValue());
        couponComsumeOut.setRemainValue(order.getRemainValue());
        couponComsumeOut.setPayments(cacheModel.getPayments());
        cacheModel.setDeductedCoupons(coupons);
        this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
        BaseOutModel out = new BaseOutModel();
        out.setOrder(OrderForPos.toOrderForPos(cacheModel));
        return ServiceResponse.buildSuccess((Object)out);
    }

    public ServiceResponse addStampaCode(ServiceSession session, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        if (StringUtils.isBlank((String)paramsObject.getString("discountCode"))) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5f55\u5165\u5370\u82b1\u7801\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u5370\u82b1\u7801"});
        }
        AddStampaCodeIn addStampaCodeIn = (AddStampaCodeIn)JSON.parseObject((String)paramsObject.toJSONString(), AddStampaCodeIn.class);
        if (addStampaCodeIn == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5165\u53c2\u8f6c\u6362\u5931\u8d25\uff01");
        }
        CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(addStampaCodeIn.getFlowNo());
        if (cacheModel == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355!", (Object[])new Object[]{addStampaCodeIn.getFlowNo()});
        }
        List<Goods> goods = cacheModel.getGoodsList();
        if (goods == null || goods.size() == 0) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u6ca1\u6709\u5546\u54c1\u4e0d\u5141\u8bb8\u5f55\u5165\u5370\u82b1\u7801!");
        }
        CacheModel respCacheModel = this.posLogicServiceImpl.CalcGoodsAmountAfterStampCode(cacheModel, addStampaCodeIn.getDiscountCode());
        if (respCacheModel.getCalcResult() != null && respCacheModel.getCalcResult() == -1 && StringUtils.isNotBlank((String)respCacheModel.getErrMsg())) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)("\u5f55\u5165\u5370\u82b1\u7801\u51fa\u9519:" + respCacheModel.getErrMsg()));
        }
        this.cacheModelService.saveOrUpdateCacheModel(respCacheModel);
        BaseOutModel out = new BaseOutModel();
        out.setOrder(OrderForPos.toOrderForPos(respCacheModel));
        return ServiceResponse.buildSuccess((Object)out);
    }

    public ServiceResponse addStampaTicket(ServiceSession session, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        if (StringUtils.isBlank((String)paramsObject.getString("payCode"))) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5f55\u5165\u5370\u82b1\u5238\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u4ed8\u6b3e\u65b9\u5f0f\u4ee3\u7801"});
        }
        if (StringUtils.isBlank((String)paramsObject.getString("discountCode"))) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5f55\u5165\u5370\u82b1\u5238\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u5370\u82b1\u5238"});
        }
        AddStampaTicketIn addStampaTicketIn = (AddStampaTicketIn)JSON.parseObject((String)paramsObject.toJSONString(), AddStampaTicketIn.class);
        if (addStampaTicketIn == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5165\u53c2\u8f6c\u6362\u5931\u8d25\uff01");
        }
        CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(addStampaTicketIn.getFlowNo());
        if (cacheModel == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355!", (Object[])new Object[]{addStampaTicketIn.getFlowNo()});
        }
        if (cacheModel.getOrder() == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355\u4e3b\u4f53\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        session.setEnt_id(cacheModel.getOrder().getEntId());
        List<Goods> goods = cacheModel.getGoodsList();
        if (goods == null || goods.size() == 0) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u6ca1\u6709\u5546\u54c1\u4e0d\u5141\u8bb8\u5f55\u5165\u5370\u82b1\u5238!");
        }
        ServiceResponse response = this.promotionCentreService.couponusePay(this.restTemplate, session, new CouponPayIn().transferAddStampaTicketIn(cacheModel, addStampaTicketIn));
        if (!"0".equals(response.getReturncode().trim())) {
            return response;
        }
        if (response.getData() == null) {
            ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5238\u652f\u4ed8\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a!");
        }
        CouponPayOut couponPayOut = (CouponPayOut)response.getData();
        AddStampaTicketOut addStampaTicketOut = couponPayOut.transferToAddStampaTicketOut();
        List<Payment> sellPayment = addStampaTicketOut.getSellPayment();
        for (Payment payment : sellPayment) {
            payment.setIsCoupon("Y");
            payment.setIsDirectDel(true);
        }
        cacheModel = this.cacheModelService.addPayments(addStampaTicketIn.getFlowNo(), sellPayment);
        cacheModel = this.posLogicCompoment.RefreshAfterCouponPay(cacheModel, couponPayOut);
        this.posLogicCompoment.calcPayBalance(cacheModel);
        Integer calcResult = cacheModel.getCalcResult();
        if (calcResult != null && calcResult == -1) {
            String errCode = "100000";
            if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                errCode = cacheModel.getErrCode();
            }
            return ServiceResponse.buildFailure((ServiceSession)session, (String)errCode, (String)cacheModel.getErrMsg());
        }
        Order order = cacheModel.getOrder();
        this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
        addStampaTicketOut.setExistPay(order.getExistPay());
        addStampaTicketOut.setOughtPay(order.getOughtPay());
        addStampaTicketOut.setOverageValue(order.getOverageValue());
        addStampaTicketOut.setRemainValue(order.getRemainValue());
        addStampaTicketOut.setSellPayment(cacheModel.getPayments());
        return ServiceResponse.buildSuccess((Object)addStampaTicketOut);
    }

    public ServiceResponse query(ServiceSession session, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        if (StringUtils.isBlank((String)paramsObject.getString("channel"))) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5238\u67e5\u8be2\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u8425\u9500\u6e20\u9053"});
        }
        if (StringUtils.isBlank((String)paramsObject.getString("terminalSno"))) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5238\u67e5\u8be2\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u5c0f\u7968\u53f7"});
        }
        if (StringUtils.isBlank((String)paramsObject.getString("scene"))) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5238\u67e5\u8be2\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u4ed8\u6b3e\u6807\u5fd7"});
        }
        if (StringUtils.isBlank((String)paramsObject.getString("payCode"))) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5238\u67e5\u8be2\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u4ed8\u6b3e\u4ee3\u7801"});
        }
        if (StringUtils.isBlank((String)paramsObject.getString("consumersId"))) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5238\u67e5\u8be2\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u4f1a\u5458\u53f7"});
        }
        if (StringUtils.isBlank((String)paramsObject.getString("couponGroup"))) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5238\u67e5\u8be2\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u6307\u5b9a\u7c7b\u578b"});
        }
        if (StringUtils.isBlank((String)paramsObject.getString("distinct"))) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5238\u67e5\u8be2\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u662f\u5426\u5408\u5e76\u5c55\u793a"});
        }
        CouponQueryIn couponQueryIn = (CouponQueryIn)JSON.parseObject((String)paramsObject.toJSONString(), CouponQueryIn.class);
        if (couponQueryIn == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5165\u53c2\u8f6c\u6362\u5931\u8d25\uff01");
        }
        CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(couponQueryIn.getFlowNo());
        if (cacheModel == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355!", (Object[])new Object[]{couponQueryIn.getFlowNo()});
        }
        if (cacheModel.getOrder() == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355\u4e3b\u4f53\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        session.setEnt_id(cacheModel.getOrder().getEntId());
        ServiceResponse response = this.promotionCentreService.couponuseGetOnline(this.restTemplate, session, CouponuseGetOnlineIn.transferCouponGetIn(cacheModel, couponQueryIn));
        if ("0".equals(response.getReturncode())) {
            if ("3".equals(couponQueryIn.getScene()) && null != response.getData()) {
                CouponuseGetOnlineOut out = (CouponuseGetOnlineOut)response.getData();
                List<SellCoupon> couponUses = out.getCouponUses();
                if (null == cacheModel.getDeductedCoupons()) {
                    couponUses.clear();
                    out.setCouponUses(couponUses);
                } else if (null != couponUses) {
                    for (int i = 0; i < couponUses.size(); ++i) {
                        SellCoupon coupon = couponUses.get(i);
                        String copType = coupon.getCouponType();
                        boolean isReturn = false;
                        for (int j = 0; j < cacheModel.getDeductedCoupons().size(); ++j) {
                            DeductedCoupon deductedCoupon = cacheModel.getDeductedCoupons().get(j);
                            if (!copType.equals(deductedCoupon.getCoptype())) continue;
                            double allowje = coupon.getAvailable() * coupon.getRate();
                            ManipulatePrecision.doubleConvert(allowje, 2, 1);
                            if (!(deductedCoupon.getMoney() < allowje)) continue;
                            coupon.setAvailable(ManipulatePrecision.doubleConvert(deductedCoupon.getMoney() / coupon.getRate(), 2, 1));
                            couponUses.set(i, coupon);
                            isReturn = true;
                        }
                        if (isReturn) continue;
                        couponUses.remove(i);
                        --i;
                    }
                }
            }
            List<Coupon> coupons = ((CouponuseGetOnlineOut)response.getData()).transferToCoupon();
            cacheModel.getOrder().setCouponDetails(coupons);
            this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
            BaseOutModel out = new BaseOutModel();
            out.setOrder(OrderForPos.toOrderForPos(cacheModel));
            return ServiceResponse.buildSuccess((Object)out);
        }
        return response;
    }

    public ServiceResponse activate(ServiceSession session, JSONObject paramsObject) {
        if (!paramsObject.containsKey((Object)"shopCode") || paramsObject.getString("shopCode").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5238\u6fc0\u6d3b\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u95e8\u5e97\u53f7"});
        }
        if (!paramsObject.containsKey((Object)"terminalNo") || paramsObject.getString("terminalNo").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5238\u6fc0\u6d3b\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u7ec8\u7aef\u53f7"});
        }
        if (!paramsObject.containsKey((Object)"terminalOperator") || paramsObject.getString("terminalOperator").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5238\u6fc0\u6d3b\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u64cd\u4f5c\u5458\u53f7"});
        }
        if (!paramsObject.containsKey((Object)"channel") || paramsObject.getString("channel").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5238\u6fc0\u6d3b\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u8425\u9500\u6e20\u9053"});
        }
        if (!paramsObject.containsKey((Object)"consumersId") || paramsObject.getString("consumersId").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5238\u6fc0\u6d3b\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u4f1a\u5458id"});
        }
        if (!paramsObject.containsKey((Object)"accntNo") || paramsObject.getString("accntNo").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5238\u6fc0\u6d3b\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u5238\u53f7"});
        }
        if (!paramsObject.containsKey((Object)"expDate") || paramsObject.getString("expDate").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5238\u6fc0\u6d3b\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u5931\u6548\u65e5\u671f"});
        }
        if (!paramsObject.containsKey((Object)"effDate") || paramsObject.getString("effDate").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5238\u6fc0\u6d3b\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u751f\u6548\u65e5\u671f"});
        }
        CouponActivateIn in = (CouponActivateIn)JSON.toJavaObject((JSON)paramsObject, CouponActivateIn.class);
        ServiceResponse resp = this.promotionCentreService.couponActivate(this.restTemplate, session, new CouponActivatePIn(in));
        if (!"0".equals(resp.getReturncode())) {
            return resp;
        }
        String accntNo = (String)resp.getData();
        return ServiceResponse.buildSuccess((Object)new CouponActivateOut(accntNo));
    }

    public ServiceResponse delay(ServiceSession session, JSONObject paramsObject) {
        if (!paramsObject.containsKey((Object)"shopCode") || paramsObject.getString("shopCode").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5238\u53f7\u5ef6\u671f\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u95e8\u5e97\u7f16\u7801"});
        }
        if (!paramsObject.containsKey((Object)"terminalNo") || paramsObject.getString("terminalNo").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5238\u53f7\u5ef6\u671f\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u6536\u94f6\u673a\u53f7"});
        }
        if (!paramsObject.containsKey((Object)"terminalOperator") || paramsObject.getString("terminalOperator").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5238\u53f7\u5ef6\u671f\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u6536\u94f6\u5458\u53f7"});
        }
        if (!paramsObject.containsKey((Object)"channel") || paramsObject.getString("channel").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5238\u53f7\u5ef6\u671f\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u6e20\u9053"});
        }
        if (!paramsObject.containsKey((Object)"expDate") || paramsObject.getString("expDate").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5238\u53f7\u5ef6\u671f\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u5ef6\u671f\u65e5\u671f"});
        }
        CouponDelayIn in = (CouponDelayIn)JSON.toJavaObject((JSON)paramsObject, CouponDelayIn.class);
        ServiceResponse resp = this.promotionCentreService.couponDelay(this.restTemplate, session, new CouponPromotionDelayIn(in));
        return resp;
    }

    public ServiceResponse couponpay(ServiceSession session, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        if (StringUtils.isBlank((String)paramsObject.getString("payCode"))) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5f55\u5165\u5238\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u4ed8\u6b3e\u65b9\u5f0f\u4ee3\u7801"});
        }
        if (StringUtils.isBlank((String)paramsObject.getString("qrCode"))) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5f55\u5165\u5238\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u5238\u53f7"});
        }
        AddQrCodeTicketIn addQrCodeIn = (AddQrCodeTicketIn)JSON.parseObject((String)paramsObject.toJSONString(), AddQrCodeTicketIn.class);
        if (addQrCodeIn == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5165\u53c2\u8f6c\u6362\u5931\u8d25\uff01");
        }
        CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(addQrCodeIn.getFlowNo());
        if (cacheModel == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355!", (Object[])new Object[]{addQrCodeIn.getFlowNo()});
        }
        if (cacheModel.getOrder() == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355\u4e3b\u4f53\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        session.setEnt_id(cacheModel.getOrder().getEntId());
        List<Goods> goods = cacheModel.getGoodsList();
        if (goods == null || goods.size() == 0) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u6ca1\u6709\u5546\u54c1\u4e0d\u5141\u8bb8\u5f55\u5165\u60e0go\u5238!");
        }
        ServiceResponse response = this.promotionCentreService.couponusePay(this.restTemplate, session, new CouponPayIn().transferAddQrCodeIn(cacheModel, addQrCodeIn));
        if (!"0".equals(response.getReturncode().trim())) {
            return response;
        }
        if (response.getData() == null) {
            ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5238\u652f\u4ed8\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a!");
        }
        CouponPayOut couponPayOut = (CouponPayOut)response.getData();
        AddQrCodeOut addQrCodeOut = couponPayOut.transferToAddQrCodeOut();
        List<Payment> sellPayment = addQrCodeOut.getSellPayment();
        for (Payment payment : sellPayment) {
            payment.setIsCoupon("Y");
            payment.setIsDirectDel(true);
        }
        cacheModel = this.cacheModelService.addPayments(addQrCodeIn.getFlowNo(), sellPayment);
        cacheModel = this.posLogicCompoment.RefreshAfterCouponPay(cacheModel, couponPayOut);
        cacheModel.getOrder().setSeqNo(((CouponPayOut)response.getData()).getCalcBillid());
        this.posLogicCompoment.calcPayBalance(cacheModel);
        Integer calcResult = cacheModel.getCalcResult();
        if (calcResult != null && calcResult == -1) {
            String errCode = "100000";
            if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                errCode = cacheModel.getErrCode();
            }
            return ServiceResponse.buildFailure((ServiceSession)session, (String)errCode, (String)cacheModel.getErrMsg());
        }
        Order order = cacheModel.getOrder();
        order.setCouponDetails(addQrCodeOut.getSellCoupon());
        this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
        BaseOutModel out = new BaseOutModel();
        out.setOrder(OrderForPos.toOrderForPos(cacheModel));
        return ServiceResponse.buildSuccess((Object)out);
    }
}

