/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pos.component;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.pos.component.CommonService;
import com.efuture.pos.component.OrderServiceImpl;
import com.efuture.pos.component.PosLogicCompoment;
import com.efuture.pos.component.PosLogicServiceImpl;
import com.efuture.pos.component.PromotionServiceImpl;
import com.efuture.pos.component.async.AsyncTask;
import com.efuture.pos.component.common.SellType;
import com.efuture.pos.component.common.WorkLogType;
import com.efuture.pos.component.common.YPopStatusType;
import com.efuture.pos.model.AnalyzeBarcodeDef;
import com.efuture.pos.model.BarcodeCacheModel;
import com.efuture.pos.model.BaseOutModel;
import com.efuture.pos.model.CacheModel;
import com.efuture.pos.model.DelGoodsInfo;
import com.efuture.pos.model.DzcGoodsDetail;
import com.efuture.pos.model.Goods;
import com.efuture.pos.model.GoodsBarcode;
import com.efuture.pos.model.GoodsForPos;
import com.efuture.pos.model.GoodsInfoForApp;
import com.efuture.pos.model.MealDetailForChoice;
import com.efuture.pos.model.MealGoodsInfoForPos;
import com.efuture.pos.model.MealInfoForChoice;
import com.efuture.pos.model.Order;
import com.efuture.pos.model.OrderForPos;
import com.efuture.pos.model.PopDetail;
import com.efuture.pos.model.PopDetailForApp;
import com.efuture.pos.model.SysPara;
import com.efuture.pos.model.SysParaInfo;
import com.efuture.pos.model.mainDataCentre.CategoryProperty;
import com.efuture.pos.model.mainDataCentre.GoodsInfo;
import com.efuture.pos.model.mainDataCentre.MealGoodsDetail;
import com.efuture.pos.model.mainDataCentre.MealGoodsInfo;
import com.efuture.pos.model.mainDataCentre.StallInfoDef;
import com.efuture.pos.model.mainDataCentre.request.GetGoodsDetailIn;
import com.efuture.pos.model.mainDataCentre.request.GetStallInfoListIn;
import com.efuture.pos.model.mainDataCentre.request.GetStallPrintInfoIn;
import com.efuture.pos.model.mainDataCentre.request.SearchMealDetailIn;
import com.efuture.pos.model.mainDataCentre.response.GetGoodsDetailOut;
import com.efuture.pos.model.mainDataCentre.response.GetStallPrintInfoOut;
import com.efuture.pos.model.mainDataCentre.response.SearchMealDetailOut;
import com.efuture.pos.model.posManager.ElecScaleCodeRule;
import com.efuture.pos.model.posManager.request.ElecScaleCodeRuleIn;
import com.efuture.pos.model.posManager.response.ElecScaleCodeRuleOut;
import com.efuture.pos.model.promotionCentre.BillDetail;
import com.efuture.pos.model.promotionCentre.SellDetail;
import com.efuture.pos.model.promotionCentre.SellPopDetail;
import com.efuture.pos.model.promotionCentre.request.CalcsingleIn;
import com.efuture.pos.model.promotionCentre.response.CalcsingleOut;
import com.efuture.pos.model.request.AddBatchGoodsInDef;
import com.efuture.pos.model.request.ChoiceMealGoodsIn;
import com.efuture.pos.model.request.CreateBillIn;
import com.efuture.pos.model.request.DelCartGoodsIn;
import com.efuture.pos.model.request.DelDesignCartGoodsIn;
import com.efuture.pos.model.request.GetMealGoodsInfoIn;
import com.efuture.pos.model.request.GetSaleGoodsInfoIn;
import com.efuture.pos.model.request.GetStallListIn;
import com.efuture.pos.model.request.GetStallPrintConfigIn;
import com.efuture.pos.model.request.QueryGoodIn;
import com.efuture.pos.model.request.SingleDiscAmountIn;
import com.efuture.pos.model.request.UpdateCartGoodsIn;
import com.efuture.pos.model.response.ChoiceMealGoodsOut;
import com.efuture.pos.model.response.GetGoodsForApplOut;
import com.efuture.pos.model.response.GetMealGoodsInfoOut;
import com.efuture.pos.model.response.GetSaleGoodsInfoOut;
import com.efuture.pos.model.response.GetStallPrintConfigOut;
import com.efuture.pos.model.response.UpdateCartGoodsOut;
import com.efuture.pos.service.GoodsService;
import com.efuture.pos.service.common.BarcodeCacheModelService;
import com.efuture.pos.service.common.CacheModelService;
import com.efuture.pos.util.CastUtil;
import com.efuture.pos.util.Convert;
import com.efuture.pos.util.DataExchageUtils;
import com.efuture.pos.util.ManipulatePrecision;
import com.efuture.pos.util.ParamsValidateUtils;
import com.efuture.pos.util.UUIDUtils;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.client.RestTemplate;

public class GoodsServiceImpl
extends CommonService
implements GoodsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(GoodsServiceImpl.class);
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    CacheModelService cacheModelService;
    @Autowired
    BarcodeCacheModelService barcodeCacheModelService;
    @Autowired
    PosLogicServiceImpl posLogicService;
    @Autowired
    PosLogicCompoment posLogicCompoment;
    @Autowired
    OrderServiceImpl orderService;
    @Autowired
    PosLogicServiceImpl posLogicServiceImpl;
    @Autowired
    PromotionServiceImpl promotionServiceImpl;
    @Autowired
    AsyncTask asyncTask;

    @Override
    public ServiceResponse getSaleGoodsInfo(ServiceSession session, JSONObject paramsObject) {
        try {
            long startTime = System.currentTimeMillis();
            ServiceResponse validateData = this.getSaleGoodsInfoValidate(session, paramsObject);
            if (!"0".equals(validateData.getReturncode())) {
                return validateData;
            }
            GetSaleGoodsInfoIn getSaleGoodsInfoIn = (GetSaleGoodsInfoIn)JSONObject.toJavaObject((JSON)paramsObject, GetSaleGoodsInfoIn.class);
            String type = "A";
            CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(getSaleGoodsInfoIn.getFlowNo());
            if (cacheModel == null) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8d2d\u7269\u8f66\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\u4ea4\u6613\u6d41\u6c34\u53f7");
            }
            if (!cacheModel.getOrder().getAllowEditGoods()) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u8fdb\u5165\u652f\u4ed8\u73af\u8282\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u5546\u54c1", (Object[])new Object[]{getSaleGoodsInfoIn.getFlowNo()});
            }
            Order order = cacheModel.getOrder();
            session.setEnt_id(cacheModel.getOrder().getEntId());
            Goods goods = null;
            Object resp = null;
            boolean isdzcm = false;
            boolean isNeedFindDzc = true;
            boolean isNeedFindMdm = true;
            int priceMode = 0;
            String originalBarNo = getSaleGoodsInfoIn.getBarNo();
            int disMode = 0;
            double disValue = 0.0;
            int barNoMode = order.getSysPara().getBarCodeMode();
            String discType = "0";
            AnalyzeBarcodeDef codeInfo = null;
            if ("Y".equals(order.getSysPara().getAssistantMode()) && StringUtils.isNotBlank((String)cacheModel.getCurYyyInfo().getYyygz()) && !this.posLogicCompoment.checkYyyRange(cacheModel.getCurYyyInfo(), order.getSysPara().getAssistantMode(), getSaleGoodsInfoIn.getOrgCode())) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4f20\u5165\u67dc\u7ec4\u975e\u5f53\u524d\u8425\u4e1a\u5458\u8303\u56f4");
            }
            if ("N".equals(order.getSysPara().getAssistantMode())) {
                getSaleGoodsInfoIn.setOrgCode("");
            }
            DzcGoodsDetail dzc = new DzcGoodsDetail();
            GoodsInfo goodsInfo = null;
            GetGoodsDetailIn queryGoodIn = new GetGoodsDetailIn();
            List<GoodsInfo> goodsInfos = null;
            if ("1".equals(getSaleGoodsInfoIn.getCalcMode())) {
                isNeedFindMdm = false;
            }
            if (isNeedFindMdm) {
                codeInfo = this.posLogicCompoment.analyzeCodeInfo(barNoMode, getSaleGoodsInfoIn.getBarNo(), getSaleGoodsInfoIn.getCalcMode());
                if (!codeInfo.getValidate()) {
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8be5\u6761\u5f62\u7801\u65e0\u6cd5\u901a\u8fc7\u6821\u9a8c\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165");
                }
                getSaleGoodsInfoIn.setBarNo(codeInfo.getBarNo());
                isNeedFindDzc = codeInfo.getIsNeedFindDzc();
                priceMode = codeInfo.getPriceMode();
                disMode = codeInfo.getDisMode();
                disValue = codeInfo.getDisValue();
                barNoMode = codeInfo.getBarNoMode();
                if (disValue > 0.0 && getSaleGoodsInfoIn.getQty() > 0.0) {
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u964d\u4ef7\u7801\u4e0d\u5141\u8bb8\u8f93\u5165\u6570\u91cf");
                }
                if (codeInfo.getBarNo().length() <= 18) {
                    queryGoodIn = GetGoodsDetailIn.transferQueryGoodIn(session, getSaleGoodsInfoIn, barNoMode);
                    queryGoodIn.setChannel(order.getChannel());
                    goodsInfos = this.GetGoodsInfo(queryGoodIn, session);
                    if (null != goodsInfos && goodsInfos.size() > 0 && codeInfo.getBarNo().equals(goodsInfos.get(0).getBarNo())) {
                        isNeedFindMdm = false;
                        isNeedFindDzc = false;
                    }
                }
            }
            if (isNeedFindMdm) {
                if (isNeedFindDzc && cacheModel.getEleCodeRule().size() > 0) {
                    List<ElecScaleCodeRule> elecCodeRules = cacheModel.getEleCodeRule();
                    dzc = this.posLogicCompoment.analyzeBarcode(getSaleGoodsInfoIn.getBarNo(), elecCodeRules, elecCodeRules.get(0).getExpModeMMDDDays(), elecCodeRules.get(0).getExpModeDDHHDays(), cacheModel.getEleCodeMode());
                    if (!SellType.ISBACK(order.getOrderType()) && dzc.getRetCode() == 2) {
                        return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8be5\u5546\u54c1\u5df2\u8fc7\u671f\uff0c\u4e0d\u5141\u8bb8\u9500\u552e");
                    }
                    if (dzc.getRetCode() == 1) {
                        isdzcm = true;
                    }
                }
                if (isdzcm) {
                    if (getSaleGoodsInfoIn.getQty() > 0.0) {
                        return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u79e4\u7801\u5546\u54c1\u4e0d\u5141\u8bb8\u8f93\u5165\u6570\u91cf");
                    }
                    queryGoodIn = GetGoodsDetailIn.transferQueryGoodInByDZC(session, getSaleGoodsInfoIn, dzc, barNoMode);
                    queryGoodIn.setChannel(order.getChannel());
                } else {
                    queryGoodIn = GetGoodsDetailIn.transferQueryGoodIn(session, getSaleGoodsInfoIn, barNoMode);
                    queryGoodIn.setChannel(order.getChannel());
                }
                goodsInfos = this.GetGoodsInfo(queryGoodIn, session);
                if (isdzcm && (null == goodsInfos || goodsInfos.size() == 0)) {
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8bf7\u6c42\u4e3b\u6570\u636e\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5931\u8d25");
                }
            }
            if (!"1".equals(getSaleGoodsInfoIn.getCalcMode())) {
                if (goodsInfos == null || goodsInfos.size() == 0) {
                    if (!isdzcm && disValue == 0.0 && queryGoodIn.getCode().length() < 13) {
                        queryGoodIn.setCode(Convert.padLeft(queryGoodIn.getCode(), '0', 13));
                    }
                    if ((goodsInfos = this.GetGoodsInfo(queryGoodIn, session)) == null || goodsInfos.size() == 0) {
                        return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5f02\u5e38\u5546\u54c1\u7801,\u4e3b\u8d44\u6599\u67e5\u8be2\u5546\u54c1\u8fd4\u56de\u4e3a\u7a7a");
                    }
                }
                GetSaleGoodsInfoOut out = new GetSaleGoodsInfoOut();
                List<Goods> goodsForCoice = Goods.transferGoodsList(goodsInfos, getSaleGoodsInfoIn.getBarNo());
                out.setOrder(OrderForPos.toGoodsForChoice(goodsForCoice));
                out.getOrder().setFlowNo(getSaleGoodsInfoIn.getFlowNo());
                if (goodsInfos.size() > 1) {
                    out.setSaleGoodsType("3");
                    for (int i = 0; i < goodsInfos.size(); ++i) {
                        GoodsInfo g = goodsInfos.get(i);
                        if (SellType.ISSALE(cacheModel.getOrder().getOrderType()) && !g.isAllowSale() || SellType.ISBACK(cacheModel.getOrder().getOrderType()) && !g.isAllowRefund()) {
                            out.getOrder().getGoodsList().remove(i);
                            --i;
                            continue;
                        }
                        if (!"Y".equals(order.getSysPara().getAssistantMode()) || !StringUtils.isNotBlank((String)getSaleGoodsInfoIn.getOrgCode()) || this.posLogicCompoment.checkGzRange(g, order.getSysPara().getAssistantMode(), getSaleGoodsInfoIn.getOrgCode())) continue;
                        out.getOrder().getGoodsList().remove(i);
                        --i;
                    }
                    if (out.getOrder().getGoodsList().size() == 0) {
                        if (SellType.ISSALE(cacheModel.getOrder().getOrderType())) {
                            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8be5\u5546\u54c1\u5f53\u524d\u65e0\u6cd5\u9500\u552e\uff0c\u8bf7\u68c0\u67e5\u5546\u54c1\u67dc\u7ec4\u548c\u9500\u552e\u72b6\u6001");
                        }
                        if (SellType.ISBACK(cacheModel.getOrder().getOrderType())) {
                            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8be5\u5546\u54c1\u5f53\u524d\u65e0\u6cd5\u9000\u8d27\uff0c\u8bf7\u68c0\u67e5\u5546\u54c1\u67dc\u7ec4\u548c\u9000\u8d27\u72b6\u6001");
                        }
                    }
                    if ("Y".equals(order.getSysPara().getAssistantMode()) && StringUtils.isNotBlank((String)getSaleGoodsInfoIn.getOrgCode())) {
                        return ServiceResponse.buildSuccess((Object)out);
                    }
                    boolean isNeedChoice = true;
                    int mainCodeNum = 0;
                    int mainCodeRow = 0;
                    for (int i = 0; i < goodsInfos.size(); ++i) {
                        GoodsInfo g = goodsInfos.get(i);
                        if (!g.getMainBarcodeFlag()) continue;
                        isNeedChoice = false;
                        ++mainCodeNum;
                        mainCodeRow = i;
                        break;
                    }
                    if (mainCodeNum == 1) {
                        goodsInfo = goodsInfos.get(mainCodeRow);
                        isNeedChoice = false;
                    }
                    if (isNeedChoice) {
                        return ServiceResponse.buildSuccess((Object)out);
                    }
                } else {
                    goodsInfo = goodsInfos.get(0);
                    if ("Y".equals(order.getSysPara().getAssistantMode()) && StringUtils.isNotBlank((String)getSaleGoodsInfoIn.getOrgCode()) && !this.posLogicCompoment.checkGzRange(goodsInfo, order.getSysPara().getAssistantMode(), getSaleGoodsInfoIn.getOrgCode())) {
                        return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8be5\u67dc\u7ec4\u65e0\u6b64\u5546\u54c1");
                    }
                }
                if (SellType.ISSALE(cacheModel.getOrder().getOrderType()) && !goodsInfo.isAllowSale()) {
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8be5\u5546\u54c1\u4e3a\u975e\u5141\u8bb8\u9500\u552e\u72b6\u6001");
                }
                if (SellType.ISBACK(cacheModel.getOrder().getOrderType()) && !goodsInfo.isAllowRefund()) {
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8be5\u5546\u54c1\u4e3a\u975e\u5141\u8bb8\u9000\u8d27\u72b6\u6001");
                }
                if (StringUtils.isNotBlank((String)order.getStallCode()) && !"0".equals(order.getStallCode()) && !"-1".equals(order.getStallCode()) && null != goodsInfo.getStallCode() && !goodsInfo.getStallCode().equals(order.getStallCode())) {
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8be5\u6b3e\u673a\u53ea\u5141\u8bb8\u9500\u552e\u6863\u53e3\u4e3a{0}\u7684\u6a94\u53e3\u5546\u54c1", (Object[])new Object[]{order.getStallCode()});
                }
                if ("16".equals(goodsInfo.getGoodsType()) && order.getOrderType().equals("1")) {
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u666e\u901a\u9500\u552e\u4e0d\u5141\u8bb8\u76f4\u63a5\u9500\u552e\u7279\u6b8a\u5546\u54c1");
                }
                if ("20".equals(goodsInfo.getGoodsType())) {
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5957\u9910\u865a\u62df\u5546\u54c1\u4e0d\u5141\u8bb8\u5355\u72ec\u9500\u552e");
                }
                if ("15".equals(goodsInfo.getGoodsType()) && (SellType.ISSALE(cacheModel.getOrder().getOrderType()) || StringUtils.isBlank((String)cacheModel.getOrder().getOriginTerminalSno()))) {
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u6807\u7b7e\u7801\u4e0d\u5141\u8bb8\u76f4\u63a5\u9500\u552e");
                }
                if (!this.posLogicService.checkSyjRange(cacheModel, goodsInfo)) {
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8be5\u5546\u54c1\u4e0d\u5141\u8bb8\u5728\u6b64\u6b3e\u673a\u9500\u552e");
                }
                if (!this.posLogicCompoment.checkGzRange(goodsInfo, order.getSysPara().getAssistantMode(), getSaleGoodsInfoIn.getOrgCode())) {
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8be5\u8425\u4e1a\u5458\u4e0d\u5141\u8bb8\u9500\u552e\u8be5\u5546\u54c1");
                }
                if (!isNeedFindDzc || originalBarNo.equals(goodsInfo.getBarNo())) {
                    goodsInfo.setEscaleFlag(0);
                }
                if (isdzcm) {
                    goodsInfo.setEWCCodeAmount(dzc.getDzcmjg());
                    goodsInfo.setEWCCodeNum(dzc.getDzcmsl());
                    goodsInfo.setExpTime(dzc.getExpTime());
                    if (goodsInfo.getSalePrice() == 0.0) {
                        goodsInfo.setSalePrice(dzc.getDzcmjg());
                    }
                }
                LOGGER.info("SALEPRICE=" + goodsInfo.getSalePrice() + "PRICEMODE=" + priceMode);
                if (disMode != 3) {
                    if (!("2".equals(getSaleGoodsInfoIn.getCalcMode()) || goodsInfo.getEscaleFlag() == 1 || goodsInfo.getSalePrice() != 0.0 && priceMode != 1)) {
                        goodsInfo.setSalePrice(0.0);
                        for (GoodsForPos sg : out.getOrder().getGoodsList()) {
                            sg.setSalePrice(0.0);
                        }
                        out.setSaleGoodsType("0");
                        return ServiceResponse.buildSuccess((Object)out);
                    }
                    if (!isdzcm && goodsInfo.getEscaleFlag() != 1 && goodsInfo.getSalePrice() < 0.1 && !"2".equals(getSaleGoodsInfoIn.getCalcMode())) {
                        out.setSaleGoodsType("1");
                        return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4ef7\u683c\u4f4e\u4e8e0.1\u7684\u5546\u54c1\u4e0d\u5141\u8bb8\u76f4\u63a5\u9500\u552e");
                    }
                }
                if ("9".equals(goodsInfo.getGoodsType())) {
                    if (getSaleGoodsInfoIn.getQty() > 0.0) {
                        return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5957\u9910\u5546\u54c1\u4e0d\u5141\u8bb8\u8f93\u5165\u6570\u91cf");
                    }
                    out.setSaleGoodsType("1");
                    return ServiceResponse.buildSuccess((Object)out);
                }
                if (goodsInfo.getControlFlag()) {
                    for (Goods g : cacheModel.getGoodsList()) {
                        if (!g.getControlFlag()) continue;
                        return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5c0f\u7968\u5df2\u6709\u7ba1\u5236\u5546\u54c1[{0}]\uff0c\u53ea\u80fd\u6dfb\u52a0\u4e00\u79cd\u7ba1\u5236\u5546\u54c1", (Object[])new Object[]{g.getBarNo()});
                    }
                    type = "2";
                }
                if ("2".equals(getSaleGoodsInfoIn.getCalcMode())) {
                    goodsInfo.setSalePrice(getSaleGoodsInfoIn.getRefPrice());
                    if (goodsInfo.getEscaleFlag() == 1) {
                        goodsInfo.setEscaleFlag(0);
                    }
                    getSaleGoodsInfoIn.setCalcMode("0");
                }
                double qty = 1.0;
                if (getSaleGoodsInfoIn.getQty() > 0.0) {
                    qty = getSaleGoodsInfoIn.getQty();
                }
                String goodsName = goodsInfo.getGoodsName();
                String engName = goodsInfo.getEnFname();
                String ensName = goodsInfo.getEnSname();
                if (null != goodsName) {
                    goodsName = goodsName.replace("\"", "\u201d");
                    goodsName = goodsName.replace("'", "\u2019");
                    goodsName = goodsName.replace("\\$", "");
                    goodsName = goodsName.replace("\u00a0", "");
                }
                if (null != engName) {
                    engName = engName.replace("\"", "\u201d");
                    engName = engName.replace("'", "\u2019");
                    engName = engName.replace("\\$", "");
                    engName = engName.replace("\u00a0", "");
                }
                if (null != ensName) {
                    ensName = ensName.replace("\"", "\u201d");
                    ensName = ensName.replace("'", "\u2019");
                    ensName = ensName.replace("\\$", "");
                    ensName = ensName.replace("\u00a0", "");
                }
                goodsInfo.setGoodsName(goodsName);
                goodsInfo.setEnFname(engName);
                goodsInfo.setEnSname(ensName);
                LOGGER.info("\u7535\u5b50\u79e4\u6807\u8bc6\uff1a" + goodsInfo.getEscaleFlag());
                goods = this.posLogicService.CalcGoodsAmountBeforeSingle(goodsInfo, getSaleGoodsInfoIn.getAssistantId(), isdzcm, dzc.getDzcmsl(), dzc.getDzcmjg(), cacheModel.getEleCodeMode(), originalBarNo, qty);
                if (null == goods) {
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u7535\u5b50\u79e4\u5546\u54c1\u9700\u8981\u4f7f\u7528\u79e4\u7801\u9500\u552e\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
                }
                goods.setEatWay(order.getEatWay());
                if (getSaleGoodsInfoIn.getCalcMode().equals("3")) {
                    goods.setEatWay(getSaleGoodsInfoIn.getEatWay());
                    if (null != getSaleGoodsInfoIn.getStallCode() && getSaleGoodsInfoIn.getStallCode().length() > 0) {
                        goods.setStallCode(getSaleGoodsInfoIn.getStallCode());
                    }
                    goods.setOriginalCategoryPropertys(goodsInfo.getCategoryPropertys());
                    getSaleGoodsInfoIn.setCalcMode("0");
                }
                goods.setCalcMode(getSaleGoodsInfoIn.getCalcMode());
                goods.setGuid(UUIDUtils.buildGuid());
                goods.setFlowNo(getSaleGoodsInfoIn.getFlowNo());
                goods.setFlowId(cacheModel.getGoodsList().size() + 1);
                LOGGER.info("PRICEMODE=" + priceMode + ",DISVALUE=" + disValue + ",DISMODE=" + disMode + ",SALEAMOUNT=" + goods.getSaleAmount() + ",GOODSNO=" + goods.getGoodsNo());
                if (priceMode == 2 && ManipulatePrecision.doubleCompare(disValue, 0.0, 2) > 0) {
                    goods = this.posLogicCompoment.calcGoodsBarcodeDiscBeforeSingle(goods, disMode, disValue, discType);
                }
                if (SellType.ISCOUPON(order.getOrderType()) && !goods.getGoodsType().equals("11")) {
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4e70\u5238\u9500\u552e\u53ea\u5141\u8bb8\u9500\u552e\u5238\u5546\u54c1");
                }
                if (!SellType.ISCOUPON(order.getOrderType()) && goods.getGoodsType().equals("11")) {
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u975e\u4e70\u5238\u9500\u552e\u4e0d\u5141\u8bb8\u9500\u552e\u5238\u5546\u54c1");
                }
                if (cacheModel.getMaxSaleGoodsQuantity() > 0.0 && goods.getQty() > cacheModel.getMaxSaleGoodsQuantity()) {
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5546\u54c1\u6570\u91cf\u8d85\u51fa\u5355\u884c\u53ef\u552e\u6700\u5927\u6570\u91cf");
                }
                if (cacheModel.getMaxSaleGoodsMoney() > 0.0 && goods.getSalePrice() > cacheModel.getMaxSaleGoodsMoney()) {
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5546\u54c1\u4ef7\u683c\u8d85\u51fa\u7cfb\u7edf\u6700\u5927\u96f6\u552e\u4ef7");
                }
            }
            boolean isNeedRefreshBillId = false;
            if (null == cacheModel.getGoodsList() || cacheModel.getGoodsList().size() == 0) {
                if (SellType.ISBACK(cacheModel.getOrder().getOrderType()) && StringUtils.isNotBlank((String)cacheModel.getOrder().getOriginTerminalSno()) && !"Y".equals(cacheModel.getCurGrant().getPrivth())) {
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5f53\u524d\u6536\u94f6\u5458\u6216\u6388\u6743\u4eba\u5458\u6ca1\u6709\u65e0\u5355\u9000\u8d27\u6743\u9650");
                }
                isNeedRefreshBillId = true;
                LocalDateTime dateTime = LocalDateTime.now();
                DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                String nowDateTime = dateTime.format(df).toString();
                cacheModel.getOrder().setSaleDate(nowDateTime);
                cacheModel.getOrder().setSaleExtractTime(nowDateTime);
            }
            if (cacheModel.getPopMode() == 1) {
                cacheModel = this.promotionServiceImpl.calcSinglePop(session, getSaleGoodsInfoIn.getCalcMode(), getSaleGoodsInfoIn.getGuid(), goods, cacheModel, getSaleGoodsInfoIn.getPopDetails(), true, isNeedRefreshBillId);
            } else if (cacheModel.getPopMode() == 2) {
                String calcMode = "0";
                List<Goods> goodsList = cacheModel.getGoodsList();
                goodsList = Goods.combineAddGoods(goodsList, goods);
                cacheModel.setGoodsList(goodsList);
                cacheModel = this.promotionServiceImpl.calcOrderPop(session, calcMode, cacheModel, false, false, false);
            } else {
                cacheModel = this.cacheModelService.addOneGoods(cacheModel, goods);
                this.posLogicCompoment.calcOrderAmount(cacheModel);
            }
            if (cacheModel.getCalcResult() == -1) {
                String errCode = "100000";
                if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                    errCode = cacheModel.getErrCode();
                }
                return ServiceResponse.buildFailure((ServiceSession)session, (String)errCode, (String)cacheModel.getErrMsg());
            }
            if (cacheModel.getMaxSaleMoney() > 0.0 && cacheModel.getOrder().getOughtPay() > cacheModel.getMaxSaleMoney()) {
                int lastIndex = cacheModel.getGoodsList().size() - 1;
                String guid = cacheModel.getGoodsList().get(lastIndex).getGuid();
                cacheModel = this.cacheModelService.deleteOneGoods(cacheModel, guid);
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355\u6210\u4ea4\u4ef7\u8d85\u51fa\u7cfb\u7edf\u6700\u5927\u6210\u4ea4\u4ef7");
            }
            long beforeSaveUpdateTime = System.currentTimeMillis();
            LOGGER.info("\u6dfb\u52a0\u5546\u54c1,flowNo:\u3010{}\u3011,\u8017\u65f6\uff1a\u3010{}\u3011\u6beb\u79d2", (Object)cacheModel.getFlowNo(), (Object)(beforeSaveUpdateTime - startTime));
            if (cacheModel.getOrder().getTempZzk() != 100.0) {
                cacheModel = this.posLogicCompoment.CalcOrderRebateByRate(cacheModel, cacheModel.getCurGrant().getGh(), cacheModel.getOrder().getTempZzk());
            }
            if (cacheModel.getOrder().getTempZzr() != 0.0) {
                cacheModel = this.posLogicCompoment.CalcOrderRebateByAmount(cacheModel, cacheModel.getCurGrant().getGh(), cacheModel.getOrder().getTempZzr());
            }
            cacheModel = this.posLogicCompoment.calcGoodsCount(cacheModel, originalBarNo);
            this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
            long afterSaveUpdateTime = System.currentTimeMillis();
            LOGGER.info("\u6dfb\u52a0\u5546\u54c1,save:\u3010{}\u3011,\u8017\u65f6\uff1a\u3010{}\u3011\u6beb\u79d2", (Object)cacheModel.getFlowNo(), (Object)(afterSaveUpdateTime - beforeSaveUpdateTime));
            GetSaleGoodsInfoOut out = new GetSaleGoodsInfoOut();
            out.setOrder(OrderForPos.toOrderForPosSingle(cacheModel));
            out.setSaleGoodsType(type);
            return ServiceResponse.buildSuccess((Object)out);
        }
        catch (Exception e) {
            e.printStackTrace();
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stringWriter));
            return ServiceResponse.buildFailure((ServiceSession)session, (String)("\u6dfb\u52a0\u5546\u54c1\u5f02\u5e38" + stringWriter.toString()));
        }
    }

    private ServiceResponse getSaleGoodsInfoValidate(ServiceSession session, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        if (StringUtils.isBlank((String)paramsObject.getString("barNo"))) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u67e5\u627e\u5546\u54c1\u4fe1\u606f\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u5546\u54c1\u6761\u5f62\u7801"});
        }
        if (StringUtils.isBlank((String)paramsObject.getString("calcMode"))) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u67e5\u627e\u5546\u54c1\u4fe1\u606f\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u8ba1\u7b97\u6a21\u5f0f"});
        }
        if (StringUtils.isBlank((String)paramsObject.getString("searchType"))) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u67e5\u627e\u5546\u54c1\u4fe1\u606f\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u67e5\u627e\u7c7b\u578b"});
        }
        if (StringUtils.isBlank((String)paramsObject.getString("erpCode"))) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u67e5\u627e\u5546\u54c1\u4fe1\u606f\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u7ecf\u8425\u516c\u53f8\u7f16\u7801"});
        }
        return ServiceResponse.buildSuccess((Object)"success");
    }

    @Override
    public ServiceResponse updateCartGoods(ServiceSession session, JSONObject paramsObject) {
        try {
            String accreditNo;
            ParamsValidateUtils paramsValidate = new ParamsValidateUtils(session, paramsObject);
            if (!paramsValidate.validate()) {
                return paramsValidate.getServiceResponse();
            }
            if (!paramsObject.containsKey((Object)"barNo") || paramsObject.getString("barNo").isEmpty()) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4fee\u6539\u5546\u54c1\u5217\u8868\u4e2d\u7684\u4e00\u884c\u5546\u54c1\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"barNo"});
            }
            if (!paramsObject.containsKey((Object)"guid") || paramsObject.getString("guid").isEmpty()) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4fee\u6539\u5546\u54c1\u5217\u8868\u4e2d\u7684\u4e00\u884c\u5546\u54c1\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"guid"});
            }
            if (!paramsObject.containsKey((Object)"calcMode") || paramsObject.getString("calcMode").isEmpty()) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4fee\u6539\u5546\u54c1\u5217\u8868\u4e2d\u7684\u4e00\u884c\u5546\u54c1\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"calcMode"});
            }
            String flag = paramsObject.getString("flag");
            if ("0".equals(flag) && (!paramsObject.containsKey((Object)"qty") || paramsObject.getDouble("qty") == 0.0)) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4fee\u6539\u5546\u54c1\u5217\u8868\u4e2d\u7684\u4e00\u884c\u5546\u54c1\u5fc5\u987b\u5305\u542b\u4e0d\u4e3a0\u53c2\u6570[{0}]", (Object[])new Object[]{"qty"});
            }
            UpdateCartGoodsIn updateGoodsIn = (UpdateCartGoodsIn)JSON.toJavaObject((JSON)paramsObject, UpdateCartGoodsIn.class);
            String flowNo = updateGoodsIn.getFlowNo();
            CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(flowNo);
            if (cacheModel == null) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4fee\u6539\u4e00\u884c\u5546\u54c1\u4fe1\u606f:\u67e5\u8be2\u7f13\u5b58order\u4e3aNull");
            }
            if (!cacheModel.getOrder().getAllowEditGoods()) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u8fdb\u5165\u652f\u4ed8\u73af\u8282\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u5546\u54c1", (Object[])new Object[]{flowNo});
            }
            if (cacheModel.getGoodsList() == null || cacheModel.getGoodsList().size() == 0) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4fee\u6539\u4e00\u884c\u5546\u54c1\u4fe1\u606f:\u67e5\u8be2\u7f13\u5b58\u5546\u54c1\u5217\u8868\u4e3a\u7a7a");
            }
            Goods existGoods = Goods.findGoods(updateGoodsIn.getGuid(), cacheModel.getGoodsList());
            if (existGoods == null) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8d2d\u7269\u8f66\u4e2d\u4e0d\u5b58\u5728\u8be5\u5546\u54c1");
            }
            if ("1".equals(flag)) {
                if ("Y".equals(existGoods.getEscaleFlag())) {
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u79e4\u7801\u5546\u54c1\u4e0d\u80fd\u4fee\u6539\u4ef7\u683c");
                }
                if (existGoods.getDisMode() > 0) {
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u964d\u4ef7\u7801\u5546\u54c1\u4e0d\u80fd\u4fee\u6539\u4ef7\u683c");
                }
            }
            if (StringUtils.isBlank((String)(accreditNo = paramsObject.getString("accreditNo")))) {
                accreditNo = cacheModel.getCurGrant().getGh();
            }
            Goods updateGoods = existGoods.deepClone();
            double oldAmount = existGoods.getSaleAmount();
            double orderTempZzk = cacheModel.getOrder().getTempZzk();
            double orderTempZzr = cacheModel.getOrder().getTempZzr();
            if (updateGoodsIn.getCalcMode().equals("3")) {
                existGoods.setEatWay(updateGoodsIn.getEatWay());
                updateGoodsIn.setCalcMode("0");
                if (null != updateGoodsIn.getCategoryPropertys() && updateGoodsIn.getCategoryPropertys().size() > 0) {
                    existGoods.setCategoryPropertys(updateGoodsIn.getCategoryPropertys());
                } else {
                    existGoods.setCategoryPropertys(new ArrayList<CategoryProperty>());
                }
            }
            if (updateGoodsIn.getCalcMode().equals("4")) {
                if (null == cacheModel.getOrder().getConsumersData().getConsumersId() || cacheModel.getOrder().getConsumersData().getConsumersId().length() <= 0) {
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u672a\u5237\u4f1a\u5458\u5361\u4e0d\u5141\u8bb8\u4fee\u6539\u6362\u8d2d\u72b6\u6001");
                }
                if (!existGoods.getFlag().equals("1") && !existGoods.getFlag().equals("7")) {
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u53ea\u6709\u666e\u901a\u5546\u54c1\u5141\u8bb8\u4fee\u6539\u6362\u8d2d\u72b6\u6001");
                }
                if (existGoods.getFlag().equals("1")) {
                    existGoods.setFlag("7");
                } else {
                    existGoods.setFlag("1");
                }
                updateGoodsIn.setCalcMode("0");
            }
            if ("0".equals(flag)) {
                if (cacheModel.getMaxSaleGoodsQuantity() > 0.0 && (updateGoodsIn.getQty() > cacheModel.getMaxSaleGoodsQuantity() || updateGoodsIn.getQty() < 0.0)) {
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u6570\u91cf\u8d85\u51fa\u7cfb\u7edf\u8bbe\u7f6e\u6700\u5927\u53ef\u552e\u6570\u91cf");
                }
                if ((cacheModel = this.posLogicService.EditGoodsQtyBeforeSingle(cacheModel, existGoods.getFlowId(), accreditNo, updateGoodsIn.getQty())).getCalcResult() == -1) {
                    String errCode = "100000";
                    if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                        errCode = cacheModel.getErrCode();
                    }
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)errCode, (String)cacheModel.getErrMsg());
                }
                LOGGER.info("\u4fee\u6539\u6570\u91cf\u7ed3\u675f");
                existGoods = cacheModel.getGoodsList().get(existGoods.getFlowId() - 1);
            }
            if ("1".equals(flag) || "3".equals(flag)) {
                if (cacheModel.getMaxSaleGoodsMoney() > 0.0 && updateGoodsIn.getRefPrice() > cacheModel.getMaxSaleGoodsMoney()) {
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5355\u4ef7\u8d85\u51fa\u7cfb\u7edf\u8bbe\u7f6e\u6700\u5927\u96f6\u552e\u4ef7");
                }
                if (updateGoodsIn.getRefPrice() <= 0.0) {
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5546\u54c1\u4e0d\u5141\u8bb8\u6539\u4ef7\u4e3a0");
                }
                if ("3".equals(flag)) {
                    existGoods.setPopFlag("J");
                }
                cacheModel = this.posLogicService.EditGoodsPriceBeforeSingle(cacheModel, existGoods.getFlowId(), accreditNo, updateGoodsIn.getRefPrice());
                existGoods = cacheModel.getGoodsList().get(existGoods.getFlowId() - 1);
            }
            if ("2".equals(flag)) {
                if (cacheModel.getMaxSaleGoodsMoney() > 0.0 && updateGoodsIn.getRefPrice() > cacheModel.getMaxSaleGoodsMoney()) {
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5355\u4ef7\u8d85\u51fa\u7cfb\u7edf\u8bbe\u7f6e\u6700\u5927\u96f6\u552e\u4ef7");
                }
                cacheModel = this.posLogicService.FixGoodsPriceBeforeSingle(cacheModel, existGoods.getFlowId(), accreditNo, updateGoodsIn.getRefPrice());
                existGoods = cacheModel.getGoodsList().get(existGoods.getFlowId() - 1);
            }
            if (cacheModel.getCalcResult() == -1) {
                String errCode = "100000";
                String errMsg = cacheModel.getErrMsg();
                if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                    errCode = cacheModel.getErrCode();
                    if ("1000".equals(cacheModel.getErrCode()) && null != cacheModel.getCurTempGrant() && StringUtils.isNotEmpty((String)cacheModel.getCurTempGrant().getGh())) {
                        cacheModel = this.cacheModelService.getCacheModelByFlowNo(flowNo);
                        this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
                    }
                }
                return ServiceResponse.buildFailure((ServiceSession)session, (String)errCode, (String)errMsg);
            }
            if (cacheModel.getPopMode() == 1) {
                cacheModel = this.promotionServiceImpl.calcSinglePop(session, updateGoodsIn.getCalcMode(), updateGoodsIn.getGuid(), existGoods, cacheModel, null, false, false, true);
            } else if (cacheModel.getPopMode() == 2) {
                String calcMode = "0";
                cacheModel = this.promotionServiceImpl.calcOrderPop(session, calcMode, cacheModel, false, false, false, true);
            } else {
                this.posLogicCompoment.calcOrderAmount(cacheModel);
            }
            if (cacheModel.getCalcResult() == -1) {
                String errCode = "100000";
                if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                    errCode = cacheModel.getErrCode();
                }
                return ServiceResponse.buildFailure((ServiceSession)session, (String)errCode, (String)cacheModel.getErrMsg());
            }
            if (cacheModel.getMaxSaleMoney() > 0.0 && cacheModel.getOrder().getOughtPay() > cacheModel.getMaxSaleMoney()) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355\u91d1\u989d\u8d85\u51fa\u7cfb\u7edf\u6700\u5927\u8ba2\u5355\u91d1\u989d");
            }
            Goods returnGoods = Goods.findGoods(updateGoodsIn.getGuid(), cacheModel.getGoodsList());
            returnGoods.setCategoryPropertys(existGoods.getCategoryPropertys());
            if (orderTempZzk != 100.0) {
                cacheModel = this.posLogicCompoment.CalcOrderRebateByRate(cacheModel, cacheModel.getCurGrant().getGh(), orderTempZzk);
            }
            if (orderTempZzr != 0.0) {
                cacheModel = this.posLogicCompoment.CalcOrderRebateByAmount(cacheModel, cacheModel.getCurGrant().getGh(), orderTempZzr);
            }
            double newAmount = returnGoods.getSaleAmount();
            this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
            if ("1".equals(flag)) {
                if (ManipulatePrecision.doubleConvert(oldAmount - newAmount) != 0.0) {
                    this.asyncTask.sendWorkLog(session, cacheModel.getOrder(), WorkLogType.editPrice, existGoods.getQty(), ManipulatePrecision.doubleConvert(oldAmount - newAmount), existGoods.getGoodsName(), existGoods.getGoodsCode());
                }
            } else if ("2".equals(flag)) {
                this.asyncTask.sendWorkLog(session, cacheModel.getOrder(), WorkLogType.rebate, existGoods.getQty(), ManipulatePrecision.doubleConvert(oldAmount - newAmount), existGoods.getGoodsName(), existGoods.getGoodsCode());
            } else if ("0".equals(flag)) {
                double je = ManipulatePrecision.doubleConvert(oldAmount - newAmount);
                if (je > 0.0) {
                    this.asyncTask.sendWorkLog(session, cacheModel.getOrder(), WorkLogType.editQty, existGoods.getQty(), ManipulatePrecision.doubleConvert(oldAmount - newAmount), existGoods.getGoodsName(), existGoods.getGoodsCode());
                }
            } else if ("3".equals(flag)) {
                this.asyncTask.sendWorkLog(session, cacheModel.getOrder(), WorkLogType.editTransactionPrice, existGoods.getQty(), ManipulatePrecision.doubleConvert(oldAmount - newAmount), existGoods.getGoodsName(), existGoods.getGoodsCode());
            }
            UpdateCartGoodsOut out = new UpdateCartGoodsOut();
            out.setOrder(OrderForPos.toOrderForPosSingle(cacheModel));
            if ("0".equals(flag)) {
                DelGoodsInfo updateGood = new DelGoodsInfo();
                updateGood.setBarNo(updateGoods.getBarNo());
                updateGood.setGoodsCode(updateGoods.getGoodsCode());
                updateGood.setGoodsDisplayName(updateGoods.getGoodsDisplayName());
                updateGood.setGoodsName(updateGoods.getGoodsName());
                updateGood.setGoodsNo(updateGoods.getGoodsNo());
                updateGood.setQty(updateGoods.getQty());
                updateGood.setSaleAmount(ManipulatePrecision.doubleConvert(oldAmount - newAmount));
                out.setUpdateGood(updateGood);
            }
            return ServiceResponse.buildSuccess((Object)out);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)e.getLocalizedMessage());
        }
    }

    @Override
    public ServiceResponse delCartGoods(ServiceSession session, JSONObject paramsObject) {
        try {
            ParamsValidateUtils paramsValidate = new ParamsValidateUtils(session, paramsObject);
            if (!paramsValidate.validate()) {
                return paramsValidate.getServiceResponse();
            }
            if (!paramsObject.containsKey((Object)"guid") || paramsObject.getString("guid").isEmpty()) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5220\u9664\u5546\u54c1\u5217\u8868\u4e2d\u7684\u4e00\u884c\u5546\u54c1\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u5546\u54c1\u552f\u4e00\u6807\u793a"});
            }
            if (!paramsObject.containsKey((Object)"barNo") || paramsObject.getString("barNo").isEmpty()) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5220\u9664\u5546\u54c1\u5217\u8868\u4e2d\u7684\u4e00\u884c\u5546\u54c1\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u5546\u54c1\u6761\u5f62\u7801"});
            }
            DelCartGoodsIn in = new DelCartGoodsIn().transfer(paramsObject);
            CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(in.getFlowNo());
            if (cacheModel == null || cacheModel.getGoodsList() == null) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4fee\u6539\u4e00\u884c\u5546\u54c1\u4fe1\u606f\u8c03\u7528\u8ba1\u7b97\u65b9\u6cd5,\u6ca1\u6709\u83b7\u5f97CacheModel");
            }
            if (!cacheModel.getOrder().getAllowEditGoods()) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u8fdb\u5165\u652f\u4ed8\u73af\u8282\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u5546\u54c1", (Object[])new Object[]{in.getFlowNo()});
            }
            boolean checkRemain = true;
            boolean checkDelNum = true;
            int delNum = cacheModel.getOrder().getSysPara().getMaxDelNum();
            int remainRow = cacheModel.getOrder().getSysPara().getMinRemainNum();
            if (delNum <= 0) {
                checkDelNum = false;
            }
            if (remainRow <= 0) {
                checkRemain = false;
            }
            if (checkDelNum && cacheModel.getOrder().getDeleteNum() >= delNum) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8d85\u51fa\u5141\u8bb8\u5220\u9664\u5546\u54c1\u884c\u6570");
            }
            if (checkRemain && cacheModel.getGoodsList().size() <= remainRow) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)("\u4e0d\u5141\u8bb8\u5220\u9664\u6700\u540e" + remainRow + "\u884c\u5546\u54c1"));
            }
            if (!"99".equals(cacheModel.getOrder().getPosType()) && (null == cacheModel.getCurGrant().getPrivqx() || "N".equals(cacheModel.getCurGrant().getPrivqx()))) {
                if (null != cacheModel.getCurTempGrant() && StringUtils.isNotEmpty((String)cacheModel.getCurTempGrant().getGh())) {
                    this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
                }
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"1000", (String)"\u5f53\u524d\u6388\u6743\u4eba\u5458\u65e0\u5220\u9664\u5355\u54c1\u6743\u9650");
            }
            Goods existGoods = Goods.findGoods(in.getGuid(), cacheModel.getGoodsList());
            Goods delGoods = existGoods.deepClone();
            if (existGoods == null || StringUtils.isEmpty((String)existGoods.getGuid())) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8d2d\u7269\u8f66\u4e2d\u4e0d\u5b58\u5728\u8be5\u5546\u54c1");
            }
            if (!SellType.ISBACK(cacheModel.getOrder().getOrderType()) && existGoods.getGoodsType().equals("15")) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u6807\u7b7e\u7801\u4e0d\u5141\u8bb8\u5220\u9664");
            }
            String accreditNo = in.getAccreditNo();
            if (StringUtils.isBlank((String)accreditNo)) {
                accreditNo = cacheModel.getCurGrant().getGh();
            }
            double oldOrderAmout = cacheModel.getOrder().getOughtPay();
            boolean isNeedReCalcOrderAdjust = true;
            if (StringUtils.isNotBlank((String)existGoods.getSGoodsSno())) {
                List<Goods> goodslist = Goods.delMealGoods(existGoods.getSGoodsSno(), cacheModel.getGoodsList());
                cacheModel.setGoodsList(goodslist);
            } else if (!existGoods.getGoodsType().equals("99") && !existGoods.getGoodsType().equals("98")) {
                cacheModel = this.posLogicCompoment.delOneGoods(cacheModel, accreditNo, existGoods.getFlowId());
            } else {
                cacheModel = this.posLogicCompoment.delOneGoods(cacheModel, accreditNo, existGoods.getFlowId());
                cacheModel = this.posLogicCompoment.removeAeonCouponPopDetail(cacheModel);
                cacheModel = this.posLogicCompoment.CalcAdjustDiscAfterOrder(cacheModel);
                isNeedReCalcOrderAdjust = false;
            }
            if (cacheModel == null || StringUtils.isEmpty((String)cacheModel.getFlowNo())) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5220\u9664\u8d2d\u7269\u8f66\u5546\u54c1\u5931\u8d25..");
            }
            DelGoodsInfo delGood = new DelGoodsInfo();
            delGood.setBarNo(delGoods.getBarNo());
            delGood.setGoodsCode(delGoods.getGoodsCode());
            delGood.setGoodsDisplayName(delGoods.getGoodsDisplayName());
            delGood.setGoodsName(delGoods.getGoodsName());
            delGood.setGoodsNo(delGoods.getGoodsNo());
            delGood.setQty(delGoods.getQty());
            delGood.setSaleAmount(delGoods.getSaleAmount());
            cacheModel = this.posLogicService.CalcOrderAmountBeforeOrder(cacheModel);
            if (-1 == cacheModel.getCalcResult()) {
                String errCode = "100000";
                if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                    errCode = cacheModel.getErrCode();
                }
                return ServiceResponse.buildFailure((ServiceSession)session, (String)errCode, (String)cacheModel.getErrMsg());
            }
            if (cacheModel == null || cacheModel.getGoodsList() == null || cacheModel.getOrder() == null) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5220\u9664\u4e00\u884c\u5546\u54c1\u4fe1\u606f\u8c03\u7528\u8ba1\u7b97\u65b9\u6cd5,\u6ca1\u6709\u83b7\u5f97\u6709\u6548CacheModel");
            }
            if (cacheModel.getPopMode() == 1 && cacheModel.getGoodsList().size() > 0) {
                cacheModel = this.promotionServiceImpl.calcSinglePopAll(session, "0", cacheModel, true);
            } else if (cacheModel.getPopMode() == 2 && cacheModel.getGoodsList().size() > 0) {
                String calcMode = "0";
                cacheModel = this.promotionServiceImpl.calcOrderPop(session, calcMode, cacheModel, false, false, false);
            } else {
                this.posLogicCompoment.calcOrderAmount(cacheModel);
            }
            if (isNeedReCalcOrderAdjust) {
                cacheModel = this.posLogicCompoment.CalcAdjustDiscAfterOrder(cacheModel);
            }
            cacheModel.getOrder().setDeleteNum(cacheModel.getOrder().getDeleteNum() + 1);
            delGood.setSaleAmount(ManipulatePrecision.doubleConvert(oldOrderAmout - cacheModel.getOrder().getOughtPay()));
            cacheModel.getOrder().setDelGoods(delGood);
            this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
            this.asyncTask.sendWorkLog(session, cacheModel.getOrder(), WorkLogType.delGoods, delGood.getQty(), delGood.getSaleAmount(), delGoods.getGoodsName(), delGoods.getGoodsCode());
            BaseOutModel out = new BaseOutModel();
            OrderForPos order = OrderForPos.toOrderForPosSingle(cacheModel);
            LOGGER.info("CacheDeleteNum:" + cacheModel.getOrder().getDeleteNum() + "OutDeleteNum:" + order.getDeleteNum());
            out.setOrder(order);
            return ServiceResponse.buildSuccess((Object)out);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5220\u9664\u4e00\u884c\u5546\u54c1\u5904\u7406\u5931\u8d25");
        }
    }

    public ServiceResponse delDesignCartGoods(ServiceSession session, JSONObject paramsObject) {
        try {
            ParamsValidateUtils paramsValidate = new ParamsValidateUtils(session, paramsObject);
            if (!paramsValidate.validate()) {
                return paramsValidate.getServiceResponse();
            }
            if (!paramsObject.containsKey((Object)"qty") || paramsObject.getString("qty").isEmpty()) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5220\u9664\u5546\u54c1\u5217\u8868\u4e2d\u7684\u4e00\u884c\u5546\u54c1\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u5220\u9664\u6570\u91cf"});
            }
            if (!paramsObject.containsKey((Object)"goodsNo") || paramsObject.getString("goodsNo").isEmpty()) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5220\u9664\u5546\u54c1\u5217\u8868\u4e2d\u7684\u4e00\u884c\u5546\u54c1\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u5546\u54c1\u7801"});
            }
            DelDesignCartGoodsIn in = (DelDesignCartGoodsIn)JSON.toJavaObject((JSON)paramsObject, DelDesignCartGoodsIn.class);
            if (in.getQty() < 0.0) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5220\u9664\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e0\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
            }
            CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(in.getFlowNo());
            if (cacheModel == null || cacheModel.getGoodsList() == null) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5220\u9664\u5546\u54c1\u6ca1\u6709\u83b7\u5f97CacheModel");
            }
            if (!cacheModel.getOrder().getAllowEditGoods()) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u8fdb\u5165\u652f\u4ed8\u73af\u8282\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u5546\u54c1", (Object[])new Object[]{in.getFlowNo()});
            }
            if (!"99".equals(cacheModel.getOrder().getPosType()) && (null == cacheModel.getCurGrant().getPrivqx() || "N".equals(cacheModel.getCurGrant().getPrivqx()))) {
                if (null != cacheModel.getCurTempGrant() && StringUtils.isNotEmpty((String)cacheModel.getCurTempGrant().getGh())) {
                    this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
                }
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"1000", (String)"\u5f53\u524d\u6388\u6743\u4eba\u5458\u65e0\u5220\u9664\u5355\u54c1\u6743\u9650");
            }
            if (!cacheModel.getOrder().getSysPara().getDecimalNum() && !ManipulatePrecision.isIntegerForDouble(in.getQty())) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u6307\u5b9a\u4fee\u6b63\u53ea\u5141\u8bb8\u8f93\u5165\u6574\u6570");
            }
            List<Goods> existGoods = Goods.findGoodsByGoodsNo(in.getGoodsNo(), cacheModel.getGoodsList());
            if (existGoods == null || existGoods.size() == 0) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8d2d\u7269\u8f66\u4e2d\u4e0d\u5b58\u5728\u8be5\u5546\u54c1");
            }
            if ((existGoods.get(0).getEWCCodeAmount() > 0.0 || existGoods.get(0).getEWCCodeNum() > 0.0) && in.getQty() != 1.0) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u79e4\u7801\u5546\u54c1\u53ea\u80fd\u9010\u4e2a\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
            }
            if (StringUtils.isNotBlank((String)existGoods.get(0).getSGoodsSno())) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5957\u9910\u5546\u54c1\u53ea\u80fd\u9010\u4e2a\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
            }
            if (existGoods.get(0).getBarcodeDiscount() > 0.0 && in.getQty() != 1.0) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u91d1\u989d\u7801\u5546\u54c1\u53ea\u80fd\u9010\u4e2a\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
            }
            if (existGoods.get(0).getFlag().equals("0")) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8d08\u54c1\u53ea\u80fd\u9010\u4e2a\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
            }
            boolean checkRemain = true;
            boolean checkDelNum = true;
            int delNum = cacheModel.getOrder().getSysPara().getMaxDelNum();
            int remainRow = cacheModel.getOrder().getSysPara().getMinRemainNum();
            int existDelNum = cacheModel.getOrder().getDeleteNum();
            if (delNum <= 0) {
                checkDelNum = false;
            }
            if (remainRow <= 0) {
                checkRemain = false;
            }
            double matchQty = 0.0;
            double delQty = in.getQty();
            int reCalcRowNo = -1;
            for (Goods g : existGoods) {
                if (existGoods.get(0).getEWCCodeAmount() > 0.0 || existGoods.get(0).getEWCCodeNum() > 0.0) {
                    matchQty += 1.0;
                    continue;
                }
                matchQty += g.getQty();
            }
            if (ManipulatePrecision.doubleCompare(matchQty, delQty, 2) < 0) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u6307\u5b9a\u4fee\u6b63\u6570\u91cf\u8d85\u51fa\u5546\u54c1\u6570\u91cf\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
            }
            if (!SellType.ISBACK(cacheModel.getOrder().getOrderType()) && existGoods.get(0).getGoodsType().equals("15")) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u6807\u7b7e\u7801\u4e0d\u5141\u8bb8\u5220\u9664");
            }
            String accreditNo = in.getAccreditNo();
            if (StringUtils.isBlank((String)accreditNo)) {
                accreditNo = cacheModel.getCurGrant().getGh();
            }
            boolean isNeedReCalcOrderAdjust = true;
            DelGoodsInfo delGood = new DelGoodsInfo();
            delGood.setBarNo(existGoods.get(0).getBarNo());
            delGood.setGoodsCode(existGoods.get(0).getGoodsCode());
            delGood.setGoodsDisplayName(existGoods.get(0).getGoodsDisplayName());
            delGood.setGoodsName(existGoods.get(0).getGoodsName());
            delGood.setGoodsNo(existGoods.get(0).getGoodsNo());
            delGood.setQty(delQty);
            delGood.setSaleAmount(existGoods.get(0).getSaleAmount());
            double oldOrderAmout = cacheModel.getOrder().getOughtPay();
            for (int i = 0; i < existGoods.size(); ++i) {
                if (StringUtils.isNotBlank((String)existGoods.get(i).getSGoodsSno())) {
                    if (checkDelNum && existDelNum >= delNum) {
                        return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8d85\u51fa\u5141\u8bb8\u5220\u9664\u5546\u54c1\u884c\u6570");
                    }
                    List<Goods> goodslist = Goods.delMealGoods(existGoods.get(i).getSGoodsSno(), cacheModel.getGoodsList());
                    cacheModel.setGoodsList(goodslist);
                    ++existDelNum;
                    break;
                }
                if (existGoods.get(i).getEWCCodeAmount() > 0.0 || existGoods.get(i).getEWCCodeNum() > 0.0) {
                    if (checkDelNum && existDelNum >= delNum) {
                        return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8d85\u51fa\u5141\u8bb8\u5220\u9664\u5546\u54c1\u884c\u6570");
                    }
                    cacheModel = this.posLogicCompoment.delOneGoods(cacheModel, accreditNo, existGoods.get(i).getFlowId());
                    ++existDelNum;
                    break;
                }
                if (existGoods.get(0).getBarcodeDiscount() > 0.0) {
                    if (checkDelNum && existDelNum >= delNum) {
                        return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8d85\u51fa\u5141\u8bb8\u5220\u9664\u5546\u54c1\u884c\u6570");
                    }
                    cacheModel = this.posLogicCompoment.delOneGoods(cacheModel, accreditNo, existGoods.get(i).getFlowId());
                    ++existDelNum;
                    break;
                }
                if (ManipulatePrecision.doubleCompare(existGoods.get(i).getQty(), delQty, 2) > 0) {
                    cacheModel = this.posLogicService.EditGoodsQtyBeforeSingle(cacheModel, existGoods.get(i).getFlowId(), cacheModel.getCurGrant().getCardno(), ManipulatePrecision.doubleConvert(existGoods.get(i).getQty() - delQty));
                    reCalcRowNo = existGoods.get(i).getFlowId();
                    break;
                }
                if (checkDelNum && existDelNum >= delNum) {
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8d85\u51fa\u5141\u8bb8\u5220\u9664\u5546\u54c1\u884c\u6570");
                }
                delQty = ManipulatePrecision.doubleConvert(delQty - existGoods.get(i).getQty());
                cacheModel = this.posLogicCompoment.delOneGoods(cacheModel, accreditNo, existGoods.get(i).getFlowId());
                ++existDelNum;
            }
            if (cacheModel == null || StringUtils.isEmpty((String)cacheModel.getFlowNo())) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5220\u9664\u8d2d\u7269\u8f66\u5546\u54c1\u5931\u8d25..");
            }
            if (checkRemain && cacheModel.getGoodsList().size() < remainRow) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)("\u4e0d\u5141\u8bb8\u5220\u9664\u6700\u540e" + remainRow + "\u884c\u5546\u54c1"));
            }
            if ((cacheModel = this.posLogicService.CalcOrderAmountBeforeOrder(cacheModel)).getCalcResult() == -1) {
                String errCode = "100000";
                if (cacheModel.getErrCode().length() > 0) {
                    errCode = cacheModel.getErrCode();
                }
                return ServiceResponse.buildFailure((ServiceSession)session, (String)errCode, (String)cacheModel.getErrMsg());
            }
            if (cacheModel == null || cacheModel.getGoodsList() == null || cacheModel.getOrder() == null) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5220\u9664\u4e00\u884c\u5546\u54c1\u4fe1\u606f\u8c03\u7528\u8ba1\u7b97\u65b9\u6cd5,\u6ca1\u6709\u83b7\u5f97\u6709\u6548CacheModel");
            }
            if (cacheModel.getPopMode() == 1 && cacheModel.getGoodsList().size() > 0) {
                cacheModel = this.promotionServiceImpl.calcSinglePopAll(session, "0", cacheModel, true);
            } else if (cacheModel.getPopMode() == 2 && cacheModel.getGoodsList().size() > 0) {
                if (reCalcRowNo != -1) {
                    if (cacheModel.getGoodsList().get(reCalcRowNo - 1).getTempZkl() != 100.0) {
                        this.posLogicCompoment.CalcGoodsRebateByRate(cacheModel, reCalcRowNo, cacheModel.getOrder().getTerminalOperatorAuthzCardNo(), cacheModel.getGoodsList().get(reCalcRowNo - 1).getTempZkl());
                        isNeedReCalcOrderAdjust = false;
                    } else if (cacheModel.getGoodsList().get(reCalcRowNo - 1).getTempZkDiscount() > 0.0) {
                        this.posLogicCompoment.CalcGoodsRebateByAmount(cacheModel, reCalcRowNo, cacheModel.getOrder().getTerminalOperatorAuthzCardNo(), cacheModel.getGoodsList().get(reCalcRowNo - 1).getTempZkDiscount());
                        isNeedReCalcOrderAdjust = false;
                    }
                }
                String calcMode = "0";
                cacheModel = this.promotionServiceImpl.calcOrderPop(session, calcMode, cacheModel, false, false, false);
            } else {
                if (reCalcRowNo != -1) {
                    if (cacheModel.getGoodsList().get(reCalcRowNo - 1).getTempZkl() != 100.0) {
                        this.posLogicCompoment.CalcGoodsRebateByRate(cacheModel, reCalcRowNo, cacheModel.getOrder().getTerminalOperatorAuthzCardNo(), cacheModel.getGoodsList().get(reCalcRowNo - 1).getTempZkl(), false);
                        isNeedReCalcOrderAdjust = false;
                    } else if (cacheModel.getGoodsList().get(reCalcRowNo - 1).getTempZkDiscount() > 0.0) {
                        this.posLogicCompoment.CalcGoodsRebateByAmount(cacheModel, reCalcRowNo, cacheModel.getOrder().getTerminalOperatorAuthzCardNo(), cacheModel.getGoodsList().get(reCalcRowNo - 1).getTempZkDiscount(), 0, true, false);
                        isNeedReCalcOrderAdjust = false;
                    }
                }
                this.posLogicCompoment.calcOrderAmount(cacheModel);
            }
            if (isNeedReCalcOrderAdjust) {
                cacheModel = this.posLogicCompoment.CalcAdjustDiscAfterOrder(cacheModel);
            }
            if (cacheModel.getCalcResult() == -1) {
                String errCode = "100000";
                if (cacheModel.getErrCode().length() > 0) {
                    errCode = cacheModel.getErrCode();
                }
                return ServiceResponse.buildFailure((ServiceSession)session, (String)errCode, (String)cacheModel.getErrMsg());
            }
            cacheModel.getOrder().setDeleteNum(existDelNum);
            delGood.setSaleAmount(ManipulatePrecision.doubleConvert(oldOrderAmout - cacheModel.getOrder().getOughtPay()));
            cacheModel.getOrder().setDelGoods(delGood);
            this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
            this.asyncTask.sendWorkLog(session, cacheModel.getOrder(), WorkLogType.delGoods, delGood.getQty(), delGood.getSaleAmount(), delGood.getGoodsName(), delGood.getGoodsCode());
            BaseOutModel out = new BaseOutModel();
            OrderForPos order = OrderForPos.toOrderForPosSingle(cacheModel);
            out.setOrder(order);
            return ServiceResponse.buildSuccess((Object)out);
        }
        catch (Exception e) {
            e.printStackTrace();
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stringWriter));
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5220\u9664\u4e00\u884c\u5546\u54c1\u5904\u7406\u5931\u8d25");
        }
    }

    @Override
    public ServiceResponse createBill(ServiceSession session, JSONObject paramsObject) {
        ServiceResponse validateData = this.createBillValidate(session, paramsObject);
        if (!"0".equals(validateData.getReturncode())) {
            return validateData;
        }
        CreateBillIn createBillIn = (CreateBillIn)JSONObject.toJavaObject((JSON)paramsObject, CreateBillIn.class);
        List<Goods> goodsListByFlowNo = this.cacheModelService.getGoodsListByFlowNo(createBillIn.getFlowNo());
        if (goodsListByFlowNo == null || goodsListByFlowNo.size() <= 0) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"\u67e5\u8be2\u5546\u54c1\u5217\u8868\u4fe1\u606f\u5931\u8d25");
        }
        OrderForPos createBillOut = new OrderForPos();
        createBillOut.setFlowNo("18734687126986");
        return ServiceResponse.buildSuccess((Object)createBillOut);
    }

    private ServiceResponse createBillValidate(ServiceSession session, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        if (StringUtils.isBlank((String)paramsObject.getString("assistantId"))) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8bf7\u6c42\u5f00\u7968\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u8425\u4e1a\u5458\u53f7"});
        }
        if (StringUtils.isBlank((String)paramsObject.getString("channel"))) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8bf7\u6c42\u5f00\u7968\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u7ba1\u9053\u53f7"});
        }
        if (StringUtils.isBlank((String)paramsObject.getString("orderType"))) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8bf7\u6c42\u5f00\u7968\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u5355\u636e\u7c7b\u522b"});
        }
        return ServiceResponse.buildSuccess((Object)"success");
    }

    @Override
    public ServiceResponse getBill(ServiceSession session, JSONObject paramsObject) {
        ServiceResponse validateData = this.getBillValidate(session, paramsObject);
        if ("0".equals(validateData.getReturncode())) {
            return validateData;
        }
        OrderForPos out = new OrderForPos();
        out.setOughtPay(10.0);
        out.setExistPay(8.0);
        out.setTotalDiscountValue(2.0);
        out.setOverageValue(8.0);
        Goods goods = new Goods();
        goods.setGuid("124325346");
        goods.setPopFlag("143254636");
        goods.setFlowId(123);
        goods.setGoodsCode("1234325");
        goods.setBarNo("23547568");
        goods.setGoodsName("\u897f\u74dc");
        goods.setGoodsType("1");
        goods.setSaleSpec("kg");
        goods.setSaleUnit("kg");
        goods.setListPrice(10.0);
        goods.setSalePrice(5.0);
        goods.setWeight(1.0);
        goods.setGoodsNo("143253467");
        goods.setFlowNo("23324535664765");
        goods.setMemo("\u5907\u7528");
        goods.setImageUrl("");
        ArrayList<GoodsForPos> goodList = new ArrayList<GoodsForPos>();
        goodList.add(goods);
        out.setGoodsList(goodList);
        return ServiceResponse.buildSuccess((Object)out);
    }

    private ServiceResponse getBillValidate(ServiceSession session, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        if (StringUtils.isBlank((String)paramsObject.getString("flowNo"))) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u83b7\u53d6\u7535\u5b50\u5f00\u7968\u5546\u54c1\u4fe1\u606f\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u5f00\u7968\u5355\u53f7"});
        }
        if (StringUtils.isBlank((String)paramsObject.getString("calcMode"))) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u83b7\u53d6\u7535\u5b50\u5f00\u7968\u5546\u54c1\u4fe1\u606f\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"calcMode"});
        }
        return ServiceResponse.buildSuccess((Object)"success");
    }

    private ServiceResponse addBatchGoodsValidate(ServiceSession session, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        if (StringUtils.isBlank((String)paramsObject.getString("tradeno"))) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u6279\u91cf\u6dfb\u52a0\u5546\u54c1\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"tradeno"});
        }
        if (StringUtils.isBlank((String)paramsObject.getString("searchType"))) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u6279\u91cf\u6dfb\u52a0\u5546\u54c1\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u67e5\u627e\u7c7b\u578b"});
        }
        if (StringUtils.isBlank((String)paramsObject.getString("erpCode"))) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u6279\u91cf\u6dfb\u52a0\u5546\u54c1\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u7ecf\u8425\u516c\u53f8\u7f16\u7801"});
        }
        return ServiceResponse.buildSuccess((Object)"success");
    }

    public ServiceResponse queryGoodsDetail(ServiceSession session, JSONObject paramsObject) {
        SellDetail sellDetail;
        List<SellDetail> sellDetails;
        BillDetail billDetail;
        CalcsingleOut calcsingleOut;
        String goodsName;
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validateWithOutFlowNoAndOperator()) {
            return paramsValidateUtils.getServiceResponse();
        }
        String erpCode = paramsObject.getString("erpCode");
        String eleMode = "";
        if (StringUtils.isBlank((String)erpCode)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"erpCode \u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{new Object()});
        }
        String channel = paramsObject.getString("channel");
        if (StringUtils.isBlank((String)channel)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"channel \u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{new Object()});
        }
        String barNo = paramsObject.getString("barNo");
        if (StringUtils.isBlank((String)barNo)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5546\u54c1\u6761\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{new Object()});
        }
        if (StringUtils.isBlank((String)paramsObject.getString("entId"))) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"entId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int eid = Integer.parseInt(paramsObject.getString("entId"));
        session.setEnt_id((long)eid);
        QueryGoodIn queryGoodIn = (QueryGoodIn)JSON.parseObject((String)paramsObject.toJSONString(), QueryGoodIn.class);
        ArrayList<Goods> goodsList = new ArrayList<Goods>();
        ElecScaleCodeRuleIn elecScaleCodeRuleIn = new ElecScaleCodeRuleIn();
        elecScaleCodeRuleIn.setErpCode(erpCode);
        elecScaleCodeRuleIn.setMkt(paramsObject.getString("shopCode"));
        ServiceResponse respElec = this.posManagerService.getElecCode(this.restTemplate, session, elecScaleCodeRuleIn);
        ArrayList<String> codes = new ArrayList<String>();
        codes.add("JYMS");
        codes.add("CWYH");
        codes.add("PRTSEQ");
        codes.add("POPPRTMODE");
        codes.add("CMJY");
        codes.add("CWYH");
        List<SysPara> sysParaList = this.orderService.getSyspara(session, codes, queryGoodIn.getErpCode(), queryGoodIn.getShopCode());
        SysParaInfo sysPara = this.orderService.initSysParaInfo(sysParaList);
        ElecScaleCodeRuleOut elecCodeRuleOut = (ElecScaleCodeRuleOut)respElec.getData();
        eleMode = elecCodeRuleOut.getCodeRule();
        if ("1".equals(elecCodeRuleOut.getCodeRule())) {
            sysPara.setBarCodeMode(1);
        }
        if ("2".equals(elecCodeRuleOut.getCodeRule())) {
            sysPara.setBarCodeMode(3);
        }
        boolean isdzcm = false;
        boolean isNeedFindMdm = true;
        DzcGoodsDetail dzc = null;
        boolean isNeedFindDzc = true;
        int priceMode = 0;
        String originalBarNo = null;
        int disMode = 0;
        double disValue = 0.0;
        int barNoMode = sysPara.getBarCodeMode();
        Goods goods = new Goods();
        GoodsInfo goodsInfo = null;
        GetGoodsDetailIn getGoodsDetailIn = new GetGoodsDetailIn();
        List<GoodsInfo> goodsInfos = null;
        AnalyzeBarcodeDef codeInfo = this.posLogicCompoment.analyzeCodeInfo(barNoMode, queryGoodIn.getBarNo(), "0");
        if (!codeInfo.getValidate()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8be5\u6761\u5f62\u7801\u65e0\u6cd5\u901a\u8fc7\u6821\u9a8c\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165");
        }
        queryGoodIn.setBarNo(codeInfo.getBarNo());
        isNeedFindDzc = codeInfo.getIsNeedFindDzc();
        priceMode = codeInfo.getPriceMode();
        originalBarNo = codeInfo.getOriginalBarNo();
        disMode = codeInfo.getDisMode();
        disValue = codeInfo.getDisValue();
        barNoMode = codeInfo.getBarNoMode();
        if (codeInfo.getBarNo().length() <= 18 && null != (goodsInfos = this.GetGoodsInfoWithTopCategory(getGoodsDetailIn = GetGoodsDetailIn.transferQueryGoodInToOrderQueryIn(queryGoodIn, barNoMode), session)) && goodsInfos.size() > 0 && codeInfo.getBarNo().equals(goodsInfos.get(0).getBarNo())) {
            isNeedFindMdm = false;
        }
        if (isNeedFindMdm) {
            if ("0".equals(respElec.getReturncode())) {
                List<ElecScaleCodeRule> elecCodeRules = elecCodeRuleOut.getElecscalecoderule();
                if (isNeedFindDzc && elecCodeRules.size() > 0) {
                    dzc = this.posLogicCompoment.analyzeBarcode(queryGoodIn.getBarNo(), elecCodeRules, elecCodeRules.get(0).getExpModeMMDDDays(), elecCodeRules.get(0).getExpModeDDHHDays(), elecCodeRuleOut.getCodeRule());
                    if (dzc.getRetCode() == 2) {
                        return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8be5\u5546\u54c1\u5df2\u8fc7\u671f\uff0c\u4e0d\u5141\u8bb8\u9500\u552e");
                    }
                    if (dzc.getRetCode() == 1) {
                        isdzcm = true;
                    }
                }
            }
            if (null == (goodsInfos = this.GetGoodsInfoWithTopCategory(getGoodsDetailIn = isdzcm ? GetGoodsDetailIn.transferQueryGoodInToOrderQueryIn(queryGoodIn, dzc, barNoMode) : GetGoodsDetailIn.transferQueryGoodInToOrderQueryIn(queryGoodIn, barNoMode), session)) || goodsInfos.size() == 0) {
                if (isdzcm) {
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u672a\u67e5\u627e\u5230\u8be5\u5546\u54c1", (Object[])new Object[]{new Object()});
                }
                if (disValue == 0.0 && getGoodsDetailIn.getCode().length() < 13) {
                    getGoodsDetailIn.setCode(Convert.padLeft(getGoodsDetailIn.getCode(), '0', 13));
                    goodsInfos = this.GetGoodsInfoWithTopCategory(getGoodsDetailIn, session);
                    if (null == goodsInfos || goodsInfos.size() == 0) {
                        return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u672a\u67e5\u627e\u5230\u8be5\u5546\u54c1", (Object[])new Object[]{new Object()});
                    }
                } else {
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u672a\u67e5\u627e\u5230\u8be5\u5546\u54c1", (Object[])new Object[]{new Object()});
                }
            }
        }
        if (null != (goodsName = (goodsInfo = (GoodsInfo)goodsInfos.get(0)).getGoodsName())) {
            goodsName = goodsName.replace("\"", "\u201d");
            goodsName = goodsName.replace("'", "\u2019");
        }
        goodsInfo.setGoodsName(goodsName);
        LOGGER.info("SALEPRICE=" + goodsInfo.getSalePrice() + "PRICEMODE=" + priceMode);
        LOGGER.info("\u7535\u5b50\u79e4\u6807\u8bc6\uff1a" + goodsInfo.getEscaleFlag());
        if (isdzcm) {
            goodsInfo.setEWCCodeAmount(dzc.getDzcmjg());
            goodsInfo.setEWCCodeNum(dzc.getDzcmsl());
            goodsInfo.setExpTime(dzc.getExpTime());
            if (goodsInfo.getSalePrice() == 0.0) {
                goodsInfo.setSalePrice(dzc.getDzcmjg());
            }
            if ((goods = this.posLogicCompoment.CalcGoodsAmount(goodsInfo, queryGoodIn.getAssistantId(), isdzcm, dzc.getDzcmsl(), dzc.getDzcmjg(), eleMode, originalBarNo, 1.0)) == null) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8be5\u5546\u54c1\u8d44\u6599\u6709\u8bef", (Object[])new Object[]{new Object()});
            }
        } else {
            if (isNeedFindMdm && goodsInfo.getEscaleFlag() == 1) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u79e4\u7801\u5546\u54c1\u4e0d\u80fd\u4f7f\u7528\u7f16\u7801\u67e5\u8be2", (Object[])new Object[]{new Object()});
            }
            Goods.transferGoodsInfoToGoods(goodsInfo, goods, 1.0);
            goods.setEscaleFlag("N");
        }
        if (!isNeedFindDzc || originalBarNo.equals(goodsInfo.getBarNo())) {
            goodsInfo.setEscaleFlag(0);
        }
        goods.setGuid(UUIDUtils.buildGuid());
        goods.setGoodsCode(goodsInfo.getGoodsCode());
        LOGGER.info("PRICEMODE=" + priceMode + ",DISVALUE=" + disValue + ",DISMODE=" + disMode + ",SALEAMOUNT=" + goods.getSaleAmount());
        String discType = "0";
        if (priceMode == 2 && ManipulatePrecision.doubleCompare(disValue, 0.0, 2) > 0) {
            goods = this.posLogicCompoment.calcGoodsBarcodeDiscBeforeSingle(goods, disMode, disValue, discType);
        }
        if ("2".equals(queryGoodIn.getCalcMode())) {
            goods.setSalePrice(queryGoodIn.getRefPrice());
            goods.setSaleAmount(queryGoodIn.getRefPrice());
            goods.setSaleValue(queryGoodIn.getRefPrice());
        }
        goods.setGoodsNo(originalBarNo);
        CalcsingleIn calcsingleIn = CalcsingleIn.build(goods, queryGoodIn);
        ServiceResponse response = this.promotionCentreService.queryPriceCalcsingle(this.restTemplate, session, calcsingleIn);
        if ("0".equals(response.getReturncode())) {
            calcsingleOut = (CalcsingleOut)response.getData();
            billDetail = calcsingleOut.getBillDetail();
            sellDetails = billDetail.getSellDetails();
            sellDetail = sellDetails.get(0);
            double noDiscAmount = 0.0;
            double popDiscAmount = 0.0;
            if (sellDetail.getSellPopDetails() != null && sellDetail.getSellPopDetails().size() > 0) {
                for (SellPopDetail sellPopDetail : sellDetail.getSellPopDetails()) {
                    if (null == sysPara.getCalcPriceType() || sysPara.getCalcPriceType().isEmpty()) continue;
                    if (StringUtils.isNotBlank((String)sellPopDetail.getPopEventType()) && sysPara.getCalcPriceType().indexOf(sellPopDetail.getPopEventType()) != -1) {
                        noDiscAmount += sellPopDetail.getDiscountAmount();
                        continue;
                    }
                    if (YPopStatusType.pop_policy_group_barcode_discA.equals(sellPopDetail.getPopPolicyGroup()) || YPopStatusType.pop_policy_group_barcode_discB.equals(sellPopDetail.getPopPolicyGroup())) {
                        goods.setBarcodeDiscount(ManipulatePrecision.doubleConvert(sellPopDetail.getDiscountAmount(), 2, 1));
                        continue;
                    }
                    if (StringUtils.isNotBlank((String)sellPopDetail.getPopDescribe()) && sellPopDetail.getPopDescribe().indexOf("\u57fa\u7840\u79ef\u5206") != -1) continue;
                    popDiscAmount += sellPopDetail.getDiscountAmount();
                }
            }
            goods.setNoDisAmountValue(ManipulatePrecision.doubleConvert(noDiscAmount));
            goods.setPopDiscountValue(ManipulatePrecision.doubleConvert(popDiscAmount));
            goods.setSaleValue(sellDetail.getListAmount());
            goods.setAdjustDiscountValue(PosLogicCompoment.getAdjustDiscount(goods));
            goods.setTotalDiscountValue(PosLogicCompoment.getZZK(goods));
            goods.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(goods.getTotalDiscountValue() - goods.getNoDisAmountValue()));
            goods.setSaleAmount(ManipulatePrecision.doubleConvert(goods.getSaleValue() - goods.getTotalDiscountValue()));
            goods.setListPrice(ManipulatePrecision.doubleConvert(goods.getSaleValue() - goods.getNoDisAmountValue()));
        }
        calcsingleIn.getBillDetail().setConsumersType("01");
        response = this.promotionCentreService.queryPriceCalcsingle(this.restTemplate, session, calcsingleIn);
        if (response.getReturncode().trim().equals("0")) {
            calcsingleOut = (CalcsingleOut)response.getData();
            billDetail = calcsingleOut.getBillDetail();
            sellDetails = billDetail.getSellDetails();
            sellDetail = sellDetails.get(0);
            if (sellDetail.getSellPopDetails() != null && sellDetail.getSellPopDetails().size() > 0) {
                for (SellPopDetail sellPopDetail : sellDetail.getSellPopDetails()) {
                    if (null != sysPara.getCalcPriceType() && !sysPara.getCalcPriceType().isEmpty() && StringUtils.isNotBlank((String)sellPopDetail.getPopEventType()) && sysPara.getCalcPriceType().indexOf(sellPopDetail.getPopEventType()) != -1) continue;
                    goods.getPopDetailsInfo().add(PopDetail.transferPopDetail2(sellPopDetail));
                }
            }
            goods.setCustomDiscountValue(ManipulatePrecision.doubleConvert(goods.getSaleAmount() - sellDetail.getSaleAmount()));
        }
        if (goods.getEWCCodeAmount() > 0.0) {
            goods.setListPrice(goods.getEWCCodeAmount());
        }
        goodsList.add(goods);
        BaseOutModel out = new BaseOutModel();
        OrderForPos order = new OrderForPos();
        order.setGoodsList(Goods.transferGoodsToPosGoodsList(goodsList, sysPara.getCalcPriceType(), true));
        out.setOrder(order);
        return ServiceResponse.buildSuccess((Object)out);
    }

    public ServiceResponse getMealGoodsInfo(ServiceSession session, JSONObject paramsObject) {
        ServiceResponse validateData = this.getMealGoodsInfoValidate(session, paramsObject);
        if (!"0".equals(validateData.getReturncode())) {
            return validateData;
        }
        GetMealGoodsInfoIn getMealGoodsInfoIn = (GetMealGoodsInfoIn)JSONObject.toJavaObject((JSON)paramsObject, GetMealGoodsInfoIn.class);
        CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(getMealGoodsInfoIn.getFlowNo());
        if (cacheModel == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8d2d\u7269\u8f66\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\u4ea4\u6613\u6d41\u6c34\u53f7");
        }
        if (!cacheModel.getOrder().getAllowEditGoods()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u8fdb\u5165\u652f\u4ed8\u73af\u8282\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u5546\u54c1", (Object[])new Object[]{getMealGoodsInfoIn.getFlowNo()});
        }
        cacheModel.setMealDetail(new SearchMealDetailOut());
        session.setEnt_id(cacheModel.getOrder().getEntId());
        SearchMealDetailIn searchMealDetailIn = new SearchMealDetailIn();
        searchMealDetailIn.setSsgId(getMealGoodsInfoIn.getSsgId());
        ServiceResponse resp = this.mainDataCentreService.getMealGoodsFromMDM(this.restTemplate, session, searchMealDetailIn);
        if (!"0".equals(resp.getReturncode())) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u67e5\u8be2\u5957\u9910\u5546\u54c1\u4fe1\u606f\u5931\u8d25");
        }
        SearchMealDetailOut out = (SearchMealDetailOut)resp.getData();
        if (null == out || null == out.getSaleGoods() || out.getSaleGoods().size() == 0 || (long)out.getSaleGoods().size() != out.getTotalResults()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u67e5\u8be2\u5957\u9910\u5546\u54c1\u4fe1\u606f\u9519\u8bef");
        }
        cacheModel.setMealDetail(out);
        GetMealGoodsInfoOut mealGoodsOut = new GetMealGoodsInfoOut();
        mealGoodsOut.setMealSalePrice(out.getSumInfo().getSalePrice());
        mealGoodsOut.setMealGoods(MealGoodsInfoForPos.transferMealGoodsInfoForPos(out));
        this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
        return ServiceResponse.buildSuccess((Object)mealGoodsOut);
    }

    private ServiceResponse getMealGoodsInfoValidate(ServiceSession session, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        return ServiceResponse.buildSuccess((Object)"success");
    }

    public ServiceResponse choiceMealGoods(ServiceSession session, JSONObject paramsObject) {
        Goods sGoods;
        ServiceResponse validateData = this.choiceMealGoodsInfoValidate(session, paramsObject);
        if (!"0".equals(validateData.getReturncode())) {
            return validateData;
        }
        ChoiceMealGoodsIn choiceMealGoodsIn = (ChoiceMealGoodsIn)JSONObject.toJavaObject((JSON)paramsObject, ChoiceMealGoodsIn.class);
        CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(choiceMealGoodsIn.getFlowNo());
        if (cacheModel == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8d2d\u7269\u8f66\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\u4ea4\u6613\u6d41\u6c34\u53f7");
        }
        session.setEnt_id(cacheModel.getOrder().getEntId());
        SearchMealDetailOut cacheModelMealInfo = cacheModel.getMealDetail();
        if (null == choiceMealGoodsIn.getChoice() || choiceMealGoodsIn.getChoice().size() <= 0) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u6ca1\u6709\u4f20\u5165\u4efb\u4f55\u5957\u9910\u4fe1\u606f");
        }
        if (null == cacheModelMealInfo || null == cacheModelMealInfo.getSaleGoods()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u7f13\u5b58\u4e2d\u6ca1\u6709\u5957\u9910\u4fe1\u606f");
        }
        if (choiceMealGoodsIn.getChoice().size() != cacheModelMealInfo.getSaleGoods().size()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u9009\u62e9\u884c\u6570\u4e0e\u7f13\u5b58\u4fe1\u606f\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165");
        }
        if (!choiceMealGoodsIn.getChoice().get(0).getGoodsCode().equals(cacheModelMealInfo.getSaleGoods().get(0).getGoodsCode())) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4f20\u5165\u5957\u9910\u7f16\u7801\u4e0e\u7f13\u5b58\u4fe1\u606f\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165");
        }
        ArrayList<Goods> tempGoods = new ArrayList<Goods>();
        GoodsForPos goods = null;
        boolean isAdd = false;
        ArrayList<CategoryProperty> oneModelCpList = new ArrayList<CategoryProperty>();
        double choiceGoodsPrice = 0.0;
        double beforeAddAmount = cacheModel.getOrder().getOughtPay();
        for (int i = 0; i < choiceMealGoodsIn.getChoice().size(); ++i) {
            MealInfoForChoice choiceInfo = choiceMealGoodsIn.getChoice().get(i);
            Stream mealStream = cacheModelMealInfo.getSaleGoods().stream();
            MealGoodsInfo mInfo = (MealGoodsInfo)mealStream.filter(mealInfo -> mealInfo.getSmtrid().equals(choiceInfo.getSmtrid())).collect(Collectors.toList()).get(0);
            long maxQty = mInfo.getOptionNum();
            List<MealDetailForChoice> mealDetails = choiceInfo.getDetail();
            if ((long)mealDetails.size() != maxQty) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)("\u9009\u62e9\u5957\u9910\u5546\u54c1\u4ef6\u6570\u5fc5\u987b\u9009\u62e9[" + maxQty + "]\u4ef6"));
            }
            for (int j = 0; j < mealDetails.size(); ++j) {
                MealDetailForChoice mealDetail = mealDetails.get(j);
                Stream mDetailStream = mInfo.getDetail().stream();
                MealGoodsDetail mDetail = (MealGoodsDetail)mDetailStream.filter(detail -> detail.getSmdid().equals(mealDetail.getSmdid())).collect(Collectors.toList()).get(0);
                if (choiceMealGoodsIn.getType().equals("3")) {
                    mDetail.setEatWay(mealDetail.getEatWay());
                    mDetail.setStallCode(mealDetail.getStallCode());
                    mDetail.setHasBackPrint(mealDetail.getHasBackPrint());
                }
                sGoods = MealGoodsDetail.transferMealGoodsDetailToGoods(mDetail, choiceMealGoodsIn.getType());
                sGoods.setFlowNo(cacheModel.getFlowNo());
                choiceGoodsPrice = ManipulatePrecision.doubleConvert(choiceGoodsPrice + sGoods.getSaleAmount(), 2, 1);
                if (null == cacheModelMealInfo.getSumInfo().getPrcutMode() || cacheModelMealInfo.getSumInfo().getPrcutMode().length() == 0) {
                    sGoods.setPrcutMode("A");
                } else {
                    sGoods.setPrcutMode(cacheModelMealInfo.getSumInfo().getPrcutMode());
                }
                sGoods.setProcessFlag(cacheModelMealInfo.getSumInfo().getProcessFlag());
                if ("1".equals(choiceMealGoodsIn.getAddModel())) {
                    sGoods.setSGoodsSno(PosLogicServiceImpl.getNewSGoodsSno(cacheModel));
                    oneModelCpList.addAll(mealDetail.getCategoryPropertys());
                    sGoods.setCategoryPropertys(oneModelCpList);
                    tempGoods.add(sGoods);
                }
                if (!"0".equals(choiceMealGoodsIn.getAddModel())) continue;
                CategoryProperty cp = new CategoryProperty();
                cp.setPropertyName(sGoods.getGoodsName());
                cp.setPropertyCode(sGoods.getGoodsCode());
                cp.setIsDel(false);
                cp.setIsGoods(true);
                sGoods.setGoodsType("9");
                oneModelCpList.add(cp);
                for (CategoryProperty cps : mealDetail.getCategoryPropertys()) {
                    CategoryProperty ncp = new CategoryProperty();
                    ncp.setPropertyName(cps.getPropertyName());
                    ncp.setPropertyCode(cps.getPropertyCode());
                    ncp.setIsDel(cps.getIsDel());
                    oneModelCpList.add(ncp);
                }
                if (isAdd) continue;
                GoodsInfo mealGoodSumInfo = cacheModelMealInfo.getSumInfo();
                goods = this.posLogicServiceImpl.CalcGoodsAmountBeforeSingle(mealGoodSumInfo, cacheModel.getOrder().getTerminalOperator(), false, 0.0, 0.0, cacheModel.getEleCodeMode(), mealGoodSumInfo.getBarNo(), 1.0);
                Goods.transferGoodsInfoToGoods(mealGoodSumInfo, (Goods)goods, 1.0);
                if (null == cacheModelMealInfo.getSumInfo().getPrcutMode() || cacheModelMealInfo.getSumInfo().getPrcutMode().length() == 0) {
                    ((Goods)goods).setPrcutMode("A");
                } else {
                    ((Goods)goods).setPrcutMode(cacheModelMealInfo.getSumInfo().getPrcutMode());
                }
                isAdd = true;
            }
        }
        if ("0".equals(choiceMealGoodsIn.getAddModel())) {
            goods.setCategoryPropertys(oneModelCpList);
            tempGoods.add((Goods)goods);
        }
        if ("1".equals(choiceMealGoodsIn.getAddModel()) && tempGoods.size() > 0) {
            Goods sGoods2;
            int i;
            double allOrgPrice = 0.0;
            double mealPrice = ManipulatePrecision.getDetailOverFlow(cacheModelMealInfo.getSumInfo().getSalePrice(), cacheModelMealInfo.getSumInfo().getPrcutMode());
            double zyhje = ManipulatePrecision.getDetailOverFlow(allOrgPrice - mealPrice, cacheModelMealInfo.getSumInfo().getPrcutMode());
            double syftje = 0.0;
            int maxPriceIndex = 0;
            double maxPrice = 0.0;
            for (i = 0; i < tempGoods.size(); ++i) {
                sGoods2 = (Goods)tempGoods.get(i);
                allOrgPrice += sGoods2.getSalePrice();
                if (!(sGoods2.getSalePrice() > maxPrice)) continue;
                maxPrice = sGoods2.getSalePrice();
                maxPriceIndex = i;
            }
            syftje = zyhje;
            for (i = 0; i < tempGoods.size(); ++i) {
                if (i == maxPriceIndex) continue;
                sGoods2 = (Goods)tempGoods.get(i);
                String precisionMode = DataExchageUtils.exchangePrecisionMode(sGoods2.getPrcutMode());
                sGoods2.setMealDiscountValue(ManipulatePrecision.getDetailOverFlow(zyhje * sGoods2.getSalePrice() / allOrgPrice, precisionMode));
                sGoods2.setTotalDiscountValue(sGoods2.getTotalDiscountValue() + sGoods2.getMealDiscountValue());
                sGoods2.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sGoods2.getTotalDiscountValue() - sGoods2.getNoDisAmountValue()));
                syftje -= sGoods2.getMealDiscountValue();
            }
            sGoods = (Goods)tempGoods.get(maxPriceIndex);
            String precisionMode = DataExchageUtils.exchangePrecisionMode(sGoods.getPrcutMode());
            sGoods.setMealDiscountValue(ManipulatePrecision.getDetailOverFlow(syftje, precisionMode));
            sGoods.setTotalDiscountValue(sGoods.getTotalDiscountValue() + sGoods.getMealDiscountValue());
            sGoods.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sGoods.getTotalDiscountValue() - sGoods.getNoDisAmountValue()));
        }
        int flowId = cacheModel.getGoodsList() == null || cacheModel.getGoodsList().isEmpty() ? 0 : cacheModel.getGoodsList().size();
        ++flowId;
        for (int i = 0; i < tempGoods.size(); ++i) {
            Goods good = (Goods)tempGoods.get(i);
            good.setFlowId(flowId);
            good.setGuid(UUIDUtils.buildGuid());
            if (cacheModel.getOrder().getSysPara().getBarCodeMode() == 2) {
                good.setTempCategory(good.getArtCode());
            }
            cacheModel.getGoodsList().add(good);
            ++flowId;
        }
        String calcMode = "0";
        if (cacheModel.getPopMode() == 1) {
            cacheModel = this.promotionServiceImpl.calcSinglePopAll(session, calcMode, cacheModel, true);
        } else if (cacheModel.getPopMode() == 2) {
            cacheModel = this.promotionServiceImpl.calcOrderPop(session, calcMode, cacheModel, false, false, false);
        }
        this.posLogicCompoment.calcOrderAmount(cacheModel);
        if ("1".equals(choiceMealGoodsIn.getAddModel()) && ManipulatePrecision.doubleCompare(cacheModel.getOrder().getOughtPay() - beforeAddAmount - choiceGoodsPrice, 0.0, 2) > 0) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u9009\u4e2d\u5546\u54c1\u5355\u72ec\u8d2d\u4e70\u4ef7\u683c\u66f4\u4f18");
        }
        this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
        ChoiceMealGoodsOut out = new ChoiceMealGoodsOut();
        for (int i = 0; i < tempGoods.size(); ++i) {
            Goods sg = (Goods)tempGoods.get(i);
            sg = Goods.removeSinglePopDetails(sg);
        }
        out.setGoodsList(tempGoods);
        out.setDiscountValue(cacheModel.getOrder().getTotalDiscountValue());
        out.setTotalValue(cacheModel.getOrder().getSaleValue());
        out.setOughtPay(cacheModel.getOrder().getOughtPay());
        out.setFlowNo(cacheModel.getFlowNo());
        return ServiceResponse.buildSuccess((Object)out);
    }

    private ServiceResponse choiceMealGoodsInfoValidate(ServiceSession session, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        return ServiceResponse.buildSuccess((Object)"success");
    }

    public ServiceResponse getStallPrintConfig(ServiceSession session, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        GetStallPrintConfigIn in = (GetStallPrintConfigIn)JSONObject.toJavaObject((JSON)paramsObject, GetStallPrintConfigIn.class);
        GetStallPrintConfigOut out = new GetStallPrintConfigOut();
        GetStallPrintInfoIn searchIn = new GetStallPrintInfoIn();
        searchIn.setShopCode(in.getShopCode());
        searchIn.setStallCode(in.getStallCode());
        ServiceResponse resp = this.mainDataCentreService.getStallInfo(this.restTemplate, session, searchIn);
        if (!"0".equals(resp.getReturncode())) {
            out.setBackPrintInfo(new ArrayList<StallInfoDef>());
        } else {
            GetStallPrintInfoOut searchOut = (GetStallPrintInfoOut)resp.getData();
            for (StallInfoDef stallInfo : searchOut.getStallinfo()) {
                if (null != stallInfo.getPrintAddress()) {
                    stallInfo.setPrintAddress(stallInfo.getPrintAddress().trim());
                    continue;
                }
                stallInfo.setPrintAddress("");
            }
            out.setBackPrintInfo(searchOut.getStallinfo());
        }
        return ServiceResponse.buildSuccess((Object)out);
    }

    public ServiceResponse getStallInfoList(ServiceSession session, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        GetStallListIn in = (GetStallListIn)JSONObject.toJavaObject((JSON)paramsObject, GetStallListIn.class);
        GetStallPrintConfigOut out = new GetStallPrintConfigOut();
        GetStallInfoListIn searchIn = new GetStallInfoListIn();
        searchIn.setShopCode(in.getShopCode());
        searchIn.setErpCode(in.getErpCode());
        ServiceResponse resp = this.mainDataCentreService.getStallInfoList(this.restTemplate, session, searchIn);
        if (!"0".equals(resp.getReturncode())) {
            out.setBackPrintInfo(new ArrayList<StallInfoDef>());
        } else {
            GetStallPrintInfoOut searchOut = (GetStallPrintInfoOut)resp.getData();
            for (StallInfoDef stallInfo : searchOut.getStallinfo()) {
                if (null == stallInfo.getPrintAddress()) continue;
                stallInfo.setPrintAddress(stallInfo.getPrintAddress().trim());
            }
            out.setBackPrintInfo(searchOut.getStallinfo());
        }
        return ServiceResponse.buildSuccess((Object)out);
    }

    public ServiceResponse queryGoodsDetailForApp(ServiceSession session, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validateWithOutFlowNoAndOperator()) {
            return paramsValidateUtils.getServiceResponse();
        }
        String erpCode = paramsObject.getString("erpCode");
        if (StringUtils.isBlank((String)erpCode)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"erpCode \u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{new Object()});
        }
        String channel = paramsObject.getString("channel");
        if (StringUtils.isBlank((String)channel)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"channel \u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{new Object()});
        }
        String barNo = paramsObject.getString("code");
        if (StringUtils.isBlank((String)barNo)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"code \u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{new Object()});
        }
        if (StringUtils.isBlank((String)paramsObject.getString("entId"))) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"entId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int eid = Integer.parseInt(paramsObject.getString("entId"));
        session.setEnt_id((long)eid);
        GetGoodsDetailIn queryGoodIn = (GetGoodsDetailIn)JSON.parseObject((String)paramsObject.toJSONString(), GetGoodsDetailIn.class);
        ElecScaleCodeRuleIn elecScaleCodeRuleIn = new ElecScaleCodeRuleIn();
        elecScaleCodeRuleIn.setErpCode(erpCode);
        elecScaleCodeRuleIn.setMkt(paramsObject.getString("shopCode"));
        ServiceResponse respElec = this.posManagerService.getElecCode(this.restTemplate, session, elecScaleCodeRuleIn);
        ArrayList<String> codes = new ArrayList<String>();
        codes.add("JYMS");
        boolean isdzcm = false;
        boolean isNeedFindMdm = true;
        DzcGoodsDetail dzc = null;
        boolean isNeedFindDzc = true;
        int priceMode = 0;
        int disMode = 0;
        double disValue = 0.0;
        GetGoodsDetailOut getGoodsDetail = null;
        GoodsInfo goodsInfo = new GoodsInfo();
        ServiceResponse serviceResponse = null;
        if (isNeedFindMdm && queryGoodIn.getCode().startsWith("20")) {
            List<GoodsInfo> goodsInfos;
            if (queryGoodIn.getCode().length() < 9) {
                queryGoodIn.setCode(Convert.padLeft(queryGoodIn.getCode(), '0', 9));
            } else {
                queryGoodIn.setCode(queryGoodIn.getCode());
            }
            serviceResponse = this.mainDataCentreService.getGoodsFromMDM(this.restTemplate, session, queryGoodIn);
            if (null != serviceResponse && "0".equals(serviceResponse.getReturncode()) && null != (goodsInfos = (getGoodsDetail = (GetGoodsDetailOut)serviceResponse.getData()).getGoods()) && goodsInfos.size() > 0) {
                isNeedFindMdm = false;
                goodsInfo = goodsInfos.get(0);
                getGoodsDetail.getGoods().set(0, goodsInfo);
                return ServiceResponse.buildSuccess((Object)getGoodsDetail);
            }
        }
        if (isNeedFindMdm) {
            if ("0".equals(respElec.getReturncode())) {
                ElecScaleCodeRuleOut elecCodeRuleOut = (ElecScaleCodeRuleOut)respElec.getData();
                List<ElecScaleCodeRule> elecCodeRules = elecCodeRuleOut.getElecscalecoderule();
                AnalyzeBarcodeDef codeInfo = this.posLogicCompoment.analyzeCodeInfo(2, queryGoodIn.getCode(), "0");
                if (!codeInfo.getValidate()) {
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8be5\u6761\u5f62\u7801\u65e0\u6cd5\u901a\u8fc7\u6821\u9a8c\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165");
                }
                queryGoodIn.setCode(codeInfo.getBarNo());
                isNeedFindDzc = codeInfo.getIsNeedFindDzc();
                priceMode = codeInfo.getPriceMode();
                disMode = codeInfo.getDisMode();
                disValue = codeInfo.getDisValue();
                if (isNeedFindDzc && elecCodeRules.size() > 0) {
                    dzc = this.posLogicCompoment.analyzeBarcode(queryGoodIn.getCode(), elecCodeRules, elecCodeRules.get(0).getExpModeMMDDDays(), elecCodeRules.get(0).getExpModeDDHHDays(), elecCodeRuleOut.getCodeRule());
                    if (dzc.getRetCode() == 2) {
                        return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8be5\u5546\u54c1\u5df2\u8fc7\u671f\uff0c\u4e0d\u5141\u8bb8\u9500\u552e");
                    }
                    if (dzc.getRetCode() == 1) {
                        isdzcm = true;
                    }
                }
            }
            if (isdzcm) {
                queryGoodIn.setCode(dzc.getCode());
                if (queryGoodIn.getCode().length() < 9) {
                    queryGoodIn.setCode(Convert.padLeft(queryGoodIn.getCode(), '0', 9));
                } else {
                    queryGoodIn.setCode(queryGoodIn.getCode());
                }
                serviceResponse = this.mainDataCentreService.getGoodsFromMDM(this.restTemplate, session, queryGoodIn);
                if (!serviceResponse.getReturncode().trim().equals("0")) {
                    return serviceResponse;
                }
                GetGoodsDetailOut goodsDetailOut = (GetGoodsDetailOut)serviceResponse.getData();
                List<GoodsInfo> goodsInfoList = goodsDetailOut.getGoods();
                if (goodsInfoList.size() == 0) {
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u672a\u67e5\u627e\u5230\u8be5\u5546\u54c1", (Object[])new Object[]{new Object()});
                }
                goodsInfo = goodsInfoList.get(0);
                goodsInfo.setSalePrice(dzc.getDzcmjg());
                goodsInfo.setEWCCodeAmount(dzc.getDzcmjg());
                goodsInfo.setEWCCodeNum(dzc.getDzcmsl());
                goodsInfo.setExpTime(dzc.getExpTime());
                goodsInfo.setPriceMode(1);
            } else {
                if (queryGoodIn.getCode().length() < 9) {
                    queryGoodIn.setCode(Convert.padLeft(queryGoodIn.getCode(), '0', 9));
                } else {
                    queryGoodIn.setCode(queryGoodIn.getCode());
                }
                serviceResponse = this.mainDataCentreService.getGoodsFromMDM(this.restTemplate, session, queryGoodIn);
                if (!serviceResponse.getReturncode().equals("0")) {
                    return serviceResponse;
                }
                getGoodsDetail = (GetGoodsDetailOut)serviceResponse.getData();
                List<GoodsInfo> goodsInfoList = getGoodsDetail.getGoods();
                if (goodsInfoList.size() == 0) {
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u672a\u67e5\u5230\u8be5\u5546\u54c1", (Object[])new Object[]{new Object()});
                }
                goodsInfo = goodsInfoList.get(0);
            }
        }
        LOGGER.info("PRICEMODE=" + priceMode + ",DISVALUE=" + disValue + ",DISMODE=" + disMode + ",SALEAMOUNT=" + goodsInfo.getSalePrice());
        if (priceMode == 2 && ManipulatePrecision.doubleCompare(disValue, 0.0, 2) > 0) {
            String precisionMode;
            goodsInfo.setPriceMode(1);
            if (disMode == 1) {
                if (ManipulatePrecision.doubleCompare(disValue, goodsInfo.getSalePrice(), 2) >= 0) {
                    goodsInfo.setSalePrice(0.0);
                } else {
                    goodsInfo.setSalePrice(ManipulatePrecision.doubleConvert(goodsInfo.getSalePrice() - disValue));
                }
            } else if (disMode == 2) {
                precisionMode = goodsInfo.getPrcutMode();
                if (ManipulatePrecision.doubleCompare(disValue, 100.0, 2) > 0) {
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u53d8\u4ef7\u6761\u5f62\u7801\u6298\u6263\u7387\u4e0d\u5141\u8bb8\u5927\u4e8e100");
                }
                goodsInfo.setSalePrice(ManipulatePrecision.getDetailOverFlow(goodsInfo.getSalePrice() - goodsInfo.getSalePrice() * disValue, precisionMode));
            } else if (disMode == 3 && ManipulatePrecision.doubleCompare(goodsInfo.getSalePrice(), disValue, 2) > 0) {
                precisionMode = DataExchageUtils.exchangePrecisionMode(goodsInfo.getPrcutMode());
                goodsInfo.setSalePrice(ManipulatePrecision.getDetailOverFlow(disValue, precisionMode));
            }
        }
        getGoodsDetail = new GetGoodsDetailOut();
        CalcsingleIn calcsingleIn = CalcsingleIn.build(goodsInfo, queryGoodIn);
        ServiceResponse response = this.promotionCentreService.queryPriceCalcsingle(this.restTemplate, session, calcsingleIn);
        if (!"0".equals(response.getReturncode())) {
            GoodsInfoForApp goodsforApp = GoodsInfoForApp.transferGoodsInfoToGoods(goodsInfo, 1.0);
            GetGoodsForApplOut out = new GetGoodsForApplOut();
            out.setGoods(new ArrayList<GoodsInfoForApp>());
            out.getGoods().add(goodsforApp);
            out.setTotalResult(1);
            return ServiceResponse.buildSuccess((Object)out);
        }
        CalcsingleOut calcsingleOut = (CalcsingleOut)response.getData();
        BillDetail billDetail = calcsingleOut.getBillDetail();
        List<SellDetail> sellDetails = billDetail.getSellDetails();
        SellDetail sellDetail = sellDetails.get(0);
        ArrayList<PopDetailForApp> popDetails = new ArrayList();
        if (sellDetail.getSellPopDetails() != null && sellDetail.getSellPopDetails().size() > 0) {
            popDetails = PopDetail.transferAppPopDetails(sellDetail.getSellPopDetails());
        }
        GoodsInfoForApp goodsforApp = GoodsInfoForApp.transferGoodsInfoToGoods(goodsInfo, 1.0);
        goodsforApp.setTotalDiscountAmount(sellDetail.getTotalDiscount());
        goodsforApp.setPopDetails(popDetails);
        GetGoodsForApplOut out = new GetGoodsForApplOut();
        out.setGoods(new ArrayList<GoodsInfoForApp>());
        out.getGoods().add(goodsforApp);
        out.setTotalResult(1);
        return ServiceResponse.buildSuccess((Object)out);
    }

    public ServiceResponse singleDisc(ServiceSession session, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        Double discountRate = paramsObject.getDouble("discountRate");
        if (discountRate == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5355\u884c\u6298\u6263\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u6298\u6263\u7387\u4e0d\u80fd\u4e3a\u7a7a"});
        }
        String guid = paramsObject.getString("guid");
        if (guid == null || guid.isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5355\u884c\u6298\u6263\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u5546\u54c1\u884c\u552f\u4e00\u884c\u53f7\u4e0d\u80fd\u4e3a\u7a7a"});
        }
        String flowNo = paramsObject.getString("flowNo");
        if (flowNo == null || flowNo.isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5355\u884c\u6298\u6263\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"flowNo\u4e0d\u80fd\u4e3a\u7a7a"});
        }
        CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(flowNo);
        if (cacheModel == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355", (Object[])new Object[]{flowNo});
        }
        Goods existGood = Goods.findGoods(guid, cacheModel.getGoodsList());
        if (null == existGood) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5355\u884c\u6298\u6263\u5546\u54c1\u65e0\u6cd5\u627e\u5230");
        }
        int flowId = existGood.getFlowId();
        String accreditNo = paramsObject.getString("accreditNo");
        double oldAmount = cacheModel.getOrder().getOughtPay();
        if (StringUtils.isBlank((String)accreditNo)) {
            accreditNo = cacheModel.getCurGrant().getGh();
        }
        if (cacheModel.getCurGrant().getPrivdpzkl() < 0.0) {
            if (null != cacheModel.getCurTempGrant() && StringUtils.isNotEmpty((String)cacheModel.getCurTempGrant().getGh())) {
                this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
            }
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"1000", (String)"\u5f53\u524d\u6388\u6743\u4eba\u5458\u4e0d\u5141\u8bb8\u5355\u54c1\u6253\u6298");
        }
        if (-1 == (cacheModel = this.posLogicServiceImpl.CalcGoodsRebateByRateBeforeSingle(cacheModel, flowId, accreditNo, discountRate)).getCalcResult()) {
            String errCode = "100000";
            String errMsg = cacheModel.getErrMsg();
            if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                errCode = cacheModel.getErrCode();
                if ("1000".equals(cacheModel.getErrCode()) && null != cacheModel.getCurTempGrant() && StringUtils.isNotEmpty((String)cacheModel.getCurTempGrant().getGh())) {
                    cacheModel = this.cacheModelService.getCacheModelByFlowNo(flowNo);
                    this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
                }
            }
            return ServiceResponse.buildFailure((ServiceSession)session, (String)errCode, (String)errMsg);
        }
        this.posLogicCompoment.calcOrderAmount(cacheModel);
        cacheModel = this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
        double newAmount = cacheModel.getOrder().getOughtPay();
        this.asyncTask.sendWorkLog(session, cacheModel.getOrder(), WorkLogType.singleDisc, ManipulatePrecision.doubleConvert(oldAmount - newAmount), existGood.getGoodsName(), existGood.getGoodsCode());
        BaseOutModel out = new BaseOutModel();
        out.setOrder(OrderForPos.toOrderForPosSingle(cacheModel));
        return ServiceResponse.buildSuccess((Object)out);
    }

    public ServiceResponse singleDiscAmount(ServiceSession session, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        Double discountAmount = paramsObject.getDouble("discountAmount");
        if (discountAmount == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5355\u884c\u6298\u8ba9\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u6298\u8ba9\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a"});
        }
        String accreditNo = paramsObject.getString("accreditNo");
        String guid = paramsObject.getString("guid");
        if (guid == null || guid.isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5355\u884c\u6298\u6263\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u5546\u54c1\u884c\u552f\u4e00\u884c\u53f7\u4e0d\u80fd\u4e3a\u7a7a"});
        }
        String flowNo = paramsObject.getString("flowNo");
        if (flowNo == null || flowNo.isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5355\u884c\u6298\u6263\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"flowNo\u4e0d\u80fd\u4e3a\u7a7a"});
        }
        SingleDiscAmountIn in = (SingleDiscAmountIn)JSON.parseObject((String)paramsObject.toJSONString(), SingleDiscAmountIn.class);
        CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(flowNo);
        if (cacheModel == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355", (Object[])new Object[]{flowNo});
        }
        if (!cacheModel.getOrder().getAllowEditGoods()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u8fdb\u5165\u652f\u4ed8\u73af\u8282\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u5546\u54c1", (Object[])new Object[]{flowNo});
        }
        Goods existGood = Goods.findGoods(guid, cacheModel.getGoodsList());
        if (null == existGood) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5355\u884c\u6298\u6263\u5546\u54c1\u65e0\u6cd5\u627e\u5230");
        }
        int flowId = existGood.getFlowId();
        if (StringUtils.isBlank((String)accreditNo)) {
            accreditNo = cacheModel.getCurGrant().getGh();
        }
        if (cacheModel.getCurGrant().getPrivdpzkl() < 0.0) {
            if (null != cacheModel.getCurTempGrant() && StringUtils.isNotEmpty((String)cacheModel.getCurTempGrant().getGh())) {
                this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
            }
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"1000", (String)"\u5f53\u524d\u6388\u6743\u4eba\u5458\u4e0d\u5141\u8bb8\u5355\u54c1\u6253\u6298");
        }
        double oldAmount = cacheModel.getOrder().getOughtPay();
        if (-1 == (cacheModel = this.posLogicServiceImpl.CalcGoodsRebateByAmountBeforeSingle(cacheModel, flowId, accreditNo, discountAmount, in.getMode(), false)).getCalcResult()) {
            String errCode = "100000";
            String errMsg = cacheModel.getErrMsg();
            if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                errCode = cacheModel.getErrCode();
                if ("1000".equals(cacheModel.getErrCode()) && null != cacheModel.getCurTempGrant() && StringUtils.isNotEmpty((String)cacheModel.getCurTempGrant().getGh())) {
                    cacheModel = this.cacheModelService.getCacheModelByFlowNo(flowNo);
                    this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
                }
            }
            return ServiceResponse.buildFailure((ServiceSession)session, (String)errCode, (String)errMsg);
        }
        cacheModel = this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
        double newAmount = cacheModel.getOrder().getOughtPay();
        this.asyncTask.sendWorkLog(session, cacheModel.getOrder(), WorkLogType.singleDiscAmount, ManipulatePrecision.doubleConvert(oldAmount - newAmount), existGood.getGoodsName(), existGood.getGoodsCode());
        BaseOutModel out = new BaseOutModel();
        out.setOrder(OrderForPos.toOrderForPosSingle(cacheModel));
        return ServiceResponse.buildSuccess((Object)out);
    }

    public ServiceResponse saveGoodsList(ServiceSession session, JSONObject paramsObject) {
        if (session == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50001");
        }
        if (paramsObject == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50003");
        }
        if (StringUtils.isBlank((String)paramsObject.getString("tradeno"))) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"\u6240\u9700\u516c\u5171\u5b57\u6bb5\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"tradeno"});
        }
        BarcodeCacheModel model = (BarcodeCacheModel)JSON.parseObject((String)paramsObject.toJSONString(), BarcodeCacheModel.class);
        ServiceResponse response = this.barcodeCacheModelService.saveOrUpdateBarcodeCacheModel(model);
        return response;
    }

    public ServiceResponse addBatchGoods(ServiceSession session, JSONObject paramsObject) {
        ServiceResponse validateData = this.addBatchGoodsValidate(session, paramsObject);
        if (!"0".equals(validateData.getReturncode())) {
            return validateData;
        }
        AddBatchGoodsInDef in = (AddBatchGoodsInDef)JSONObject.toJavaObject((JSON)paramsObject, AddBatchGoodsInDef.class);
        String tradeno = in.getTradeno();
        String flowNo = in.getFlowNo();
        BarcodeCacheModel barcodeCacheModel = this.barcodeCacheModelService.getBarcodeCacheModel(tradeno);
        CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(flowNo);
        if (cacheModel == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8d2d\u7269\u8f66\u4e0d\u5b58\u5728");
        }
        if (barcodeCacheModel == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"tradeno\u4e0d\u5b58\u5728");
        }
        if ("Y12".equals(cacheModel.getOrder().getOrderType())) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u4e3a\u5370\u82b1\u6362\u8d2d\u8ba2\u5355\uff0c\u4e0d\u5141\u8bb8\u6dfb\u52a0\u9884\u9500\u552e\u4fe1\u606f", (Object[])new Object[]{flowNo});
        }
        if (!cacheModel.getOrder().getAllowEditGoods()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u8fdb\u5165\u652f\u4ed8\u73af\u8282\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u5546\u54c1", (Object[])new Object[]{flowNo});
        }
        if (StringUtils.isBlank((String)cacheModel.getOrder().getSeqNo())) {
            LocalDateTime dateTime = LocalDateTime.now();
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            String nowDateTime = dateTime.format(df).toString();
            cacheModel.getOrder().setSaleDate(nowDateTime);
            cacheModel.getOrder().setSaleExtractTime(nowDateTime);
        }
        session.setEnt_id(cacheModel.getOrder().getEntId());
        ArrayList<Goods> goodsList = new ArrayList<Goods>();
        double totalQty = 0.0;
        ArrayList<String> guidList = new ArrayList<String>();
        int flowId = cacheModel.getGoodsList() == null || cacheModel.getGoodsList().isEmpty() ? 0 : cacheModel.getGoodsList().size();
        for (GoodsBarcode goodsBarcode : barcodeCacheModel.getBarcodeList()) {
            String qtystring = goodsBarcode.getQty();
            double qty = CastUtil.castDouble(qtystring);
            totalQty = ManipulatePrecision.add(totalQty, qty);
            String barcode = goodsBarcode.getBarcode();
            GetGoodsDetailIn getGoodsDetailIn = new GetGoodsDetailIn();
            getGoodsDetailIn.setEntId(session.getEnt_id());
            getGoodsDetailIn.setShopCode(cacheModel.getOrder().getShopCode());
            getGoodsDetailIn.setTerminalNo(in.getTerminalNo());
            getGoodsDetailIn.setCode(barcode);
            getGoodsDetailIn.setSearchType(in.getSearchType());
            getGoodsDetailIn.setOrgCode(in.getOrgCode());
            getGoodsDetailIn.setErpCode(in.getErpCode());
            ServiceResponse resp = this.mainDataCentreService.getGoodsFromMDM(this.restTemplate, session, getGoodsDetailIn);
            if (!"0".equals(resp.getReturncode())) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8bf7\u6c42\u4e3b\u6570\u636e\u4e2d\u5fc3\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5931\u8d25[{0}]", (Object[])new Object[]{resp.getData().toString()});
            }
            GetGoodsDetailOut goodsDetail = (GetGoodsDetailOut)resp.getData();
            if (goodsDetail.getGoods().size() == 0) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u6ca1\u6709\u4ece\u5546\u54c1\u8d44\u6599\u4e2d\u627e\u5230\u8d27\u53f7\u4e3a[{0}]\u7684\u5546\u54c1", (Object[])new Object[]{barcode});
            }
            GoodsInfo goodsInfo = goodsDetail.getGoods().get(0);
            if (goodsDetail.getGoods().size() > 1) {
                for (GoodsInfo g : goodsDetail.getGoods()) {
                    if (!g.getMainBarcodeFlag()) continue;
                    goodsInfo = g;
                    break;
                }
            }
            boolean isdzcm = false;
            if (goodsInfo.getSalePrice() < 0.1) continue;
            if (SellType.ISSALE(cacheModel.getOrder().getOrderType()) && !goodsInfo.isAllowSale()) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)("\u5546\u54c1" + barcode + "\u4e3a\u975e\u5141\u8bb8\u9500\u552e\u72b6\u6001"));
            }
            Goods goods = this.posLogicService.CalcGoodsAmountBeforeSingle(goodsInfo, in.getAssistantId(), isdzcm, 0.0, 0.0, cacheModel.getEleCodeMode(), barcode, qty);
            if (null == goods) continue;
            if (cacheModel.getMaxSaleGoodsQuantity() > 0.0 && qty > cacheModel.getMaxSaleGoodsQuantity()) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8d27\u53f7\u4e3a[{0}]\u7684\u5546\u54c1\u6570\u91cf\u8d85\u51fa\u5355\u884c\u53ef\u552e\u6700\u5927\u6570\u91cf", (Object[])new Object[]{barcode});
            }
            if (cacheModel.getMaxSaleGoodsMoney() > 0.0 && goods.getSalePrice() > cacheModel.getMaxSaleGoodsMoney()) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8d27\u53f7\u4e3a[{0}]\u7684\u5546\u54c1\u4ef7\u683c\u8d85\u51fa\u7cfb\u7edf\u6700\u5927\u96f6\u552e\u4ef7", (Object[])new Object[]{barcode});
            }
            Goods.transferGoodsInfoToGoods(goodsInfo, goods, qty);
            String guid = UUIDUtils.buildGuid();
            goods.setGuid(guid);
            goods.setFlowId(++flowId);
            goods.setFlowNo(in.getFlowNo());
            if (cacheModel.getOrder().getSysPara().getBarCodeMode() == 2) {
                goods.setTempCategory(goods.getArtCode());
            }
            goodsList.add(goods);
            guidList.add(guid);
        }
        if (null == goodsList || goodsList.size() == 0) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u9884\u9500\u552e\u6ca1\u6709\u6dfb\u52a0\u4efb\u4f55\u5546\u54c1");
        }
        List<Goods> cacheGoodsList = cacheModel.getGoodsList();
        cacheGoodsList.addAll(goodsList);
        cacheModel.setGoodsList(cacheGoodsList);
        if (cacheModel == null || cacheModel.getGoodsList() == null || cacheModel.getOrder() == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u9884\u9500\u552e\u8c03\u7528\u8ba1\u7b97\u65b9\u6cd5,\u6ca1\u6709\u83b7\u5f97\u6709\u6548CacheModel");
        }
        if (cacheModel.getPopMode() == 1) {
            cacheModel = this.promotionServiceImpl.calcSinglePopAll(session, "0", cacheModel, true);
        } else if (cacheModel.getPopMode() == 2) {
            String calcMode = "0";
            cacheGoodsList = Goods.combineSameGoods(cacheGoodsList);
            cacheModel.setGoodsList(cacheGoodsList);
            cacheModel = this.promotionServiceImpl.calcOrderPop(session, calcMode, cacheModel, false, false, false);
        } else {
            this.posLogicCompoment.calcOrderAmount(cacheModel);
        }
        if (cacheModel.getCalcResult() == -1) {
            String errCode = "100000";
            if (cacheModel.getErrCode().length() > 0) {
                errCode = cacheModel.getErrCode();
            }
            return ServiceResponse.buildFailure((ServiceSession)session, (String)errCode, (String)cacheModel.getErrMsg());
        }
        if (cacheModel.getMaxSaleMoney() > 0.0 && cacheModel.getOrder().getOughtPay() > cacheModel.getMaxSaleMoney()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u6574\u5355\u6210\u4ea4\u4ef7\u8d85\u51fa\u7cfb\u7edf\u8bbe\u5b9a\u6700\u5927\u6210\u4ea4\u91d1\u989d");
        }
        CacheModel model = this.cacheModelService.saveOrUpdateCacheModel(cacheModel = this.posLogicCompoment.calcGoodsCount(cacheModel));
        if (model == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u6dfb\u52a0\u5931\u8d25");
        }
        BaseOutModel out = new BaseOutModel();
        OrderForPos ofp = OrderForPos.toOrderForPosSingle(model);
        ofp.setQty(totalQty);
        out.setOrder(ofp);
        return ServiceResponse.buildSuccess((Object)out);
    }

    private List<GoodsInfo> GetGoodsInfo(GetGoodsDetailIn in, ServiceSession session) {
        try {
            GetGoodsDetailOut getGoodsDetailOut;
            List<GoodsInfo> goodsInfos;
            ServiceResponse resp = this.mainDataCentreService.getGoodsFromMDM(this.restTemplate, session, in);
            if (null != resp && "0".equals(resp.getReturncode()) && null != (goodsInfos = (getGoodsDetailOut = (GetGoodsDetailOut)resp.getData()).getGoods()) && goodsInfos.size() > 0) {
                return goodsInfos;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stringWriter));
            return null;
        }
    }

    private List<GoodsInfo> GetGoodsInfoWithTopCategory(GetGoodsDetailIn in, ServiceSession session) {
        try {
            GetGoodsDetailOut getGoodsDetailOut;
            List<GoodsInfo> goodsInfos;
            ServiceResponse resp = this.mainDataCentreService.getGoodsTopCateFromMDM(this.restTemplate, session, in);
            if (null != resp && "0".equals(resp.getReturncode()) && null != (goodsInfos = (getGoodsDetailOut = (GetGoodsDetailOut)resp.getData()).getGoods()) && goodsInfos.size() > 0) {
                return goodsInfos;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stringWriter));
            return null;
        }
    }
}

