/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pos.component;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.pos.component.CommonService;
import com.efuture.pos.component.OrderServiceImpl;
import com.efuture.pos.component.PosLogicCompoment;
import com.efuture.pos.component.PosLogicServiceImpl;
import com.efuture.pos.component.PromotionServiceImpl;
import com.efuture.pos.model.Goods;
import com.efuture.pos.model.PopDetail;
import com.efuture.pos.model.mainDataCentre.GoodsInfo;
import com.efuture.pos.model.mainDataCentre.request.GetGoodsDetailBySkuIn;
import com.efuture.pos.model.mainDataCentre.response.GetGoodsDetailOut;
import com.efuture.pos.model.promotionCentre.BillDetail;
import com.efuture.pos.model.promotionCentre.SellDetail;
import com.efuture.pos.model.promotionCentre.request.CalcSimpleTagIn;
import com.efuture.pos.model.promotionCentre.request.CalcsingleIn;
import com.efuture.pos.model.promotionCentre.response.CalcSimpleTagOut;
import com.efuture.pos.model.promotionCentre.response.CalcsingleOut;
import com.efuture.pos.model.request.SkuSearchIn;
import com.efuture.pos.model.response.SkuSearchOut;
import com.efuture.pos.service.MallGoodsService;
import com.efuture.pos.service.common.CacheModelService;
import com.efuture.pos.util.ManipulatePrecision;
import com.efuture.pos.util.ParamsValidateUtils;
import com.efuture.pos.util.UUIDUtils;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@ConditionalOnProperty(name={"epos.run"}, havingValue="yes", matchIfMissing=true)
@Service
public class MallGoodsServiceImpl
extends CommonService
implements MallGoodsService {
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    CacheModelService cacheModelService;
    @Autowired
    PosLogicServiceImpl posLogicService;
    @Autowired
    PosLogicCompoment posLogicCompoment;
    @Autowired
    OrderServiceImpl orderService;
    @Autowired
    PosLogicServiceImpl posLogicServiceImpl;
    @Autowired
    PromotionServiceImpl promotionServiceImpl;

    public ServiceResponse skuSearch(ServiceSession session, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.mallValidate(false)) {
            return paramsValidateUtils.getServiceResponse();
        }
        String erpCode = paramsObject.getString("erpCode");
        if (StringUtils.isBlank((String)erpCode)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"erpCode \u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{new Object()});
        }
        String channel = paramsObject.getString("channel");
        if (StringUtils.isBlank((String)channel)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"channel \u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{new Object()});
        }
        String barNo = paramsObject.getString("skuCode");
        if (StringUtils.isBlank((String)barNo)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"skuCode \u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{new Object()});
        }
        if (StringUtils.isBlank((String)paramsObject.getString("entId"))) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"entId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int eid = Integer.parseInt(paramsObject.getString("entId"));
        session.setEnt_id((long)eid);
        SkuSearchIn skuSearchIn = (SkuSearchIn)JSON.parseObject((String)paramsObject.toJSONString(), SkuSearchIn.class);
        ArrayList<Goods> goodsList = new ArrayList<Goods>();
        new GetGoodsDetailBySkuIn();
        GetGoodsDetailBySkuIn getGoodsDetailBySkuIn = GetGoodsDetailBySkuIn.transferSkuSearchInToOrderQueryIn(session, skuSearchIn);
        ServiceResponse serviceResponse = this.mainDataCentreService.getGoodsFromMDMBySkuCode(this.restTemplate, session, getGoodsDetailBySkuIn);
        if (!serviceResponse.getReturncode().equals("0")) {
            return serviceResponse;
        }
        GetGoodsDetailOut getGoodsDetail = (GetGoodsDetailOut)serviceResponse.getData();
        List<GoodsInfo> goodsInfoList = getGoodsDetail.getGoods();
        if (goodsInfoList.size() == 0) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u672a\u67e5\u5230\u8be5\u5546\u54c1", (Object[])new Object[]{new Object()});
        }
        GoodsInfo goodsInfo = goodsInfoList.get(0);
        Goods goods = new Goods();
        goods.setGuid(UUIDUtils.buildGuid());
        goods.setGoodsCode(goodsInfo.getGoodsCode());
        Goods.transferGoodsInfoToGoods(goodsInfo, goods, 1.0);
        SkuSearchOut goodOut = new SkuSearchOut();
        CalcsingleIn calcsingleIn = CalcsingleIn.build(goods, skuSearchIn);
        ServiceResponse response = this.promotionCentreService.queryPriceCalcsingle(this.restTemplate, session, calcsingleIn);
        if (!"0".equals(response.getReturncode())) {
            goodsList.add(goods);
            goodOut.setGoodsInfo(goodsList);
            return ServiceResponse.buildSuccess((Object)goodOut);
        }
        CalcsingleOut calcsingleOut = (CalcsingleOut)response.getData();
        BillDetail billDetail = calcsingleOut.getBillDetail();
        List<SellDetail> sellDetails = billDetail.getSellDetails();
        SellDetail sellDetail = sellDetails.get(0);
        goods.setSaleAmount(sellDetail.getSaleAmount());
        goods.setSaleValue(sellDetail.getSaleAmount());
        goods.setTotalDiscountValue(sellDetail.getTotalDiscount());
        goods.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(goods.getTotalDiscountValue() - goods.getNoDisAmountValue()));
        CalcSimpleTagIn requestIn = CalcSimpleTagIn.transfer(skuSearchIn, goods);
        response = this.promotionCentreService.calcAeonTag(this.restTemplate, session, requestIn);
        if (!response.getReturncode().trim().equals("0")) {
            goodsList.add(goods);
            goodOut.setGoodsInfo(goodsList);
            return ServiceResponse.buildSuccess((Object)goodOut);
        }
        CalcSimpleTagOut calcSimpleTagOut = (CalcSimpleTagOut)response.getData();
        if (calcSimpleTagOut.getSellDetails() == null || calcSimpleTagOut.getSellDetails().size() < 1) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8425\u9500\u4e2d\u5fc3\u67e5\u8be2\u4fc3\u9500\u5931\u8d25");
        }
        SellDetail sellDetailSimple = calcSimpleTagOut.getSellDetails().get(0);
        List<PopDetail> popDetails = new ArrayList<PopDetail>();
        if (sellDetail.getSellPopDetails() != null && sellDetailSimple.getSellPopDetails().size() > 0) {
            popDetails = PopDetail.transferPopDetail2(sellDetailSimple.getSellPopDetails());
        }
        goods.setPopDetailsInfo(popDetails);
        goods.setCustomDiscountValue(sellDetailSimple.getVipzk());
        goodsList.add(goods);
        goodOut.setGoodsInfo(goodsList);
        return ServiceResponse.buildSuccess((Object)goodOut);
    }
}

