/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pos.component;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.pos.component.CommonService;
import com.efuture.pos.component.PosLogicCompoment;
import com.efuture.pos.component.PosLogicServiceImpl;
import com.efuture.pos.component.PromotionServiceImpl;
import com.efuture.pos.model.BaseOutModel;
import com.efuture.pos.model.CacheModel;
import com.efuture.pos.model.ConsumersData;
import com.efuture.pos.model.Goods;
import com.efuture.pos.model.OperUser;
import com.efuture.pos.model.Order;
import com.efuture.pos.model.OrderForPos;
import com.efuture.pos.model.posManager.PosRoleManager;
import com.efuture.pos.model.posManager.request.OperUserIn;
import com.efuture.pos.model.posManager.request.QueryStaffAndRelativeInfoIn;
import com.efuture.pos.model.posManager.response.OperUserOut;
import com.efuture.pos.model.posManager.response.QueryStaffAndRelativeInfoOut;
import com.efuture.pos.model.promotionCentre.request.CalcsingleIn;
import com.efuture.pos.model.promotionCentre.request.CrminfoAuthIn;
import com.efuture.pos.model.promotionCentre.response.CalcsingleOut;
import com.efuture.pos.model.promotionCentre.response.CrminfoAuthOut;
import com.efuture.pos.model.request.FindGhIn;
import com.efuture.pos.model.request.FindOperUserIn;
import com.efuture.pos.model.request.FindStaffAndRelativeInfoIn;
import com.efuture.pos.model.request.MemberLoginIn;
import com.efuture.pos.model.response.FindOperUserOut;
import com.efuture.pos.model.response.MemberLoginOut;
import com.efuture.pos.service.MemberService;
import com.efuture.pos.service.common.CacheModelService;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.client.RestTemplate;

public class MemberServiceImpl
extends CommonService
implements MemberService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MemberServiceImpl.class);
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    CacheModelService cacheModelService;
    @Autowired
    PosLogicServiceImpl posLogicServiceImpl;
    @Autowired
    PosLogicCompoment posLogicCompoment;
    @Autowired
    PromotionServiceImpl promotionServiceImpl;
    @Value(value="${server.route.mode}")
    private String routeMode;

    public ServiceResponse login(ServiceSession session, JSONObject paramsObject) {
        if (StringUtils.isBlank((String)paramsObject.getString("certifyType"))) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4f1a\u5458\u767b\u5f55\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u8bf7\u6c42\u7c7b\u578b"});
        }
        if ("CANCEL".equals(paramsObject.getString("certifyType"))) {
            CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(paramsObject.getString("flowNo"));
            if (cacheModel == null) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355!", (Object[])new Object[]{paramsObject.getString("flowNo")});
            }
            Order order = cacheModel.getOrder();
            if (null != order.getConsumersData().getConsumersTrgs()) {
                order.getConsumersData().getConsumersTrgs().clear();
            }
            order.getConsumersData().setConsumersCard("");
            order.getConsumersData().setConsumersId("");
            order.getConsumersData().setConsumersType("");
            MemberLoginOut memberLoginOut = new MemberLoginOut();
            memberLoginOut.setConsumersCard("");
            memberLoginOut.setConsumersId("");
            memberLoginOut.setConsumersType("");
            memberLoginOut.setMemberIntegral(0.0);
            memberLoginOut.setFlowNo(paramsObject.getString("flowNo"));
            memberLoginOut.setIsHaveCart("N");
            memberLoginOut.setAccountRemain(0.0);
            memberLoginOut.setMaxRemain(0.0);
            memberLoginOut.setValidityDate("");
            memberLoginOut.setTotalValue(order.getSaleValue());
            memberLoginOut.setDiscountValue(order.getTotalDiscountValue());
            memberLoginOut.setOughtPay(order.getOughtPay());
            for (int i = 0; i < cacheModel.getGoodsList().size(); ++i) {
                Goods sg = cacheModel.getGoodsList().get(i);
                if (sg == null || !sg.getGoodsType().equals("99") && !sg.getGoodsType().equals("98")) continue;
                String couponCode = sg.getGoodsCode();
                cacheModel = this.posLogicCompoment.DelAeonOldCoupon(cacheModel, couponCode);
                cacheModel.getGoodsList().remove(i);
                --i;
            }
            if (cacheModel.getGoodsList() != null && cacheModel.getGoodsList().size() > 0) {
                for (Goods g : cacheModel.getGoodsList()) {
                    if (!g.getFlag().equals("7")) continue;
                    g.setFlag("1");
                }
                CalcsingleIn calcsingleIn = CalcsingleIn.memberLoginCreateCalcsingleIn(order, cacheModel.getGoodsList());
                ServiceResponse callCalcsingleResponse = this.promotionCentreService.callCalcsingle(this.restTemplate, session, calcsingleIn);
                if (!"0".equals(callCalcsingleResponse.getReturncode())) {
                    return callCalcsingleResponse;
                }
                CalcsingleOut calcsingleOut = (CalcsingleOut)callCalcsingleResponse.getData();
                order.setSeqNo(calcsingleOut.getCalcBillid());
                cacheModel = this.posLogicServiceImpl.CalcGoodsAmountAfterSingleAll(cacheModel, calcsingleOut, true);
                this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
                memberLoginOut.setGoodsList(cacheModel.getGoodsList());
            }
            return ServiceResponse.buildSuccess((Object)memberLoginOut);
        }
        if (StringUtils.isBlank((String)paramsObject.getString("consumersCard"))) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4f1a\u5458\u767b\u5f55\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u4f1a\u5458\u5361"});
        }
        if (StringUtils.isBlank((String)paramsObject.getString("channel"))) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4f1a\u5458\u767b\u5f55\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u7ba1\u9053"});
        }
        if (StringUtils.isBlank((String)paramsObject.getString("idType"))) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4f1a\u5458\u767b\u5f55\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u9a8c\u8bc1\u65b9\u5f0f"});
        }
        MemberLoginIn memberLoginIn = (MemberLoginIn)JSON.parseObject((String)paramsObject.toJSONString(), MemberLoginIn.class);
        if (memberLoginIn == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5165\u53c2\u8f6c\u6362\u5931\u8d25\uff01");
        }
        if (null == memberLoginIn.getFlowNo() || "".equals(memberLoginIn.getFlowNo())) {
            CrminfoAuthIn crminfoAuthIn = new CrminfoAuthIn().transferMemberLoginInToCrminfoAuthIn("", memberLoginIn);
            ServiceResponse response = this.promotionCentreService.crminfoAuth(this.restTemplate, session, crminfoAuthIn);
            if ("0".equals(response.getReturncode())) {
                MemberLoginOut memberLoginOut = ((CrminfoAuthOut)response.getData()).transferCrminfoAuthOutToMemberLoginOut(memberLoginIn);
                return ServiceResponse.buildSuccess((Object)memberLoginOut);
            }
            return response;
        }
        CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(memberLoginIn.getFlowNo());
        if (cacheModel == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355!", (Object[])new Object[]{memberLoginIn.getFlowNo()});
        }
        Order order = cacheModel.getOrder();
        if (order == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355\u4e3b\u4f53\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (order.getStaffSale()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5df2\u5237\u5458\u5de5\u5361\u4e0d\u5141\u8bb8\u5237\u4f1a\u5458\u5361");
        }
        for (int i = 0; i < cacheModel.getGoodsList().size(); ++i) {
            Goods sg = cacheModel.getGoodsList().get(i);
            if (sg == null || !sg.getGoodsType().equals("99") && !sg.getGoodsType().equals("98")) continue;
            String couponCode = sg.getGoodsCode();
            cacheModel = this.posLogicCompoment.DelAeonOldCoupon(cacheModel, couponCode);
            cacheModel.getGoodsList().remove(i);
            --i;
        }
        session.setEnt_id(order.getEntId());
        CrminfoAuthIn crminfoAuthIn = new CrminfoAuthIn().transferMemberLoginInToCrminfoAuthIn(Long.toString(order.getEntId()), memberLoginIn);
        ServiceResponse response = this.promotionCentreService.crminfoAuth(this.restTemplate, session, crminfoAuthIn);
        if ("0".equals(response.getReturncode())) {
            MemberLoginOut memberLoginOut = ((CrminfoAuthOut)response.getData()).transferCrminfoAuthOutToMemberLoginOut(memberLoginIn);
            ConsumersData cust = new ConsumersData();
            cust.setConsumersTrgs(memberLoginOut.getConsumersTrgs());
            cust.setConsumersCard(memberLoginOut.getConsumersCard());
            cust.setConsumersId(memberLoginOut.getConsumersId());
            cust.setConsumersType(memberLoginOut.getConsumersType());
            order.setConsumersData(cust);
            if (StringUtils.isNotBlank((String)paramsObject.getString("flowNo"))) {
                order.setFlowNo(paramsObject.getString("flowNo"));
                memberLoginOut.setFlowNo(paramsObject.getString("flowNo"));
            }
            if (cacheModel.getGoodsList() != null && cacheModel.getGoodsList().size() > 0) {
                CalcsingleIn calcsingleIn = CalcsingleIn.memberLoginCreateCalcsingleIn(order, cacheModel.getGoodsList());
                ServiceResponse callCalcsingleResponse = this.promotionCentreService.callCalcsingle(this.restTemplate, session, calcsingleIn);
                if (!"0".equals(callCalcsingleResponse.getReturncode())) {
                    return callCalcsingleResponse;
                }
                CalcsingleOut calcsingleOut = (CalcsingleOut)callCalcsingleResponse.getData();
                order.setSeqNo(calcsingleOut.getCalcBillid());
                cacheModel = this.posLogicServiceImpl.CalcGoodsAmountAfterSingleAll(cacheModel, calcsingleOut, true);
                this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
                memberLoginOut.setTotalValue(order.getSaleValue());
                memberLoginOut.setDiscountValue(order.getTotalDiscountValue());
                memberLoginOut.setOughtPay(order.getOughtPay());
                ArrayList<Goods> gList = new ArrayList<Goods>();
                for (Goods g : cacheModel.getGoodsList()) {
                    if (g.getIsNoBackGift()) continue;
                    if (null != g.getPopDetailsInfo() && g.getPopDetailsInfo().size() > 0) {
                        g = Goods.removeSinglePopDetails(g);
                    }
                    gList.add(g);
                }
                memberLoginOut.setGoodsList(gList);
            }
            return ServiceResponse.buildSuccess((Object)memberLoginOut);
        }
        return response;
    }

    public ServiceResponse getOperUser(ServiceSession session, JSONObject paramsObject) {
        FindOperUserIn OperUserIn2 = (FindOperUserIn)JSON.parseObject((String)paramsObject.toJSONString(), FindOperUserIn.class);
        if (OperUserIn2 == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5165\u53c2\u8f6c\u6362\u5931\u8d25\uff01");
        }
        if (OperUserIn2.getType() == 0 && StringUtils.isBlank((String)paramsObject.getString("cardNo"))) {
            LOGGER.info("\u5de5\u53f7\u6388\u6743");
            return this.getGh(session, paramsObject);
        }
        CacheModel cacheModel = null;
        Order order = null;
        if (OperUserIn2.getType() == 1 && StringUtils.isBlank((String)OperUserIn2.getCardNo())) {
            cacheModel = this.cacheModelService.getCacheModelByFlowNo(OperUserIn2.getFlowNo());
            if (cacheModel == null) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355!", (Object[])new Object[]{OperUserIn2.getFlowNo()});
            }
            cacheModel.setCurYyyInfo(new OperUser());
            this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
            return ServiceResponse.buildSuccess((Object)new OperUser());
        }
        if (StringUtils.isBlank((String)paramsObject.getString("shopCode"))) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u6388\u6743\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u95e8\u5e97\u53f7"});
        }
        if (StringUtils.isBlank((String)paramsObject.getString("erpCode"))) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u6388\u6743\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u7ecf\u8425\u516c\u53f8"});
        }
        if (StringUtils.isNotBlank((String)OperUserIn2.getFlowNo())) {
            cacheModel = this.cacheModelService.getCacheModelByFlowNo(OperUserIn2.getFlowNo());
            if (cacheModel == null) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355!", (Object[])new Object[]{OperUserIn2.getFlowNo()});
            }
            if (OperUserIn2.getType() == 0 && !"Y".equals(OperUserIn2.getIsAllowSelf()) && (OperUserIn2.getCardNo().equals(cacheModel.getOrder().getTerminalOperator()) || OperUserIn2.getCardNo().equals(cacheModel.getOrder().getScanGoodOperator()))) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"1001", (String)"\u81ea\u5df1\u4e0d\u80fd\u7ed9\u81ea\u5df1\u6388\u6743");
            }
            order = cacheModel.getOrder();
            if (order == null) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355\u4e3b\u4f53\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            session.setEnt_id(order.getEntId());
            OperUserIn2.setErpCode(order.getErpCode());
        }
        OperUserIn posManagerOperUserIn = new OperUserIn();
        posManagerOperUserIn.setCardno(OperUserIn2.getCardNo());
        posManagerOperUserIn.setMkt(OperUserIn2.getShopCode());
        posManagerOperUserIn.setErpCode(OperUserIn2.getErpCode());
        posManagerOperUserIn.setSyjh(OperUserIn2.getTerminalNo());
        posManagerOperUserIn.setRandomCode(OperUserIn2.getAuthCode());
        if (0 == OperUserIn2.getType()) {
            posManagerOperUserIn.setFlag("Y");
        } else if (1 == OperUserIn2.getType()) {
            posManagerOperUserIn.setFlag("S");
        }
        ServiceResponse response = new ServiceResponse();
        response = 1 == OperUserIn2.getType() ? this.posManagerService.getYyyOperUser(this.restTemplate, session, posManagerOperUserIn) : this.posManagerService.getOperUser(this.restTemplate, session, posManagerOperUserIn);
        if ("0".equals(response.getReturncode())) {
            OperUserOut posManagerOperUserOut = (OperUserOut)response.getData();
            if (null == posManagerOperUserOut.getOperuser() || StringUtils.isBlank((String)posManagerOperUserOut.getOperuser().getCardno())) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8be5\u4eba\u5458\u4fe1\u606f\u65e0\u6cd5\u627e\u5230");
            }
            if (!"Y".equals(OperUserIn2.getIsBasic())) {
                if (1 != OperUserIn2.getType() && null == posManagerOperUserOut.getPosrole()) {
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8be5\u4eba\u5458\u6ca1\u6709\u5bf9\u5e94\u89d2\u8272\u4fe1\u606f");
                }
                if (0 == OperUserIn2.getType() && !"Y".equals(posManagerOperUserOut.getPosrole().getIsgrant())) {
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8be5\u4eba\u5458\u6ca1\u6709\u6388\u6743\u6743\u9650");
                }
                if (1 == OperUserIn2.getType() && !"2".equals(posManagerOperUserOut.getOperuser().getGhtype())) {
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8be5\u4eba\u5458\u975e\u8425\u4e1a\u5458");
                }
            }
            OperUser operUser = new OperUser(posManagerOperUserOut);
            if (null != cacheModel) {
                if (0 == OperUserIn2.getType()) {
                    if (!"Y".equals(OperUserIn2.getIsAllowSelf()) && (operUser.getGh().equals(cacheModel.getOrder().getTerminalOperator()) || operUser.getGh().equals(cacheModel.getOrder().getScanGoodOperator()))) {
                        return ServiceResponse.buildFailure((ServiceSession)session, (String)"1001", (String)"\u81ea\u5df1\u4e0d\u80fd\u7ed9\u81ea\u5df1\u6388\u6743");
                    }
                    if (!cacheModel.getIsGrant()) {
                        cacheModel.setCurTempGrant(cacheModel.getCurGrant());
                        cacheModel.setIsGrant(true);
                    }
                    cacheModel.setCurGrant(operUser);
                } else if (1 == OperUserIn2.getType()) {
                    cacheModel.setCurYyyInfo(operUser);
                }
                this.cacheModelService.saveOrUpdateCacheModel(cacheModel, true);
            }
            FindOperUserOut OperUserOut2 = new FindOperUserOut(operUser);
            return ServiceResponse.buildSuccess((Object)OperUserOut2);
        }
        return response;
    }

    public ServiceResponse getCNAeonStaffInfo(ServiceSession session, JSONObject paramsObject) {
        CacheModel cacheModel = null;
        Order order = null;
        if (StringUtils.isBlank((String)paramsObject.getString("flowNo"))) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5458\u5de5\u6388\u6743\u5fc5\u987b\u5305\u542b\u53c2\u6570flowNo");
        }
        FindStaffAndRelativeInfoIn findStaffInfoIn = (FindStaffAndRelativeInfoIn)JSON.parseObject((String)paramsObject.toJSONString(), FindStaffAndRelativeInfoIn.class);
        if (findStaffInfoIn == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5165\u53c2\u8f6c\u6362\u5931\u8d25\uff01");
        }
        cacheModel = this.cacheModelService.getCacheModelByFlowNo(findStaffInfoIn.getFlowNo());
        if (cacheModel == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355!", (Object[])new Object[]{findStaffInfoIn.getFlowNo()});
        }
        order = cacheModel.getOrder();
        if (order == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355\u4e3b\u4f53\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((String)findStaffInfoIn.getCardNo()) && StringUtils.isBlank((String)findStaffInfoIn.getUserCode())) {
            order.setStaffCardNo("");
            order.setStaffType("");
            order.setStaffNo("");
            order.setStaffSale(false);
            cacheModel = this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
            BaseOutModel outInfo = new BaseOutModel();
            outInfo.setOrder(OrderForPos.toOrderForPos(cacheModel));
            return ServiceResponse.buildSuccess((Object)outInfo);
        }
        String userCode = findStaffInfoIn.getUserCode();
        if (userCode.equals(order.getScanGoodOperator()) || userCode.equals(order.getTerminalOperator())) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5f53\u524d\u6b3e\u673a\u767b\u5f55\u7684\u626b\u63cf\u5458\u6216\u6536\u94f6\u5458\u7684\u5de5\u53f7\u4e0d\u5141\u8bb8\u767b\u5f55\u5230\u5458\u5de5\u8d2d\u7269\u7684\u5de5\u53f7\u4e2d");
        }
        if (!"N".equals(cacheModel.getOrder().getSysPara().getStaffMode())) {
            QueryStaffAndRelativeInfoIn queryStaffAndRelativeInfoIn = new QueryStaffAndRelativeInfoIn();
            queryStaffAndRelativeInfoIn.setCardNo(findStaffInfoIn.getCardNo());
            queryStaffAndRelativeInfoIn.setUserCode(findStaffInfoIn.getUserCode());
            queryStaffAndRelativeInfoIn.setErpCode(findStaffInfoIn.getErpCode());
            ServiceResponse response = this.routeMode.equals("2") ? this.mainDataCentreService.getStaffInfoIdc(this.restTemplate, session, queryStaffAndRelativeInfoIn) : this.mainDataCentreService.getStaffInfo(this.restTemplate, session, queryStaffAndRelativeInfoIn);
            QueryStaffAndRelativeInfoOut queryOut = new QueryStaffAndRelativeInfoOut();
            if (!"0".equals(response.getReturncode())) {
                return response;
            }
            queryOut = (QueryStaffAndRelativeInfoOut)response.getData();
            if (null == queryOut.getAccount() || queryOut.getAccount().size() == 0) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u6ca1\u6709\u67e5\u627e\u5230\u6709\u6548\u5458\u5de5\u4fe1\u606f");
            }
            if (StringUtils.isBlank((String)queryOut.getAccount().get(0).getUserCode())) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u6ca1\u6709\u67e5\u627e\u5230\u6709\u6548\u5458\u5de5\u4fe1\u606f");
            }
            cacheModel.getOrder().setStaffCardNo(queryOut.getAccount().get(0).getCardno());
            cacheModel.getOrder().setStaffType("" + queryOut.getAccount().get(0).getCtype());
            cacheModel.getOrder().setStaffNo(queryOut.getAccount().get(0).getUserCode());
            cacheModel.getOrder().setStaffSale(true);
        } else {
            cacheModel.getOrder().setStaffCardNo(findStaffInfoIn.getCardNo());
            cacheModel.getOrder().setStaffType("1");
            cacheModel.getOrder().setStaffNo(findStaffInfoIn.getUserCode());
            cacheModel.getOrder().setStaffSale(true);
        }
        cacheModel = this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
        BaseOutModel outInfo = new BaseOutModel();
        outInfo.setOrder(OrderForPos.toOrderForPosSingle(cacheModel));
        return ServiceResponse.buildSuccess((Object)outInfo);
    }

    public CacheModel cancelOrderMember(JSONObject paramsObject, ServiceSession session) {
        String flowNo = paramsObject.getString("flowNo");
        CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(flowNo);
        if (cacheModel == null) {
            throw new RuntimeException(String.format("\u8ba2\u5355[%1$s]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355!", flowNo));
        }
        Order order = cacheModel.getOrder();
        if (null != order.getConsumersData().getConsumersTrgs()) {
            order.getConsumersData().getConsumersTrgs().clear();
        }
        order.getConsumersData().setConsumersCard("");
        order.getConsumersData().setConsumersId("");
        order.getConsumersData().setConsumersType("");
        return cacheModel;
    }

    public CacheModel calcAfterMemberLoginOrCancel(CacheModel cacheModel, JSONObject paramsObject, ServiceSession session) {
        cacheModel.callMarketClear();
        cacheModel = this.posLogicCompoment.removeAeonCouponPopDetail(cacheModel);
        cacheModel.getOrder().setSeqNo("");
        if (cacheModel.getPopMode() == 1 || cacheModel.getPopMode() == 3) {
            cacheModel = this.promotionServiceImpl.calcSinglePopAll(session, "0", cacheModel, true);
        } else if (cacheModel.getPopMode() == 2) {
            String calcMode = "0";
            cacheModel = this.promotionServiceImpl.calcOrderPop(session, calcMode, cacheModel, false, true, false);
        } else {
            this.posLogicCompoment.calcOrderAmount(cacheModel);
        }
        cacheModel = this.posLogicCompoment.CalcAdjustDiscAfterOrder(cacheModel);
        return cacheModel;
    }

    public ServiceResponse getGh(ServiceSession session, JSONObject paramsObject) {
        ServiceResponse response;
        if (StringUtils.isBlank((String)paramsObject.getString("gh"))) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u6388\u6743\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u5de5\u53f7"});
        }
        if (StringUtils.isBlank((String)paramsObject.getString("shopCode"))) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u6388\u6743\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u95e8\u5e97\u53f7"});
        }
        if (StringUtils.isBlank((String)paramsObject.getString("erpCode"))) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u6388\u6743\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u7ecf\u8425\u516c\u53f8"});
        }
        FindGhIn ghIn = (FindGhIn)JSON.parseObject((String)paramsObject.toJSONString(), FindGhIn.class);
        if (ghIn == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5165\u53c2\u8f6c\u6362\u5931\u8d25\uff01");
        }
        CacheModel cacheModel = null;
        Order order = null;
        if (null != ghIn.getFlowNo() && ghIn.getFlowNo().length() > 0) {
            cacheModel = this.cacheModelService.getCacheModelByFlowNo(ghIn.getFlowNo());
            if (cacheModel == null) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355!", (Object[])new Object[]{ghIn.getFlowNo()});
            }
            if (!"Y".equals(ghIn.getIsAllowSelf()) && ghIn.getGh().equals(cacheModel.getOrder().getGh())) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"1001", (String)"\u81ea\u5df1\u4e0d\u80fd\u7ed9\u81ea\u5df1\u6388\u6743");
            }
            order = cacheModel.getOrder();
            if (order == null) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355\u4e3b\u4f53\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            session.setEnt_id(order.getEntId());
            ghIn.setErpCode(order.getErpCode());
        }
        ghIn.setMkt(ghIn.getShopCode());
        ghIn.setRandomCode(paramsObject.getString("authCode"));
        if (null == ghIn.getPasswd()) {
            ghIn.setPasswd("");
        }
        if ("0".equals((response = this.posManagerService.getGh(this.restTemplate, session, ghIn)).getReturncode())) {
            OperUserOut posManagerOperUserOut = (OperUserOut)response.getData();
            if (null == posManagerOperUserOut.getOperuser() || null == posManagerOperUserOut.getOperuser().getCardno() || posManagerOperUserOut.getOperuser().getCardno().length() == 0) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8be5\u4eba\u5458\u4fe1\u606f\u65e0\u6cd5\u627e\u5230");
            }
            PosRoleManager posrole = posManagerOperUserOut.getPosrole();
            if (!"Y".equals(ghIn.getIsBasic())) {
                if (null == posrole) {
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8be5\u4eba\u5458\u6ca1\u6709\u6388\u6743\u6743\u9650");
                }
                if (0 == ghIn.getType() && !"Y".equals(posrole.getIsgrant())) {
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8be5\u4eba\u5458\u6ca1\u6709\u6388\u6743\u6743\u9650");
                }
                if (1 == ghIn.getType() && !"2".equals(posManagerOperUserOut.getOperuser().getGhtype())) {
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8be5\u4eba\u5458\u975e\u8425\u4e1a\u5458");
                }
            }
            OperUser operUser = new OperUser(posManagerOperUserOut);
            if (null != cacheModel) {
                if (!"Y".equals(ghIn.getIsAllowSelf()) && (operUser.getCardno().equals(cacheModel.getOrder().getTerminalOperator()) || operUser.getCardno().equals(cacheModel.getOrder().getScanGoodOperator()))) {
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"1001", (String)"\u81ea\u5df1\u4e0d\u80fd\u7ed9\u81ea\u5df1\u6388\u6743");
                }
                if (!cacheModel.getIsGrant()) {
                    cacheModel.setIsGrant(true);
                    cacheModel.setCurTempGrant(cacheModel.getCurGrant());
                }
                cacheModel.setCurGrant(operUser);
                this.cacheModelService.saveOrUpdateCacheModel(cacheModel, true);
            }
            FindOperUserOut OperUserOut2 = new FindOperUserOut(operUser);
            return ServiceResponse.buildSuccess((Object)OperUserOut2);
        }
        return response;
    }
}

