/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pos.component;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.pos.component.PosLogicServiceImpl;
import com.efuture.pos.component.service.MainDataCentreService;
import com.efuture.pos.model.BaseOutModel;
import com.efuture.pos.model.CacheModel;
import com.efuture.pos.model.Goods;
import com.efuture.pos.model.Order;
import com.efuture.pos.model.OrderForPos;
import com.efuture.pos.model.Payment;
import com.efuture.pos.model.mainDataCentre.PaymentMethod;
import com.efuture.pos.model.mainDataCentre.request.QueryPaymentmethodIn;
import com.efuture.pos.model.mainDataCentre.response.QueryPaymentmethodOut;
import com.efuture.pos.pay.AeonPayTools;
import com.efuture.pos.pay.model.aeon.BasePayRequest;
import com.efuture.pos.pay.model.aeon.BasePayResponse;
import com.efuture.pos.pay.model.aeon.GoodsDetails;
import com.efuture.pos.pay.model.aeon.request.PayQueryRequest;
import com.efuture.pos.pay.model.aeon.request.PayRefundQueryRequest;
import com.efuture.pos.pay.model.aeon.request.PayRefundRequest;
import com.efuture.pos.pay.model.aeon.request.PayRequest;
import com.efuture.pos.pay.model.aeon.request.RepealPayRequest;
import com.efuture.pos.pay.model.aeon.response.PayQueryResponse;
import com.efuture.pos.pay.model.aeon.response.PayRefundQueryResponse;
import com.efuture.pos.pay.model.aeon.response.PayRefundResponse;
import com.efuture.pos.pay.model.aeon.response.PayResponse;
import com.efuture.pos.pay.model.aeon.response.RepealPayResponse;
import com.efuture.pos.service.MiyaPayService;
import com.efuture.pos.service.common.CacheModelService;
import com.efuture.pos.util.CastUtil;
import com.efuture.pos.util.ManipulatePrecision;
import com.efuture.pos.util.ParamsValidateUtils;
import com.efuture.pos.util.UUIDUtils;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.client.RestTemplate;

public class MiyaPayServiceImpl
implements MiyaPayService {
    private static final Logger logger = LoggerFactory.getLogger(MiyaPayServiceImpl.class);
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    CacheModelService cacheModelService;
    @Autowired
    PosLogicServiceImpl posLogicServiceImpl;
    @Autowired
    public MainDataCentreService mainDataCentreService;
    private static final String SUCCESS = "SUCCESS";
    private String miyaBizCode = "";
    private String mkey = "";
    private String murl = "";

    public ServiceResponse salePayQuery(ServiceSession session, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        if (!paramsObject.containsKey((Object)"terminalSno") || paramsObject.getString("terminalSno").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355\u67e5\u8a62\u5fc5\u9808\u5305\u542b\u53c3\u6578[{0}]", (Object[])new Object[]{"\u5c0f\u7968\u865f"});
        }
        if (!paramsObject.containsKey((Object)"rate") || paramsObject.getDouble("rate").isNaN()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355\u67e5\u8be2\u5fc5\u9808\u5305\u542b\u53c3\u6578[{0}]", (Object[])new Object[]{"\u532f\u7387"});
        }
        if (!paramsObject.containsKey((Object)"precision") || paramsObject.getString("precision").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355\u67e5\u8be2\u5fc5\u9808\u5305\u542b\u53c3\u6578[{0}]", (Object[])new Object[]{"\u56db\u6368\u4e94\u5165\u7cbe\u5ea6"});
        }
        if (!paramsObject.containsKey((Object)"cutMode") || paramsObject.getString("cutMode").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355\u67e5\u8be2\u5fc5\u9808\u5305\u542b\u53c3\u6578[{0}]", (Object[])new Object[]{"\u56db\u6368\u4e94\u5165\u65b9\u5f0f"});
        }
        if (!paramsObject.containsKey((Object)"erpCode") || paramsObject.getString("erpCode").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355\u67e5\u8be2\u5fc5\u9808\u5305\u542b\u53c3\u6578[{0}]", (Object[])new Object[]{"erpCode"});
        }
        String flowNo = paramsObject.getString("flowNo");
        CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(flowNo);
        if (cacheModel == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8a02\u55ae[{0}]\u5df2\u5931\u6548\uff0c\u8acb\u91cd\u65b0\u751f\u6210\u8a02\u55ae", (Object[])new Object[]{flowNo});
        }
        if (null == cacheModel.getPaymentmethodposref() || cacheModel.getPaymentmethodposref().size() <= 0) {
            ServiceResponse res = this.queryPaymentmethod(session, paramsObject.getString("erpCode"));
            if (!"0".equals(res.getReturncode())) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8bf7\u6c42\u4e3b\u6570\u636e\u4e2d\u5fc3\u67e5\u8be2\u652f\u4ed8\u65b9\u5f0f\u5931\u8d25[{0}]", (Object[])new Object[]{res.getData().toString()});
            }
            QueryPaymentmethodOut out = (QueryPaymentmethodOut)res.getData();
            cacheModel.setPaymentmethodposref(out.getPaymentmethodposref());
            this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
        }
        Order order = cacheModel.getOrder();
        this.miyaBizCode = order.getSysPara().getMsid();
        this.mkey = order.getSysPara().getMkey();
        this.murl = order.getSysPara().getMadr();
        if (StringUtils.isBlank((String)this.murl)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4ece\u603b\u90e8\u83b7\u53d6\u7c73\u96c5\u8bf7\u6c42\u5730\u5740\u5931\u8d25");
        }
        if (StringUtils.isBlank((String)this.miyaBizCode)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4ece\u603b\u90e8\u83b7\u53d6\u7c73\u96c5\u5546\u6237\u53f7\u5931\u8d25");
        }
        if (StringUtils.isBlank((String)this.mkey)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4ece\u603b\u90e8\u83b7\u53d6\u7c73\u96c5\u7b7e\u540d\u79d8\u94a5\u5931\u8d25");
        }
        paramsObject.put("optType", (Object)"B");
        paramsObject.put("miyaBizCode", (Object)this.miyaBizCode);
        String merchantOrderNo = "";
        boolean isBd = false;
        if (StringUtils.isNotBlank((String)paramsObject.getString("merchantOrderNo"))) {
            merchantOrderNo = paramsObject.getString("merchantOrderNo");
            isBd = true;
        } else {
            merchantOrderNo = cacheModel.getOrder().getMerchantOrderNo();
        }
        Boolean hasPayment = false;
        List<Payment> cacheList = cacheModel.getPayments();
        for (Payment payment : cacheList) {
            if (!payment.getRefCode().equals(merchantOrderNo)) continue;
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u652f\u4ed8\u5931\u8d25\uff1a\u8be5\u7b14\u652f\u4ed8\u65b9\u5f0f\u5df2\u5b58\u5728");
        }
        PayQueryRequest payQueryRequest = new PayQueryRequest(paramsObject);
        payQueryRequest.getData().setIdSheetNo(merchantOrderNo);
        PayQueryResponse payResponse = AeonPayTools.salePayQuery(payQueryRequest, this.murl, this.mkey);
        if (this.isRequestSuccess(payResponse)) {
            String cmft;
            if ("PAYWAIT".equals(payResponse.getStatusCode())) {
                for (int i = 0; i < 11; ++i) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    payResponse = AeonPayTools.salePayQuery(payQueryRequest, this.murl, this.mkey);
                    if (!"PAYWAIT".equals(payResponse.getStatusCode())) break;
                }
                if (!"PAYSUCCESS".equals(payResponse.getStatusCode())) {
                    return this.buildErrResponse(session, payResponse, "\u652f\u4ed8\u8a02\u55ae\u67e5\u8a62");
                }
            }
            if (isBd && StringUtils.isNotBlank((String)(cmft = cacheModel.getOrder().getSysPara().getCmft())) && CastUtil.castLong(cmft) > 0L) {
                try {
                    String channelTransationTime = payResponse.getChannelTransationTime();
                    LocalDateTime dateTime = LocalDateTime.now();
                    DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                    LocalDateTime orderDateTime = LocalDateTime.parse(channelTransationTime, df);
                    Duration duration = Duration.between(orderDateTime, dateTime);
                    if (duration.toMinutes() - CastUtil.castLong(cmft) > 0L) {
                        return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u652f\u4ed8\u5931\u8d25\uff1a\u8d85\u8fc7\u4ea4\u6613\u95f4\u9694\u65f6\u95f4\u4e0d\u5141\u8bb8\u4f7f\u7528\u67e5\u8be2\u652f\u4ed8");
                    }
                }
                catch (Exception e) {
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u6821\u9a8c\u4ea4\u6613\u95f4\u9694\u65f6\u95f4\u51fa\u73b0\u5f02\u5e38");
                }
            }
            if (!hasPayment.booleanValue()) {
                BasePayRequest.Request request = payQueryRequest.getRequest();
                String channelFlag = payResponse.getChannelFlag();
                PaymentMethod paymentmethod = this.getPaymentmethod(channelFlag, cacheModel.getPaymentmethodposref());
                if (null == paymentmethod) {
                    paramsObject.put("originIdSheetNo", (Object)merchantOrderNo);
                    for (int i = 0; i < 3; ++i) {
                        paramsObject.put("optType", (Object)"E");
                        paramsObject.put("miyaBizCode", (Object)this.miyaBizCode);
                        RepealPayRequest repealPayRequest = new RepealPayRequest(paramsObject);
                        repealPayRequest.getData().setIdSheetNo(null);
                        RepealPayResponse rayResponse = AeonPayTools.repealPay(repealPayRequest, this.murl, this.mkey);
                        if (this.isRequestSuccess(rayResponse)) {
                            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u652f\u4ed8\u5931\u8d25\uff1a\u652f\u4ed8\u65b9\u5f0f\u672a\u914d\u7f6e\uff0c\u5df2\u64a4\u9500");
                        }
                        try {
                            Thread.sleep(3000L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5b8c\u6210\u4e86\u672a\u914d\u7f6e\u7684\u4ea4\u6613\uff0c\u8bf7\u8054\u7cfbIT\u90e8\u95e8");
                }
                Payment payment = new Payment();
                payment.setPuid(UUIDUtils.buildPuid());
                payment.setRownoId(payment.getPuid());
                payment.setPayCode(paymentmethod.getPosAbleCode());
                payment.setPayName(paymentmethod.getPosAbleName());
                payment.setPayNo(payQueryRequest.getData().getIdSheetNo());
                double money = 0.0;
                if (null != payResponse.getDiscountInfo() && payResponse.getDiscountInfo().length() > 2) {
                    String discountInfoStr = payResponse.getDiscountInfo().substring(1, payResponse.getDiscountInfo().length() - 1);
                    String[] moneyStrs = discountInfoStr.split("\\|");
                    for (int i = 0; i < moneyStrs.length; ++i) {
                        String moneyStr = moneyStrs[i];
                        money += ManipulatePrecision.doubleConvert(Double.valueOf(moneyStr) / 100.0, 2, 1);
                    }
                } else {
                    money = ManipulatePrecision.doubleConvert(Double.valueOf(payResponse.getMoney()) / 100.0, 2, 1);
                }
                payment.setMoney(money);
                payment.setAmount(money);
                payment.setRate(1.0);
                payment.setPrecision(paramsObject.getString("precision"));
                payment.setPrcutMode(paramsObject.getString("cutMode"));
                payment.setFlag("1");
                payment.setTerminalNo(request.getTerminalNo());
                payment.setTerminalSno(request.getTerminalSno());
                payment.setRefCode(payQueryRequest.getData().getIdSheetNo());
                String discountInfo = payResponse.getDiscountInfo();
                JSONObject discObj = payResponse.resolveDiscounts(discountInfo);
                payment.setDiscountValue(discObj.getDoubleValue("discounts") + discObj.getDoubleValue("channelDiscounts") + discObj.getDoubleValue("otherDiscounts"));
                payment.setMerchantDiscountValue(discObj.getDoubleValue("discounts"));
                payment.setPayChannelDiscountValue(discObj.getDoubleValue("channelDiscounts") + discObj.getDoubleValue("otherDiscounts"));
                payment.setRowno(cacheModel.getPayments().size() + 1);
                cacheModel = this.posLogicServiceImpl.calcPayAmout(cacheModel, payment);
            }
            this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
            BaseOutModel out = new BaseOutModel();
            out.setOrder(OrderForPos.toOrderForPos(cacheModel));
            return ServiceResponse.buildSuccess((Object)out);
        }
        return this.buildErrResponse(session, payResponse, "\u652f\u4ed8\u8ba2\u5355\u67e5\u8be2");
    }

    public ServiceResponse salePay(ServiceSession session, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        if (!paramsObject.containsKey((Object)"payBarCode") || paramsObject.getString("payBarCode").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u652f\u4ed8\u5fc5\u9808\u5305\u542b\u53c3\u6578[{0}]", (Object[])new Object[]{"\u652f\u4ed8\u78bc"});
        }
        if (!paramsObject.containsKey((Object)"amount") || paramsObject.getString("amount").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u652f\u4ed8\u5fc5\u9808\u5305\u542b\u53c3\u6578[{0}]", (Object[])new Object[]{"\u652f\u4ed8\u91d1\u984d"});
        }
        if (!paramsObject.containsKey((Object)"terminalSno") || paramsObject.getString("terminalSno").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u652f\u4ed8\u5fc5\u9808\u5305\u542b\u53c3\u6578[{0}]", (Object[])new Object[]{"\u5c0f\u7968\u53f7"});
        }
        if (!paramsObject.containsKey((Object)"rate") || paramsObject.getDouble("rate").isNaN()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u652f\u4ed8\u5fc5\u9808\u5305\u542b\u53c3\u6578[{0}]", (Object[])new Object[]{"\u532f\u7387"});
        }
        if (!paramsObject.containsKey((Object)"precision") || paramsObject.getString("precision").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u652f\u4ed8\u5fc5\u9808\u5305\u542b\u53c3\u6578[{0}]", (Object[])new Object[]{"\u56db\u6368\u4e94\u5165\u7cbe\u5ea6"});
        }
        if (!paramsObject.containsKey((Object)"cutMode") || paramsObject.getString("cutMode").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u652f\u4ed8\u5fc5\u9808\u5305\u542b\u53c3\u6578[{0}]", (Object[])new Object[]{"\u56db\u6368\u4e94\u5165\u65b9\u5f0f"});
        }
        if (!paramsObject.containsKey((Object)"erpCode") || paramsObject.getString("erpCode").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u652f\u4ed8\u5fc5\u9808\u5305\u542b\u53c3\u6578[{0}]", (Object[])new Object[]{"erpCode"});
        }
        String flowNo = paramsObject.getString("flowNo");
        CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(flowNo);
        if (cacheModel == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8a02\u55ae[{0}]\u5df2\u5931\u6548\uff0c\u8acb\u91cd\u65b0\u751f\u6210\u8a02\u55ae", (Object[])new Object[]{flowNo});
        }
        if (null == cacheModel.getPaymentmethodposref() || cacheModel.getPaymentmethodposref().size() <= 0) {
            ServiceResponse res = this.queryPaymentmethod(session, paramsObject.getString("erpCode"));
            if (!"0".equals(res.getReturncode())) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8bf7\u6c42\u4e3b\u6570\u636e\u4e2d\u5fc3\u67e5\u8be2\u652f\u4ed8\u65b9\u5f0f\u5931\u8d25[{0}]", (Object[])new Object[]{res.getData().toString()});
            }
            QueryPaymentmethodOut out = (QueryPaymentmethodOut)res.getData();
            cacheModel.setPaymentmethodposref(out.getPaymentmethodposref());
            this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
        }
        Order order = cacheModel.getOrder();
        this.miyaBizCode = order.getSysPara().getMsid();
        this.mkey = order.getSysPara().getMkey();
        this.murl = order.getSysPara().getMadr();
        if (StringUtils.isBlank((String)this.murl)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4ece\u603b\u90e8\u83b7\u53d6\u7c73\u96c5\u8bf7\u6c42\u5730\u5740\u5931\u8d25");
        }
        if (StringUtils.isBlank((String)this.miyaBizCode)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4ece\u603b\u90e8\u83b7\u53d6\u7c73\u96c5\u5546\u6237\u53f7\u5931\u8d25");
        }
        if (StringUtils.isBlank((String)this.mkey)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4ece\u603b\u90e8\u83b7\u53d6\u7c73\u96c5\u7b7e\u540d\u79d8\u94a5\u5931\u8d25");
        }
        double remainValue = (cacheModel = this.posLogicServiceImpl.calcBalance(cacheModel)).getOrder().getRemainValue();
        if (remainValue <= 0.0) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5df2\u4ed8\u6e05\u6b3e\u9805\uff0c\u7121\u9700\u518d\u652f\u4ed8\uff01");
        }
        remainValue = ManipulatePrecision.doubleConvert(remainValue, 2, 0);
        paramsObject.put("optType", (Object)"A");
        paramsObject.put("miyaBizCode", (Object)this.miyaBizCode);
        PayRequest payReq = new PayRequest(paramsObject);
        String merchantOrderNo = MiyaPayServiceImpl.getMerchantOrderNo(paramsObject);
        List<Goods> goodsList = cacheModel.getGoodsList();
        ArrayList<GoodsDetails> goodsDetails = new ArrayList<GoodsDetails>();
        for (Goods goods : goodsList) {
            GoodsDetails d = new GoodsDetails();
            d.setQty(goods.getQty());
            d.setGoodsCode(goods.getGoodsCode());
            d.setGoodsName(goods.getGoodsName().replaceAll("\"", "").replaceAll(">", "").replaceAll("'", "").replaceAll("&", "").replaceAll("<", ""));
            d.setSalePrice(goods.getSalePrice());
            goodsDetails.add(d);
        }
        PayRequest.PayRequestData data = (PayRequest.PayRequestData)payReq.getData();
        data.setGoodsDetails(JSON.toJSONString(goodsDetails));
        double amount = ManipulatePrecision.getDetailOverFlow(paramsObject.getDouble("amount"), paramsObject.getString("cutMode"));
        data.setMoney((int)ManipulatePrecision.doubleConvert(amount * 100.0));
        data.setIdSheetNo(merchantOrderNo);
        PayResponse payResponse = AeonPayTools.salePay(payReq, this.murl, this.mkey);
        cacheModel.getOrder().setMerchantOrderNo(merchantOrderNo);
        this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
        if (this.isRequestSuccess(payResponse)) {
            if ("PAYWAIT".equals(payResponse.getStatusCode())) {
                return this.buildPayWaitResponse(session, payResponse);
            }
            BasePayRequest.Request request = payReq.getRequest();
            String channelFlag = payResponse.getChannelFlag();
            PaymentMethod paymentmethod = this.getPaymentmethod(channelFlag, cacheModel.getPaymentmethodposref());
            if (null == paymentmethod) {
                paramsObject.put("originIdSheetNo", (Object)merchantOrderNo);
                for (int i = 0; i < 3; ++i) {
                    paramsObject.put("optType", (Object)"E");
                    paramsObject.put("miyaBizCode", (Object)this.miyaBizCode);
                    logger.info("\u64a4\u9500\u5165\u53c2\uff1a" + JSON.toJSONString((Object)paramsObject));
                    RepealPayRequest repealPayRequest = new RepealPayRequest(paramsObject);
                    repealPayRequest.getData().setIdSheetNo(null);
                    RepealPayResponse rayResponse = AeonPayTools.repealPay(repealPayRequest, this.murl, this.mkey);
                    if (this.isRequestSuccess(rayResponse)) {
                        return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u652f\u4ed8\u5931\u8d25\uff1a\u652f\u4ed8\u65b9\u5f0f\u672a\u914d\u7f6e\uff0c\u5df2\u64a4\u9500");
                    }
                    try {
                        Thread.sleep(3000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5b8c\u6210\u4e86\u672a\u914d\u7f6e\u7684\u4ea4\u6613\uff0c\u8bf7\u8054\u7cfbIT\u90e8\u95e8");
            }
            Payment payment = new Payment();
            payment.setPuid(UUIDUtils.buildPuid());
            payment.setRownoId(payment.getPuid());
            payment.setPayCode(paymentmethod.getPosAbleCode());
            payment.setPayName(paymentmethod.getPosAbleName());
            payment.setPayNo(payResponse.getIdSheetNo());
            double money = 0.0;
            if (null != payResponse.getDiscountInfo() && payResponse.getDiscountInfo().length() > 2) {
                String discountInfoStr = payResponse.getDiscountInfo().substring(1, payResponse.getDiscountInfo().length() - 1);
                String[] moneyStrs = discountInfoStr.split("\\|");
                for (int i = 0; i < moneyStrs.length; ++i) {
                    String moneyStr = moneyStrs[i];
                    money += ManipulatePrecision.doubleConvert(Double.valueOf(moneyStr) / 100.0, 2, 1);
                }
            } else {
                money = ManipulatePrecision.doubleConvert(Double.valueOf(payResponse.getMoney()) / 100.0, 2, 1);
            }
            payment.setMoney(money);
            payment.setAmount(money);
            payment.setRate(paramsObject.getDouble("rate"));
            payment.setPrecision(paramsObject.getString("precision"));
            payment.setPrcutMode(paramsObject.getString("cutMode"));
            payment.setFlag("1");
            payment.setTerminalNo(request.getTerminalNo());
            payment.setTerminalSno(request.getTerminalSno());
            payment.setRefCode(payReq.getData().getIdSheetNo());
            String discountInfo = payResponse.getDiscountInfo();
            JSONObject discObj = payResponse.resolveDiscounts(discountInfo);
            payment.setDiscountValue(discObj.getDoubleValue("discounts") + discObj.getDoubleValue("channelDiscounts") + discObj.getDoubleValue("otherDiscounts"));
            payment.setMerchantDiscountValue(discObj.getDoubleValue("discounts"));
            payment.setPayChannelDiscountValue(discObj.getDoubleValue("channelDiscounts") + discObj.getDoubleValue("otherDiscounts"));
            payment.setRowno(cacheModel.getPayments().size() + 1);
            cacheModel = this.posLogicServiceImpl.calcPayAmout(cacheModel, payment);
            this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
            BaseOutModel out = new BaseOutModel();
            out.setOrder(OrderForPos.toOrderForPos(cacheModel));
            return ServiceResponse.buildSuccess((Object)out);
        }
        return this.buildErrResponse(session, payResponse, "\u652f\u4ed8");
    }

    public ServiceResponse saleRefund(ServiceSession session, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        if (!paramsObject.containsKey((Object)"terminalSno") || paramsObject.getString("terminalSno").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u9000\u6b3e\u5fc5\u9808\u5305\u542b\u53c3\u6578[{0}]", (Object[])new Object[]{"\u5c0f\u7968\u865f"});
        }
        if (!paramsObject.containsKey((Object)"originIdSheetNo") || paramsObject.getString("originIdSheetNo").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u9000\u6b3e\u5fc5\u9808\u5305\u542b\u53c3\u6578[{0}]", (Object[])new Object[]{"\u539f\u55ae\u865f"});
        }
        if (!paramsObject.containsKey((Object)"amount") || paramsObject.getString("amount").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u9000\u6b3e\u5fc5\u9808\u5305\u542b\u53c3\u6578[{0}]", (Object[])new Object[]{"\u9000\u6b3e\u91d1\u989d"});
        }
        if (!paramsObject.containsKey((Object)"rate") || paramsObject.getDouble("rate").isNaN()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u9000\u6b3e\u5fc5\u9808\u5305\u542b\u53c3\u6578[{0}]", (Object[])new Object[]{"\u532f\u7387"});
        }
        if (!paramsObject.containsKey((Object)"precision") || paramsObject.getString("precision").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u9000\u6b3e\u5fc5\u9808\u5305\u542b\u53c3\u6578[{0}]", (Object[])new Object[]{"\u56db\u6368\u4e94\u5165\u7cbe\u5ea6"});
        }
        if (!paramsObject.containsKey((Object)"cutMode") || paramsObject.getString("cutMode").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u9000\u6b3e\u5fc5\u9808\u5305\u542b\u53c3\u6578[{0}]", (Object[])new Object[]{"\u56db\u6368\u4e94\u5165\u65b9\u5f0f"});
        }
        if (!paramsObject.containsKey((Object)"erpCode") || paramsObject.getString("erpCode").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u9000\u6b3e\u5fc5\u9808\u5305\u542b\u53c3\u6578[{0}]", (Object[])new Object[]{"erpCode"});
        }
        CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(paramsObject.getString("flowNo"));
        if (null == cacheModel) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8a02\u55ae\u5df2\u5931\u6548\uff0c\u8acb\u91cd\u65b0\u7372\u53d6\u8a02\u55ae\u6d41\u6c34\u865f\uff01");
        }
        if (null == cacheModel.getPaymentmethodposref() || cacheModel.getPaymentmethodposref().size() <= 0) {
            ServiceResponse res = this.queryPaymentmethod(session, paramsObject.getString("erpCode"));
            if (!"0".equals(res.getReturncode())) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8bf7\u6c42\u4e3b\u6570\u636e\u4e2d\u5fc3\u67e5\u8be2\u652f\u4ed8\u65b9\u5f0f\u5931\u8d25[{0}]", (Object[])new Object[]{res.getData().toString()});
            }
            QueryPaymentmethodOut out = (QueryPaymentmethodOut)res.getData();
            cacheModel.setPaymentmethodposref(out.getPaymentmethodposref());
            this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
        }
        Order order = cacheModel.getOrder();
        this.miyaBizCode = order.getSysPara().getMsid();
        this.mkey = order.getSysPara().getMkey();
        this.murl = order.getSysPara().getMadr();
        if (StringUtils.isBlank((String)this.murl)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4ece\u603b\u90e8\u83b7\u53d6\u7c73\u96c5\u8bf7\u6c42\u5730\u5740\u5931\u8d25");
        }
        if (StringUtils.isBlank((String)this.miyaBizCode)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4ece\u603b\u90e8\u83b7\u53d6\u7c73\u96c5\u5546\u6237\u53f7\u5931\u8d25");
        }
        if (StringUtils.isBlank((String)this.mkey)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4ece\u603b\u90e8\u83b7\u53d6\u7c73\u96c5\u7b7e\u540d\u79d8\u94a5\u5931\u8d25");
        }
        paramsObject.put("optType", (Object)"C");
        paramsObject.put("miyaBizCode", (Object)this.miyaBizCode);
        PayRefundRequest refundRequest = new PayRefundRequest(paramsObject);
        String merchantOrderNo = MiyaPayServiceImpl.getMerchantOrderNo(paramsObject);
        cacheModel = this.posLogicServiceImpl.calcBalance(cacheModel);
        PayRefundRequest.PayRefundRequestData data = (PayRefundRequest.PayRefundRequestData)refundRequest.getData();
        double moneyReal = paramsObject.getDouble("amount");
        moneyReal = ManipulatePrecision.getDetailOverFlow(moneyReal, paramsObject.getString("cutMode"));
        data.setMoney((int)ManipulatePrecision.doubleConvert(moneyReal * 100.0));
        if (ManipulatePrecision.doubleCompare(moneyReal, order.getRemainValue(), 1) == 1) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8acb\u6c42\u91d1\u984d\u5fc5\u9808\u5c0f\u65bc\u8a02\u55ae\u5269\u9918\u4ed8\u6b3e", (Object[])new Object[]{""});
        }
        String originIdSheetNo = paramsObject.getString("originIdSheetNo");
        data.setOriginIdSheetNo(originIdSheetNo);
        data.setRefundIdSheetNo(merchantOrderNo);
        data.setIdSheetNo(null);
        PayRefundResponse refundPayResponse = AeonPayTools.saleRefundPay(refundRequest, this.murl, this.mkey);
        cacheModel.getOrder().setMerchantOrderNo(merchantOrderNo);
        this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
        if (this.isRequestSuccess(refundPayResponse)) {
            String channelFlag = refundPayResponse.getChannelFlag();
            PaymentMethod paymentmethod = this.getPaymentmethod(channelFlag, cacheModel.getPaymentmethodposref());
            if (null == paymentmethod) {
                paramsObject.put("originIdSheetNo", (Object)merchantOrderNo);
                for (int i = 0; i < 3; ++i) {
                    paramsObject.put("optType", (Object)"E");
                    paramsObject.put("miyaBizCode", (Object)this.miyaBizCode);
                    logger.info("\u64a4\u9500\u5165\u53c2\uff1a" + JSON.toJSONString((Object)paramsObject));
                    RepealPayRequest repealPayRequest = new RepealPayRequest(paramsObject);
                    repealPayRequest.getData().setIdSheetNo(null);
                    RepealPayResponse rayResponse = AeonPayTools.repealPay(repealPayRequest, this.murl, this.mkey);
                    if (this.isRequestSuccess(rayResponse)) {
                        return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u652f\u4ed8\u5931\u8d25\uff1a\u652f\u4ed8\u65b9\u5f0f\u672a\u914d\u7f6e\uff0c\u5df2\u64a4\u9500");
                    }
                    try {
                        Thread.sleep(3000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5b8c\u6210\u4e86\u672a\u914d\u7f6e\u7684\u4ea4\u6613\uff0c\u8bf7\u8054\u7cfbIT\u90e8\u95e8");
            }
            BasePayRequest.Request request = refundRequest.getRequest();
            Payment payment = new Payment();
            payment.setPuid(UUIDUtils.buildPuid());
            payment.setRownoId(payment.getPuid());
            payment.setPayCode(paymentmethod.getPosAbleCode());
            payment.setPayName(paymentmethod.getPosAbleName());
            payment.setMoney(moneyReal);
            payment.setAmount(moneyReal);
            payment.setRate(paramsObject.getDouble("rate"));
            payment.setPrecision(paramsObject.getString("precision"));
            payment.setFlag("1");
            payment.setTerminalNo(request.getTerminalNo());
            payment.setTerminalSno(request.getTerminalSno());
            payment.setRowno(cacheModel.getPayments().size() + 1);
            payment.setPrcutMode(paramsObject.getString("cutMode"));
            payment.setPayNo(refundPayResponse.getRefundSheetNo());
            payment.setRefCode(data.getOriginIdSheetNo());
            String discountInfo = refundPayResponse.getDiscountInfo();
            JSONObject discObj = refundPayResponse.resolveDiscounts(discountInfo);
            payment.setDiscountValue(discObj.getDoubleValue("discounts") + discObj.getDoubleValue("channelDiscounts") + discObj.getDoubleValue("otherDiscounts"));
            payment.setMerchantDiscountValue(discObj.getDoubleValue("discounts"));
            payment.setPayChannelDiscountValue(discObj.getDoubleValue("channelDiscounts") + discObj.getDoubleValue("otherDiscounts"));
            cacheModel = this.posLogicServiceImpl.calcPayAmout(cacheModel, payment);
            this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
            BaseOutModel out = new BaseOutModel();
            out.setOrder(OrderForPos.toOrderForPos(cacheModel));
            return ServiceResponse.buildSuccess((Object)out);
        }
        if (null == refundPayResponse) {
            refundPayResponse = new PayRefundResponse();
        }
        refundPayResponse.setRemainValue(order.getRemainValue() - order.getExistPay());
        refundPayResponse.setOughtPay(order.getOughtPay());
        refundPayResponse.setOverageValue(order.getOverageValue());
        refundPayResponse.setExistPay(order.getExistPay());
        return this.buildErrResponse(session, refundPayResponse, "\u9000\u6b3e");
    }

    public ServiceResponse saleRefundQuery(ServiceSession session, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        if (!paramsObject.containsKey((Object)"originIdSheetNo") || paramsObject.getString("originIdSheetNo").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u9000\u6b3e\u67e5\u8a62\u5fc5\u9808\u5305\u542b\u53c3\u6578[{0}]", (Object[])new Object[]{"\u539f\u55ae\u865f"});
        }
        String flowNo = paramsObject.getString("flowNo");
        CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(flowNo);
        if (cacheModel == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8a02\u55ae[{0}]\u5df2\u5931\u6548\uff0c\u8acb\u91cd\u65b0\u751f\u6210\u8a02\u55ae", (Object[])new Object[]{flowNo});
        }
        String merchantOrderNo = cacheModel.getOrder().getMerchantOrderNo();
        Order order = cacheModel.getOrder();
        this.miyaBizCode = order.getSysPara().getMsid();
        this.mkey = order.getSysPara().getMkey();
        this.murl = order.getSysPara().getMadr();
        if (StringUtils.isBlank((String)this.murl)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4ece\u603b\u90e8\u83b7\u53d6\u7c73\u96c5\u8bf7\u6c42\u5730\u5740\u5931\u8d25");
        }
        if (StringUtils.isBlank((String)this.miyaBizCode)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4ece\u603b\u90e8\u83b7\u53d6\u7c73\u96c5\u5546\u6237\u53f7\u5931\u8d25");
        }
        if (StringUtils.isBlank((String)this.mkey)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4ece\u603b\u90e8\u83b7\u53d6\u7c73\u96c5\u7b7e\u540d\u79d8\u94a5\u5931\u8d25");
        }
        paramsObject.put("optType", (Object)"D");
        paramsObject.put("miyaBizCode", (Object)this.miyaBizCode);
        PayRefundQueryRequest refundQueryRequest = new PayRefundQueryRequest(paramsObject);
        PayRefundQueryRequest.PayRefundQueryRequestData data = (PayRefundQueryRequest.PayRefundQueryRequestData)refundQueryRequest.getData();
        data.setRefundIdSheetNo(merchantOrderNo);
        data.setIdSheetNo(null);
        PayRefundQueryResponse refundPayQueryResponse = AeonPayTools.saleRefundPayQuery(refundQueryRequest, this.murl, this.mkey);
        if (this.isRequestSuccess(refundPayQueryResponse)) {
            return ServiceResponse.buildSuccess((Object)refundPayQueryResponse.buildFinalResp());
        }
        return this.buildErrResponse(session, refundPayQueryResponse, "\u9000\u6b3e\u67e5\u8a62");
    }

    public ServiceResponse saleRepealPay(ServiceSession session, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        if (!paramsObject.containsKey((Object)"originIdSheetNo") || paramsObject.getString("originIdSheetNo").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u64a4\u92b7\u4ed8\u6b3e\u5fc5\u9808\u5305\u542b\u53c3\u6578[{0}]", (Object[])new Object[]{"\u539f\u55ae\u865f"});
        }
        if (!paramsObject.containsKey((Object)"puid") || paramsObject.getString("puid").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u64a4\u92b7\u4ed8\u6b3e\u5fc5\u9808\u5305\u542b\u53c3\u6578[{0}]", (Object[])new Object[]{"\u4ed8\u6b3e\u552f\u4e00\u6807\u8bc6\u53f7"});
        }
        CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(paramsObject.getString("flowNo"));
        if (null == cacheModel) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8a02\u55ae\u5df2\u5931\u6548\uff0c\u8acb\u91cd\u65b0\u7372\u53d6\u8a02\u55ae\u6d41\u6c34\u865f\uff01");
        }
        if (cacheModel.getOrder().getSendSuccess()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u63d0\u4ea4\u6210\u529f\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u4ed8\u6b3e\u4fe1\u606f", (Object[])new Object[]{paramsObject.getString("flowNo")});
        }
        String puid = paramsObject.getString("puid");
        Payment PreDeletePayment = null;
        for (Payment p : cacheModel.getPayments()) {
            if (!p.getPuid().equals(puid)) continue;
            PreDeletePayment = p;
            break;
        }
        if (PreDeletePayment == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u64a4\u9500\u4ed8\u6b3e\u5931\u8d25\u539f\u56e0[{0}]", (Object[])new Object[]{"\u4ed8\u6b3e\u884c\u4e3a\u7a7a"});
        }
        Order order = cacheModel.getOrder();
        this.miyaBizCode = order.getSysPara().getMsid();
        this.mkey = order.getSysPara().getMkey();
        this.murl = order.getSysPara().getMadr();
        if (StringUtils.isBlank((String)this.murl)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4ece\u603b\u90e8\u83b7\u53d6\u7c73\u96c5\u8bf7\u6c42\u5730\u5740\u5931\u8d25");
        }
        if (StringUtils.isBlank((String)this.miyaBizCode)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4ece\u603b\u90e8\u83b7\u53d6\u7c73\u96c5\u5546\u6237\u53f7\u5931\u8d25");
        }
        if (StringUtils.isBlank((String)this.mkey)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4ece\u603b\u90e8\u83b7\u53d6\u7c73\u96c5\u7b7e\u540d\u79d8\u94a5\u5931\u8d25");
        }
        paramsObject.put("optType", (Object)"E");
        paramsObject.put("miyaBizCode", (Object)this.miyaBizCode);
        RepealPayRequest repealPayRequest = new RepealPayRequest(paramsObject);
        repealPayRequest.getData().setIdSheetNo(null);
        RepealPayResponse rayResponse = AeonPayTools.repealPay(repealPayRequest, this.murl, this.mkey);
        if (this.isRequestSuccess(rayResponse)) {
            if (PreDeletePayment != null) {
                cacheModel.getPayments().remove(PreDeletePayment);
                cacheModel = this.posLogicServiceImpl.CalcOrderAmountByDeletePayReturn(cacheModel);
                if (cacheModel.getCalcResult() == -1) {
                    String errCode = "100000";
                    if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                        errCode = cacheModel.getErrCode();
                    }
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)errCode, (String)cacheModel.getErrMsg());
                }
                cacheModel = this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
            }
            BaseOutModel out = new BaseOutModel();
            out.setOrder(OrderForPos.toOrderForPos(cacheModel));
            return ServiceResponse.buildSuccess((Object)out);
        }
        return this.buildErrResponse(session, rayResponse, "\u64a4\u92b7\u4ed8\u6b3e");
    }

    private boolean isRequestSuccess(BasePayResponse resp) {
        boolean isReqSuccess;
        boolean bl = isReqSuccess = null != resp && SUCCESS.equals(resp.getOrderStatus());
        if (isReqSuccess) {
            String statusCode = resp.getStatusCode();
            if ("PAYSUCCESS".equals(statusCode) || "PAYWAIT".equals(statusCode)) {
                return true;
            }
            if ("REFUNDSUCCESS".equals(statusCode)) {
                return true;
            }
            if ("CANCELSUCCESS".equals(statusCode)) {
                return true;
            }
        }
        return false;
    }

    private ServiceResponse buildErrResponse(ServiceSession session, BasePayResponse resp, String apiName) {
        String errMsg = "";
        if (null != resp) {
            if (resp.getStatusCode() == null) {
                errMsg = "\u8bbf\u95ee\u652f\u4ed8\u7cfb\u7edf\u7f51\u7edc\u5f02\u5e38\uff01";
            } else {
                StringBuffer sb = new StringBuffer();
                sb.append("[").append(apiName).append("]\u5904\u7406\u5f02\u5e38-->\u72b6\u6001\u7801=[").append(resp.getStatusCode()).append("],\u7ba1\u9053\u5e73\u53f0\u9519\u8bef\u7801=[").append(resp.getChannelErrCode()).append("],\u7ba1\u9053\u5e73\u53f0\u9519\u8bef\u4fe1\u606f=[").append(resp.getChannelErrMsg()).append("]");
                errMsg = sb.toString();
            }
        } else {
            errMsg = "\u6267\u884c[" + apiName + "]\u65f6\u7f51\u7edc\u5f02\u5e38\uff01";
        }
        return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)errMsg);
    }

    private ServiceResponse buildPayWaitResponse(ServiceSession session, BasePayResponse payresponse) {
        ServiceResponse resp = new ServiceResponse();
        JSONObject json = new JSONObject();
        json.put("channelMsg", (Object)payresponse);
        resp.setData((Object)json);
        resp.setReturncode("4000");
        return resp;
    }

    private String getPayChannel(String channelFlag) {
        if (channelFlag != null) {
            switch (channelFlag) {
                case "H": 
                case "1": {
                    return "WeChat";
                }
                case "J": {
                    return "WeChat 2";
                }
                case "3": 
                case "F": {
                    return "Alipay";
                }
                case "4": {
                    return "\u767e\u5ea6";
                }
                case "5": {
                    return "\u7ffc\u652f\u4ed8";
                }
                case "6": {
                    return "QQ \u9322\u5305";
                }
                case "8": {
                    return "\u8607\u752f\u6613\u4ed8\u5bf6";
                }
                case "A": {
                    return "\u5927\u773e\u9ede\u8a55";
                }
                case "C": {
                    return "\u4eac\u6771";
                }
                case "I": {
                    return "\u767e\u7cef\u7c73";
                }
                case "K": {
                    return "\u5de5\u884c";
                }
                case "L": {
                    return "\u98db\u51e1";
                }
                case "M": {
                    return "\u83ef\u6f64\u9280\u884c";
                }
            }
        }
        return "\u672a\u77e5\u652f\u4ed8\u65b9\u5f0f";
    }

    private static String getTime() {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        String time = df.format(new Date()).toString();
        return time;
    }

    private static String getMerchantOrderNo(JSONObject json) {
        String shopCode = json.getString("shopCode");
        String terminalNo = json.getString("terminalNo");
        String terminalSno = json.getString("terminalSno");
        String timestamp = MiyaPayServiceImpl.getTime();
        String merchantOrderNo = shopCode + terminalNo + terminalSno + timestamp;
        return merchantOrderNo;
    }

    public ServiceResponse queryPaymentmethod(ServiceSession session, String erpCode) {
        QueryPaymentmethodIn in = new QueryPaymentmethodIn();
        in.setErpCode(erpCode);
        in.setPage_no(1);
        in.setPage_size(9999);
        return this.mainDataCentreService.queryPaymentmethod(this.restTemplate, session, in);
    }

    private PaymentMethod getPaymentmethod(String channelFlag, List<PaymentMethod> list) {
        for (PaymentMethod paymentMethod : list) {
            if (!StringUtils.isNotBlank((String)paymentMethod.getPmcode()) || !paymentMethod.getPmcode().equals(channelFlag)) continue;
            return paymentMethod;
        }
        return null;
    }

    public static void main(String[] args) {
        JSONObject paramsObject = new JSONObject();
        paramsObject.put("miyaBizCode", (Object)"miya");
        paramsObject.put("shopCode", (Object)"0008");
        paramsObject.put("terminalNo", (Object)"580");
        paramsObject.put("terminalOperator", (Object)"19370");
        paramsObject.put("idSheetNo", (Object)"5252525");
        paramsObject.put("originIdSheetNo", (Object)"000872221345320200415180939");
        paramsObject.put("optType", (Object)"C");
        PayRefundRequest refundRequest = new PayRefundRequest(paramsObject);
        String merchantOrderNo = MiyaPayServiceImpl.getMerchantOrderNo(paramsObject);
        PayRefundRequest.PayRefundRequestData data = (PayRefundRequest.PayRefundRequestData)refundRequest.getData();
        data.setMoney(60);
        String originIdSheetNo = paramsObject.getString("originIdSheetNo");
        data.setOriginIdSheetNo(originIdSheetNo);
        data.setRefundIdSheetNo(merchantOrderNo);
        data.setIdSheetNo(null);
    }
}

