/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pos.component;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.pos.component.CommonService;
import com.efuture.pos.component.OrderServiceImpl;
import com.efuture.pos.component.PosLogicServiceImpl;
import com.efuture.pos.component.dao.impl.MzkServerDaoImpl;
import com.efuture.pos.component.dao.impl.Test;
import com.efuture.pos.component.service.PosSVService;
import com.efuture.pos.model.BaseOutModel;
import com.efuture.pos.model.CacheModel;
import com.efuture.pos.model.OrderForPos;
import com.efuture.pos.model.Payment;
import com.efuture.pos.model.posManager.request.SendBankLogIn;
import com.efuture.pos.model.request.MzkIn;
import com.efuture.pos.model.request.MzkRequestDef;
import com.efuture.pos.model.response.MzkResultDef;
import com.efuture.pos.service.MzkService;
import com.efuture.pos.service.common.CacheModelService;
import com.efuture.pos.util.CastUtil;
import com.efuture.pos.util.ManipulatePrecision;
import com.efuture.pos.util.ParamsValidateUtils;
import com.efuture.pos.util.UUIDUtils;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.client.RestTemplate;

public class MzkServiceImpl
extends CommonService
implements MzkService {
    private static final Logger logger = LoggerFactory.getLogger(MzkServiceImpl.class);
    @Autowired
    CacheModelService cacheModelService;
    @Autowired
    PosLogicServiceImpl posLogicServiceImpl;
    @Autowired
    MzkServerDaoImpl mzkServerDaoImpl;
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    PosSVService posSVService;
    @Autowired
    OrderServiceImpl orderService;
    @Value(value="${server.route.mode}")
    private String routeMode;

    public ServiceResponse salePay(ServiceSession session, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        MzkIn in = (MzkIn)JSON.parseObject((String)paramsObject.toJSONString(), MzkIn.class);
        logger.info("\u50a8\u503c\u5361\u5165\u53c2\uff1a" + paramsObject.toJSONString());
        if (!paramsObject.containsKey((Object)"cardNo") || paramsObject.getString("cardNo").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u50a8\u503c\u5361\u5361\u53f7"});
        }
        if (!paramsObject.containsKey((Object)"amount") || paramsObject.getString("amount").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u4ea4\u6613\u91d1\u989d"});
        }
        CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(in.getFlowNo());
        if (cacheModel == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355", (Object[])new Object[]{in.getFlowNo()});
        }
        if (cacheModel.getOrder().getSendSuccess()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u63d0\u4ea4\u6210\u529f\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u4ed8\u6b3e\u4fe1\u606f", (Object[])new Object[]{in.getFlowNo()});
        }
        session.setEnt_id(cacheModel.getOrder().getEntId());
        cacheModel = this.posLogicServiceImpl.calcBalance(cacheModel);
        double remainValue = cacheModel.getOrder().getRemainValue();
        if (remainValue <= 0.0) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5df2\u4ed8\u6e05\u6b3e\u9879\uff0c\u65e0\u9700\u518d\u652f\u4ed8\uff01");
        }
        if (remainValue - in.getAmount() < 0.0) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u652f\u4ed8\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5269\u4f59\u4ed8\u6b3e\uff01");
        }
        MzkRequestDef mzkreq = new MzkRequestDef(in);
        mzkreq.setVtype("01");
        mzkreq.setVmemo(cacheModel.getOrder().getSysPara().getMzkUrl());
        SendBankLogIn sendBankLogIn = this.toSendBankLogIn(in);
        sendBankLogIn.setErpCode(cacheModel.getOrder().getErpCode());
        ServiceResponse res = this.posSVService.executeCzk(this.restTemplate, session, mzkreq);
        if (!"0".equals(res.getReturncode())) {
            mzkreq.setVtype("02");
            sendBankLogIn.setType("1");
            res = this.posSVService.executeCzk(this.restTemplate, session, mzkreq);
            if ("0".equals(res.getReturncode())) {
                MzkResultDef mzkres = (MzkResultDef)res.getData();
                if ("00".equals(mzkres.getRetcode())) {
                    sendBankLogIn.setRetbz("Y");
                    sendBankLogIn.setRetmsg("\u6d88\u8d39\u5931\u8d25\uff0c\u51b2\u6b63\u6210\u529f");
                    sendBankLogIn.setVbal(CastUtil.castDouble(mzkres.getRamount()) * 0.01);
                    try {
                        this.posManagerService.sendBankLog(this.restTemplate, session, sendBankLogIn);
                    }
                    catch (Exception e) {
                        logger.info("\u4e0a\u4f20\u65e5\u5fd7\u53d1\u751f\u5f02\u5e38");
                    }
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u652f\u4ed8\u6210\u529f\u672a\u6536\u5230\u8fd4\u56de,\u5df2\u64a4\u9500");
                }
                sendBankLogIn.setRetbz("N");
                sendBankLogIn.setRetmsg("\u6d88\u8d39\u5931\u8d25\uff0c\u51b2\u6b63\u5931\u8d25\uff1a" + mzkres.getRerrmsg());
                try {
                    this.posManagerService.sendBankLog(this.restTemplate, session, sendBankLogIn);
                }
                catch (Exception e) {
                    logger.info("\u4e0a\u4f20\u65e5\u5fd7\u53d1\u751f\u5f02\u5e38");
                }
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"2005", (String)("\u652f\u4ed8\u672a\u6536\u5230\u8fd4\u56de,\u5df2\u64a4\u9500,\u64a4\u9500\u5931\u8d25\uff1a" + mzkres.getRerrmsg()));
            }
            sendBankLogIn.setRetbz("N");
            sendBankLogIn.setRetmsg("\u6d88\u8d39\u5931\u8d25\uff0c\u51b2\u6b63\u5931\u8d25\uff1a\u7f51\u7edc\u5f02\u5e38");
            try {
                this.posManagerService.sendBankLog(this.restTemplate, session, sendBankLogIn);
            }
            catch (Exception e) {
                logger.info("\u4e0a\u4f20\u65e5\u5fd7\u53d1\u751f\u5f02\u5e38");
            }
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"2005", (String)"\u652f\u4ed8\u672a\u6536\u5230\u8fd4\u56de,\u5df2\u64a4\u9500,\u64a4\u9500\u5931\u8d25\uff1a\u672a\u6536\u5230\u8fd4\u56de");
        }
        MzkResultDef mzkres = (MzkResultDef)res.getData();
        sendBankLogIn.setType("0");
        if ("00".equals(mzkres.getRetcode())) {
            Payment payment = new Payment();
            payment.setPuid(UUIDUtils.buildPuid());
            payment.setRownoId(payment.getPuid());
            payment.setRefCode(in.getOrderNo());
            payment.setPayCode(in.getPayCode());
            payment.setPayName(in.getPayName());
            payment.setPayType(in.getPayType());
            payment.setPayNo(mzkres.getRcardno());
            payment.setPasswd(in.getPasswd());
            payment.setCouponBalance(ManipulatePrecision.mul(CastUtil.castDouble(mzkres.getRamount()), 0.01));
            payment.setTrackData(mzkreq.getVtrack2());
            payment.setAmount(in.getAmount());
            payment.setTerminalNo(in.getTerminalNo());
            payment.setTerminalSno(mzkreq.getVinvno());
            payment.setCustmnerName(mzkres.getRname());
            payment.setPrecision(in.getPrecision());
            payment.setPrcutMode(in.getCutMode());
            payment.setRate(in.getRate());
            payment.setFlag("1");
            payment.setRowno(cacheModel.getPayments().size() + 1);
            cacheModel = this.posLogicServiceImpl.calcPayAmout(cacheModel, payment);
            this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
            sendBankLogIn.setRetbz("Y");
            sendBankLogIn.setRetmsg("\u6210\u529f");
            sendBankLogIn.setVbal(CastUtil.castDouble(mzkres.getRamount()) * 0.01);
            try {
                this.posManagerService.sendBankLog(this.restTemplate, session, sendBankLogIn);
            }
            catch (Exception e) {
                logger.info("\u4e0a\u4f20\u65e5\u5fd7\u53d1\u751f\u5f02\u5e38");
            }
            BaseOutModel out = new BaseOutModel();
            out.setOrder(OrderForPos.toOrderForPos(cacheModel));
            return ServiceResponse.buildSuccess((Object)out);
        }
        sendBankLogIn.setRetbz("N");
        sendBankLogIn.setRetmsg(mzkres.getRerrmsg());
        try {
            this.posManagerService.sendBankLog(this.restTemplate, session, sendBankLogIn);
        }
        catch (Exception e) {
            logger.info("\u4e0a\u4f20\u65e5\u5fd7\u53d1\u751f\u5f02\u5e38");
        }
        return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)("\u652f\u4ed8\u5931\u8d25\uff1a" + mzkres.getRerrmsg()));
    }

    public ServiceResponse cancelPay(ServiceSession session, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        MzkIn in = (MzkIn)JSON.parseObject((String)paramsObject.toJSONString(), MzkIn.class);
        if (!paramsObject.containsKey((Object)"cardNo") || paramsObject.getString("cardNo").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u64a4\u9500\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u50a8\u503c\u5361\u5361\u53f7"});
        }
        if (!paramsObject.containsKey((Object)"amount") || paramsObject.getString("amount").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u64a4\u9500\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u4ea4\u6613\u91d1\u989d"});
        }
        CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(in.getFlowNo());
        if (cacheModel.getOrder().getSendSuccess()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u63d0\u4ea4\u6210\u529f\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u4ed8\u6b3e\u4fe1\u606f", (Object[])new Object[]{in.getFlowNo()});
        }
        String puid = in.getPuid();
        Payment PreDeletePayment = null;
        for (Payment p : cacheModel.getPayments()) {
            if (!p.getPuid().equals(puid)) continue;
            PreDeletePayment = p;
            break;
        }
        MzkRequestDef mzkreq = new MzkRequestDef(in);
        if (PreDeletePayment == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u64a4\u9500\u4ed8\u6b3e\u5931\u8d25\u539f\u56e0[{0}]", (Object[])new Object[]{"\u4ed8\u6b3e\u884c\u4e3a\u7a7a"});
        }
        mzkreq.setVpasswd(PreDeletePayment.getPasswd());
        mzkreq.setVtype("02");
        mzkreq.setVmemo(cacheModel.getOrder().getSysPara().getMzkUrl());
        ServiceResponse res = this.posSVService.executeCzk(this.restTemplate, session, mzkreq);
        if ("0".equals(res.getReturncode())) {
            MzkResultDef mzkres = (MzkResultDef)res.getData();
            SendBankLogIn sendBankLogIn = this.toSendBankLogIn(in);
            sendBankLogIn.setErpCode(cacheModel.getOrder().getErpCode());
            sendBankLogIn.setType("1");
            if ("00".equals(mzkres.getRetcode())) {
                if (PreDeletePayment != null) {
                    cacheModel.getPayments().remove(PreDeletePayment);
                    cacheModel = this.posLogicServiceImpl.CalcOrderAmountByDeletePayReturn(cacheModel);
                    if (cacheModel.getCalcResult() == -1) {
                        String errCode = "100000";
                        if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                            errCode = cacheModel.getErrCode();
                        }
                        return ServiceResponse.buildFailure((ServiceSession)session, (String)errCode, (String)cacheModel.getErrMsg());
                    }
                    this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
                }
                sendBankLogIn.setRetbz("Y");
                sendBankLogIn.setRetmsg("\u6210\u529f");
                sendBankLogIn.setVbal(CastUtil.castDouble(mzkres.getRamount()) * 0.01);
                try {
                    this.posManagerService.sendBankLog(this.restTemplate, session, sendBankLogIn);
                }
                catch (Exception e) {
                    logger.info("\u4e0a\u4f20\u65e5\u5fd7\u53d1\u751f\u5f02\u5e38");
                }
                BaseOutModel out = new BaseOutModel();
                out.setOrder(OrderForPos.toOrderForPos(cacheModel));
                return ServiceResponse.buildSuccess((Object)out);
            }
            sendBankLogIn.setRetbz("N");
            sendBankLogIn.setRetmsg(mzkres.getRerrmsg());
            try {
                this.posManagerService.sendBankLog(this.restTemplate, session, sendBankLogIn);
            }
            catch (Exception e) {
                logger.info("\u4e0a\u4f20\u65e5\u5fd7\u53d1\u751f\u5f02\u5e38");
            }
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)("\u64a4\u9500\u5931\u8d25\uff1a" + mzkres.getRerrmsg()));
        }
        return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u64a4\u9500\u5931\u8d25\uff1a\u8bf7\u6c42\u5931\u8d25");
    }

    public ServiceResponse saleRefund(ServiceSession session, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        MzkIn in = (MzkIn)JSON.parseObject((String)paramsObject.toJSONString(), MzkIn.class);
        if (!paramsObject.containsKey((Object)"cardNo") || paramsObject.getString("cardNo").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u6d88\u5355\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u50a8\u503c\u5361\u5361\u53f7"});
        }
        if (!paramsObject.containsKey((Object)"amount") || paramsObject.getString("amount").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u6d88\u5355\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u4ea4\u6613\u91d1\u989d"});
        }
        CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(in.getFlowNo());
        MzkRequestDef mzkreq = new MzkRequestDef(in);
        mzkreq.setVtype("02");
        mzkreq.setVmemo(cacheModel.getOrder().getSysPara().getMzkUrl());
        ServiceResponse res = this.posSVService.executeCzk(this.restTemplate, session, mzkreq);
        if ("0".equals(res.getReturncode())) {
            MzkResultDef mzkres = (MzkResultDef)res.getData();
            SendBankLogIn sendBankLogIn = this.toSendBankLogIn(in);
            sendBankLogIn.setErpCode(cacheModel.getOrder().getErpCode());
            sendBankLogIn.setType("1");
            if ("00".equals(mzkres.getRetcode())) {
                Payment payment = new Payment();
                payment.setPuid(UUIDUtils.buildPuid());
                payment.setRownoId(payment.getPuid());
                payment.setPayCode(in.getPayCode());
                payment.setPayName(in.getPayName());
                payment.setPayType(in.getPayType());
                payment.setPayNo(mzkres.getRcardno());
                payment.setCouponBalance(ManipulatePrecision.mul(CastUtil.castDouble(mzkres.getRamount()), 0.01));
                payment.setTrackData(mzkreq.getVtrack2());
                payment.setAmount(in.getAmount());
                payment.setMisTerminalId(mzkreq.getVtermno());
                payment.setTerminalSno(mzkreq.getVinvno());
                payment.setTerminalNo(in.getTerminalNo());
                payment.setPrcutMode(in.getCutMode());
                payment.setPrecision(in.getPrecision());
                payment.setRate(in.getRate());
                payment.setCustmnerName(mzkres.getRname());
                payment.setFlag("1");
                payment.setRowno(cacheModel.getPayments().size());
                cacheModel = this.posLogicServiceImpl.calcPayAmout(cacheModel, payment);
                this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
                sendBankLogIn.setRetbz("Y");
                sendBankLogIn.setRetmsg("\u6210\u529f");
                sendBankLogIn.setVbal(CastUtil.castDouble(mzkres.getRamount()) * 0.01);
                try {
                    this.posManagerService.sendBankLog(this.restTemplate, session, sendBankLogIn);
                }
                catch (Exception e) {
                    logger.info("\u4e0a\u4f20\u65e5\u5fd7\u53d1\u751f\u5f02\u5e38");
                }
                BaseOutModel out = new BaseOutModel();
                out.setOrder(OrderForPos.toOrderForPos(cacheModel));
                return ServiceResponse.buildSuccess((Object)out);
            }
            sendBankLogIn.setRetbz("N");
            sendBankLogIn.setRetmsg(mzkres.getRerrmsg());
            try {
                this.posManagerService.sendBankLog(this.restTemplate, session, sendBankLogIn);
            }
            catch (Exception e) {
                logger.info("\u4e0a\u4f20\u65e5\u5fd7\u53d1\u751f\u5f02\u5e38");
            }
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)("\u6d88\u5355\u5931\u8d25\uff1a" + mzkres.getRerrmsg()));
        }
        return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u6d88\u5355\u5931\u8d25\uff1a\u8bf7\u6c42\u5931\u8d25");
    }

    public ServiceResponse saleQuery(ServiceSession session, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        MzkIn in = (MzkIn)JSON.parseObject((String)paramsObject.toJSONString(), MzkIn.class);
        if (!paramsObject.containsKey((Object)"cardNo") || paramsObject.getString("cardNo").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u50a8\u503c\u5361\u5361\u53f7"});
        }
        CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(in.getFlowNo());
        MzkRequestDef mzkreq = new MzkRequestDef(in);
        mzkreq.setVtype("05");
        mzkreq.setVmemo(cacheModel.getOrder().getSysPara().getMzkUrl());
        ServiceResponse res = this.posSVService.executeCzk(this.restTemplate, session, mzkreq);
        if ("0".equals(res.getReturncode())) {
            MzkResultDef mzkres = (MzkResultDef)res.getData();
            if ("00".equals(mzkres.getRetcode())) {
                double money = ManipulatePrecision.mul(CastUtil.castDouble(mzkres.getRamount()), 0.01);
                JSONObject json = new JSONObject();
                json.put("money", (Object)money);
                return ServiceResponse.buildSuccess((Object)json);
            }
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)("\u67e5\u8be2\u4f59\u989d\u5931\u8d25\uff1a" + mzkres.getRerrmsg()));
        }
        return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u67e5\u8be2\u5931\u8d25\uff1a\u8bf7\u6c42\u5931\u8d25");
    }

    public ServiceResponse saleReserve(ServiceSession session, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        MzkIn in = (MzkIn)JSON.parseObject((String)paramsObject.toJSONString(), MzkIn.class);
        if (!paramsObject.containsKey((Object)"cardNo") || paramsObject.getString("cardNo").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u51b2\u6b63\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u50a8\u503c\u5361\u5361\u53f7"});
        }
        if (!paramsObject.containsKey((Object)"amount") || paramsObject.getString("amount").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u51b2\u6b63\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u4ea4\u6613\u91d1\u989d"});
        }
        MzkRequestDef mzkreq = new MzkRequestDef(in);
        mzkreq.setVtype("02");
        MzkResultDef mzkres = new MzkResultDef();
        String cardNo = in.getCardNo();
        if (cardNo.contains("=")) {
            String dataSource = "";
            String first = cardNo.substring(0, 1);
            if ("7".equals(first) || cardNo.split("=")[0].length() < 13) {
                dataSource = "xykDataSource";
            } else if ("8".equals(first)) {
                dataSource = "lmsDataSource";
            } else if ("5".equals(first)) {
                dataSource = "hkyhDataSource";
            } else if ("9".equals(first)) {
                dataSource = "xmsDataSource";
            } else {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"2005", (String)"\u51b2\u6b63\u5931\u8d25\uff1a\u5361\u53f7\u9519\u8bef");
            }
            mzkres = this.mzkServerDaoImpl.sendMzk(JSON.toJSONString((Object)mzkreq), dataSource);
        } else {
            mzkres = this.mzkServerDaoImpl.sendDzk(JSON.toJSONString((Object)mzkreq));
        }
        SendBankLogIn sendBankLogIn = this.toSendBankLogIn(in);
        sendBankLogIn.setType("1");
        if ("00".equals(mzkres.getRetcode())) {
            sendBankLogIn.setRetbz("Y");
            sendBankLogIn.setRetmsg("\u6210\u529f");
            sendBankLogIn.setVbal(CastUtil.castDouble(mzkres.getRamount()) * 0.01);
            try {
                this.posManagerService.sendBankLog(this.restTemplate, session, sendBankLogIn);
            }
            catch (Exception e) {
                logger.info("\u4e0a\u4f20\u65e5\u5fd7\u53d1\u751f\u5f02\u5e38");
            }
            JSONObject json = new JSONObject();
            json.put("retcode", (Object)mzkres.getRetcode());
            return ServiceResponse.buildSuccess((Object)json);
        }
        sendBankLogIn.setRetbz("N");
        sendBankLogIn.setRetmsg(mzkres.getRerrmsg());
        try {
            this.posManagerService.sendBankLog(this.restTemplate, session, sendBankLogIn);
        }
        catch (Exception e) {
            logger.info("\u4e0a\u4f20\u65e5\u5fd7\u53d1\u751f\u5f02\u5e38");
        }
        return ServiceResponse.buildFailure((ServiceSession)session, (String)"2005", (String)("\u51b2\u6b63\u5931\u8d25\uff1a" + mzkres.getRerrmsg()));
    }

    public ServiceResponse saleQuery1(ServiceSession session, JSONObject paramsObject) {
        Connection connection;
        try {
            connection = Test.getConnection(paramsObject.getString("url"));
        }
        catch (Exception e) {
            return ServiceResponse.buildSuccess((Object)"\u8fde\u63a5oracle\u6570\u636e\u5e93\u5931\u8d25");
        }
        if (connection != null) {
            System.out.println("\u8fde\u63a5oracle\u6570\u636e\u5e93\u6210\u529f:" + connection);
            return ServiceResponse.buildSuccess((Object)"\u8fde\u63a5oracle\u6570\u636e\u5e93\u6210\u529f");
        }
        System.out.println("\u8fde\u63a5oracle\u6570\u636e\u5e93\u5931\u8d25!!!");
        return ServiceResponse.buildSuccess((Object)"\u8fde\u63a5oracle\u6570\u636e\u5e93\u5931\u8d25");
    }

    public SendBankLogIn toSendBankLogIn(MzkIn mzkin) {
        SendBankLogIn in = new SendBankLogIn();
        in.setCardno(mzkin.getCardNo());
        in.setErpCode(in.getErpCode());
        in.setMkt(mzkin.getShopCode());
        in.setFphm(mzkin.getInvno());
        in.setJe(mzkin.getAmount());
        in.setTermno(mzkin.getMzkTerminalNo());
        in.setPayCode(mzkin.getPayCode());
        Date date = new Date();
        SimpleDateFormat s = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        in.setRqsj(s.format(date));
        in.setSyjh(mzkin.getTerminalNo());
        in.setSyyh(mzkin.getTerminalOperator());
        in.setTrace(mzkin.getOrderNo());
        return in;
    }

    public ServiceResponse executeCzk(ServiceSession session, JSONObject paramsObject) {
        MzkRequestDef mzkreq = (MzkRequestDef)JSON.parseObject((String)paramsObject.toJSONString(), MzkRequestDef.class);
        String sysParaInfo = mzkreq.getVmemo();
        mzkreq.setVmemo("");
        this.mzkServerDaoImpl.changeDataSource(sysParaInfo);
        MzkResultDef mzkres = new MzkResultDef();
        String cardNo = mzkreq.getVtrack2();
        if (cardNo.contains("=")) {
            String dataSource = "";
            String first = cardNo.substring(0, 1);
            if ("7".equals(first) || cardNo.split("=")[0].length() < 13) {
                dataSource = "xykDataSource";
            } else if ("8".equals(first)) {
                dataSource = "lmsDataSource";
            } else if ("5".equals(first)) {
                dataSource = "hkyhDataSource";
            } else if ("9".equals(first)) {
                dataSource = "xmsDataSource";
            } else {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4ea4\u6613\u5931\u8d25\uff1a\u5361\u53f7\u9519\u8bef");
            }
            mzkres = this.mzkServerDaoImpl.sendMzk(JSON.toJSONString((Object)mzkreq), dataSource);
        } else {
            mzkres = this.mzkServerDaoImpl.sendDzk(JSON.toJSONString((Object)mzkreq));
        }
        return ServiceResponse.buildSuccess((Object)mzkres);
    }
}

