/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pos.component;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.pos.component.PosLogicServiceImpl;
import com.efuture.pos.component.service.MainDataCentreService;
import com.efuture.pos.model.BaseOutModel;
import com.efuture.pos.model.CacheModel;
import com.efuture.pos.model.Goods;
import com.efuture.pos.model.Order;
import com.efuture.pos.model.OrderForPos;
import com.efuture.pos.model.Payment;
import com.efuture.pos.model.mainDataCentre.PaymentMethod;
import com.efuture.pos.model.mainDataCentre.request.QueryPaymentmethodIn;
import com.efuture.pos.model.mainDataCentre.response.QueryPaymentmethodOut;
import com.efuture.pos.pay.OfflinePayTools;
import com.efuture.pos.pay.model.offlinepay.OffinePayReq;
import com.efuture.pos.pay.model.offlinepay.OffineRefundReq;
import com.efuture.pos.pay.model.offlinepay.OfflinePayQueryReq;
import com.efuture.pos.pay.model.offlinepay.OfflineRefundQueryReq;
import com.efuture.pos.pay.model.offlinepay.OfflineReverseReq;
import com.efuture.pos.service.OfflinePayService;
import com.efuture.pos.service.common.CacheModelService;
import com.efuture.pos.util.CastUtil;
import com.efuture.pos.util.ManipulatePrecision;
import com.efuture.pos.util.ParamsValidateUtils;
import com.efuture.pos.util.UUIDUtils;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.client.RestTemplate;

public class OfflinePayServiceImpl
implements OfflinePayService {
    private static final Logger logger = LoggerFactory.getLogger(OfflinePayServiceImpl.class);
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    CacheModelService cacheModelService;
    @Autowired
    PosLogicServiceImpl posLogicServiceImpl;
    @Autowired
    public MainDataCentreService mainDataCentreService;
    @Autowired
    OfflinePayTools offlinePayTools;
    private static final String SUCCESS = "SUCCESS";

    @Override
    public ServiceResponse salePayQuery(ServiceSession session, JSONObject paramsObject) {
        CacheModel cacheModel;
        block23: {
            logger.info("salePayQuery\u5165\u53c2\uff1a" + paramsObject.toJSONString());
            ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
            if (!paramsValidateUtils.validate()) {
                return paramsValidateUtils.getServiceResponse();
            }
            if (!paramsObject.containsKey((Object)"terminalSno") || paramsObject.getString("terminalSno").isEmpty()) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355\u67e5\u8a62\u5fc5\u9808\u5305\u542b\u53c3\u6578[{0}]", (Object[])new Object[]{"\u5c0f\u7968\u865f"});
            }
            if (!paramsObject.containsKey((Object)"rate") || paramsObject.getDouble("rate").isNaN()) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355\u67e5\u8be2\u5fc5\u9808\u5305\u542b\u53c3\u6578[{0}]", (Object[])new Object[]{"\u532f\u7387"});
            }
            if (!paramsObject.containsKey((Object)"precision") || paramsObject.getString("precision").isEmpty()) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355\u67e5\u8be2\u5fc5\u9808\u5305\u542b\u53c3\u6578[{0}]", (Object[])new Object[]{"\u56db\u6368\u4e94\u5165\u7cbe\u5ea6"});
            }
            if (!paramsObject.containsKey((Object)"cutMode") || paramsObject.getString("cutMode").isEmpty()) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355\u67e5\u8be2\u5fc5\u9808\u5305\u542b\u53c3\u6578[{0}]", (Object[])new Object[]{"\u56db\u6368\u4e94\u5165\u65b9\u5f0f"});
            }
            String flowNo = paramsObject.getString("flowNo");
            cacheModel = this.cacheModelService.getCacheModelByFlowNo(flowNo);
            if (cacheModel == null) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8a02\u55ae[{0}]\u5df2\u5931\u6548\uff0c\u8acb\u91cd\u65b0\u751f\u6210\u8a02\u55ae", (Object[])new Object[]{flowNo});
            }
            if (null == cacheModel.getPaymentmethodposref() || cacheModel.getPaymentmethodposref().size() <= 0) {
                ServiceResponse res = this.queryPaymentmethod(session, paramsObject.getString("erpCode"));
                if (!"0".equals(res.getReturncode())) {
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8bf7\u6c42\u4e3b\u6570\u636e\u4e2d\u5fc3\u67e5\u8be2\u652f\u4ed8\u65b9\u5f0f\u5931\u8d25[{0}]", (Object[])new Object[]{res.getData().toString()});
                }
                QueryPaymentmethodOut out = (QueryPaymentmethodOut)res.getData();
                cacheModel.setPaymentmethodposref(out.getPaymentmethodposref());
                this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
            }
            String merchantOrderNo = "";
            boolean isBd = false;
            if (StringUtils.isNotBlank((String)paramsObject.getString("merchantOrderNo"))) {
                merchantOrderNo = paramsObject.getString("merchantOrderNo");
                isBd = true;
            } else {
                merchantOrderNo = cacheModel.getOrder().getMerchantOrderNo();
            }
            Boolean hasPayment = false;
            List<Payment> cacheList = cacheModel.getPayments();
            for (Payment payment : cacheList) {
                if (!payment.getPayNo().equals(merchantOrderNo)) continue;
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8be5\u7b14\u652f\u4ed8\u65b9\u5f0f\u5df2\u5b58\u5728");
            }
            ServiceResponse response = null;
            OfflinePayQueryReq offlinePayQueryReq = new OfflinePayQueryReq(paramsObject);
            offlinePayQueryReq.setOutTradeNo(merchantOrderNo);
            try {
                String cmft;
                logger.info("\u7ebf\u4e0b\u8ba2\u5355\u652f\u4ed8\u5165\u53c2\uff1a" + JSON.toJSONString((Object)offlinePayQueryReq));
                response = this.offlinePayTools.salePayQuery(this.restTemplate, session, JSON.toJSONString((Object)offlinePayQueryReq));
                logger.info("\u7ebf\u4e0b\u8ba2\u5355\u652f\u4ed8\u8fd4\u53c2\uff1a" + JSON.toJSONString((Object)response));
                JSONObject queryRev = (JSONObject)JSONObject.toJSON((Object)response.getData());
                if (!SUCCESS.equals(queryRev.getString("resultCode"))) break block23;
                if (isBd && StringUtils.isNotBlank((String)(cmft = cacheModel.getOrder().getSysPara().getCmft())) && CastUtil.castLong(cmft) > 0L) {
                    try {
                        String channelTransationTime = queryRev.getString("timeEnd");
                        LocalDateTime dateTime = LocalDateTime.now();
                        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
                        LocalDateTime orderDateTime = LocalDateTime.parse(channelTransationTime, df);
                        Duration duration = Duration.between(orderDateTime, dateTime);
                        if (duration.toMinutes() - CastUtil.castLong(cmft) > 0L) {
                            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u652f\u4ed8\u5931\u8d25\uff1a\u8d85\u8fc7\u4ea4\u6613\u95f4\u9694\u65f6\u95f4\u4e0d\u5141\u8bb8\u4f7f\u7528\u67e5\u8be2\u652f\u4ed8");
                        }
                    }
                    catch (Exception e) {
                        return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u6821\u9a8c\u4ea4\u6613\u95f4\u9694\u65f6\u95f4\u51fa\u73b0\u5f02\u5e38");
                    }
                }
                if (!hasPayment.booleanValue()) {
                    String channelFlag = queryRev.getString("payMode");
                    PaymentMethod paymentmethod = this.getPaymentmethod(paramsObject.getString("payCode"), channelFlag, cacheModel.getPaymentmethodposref());
                    if (null == paymentmethod) {
                        paramsObject.put("originMerchantOrderNo", (Object)merchantOrderNo);
                        for (int i = 0; i < 3; ++i) {
                            OfflineReverseReq offlineReverseReq = new OfflineReverseReq(paramsObject);
                            ServiceResponse resp = null;
                            logger.info("\u7ebf\u4e0b\u6536\u5355\u64a4\u9500\u8ba2\u5355\u5165\u53c2\uff1a" + JSON.toJSONString((Object)offlineReverseReq));
                            resp = this.offlinePayTools.reverse(this.restTemplate, session, JSON.toJSONString((Object)offlineReverseReq));
                            logger.info("\u7ebf\u4e0b\u6536\u5355\u64a4\u9500\u8ba2\u5355\u8fd4\u53c2\uff1a" + JSON.toJSONString((Object)resp));
                            JSONObject offlineReverseRev = (JSONObject)JSONObject.toJSON((Object)response.getData());
                            if (SUCCESS.equals(offlineReverseRev.getString("resultCode"))) {
                                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u652f\u4ed8\u5931\u8d25\uff1a\u652f\u4ed8\u65b9\u5f0f\u672a\u914d\u7f6e\uff0c\u5df2\u64a4\u9500");
                            }
                            try {
                                Thread.sleep(3000L);
                                continue;
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                        return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5b8c\u6210\u4e86\u672a\u914d\u7f6e\u7684\u4ea4\u6613\uff0c\u8bf7\u8054\u7cfbIT\u90e8\u95e8");
                    }
                    Payment payment = new Payment();
                    payment.setPuid(UUIDUtils.buildPuid());
                    payment.setRownoId(payment.getPuid());
                    payment.setPayCode(paymentmethod.getPosAbleCode());
                    payment.setPayName(paymentmethod.getPosAbleName());
                    payment.setPayNo(offlinePayQueryReq.getOutTradeNo());
                    double money = 0.0;
                    money = CastUtil.castDouble(queryRev.getString("totalFee"));
                    payment.setMoney(money / 100.0);
                    payment.setAmount(money / 100.0);
                    payment.setRate(1.0);
                    payment.setPrecision(paramsObject.getString("precision"));
                    payment.setPrcutMode(paramsObject.getString("cutMode"));
                    payment.setFlag("1");
                    payment.setTerminalNo(paramsObject.getString("terminalNo"));
                    payment.setTerminalSno(paramsObject.getString("terminalSno"));
                    payment.setRefCode(queryRev.getString("transactionId"));
                    payment.setDiscountValue(CastUtil.castDouble(queryRev.getString("merchantContribute")) + CastUtil.castDouble(queryRev.getString("platformContribute")) / 100.0);
                    payment.setMerchantDiscountValue(CastUtil.castDouble(queryRev.getString("merchantContribute")) / 100.0);
                    payment.setPayChannelDiscountValue(CastUtil.castDouble(queryRev.getString("platformContribute")) / 100.0);
                    payment.setRowno(cacheModel.getPayments().size() + 1);
                    cacheModel = this.posLogicServiceImpl.calcPayAmout(cacheModel, payment);
                }
            }
            catch (Exception e) {
                logger.info(e.getLocalizedMessage());
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u652f\u4ed8\u67e5\u8be2\u4e2d\u53f0\u901a\u9053\u5f02\u5e38");
            }
        }
        this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
        BaseOutModel out = new BaseOutModel();
        out.setOrder(OrderForPos.toOrderForPos(cacheModel));
        return ServiceResponse.buildSuccess((Object)out);
    }

    @Override
    public ServiceResponse salePay(ServiceSession session, JSONObject paramsObject) {
        logger.info("salePay\u5165\u53c2\uff1a" + paramsObject.toJSONString());
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        if (!paramsObject.containsKey((Object)"payBarCode") || paramsObject.getString("payBarCode").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u652f\u4ed8\u5fc5\u9808\u5305\u542b\u53c3\u6578[{0}]", (Object[])new Object[]{"\u652f\u4ed8\u78bc"});
        }
        if (!paramsObject.containsKey((Object)"amount") || paramsObject.getString("amount").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u652f\u4ed8\u5fc5\u9808\u5305\u542b\u53c3\u6578[{0}]", (Object[])new Object[]{"\u652f\u4ed8\u91d1\u984d"});
        }
        if (!paramsObject.containsKey((Object)"terminalSno") || paramsObject.getString("terminalSno").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u652f\u4ed8\u5fc5\u9808\u5305\u542b\u53c3\u6578[{0}]", (Object[])new Object[]{"\u5c0f\u7968\u53f7"});
        }
        if (!paramsObject.containsKey((Object)"rate") || paramsObject.getDouble("rate").isNaN()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u652f\u4ed8\u5fc5\u9808\u5305\u542b\u53c3\u6578[{0}]", (Object[])new Object[]{"\u532f\u7387"});
        }
        if (!paramsObject.containsKey((Object)"precision") || paramsObject.getString("precision").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u652f\u4ed8\u5fc5\u9808\u5305\u542b\u53c3\u6578[{0}]", (Object[])new Object[]{"\u56db\u6368\u4e94\u5165\u7cbe\u5ea6"});
        }
        if (!paramsObject.containsKey((Object)"cutMode") || paramsObject.getString("cutMode").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u652f\u4ed8\u5fc5\u9808\u5305\u542b\u53c3\u6578[{0}]", (Object[])new Object[]{"\u56db\u6368\u4e94\u5165\u65b9\u5f0f"});
        }
        String flowNo = paramsObject.getString("flowNo");
        CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(flowNo);
        if (cacheModel == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8a02\u55ae[{0}]\u5df2\u5931\u6548\uff0c\u8acb\u91cd\u65b0\u751f\u6210\u8a02\u55ae", (Object[])new Object[]{flowNo});
        }
        if (null == cacheModel.getPaymentmethodposref() || cacheModel.getPaymentmethodposref().size() <= 0) {
            ServiceResponse res = this.queryPaymentmethod(session, paramsObject.getString("erpCode"));
            if (!"0".equals(res.getReturncode())) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8bf7\u6c42\u4e3b\u6570\u636e\u4e2d\u5fc3\u67e5\u8be2\u652f\u4ed8\u65b9\u5f0f\u5931\u8d25[{0}]", (Object[])new Object[]{res.getData().toString()});
            }
            QueryPaymentmethodOut out = (QueryPaymentmethodOut)res.getData();
            cacheModel.setPaymentmethodposref(out.getPaymentmethodposref());
            this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
        }
        Order order = cacheModel.getOrder();
        double remainValue = (cacheModel = this.posLogicServiceImpl.calcBalance(cacheModel)).getOrder().getRemainValue();
        if (remainValue <= 0.0) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5df2\u4ed8\u6e05\u6b3e\u9805\uff0c\u7121\u9700\u518d\u652f\u4ed8\uff01");
        }
        remainValue = ManipulatePrecision.doubleConvert(remainValue, 2, 0);
        OffinePayReq offinePayReq = new OffinePayReq(paramsObject);
        String merchantOrderNo = OfflinePayServiceImpl.getMerchantOrderNo(paramsObject);
        offinePayReq.setOutTradeNo(merchantOrderNo);
        List<Goods> goodsList = cacheModel.getGoodsList();
        ArrayList<OffinePayReq.GoodsDetail> goodsDetail = new ArrayList<OffinePayReq.GoodsDetail>();
        for (Goods goods : goodsList) {
            OffinePayReq.GoodsDetail d = new OffinePayReq.GoodsDetail();
            d.setQuantity(goods.getQty());
            d.setGoodsId(goods.getGoodsCode());
            d.setGoodsName(goods.getGoodsName().replaceAll("\"", "").replaceAll(">", "").replaceAll("'", "").replaceAll("&", "").replaceAll("<", ""));
            d.setPrice((int)goods.getSalePrice() * 100);
            goodsDetail.add(d);
        }
        JSONObject ob = new JSONObject();
        ob.put("goodsDetail", goodsDetail);
        offinePayReq.setDetail(ob);
        ServiceResponse response = null;
        try {
            PaymentMethod paymentmethod;
            logger.info("\u7ebf\u4e0b\u6536\u5355\u652f\u4ed8\u5165\u53c2\uff1a" + JSON.toJSONString((Object)offinePayReq));
            response = this.offlinePayTools.salePay(this.restTemplate, session, JSON.toJSONString((Object)offinePayReq));
            logger.info("\u7ebf\u4e0b\u6536\u5355\u652f\u4ed8\u8fd4\u53c2\uff1a" + JSON.toJSONString((Object)response));
            cacheModel.getOrder().setMerchantOrderNo(merchantOrderNo);
            this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
            JSONObject offinePayRev = (JSONObject)JSONObject.toJSON((Object)response.getData());
            if (SUCCESS.equals(offinePayRev.getString("resultCode"))) {
                String channelFlag = offinePayRev.getString("payMode");
                paymentmethod = this.getPaymentmethod(paramsObject.getString("payCode"), channelFlag, cacheModel.getPaymentmethodposref());
                if (null == paymentmethod) {
                    paramsObject.put("originMerchantOrderNo", (Object)merchantOrderNo);
                    for (int i = 0; i < 3; ++i) {
                        OfflineReverseReq offlineReverseReq = new OfflineReverseReq(paramsObject);
                        ServiceResponse resp = null;
                        logger.info("\u7ebf\u4e0b\u6536\u5355\u64a4\u9500\u8ba2\u5355\u5165\u53c2\uff1a" + JSON.toJSONString((Object)offlineReverseReq));
                        resp = this.offlinePayTools.reverse(this.restTemplate, session, JSON.toJSONString((Object)offlineReverseReq));
                        logger.info("\u7ebf\u4e0b\u6536\u5355\u64a4\u9500\u8ba2\u5355\u8fd4\u53c2\uff1a" + JSON.toJSONString((Object)resp));
                        JSONObject offlineReverseRev = (JSONObject)JSONObject.toJSON((Object)response.getData());
                        if (SUCCESS.equals(offlineReverseRev.getString("resultCode"))) {
                            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u652f\u4ed8\u5931\u8d25\uff1a\u652f\u4ed8\u65b9\u5f0f\u672a\u914d\u7f6e\uff0c\u5df2\u64a4\u9500");
                        }
                        try {
                            Thread.sleep(3000L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5b8c\u6210\u4e86\u672a\u914d\u7f6e\u7684\u4ea4\u6613\uff0c\u8bf7\u8054\u7cfbIT\u90e8\u95e8");
                }
            } else {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)offinePayRev.getString("errCode"), (String)offinePayRev.getString("errCodeDes"));
            }
            Payment payment = new Payment();
            payment.setPuid(UUIDUtils.buildPuid());
            payment.setRownoId(payment.getPuid());
            payment.setPayCode(paymentmethod.getPosAbleCode());
            payment.setPayName(paymentmethod.getPosAbleName());
            payment.setPayNo(offinePayRev.getString("outTradeNo"));
            double money = 0.0;
            money = CastUtil.castDouble(offinePayRev.getString("totalFee"));
            payment.setMoney(money / 100.0);
            payment.setAmount(money / 100.0);
            payment.setRate(paramsObject.getDouble("rate"));
            payment.setPrecision(paramsObject.getString("precision"));
            payment.setPrcutMode(paramsObject.getString("cutMode"));
            payment.setFlag("1");
            payment.setTerminalNo(paramsObject.getString("terminalNo"));
            payment.setTerminalSno(paramsObject.getString("terminalSno"));
            payment.setRefCode(offinePayRev.getString("transactionId"));
            payment.setDiscountValue(CastUtil.castDouble(offinePayRev.getString("merchantContribute")) + CastUtil.castDouble(offinePayRev.getString("platformContribute")) / 100.0);
            payment.setMerchantDiscountValue(CastUtil.castDouble(offinePayRev.getString("merchantContribute")) / 100.0);
            payment.setPayChannelDiscountValue(CastUtil.castDouble(offinePayRev.getString("platformContribute")) / 100.0);
            payment.setRowno(cacheModel.getPayments().size() + 1);
            payment.setIsDirectDel(true);
            cacheModel = this.posLogicServiceImpl.calcPayAmout(cacheModel, payment);
        }
        catch (Exception e) {
            logger.info("\u4e2d\u53f0\u652f\u4ed8\u901a\u9053\u5f02\u5e38:" + JSON.toJSONString(response));
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u652f\u4ed8\u5931\u8d25-\u4e2d\u53f0\u652f\u4ed8\u901a\u9053\u5f02\u5e38");
        }
        this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
        BaseOutModel out = new BaseOutModel();
        out.setOrder(OrderForPos.toOrderForPos(cacheModel));
        return ServiceResponse.buildSuccess((Object)out);
    }

    @Override
    public ServiceResponse saleRefund(ServiceSession session, JSONObject paramsObject) {
        logger.info("saleRefund\u5165\u53c2\uff1a" + paramsObject.toJSONString());
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        if (!paramsObject.containsKey((Object)"terminalSno") || paramsObject.getString("terminalSno").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u9000\u6b3e\u5fc5\u9808\u5305\u542b\u53c3\u6578[{0}]", (Object[])new Object[]{"\u5c0f\u7968\u865f"});
        }
        if (!paramsObject.containsKey((Object)"originMerchantOrderNo") || paramsObject.getString("originMerchantOrderNo").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u9000\u6b3e\u5fc5\u9808\u5305\u542b\u53c3\u6578[{0}]", (Object[])new Object[]{"\u539f\u55ae\u865f"});
        }
        if (!paramsObject.containsKey((Object)"amount") || paramsObject.getString("amount").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u9000\u6b3e\u5fc5\u9808\u5305\u542b\u53c3\u6578[{0}]", (Object[])new Object[]{"\u9000\u6b3e\u91d1\u989d"});
        }
        if (!paramsObject.containsKey((Object)"rate") || paramsObject.getDouble("rate").isNaN()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u9000\u6b3e\u5fc5\u9808\u5305\u542b\u53c3\u6578[{0}]", (Object[])new Object[]{"\u532f\u7387"});
        }
        if (!paramsObject.containsKey((Object)"precision") || paramsObject.getString("precision").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u9000\u6b3e\u5fc5\u9808\u5305\u542b\u53c3\u6578[{0}]", (Object[])new Object[]{"\u56db\u6368\u4e94\u5165\u7cbe\u5ea6"});
        }
        if (!paramsObject.containsKey((Object)"cutMode") || paramsObject.getString("cutMode").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u9000\u6b3e\u5fc5\u9808\u5305\u542b\u53c3\u6578[{0}]", (Object[])new Object[]{"\u56db\u6368\u4e94\u5165\u65b9\u5f0f"});
        }
        CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(paramsObject.getString("flowNo"));
        if (null == cacheModel) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8a02\u55ae\u5df2\u5931\u6548\uff0c\u8acb\u91cd\u65b0\u7372\u53d6\u8a02\u55ae\u6d41\u6c34\u865f\uff01");
        }
        Order order = cacheModel.getOrder();
        String merchantOrderNo = OfflinePayServiceImpl.getMerchantOrderNo(paramsObject);
        OffineRefundReq refundReq = new OffineRefundReq(paramsObject);
        refundReq.setOutRefundNo(merchantOrderNo);
        cacheModel = this.posLogicServiceImpl.calcBalance(cacheModel);
        double amount = ManipulatePrecision.getDetailOverFlow(paramsObject.getDouble("amount"), paramsObject.getString("cutMode"));
        if (ManipulatePrecision.doubleCompare(amount, order.getRemainValue(), 1) == 1) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8bf7\u6c42\u91d1\u989d\u5fc5\u987b\u5c0f\u4e8e\u8ba2\u5355\u5269\u4f59\u91d1\u989d", (Object[])new Object[]{""});
        }
        refundReq.setRefundFee((int)ManipulatePrecision.doubleConvert(amount * 100.0));
        ServiceResponse response = null;
        try {
            logger.info("\u7ebf\u4e0b\u6536\u5355\u9000\u6b3e\u5165\u53c2\uff1a" + JSON.toJSONString((Object)refundReq));
            response = this.offlinePayTools.refund(this.restTemplate, session, JSON.toJSONString((Object)refundReq));
            logger.info("\u7ebf\u4e0b\u6536\u5355\u9000\u6b3e\u8fd4\u53c2\uff1a" + JSON.toJSONString((Object)response));
            cacheModel.getOrder().setMerchantOrderNo(merchantOrderNo);
            this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
            JSONObject offineRefundRev = (JSONObject)JSONObject.toJSON((Object)response.getData());
            if (!SUCCESS.equals(offineRefundRev.getString("resultCode"))) {
                logger.info("\u7ebf\u4e0b\u6536\u5355\u9000\u6b3e\u5931\u8d25\u8bf7\u6c42\uff1a" + JSON.toJSONString((Object)offineRefundRev));
                return ServiceResponse.buildFailure((ServiceSession)session, (String)offineRefundRev.getString("errCode"), (String)offineRefundRev.getString("errCodeDes"));
            }
            Payment payment = new Payment();
            payment.setPuid(UUIDUtils.buildPuid());
            payment.setRownoId(payment.getPuid());
            payment.setPayCode(paramsObject.getString("payCode"));
            payment.setPayName(paramsObject.getString("payName"));
            payment.setMoney(amount);
            payment.setAmount(amount);
            payment.setRate(paramsObject.getDouble("rate"));
            payment.setPrecision(paramsObject.getString("precision"));
            payment.setFlag("1");
            payment.setTerminalNo(paramsObject.getString("terminalNo"));
            payment.setTerminalSno(paramsObject.getString("terminalSno"));
            payment.setRowno(cacheModel.getPayments().size() + 1);
            payment.setPrcutMode(paramsObject.getString("cutMode"));
            payment.setPayNo(merchantOrderNo);
            payment.setRefCode(offineRefundRev.getString("transactionId"));
            payment.setDiscountValue(0.0);
            payment.setMerchantDiscountValue(0.0);
            payment.setPayChannelDiscountValue(0.0);
            cacheModel = this.posLogicServiceImpl.calcPayAmout(cacheModel, payment);
        }
        catch (Exception e) {
            logger.error("\u9000\u6b3e\u5931\u8d25", (Throwable)e);
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u9000\u6b3e\u5931\u8d25-\u4e2d\u53f0\u901a\u9053\u5f02\u5e38");
        }
        this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
        BaseOutModel out = new BaseOutModel();
        out.setOrder(OrderForPos.toOrderForPos(cacheModel));
        return ServiceResponse.buildSuccess((Object)out);
    }

    @Override
    public ServiceResponse saleRefundQuery(ServiceSession session, JSONObject paramsObject) {
        logger.info("saleRefundQuery\u5165\u53c2\uff1a" + paramsObject.toJSONString());
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        if (!paramsObject.containsKey((Object)"originRefundMerchantOrderNo") || paramsObject.getString("originRefundMerchantOrderNo").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u9000\u6b3e\u67e5\u8a62\u5fc5\u9808\u5305\u542b\u53c3\u6578[{0}]", (Object[])new Object[]{"\u539f\u55ae\u865f"});
        }
        String flowNo = paramsObject.getString("flowNo");
        CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(flowNo);
        if (cacheModel == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8a02\u55ae[{0}]\u5df2\u5931\u6548\uff0c\u8acb\u91cd\u65b0\u751f\u6210\u8a02\u55ae", (Object[])new Object[]{flowNo});
        }
        OfflineRefundQueryReq offlineRefundQueryReq = new OfflineRefundQueryReq(paramsObject);
        ServiceResponse response = null;
        try {
            logger.info("\u7ebf\u4e0b\u6536\u5355\u9000\u6b3e\u67e5\u8be2\u5165\u53c2\uff1a" + JSON.toJSONString((Object)offlineRefundQueryReq));
            response = this.offlinePayTools.refundQuery(this.restTemplate, session, JSON.toJSONString((Object)offlineRefundQueryReq));
            logger.info("\u7ebf\u4e0b\u6536\u5355\u9000\u6b3e\u67e5\u8be2\u8fd4\u53c2\uff1a" + JSON.toJSONString((Object)response));
            JSONObject offlineRefundQueryRev = (JSONObject)JSONObject.toJSON((Object)response.getData());
            if (SUCCESS.equals(offlineRefundQueryRev.getString("resultCode"))) {
                return ServiceResponse.buildSuccess((Object)offlineRefundQueryRev);
            }
            logger.info("\u7ebf\u4e0b\u6536\u5355\u9000\u6b3e\u67e5\u8be2\u5931\u8d25\uff1a" + JSON.toJSONString((Object)offlineRefundQueryRev));
            return ServiceResponse.buildFailure((ServiceSession)session, (String)offlineRefundQueryRev.getString("errCode"), (String)offlineRefundQueryRev.getString("errCodeDes"));
        }
        catch (Exception e) {
            logger.info(e.getLocalizedMessage());
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u9000\u6b3e\u5931\u8d25-\u4e2d\u53f0\u901a\u9053\u5f02\u5e38");
        }
    }

    @Override
    public ServiceResponse saleRepealPay(ServiceSession session, JSONObject paramsObject) {
        CacheModel cacheModel;
        block13: {
            logger.info("saleRepealPay\u5165\u53c2\uff1a" + paramsObject.toJSONString());
            ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
            if (!paramsValidateUtils.validate()) {
                return paramsValidateUtils.getServiceResponse();
            }
            if (!paramsObject.containsKey((Object)"originMerchantOrderNo") || paramsObject.getString("originMerchantOrderNo").isEmpty()) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u64a4\u92b7\u4ed8\u6b3e\u5fc5\u9808\u5305\u542b\u53c3\u6578[{0}]", (Object[])new Object[]{"\u539f\u55ae\u865f"});
            }
            if (!paramsObject.containsKey((Object)"puid") || paramsObject.getString("puid").isEmpty()) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u64a4\u92b7\u4ed8\u6b3e\u5fc5\u9808\u5305\u542b\u53c3\u6578[{0}]", (Object[])new Object[]{"\u4ed8\u6b3e\u552f\u4e00\u6807\u8bc6\u53f7"});
            }
            cacheModel = this.cacheModelService.getCacheModelByFlowNo(paramsObject.getString("flowNo"));
            if (null == cacheModel) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8a02\u55ae\u5df2\u5931\u6548\uff0c\u8acb\u91cd\u65b0\u7372\u53d6\u8a02\u55ae\u6d41\u6c34\u865f\uff01");
            }
            if (cacheModel.getOrder().getSendSuccess()) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u63d0\u4ea4\u6210\u529f\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u4ed8\u6b3e\u4fe1\u606f", (Object[])new Object[]{paramsObject.getString("flowNo")});
            }
            String puid = paramsObject.getString("puid");
            Payment PreDeletePayment = null;
            for (Payment p : cacheModel.getPayments()) {
                if (!p.getPuid().equals(puid)) continue;
                PreDeletePayment = p;
                break;
            }
            if (PreDeletePayment == null) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u64a4\u9500\u4ed8\u6b3e\u5931\u8d25\u539f\u56e0[{0}]", (Object[])new Object[]{"\u4ed8\u6b3e\u884c\u4e3a\u7a7a"});
            }
            OfflineReverseReq offlineReverseReq = new OfflineReverseReq(paramsObject);
            ServiceResponse response = null;
            try {
                logger.info("\u7ebf\u4e0b\u6536\u5355\u64a4\u9500\u8ba2\u5355\u5165\u53c2\uff1a" + JSON.toJSONString((Object)offlineReverseReq));
                response = this.offlinePayTools.reverse(this.restTemplate, session, JSON.toJSONString((Object)offlineReverseReq));
                logger.info("\u7ebf\u4e0b\u6536\u5355\u64a4\u9500\u8ba2\u5355\u8fd4\u53c2\uff1a" + JSON.toJSONString((Object)response));
                JSONObject offlineReverseRev = (JSONObject)JSONObject.toJSON((Object)response.getData());
                if (SUCCESS.equals(offlineReverseRev.getString("resultCode"))) {
                    if (PreDeletePayment != null) {
                        cacheModel.getPayments().remove(PreDeletePayment);
                        cacheModel = this.posLogicServiceImpl.CalcOrderAmountByDeletePayReturn(cacheModel);
                        if (cacheModel.getCalcResult() == -1) {
                            String errCode = "100000";
                            if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                                errCode = cacheModel.getErrCode();
                            }
                            return ServiceResponse.buildFailure((ServiceSession)session, (String)errCode, (String)cacheModel.getErrMsg());
                        }
                        cacheModel = this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
                    }
                    break block13;
                }
                logger.info("\u7ebf\u4e0b\u6536\u5355\u64a4\u9500\u8ba2\u5355\u5931\u8d25\uff1a" + JSON.toJSONString((Object)offlineReverseRev));
                return ServiceResponse.buildFailure((ServiceSession)session, (String)offlineReverseRev.getString("errCode"), (String)offlineReverseRev.getString("errCodeDes"));
            }
            catch (Exception e) {
                logger.info(e.getLocalizedMessage());
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u64a4\u9500\u5931\u8d25-\u4e2d\u53f0\u901a\u9053\u5f02\u5e38");
            }
        }
        BaseOutModel out = new BaseOutModel();
        out.setOrder(OrderForPos.toOrderForPos(cacheModel));
        return ServiceResponse.buildSuccess((Object)out);
    }

    private static String getTime() {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        String time = df.format(new Date()).toString();
        return time;
    }

    private static String getMerchantOrderNo(JSONObject json) {
        String shopCode = json.getString("shopCode");
        String terminalNo = json.getString("terminalNo");
        String terminalSno = json.getString("terminalSno");
        String timestamp = OfflinePayServiceImpl.getTime();
        String merchantOrderNo = shopCode + terminalNo + terminalSno + timestamp;
        return merchantOrderNo;
    }

    public ServiceResponse queryPaymentmethod(ServiceSession session, String erpCode) {
        QueryPaymentmethodIn in = new QueryPaymentmethodIn();
        in.setErpCode(erpCode);
        in.setPage_no(1);
        in.setPage_size(9999);
        return this.mainDataCentreService.queryPaymentmethod(this.restTemplate, session, in);
    }

    private PaymentMethod getPaymentmethod(String payCode, String channelFlag, List<PaymentMethod> list) {
        logger.info("getPaymentmethod,{},{},{}", new Object[]{payCode, channelFlag, JSONObject.toJSONString(list)});
        for (PaymentMethod paymentMethod : list) {
            if (!StringUtils.isNotBlank((String)paymentMethod.getPmcode()) || !paymentMethod.getPmcode().equals(channelFlag) || !payCode.equals(paymentMethod.getPayCode())) continue;
            return paymentMethod;
        }
        return null;
    }

    public static void main(String[] args) {
        JSONObject paramsObject = new JSONObject();
        paramsObject.put("storeCode", (Object)"0008");
        paramsObject.put("outTradeNo", (Object)"000872221345320200415180939");
    }
}

