/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pos.component;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.enu.order.OrderStateEnum;
import com.efuture.model.order.OrdersDetailModel;
import com.efuture.model.order.OrdersDetailPopModel;
import com.efuture.model.order.OrdersGainDetailModel;
import com.efuture.model.order.OrdersGainModel;
import com.efuture.model.order.OrdersPayModel;
import com.efuture.model.order.OrdersUseCouponModel;
import com.efuture.pos.component.AeonCrmServiceImpl;
import com.efuture.pos.component.CartServiceImpl;
import com.efuture.pos.component.CommonService;
import com.efuture.pos.component.MemberServiceImpl;
import com.efuture.pos.component.PointConsumeReverseServiceImpl;
import com.efuture.pos.component.PosLogicCompoment;
import com.efuture.pos.component.PosLogicServiceImpl;
import com.efuture.pos.component.PromotionServiceImpl;
import com.efuture.pos.component.YWMemberPointServiceImpl;
import com.efuture.pos.component.async.AsyncTask;
import com.efuture.pos.component.common.SellType;
import com.efuture.pos.component.common.WorkLogType;
import com.efuture.pos.component.common.YPopStatusType;
import com.efuture.pos.component.service.ChinaYWService;
import com.efuture.pos.component.util.ReadOrWriterUtil;
import com.efuture.pos.model.AnalyzeBarcodeDef;
import com.efuture.pos.model.BackPrintDef;
import com.efuture.pos.model.BackPrintGoodsInfo;
import com.efuture.pos.model.BaseOutModel;
import com.efuture.pos.model.CacheModel;
import com.efuture.pos.model.ConsumersData;
import com.efuture.pos.model.Coupon;
import com.efuture.pos.model.CouponGain;
import com.efuture.pos.model.CouponUse;
import com.efuture.pos.model.DzcGoodsDetail;
import com.efuture.pos.model.ExceptPay;
import com.efuture.pos.model.ExceptPayForPos;
import com.efuture.pos.model.GetSyncDataCount;
import com.efuture.pos.model.GiftsGroup;
import com.efuture.pos.model.Goods;
import com.efuture.pos.model.GoodsForPos;
import com.efuture.pos.model.OperUser;
import com.efuture.pos.model.Order;
import com.efuture.pos.model.OrderForPos;
import com.efuture.pos.model.OrderGains;
import com.efuture.pos.model.PayMode;
import com.efuture.pos.model.Payment;
import com.efuture.pos.model.PaymentForPos;
import com.efuture.pos.model.PaymentInfo;
import com.efuture.pos.model.PopDetail;
import com.efuture.pos.model.PopDetailForPos;
import com.efuture.pos.model.PosClearInfoDef;
import com.efuture.pos.model.PrintInfo;
import com.efuture.pos.model.RatesStatisticsDef;
import com.efuture.pos.model.SalesStatisticsDef;
import com.efuture.pos.model.SimpleQueryIn;
import com.efuture.pos.model.SysPara;
import com.efuture.pos.model.SysParaInfo;
import com.efuture.pos.model.aeoncrm.request.UpdateStampIn;
import com.efuture.pos.model.aeoncrm.response.ProfileOut;
import com.efuture.pos.model.aeoncrm.response.UpdateStampOut;
import com.efuture.pos.model.cnaeon.response.SubCompany;
import com.efuture.pos.model.mainDataCentre.CategoryProperty;
import com.efuture.pos.model.mainDataCentre.GoodsInfo;
import com.efuture.pos.model.mainDataCentre.request.GetGoodsDetailIn;
import com.efuture.pos.model.mainDataCentre.request.GetQuotaInfoIn;
import com.efuture.pos.model.mainDataCentre.request.GetRegionRuleNameIn;
import com.efuture.pos.model.mainDataCentre.request.PaySerchIn;
import com.efuture.pos.model.mainDataCentre.request.UpdateQuotaInfoIn;
import com.efuture.pos.model.mainDataCentre.response.GetGoodsDetailOut;
import com.efuture.pos.model.mainDataCentre.response.GetQuotaInfoOut;
import com.efuture.pos.model.mainDataCentre.response.GetRegionInfoOut;
import com.efuture.pos.model.mainDataCentre.response.GetRegionRuleNameOut;
import com.efuture.pos.model.mainDataCentre.response.PaySerchOut;
import com.efuture.pos.model.mainDataCentre.response.SearchMealDetailOut;
import com.efuture.pos.model.orderCentre.BackPrintItem;
import com.efuture.pos.model.orderCentre.OrderClearInfoDef;
import com.efuture.pos.model.orderCentre.OrderRateStatisticsDef;
import com.efuture.pos.model.orderCentre.OrderSalesStatisticsDef;
import com.efuture.pos.model.orderCentre.OrdersModel4Pos;
import com.efuture.pos.model.orderCentre.SaleOrders;
import com.efuture.pos.model.orderCentre.request.DeleteOrderLocal;
import com.efuture.pos.model.orderCentre.request.GetClearInfoIn;
import com.efuture.pos.model.orderCentre.request.GetSalesStatisticsForCardIn;
import com.efuture.pos.model.orderCentre.request.GetSalesStatisticsIn;
import com.efuture.pos.model.orderCentre.request.OrderQueryIn;
import com.efuture.pos.model.orderCentre.request.PrintLogIn;
import com.efuture.pos.model.orderCentre.request.SearchLocalOrdersIn;
import com.efuture.pos.model.orderCentre.request.StallBackPrintIn;
import com.efuture.pos.model.orderCentre.request.SynQueryOrderIn;
import com.efuture.pos.model.orderCentre.request.SyncLocalOrderIn;
import com.efuture.pos.model.orderCentre.response.GetClearInfoOut;
import com.efuture.pos.model.orderCentre.response.GetOrdersDetailOut;
import com.efuture.pos.model.orderCentre.response.GetSalesStatisticsForCardOut;
import com.efuture.pos.model.orderCentre.response.GetSalesStatisticsOut;
import com.efuture.pos.model.orderCentre.response.OrdersQueryOut;
import com.efuture.pos.model.orderCentre.response.SaveOrdersOut;
import com.efuture.pos.model.orderCentre.response.SearchLocalOrdersOut;
import com.efuture.pos.model.orderCentre.response.SynQueryOrderOut;
import com.efuture.pos.model.posManager.BankCardInfoDef;
import com.efuture.pos.model.posManager.ElecScaleCodeRule;
import com.efuture.pos.model.posManager.StampExchangeInfo;
import com.efuture.pos.model.posManager.request.ElecScaleCodeRuleIn;
import com.efuture.pos.model.posManager.request.GetBankCardInfoIn;
import com.efuture.pos.model.posManager.request.OperUserIn;
import com.efuture.pos.model.posManager.request.QuerySyncDataIn;
import com.efuture.pos.model.posManager.request.QueryTerminalInfoIn;
import com.efuture.pos.model.posManager.request.SysparaIn;
import com.efuture.pos.model.posManager.request.UpdatePosCenterSynStatus;
import com.efuture.pos.model.posManager.response.ElecScaleCodeRuleOut;
import com.efuture.pos.model.posManager.response.GetBankCardInfoOut;
import com.efuture.pos.model.posManager.response.OperUserOut;
import com.efuture.pos.model.posManager.response.QuerySyncDataOut;
import com.efuture.pos.model.posManager.response.QueryTerminalInfoOut;
import com.efuture.pos.model.posManager.response.SysparaOut;
import com.efuture.pos.model.promotionCentre.SellPayment;
import com.efuture.pos.model.promotionCentre.request.CalSaleReturnIn;
import com.efuture.pos.model.promotionCentre.request.CalcafFirmIn;
import com.efuture.pos.model.promotionCentre.request.CalcsingleIn;
import com.efuture.pos.model.promotionCentre.request.CouponGainCalcIn;
import com.efuture.pos.model.promotionCentre.request.CouponuseConsumeIn;
import com.efuture.pos.model.promotionCentre.request.GetGiveRuleIn;
import com.efuture.pos.model.promotionCentre.response.CalSaleReturnOut;
import com.efuture.pos.model.promotionCentre.response.CalcafFirmOut;
import com.efuture.pos.model.promotionCentre.response.CalcsingleOut;
import com.efuture.pos.model.promotionCentre.response.CouponGainCalcOut;
import com.efuture.pos.model.promotionCentre.response.GetGiveRuleOut;
import com.efuture.pos.model.request.BackPrintIn;
import com.efuture.pos.model.request.CancelPayIn;
import com.efuture.pos.model.request.ChangeOrderSnoIn;
import com.efuture.pos.model.request.ChangeOrderTypeIn;
import com.efuture.pos.model.request.ConfirmSaleReturnIn;
import com.efuture.pos.model.request.CopySnoIn;
import com.efuture.pos.model.request.CountAllIn;
import com.efuture.pos.model.request.DeletePaymentIn;
import com.efuture.pos.model.request.GetClearInfoPosIn;
import com.efuture.pos.model.request.GetFlowNoIn;
import com.efuture.pos.model.request.GetOrderIn;
import com.efuture.pos.model.request.GetOrderInfoIn;
import com.efuture.pos.model.request.GetOrdersIn;
import com.efuture.pos.model.request.GetSalesStatisticsForCardPosIn;
import com.efuture.pos.model.request.GetSalesStatisticsForPosIn;
import com.efuture.pos.model.request.PayConfirmIn;
import com.efuture.pos.model.request.PaymentIn;
import com.efuture.pos.model.request.QueryGiveRuleIn;
import com.efuture.pos.model.request.QuerySalesIn;
import com.efuture.pos.model.request.RecordPrintLogIn;
import com.efuture.pos.model.request.RefreshBackPrintInfo;
import com.efuture.pos.model.request.RefreshDeliveryInfoIn;
import com.efuture.pos.model.request.SaleReturnIn;
import com.efuture.pos.model.request.SaleReturnQueryIn;
import com.efuture.pos.model.request.SaveSaleReturnIn;
import com.efuture.pos.model.request.SynSalesIn;
import com.efuture.pos.model.request.UpdatePaymentStatusIn;
import com.efuture.pos.model.response.AmcMemberLoginOut;
import com.efuture.pos.model.response.BackPrintOut;
import com.efuture.pos.model.response.CancelAssginTypeDisOut;
import com.efuture.pos.model.response.CancelPayOut;
import com.efuture.pos.model.response.CountAllOut;
import com.efuture.pos.model.response.GetClearInfoPosOut;
import com.efuture.pos.model.response.GetFlowNoOut;
import com.efuture.pos.model.response.GetRateStatisticsPosOut;
import com.efuture.pos.model.response.GetRefundOrderInfoOut;
import com.efuture.pos.model.response.GetSalesStatisticsPosOut;
import com.efuture.pos.model.response.PayConfirmOut;
import com.efuture.pos.model.response.QueryGiveRuleOut;
import com.efuture.pos.model.response.QuerySalesOut;
import com.efuture.pos.model.response.RefreshOctopusInfoOut;
import com.efuture.pos.model.response.SaleReturnOut;
import com.efuture.pos.model.response.TransferAeonCardNoOut;
import com.efuture.pos.model.yongwang.request.YWMemberConsumeReverseIn;
import com.efuture.pos.model.yongwang.response.YWMemberOut;
import com.efuture.pos.service.OrderService;
import com.efuture.pos.service.common.CacheModelService;
import com.efuture.pos.service.sync.SyncTradeService;
import com.efuture.pos.util.CastUtil;
import com.efuture.pos.util.Convert;
import com.efuture.pos.util.DataExchageUtils;
import com.efuture.pos.util.HttpUtils;
import com.efuture.pos.util.JsonUtils;
import com.efuture.pos.util.ManipulatePrecision;
import com.efuture.pos.util.ParamsValidateUtils;
import com.efuture.pos.util.UUIDUtils;
import com.efuture.pos.util.ValidateUtils;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.web.client.RestTemplate;

public class OrderServiceImpl
extends CommonService
implements OrderService {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrderServiceImpl.class);
    private String timestamp = "20200731.01";
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    AeonCrmServiceImpl aeonAMCService;
    @Autowired
    CacheModelService cacheModelService;
    @Autowired
    PosLogicServiceImpl posLogicServiceImpl;
    @Autowired
    PosLogicCompoment posLogicCompoment;
    @Autowired
    SyncTradeService syncTradeServiceImpl;
    @Autowired
    PromotionServiceImpl promotionServiceImpl;
    @Autowired
    private MemberServiceImpl memberService;
    @Autowired
    private CartServiceImpl cartServiceImpl;
    @Value(value="${server.route.mode}")
    private String routeMode;
    @Resource(name="stringRedisTemplate")
    private ValueOperations<String, String> opsForValue;
    @Autowired
    private ChinaYWService chinaYWService;
    @Autowired
    PointConsumeReverseServiceImpl pointConsumeReverseService;
    @Autowired
    private YWMemberPointServiceImpl yWMemberPointService;
    @Autowired
    AsyncTask asyncTask;

    public ServiceResponse saleReturn(ServiceSession session, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        if (!paramsObject.containsKey((Object)"autoBackPayCode") || paramsObject.getString("autoBackPayCode").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba1\u7b97\u9000\u8d27\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u81ea\u52a8\u751f\u6210\u6263\u56de\u884c\u7684\u4ed8\u6b3e\u65b9\u5f0f\u4ee3\u7801"});
        }
        if (!paramsObject.containsKey((Object)"calcMode") || paramsObject.getString("calcMode").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba1\u7b97\u9000\u8d27\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u9000\u8d27\u72b6\u6001 0 \u9996\u6b21 1 \u9009\u5b8c\u8d60\u54c1 2 \u6263\u5b8c\u8fd4\u5238"});
        }
        SaleReturnIn salesReturnIn = (SaleReturnIn)JSON.parseObject((String)paramsObject.toJSONString(), SaleReturnIn.class);
        CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(salesReturnIn.getFlowNo());
        cacheModel.setAutoBackCode(paramsObject.getString("autoBackPayCode"));
        if (null == cacheModel.getBakGoods() || cacheModel.getBakGoods().size() <= 0) {
            cacheModel.backGoodsAndPayments();
        }
        String calcMode = paramsObject.getString("calcMode");
        if ("2".equals(cacheModel.getOrder().getOrderType())) {
            calcMode = "-1";
        }
        if (calcMode.equals("0")) {
            CalSaleReturnIn calSaleReturnIn = new CalSaleReturnIn(cacheModel);
            cacheModel.callMarketClear();
            ServiceResponse sr = this.promotionCentreService.calSaleReturn(this.restTemplate, session, calSaleReturnIn);
            if (!sr.getReturncode().equals("0")) {
                return sr;
            }
            CalSaleReturnOut calSaleReturnOut = (CalSaleReturnOut)sr.getData();
            if ((cacheModel = this.posLogicServiceImpl.CalcOrderAfterCheckReturnMode0(cacheModel, calSaleReturnOut, paramsObject.getString("notYpopPayCodes"), session)).getCalcResult() == -1) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba1\u7b97\u9519\u8bef\u63d0\u793a[{0}]", (Object[])new Object[]{cacheModel.getErrMsg()});
            }
            cacheModel.getOrder().setSeqNo(calSaleReturnOut.getCalcBilid());
        }
        if (!"99".equals(calcMode) && cacheModel.getRefundGiftList().size() <= 0) {
            calcMode = "1";
        }
        if (calcMode.equals("1")) {
            if ((cacheModel = this.posLogicServiceImpl.CalcOrderAfterCheckReturnMode1(cacheModel, salesReturnIn.getGiftList(), paramsObject.getString("autoBackPayCode"), paramsObject.getString("giftMode"), session)).getCalcResult() == -1) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba1\u7b97\u9519\u8bef\u63d0\u793a[{0}]", (Object[])new Object[]{cacheModel.getErrMsg()});
            }
            if (null == cacheModel.getDeductedCoupons() || cacheModel.getDeductedCoupons().size() == 0) {
                calcMode = "2";
            }
        }
        if (!"2".equals(cacheModel.getOrder().getOrderType())) {
            double returnPoint = 0.0;
            List<Goods> goodsList = cacheModel.getGoodsList();
            if (null != goodsList && goodsList.size() > 0) {
                for (int i = 0; i < goodsList.size(); ++i) {
                    Goods goods = goodsList.get(i);
                    List<CouponGain> couponGains = goods.getCouponGains();
                    if (null == couponGains || couponGains.size() <= 0) continue;
                    for (int j = 0; j < couponGains.size(); ++j) {
                        CouponGain couponGain = couponGains.get(j);
                        if (!"01".equals(couponGain.getCouponGroup())) continue;
                        returnPoint = ManipulatePrecision.add(returnPoint, couponGain.getAmount());
                    }
                }
            }
            cacheModel.getOrder().setThisTimePoint(ManipulatePrecision.getDetailOverFlow(returnPoint, "4"));
        }
        if ("0".equals((cacheModel = this.posLogicCompoment.calcPayBalance(cacheModel)).getOrder().getSysPara().getOverageMode()) && ManipulatePrecision.doubleCompare(cacheModel.getOrder().getRoundUpOverageValue(), 0.0, 2) > 0) {
            cacheModel = this.addOveragePopDetail(session, cacheModel, false);
        }
        this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
        SaleReturnOut out = new SaleReturnOut(cacheModel);
        if ("99".equals(calcMode)) {
            out.setResultMode("99");
        } else if ("-1".equals(calcMode)) {
            cacheModel.getOrder().setAllowEditGoods(false);
        } else {
            if (out.getGifts() != null && out.getGifts().size() > 0) {
                out.setResultMode("1");
            }
            if (out.getCoupons() != null && out.getCoupons().size() > 0 && !out.getResultMode().equals("1")) {
                out.setResultMode("2");
            }
            if ("0".equals(out.getResultMode())) {
                cacheModel.getOrder().setAllowEditGoods(false);
            }
        }
        return ServiceResponse.buildSuccess((Object)out);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ServiceResponse getFlowNo(ServiceSession session, JSONObject paramsObject) {
        try {
            void var29_36;
            GetFlowNoIn in = (GetFlowNoIn)JSON.parseObject((String)paramsObject.toJSONString(), GetFlowNoIn.class);
            try {
                ValidateUtils.checkFieldNotNull(in);
            }
            catch (Exception e) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u521d\u59cb\u5316\u5931\u8d25\u539f\u56e0[{0}]", (Object[])new Object[]{e.getMessage()});
            }
            String terminalNo = in.getTerminalNo();
            String terminalSno = in.getTerminalSno();
            String shopCode = in.getShopCode();
            String flowNo = UUIDUtils.buildFlowNo(String.valueOf(in.getEntId()), shopCode, terminalNo);
            HttpUtils.postThreadLocal.set(flowNo);
            String orgId = this.getOrgid(session, in.getErpCode(), shopCode);
            if (StringUtils.isEmpty((String)orgId)) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4ece\u4e3b\u6570\u636e\u83b7\u53d6\u6cd5\u4eba\u516c\u53f8\u4ee3\u7801\u5931\u8d25");
            }
            Order order = new Order();
            order.setOrgId(orgId);
            order.setConsumersData(new ConsumersData());
            order.setScheduleCode(in.getScheduleCode());
            order.setFlowNo(flowNo);
            order.setYpopBillNo(flowNo);
            order.setTerminalOperator(in.getTerminalOperator());
            order.setTerminalNo(terminalNo);
            order.setShopCode(shopCode);
            order.setTerminalSno(terminalSno);
            order.setSaleDate(in.getSaleDate());
            order.setSaleExtractTime(in.getSaleDate());
            order.setScanGoodOperator(in.getScanGoodOperator());
            order.setOrderType(in.getOrderType());
            order.setChannel(in.getChannel());
            order.setShopId(in.getShopId());
            order.setShopName(in.getShopName());
            order.setErpCode(in.getErpCode());
            order.setLanguage(in.getLanguage());
            order.setEntId(in.getEntId());
            order.setPrecisionMode(in.getPrecisionMode());
            order.setPosType(in.getPosType());
            order.setDeleteNum(0);
            order.setExerciseMode(in.getExerciseMode());
            order.setPopmode(1);
            if (in.getPopMode() != 1) {
                order.setPopmode(in.getPopMode());
            }
            if ("H1".equals(order.getOrderType())) {
                order.setPopmode(0);
            }
            if (null == in.getStallCode()) {
                order.setStallCode("");
            } else {
                order.setStallCode(in.getStallCode());
            }
            if (SellType.ISBACK(order.getOrderType()) && null != in.getReason()) {
                order.setReason(in.getReason());
            }
            SearchMealDetailOut mealDetail = new SearchMealDetailOut();
            ArrayList<GiftsGroup> giftsGroup = new ArrayList<GiftsGroup>();
            ArrayList<Goods> choiceGiftsHavePrice = new ArrayList<Goods>();
            ArrayList<Goods> choiceGiftsHaveNoPrice = new ArrayList<Goods>();
            CacheModel cacheModel = new CacheModel();
            cacheModel.setFlowNo(flowNo);
            cacheModel.setOrder(order);
            cacheModel.setMealDetail(mealDetail);
            cacheModel.setGiftsGroup(giftsGroup);
            cacheModel.setChoiceGiftsHaveNoPrice(choiceGiftsHaveNoPrice);
            cacheModel.setChoiceGiftsHavePrice(choiceGiftsHavePrice);
            cacheModel.setErrCode("");
            cacheModel.setMaxSaleGoodsQuantity(in.getMaxSaleGoodsQuantity());
            cacheModel.setMaxSaleGoodsMoney(in.getMaxSaleGoodsMoney());
            cacheModel.setMaxSaleMoney(in.getMaxSaleMoney());
            SysParaInfo sysPara = this.initSysParaInfo(session, in.getErpCode(), in.getShopCode());
            order.setSysPara(sysPara);
            if (StringUtils.isBlank((String)sysPara.getBasePaymentCode())) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u521d\u59cb\u5316\u5931\u8d25\u539f\u56e0[{0}]", (Object[])new Object[]{"\u83b7\u53d6\u9884\u8bbe\u652f\u4ed8\u65b9\u5f0f\u5931\u8d25,\u603b\u90e8\u8fd4\u56de\u4e3a\u7a7a"});
            }
            if (sysPara.getMaxChangeValue() < 0.0) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u521d\u59cb\u5316\u5931\u8d25\u539f\u56e0[{0}]", (Object[])new Object[]{"\u83b7\u53d6\u6700\u5927\u627e\u96f6\u91d1\u989d\u5931\u8d25,\u603b\u90e8\u8fd4\u56de\u4e3a\u7a7a"});
            }
            String payCode = sysPara.getBasePaymentCode();
            PaySerchIn paySerchIn = new PaySerchIn();
            String[] payCodes = payCode.split(",");
            payCode = payCodes[0];
            paySerchIn.setPayCode(payCode);
            paySerchIn.setErpCode(in.getErpCode());
            ServiceResponse response = this.mainDataCentreService.paySerch(this.restTemplate, session, paySerchIn);
            if (!"0".equals(response.getReturncode())) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u521d\u59cb\u5316\u5931\u8d25\u539f\u56e0[{0}]", (Object[])new Object[]{response.getData()});
            }
            PaySerchOut paySerchOut = (PaySerchOut)response.getData();
            if (paySerchOut == null || paySerchOut.getPaymentMethod() == null || paySerchOut.getPaymentMethod().size() < 1) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u521d\u59cb\u5316\u5931\u8d25\u539f\u56e0[{0}]", (Object[])new Object[]{"\u83b7\u53d6\u9ed8\u8ba4\u652f\u4ed8\u65b9\u5f0f\u5931\u8d25\uff0c\u4e3b\u6570\u636e\u8fd4\u56de\u4e3a\u7a7a"});
            }
            PayMode payMode = paySerchOut.getPaymentMethod().get(0);
            cacheModel.setPayMode(payMode);
            QueryTerminalInfoIn querySyjIn = new QueryTerminalInfoIn();
            querySyjIn.setErpCode(in.getErpCode());
            querySyjIn.setMkt(in.getShopCode());
            querySyjIn.setSyjh(in.getTerminalNo());
            try {
                response = this.posManagerService.getTerminalInfo(this.restTemplate, session, querySyjIn);
                if (!"0".equals(response.getReturncode())) return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u521d\u59cb\u5316\u5931\u8d25\u539f\u56e0[{0}]", (Object[])new Object[]{"\u83b7\u53d6\u6b3e\u673a\u5c5e\u6027\u5931\u8d25\uff0cPOS\u603b\u90e8\u8fd4\u56de\u4e3a\u7a7a"});
                QueryTerminalInfoOut syjData = (QueryTerminalInfoOut)response.getData();
                if (null != syjData) {
                    cacheModel.setSyjgroup(syjData.getSyjgroup());
                    cacheModel.setSyjmain(syjData.getSyjmain());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                StringWriter stringWriter = new StringWriter();
                e.printStackTrace(new PrintWriter(stringWriter));
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u521d\u59cb\u5316\u5931\u8d25\u539f\u56e0[{0}]", (Object[])new Object[]{"\u83b7\u53d6\u6b3e\u673a\u5c5e\u6027\u5f02\u5e38"});
            }
            String cardnoString = in.getTerminalOperator();
            String grantFlag = "N";
            if (null != in.getAccreditNo() && in.getAccreditNo().length() > 0 && !in.getAccreditNo().equals(in.getTerminalOperator())) {
                cardnoString = in.getAccreditNo();
                grantFlag = "Y";
            }
            OperUserIn posManagerOperUserIn = new OperUserIn();
            posManagerOperUserIn.setErpCode(in.getErpCode());
            posManagerOperUserIn.setCardno(cardnoString);
            posManagerOperUserIn.setMkt(in.getShopCode());
            posManagerOperUserIn.setFlag(grantFlag);
            posManagerOperUserIn.setSyjh(in.getTerminalNo());
            OperUser op1 = new OperUser();
            cacheModel.setCurGrant(op1);
            cacheModel.setCurYyyInfo(new OperUser());
            response = this.posManagerService.getOperUser(this.restTemplate, session, posManagerOperUserIn);
            if (!"0".equals(response.getReturncode())) return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5f53\u524d\u6536\u94f6\u5458\u6216\u6388\u6743\u4eba\u5458\u4fe1\u606f\u65e0\u6cd5\u627e\u5230");
            OperUserOut posManagerOperUserOut = (OperUserOut)response.getData();
            if (posManagerOperUserOut.getOperuser() == null || posManagerOperUserOut.getPosrole() == null) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5f53\u524d\u6536\u94f6\u5458\u6216\u6388\u6743\u4eba\u5458\u4fe1\u606f\u4e0d\u5b8c\u6574");
            }
            OperUser operUser = new OperUser(posManagerOperUserOut);
            cacheModel.setCurSyyInfo(operUser);
            if (SellType.ISBACK(order.getOrderType())) {
                if (!posManagerOperUserOut.getPosrole().getPrivth().equals("Y") && !posManagerOperUserOut.getPosrole().getPrivth().equals("T")) {
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5f53\u524d\u6536\u94f6\u5458\u6216\u6388\u6743\u4eba\u5458\u6ca1\u6709\u9000\u8d27\u6743\u9650");
                }
                order.setRefundAuthzCardNo(operUser.getGh());
            }
            if (!SellType.ISBACK(order.getOrderType()) && StringUtils.isNotBlank((String)in.getScanGoodOperator())) {
                posManagerOperUserIn.setCardno(in.getScanGoodOperator());
                response = this.posManagerService.getOperUser(this.restTemplate, session, posManagerOperUserIn);
                if (!"0".equals(response.getReturncode())) return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5f53\u524d\u626b\u63cf\u5458\u4fe1\u606f\u65e0\u6cd5\u627e\u5230");
                posManagerOperUserOut = (OperUserOut)response.getData();
                if (posManagerOperUserOut.getOperuser() == null || posManagerOperUserOut.getPosrole() == null) {
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5f53\u524d\u6536\u94f6\u5458\u6216\u6388\u6743\u4eba\u5458\u4fe1\u606f\u4e0d\u5b8c\u6574");
                }
                operUser = new OperUser(posManagerOperUserOut);
                OperUser operUser2 = (OperUser)operUser.clone();
                cacheModel.setCurSmyInfo(operUser2);
                cacheModel.setCurGrant(operUser);
            } else {
                cacheModel.setCurGrant(cacheModel.getCurSyyInfo());
            }
            order.setGh(cacheModel.getCurGrant().getGh());
            ElecScaleCodeRuleIn elecScaleCodeRuleIn = new ElecScaleCodeRuleIn();
            elecScaleCodeRuleIn.setErpCode(in.getErpCode());
            elecScaleCodeRuleIn.setMkt(shopCode);
            ServiceResponse respElec = this.posManagerService.getElecCode(this.restTemplate, session, elecScaleCodeRuleIn);
            ArrayList arrayList = new ArrayList();
            String codeRule = "0";
            if ("0".equals(respElec.getReturncode())) {
                ElecScaleCodeRuleOut elecCodeRuleOut = (ElecScaleCodeRuleOut)respElec.getData();
                List<ElecScaleCodeRule> list = elecCodeRuleOut.getElecscalecoderule();
                if (null != elecCodeRuleOut.getCodeRule() && elecCodeRuleOut.getCodeRule().length() > 0) {
                    codeRule = elecCodeRuleOut.getCodeRule();
                }
            }
            cacheModel.setEleCodeRule((List<ElecScaleCodeRule>)var29_36);
            cacheModel.setEleCodeMode(codeRule);
            if ("1".equals(cacheModel.getEleCodeMode())) {
                cacheModel.getOrder().getSysPara().setBarCodeMode(1);
            }
            if ("2".equals(cacheModel.getEleCodeMode())) {
                cacheModel.getOrder().getSysPara().setBarCodeMode(3);
            }
            cacheModel.setPopMode(1);
            cacheModel.getOrder().setLogisticsMode(7);
            if (in.getPopMode() != 1) {
                cacheModel.setPopMode(in.getPopMode());
            }
            this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
            GetFlowNoOut out = new GetFlowNoOut();
            out.setTerminalSno(terminalSno);
            out.setFlowNo(flowNo);
            out.setTimestamp(this.timestamp);
            return ServiceResponse.buildSuccess((Object)out);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u521d\u59cb\u5316\u6d41\u6c34\u53f7\u5931\u8d25");
        }
    }

    public ServiceResponse disc(ServiceSession session, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        Double discountRate = paramsObject.getDouble("discountRate");
        if (discountRate == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u6574\u5355\u6298\u6263\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u6298\u6263\u7387\u4e0d\u80fd\u4e3a\u7a7a"});
        }
        String accreditNo = paramsObject.getString("accreditNo");
        String flowNo = paramsObject.getString("flowNo");
        if (flowNo == null || flowNo.isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5355\u884c\u6298\u6263\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"flowNo\u4e0d\u80fd\u4e3a\u7a7a"});
        }
        CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(flowNo);
        if (cacheModel == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355", (Object[])new Object[]{flowNo});
        }
        if ("Y12".equals(cacheModel.getOrder().getOrderType())) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u4e3a\u5370\u82b1\u6362\u8d2d\u8ba2\u5355\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u4ef7\u683c", (Object[])new Object[]{flowNo});
        }
        if (!cacheModel.getOrder().getAllowEditGoods()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u8fdb\u5165\u652f\u4ed8\u73af\u8282\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u5546\u54c1", (Object[])new Object[]{flowNo});
        }
        if (StringUtils.isBlank((String)accreditNo)) {
            accreditNo = cacheModel.getCurGrant().getGh();
        }
        if (cacheModel.getCurGrant().getPrivzpzkl() < 0.0) {
            if (null != cacheModel.getCurTempGrant() && StringUtils.isNotEmpty((String)cacheModel.getCurTempGrant().getGh())) {
                this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
            }
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"1000", (String)"\u5f53\u524d\u6388\u6743\u4eba\u5458\u4e0d\u5141\u8bb8\u6574\u5355\u6253\u6298");
        }
        double oldAmount = cacheModel.getOrder().getOughtPay();
        double tempZzr = cacheModel.getOrder().getTempZzr();
        if (-1 == (cacheModel = this.posLogicServiceImpl.CalcOrderRebateByRateBeforeOrder(cacheModel, accreditNo, discountRate)).getCalcResult()) {
            String errCode = "100000";
            String errMsg = cacheModel.getErrMsg();
            if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                errCode = cacheModel.getErrCode();
                if ("1000".equals(cacheModel.getErrCode()) && null != cacheModel.getCurTempGrant() && StringUtils.isNotEmpty((String)cacheModel.getCurTempGrant().getGh())) {
                    cacheModel = this.cacheModelService.getCacheModelByFlowNo(flowNo);
                    this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
                }
            }
            return ServiceResponse.buildFailure((ServiceSession)session, (String)errCode, (String)errMsg);
        }
        if (cacheModel == null || cacheModel.getGoodsList() == null || cacheModel.getOrder() == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u6574\u5355\u6298\u6263\u8c03\u7528\u8ba1\u7b97\u65b9\u6cd5,\u6ca1\u6709\u83b7\u5f97\u6709\u6548CacheModel");
        }
        if (tempZzr != 0.0) {
            cacheModel = this.posLogicCompoment.CalcOrderRebateByAmount(cacheModel, cacheModel.getCurGrant().getGh(), tempZzr);
        }
        this.posLogicCompoment.calcOrderAmount(cacheModel);
        this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
        double newAmount = cacheModel.getOrder().getOughtPay();
        this.asyncTask.sendOrderDiscWorkLog(session, cacheModel.getOrder(), WorkLogType.disc, ManipulatePrecision.doubleConvert(oldAmount - newAmount));
        BaseOutModel out = new BaseOutModel();
        out.setOrder(OrderForPos.toOrderForPosSingle(cacheModel));
        return ServiceResponse.buildSuccess((Object)out);
    }

    public ServiceResponse discAmount(ServiceSession session, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        Double discountAmount = paramsObject.getDouble("discountAmount");
        if (discountAmount == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u6574\u5355\u6298\u8ba9\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u6298\u8ba9\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a"});
        }
        String accreditNo = paramsObject.getString("accreditNo");
        String flowNo = paramsObject.getString("flowNo");
        int mode = 0;
        if (StringUtils.isNotBlank((String)paramsObject.getString("mode"))) {
            mode = CastUtil.castInt(paramsObject.getInteger("mode"));
        }
        if (flowNo == null || flowNo.isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5355\u884c\u6298\u6263\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"flowNo\u4e0d\u80fd\u4e3a\u7a7a"});
        }
        CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(flowNo);
        if (cacheModel == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355", (Object[])new Object[]{flowNo});
        }
        if ("Y12".equals(cacheModel.getOrder().getOrderType())) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u4e3a\u5370\u82b1\u6362\u8d2d\u8ba2\u5355\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u4ef7\u683c", (Object[])new Object[]{flowNo});
        }
        if (!cacheModel.getOrder().getAllowEditGoods()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u8fdb\u5165\u652f\u4ed8\u73af\u8282\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u5546\u54c1", (Object[])new Object[]{flowNo});
        }
        if (-1 == cacheModel.getCalcResult()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"calcResult\u4e3a-1\u65f6\u4e0d\u80fd\u4fee\u6539\u5546\u54c1");
        }
        if (StringUtils.isBlank((String)accreditNo)) {
            accreditNo = cacheModel.getCurGrant().getGh();
        }
        if (cacheModel.getCurGrant().getPrivzpzkl() < 0.0) {
            if (null != cacheModel.getCurTempGrant() && StringUtils.isNotEmpty((String)cacheModel.getCurTempGrant().getGh())) {
                this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
            }
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"1000", (String)"\u5f53\u524d\u6388\u6743\u4eba\u5458\u4e0d\u5141\u8bb8\u6574\u5355\u6253\u6298");
        }
        double oldAmount = cacheModel.getOrder().getOughtPay();
        if (-1 == (cacheModel = this.posLogicServiceImpl.CalcOrderRebateByAmountBeforeOrder(cacheModel, accreditNo, discountAmount, mode)).getCalcResult()) {
            String errCode = "100000";
            String errMsg = cacheModel.getErrMsg();
            if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                errCode = cacheModel.getErrCode();
                if ("1000".equals(cacheModel.getErrCode()) && null != cacheModel.getCurTempGrant() && StringUtils.isNotEmpty((String)cacheModel.getCurTempGrant().getGh())) {
                    cacheModel = this.cacheModelService.getCacheModelByFlowNo(flowNo);
                    this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
                }
            }
            return ServiceResponse.buildFailure((ServiceSession)session, (String)errCode, (String)errMsg);
        }
        if (cacheModel == null || cacheModel.getGoodsList() == null || cacheModel.getOrder() == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u6574\u5355\u6298\u8ba9\u8c03\u7528\u8ba1\u7b97\u65b9\u6cd5,\u6ca1\u6709\u83b7\u5f97\u6709\u6548CacheModel");
        }
        this.posLogicCompoment.calcOrderAmount(cacheModel);
        this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
        double newAmount = cacheModel.getOrder().getOughtPay();
        this.asyncTask.sendOrderDiscWorkLog(session, cacheModel.getOrder(), WorkLogType.discAmount, ManipulatePrecision.doubleConvert(oldAmount - newAmount));
        BaseOutModel out = new BaseOutModel();
        out.setOrder(OrderForPos.toOrderForPosSingle(cacheModel));
        return ServiceResponse.buildSuccess((Object)out);
    }

    public ServiceResponse cancelOrder(ServiceSession session, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        if (StringUtils.isBlank((String)paramsObject.getString("flag"))) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u53d6\u6d88\u6574\u5355\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u6807\u5fd7\uff08\u9ed8\u8ba4\u4e3a0\uff09\u4e0d\u80fd\u4e3a\u7a7a"});
        }
        CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(paramsObject.getString("flowNo"));
        if (null == cacheModel) {
            BaseOutModel out = new BaseOutModel();
            return ServiceResponse.buildSuccess((Object)out);
        }
        if (!cacheModel.getOrder().getAllowEditGoods()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u8fdb\u5165\u652f\u4ed8\u73af\u8282\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u8ba2\u5355", (Object[])new Object[]{paramsObject.getString("flowNo")});
        }
        if (cacheModel.getOrder().getSendSuccess()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u63d0\u4ea4\u6210\u529f\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u4ed8\u6b3e\u4fe1\u606f", (Object[])new Object[]{paramsObject.getString("flowNo")});
        }
        if (null == cacheModel.getCurGrant().getPrivqx() || !"Y".equals(cacheModel.getCurGrant().getPrivqx())) {
            if (null != cacheModel.getCurTempGrant() && StringUtils.isNotEmpty((String)cacheModel.getCurTempGrant().getGh())) {
                this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
            }
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"1000", (String)"\u5f53\u524d\u4eba\u5458\u6ca1\u6709\u53d6\u6d88\u8ba2\u5355\u6743\u9650");
        }
        cacheModel.getOrder().setTerminalOperatorAuthzCardNo(cacheModel.getCurGrant().getGh());
        OrderForPos ofp = OrderForPos.toOrderForPosSingle(cacheModel);
        if (cacheModel != null) {
            try {
                if (null != cacheModel.getOrder() && "Y12".equals(cacheModel.getOrder().getOrderType()) && cacheModel.getGoodsList().size() > 0) {
                    double eleStamp = 0.0;
                    for (Goods g : cacheModel.getGoodsList()) {
                        eleStamp += g.getElectronicStamp();
                    }
                    if (eleStamp > 0.0 && !this.sendEleStamp(session, (int)eleStamp, cacheModel, "V", null, null)) {
                        return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u6263\u51cf\u7535\u5b50\u5370\u82b1\u5931\u8d25");
                    }
                }
                List<Payment> payments = cacheModel.getPayments();
                for (int i = 0; i < payments.size(); ++i) {
                    Payment payment = payments.get(i);
                    if (!"0706".equals(payment.getPayCode())) continue;
                    YWMemberConsumeReverseIn consumeReverseIn = this.posLogicCompoment.buildYWMemberConsumeReverseIn(cacheModel, payment);
                    String sign = this.posLogicCompoment.signYWMemberConsumeReverse(cacheModel, payment, consumeReverseIn);
                    consumeReverseIn.setSign(sign);
                    ServiceResponse response = this.chinaYWService.pointConsume(this.restTemplate, session, consumeReverseIn);
                    if ("0".equals(response.getReturncode())) {
                        YWMemberOut res = (YWMemberOut)response.getData();
                        if (200 == res.getCode()) continue;
                        this.pointConsumeReverseService.save(session, (JSONObject)JSONObject.toJSON((Object)consumeReverseIn));
                        continue;
                    }
                    this.pointConsumeReverseService.save(session, (JSONObject)JSONObject.toJSON((Object)consumeReverseIn));
                }
                if (StringUtils.isNotBlank((String)cacheModel.getOrder().getInvoiceTitle())) {
                    this.updateQuota(session, cacheModel, -1);
                }
                this.asyncTask.sendCancelOrderLog(session, cacheModel.getOrder(), cacheModel.getGoodsList(), WorkLogType.delOrder, "");
                this.cacheModelService.deleteCacheModel(paramsObject.getString("flowNo"));
                if ("0".equals(this.routeMode)) {
                    ReadOrWriterUtil.delete(paramsObject.getString("flowNo"));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                LOGGER.info(e.getMessage());
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)("\u53d6\u6d88\u6574\u5355\u5931\u8d25" + e.getMessage()));
            }
        }
        BaseOutModel out = new BaseOutModel();
        out.setOrder(ofp);
        return ServiceResponse.buildSuccess((Object)out);
    }

    @Override
    public ServiceResponse getOrder(ServiceSession session, JSONObject paramsObject) {
        try {
            ServiceResponse validateData = this.getOrderValidate(session, paramsObject);
            if (!"0".equals(validateData.getReturncode())) {
                return validateData;
            }
            GetOrderIn getOrderIn = (GetOrderIn)JSONObject.toJavaObject((JSON)paramsObject, GetOrderIn.class);
            OrderQueryIn in = new OrderQueryIn();
            in.setBusiTakeMarketCode(getOrderIn.getShopCode());
            in.setTerminalNo(getOrderIn.getTerminalNo());
            in.setTerminalSno(getOrderIn.getTerminalSno());
            in.setCreateDate(getOrderIn.getBillDate());
            in.setSearchType(getOrderIn.getSearchType());
            in.setErpCode(getOrderIn.getErpCode());
            ServiceResponse resp = this.orderCentreSerivce.getOrderAll(this.restTemplate, session, in);
            if (!"0".equals(resp.getReturncode())) {
                if ("60003".equals(resp.getReturncode())) {
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)("\u8bf7\u6c42\u8ba2\u5355\u4e2d\u5fc3\u83b7\u53d6\u8ba2\u5355\u5931\u8d25:" + resp.getData()));
                }
                LOGGER.info("\u8bf7\u6c42\u8ba2\u5355\u4e2d\u5fc3\u83b7\u53d6\u8ba2\u5355\u5931\u8d25:" + resp.getData());
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5355\u636e\u7f16\u53f7\u4e0d\u6b63\u786e\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u5355\u636e\u7f16\u53f7\uff08 \u95e8\u5e97\u53f7+\u673a\u53f0\u53f7+\u5c0f\u7968\u53f7\uff09");
            }
            GetOrdersDetailOut getOrdersDetailOut = (GetOrdersDetailOut)resp.getData();
            SaleOrders saleOrder = new SaleOrders();
            SaleOrders oriOrder = null;
            if (in.getSearchType() == 3) {
                oriOrder = getOrdersDetailOut.getOriginInfo();
                saleOrder = getOrdersDetailOut.getOrderInfo();
            } else {
                saleOrder = in.getSearchType() == 4 ? getOrdersDetailOut.getOriginInfo() : getOrdersDetailOut.getOrderInfo();
            }
            if (saleOrder.getOrders() == null) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u67e5\u8be2\u8ba2\u5355\u5931\u8d25");
            }
            ArrayList<String> codes = new ArrayList<String>();
            codes.add("CWYH");
            codes.add("PRTSEQ");
            codes.add("POPPRTMODE");
            List<SysPara> sysParaList = this.getSyspara(session, codes, getOrderIn.getErpCode(), getOrderIn.getShopCode());
            SysParaInfo sysPara = this.initSysParaInfo(sysParaList);
            PayConfirmOut orderInfo = this.toPayConfirmOut(session, saleOrder, oriOrder, sysPara.getCalcPriceType(), sysPara.getPopPrtSeq(), sysPara.getPopPrtMode());
            return ServiceResponse.buildSuccess((Object)orderInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)e.getMessage());
        }
    }

    public ServiceResponse recordPrintLog(ServiceSession session, JSONObject paramsObject) {
        try {
            RecordPrintLogIn in = (RecordPrintLogIn)JSONObject.toJavaObject((JSON)paramsObject, RecordPrintLogIn.class);
            PrintLogIn appLogIn = new PrintLogIn();
            appLogIn.setMarketCode(in.getShopCode());
            appLogIn.setTerminalNo(in.getTerminalNo());
            appLogIn.setTerminalOperator(in.getTerminalOperator());
            appLogIn.setOriginMarketCode(in.getPShopCode());
            appLogIn.setOriginTerminalNo(in.getPTerminalNo());
            appLogIn.setOriginTerminalSno(in.getPTerminalSno());
            ServiceResponse resp = this.orderCentreSerivce.orderPrintLog(this.restTemplate, session, appLogIn);
            String opgId = "";
            if (!"0".equals(resp.getReturncode()) && !"1".equals(resp.getReturncode())) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)("\u8bf7\u6c42\u8ba2\u5355\u4e2d\u5fc3\u8bb0\u5f55\u91cd\u5370\u65e5\u5fd7\u5931\u8d25:" + resp.getData()));
            }
            opgId = resp.getData().toString();
            this.excuteZuul(resp.getReturncode(), opgId, "2");
            String back = "success";
            return ServiceResponse.buildSuccess((Object)back);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)e.getMessage());
        }
    }

    private ServiceResponse getOrderValidate(ServiceSession session, JSONObject paramsObject) {
        if (StringUtils.isBlank((String)paramsObject.getString("terminalOperator"))) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u64cd\u4f5c\u5458\u53f7"});
        }
        boolean flag = false;
        if (StringUtils.isNotBlank((String)paramsObject.getString("sheetNo"))) {
            flag = true;
        } else if (StringUtils.isNotBlank((String)paramsObject.getString("shopCode")) && StringUtils.isNotBlank((String)paramsObject.getString("terminalNo")) && StringUtils.isNotBlank((String)paramsObject.getString("terminalSno"))) {
            flag = true;
        }
        if (!flag) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u590d\u5236\u5c0f\u7968\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u8ba2\u5355\u4e2d\u5fc3\u8ba2\u5355\u53f7\u6216\u8005\u5c0f\u7968\u53f7\u3001\u95e8\u5e97\u53f7\u3001\u7ec8\u7aef\u53f7"});
        }
        return ServiceResponse.buildSuccess((Object)"success");
    }

    public ServiceResponse saleReturnQuery(ServiceSession session, JSONObject paramsObject) {
        try {
            ServiceResponse resp;
            ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
            if (!paramsValidateUtils.validate()) {
                return paramsValidateUtils.getServiceResponse();
            }
            SaleReturnQueryIn saleReturnQueryIn = (SaleReturnQueryIn)JSON.parseObject((String)paramsObject.toJSONString(), SaleReturnQueryIn.class);
            CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(saleReturnQueryIn.getFlowNo());
            if (null == cacheModel) {
                ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"POS\u670d\u52a1\u7f13\u5b58\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u521d\u59cb\u5316\u8ba2\u5355");
            }
            Order order = cacheModel.getOrder();
            OrderQueryIn orderQueryIn = new OrderQueryIn();
            orderQueryIn.setTerminalNo(saleReturnQueryIn.getOldTerminalNo());
            orderQueryIn.setTerminalSno(saleReturnQueryIn.getOldTerminalSno());
            orderQueryIn.setBusiTakeMarketCode(saleReturnQueryIn.getOldShopCode());
            orderQueryIn.setCreateDate(saleReturnQueryIn.getBillDate());
            if (!SellType.ISBACK(cacheModel.getOrder().getOrderType())) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5f53\u524d\u8ba2\u5355\u7c7b\u578b\u4e0d\u6b63\u786e\uff0c\u8bf7\u91cd\u65b0\u9000\u8d27");
            }
            if ("2".equals(cacheModel.getOrder().getOrderType())) {
                orderQueryIn.setSearchType(1);
            } else {
                orderQueryIn.setSearchType(2);
            }
            if (StringUtils.isBlank((String)cacheModel.getOrder().getRefundAuthzCardNo())) {
                String cardnoString = saleReturnQueryIn.getTerminalOperator();
                if (StringUtils.isNotBlank((String)saleReturnQueryIn.getAccreditNo())) {
                    cardnoString = saleReturnQueryIn.getAccreditNo();
                }
                OperUserIn posManagerOperUserIn = new OperUserIn();
                posManagerOperUserIn.setCardno(cardnoString);
                posManagerOperUserIn.setMkt(saleReturnQueryIn.getShopCode());
                posManagerOperUserIn.setErpCode(cacheModel.getOrder().getErpCode());
                posManagerOperUserIn.setFlag("N");
                posManagerOperUserIn.setSyjh(saleReturnQueryIn.getTerminalNo());
                OperUser op1 = new OperUser();
                cacheModel.setCurGrant(op1);
                ServiceResponse response = this.posManagerService.getOperUser(this.restTemplate, session, posManagerOperUserIn);
                if ("0".equals(response.getReturncode())) {
                    OperUserOut posManagerOperUserOut = (OperUserOut)response.getData();
                    if (!posManagerOperUserOut.getPosrole().getPrivth().equals("Y") && !posManagerOperUserOut.getPosrole().getPrivth().equals("T")) {
                        return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5f53\u524d\u6536\u94f6\u5458\u6216\u6388\u6743\u4eba\u5458\u6ca1\u6709\u9000\u8d27\u6743\u9650");
                    }
                    OperUser operUser = new OperUser(posManagerOperUserOut);
                    cacheModel.setCurGrant(operUser);
                    order.setRefundAuthzCardNo(operUser.getGh());
                } else {
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5f53\u524d\u6536\u94f6\u5458\u6216\u6388\u6743\u4eba\u5458\u4fe1\u606f\u65e0\u6cd5\u627e\u5230");
                }
            }
            if (!(resp = this.orderCentreSerivce.getOrderAll(this.restTemplate, session, orderQueryIn)).getReturncode().equals("0")) {
                if ("60003".equals(resp.getReturncode())) {
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)("\u8bf7\u6c42\u8ba2\u5355\u4e2d\u5fc3\u83b7\u53d6\u8ba2\u5355\u5931\u8d25:" + resp.getData()));
                }
                LOGGER.info("\u8bf7\u6c42\u8ba2\u5355\u4e2d\u5fc3\u83b7\u53d6\u8ba2\u5355\u5931\u8d25:" + resp.getData());
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5355\u636e\u7f16\u53f7\u4e0d\u6b63\u786e\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u5355\u636e\u7f16\u53f7\uff08 \u95e8\u5e97\u53f7+\u673a\u53f0\u53f7+\u5c0f\u7968\u53f7\uff09");
            }
            GetOrdersDetailOut getOrdersDetailOut = (GetOrdersDetailOut)resp.getData();
            SaleOrders orderQueryOut = getOrdersDetailOut.getOrderInfo();
            if (null == orderQueryOut) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355\u4e2d\u5fc3\uff0c\u67e5\u8be2\u65e0\u6b64\u8ba2\u5355");
            }
            if (StringUtils.isNotBlank((String)cacheModel.getOrder().getSysPara().getNoRefundDate())) {
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
                    Date thDate = sdf.parse(cacheModel.getOrder().getSysPara().getNoRefundDate());
                    Date orderDate = orderQueryOut.getOrders().getSaleDate();
                    if (orderDate.before(thDate)) {
                        return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)(thDate + "\u524d\u7684\u4ea4\u6613\u53ea\u80fd\u8fdb\u884c\u65e0\u5355\u9000\u8d27"));
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            double allowReturnCopies = 0.0;
            for (OrdersDetailModel detail : orderQueryOut.getOrdersDetail()) {
                if ("0".equals(detail.getGoodsFlag())) continue;
                if (("2".equals(cacheModel.getOrder().getOrderType()) || "YK2".equals(cacheModel.getOrder().getOrderType()) || "SK2".equals(cacheModel.getOrder().getOrderType())) && ManipulatePrecision.doubleCompare(detail.getAllowReturnCopies(), detail.getQty(), 4) != 0) {
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8be5\u5355\u4e0d\u53ef\u6d88\u5355\uff0c\u8bf7\u9000\u8d27\u6216\u8054\u7cfb\u4e3b\u7ba1\u3002");
                }
                allowReturnCopies += detail.getAllowReturnCopies().doubleValue();
            }
            if (allowReturnCopies <= 0.0) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8be5\u8ba2\u5355\u65e0\u53ef\u9000\u5546\u54c1");
            }
            boolean isHc = false;
            if ("2".equals(cacheModel.getOrder().getOrderType()) || "YK2".equals(cacheModel.getOrder().getOrderType()) || "SK2".equals(cacheModel.getOrder().getOrderType())) {
                isHc = true;
            }
            String message = "\u9000\u8d27";
            if ("2".equals(cacheModel.getOrder().getOrderType())) {
                message = "\u6d88\u5355";
            }
            if (SellType.ISBACK(orderQueryOut.getOrders().getOrderType())) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)("\u9000\u8d27\u8ba2\u5355\u4e0d\u5141\u8bb8" + message));
            }
            if (!SellType.ISBACK(order.getOrderType())) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8bf7\u786e\u8ba4\u7aef\u7684\u64cd\u4f5c\u662f\u9000\u8d27\u8bf7\u6c42\uff01");
            }
            String authCardNo = cacheModel.getOrder().getTerminalOperatorAuthzCardNo();
            String thAuthCardNo = cacheModel.getOrder().getRefundAuthzCardNo();
            cacheModel = this.TransferCacheModelForReturn(orderQueryOut, saleReturnQueryIn, cacheModel, isHc);
            LocalDateTime dateTime = LocalDateTime.now();
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            String nowDateTime = dateTime.format(df).toString();
            cacheModel.getOrder().setSaleDate(nowDateTime);
            cacheModel.getOrder().setSaleExtractTime(nowDateTime);
            cacheModel.getOrder().setTerminalOperatorAuthzCardNo(authCardNo);
            cacheModel.getOrder().setRefundAuthzCardNo(thAuthCardNo);
            if (null != cacheModel.getOrder().getConsumersData() && StringUtils.isNotBlank((String)cacheModel.getOrder().getConsumersData().getConsumersId())) {
                JSONObject memberPointQueryin = new JSONObject();
                memberPointQueryin.put("shopCode", (Object)cacheModel.getOrder().getShopCode());
                memberPointQueryin.put("terminalNo", (Object)cacheModel.getOrder().getTerminalNo());
                memberPointQueryin.put("memberId", (Object)cacheModel.getOrder().getConsumersData().getConsumersId());
                memberPointQueryin.put("terminalOperator", (Object)cacheModel.getOrder().getTerminalOperator());
                memberPointQueryin.put("erpCode", (Object)cacheModel.getOrder().getErpCode());
                ServiceResponse res = this.yWMemberPointService.memberPointQuery(session, memberPointQueryin);
                if ("0".equals(res.getReturncode())) {
                    JSONObject data = JSONObject.parseObject((String)JSON.toJSONString((Object)res.getData()));
                    cacheModel.getOrder().setTotalPoint(data.getDoubleValue("lastConsumePoint"));
                    cacheModel.getOrder().getConsumersData().setPoint(data.getDoubleValue("lastConsumePoint"));
                    cacheModel.getOrder().setUnavailablePointDate(data.getString("unavailablePointDate"));
                    cacheModel.getOrder().setUnavailablePoint(data.getDoubleValue("unavailablePoint"));
                } else {
                    LOGGER.error("\u67e5\u8be2\u4f1a\u5458\u79ef\u5206\u5f02\u5e38:" + res.getData());
                }
            }
            this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
            BaseOutModel out = new BaseOutModel();
            out.setOrder(OrderForPos.toOrderForReturnQuery(cacheModel));
            return ServiceResponse.buildSuccess((Object)out);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ServiceResponse.buildFailure((ServiceSession)session, (String)e.getMessage());
        }
    }

    public ServiceResponse confirmSalesReturn(ServiceSession session, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        ConfirmSaleReturnIn confirmSalesReturnIn = (ConfirmSaleReturnIn)JSON.parseObject((String)paramsObject.toJSONString(), ConfirmSaleReturnIn.class);
        CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(confirmSalesReturnIn.getFlowNo());
        List<Goods> orderGoods = cacheModel.getReturnGoodsList();
        List<Goods> selectGoods = confirmSalesReturnIn.getGoodsList();
        ArrayList<Goods> returnGoods = new ArrayList<Goods>();
        int i = 0;
        if (cacheModel.getOrder().getOriginOrderState() == 7 && (cacheModel.getOrder().getOriginLogisticsState() == 16 || cacheModel.getOrder().getOriginLogisticsState() == 1) && orderGoods.size() != selectGoods.size()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5f53\u524d\u8ba2\u5355\u72b6\u6001\u53ea\u5141\u8bb8\u6574\u5355\u9000\u8d27");
        }
        double refundAmount = 0.0;
        block0: for (Goods goodsA : selectGoods) {
            for (Goods goodsB : orderGoods) {
                if (!goodsB.getGuid().equals(goodsA.getGuid())) continue;
                if (goodsB.getAllowReturnCopies() <= 0.0) {
                    ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5546\u54c1CODE-[{0}],\u53ef\u9000\u6570\u91cf[{2}]", (Object[])new Object[]{goodsB.getGoodsCode(), goodsB.getAllowReturnCopies()});
                }
                Goods goods = new Goods();
                String precisionMode = DataExchageUtils.exchangePrecisionMode(goodsB.getPrcutMode());
                goods = "2".equals(cacheModel.getOrder().getOrderType()) ? goodsB.deepClone() : goodsB.deepCloneWithOutPopInfo();
                String artCode = "";
                String serchType = "1";
                GetGoodsDetailIn getGoodsDetailIn = new GetGoodsDetailIn();
                getGoodsDetailIn.setEntId(cacheModel.getOrder().getEntId());
                getGoodsDetailIn.setShopCode(cacheModel.getOrder().getShopCode());
                getGoodsDetailIn.setTerminalNo(cacheModel.getOrder().getTerminalNo());
                getGoodsDetailIn.setCode(goods.getBarNo());
                getGoodsDetailIn.setSearchType(serchType);
                getGoodsDetailIn.setOrgCode(goods.getOrgCode());
                getGoodsDetailIn.setErpCode(cacheModel.getOrder().getErpCode());
                ServiceResponse resp = this.mainDataCentreService.getGoodsFromMDM(this.restTemplate, session, getGoodsDetailIn);
                if (!"0".equals(resp.getReturncode())) {
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"\u8bf7\u6c42\u4e3b\u6570\u636e\u4e2d\u5fc3\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5931\u8d25");
                }
                GetGoodsDetailOut goodsDetailOut = (GetGoodsDetailOut)resp.getData();
                if (goodsDetailOut.getGoods() != null && goodsDetailOut.getGoods().size() > 0) {
                    GoodsInfo goodsInfo = goodsDetailOut.getGoods().get(0);
                    artCode = goodsInfo.getArtCode();
                }
                goods.setArtCode(artCode);
                if (cacheModel.getOrder().getSysPara().getBarCodeMode() == 2) {
                    goods.setTempCategory(goods.getArtCode());
                } else {
                    goods.setTempCategory(goods.getCategory());
                }
                goods.setOriginalFlowId(goodsB.getFlowId());
                goods.setFlowId(++i);
                if (goodsA.getQty() != goods.getAllowReturnCopies() && cacheModel.getOrder().getOriginOrderState() == 7 && (cacheModel.getOrder().getOriginLogisticsState() == 16 || cacheModel.getOrder().getOriginLogisticsState() == 1) && orderGoods.size() != selectGoods.size()) {
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5f53\u524d\u8ba2\u5355\u72b6\u6001\u53ea\u5141\u8bb8\u6574\u5355\u9000\u8d27");
                }
                if (goodsA.getQty() > goods.getAllowReturnCopies()) {
                    ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5546\u54c1GUID-[{0}],\u9000\u8d27\u6570\u91cf[{1}]>\u53ef\u9000\u6570\u91cf[{2}]", (Object[])new Object[]{goods.getGuid(), goodsA.getQty(), goods.getAllowReturnCopies()});
                }
                if (goods.getQty() != goodsA.getQty()) {
                    goods.setSaleValue(ManipulatePrecision.getDetailOverFlow(ManipulatePrecision.mul(ManipulatePrecision.div(goods.getSaleValue(), goodsB.getQty()), goodsA.getQty()), precisionMode));
                    goods.setCouponValue(ManipulatePrecision.getDetailOverFlow(ManipulatePrecision.mul(ManipulatePrecision.div(goods.getCouponValue(), goodsB.getQty()), goodsA.getQty()), precisionMode));
                    goods.setPopDiscountValue(ManipulatePrecision.getDetailOverFlow(ManipulatePrecision.mul(ManipulatePrecision.div(goods.getPopDiscountValue(), goodsB.getQty()), goodsA.getQty()), precisionMode));
                    goods.setAdjustDiscountValue(ManipulatePrecision.getDetailOverFlow(ManipulatePrecision.mul(ManipulatePrecision.div(goods.getAdjustDiscountValue(), goodsB.getQty()), goodsA.getQty()), precisionMode));
                    goods.setCustomDiscountValue(ManipulatePrecision.getDetailOverFlow(ManipulatePrecision.mul(ManipulatePrecision.div(goods.getCustomDiscountValue(), goodsB.getQty()), goodsA.getQty()), precisionMode));
                    goods.setMealDiscountValue(ManipulatePrecision.getDetailOverFlow(ManipulatePrecision.mul(ManipulatePrecision.div(goods.getMealDiscountValue(), goodsB.getQty()), goodsA.getQty()), precisionMode));
                    goods.setFixedDiscountValue(ManipulatePrecision.getDetailOverFlow(ManipulatePrecision.mul(ManipulatePrecision.div(goods.getFixedDiscountValue(), goodsB.getQty()), goodsA.getQty()), precisionMode));
                    goods.setNoDisAmountValue(ManipulatePrecision.getDetailOverFlow(ManipulatePrecision.mul(ManipulatePrecision.div(goods.getNoDisAmountValue(), goodsB.getQty()), goodsA.getQty()), precisionMode));
                    goods.setTotalDiscountValue(PosLogicCompoment.getZZK(goods));
                    goods.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(goods.getTotalDiscountValue() - goods.getNoDisAmountValue()));
                }
                goods.setSaleAmount(ManipulatePrecision.getDetailOverFlow(goods.getSaleValue() - goods.getTotalDiscountValue(), precisionMode));
                goods.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(goods.getTotalDiscountValue() - goods.getNoDisAmountValue()));
                goods.setQty(goodsA.getQty());
                returnGoods.add(goods);
                refundAmount += goods.getSaleAmount();
                continue block0;
            }
        }
        if (refundAmount > cacheModel.getCurGrant().getPrivthje()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"1000", (String)"\u9000\u8d27\u91d1\u989d\u8d85\u51fa\u5f53\u524d\u6388\u6743\u4eba\u5458\u6743\u9650\u91d1\u989d\uff0c\u4e0d\u5141\u8bb8\u9000\u8d27");
        }
        cacheModel.setGoodsList(returnGoods);
        this.posLogicServiceImpl.calcOrderAmount(cacheModel);
        this.posLogicServiceImpl.calcPayBalance(cacheModel);
        cacheModel = this.posLogicCompoment.calcGoodsCount(cacheModel);
        if (cacheModel.getCalcResult() == -1) {
            ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"calcOrderAmount\u8ba1\u7b97\u9519\u8bef\u63d0\u793a[{0}]", (Object[])new Object[]{cacheModel.getErrMsg()});
        }
        this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
        BaseOutModel out = new BaseOutModel();
        out.setOrder(OrderForPos.toOrderForPos(cacheModel));
        return ServiceResponse.buildSuccess((Object)out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceResponse countAll(ServiceSession session, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        if (!paramsObject.containsKey((Object)"count") || paramsObject.getIntValue("count") == 0) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u6574\u5355\u8ba1\u7b97\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u5546\u54c1\u6761\u6570"});
        }
        if (!paramsObject.containsKey((Object)"qty") || paramsObject.getString("qty").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u6574\u5355\u8ba1\u7b97\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u8d2d\u4e70\u603b\u4ef6\u6570"});
        }
        if (!JsonUtils.checkJsonArray(paramsObject, "guidList", true, new String[0])) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u6574\u5355\u8ba1\u7b97\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u5546\u54c1\u552f\u4e00\u6807\u8bc6\u7b26\u5217\u8868"});
        }
        if (!JsonUtils.checkJsonArray(paramsObject, "limitedPayCodes", new String[0])) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u6574\u5355\u8ba1\u7b97\u6709\u9519\u8bef\u53c2\u6570[{0}]", (Object[])new Object[]{"\u53d7\u9650\u4ed8\u6b3e\u65b9\u5f0f\u4ee3\u7801\u6e05\u5355"});
        }
        if (!JsonUtils.checkJsonArray(paramsObject, "giftList", "guid", "qty")) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u6574\u5355\u8ba1\u7b97\u6709\u9519\u8bef\u53c2\u6570[{0}]", (Object[])new Object[]{"\u9009\u62e9\u7684\u8d60\u54c1\u5217\u8868"});
        }
        CountAllIn countAllIn = null;
        try {
            countAllIn = (CountAllIn)JSON.parseObject((String)paramsObject.toJSONString(), CountAllIn.class);
        }
        catch (Exception e) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u6574\u5355\u8ba1\u7b97\u5165\u53c2\u8f6c\u6362\u9519\u8bef[{0}]", (Object[])new Object[]{e.getMessage()});
        }
        CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(countAllIn.getFlowNo());
        if (cacheModel == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355", (Object[])new Object[]{countAllIn.getFlowNo()});
        }
        if (null == cacheModel.getGoodsList() || cacheModel.getGoodsList().size() == 0) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u6ca1\u6709\u5546\u54c1\uff0c\u8bf7\u6dfb\u52a0\u5546\u54c1\u540e\u8ba1\u7b97\u4f18\u60e0", (Object[])new Object[]{countAllIn.getFlowNo()});
        }
        cacheModel.getOrder().setAllowEditGoods(false);
        cacheModel = this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
        boolean isrestore = true;
        try {
            ServiceResponse response;
            String errCode;
            Payment p;
            ServiceResponse serviceResponse;
            ServiceResponse serviceResponse2;
            session.setEnt_id(cacheModel.getOrder().getEntId());
            if ("0".equals(countAllIn.getCalcMode()) && null != cacheModel.getBakGoods() && cacheModel.getBakGoods().size() > 0) {
                LOGGER.info("\u6062\u590d\u5546\u54c1");
                cacheModel.restoreGoodsAndPayments();
            }
            if ("0".equals(countAllIn.getCalcMode())) {
                if (countAllIn.getCount() != countAllIn.getGuidList().size() || countAllIn.getCount() != cacheModel.getGoodsList().size()) {
                    ServiceResponse serviceResponse3 = ServiceResponse.buildFailure((ServiceSession)session, (String)"1005", (String)"\u5546\u54c1\u4fe1\u606f\u4e0d\u4e00\u81f4,\u6574\u5355\u8ba1\u7b97\u5931\u8d250");
                    return serviceResponse3;
                }
                int num = 0;
                double qty = 0.0;
                for (Goods g : cacheModel.getGoodsList()) {
                    boolean flag = false;
                    for (String guid : countAllIn.getGuidList()) {
                        if (!guid.equals(g.getGuid())) continue;
                        ++num;
                        qty += g.getQty();
                        flag = true;
                    }
                    if (flag) continue;
                    serviceResponse2 = ServiceResponse.buildFailure((ServiceSession)session, (String)"1005", (String)"\u5546\u54c1\u4fe1\u606f\u4e0d\u4e00\u81f4,\u6574\u5355\u8ba1\u7b97\u5931\u8d251");
                    return serviceResponse2;
                }
                LOGGER.info("qty=" + qty + ",qtys=" + countAllIn.getQty() + ",num=" + num + ",nums=" + countAllIn.getCount());
                if (ManipulatePrecision.doubleCompare(qty, countAllIn.getQty(), 0) != 0 || ManipulatePrecision.doubleCompare(num, countAllIn.getCount(), 0) != 0) {
                    serviceResponse = ServiceResponse.buildFailure((ServiceSession)session, (String)"1005", (String)"\u5546\u54c1\u4fe1\u606f\u4e0d\u4e00\u81f4,\u6574\u5355\u8ba1\u7b97\u5931\u8d252");
                    return serviceResponse;
                }
                cacheModel.setDiscountPayCode("");
            }
            boolean isRemoveAdjustDisc = true;
            if ("1".equals(cacheModel.getOrder().getSysPara().getOrderDiscSeq())) {
                isRemoveAdjustDisc = false;
            }
            if (null == cacheModel.getBakGoods() || cacheModel.getBakGoods().size() <= 0) {
                cacheModel.backGoodsAndPayments();
                if (cacheModel.getPopMode() == 1 || cacheModel.getPopMode() == 3) {
                    cacheModel.setGoodsList(Goods.combineSameGoods(cacheModel.getGoodsList()));
                }
            }
            cacheModel.setErrMsg("");
            if (!("-1".equals(countAllIn.getCalcMode()) || "-2".equals(countAllIn.getCalcMode()) || "-3".equals(countAllIn.getCalcMode()))) {
                cacheModel.getOrder().setCalcMarketingMode(countAllIn.getCalcMode());
            }
            cacheModel.setLimitedPayCodes(CountAllIn.gainLimitedPayCodes(cacheModel, countAllIn));
            if ("-2".equals(countAllIn.getCalcMode())) {
                if (countAllIn.getNoPriceGiftList().size() != cacheModel.getChoiceGiftsHaveNoPrice().size()) {
                    ServiceResponse qty = ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4f20\u53c2\u6709\u8bef\uff0c\u4f20\u5165\u7684\u8d60\u54c1\u6761\u6570\u4e0d\u5339\u914d");
                    return qty;
                }
                cacheModel = this.posLogicServiceImpl.addGiftsPrice(cacheModel, countAllIn.getNoPriceGiftList());
            }
            if ("4".equals(countAllIn.getCalcMode()) && countAllIn.getGiftList() != null && countAllIn.getGiftList().size() > 0) {
                if ((cacheModel = this.posLogicServiceImpl.addGifts(session, cacheModel, countAllIn.getGiftList())).getCalcResult() == -1) {
                    String errCode2 = "100000";
                    if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                        errCode2 = cacheModel.getErrCode();
                    }
                    ServiceResponse serviceResponse4 = ServiceResponse.buildFailure((ServiceSession)session, (String)errCode2, (String)cacheModel.getErrMsg());
                    return serviceResponse4;
                }
                if (null != cacheModel.getChoiceGiftsHaveNoPrice() && cacheModel.getChoiceGiftsHaveNoPrice().size() > 0) {
                    CountAllOut countAllOut = new CountAllOut();
                    OrderForPos order = OrderForPos.toOrderForPos(cacheModel);
                    countAllOut.setOrder(order);
                    countAllOut.setPopFlag(100001);
                    countAllOut.setNoPriceGiftList(cacheModel.getChoiceGiftsHaveNoPrice());
                    cacheModel = this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
                    serviceResponse = ServiceResponse.buildSuccess((Object)countAllOut);
                    return serviceResponse;
                }
            }
            if ("3".equals(countAllIn.getCalcMode()) && countAllIn.getDiscountPayCode() != null && countAllIn.getDiscountPayType() != null) {
                boolean isAllow = false;
                ExceptPay exceptPay = null;
                for (int i = 0; i < cacheModel.getExceptPayDetails().size(); ++i) {
                    exceptPay = cacheModel.getExceptPayDetails().get(i);
                    if (!countAllIn.getDiscountPayCode().equals(exceptPay.getPayCode())) continue;
                    isAllow = true;
                    break;
                }
                if (!isAllow) {
                    ServiceResponse i = ServiceResponse.buildFailure((ServiceSession)session, (String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u8ffd\u9001\u89c4\u5219");
                    return i;
                }
                cacheModel.setDiscountPayCode(countAllIn.getDiscountPayCode());
                p = new Payment();
                p.setPuid(UUIDUtils.buildPuid());
                p.setRownoId(p.getPuid());
                p.setPayCode(countAllIn.getDiscountPayCode());
                p.setPayType(countAllIn.getDiscountPayType());
                p.setPayName("\u652f\u4ed8\u6298\u6263");
                p.setCouponEventId(exceptPay.getEventId());
                p.setCouponPolicyId(exceptPay.getPolicyId());
                p.setTerminalNo(cacheModel.getOrder().getTerminalNo());
                p.setTerminalSno(cacheModel.getOrder().getTerminalSno());
                p.setRate(0.0);
                p.setAmount(0.0);
                p.setMoney(0.0);
                p.setPayNo("");
                p.setIsAutoDelOnly(true);
                p.setFlag("1");
                cacheModel.getPayments().add(p);
            }
            String calcMode = "";
            calcMode = countAllIn.getCalcMode();
            LOGGER.info("\u5546\u54c1\u6570\u91cf\uff1a" + cacheModel.getGoodsList().size());
            if (cacheModel.getPopMode() == 1 || cacheModel.getPopMode() == 2 || cacheModel.getPopMode() == 3) {
                if (!"-1".equals(countAllIn.getCalcMode())) {
                    cacheModel.getOrder().setOutSideGiftsInfo("");
                    if ("-2".equals(calcMode)) {
                        calcMode = "4";
                    }
                    if ((cacheModel = "0".equals(calcMode) ? this.promotionServiceImpl.calcOrderPop(session, calcMode, cacheModel, true, true, isRemoveAdjustDisc) : this.promotionServiceImpl.calcOrderPop(session, calcMode, cacheModel, true, false, isRemoveAdjustDisc)).getCalcResult() == -1) {
                        errCode = "100000";
                        if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                            errCode = cacheModel.getErrCode();
                        }
                        p = ServiceResponse.buildFailure((ServiceSession)session, (String)errCode, (String)cacheModel.getErrMsg());
                        return p;
                    }
                }
                if ("-1".equals(calcMode) || 0 == cacheModel.getCalcResult()) {
                    Object errCode3;
                    double beforeCalcAdjust;
                    if ("0".equals(cacheModel.getOrder().getSysPara().getOrderDiscSeq()) && (beforeCalcAdjust = cacheModel.getOrder().getTotalDiscountValue()) != (cacheModel = this.posLogicCompoment.CalcAdjustDiscAfterOrder(cacheModel)).getOrder().getTotalDiscountValue() && (cacheModel = this.promotionServiceImpl.calcOrderPop(session, "6", cacheModel, false, false, false)).getCalcResult() == -1) {
                        errCode3 = "100000";
                        if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                            errCode3 = cacheModel.getErrCode();
                        }
                        ServiceResponse flag = ServiceResponse.buildFailure((ServiceSession)session, (String)errCode3, (String)cacheModel.getErrMsg());
                        return flag;
                    }
                    CalcafFirmIn calcafFirmIn = new CalcafFirmIn();
                    calcafFirmIn.setType("0");
                    calcafFirmIn.setCalcBillid(cacheModel.getOrder().getSeqNo());
                    response = this.promotionCentreService.calcaffirm(this.restTemplate, session, calcafFirmIn);
                    if (!response.getReturncode().equals("0")) {
                        errCode3 = response;
                        return errCode3;
                    }
                    CalcafFirmOut calcafFirmOut = (CalcafFirmOut)response.getData();
                    if (!calcafFirmOut.getCalcResult().equals("0")) {
                        ServiceResponse flag = ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u9501\u5b9a\u9650\u91cf\u5931\u8d25\uff0c\u6574\u5355\u8ba1\u7b97\u9519\u8bef");
                        return flag;
                    }
                    this.posLogicServiceImpl.calcOrderAmount(cacheModel);
                    cacheModel.setCalcResult(0);
                    cacheModel.clearOrderlist();
                    if ("0".equals(cacheModel.getOrder().getSysPara().getOverageMode()) && ManipulatePrecision.doubleCompare(cacheModel.getOrder().getRoundUpOverageValue(), 0.0, 2) > 0) {
                        if ((cacheModel = this.addOveragePopDetail(session, cacheModel, true)).getCalcResult() == -1) {
                            String errCode4 = "100000";
                            if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                                errCode4 = cacheModel.getErrCode();
                            }
                            serviceResponse2 = ServiceResponse.buildFailure((ServiceSession)session, (String)errCode4, (String)cacheModel.getErrMsg());
                            return serviceResponse2;
                        }
                    } else {
                        cacheModel.setCalcResult(0);
                        calcMode = "99999";
                    }
                }
            } else {
                this.posLogicServiceImpl.calcOrderAmount(cacheModel);
            }
            if (cacheModel.getCalcResult() == -1) {
                errCode = "100000";
                if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                    errCode = cacheModel.getErrCode();
                }
                response = ServiceResponse.buildFailure((ServiceSession)session, (String)errCode, (String)cacheModel.getErrMsg());
                return response;
            }
            if (("-1".equals(calcMode) || "-3".equals(calcMode)) && !this.posLogicServiceImpl.checkBalance(cacheModel)) {
                errCode = ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)cacheModel.getErrMsg());
                return errCode;
            }
            this.posLogicServiceImpl.calcPayBalance(cacheModel);
            if (SellType.ISBACK(cacheModel.getOrder().getOrderType()) && cacheModel.getOrder().getOughtPay() > cacheModel.getCurGrant().getPrivthje()) {
                errCode = ServiceResponse.buildFailure((ServiceSession)session, (String)"1000", (String)"\u9000\u8d27\u91d1\u989d\u8d85\u51fa\u5f53\u524d\u6388\u6743\u4eba\u5458\u6743\u9650\u91d1\u989d\uff0c\u4e0d\u5141\u8bb8\u9000\u8d27");
                return errCode;
            }
            cacheModel = this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
            isrestore = false;
            CountAllOut countAllOut = new CountAllOut();
            OrderForPos order = OrderForPos.toOrderForPos(cacheModel);
            LOGGER.info("CalcMode = " + calcMode);
            if (!"-1".equals(calcMode)) {
                countAllOut.setPopFlag(cacheModel.getCalcResult());
                countAllOut.setGiftGroupList(cacheModel.getGiftsGroup());
                countAllOut.setExceptPays(ExceptPayForPos.transferExceptPayForPosList(cacheModel.getExceptPayDetails()));
                countAllOut.setLimitedPays(cacheModel.getLimitedPayDetails());
            }
            countAllOut.setPopFlag(cacheModel.getCalcResult());
            if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                order.setMessage(cacheModel.getErrMsg());
            }
            countAllOut.setOrder(order);
            ServiceResponse serviceResponse5 = ServiceResponse.buildSuccess((Object)countAllOut);
            return serviceResponse5;
        }
        catch (Exception e) {
            e.printStackTrace();
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stringWriter));
            ServiceResponse serviceResponse = ServiceResponse.buildFailure((ServiceSession)session, (String)stringWriter.toString());
            return serviceResponse;
        }
        finally {
            if (isrestore) {
                cacheModel.getOrder().setAllowEditGoods(true);
                cacheModel = this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
            }
        }
    }

    public ServiceResponse cancelPay(ServiceSession session, JSONObject paramsObject) {
        try {
            ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
            if (!paramsValidateUtils.validate()) {
                return paramsValidateUtils.getServiceResponse();
            }
            CancelPayIn cancelPayIn = (CancelPayIn)JSON.parseObject((String)paramsObject.toJSONString(), CancelPayIn.class);
            CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(cancelPayIn.getFlowNo());
            if (cacheModel == null) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355", (Object[])new Object[]{cancelPayIn.getFlowNo()});
            }
            if (cacheModel.getOrder().getSendSuccess()) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u63d0\u4ea4\u6210\u529f\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u4ed8\u6b3e\u4fe1\u606f", (Object[])new Object[]{cancelPayIn.getFlowNo()});
            }
            if (cacheModel.getOrder().getAllowEditGoods()) {
                BaseOutModel out = new BaseOutModel();
                out.setOrder(OrderForPos.toOrderForPosSingle(cacheModel));
                return ServiceResponse.buildSuccess((Object)out);
            }
            session.setEnt_id(cacheModel.getOrder().getEntId());
            if (null != cacheModel.getPayments() && cacheModel.getPayments().size() > 0) {
                boolean isAllowedDel = true;
                for (Payment p : cacheModel.getPayments()) {
                    if (p.getIsAutoDelOnly()) continue;
                    isAllowedDel = false;
                    break;
                }
                if (!isAllowedDel) {
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5b58\u5728\u4e0d\u5141\u8bb8\u81ea\u52a8\u5220\u9664\u7684\u4ed8\u6b3e\u65b9\u5f0f\uff0c\u8bf7\u5148\u624b\u52a8\u5220\u9664\u4ed8\u6b3e");
                }
                cacheModel = this.posLogicCompoment.calcPayBalance(cacheModel);
            }
            if (SellType.ISSALE(cacheModel.getOrder().getOrderType())) {
                if (!"Y6".equals(cacheModel.getOrder().getOrderType()) && StringUtils.isNotBlank((String)cacheModel.getOrder().getSeqNo())) {
                    CalcafFirmIn calcafFirmIn = new CalcafFirmIn();
                    calcafFirmIn.setType("1");
                    calcafFirmIn.setCalcBillid(cacheModel.getOrder().getSeqNo());
                    ServiceResponse response = this.promotionCentreService.calcaffirm(this.restTemplate, session, calcafFirmIn);
                    if ("0".equals(response.getReturncode())) {
                        CalcafFirmOut crminfoAuthOut = (CalcafFirmOut)response.getData();
                        if (!crminfoAuthOut.getCalcResult().equals("0")) {
                            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u53d6\u6d88\u9501\u5b9a\u9650\u91cf\u5931\u8d25");
                        }
                    } else if (!YPopStatusType.returncode_88888.equals(response.getReturncode())) {
                        return response;
                    }
                }
                CancelPayOut cancelPayOut = new CancelPayOut();
                cancelPayOut.setFlowNo(cancelPayIn.getFlowNo());
                if (!"Y6".equals(cacheModel.getOrder().getOrderType())) {
                    LOGGER.info("\u5220\u9664\u5907\u4efd\u5546\u54c1");
                    cacheModel.restoreGoodsAndPayments();
                }
                this.posLogicServiceImpl.calcOrderAmount(cacheModel);
                this.posLogicCompoment.calcPayBalance(cacheModel);
                cacheModel.getOrder().setAllowEditGoods(true);
                cacheModel = this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
                BaseOutModel out = new BaseOutModel();
                out.setOrder(OrderForPos.toOrderForPosSingle(cacheModel));
                return ServiceResponse.buildSuccess((Object)out);
            }
            if (SellType.ISBACK(cacheModel.getOrder().getOrderType())) {
                if (cacheModel.getOrder().getElectronicStamp() > 0.0) {
                    if (!this.sendEleStamp(session, cacheModel.getOrder().getElectronicStamp(), cacheModel, "S", null, null)) {
                        return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u7ea2\u51b2\u5df2\u6263\u56de\u7684\u7535\u5b50\u5370\u82b1\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
                    }
                    cacheModel.getOrder().setTempElectronicStamp(cacheModel.getOrder().getElectronicStamp());
                    cacheModel.getOrder().setElectronicStamp(0.0);
                }
            } else {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u7f13\u5b58\u53f7\u4e3a[{0}]\u7684\u8ba2\u5355\u7c7b\u578b\u9519\u8bef", (Object[])new Object[]{cancelPayIn.getFlowNo()});
            }
            cacheModel.restoreGoodsAndPayments();
            this.posLogicServiceImpl.calcOrderAmount(cacheModel);
            this.posLogicCompoment.calcPayBalance(cacheModel);
            cacheModel.getOrder().setAllowEditGoods(true);
            cacheModel = this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
            BaseOutModel out = new BaseOutModel();
            out.setOrder(OrderForPos.toOrderForPosSingle(cacheModel));
            return ServiceResponse.buildSuccess((Object)out);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u53d6\u6d88\u9000\u6b3e\u5f02\u5e38");
        }
    }

    public ServiceResponse payment(ServiceSession session, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        if (!paramsObject.containsKey((Object)"amount") || paramsObject.getString("amount").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u4ed8\u6b3e\u91d1\u989d"});
        }
        if (!paramsObject.containsKey((Object)"payCode") || paramsObject.getString("payCode").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u4ed8\u6b3e\u65b9\u5f0f\u4ee3\u7801"});
        }
        if (!paramsObject.containsKey((Object)"payName") || paramsObject.getString("payName").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u4ed8\u6b3e\u65b9\u5f0f\u540d\u79f0"});
        }
        if (!paramsObject.containsKey((Object)"flag") || paramsObject.getString("flag").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u662f\u5426\u7acb\u5373\u652f\u4ed8"});
        }
        if (!paramsObject.containsKey((Object)"scene") || paramsObject.getString("scene").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"scene"});
        }
        if (!paramsObject.containsKey((Object)"rate") || paramsObject.getString("rate").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u6c47\u7387"});
        }
        if (!paramsObject.containsKey((Object)"precision") || paramsObject.getString("precision").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u56db\u820d\u4e94\u5165\u7cbe\u5ea6"});
        }
        if (!paramsObject.containsKey((Object)"cutMode") || paramsObject.getString("cutMode").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u56db\u820d\u4e94\u5165\u65b9\u5f0f"});
        }
        if (!paramsObject.containsKey((Object)"maxVal") || paramsObject.getDouble("maxVal").isNaN()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u6700\u5927\u6210\u4ea4\u91d1\u989d"});
        }
        if (!paramsObject.containsKey((Object)"isAllowCharge") || paramsObject.getString("isAllowCharge").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u662f\u5426\u627e\u96f6"});
        }
        if (!paramsObject.containsKey((Object)"isOverage") || paramsObject.getString("isOverage").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u662f\u5426\u6ea2\u4f59"});
        }
        if (!paramsObject.containsKey((Object)"minVal") || paramsObject.getDouble("minVal").isNaN()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u6700\u5c0f\u6210\u4ea4\u91d1\u989d"});
        }
        if (!paramsObject.containsKey((Object)"payType") || paramsObject.getString("payType").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u4ed8\u6b3e\u5927\u7c7b"});
        }
        PaymentIn in = (PaymentIn)JSON.parseObject((String)paramsObject.toJSONString(), PaymentIn.class);
        CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(in.getFlowNo());
        if (cacheModel == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355", (Object[])new Object[]{in.getFlowNo()});
        }
        if (cacheModel.getOrder().getSendSuccess()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u63d0\u4ea4\u6210\u529f\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u4ed8\u6b3e\u4fe1\u606f", (Object[])new Object[]{in.getFlowNo()});
        }
        session.setEnt_id(cacheModel.getOrder().getEntId());
        if (in.getAmount() < in.getMinVal() || in.getAmount() > in.getMaxVal()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8be5\u4ed8\u6b3e\u65b9\u5f0f\u914d\u7f6e\u4e86\u6700\u5c0f\u548c\u6700\u5927\u6210\u4ea4\u91d1\u989d\uff0c\u4ed8\u6b3e\u91d1\u989d\u4e0d\u5728\u914d\u7f6e\u8303\u56f4\u5185\uff0c[{0}],{0}]\u8bf7\u68c0\u67e5\u4ed8\u6b3e\u65b9\u5f0f\u53c2\u6570\u914d\u7f6e", (Object[])new Object[]{in.getMinVal(), in.getMaxVal()});
        }
        if (SellType.ISBACK(cacheModel.getOrder().getOrderType()) && !"2".equals(cacheModel.getOrder().getOrderType()) && in.getAmount() > ManipulatePrecision.getMoneyByPrecision(cacheModel.getOrder().getRemainValue(), in.getCutMode(), in.getPrecision()) && !"Y".equals(in.getIsOverage())) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u9000\u6b3e\u91d1\u989d\u4e0d\u5141\u8bb8\u5927\u4e8e\u5269\u4f59\u5e94\u4ed8\u91d1\u989d");
        }
        boolean b = this.posLogicServiceImpl.isNoYpopPay(cacheModel.getLimitedPayCodes(), in.getPayCode());
        if ("0".equals(in.getScene())) {
            if (b) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u666e\u901a\u4ed8\u6b3e\uff0c\u8be5\u4ed8\u6b3e\u65b9\u5f0f\u5728\u53d7\u9650\u4ed8\u6b3e\u4e2d\uff0c\u8bf7\u68c0\u67e5\u4ed8\u6b3e\u914d\u7f6e\u5408\u6cd5\u6027");
            }
        } else if ("1".equals(in.getScene()) && !b) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u9664\u5916\u4ed8\u6b3e\uff0c\u8be5\u4ed8\u6b3e\u65b9\u5f0f\u4e0d\u5728\u53d7\u9650\u4ed8\u6b3e\u4e2d\uff0c\u8bf7\u68c0\u67e5\u4ed8\u6b3e\u914d\u7f6e\u5408\u6cd5\u6027");
        }
        Payment pay = PaymentIn.creatPayment(in, cacheModel);
        if (ManipulatePrecision.doubleCompare(cacheModel.getOrder().getRemainValue(), 0.0, 2) <= 0 && ManipulatePrecision.doubleCompare(cacheModel.getOrder().getOughtPay(), 0.0, 2) > 0) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355\u652f\u4ed8\u5df2\u7ecf\u8db3\u591f\uff0c\u4e0d\u9700\u8981\u518d\u4ed8\u6b3e");
        }
        if ((cacheModel = this.posLogicServiceImpl.CalcOrderAmountByPayReturn(cacheModel, pay)).getCalcResult() == -1) {
            String errCode = "100000";
            if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                errCode = cacheModel.getErrCode();
            }
            return ServiceResponse.buildFailure((ServiceSession)session, (String)errCode, (String)cacheModel.getErrMsg());
        }
        cacheModel = this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
        BaseOutModel out = new BaseOutModel();
        out.setOrder(OrderForPos.toOrderForPos(cacheModel));
        return ServiceResponse.buildSuccess((Object)out);
    }

    public ServiceResponse payConfirm(ServiceSession session, JSONObject paramsObject) {
        try {
            ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
            if (!paramsValidateUtils.validate()) {
                return paramsValidateUtils.getServiceResponse();
            }
            if (!JsonUtils.checkJsonArray(paramsObject, "guidList", true, new String[0])) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u786e\u8ba4\u6210\u4ea4\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u5546\u54c1\u4e32"});
            }
            if (!JsonUtils.checkJsonArray(paramsObject, "puidList", true, new String[0])) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u786e\u8ba4\u6210\u4ea4\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u652f\u4ed8\u65b9\u5f0f\u4e32"});
            }
            PayConfirmIn in = (PayConfirmIn)JSON.parseObject((String)paramsObject.toJSONString(), PayConfirmIn.class);
            PayConfirmOut out = new PayConfirmOut();
            CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(in.getFlowNo());
            if (cacheModel == null) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355", (Object[])new Object[]{in.getFlowNo()});
            }
            session.setEnt_id(cacheModel.getOrder().getEntId());
            if (!cacheModel.getOrder().getSendSuccess()) {
                String errCode;
                int m = 0;
                for (Goods g : cacheModel.getGoodsList()) {
                    if (!g.getIsNoBackGift()) continue;
                    ++m;
                }
                List<String> guidList = in.getGuidList();
                if (guidList.size() != cacheModel.getGoodsList().size() - m) {
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5546\u54c1\u4fe1\u606f\u4e0d\u4e00\u81f4,\u786e\u8ba4\u6210\u4ea4\u5931\u8d25");
                }
                int num = 0;
                for (Goods g : cacheModel.getGoodsList()) {
                    if (g.getIsNoBackGift()) continue;
                    boolean flag = false;
                    for (String guid : guidList) {
                        if (!guid.equals(g.getGuid())) continue;
                        ++num;
                        flag = true;
                    }
                    if (flag) continue;
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5546\u54c1\u4fe1\u606f\u4e0d\u4e00\u81f4,\u786e\u8ba4\u6210\u4ea4\u5931\u8d25");
                }
                if (num != guidList.size()) {
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5546\u54c1\u4fe1\u606f\u4e0d\u4e00\u81f4,\u786e\u8ba4\u6210\u4ea4\u5931\u8d25");
                }
                List<String> puidList = in.getPuidList();
                if (puidList.size() != cacheModel.getPayments().size()) {
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u652f\u4ed8\u4fe1\u606f\u4e0d\u4e00\u81f4,\u786e\u8ba4\u6210\u4ea4\u5931\u8d25");
                }
                int num2 = 0;
                boolean noSuccessFlag = false;
                for (int i = 0; i < cacheModel.getPayments().size(); ++i) {
                    Payment p = cacheModel.getPayments().get(i);
                    if (!p.getIsSuccess()) {
                        cacheModel.getPayments().remove(i);
                        --i;
                        noSuccessFlag = true;
                        continue;
                    }
                    boolean flag = false;
                    for (String puid : puidList) {
                        if (!puid.equals(p.getPuid())) continue;
                        ++num2;
                        flag = true;
                    }
                    if (flag) continue;
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u652f\u4ed8\u4fe1\u606f\u4e0d\u4e00\u81f4,\u786e\u8ba4\u6210\u4ea4\u5931\u8d25");
                }
                if (num2 != puidList.size()) {
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u652f\u4ed8\u4fe1\u606f\u4e0d\u4e00\u81f4,\u786e\u8ba4\u6210\u4ea4\u5931\u8d25");
                }
                if (noSuccessFlag) {
                    cacheModel = this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
                    GetRefundOrderInfoOut outInfo = new GetRefundOrderInfoOut();
                    outInfo.setOrder(OrderForPos.toOrderForPos(cacheModel));
                    ServiceResponse outSp = ServiceResponse.buildSuccess((Object)outInfo);
                    outSp.setReturncode("2006");
                }
                List<Payment> payments = cacheModel.getPayments();
                double thisTimeUsedPoint = 0.0;
                if (null != payments) {
                    for (Payment payment : payments) {
                        if (!payment.getPayCode().equals("0706")) continue;
                        thisTimeUsedPoint += payment.getAmount();
                    }
                }
                cacheModel.getOrder().setThisTimeUsedPoint(thisTimeUsedPoint);
                if (SellType.ISBACK(cacheModel.getOrder().getOrderType()) && StringUtils.isNotBlank((String)cacheModel.getOrder().getOriginTerminalSno())) {
                    cacheModel.getOrder().setTotalPoint(cacheModel.getOrder().getConsumersData().getPoint() + cacheModel.getOrder().getThisTimeUsedPoint() - cacheModel.getOrder().getThisTimePoint());
                    cacheModel = this.saveSaleReturnOrder(cacheModel, session, in.getNewTerminalSno());
                    if (cacheModel.getCalcResult() == -1) {
                        errCode = "100000";
                        if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                            errCode = cacheModel.getErrCode();
                        }
                        return ServiceResponse.buildFailure((ServiceSession)session, (String)errCode, (String)cacheModel.getErrMsg());
                    }
                } else if ((cacheModel = this.saveOrder(cacheModel, session, in.getNewTerminalSno())).getCalcResult() == -1) {
                    errCode = "100000";
                    if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                        errCode = cacheModel.getErrCode();
                    }
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)errCode, (String)cacheModel.getErrMsg());
                }
                double availablePoint = ManipulatePrecision.add(cacheModel.getOrder().getTotalPoint(), cacheModel.getOrder().getThisTimePoint());
                cacheModel.getOrder().setAvailablePoint(ManipulatePrecision.getDetailOverFlow(availablePoint, "4"));
                cacheModel.clearOrderlist();
                cacheModel.clearBakGoodsAndPayments();
                if (null != cacheModel.getReturnPayments()) {
                    cacheModel.getReturnPayments().clear();
                }
                this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
                if (SellType.ISBACK(cacheModel.getOrder().getOrderType())) {
                    String type = WorkLogType.refund;
                    if ("2".equals(cacheModel.getOrder().getOrderType())) {
                        type = WorkLogType.voidSale;
                    }
                    if (StringUtils.isBlank((String)cacheModel.getOrder().getOriginTerminalSno())) {
                        type = WorkLogType.superRefund;
                    }
                    this.asyncTask.sendWorkLog(session, cacheModel.getOrder(), type, cacheModel.getOrder().getQty(), cacheModel.getOrder().getOughtPay());
                }
            }
            PrintInfo printInfo = PrintInfo.convertPrintInfo(cacheModel.getGoodsList(), cacheModel.getOrder().getSysPara().getCalcPriceType(), cacheModel.getOrder().getSysPara().getPopPrtSeq(), cacheModel.getOrder().getSysPara().getPopPrtMode());
            out.setOrder(OrderForPos.toOrderForPosOrderSave(cacheModel, printInfo.getGoodsListForPrint()));
            out.setPopInfo(PopDetail.transferPopForPos(printInfo.getMergedPopDetails()));
            if (!cacheModel.getOrder().getIsAllReturn()) {
                OrderQueryIn queryIn = new OrderQueryIn();
                queryIn.setBusiTakeMarketCode(in.getShopCode());
                queryIn.setTerminalNo(in.getTerminalNo());
                queryIn.setTerminalSno(cacheModel.getOrder().getTerminalSno());
                queryIn.setSearchType(4);
                ServiceResponse resp = this.orderCentreSerivce.getOrderAll(this.restTemplate, session, queryIn);
                if ("0".equals(resp.getReturncode())) {
                    GetOrdersDetailOut getOrdersDetailOut = (GetOrdersDetailOut)resp.getData();
                    SaleOrders oriOrder = getOrdersDetailOut.getOriginInfo();
                    if (null != oriOrder && oriOrder.getOrders() != null) {
                        PayConfirmOut orderInfo = this.toPayConfirmOutBySave(session, oriOrder, cacheModel.getOrder().getSysPara().getCalcPriceType(), cacheModel.getOrder().getSysPara().getPopPrtSeq(), cacheModel.getOrder().getSysPara().getPopPrtMode());
                        OrderForPos originOrder = orderInfo.getOriginOrder();
                        if (null != cacheModel.getOrder().getConsumersData()) {
                            originOrder.setThisTimePoint(cacheModel.getOrder().getThisTimePoint());
                            originOrder.setThisTimeUsedPoint(cacheModel.getOrder().getThisTimeUsedPoint());
                            originOrder.setTotalPoint(cacheModel.getOrder().getTotalPoint());
                            originOrder.getConsumersData().setPoint(cacheModel.getOrder().getConsumersData().getPoint());
                        }
                        out.setOriginOrder(originOrder);
                        out.setOriginPopInfo(orderInfo.getOriginPopInfo());
                    }
                } else {
                    LOGGER.info("\u67e5\u8be2\u65b0\u8ba2\u5355\u5931\u8d25\uff1a" + resp.getData());
                }
            }
            if ("0".equals(this.routeMode)) {
                ReadOrWriterUtil.delete(in.getFlowNo());
            }
            return ServiceResponse.buildSuccess((Object)out);
        }
        catch (Exception e) {
            e.printStackTrace();
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stringWriter));
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355\u4fdd\u5b58\u5931\u8d25");
        }
    }

    private ServiceResponse reversePromotion(ServiceSession session, CacheModel cacheModel, CouponuseConsumeIn couponuseConsumeIn) {
        ServiceResponse response = new ServiceResponse();
        List<SellPayment> reversePayments = couponuseConsumeIn.getSellPayments();
        cacheModel.setReversePayments(reversePayments);
        response.setReturncode(this.couponConsume(cacheModel, session, 4).getReturncode());
        return response;
    }

    /*
     * WARNING - void declaration
     */
    public ServiceResponse deletePayment(ServiceSession session, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        if (!paramsObject.containsKey((Object)"puid") || paramsObject.getString("puid").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5220\u9664\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u4ed8\u6b3e\u884c\u552f\u4e00\u6807\u8bc6"});
        }
        DeletePaymentIn in = (DeletePaymentIn)JSON.parseObject((String)paramsObject.toJSONString(), DeletePaymentIn.class);
        CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(in.getFlowNo());
        if (cacheModel == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355", (Object[])new Object[]{in.getFlowNo()});
        }
        if (cacheModel.getOrder().getSendSuccess()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u63d0\u4ea4\u6210\u529f\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u4ed8\u6b3e\u4fe1\u606f", (Object[])new Object[]{in.getFlowNo()});
        }
        session.setEnt_id(cacheModel.getOrder().getEntId());
        Payment payment = null;
        for (Payment payment2 : cacheModel.getPayments()) {
            if (!payment2.getPuid().equals(in.getPuid())) continue;
            payment = payment2;
            break;
        }
        if (payment != null) {
            if (!payment.getIsDirectDel()) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8be5\u4ed8\u6b3e\u65b9\u5f0f\u4e0d\u5141\u8bb8\u76f4\u63a5\u5220\u9664");
            }
            boolean isNeedCalcOrder = false;
            for (Payment p : cacheModel.getPayments()) {
                if (!p.getIsHaveDelDiscount()) continue;
                isNeedCalcOrder = true;
            }
            cacheModel.getPayments().remove(payment);
            cacheModel = this.posLogicServiceImpl.CalcOrderAmountByDeletePayReturn(cacheModel);
            if (isNeedCalcOrder) {
                cacheModel = this.promotionServiceImpl.calcOrderPop(session, "5", cacheModel, false, false, false);
            } else if (cacheModel.getOrder().getIsHaveConflictCoupon()) {
                cacheModel = this.promotionServiceImpl.calcOrderPop(session, "7", cacheModel, false, false, false);
            }
            if (cacheModel.getCalcResult() == -1) {
                void var8_13;
                String string = "100000";
                if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                    String string2 = cacheModel.getErrCode();
                }
                return ServiceResponse.buildFailure((ServiceSession)session, (String)var8_13, (String)cacheModel.getErrMsg());
            }
            this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
        }
        BaseOutModel out = new BaseOutModel();
        out.setOrder(OrderForPos.toOrderForPos(cacheModel));
        return ServiceResponse.buildSuccess((Object)out);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ServiceResponse getOrderInfo(ServiceSession session, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        GetOrderInfoIn in = (GetOrderInfoIn)JSON.toJavaObject((JSON)paramsObject, GetOrderInfoIn.class);
        CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(in.getFlowNo());
        if (cacheModel == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355", (Object[])new Object[]{in.getFlowNo()});
        }
        if (in.getType() == 1 || in.getType() == 2 || in.getType() == 3) {
            LocalDateTime dateTime = LocalDateTime.now();
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            String nowDateTime = dateTime.format(df).toString();
            Order order = cacheModel.getOrder();
            if (in.getType() == 1) {
                cacheModel.getOrder().setSaleExtractTime(nowDateTime);
                if (in.getTerminalOperator().equals(order.getTerminalOperator())) {
                    cacheModel.setCurGrant(cacheModel.getCurSyyInfo());
                } else {
                    OperUserIn posManagerOperUserIn = new OperUserIn();
                    posManagerOperUserIn.setErpCode(order.getErpCode());
                    posManagerOperUserIn.setCardno(in.getTerminalOperator());
                    posManagerOperUserIn.setMkt(in.getShopCode());
                    posManagerOperUserIn.setSyjh(in.getTerminalNo());
                    posManagerOperUserIn.setFlag("N");
                    ServiceResponse response = this.posManagerService.getOperUser(this.restTemplate, session, posManagerOperUserIn);
                    if (!"0".equals(response.getReturncode())) return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5f53\u524d\u6536\u94f6\u5458\u6216\u6388\u6743\u4eba\u5458\u4fe1\u606f\u65e0\u6cd5\u627e\u5230");
                    OperUserOut operUserOut = (OperUserOut)response.getData();
                    if (operUserOut.getOperuser() == null || operUserOut.getPosrole() == null) {
                        return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5f53\u524d\u6536\u94f6\u5458\u6216\u6388\u6743\u4eba\u5458\u4fe1\u606f\u4e0d\u5b8c\u6574");
                    }
                    OperUser operUser = new OperUser(operUserOut);
                    cacheModel.getOrder().setTerminalOperator(in.getTerminalOperator());
                    cacheModel.setCurSyyInfo(operUser);
                    cacheModel.setCurGrant(operUser);
                }
            } else if (in.getType() == 2) {
                cacheModel.setCurGrant(cacheModel.getCurSmyInfo());
            } else if (in.getType() == 3) {
                cacheModel.getOrder().setScanSubmitTime(nowDateTime);
            }
            cacheModel = this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
        }
        GetRefundOrderInfoOut out = new GetRefundOrderInfoOut();
        if (cacheModel.getOrder().getAllowEditGoods()) {
            out.setOrder(OrderForPos.toOrderForPosSingle(cacheModel));
        } else {
            out.setOrder(OrderForPos.toOrderForPos(cacheModel));
        }
        if (in.getNeedOldPay() == 1 && SellType.ISBACK(cacheModel.getOrder().getOrderType())) {
            List<GoodsForPos> goodListPops = Goods.transferGoodsToPosGoodsListSingle(cacheModel.getReturnGoodsList(), cacheModel.getOrder().getSysPara().getCalcPriceType());
            out.setOriginGoodsList(goodListPops);
            out.setOriginSalePayments(Payment.transferPosPaymentList(cacheModel.getReturnPayments()));
        }
        out.setDiscountPayCode(cacheModel.getDiscountPayCode());
        out.setLimitedPays(cacheModel.getLimitedPayDetails());
        return ServiceResponse.buildSuccess((Object)out);
    }

    public ServiceResponse calcRedemOrder(ServiceSession session, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        GetOrderInfoIn in = (GetOrderInfoIn)JSON.toJavaObject((JSON)paramsObject, GetOrderInfoIn.class);
        CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(in.getFlowNo());
        if (cacheModel == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355", (Object[])new Object[]{in.getFlowNo()});
        }
        if (cacheModel.getGoodsList().size() <= 0) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u6ca1\u6709\u5546\u54c1\uff0c\u8bf7\u6dfb\u52a0\u5546\u54c1", (Object[])new Object[]{in.getFlowNo()});
        }
        if (!"H1".equals(cacheModel.getOrder().getOrderType())) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355\u7c7b\u578b\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5");
        }
        Payment payment = new Payment();
        payment.setPuid(UUIDUtils.buildPuid());
        payment.setAmount(cacheModel.getOrder().getOughtPay());
        payment.setPayCode(cacheModel.getPayMode().getPayCode());
        payment.setPayType(cacheModel.getPayMode().getPayType());
        payment.setRate(cacheModel.getPayMode().getRate());
        payment.setMoney(cacheModel.getOrder().getOughtPay());
        payment.setOverage(0.0);
        payment.setRoundUpOverageValue(0.0);
        payment.setPayName(cacheModel.getPayMode().getPayName());
        payment.setRowno(1);
        payment.setFlag("1");
        payment.setPrcutMode(cacheModel.getPayMode().getRoundType());
        payment.setPrecision(cacheModel.getPayMode().getRoundPrecision());
        cacheModel = this.posLogicServiceImpl.CalcOrderAmountByPayReturn(cacheModel, payment);
        cacheModel = this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
        this.cacheModelService.deleteCacheModel(paramsObject.getString("flowNo"));
        BaseOutModel out = new BaseOutModel();
        out.setOrder(OrderForPos.toOrderForPos(cacheModel));
        return ServiceResponse.buildSuccess((Object)out);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ServiceResponse getReturnOrderInfo(ServiceSession session, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        GetOrderInfoIn in = (GetOrderInfoIn)JSON.toJavaObject((JSON)paramsObject, GetOrderInfoIn.class);
        CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(in.getFlowNo());
        if (cacheModel == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355", (Object[])new Object[]{in.getFlowNo()});
        }
        if (in.getType() == 1 || in.getType() == 2) {
            LocalDateTime dateTime = LocalDateTime.now();
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            String nowDateTime = dateTime.format(df).toString();
            cacheModel.getOrder().setSaleExtractTime(nowDateTime);
            Order order = cacheModel.getOrder();
            if (in.getType() == 1) {
                if (in.getTerminalOperator().equals(order.getTerminalOperator())) {
                    cacheModel.setCurGrant(cacheModel.getCurSyyInfo());
                } else {
                    OperUserIn posManagerOperUserIn = new OperUserIn();
                    posManagerOperUserIn.setErpCode(order.getErpCode());
                    posManagerOperUserIn.setCardno(in.getTerminalOperator());
                    posManagerOperUserIn.setMkt(in.getShopCode());
                    posManagerOperUserIn.setSyjh(in.getTerminalNo());
                    ServiceResponse response = this.posManagerService.getOperUser(this.restTemplate, session, posManagerOperUserIn);
                    if (!"0".equals(response.getReturncode())) return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5f53\u524d\u6536\u94f6\u5458\u6216\u6388\u6743\u4eba\u5458\u4fe1\u606f\u65e0\u6cd5\u627e\u5230");
                    OperUserOut operUserOut = (OperUserOut)response.getData();
                    if (operUserOut.getOperuser() == null || operUserOut.getPosrole() == null) {
                        return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5f53\u524d\u6536\u94f6\u5458\u6216\u6388\u6743\u4eba\u5458\u4fe1\u606f\u4e0d\u5b8c\u6574");
                    }
                    OperUser operUser = new OperUser(operUserOut);
                    cacheModel.setCurGrant(operUser);
                }
            } else {
                cacheModel.setCurGrant(cacheModel.getCurSmyInfo());
            }
            cacheModel = this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
        }
        BaseOutModel out = new BaseOutModel();
        out.setOrder(OrderForPos.toReturnOrderForPos(cacheModel));
        return ServiceResponse.buildSuccess((Object)out);
    }

    public ServiceResponse getOrders(ServiceSession session, JSONObject paramsObject) {
        if (StringUtils.isBlank((String)paramsObject.getString("shopCode"))) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u6279\u91cf\u83b7\u53d6\u8ba2\u5355\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u95e8\u5e97\u53f7"});
        }
        if (StringUtils.isBlank((String)paramsObject.getString("entId"))) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u6279\u91cf\u83b7\u53d6\u8ba2\u5355\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u96f6\u552e\u5546id"});
        }
        if (StringUtils.isBlank((String)paramsObject.getString("pageNo"))) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u6279\u91cf\u83b7\u53d6\u8ba2\u5355\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u8d77\u59cb\u9875"});
        }
        if (StringUtils.isBlank((String)paramsObject.getString("pageSize"))) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u6279\u91cf\u83b7\u53d6\u8ba2\u5355\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u5206\u9875\u6bcf\u9875\u5927\u5c0f"});
        }
        GetOrdersIn getOrdersIn = (GetOrdersIn)JSON.parseObject((String)paramsObject.toJSONString(), GetOrdersIn.class);
        if (getOrdersIn == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5165\u53c2\u8f6c\u6362\u5931\u8d25\uff01");
        }
        session.setEnt_id(getOrdersIn.getEntId());
        OrderQueryIn orderQueryIn = OrderQueryIn.transferGetOrdersInToOrderQueryIn(getOrdersIn);
        ServiceResponse response = this.orderCentreSerivce.getBills(this.restTemplate, session, orderQueryIn);
        if ("0".equals(response.getReturncode())) {
            return ServiceResponse.buildSuccess((Object)((OrdersQueryOut)response.getData()).transferOrderToGetOrdersOut(getOrdersIn));
        }
        return response;
    }

    public ServiceResponse saveSalesReturn(ServiceSession session, JSONObject paramsObject) {
        try {
            ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
            if (!paramsValidateUtils.validate()) {
                return paramsValidateUtils.getServiceResponse();
            }
            if (!paramsObject.containsKey((Object)"guidList") || paramsObject.getJSONArray("guidList").isEmpty()) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u9000\u8d27\u4fdd\u5b58\u8ba2\u5355\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u5546\u54c1uid\u4e32"});
            }
            if (!paramsObject.containsKey((Object)"puidList") || paramsObject.getJSONArray("puidList").isEmpty()) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u9000\u8d27\u4fdd\u5b58\u8ba2\u5355\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u652f\u4ed8uid\u4e32"});
            }
            SaveSaleReturnIn saveSalesReturnIn = (SaveSaleReturnIn)JSON.parseObject((String)paramsObject.toJSONString(), SaveSaleReturnIn.class);
            CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(saveSalesReturnIn.getFlowNo());
            if (!cacheModel.getOrder().getSendSuccess() && (cacheModel = this.saveSaleReturnOrder(cacheModel, session, saveSalesReturnIn.getNewTerminalSno())).getCalcResult() == -1) {
                String errCode = "100000";
                if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                    errCode = cacheModel.getErrCode();
                }
                return ServiceResponse.buildFailure((ServiceSession)session, (String)errCode, (String)cacheModel.getErrMsg());
            }
            if (SellType.ISBACK(cacheModel.getOrder().getOrderType()) && StringUtils.isNotBlank((String)cacheModel.getOrder().getOriginInvoiceTitle())) {
                this.updateQuota(session, cacheModel, -1);
            }
            List<Payment> payments = cacheModel.getReturnPayments();
            for (int i = 0; i < payments.size(); ++i) {
                Payment payment = payments.get(i);
                if (!"\u79ef\u5206\u6362\u8d2d".equals(payment.getPayName()) && !"\u79ef\u5206\u5229\u7528".equals(payment.getPayName())) continue;
                YWMemberConsumeReverseIn consumeReverseIn = this.posLogicCompoment.buildYWMemberConsumeReverseIn(cacheModel, payment);
                String sign = this.posLogicCompoment.signYWMemberConsumeReverse(cacheModel, payment, consumeReverseIn);
                consumeReverseIn.setSign(sign);
                ServiceResponse response = this.chinaYWService.pointConsume(this.restTemplate, session, consumeReverseIn);
                if ("0".equals(response.getReturncode())) {
                    YWMemberOut res = (YWMemberOut)response.getData();
                    if (200 == res.getCode()) continue;
                    this.pointConsumeReverseService.save(session, (JSONObject)JSONObject.toJSON((Object)consumeReverseIn));
                    continue;
                }
                this.pointConsumeReverseService.save(session, (JSONObject)JSONObject.toJSON((Object)consumeReverseIn));
            }
            OrderForPos ofp = OrderForPos.toOrderForPos(cacheModel);
            return ServiceResponse.buildSuccess((Object)ofp);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public ServiceResponse cancelAppointDiscounts(ServiceSession session, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        String popType = paramsObject.getString("popType");
        if (StringUtils.isBlank((String)popType)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u7c7b\u578b\u4f18\u60e0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{new Object()});
        }
        CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(paramsObject.getString("flowNo"));
        if (cacheModel == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)("\u67e5\u627e\u7f13\u5b58\u5931\u8d25" + paramsObject.getString("flowNo")), (Object[])new Object[]{new Object()});
        }
        if (!cacheModel.getOrder().getAllowEditGoods()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u8fdb\u5165\u652f\u4ed8\u73af\u8282\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u5546\u54c1", (Object[])new Object[]{paramsObject.getString("flowNo")});
        }
        List<Goods> goodes = cacheModel.getGoodsList();
        if (goodes.size() < 0) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u65e0\u5546\u54c1\uff0c\u65e0\u6cd5\u8fdb\u884c\u53d6\u6d88\u4f18\u60e0", (Object[])new Object[]{new Object()});
        }
        block0: for (Goods good : goodes) {
            List<PopDetail> popDetails;
            if (good == null || (popDetails = good.getPopDetailsInfo()).size() <= 0) continue;
            for (int i = 0; i < popDetails.size(); ++i) {
                if (!popDetails.get(i).getPopPolicyGroup().trim().equals(popType)) continue;
                double discountAmout = popDetails.get(i).getDiscountAmount();
                double newDiscountAmout = ManipulatePrecision.doubleConvert(good.getPopDiscountValue() - discountAmout, 2, 1);
                good.setPopDiscountValue(newDiscountAmout);
                double totalDiscountValue = PosLogicCompoment.getZZK(good);
                good.setTotalDiscountValue(totalDiscountValue);
                good.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(good.getTotalDiscountValue() - good.getNoDisAmountValue()));
                popDetails.remove(popDetails.get(i));
                --i;
                continue block0;
            }
        }
        this.posLogicServiceImpl.calcOrderAmount(cacheModel);
        if (cacheModel.getCalcResult().equals(-1)) {
            String errCode = "100000";
            if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                errCode = cacheModel.getErrCode();
            }
            return ServiceResponse.buildFailure((ServiceSession)session, (String)errCode, (String)cacheModel.getErrMsg());
        }
        this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
        CancelAssginTypeDisOut cancelAssginTypeDisOut = new CancelAssginTypeDisOut();
        cancelAssginTypeDisOut.setDiscountValue(cacheModel.getOrder().getTotalDiscountValue());
        cancelAssginTypeDisOut.setFlowNo(paramsObject.getString("flowNo"));
        cancelAssginTypeDisOut.setTotalValue(cacheModel.getOrder().getSaleValue());
        cancelAssginTypeDisOut.setOughtPay(cacheModel.getOrder().getOughtPay());
        cancelAssginTypeDisOut.setGoodsList(goodes);
        return ServiceResponse.buildSuccess((Object)cancelAssginTypeDisOut);
    }

    private ServiceResponse couponConsume(CacheModel cacheModel, ServiceSession session, int payConfirmStatus) {
        try {
            CouponuseConsumeIn couponuseConsumeIn = new CouponuseConsumeIn();
            couponuseConsumeIn.setBillno(cacheModel.getOrder().getFlowNo());
            couponuseConsumeIn.setCalcBillId(cacheModel.getOrder().getSeqNo());
            couponuseConsumeIn.setType("1");
            ServiceResponse response = null;
            response = this.promotionCentreService.couponAndPointsConsume(this.restTemplate, session, couponuseConsumeIn);
            if ("0".equals(response.getReturncode()) || YPopStatusType.returncode_99998.equals(response.getReturncode())) {
                cacheModel.getReversePayments().clear();
                payConfirmStatus = 0;
                response.setReturncode("2000");
                response.setData((Object)"\u51b2\u6b63\u6210\u529f");
            } else {
                response.setReturncode("2001");
                payConfirmStatus = Integer.valueOf(payConfirmStatus + "1");
                String msg = "\u51b2\u6b63\u5931\u8d25-" + payConfirmStatus + "-" + response.getData();
                response.setData((Object)msg);
            }
            cacheModel.setPayConfirmStatus(payConfirmStatus);
            cacheModel = this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
            return response;
        }
        catch (Exception e) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)e.getMessage());
        }
    }

    private ServiceResponse couponConsumeByHC(CacheModel cacheModel, ServiceSession session, int payConfirmStatus) {
        try {
            CouponuseConsumeIn couponuseConsumeIn = new CouponuseConsumeIn();
            couponuseConsumeIn.setBillno(cacheModel.getOrder().getOriginFlowNo());
            couponuseConsumeIn.setCalcBillId(cacheModel.getOrder().getOriginSeqNo());
            couponuseConsumeIn.setType("1");
            ServiceResponse response = this.promotionCentreService.couponAndPointsConsume(this.restTemplate, session, couponuseConsumeIn);
            if ("0".equals(response.getReturncode()) || YPopStatusType.returncode_99998.equals(response.getReturncode())) {
                cacheModel.getReversePayments().clear();
                payConfirmStatus = 0;
                response.setReturncode("2000");
            } else {
                response.setReturncode("2001");
                payConfirmStatus = Integer.valueOf(payConfirmStatus + "1");
                String msg = "\u51b2\u6b63\u5931\u8d25-" + payConfirmStatus + "-" + response.getData();
                response.setData((Object)msg);
            }
            cacheModel.setPayConfirmStatus(payConfirmStatus);
            cacheModel = this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
            return response;
        }
        catch (Exception e) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)e.getMessage());
        }
    }

    private ServiceResponse couponConsume(CacheModel cacheModel, ServiceSession session, int payConfirmStatus, ServiceResponse errRsp) {
        ServiceResponse response = this.couponConsume(cacheModel, session, payConfirmStatus);
        if (!"2000".equals(response.getReturncode())) {
            response.setData((Object)("[\u51b2\u6b63\u5931\u8d25]---[" + response.getData() + "]--[\u51b2\u6b63\u539f\u56e0]---[" + errRsp.getData() + "]"));
        } else {
            response.setData((Object)("[\u51b2\u6b63\u6210\u529f]---[" + response.getData() + "]--[\u51b2\u6b63\u539f\u56e0]---[" + errRsp.getData() + "]"));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ServiceResponse copySno(ServiceSession session, JSONObject paramsObject) {
        try {
            CopySnoIn copySnoIn;
            CacheModel cacheModel;
            ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
            if (!paramsValidateUtils.validate()) {
                if (StringUtils.isBlank((String)paramsObject.getString("flowNo"))) {
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u590d\u5236\u5c0f\u7968\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u6d41\u6c34\u53f7"});
                }
            } else if (!paramsObject.containsKey((Object)"originShopCode") || "".equals(paramsObject.getString("originShopCode")) || !paramsObject.containsKey((Object)"originTerminalSno") || "".equals(paramsObject.getString("originTerminalSno")) || !paramsObject.containsKey((Object)"originTerminalNo") || "".equals(paramsObject.getString("originTerminalNo"))) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u590d\u5236\u5c0f\u7968\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u8ba2\u5355\u4e2d\u5fc3\u8ba2\u5355\u53f7\u6216\u8005\u5c0f\u7968\u53f7\u3001\u95e8\u5e97\u53f7\u3001\u7ec8\u7aef\u53f7"});
            }
            if ((cacheModel = this.cacheModelService.getCacheModelByFlowNo((copySnoIn = (CopySnoIn)JSONObject.toJavaObject((JSON)paramsObject, CopySnoIn.class)).getFlowNo())) == null) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355", (Object[])new Object[]{copySnoIn.getFlowNo()});
            }
            try {
                String nowDateTime;
                if (!cacheModel.getOrder().getAllowEditGoods()) {
                    ServiceResponse serviceResponse = ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u8fdb\u5165\u652f\u4ed8\u73af\u8282\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u5546\u54c1", (Object[])new Object[]{copySnoIn.getFlowNo()});
                    return serviceResponse;
                }
                if (StringUtils.isBlank((String)cacheModel.getOrder().getSeqNo())) {
                    LocalDateTime dateTime = LocalDateTime.now();
                    DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                    nowDateTime = dateTime.format(df).toString();
                    cacheModel.getOrder().setSaleDate(nowDateTime);
                    cacheModel.getOrder().setSaleExtractTime(nowDateTime);
                }
                OrderQueryIn in = new OrderQueryIn();
                in.setBusiTakeMarketCode(copySnoIn.getOriginShopCode());
                in.setTerminalNo(copySnoIn.getOriginTerminalNo());
                in.setTerminalSno(copySnoIn.getOriginTerminalSno());
                in.setCreateDate(copySnoIn.getBillDate());
                in.setSearchType(3);
                ServiceResponse resp = this.orderCentreSerivce.getOrderAll(this.restTemplate, session, in);
                if (!"0".equals(resp.getReturncode())) {
                    if ("60003".equals(resp.getReturncode())) {
                        nowDateTime = ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)("\u8bf7\u6c42\u8ba2\u5355\u4e2d\u5fc3\u83b7\u53d6\u8ba2\u5355\u5931\u8d25:" + resp.getData()));
                        return nowDateTime;
                    }
                    LOGGER.info("\u8bf7\u6c42\u8ba2\u5355\u4e2d\u5fc3\u83b7\u53d6\u8ba2\u5355\u5931\u8d25:" + resp.getData());
                    nowDateTime = ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5355\u636e\u7f16\u53f7\u4e0d\u6b63\u786e\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u5355\u636e\u7f16\u53f7\uff08 \u95e8\u5e97\u53f7+\u673a\u53f0\u53f7+\u5c0f\u7968\u53f7\uff09");
                    return nowDateTime;
                }
                GetOrdersDetailOut getOrdersDetailOut = (GetOrdersDetailOut)resp.getData();
                SaleOrders saleOrders = getOrdersDetailOut.getOrderInfo();
                if (saleOrders.getOrders() == null) {
                    ServiceResponse serviceResponse = ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u67e5\u8be2\u8ba2\u5355\u5931\u8d25");
                    return serviceResponse;
                }
                OrdersModel4Pos saleOrder = saleOrders.getOrders();
                String typeCode = saleOrder.getOrderType();
                if (SellType.ISBACK(typeCode)) {
                    ServiceResponse serviceResponse = ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u9000\u8d27\u8ba2\u5355\u4e0d\u5141\u8bb8\u590d\u5236");
                    return serviceResponse;
                }
                if ("Y10".equals(typeCode)) {
                    ServiceResponse serviceResponse = ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4f1a\u5458\u5165\u4f1a\u8ba2\u5355\u4e0d\u5141\u8bb8\u590d\u5236");
                    return serviceResponse;
                }
                if ("Y11".equals(typeCode)) {
                    ServiceResponse serviceResponse = ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4f1a\u5458\u7eed\u8d39\u8ba2\u5355\u4e0d\u5141\u8bb8\u590d\u5236");
                    return serviceResponse;
                }
                if ("Y9".equals(typeCode)) {
                    ServiceResponse serviceResponse = ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u627e\u96f6\u516b\u8fbe\u901a\u8ba2\u5355\u4e0d\u5141\u8bb8\u590d\u5236");
                    return serviceResponse;
                }
                if ("Y3".equals(typeCode)) {
                    ServiceResponse serviceResponse = ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u516b\u8fbe\u901a\u5145\u503c\u8ba2\u5355\u4e0d\u5141\u8bb8\u590d\u5236");
                    return serviceResponse;
                }
                if ("Y4".equals(typeCode)) {
                    ServiceResponse serviceResponse = ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u56db\u7535\u4e00\u8111\u8ba2\u5355\u4e0d\u5141\u8bb8\u590d\u5236");
                    return serviceResponse;
                }
                if ("Y12".equals(typeCode)) {
                    ServiceResponse serviceResponse = ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5370\u82b1\u6362\u8d2d\u8ba2\u5355\u4e0d\u5141\u8bb8\u590d\u5236");
                    return serviceResponse;
                }
                int barNoMode = 0;
                String discType = "0";
                if ("2".equals(cacheModel.getEleCodeMode())) {
                    barNoMode = 3;
                }
                DzcGoodsDetail dzc = new DzcGoodsDetail();
                GoodsInfo goodsInfo = null;
                List<OrdersDetailModel> saleOrderDetail = saleOrders.getOrdersDetail();
                ArrayList<Goods> goodsList = new ArrayList<Goods>();
                boolean n = false;
                if (!saleOrderDetail.isEmpty()) {
                    for (int i = 0; i < saleOrderDetail.size(); ++i) {
                        Object object;
                        GetGoodsDetailOut goodsDetail;
                        if (saleOrderDetail.get(i).getGoodType().equals("98") || saleOrderDetail.get(i).getGoodType().equals("99") || null != saleOrderDetail.get(i).getGoodsFlag() && (saleOrderDetail.get(i).getGoodsFlag().equals("0") || saleOrderDetail.get(i).getGoodsFlag().equals("7") || saleOrderDetail.get(i).getGoodsFlag().equals("8") || saleOrderDetail.get(i).getGoodsFlag().equals("9") || saleOrderDetail.get(i).getGoodsFlag().equals("B"))) continue;
                        boolean isdzcm = false;
                        boolean isNeedFindDzc = true;
                        boolean isNeedFindMdm = true;
                        int priceMode = 0;
                        String originalBarNo = saleOrderDetail.get(i).getScanCode();
                        int disMode = 0;
                        double disValue = 0.0;
                        AnalyzeBarcodeDef codeInfo = this.posLogicCompoment.analyzeCodeInfo(barNoMode, originalBarNo, "0");
                        if (!codeInfo.getValidate()) {
                            ServiceResponse serviceResponse = ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8be5\u6761\u5f62\u7801\u65e0\u6cd5\u901a\u8fc7\u6821\u9a8c\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165");
                            return serviceResponse;
                        }
                        isNeedFindDzc = codeInfo.getIsNeedFindDzc();
                        priceMode = codeInfo.getPriceMode();
                        disMode = codeInfo.getDisMode();
                        disValue = codeInfo.getDisValue();
                        barNoMode = codeInfo.getBarNoMode();
                        GetGoodsDetailIn getGoodsDetailIn = new GetGoodsDetailIn();
                        if (codeInfo.getBarNo().length() <= 18) {
                            getGoodsDetailIn.setCode(codeInfo.getBarNo());
                            getGoodsDetailIn.setEntId(session.getEnt_id());
                            getGoodsDetailIn.setShopCode(cacheModel.getOrder().getShopCode());
                            getGoodsDetailIn.setTerminalNo(cacheModel.getOrder().getTerminalNo());
                            getGoodsDetailIn.setSearchType("1");
                            getGoodsDetailIn.setChannel(cacheModel.getOrder().getChannel());
                            getGoodsDetailIn.setErpCode(cacheModel.getOrder().getErpCode());
                            resp = this.mainDataCentreService.getGoodsFromMDM(this.restTemplate, session, getGoodsDetailIn);
                            if (null != resp && null != (goodsDetail = (GetGoodsDetailOut)resp.getData()) && null != goodsDetail.getGoods() && goodsDetail.getGoods().size() > 0) {
                                isNeedFindDzc = false;
                                isNeedFindMdm = false;
                            }
                        }
                        if (isNeedFindDzc && cacheModel.getEleCodeRule().size() > 0) {
                            List<ElecScaleCodeRule> elecCodeRules = cacheModel.getEleCodeRule();
                            dzc = this.posLogicCompoment.analyzeBarcode(codeInfo.getBarNo(), elecCodeRules, elecCodeRules.get(0).getExpModeMMDDDays(), elecCodeRules.get(0).getExpModeDDHHDays(), cacheModel.getEleCodeMode());
                            if (!SellType.ISBACK(cacheModel.getOrder().getOrderType()) && dzc.getRetCode() == 2) {
                                object = ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8be5\u5546\u54c1\u5df2\u8fc7\u671f\uff0c\u4e0d\u5141\u8bb8\u9500\u552e");
                                return object;
                            }
                            if (dzc.getRetCode() == 1) {
                                isdzcm = true;
                            }
                        }
                        if (isdzcm) {
                            getGoodsDetailIn.setEntId(session.getEnt_id());
                            getGoodsDetailIn.setShopCode(cacheModel.getOrder().getShopCode());
                            getGoodsDetailIn.setTerminalNo(cacheModel.getOrder().getTerminalNo());
                            getGoodsDetailIn.setCode(dzc.getCode());
                            if (getGoodsDetailIn.getCode().length() < 8) {
                                getGoodsDetailIn.setCode(Convert.padLeft(getGoodsDetailIn.getCode(), '0', 8));
                            }
                            getGoodsDetailIn.setSearchType("1");
                            getGoodsDetailIn.setChannel(cacheModel.getOrder().getChannel());
                            getGoodsDetailIn.setErpCode(cacheModel.getOrder().getErpCode());
                            resp = this.mainDataCentreService.getGoodsFromMDM(this.restTemplate, session, getGoodsDetailIn);
                        } else {
                            getGoodsDetailIn.setEntId(session.getEnt_id());
                            getGoodsDetailIn.setShopCode(cacheModel.getOrder().getShopCode());
                            getGoodsDetailIn.setTerminalNo(cacheModel.getOrder().getTerminalNo());
                            getGoodsDetailIn.setCode(codeInfo.getBarNo());
                            if (getGoodsDetailIn.getCode().length() < 8) {
                                getGoodsDetailIn.setCode(Convert.padLeft(getGoodsDetailIn.getCode(), '0', 8));
                            }
                            getGoodsDetailIn.setSearchType("1");
                            getGoodsDetailIn.setChannel(cacheModel.getOrder().getChannel());
                            getGoodsDetailIn.setErpCode(cacheModel.getOrder().getErpCode());
                            if (isNeedFindMdm) {
                                resp = this.mainDataCentreService.getGoodsFromMDM(this.restTemplate, session, getGoodsDetailIn);
                            }
                        }
                        goodsDetail = (GetGoodsDetailOut)resp.getData();
                        if (goodsDetail.getGoods().size() == 0) {
                            if (!isdzcm && disValue == 0.0 && getGoodsDetailIn.getCode().length() < 13) {
                                getGoodsDetailIn.setCode(Convert.padLeft(getGoodsDetailIn.getCode(), '0', 13));
                            }
                            if (!"0".equals((resp = this.mainDataCentreService.getGoodsFromMDM(this.restTemplate, session, getGoodsDetailIn)).getReturncode())) {
                                object = ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)("\u8bf7\u6c42\u4e3b\u6570\u636e\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5931\u8d25:" + resp.getData().toString()));
                                return object;
                            }
                            goodsDetail = (GetGoodsDetailOut)resp.getData();
                            if (goodsDetail.getGoods().size() == 0) continue;
                        }
                        goodsInfo = goodsDetail.getGoods().get(0);
                        if (goodsDetail.getGoods().size() > 1) {
                            for (GoodsInfo g : goodsDetail.getGoods()) {
                                if (!g.getMainBarcodeFlag()) continue;
                                goodsInfo = g;
                                break;
                            }
                        }
                        if (goodsInfo.getSalePrice() == 0.0) {
                            goodsInfo.setSalePrice(CastUtil.castDouble(saleOrderDetail.get(i).getSalePrice()));
                        }
                        if (isdzcm) {
                            goodsInfo.setEWCCodeAmount(dzc.getDzcmjg());
                            goodsInfo.setEWCCodeNum(dzc.getDzcmsl());
                            goodsInfo.setExpTime(dzc.getExpTime());
                            if (goodsInfo.getSalePrice() == 0.0) {
                                goodsInfo.setSalePrice(dzc.getDzcmjg());
                            }
                        } else if (goodsInfo.getEscaleFlag() == 1) {
                            goodsInfo.setEscaleFlag(0);
                            goodsInfo.setSalePrice(CastUtil.castDouble(saleOrderDetail.get(i).getSalePrice()));
                        }
                        if (goodsInfo.getSalePrice() == 0.0) {
                            goodsInfo.setSalePrice(CastUtil.castDouble(saleOrderDetail.get(i).getSalePrice()));
                        }
                        Goods goods = this.posLogicServiceImpl.CalcGoodsAmountBeforeSingle(goodsInfo, cacheModel.getOrder().getTerminalOperator(), isdzcm, goodsInfo.getEWCCodeNum(), goodsInfo.getEWCCodeAmount(), cacheModel.getEleCodeMode(), saleOrderDetail.get(i).getBarCode(), saleOrderDetail.get(i).getQty());
                        goods.setGoodsNo(originalBarNo);
                        goods.setCalcMode("0");
                        goods.setGuid(UUIDUtils.buildGuid());
                        goods.setFlowNo(cacheModel.getFlowNo());
                        goods.setFlowId(goodsList.size() + 1);
                        LOGGER.info("PRICEMODE=" + priceMode + ",DISVALUE=" + disValue + ",DISMODE=" + disMode + ",SALEAMOUNT=" + goods.getSaleAmount() + ",GOODSNO=" + goods.getGoodsNo());
                        if (priceMode == 2 && ManipulatePrecision.doubleCompare(disValue, 0.0, 2) > 0) {
                            goods = this.posLogicCompoment.calcGoodsBarcodeDiscBeforeSingle(goods, disMode, disValue, discType);
                        }
                        String guid = UUIDUtils.buildGuid();
                        goods.setGuid(guid);
                        goods.setAssistantId(saleOrderDetail.get(i).getAssistantId());
                        goodsList.add(goods);
                        if (!"Y".equals(goods.getEscaleFlag()) || goods.getQty() == saleOrderDetail.get(i).getQty().doubleValue()) continue;
                        for (double m = saleOrderDetail.get(i).getQty() - 1.0; m > 0.0; m -= 1.0) {
                            Goods g = goods.deepClone();
                            goods.setGuid(UUIDUtils.buildGuid());
                            g.setAssistantId(saleOrderDetail.get(i).getAssistantId());
                            g.setFlowId(goodsList.size() + 1);
                            goodsList.add(g);
                        }
                    }
                }
                cacheModel.callMarketClear();
                cacheModel.setGoodsList(goodsList);
                cacheModel = this.posLogicServiceImpl.clearPop(cacheModel);
                if (cacheModel == null || cacheModel.getGoodsList() == null || cacheModel.getOrder() == null) {
                    ServiceResponse i = ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u590d\u5236\u5c0f\u7968\u6e05\u7a7a\u5546\u54c1\u6298\u6263\u4fe1\u606f,\u6ca1\u6709\u83b7\u5f97\u6709\u6548CacheModel");
                    return i;
                }
                if (cacheModel.getPopMode() == 1 || cacheModel.getPopMode() == 3) {
                    cacheModel = this.promotionServiceImpl.calcSinglePopAll(session, "0", cacheModel, true);
                } else if (cacheModel.getPopMode() == 2) {
                    String calcMode = "0";
                    cacheModel = this.promotionServiceImpl.calcOrderPop(session, calcMode, cacheModel, false, false, false);
                } else {
                    this.posLogicCompoment.calcOrderAmount(cacheModel);
                }
                if (cacheModel.getCalcResult() == -1) {
                    String errCode = "100000";
                    if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                        errCode = cacheModel.getErrCode();
                    }
                    ServiceResponse isdzcm = ServiceResponse.buildFailure((ServiceSession)session, (String)errCode, (String)cacheModel.getErrMsg());
                    return isdzcm;
                }
                cacheModel = this.posLogicCompoment.calcGoodsCount(cacheModel);
                cacheModel.getOrder().setTerminalOperatorAuthzCardNo(cacheModel.getCurGrant().getGh());
                this.asyncTask.sendWorkLog(session, cacheModel.getOrder(), WorkLogType.copySno);
                OrderForPos ofp = OrderForPos.toOrderForPosSingle(cacheModel);
                BaseOutModel out = new BaseOutModel();
                out.setOrder(ofp);
                ServiceResponse serviceResponse = ServiceResponse.buildSuccess((Object)out);
                return serviceResponse;
            }
            finally {
                this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stringWriter));
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u590d\u5236\u5c0f\u7968\u9519\u8bef:", (Object[])new Object[]{e.getMessage()});
        }
    }

    public ServiceResponse querySales(ServiceSession session, JSONObject paramsObject) {
        if (!paramsObject.containsKey((Object)"idSheetNo") || paramsObject.getString("idSheetNo").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355\u5168\u91cf\u67e5\u8be2\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u539f\u8ba2\u5355\u53f7"});
        }
        QuerySalesIn querySalesIn = null;
        try {
            querySalesIn = (QuerySalesIn)JSON.parseObject((String)paramsObject.toJSONString(), QuerySalesIn.class);
        }
        catch (Exception e) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355\u5168\u91cf\u67e5\u8be2[{0}]", (Object[])new Object[]{e.getMessage()});
        }
        SearchLocalOrdersIn in = new SearchLocalOrdersIn();
        in.setOrderNo(querySalesIn.getIdSheetNo());
        ServiceResponse orderS = this.orderCentreSerivce.searchLocalOrders(this.restTemplate, session, in);
        if (!orderS.getReturncode().equals("0")) {
            return orderS;
        }
        SearchLocalOrdersOut out = SearchLocalOrdersOut.fromString((String)orderS.getData());
        if (out == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u5168\u91cf\u8ba2\u5355\u5931\u8d25");
        }
        QuerySalesOut querySalesOut = new QuerySalesOut();
        querySalesOut.setSaleOrderInfo(out.getOrderList());
        return ServiceResponse.buildSuccess((Object)querySalesOut);
    }

    @Override
    public ServiceResponse refreshDeliveryInfo(ServiceSession session, JSONObject paramsObject) {
        RefreshDeliveryInfoIn refreshDeliveryInfoIn = null;
        try {
            if (!paramsObject.containsKey((Object)"logisticsMode")) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u83b7\u53d6\u652f\u4ed8\u5c3e\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u914d\u9001\u65b9\u5f0f"});
            }
            refreshDeliveryInfoIn = (RefreshDeliveryInfoIn)JSON.parseObject((String)paramsObject.toJSONString(), RefreshDeliveryInfoIn.class);
        }
        catch (Exception e) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u914d\u9001\u4fe1\u606f\u66f4\u65b0[{0}]", (Object[])new Object[]{e.getMessage()});
        }
        String flowNo = refreshDeliveryInfoIn.getFlowNo();
        CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(flowNo);
        if (cacheModel == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355", (Object[])new Object[]{flowNo});
        }
        if (StringUtils.isNotBlank((String)cacheModel.getOrder().getInvoiceTitle())) {
            this.updateQuota(session, cacheModel, -1);
        }
        if (refreshDeliveryInfoIn.getLogisticsMode() == 0) {
            cacheModel.getOrder().setLogisticsMode(7);
        } else {
            cacheModel.getOrder().setLogisticsMode(refreshDeliveryInfoIn.getLogisticsMode());
        }
        cacheModel.getOrder().setReceiverMobile(refreshDeliveryInfoIn.getReceiverMobile());
        cacheModel.getOrder().setReceiverName(refreshDeliveryInfoIn.getReceiverName());
        cacheModel.getOrder().setReceiverPhone(refreshDeliveryInfoIn.getReceiverPhone());
        cacheModel.getOrder().setReserveLocation(refreshDeliveryInfoIn.getReserveLocation());
        cacheModel.getOrder().setDeliveryTime(refreshDeliveryInfoIn.getDeliveryTime());
        cacheModel.getOrder().setOutLocation(refreshDeliveryInfoIn.getOutLocation());
        cacheModel.getOrder().setExpressNumber(refreshDeliveryInfoIn.getExpressNumber());
        cacheModel.getOrder().setReceiverStandbyPhone(refreshDeliveryInfoIn.getReceiverStandbyPhone());
        cacheModel.getOrder().setReceiverDistrict(refreshDeliveryInfoIn.getReceiverDistrict());
        cacheModel.getOrder().setReceiverStreet(refreshDeliveryInfoIn.getReceiverStreet());
        cacheModel.getOrder().setReceiverAddress(refreshDeliveryInfoIn.getReceiverAddress());
        cacheModel.getOrder().setDeliveryStartTime(refreshDeliveryInfoIn.getDeliveryStartTime());
        cacheModel.getOrder().setDeliveryEndTime(refreshDeliveryInfoIn.getDeliveryEndTime());
        cacheModel.getOrder().setInvoiceTitle(refreshDeliveryInfoIn.getInvoiceTitle());
        if (StringUtils.isNotBlank((String)cacheModel.getOrder().getInvoiceTitle())) {
            if (SellType.ISBACK(cacheModel.getOrder().getOrderType())) {
                this.updateQuota(session, cacheModel, -1);
            } else {
                this.updateQuota(session, cacheModel, 1);
            }
        }
        this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
        OrderForPos ofp = OrderForPos.toOrderForPos(cacheModel);
        return ServiceResponse.buildSuccess((Object)ofp);
    }

    public ServiceResponse synQuery(ServiceSession session, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        SynQueryOrderIn synQueryOrderIn = (SynQueryOrderIn)JSON.parseObject((String)paramsObject.toJSONString(), SynQueryOrderIn.class);
        ServiceResponse response = this.orderCentreSerivce.synQueryOrder(this.restTemplate, session, synQueryOrderIn);
        SynQueryOrderOut synQueryOrderOut = new SynQueryOrderOut();
        synQueryOrderOut.setOrderIsEnd(response.getReturncode());
        if (!"0".equals(response.getReturncode())) {
            synQueryOrderOut.setOrderIsEnd("1");
        }
        return ServiceResponse.buildSuccess((Object)synQueryOrderOut);
    }

    public ServiceResponse getSynCount(ServiceSession session, JSONObject paramsObject) {
        GetSyncDataCount getSyncDataCount;
        JSONObject json;
        JSONObject result = new JSONObject();
        if (!"0".equals(this.routeMode)) {
            LOGGER.info("..............  \u8bf7\u6c42\u5728\u7ebf\u6216\u524d\u7f6e\u63a5\u53e3\uff08\u672a\u7ecf\u8fc7\u672c\u5730\u8def\u7531\uff09\uff0c\u65e0\u9700\u540c\u6b65\u6570\u636e..........");
            result.put("synflag", (Object)"1");
            result.put("retmsg", (Object)"\u8bf7\u6c42\u5728\u7ebf\u6216\u524d\u7f6e\u63a5\u53e3\uff08\u672a\u7ecf\u8fc7\u672c\u5730\u8def\u7531\uff09\uff0c\u65e0\u9700\u540c\u6b65\u6570\u636e");
            result.put("command_id", paramsObject.get((Object)"command_id"));
            return ServiceResponse.buildSuccess((Object)result);
        }
        ServiceResponse response = this.cartServiceImpl.synTradeNo(session, paramsObject);
        if (response != null && "0".equals(response.getReturncode()) && (json = (JSONObject)response.getData()).containsKey((Object)"total") && json.getInteger("total") > 0) {
            result.put("synflag", (Object)"0");
            result.put("retmsg", (Object)"\u8ba2\u5355\u4e2d\u5fc3\u79bb\u7ebf\u6709\u65b0\u589e\u6570\u636e\u6570\u636e");
            result.put("command_id", paramsObject.get((Object)"command_id"));
            LOGGER.info(" ... \u8ba2\u5355\u4e2d\u5fc3\u79bb\u7ebf\u6709\u65b0\u589e\u6570\u636e\u6570\u636e ...");
            return ServiceResponse.buildSuccess((Object)result);
        }
        ServiceResponse response2 = this.posManagerService.getPosCenterSyncDataCount(this.restTemplate, session, null);
        if (response2 != null && "0".equals(response2.getReturncode()) && (getSyncDataCount = (GetSyncDataCount)response2.getData()).getRetflag().equals("1")) {
            result.put("synflag", (Object)"0");
            result.put("retmsg", (Object)"POS\u603b\u90e8\u79bb\u7ebf\u6709\u65b0\u589e\u6570\u636e\u6570\u636e");
            result.put("command_id", paramsObject.get((Object)"command_id"));
            LOGGER.info(" ... POS\u603b\u90e8\u79bb\u7ebf\u6709\u65b0\u589e\u6570\u636e\u6570\u636e ...");
            return ServiceResponse.buildSuccess((Object)result);
        }
        result.put("synflag", (Object)"1");
        result.put("retmsg", (Object)"\u65e0\u65b0\u589e\u6570\u636e\u6570\u636e");
        result.put("command_id", paramsObject.get((Object)"command_id"));
        return ServiceResponse.buildSuccess((Object)result);
    }

    public ServiceResponse posCenterSynData(ServiceSession session, JSONObject paramsObject) {
        JSONObject json = new JSONObject();
        json.put("status", (Object)"success");
        if (!"0".equals(this.routeMode)) {
            LOGGER.info("..............  \u8bf7\u6c42\u5728\u7ebf\u6216\u524d\u7f6e\u63a5\u53e3 - posCenterSynData\uff08\u672a\u7ecf\u8fc7\u672c\u5730\u8def\u7531\uff09\uff0c\u65e0\u9700\u540c\u6b65\u6570\u636e..........");
            return ServiceResponse.buildSuccess((Object)json);
        }
        String uuid = paramsObject.getString("uuid");
        LOGGER.info(".............. posCenterSynData --> uuid =" + uuid);
        if (StringUtils.isEmpty((String)uuid)) {
            uuid = "upload:test";
        }
        this.opsForValue.set((Object)uuid, (Object)"start", 1800L, TimeUnit.SECONDS);
        int pageSize = 1000;
        int resultNum = 0;
        QuerySyncDataIn in = new QuerySyncDataIn();
        UpdatePosCenterSynStatus updateIn = new UpdatePosCenterSynStatus();
        ServiceResponse response = new ServiceResponse();
        block4: for (int j = 0; j < 8; ++j) {
            if ("stop".equals(this.opsForValue.get((Object)(uuid + ":status")))) {
                LOGGER.info("......  pos\u603b\u90e8\u540c\u6b65\u79bb\u7ebf\u6570\u636e\u7a0b\u5e8f-\u300b\u68c0\u6d4b\u5230redis\u4e2d\u6709\u7ec8\u6b62\u540c\u6b65\u6807\u5fd7, \u9a6c\u4e0a\u9000\u51fa\u540c\u6b65");
                break;
            }
            updateIn.setTableFlag(String.valueOf(j));
            if (j == 0) {
                in.setTable("payinhead");
                in.setPageSize(pageSize);
                in.setPageNo(1);
                in.setBatchNo("");
            } else if (j == 1) {
                in.setTable("payindetail");
                in.setPageSize(pageSize);
                in.setPageNo(1);
                in.setBatchNo("");
            } else if (j == 2) {
                in.setTable("posworklog");
                in.setPageSize(pageSize);
                in.setPageNo(1);
                in.setBatchNo("");
            } else if (j == 3) {
                in.setTable("syjmainlog");
                in.setPageSize(pageSize);
                in.setPageNo(1);
                in.setBatchNo("");
            } else if (j == 4) {
                in.setTable("syjcashlog");
                in.setPageSize(pageSize);
                in.setPageNo(1);
                in.setBatchNo("");
            } else if (j == 5) {
                in.setTable("syjcashdetail");
                in.setPageSize(pageSize);
                in.setPageNo(1);
                in.setBatchNo("");
            } else if (j == 6) {
                in.setTable("posworkacount");
                in.setPageSize(pageSize);
                in.setPageNo(1);
                in.setBatchNo("");
            } else if (j == 7) {
                in.setTable("changeposmodelog");
                in.setPageSize(pageSize);
                in.setPageNo(1);
                in.setBatchNo("");
            }
            int send_tryCount = 0;
            int update_tryCount = 0;
            QuerySyncDataOut posCenterSynOut = new QuerySyncDataOut();
            posCenterSynOut = this.getPosCenterSynData(this.restTemplate, session, in);
            if (null != posCenterSynOut) {
                resultNum = posCenterSynOut.getTotalResults();
                String batchNo = posCenterSynOut.getBatchNo();
                if (resultNum <= 0) continue;
                try {
                    response = this.posManagerService.sendPosCenterSyncData(this.restTemplate, session, posCenterSynOut);
                    if (response != null && "0".equals(response.getReturncode())) {
                        LOGGER.info("................... \u5df2\u4e0a\u4f20-\u300b" + in.getTable() + ", \u6761\u6570: " + resultNum);
                        updateIn.setBatchNo(batchNo);
                        response = this.posManagerService.updatePosCenterSynStatus(this.restTemplate, session, updateIn);
                        if (response != null && "0".equals(response.getReturncode())) {
                            LOGGER.info("................... \u5df2\u66f4\u65b0-\u300b" + in.getTable() + ", \u6761\u6570: " + resultNum);
                        } else {
                            ++update_tryCount;
                        }
                    } else {
                        ++send_tryCount;
                    }
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
                while (resultNum > 0) {
                    try {
                        if ("stop".equals(this.opsForValue.get((Object)(uuid + ":status")))) {
                            LOGGER.info("......  pos\u603b\u90e8\u540c\u6b65\u79bb\u7ebf\u6570\u636e\u7a0b\u5e8f-\u300b\u68c0\u6d4b\u5230redis\u4e2d\u6709\u7ec8\u6b62\u540c\u6b65\u6807\u5fd7, \u9a6c\u4e0a\u9000\u51fa\u540c\u6b65");
                            continue block4;
                        }
                        in.setPageNo(1);
                        in.setPageSize(pageSize);
                        posCenterSynOut = this.getPosCenterSynData(this.restTemplate, session, in);
                        if (null != posCenterSynOut) {
                            resultNum = posCenterSynOut.getTotalResults();
                            response = this.posManagerService.sendPosCenterSyncData(this.restTemplate, session, posCenterSynOut);
                            if (response != null && "0".equals(response.getReturncode())) {
                                LOGGER.info("................... \u5df2\u4e0a\u4f20-\u300b" + in.getTable() + ", \u6761\u6570: " + resultNum);
                                batchNo = posCenterSynOut.getBatchNo();
                                updateIn.setBatchNo(batchNo);
                                response = this.posManagerService.updatePosCenterSynStatus(this.restTemplate, session, updateIn);
                                if (response != null && "0".equals(response.getReturncode())) {
                                    LOGGER.info("................... \u5df2\u66f4\u65b0-\u300b" + in.getTable() + ", \u6761\u6570: " + resultNum);
                                    continue;
                                }
                                if (++update_tryCount < 3) continue;
                                LOGGER.info("................... \u8c03\u7528\u672c\u5730\u66f4\u65b0pos\u603b\u90e8\u6570\u636e\u72b6\u6001\u63a5\u53e3\u8d85\u8fc7:{} \u6b21\uff0c\u9000\u51fa\u540c\u6b65\u63a5\u53e3", (Object)update_tryCount);
                                continue block4;
                            }
                            if (++send_tryCount < 3) continue;
                            LOGGER.info("................... \u8c03\u7528\u4e0a\u4f20pos\u603b\u90e8\u6570\u636e\u63a5\u53e3\u8d85\u8fc7:{} \u6b21\uff0c\u9000\u51fa\u540c\u6b65\u63a5\u53e3", (Object)send_tryCount);
                            continue block4;
                        }
                        resultNum = 0;
                    }
                    catch (Exception e) {
                        LOGGER.error(e.getMessage(), (Throwable)e);
                        if (++send_tryCount < 3) continue;
                        LOGGER.info("................... \u8c03\u7528\u4e0a\u4f20pos\u603b\u90e8\u6570\u636e\u63a5\u53e3\u8d85\u8fc7:{} \u6b21\uff0c\u9000\u51fa\u540c\u6b65\u63a5\u53e3", (Object)send_tryCount);
                        continue block4;
                    }
                }
                continue;
            }
            LOGGER.info("................... \u8868-\u300b" + in.getTable() + "\u65e0\u4e0a\u4f20\u79bb\u7ebf\u8d44\u6599!");
        }
        LOGGER.info("................... \u672c\u6b21poscenter \u540c\u6b65\u5b8c\u6bd5 ............");
        this.opsForValue.set((Object)uuid, (Object)"finish");
        return ServiceResponse.buildSuccess((Object)json);
    }

    public ServiceResponse posCenterSynData_bak(ServiceSession session, JSONObject paramsObject) {
        int resultNum = 0;
        QuerySyncDataIn in = new QuerySyncDataIn();
        ServiceResponse response = new ServiceResponse();
        for (int j = 0; j < 5; ++j) {
            if (j == 0) {
                in.setTable("payinhead");
                in.setPageSize(1000);
                in.setPageNo(1);
                in.setBatchNo("");
            } else if (j == 1) {
                in.setTable("payindetail");
                in.setPageSize(1000);
                in.setPageNo(1);
                in.setBatchNo("");
            } else if (j == 2) {
                in.setTable("posupdatestamp");
                in.setPageSize(1000);
                in.setPageNo(1);
                in.setBatchNo("");
            } else if (j == 3) {
                in.setTable("posworklog");
                in.setPageSize(1000);
                in.setPageNo(1);
                in.setBatchNo("");
            } else if (j == 4) {
                in.setTable("syjmainlog");
                in.setPageSize(1000);
                in.setPageNo(1);
                in.setBatchNo("");
            }
            QuerySyncDataOut posCenterSynOut = new QuerySyncDataOut();
            posCenterSynOut = this.getPosCenterSynData(this.restTemplate, session, in);
            if (null != posCenterSynOut) {
                int loop;
                boolean isNeedEdit = true;
                resultNum = posCenterSynOut.getTotalResults();
                String batchNo = posCenterSynOut.getBatchNo();
                if (resultNum <= 0) continue;
                response = this.posManagerService.sendPosCenterSyncData(this.restTemplate, session, posCenterSynOut);
                if (!"0".equals(response.getReturncode())) {
                    isNeedEdit = false;
                }
                if ((loop = (resultNum + 999) / 1000) > 1) {
                    for (int i = 1; i < loop; ++i) {
                        in.setBatchNo(batchNo);
                        in.setPageNo(i + 1);
                        in.setPageSize(100);
                        posCenterSynOut = this.getPosCenterSynData(this.restTemplate, session, in);
                        if (null == posCenterSynOut || "0".equals((response = this.posManagerService.sendPosCenterSyncData(this.restTemplate, session, posCenterSynOut)).getReturncode())) continue;
                        isNeedEdit = false;
                    }
                }
                if (!isNeedEdit) continue;
                UpdatePosCenterSynStatus updateIn = new UpdatePosCenterSynStatus();
                updateIn.setBatchNo(batchNo);
                response = this.posManagerService.updatePosCenterSynStatus(this.restTemplate, session, updateIn);
                continue;
            }
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u67e5\u8be2POS\u603b\u90e8\u5f85\u4e0a\u4f20\u6570\u636e\u5931\u8d25");
        }
        return ServiceResponse.buildSuccess((Object)"");
    }

    public QuerySyncDataOut getPosCenterSynData(RestTemplate restTemplate, ServiceSession session, QuerySyncDataIn in) {
        ServiceResponse response = this.posManagerService.getPosCenterSyncData(restTemplate, session, in);
        if (!"0".equals(response.getReturncode())) {
            return null;
        }
        return (QuerySyncDataOut)response.getData();
    }

    public ServiceResponse synSales(ServiceSession session, JSONObject paramsObject) {
        if (!paramsObject.containsKey((Object)"saleOrderInfo") || paramsObject.getJSONArray("saleOrderInfo").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355\u5168\u91cf\u63a5\u6536\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u8ba2\u5355\u4fe1\u606f"});
        }
        SynSalesIn synSalesIn = null;
        try {
            synSalesIn = (SynSalesIn)JSON.parseObject((String)paramsObject.toJSONString(), SynSalesIn.class);
        }
        catch (Exception e) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355\u5168\u91cf\u63a5\u6536[{0}]", (Object[])new Object[]{e.getMessage()});
        }
        SyncLocalOrderIn in = new SyncLocalOrderIn();
        in.setSyncOrder(synSalesIn.getSaleOrderInfo());
        ServiceResponse response = this.orderCentreSerivce.synchroFromPos(this.restTemplate, session, in);
        return response;
    }

    private boolean excuteZuul(String returnCode, String orderNo, String type) {
        boolean reverseStata = false;
        switch (returnCode) {
            case "0": {
                break;
            }
            case "1": {
                String billDate = "";
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    billDate = sdf.format(new Date());
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.syncTradeServiceImpl.addSyncTrade(orderNo, type, billDate);
                break;
            }
            case "2": {
                reverseStata = true;
                break;
            }
            default: {
                reverseStata = true;
            }
        }
        return reverseStata;
    }

    public ServiceResponse queryGiveRule(ServiceSession session, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        QueryGiveRuleIn queryGiveRuleIn = (QueryGiveRuleIn)JSONObject.toJavaObject((JSON)paramsObject, QueryGiveRuleIn.class);
        GetGiveRuleIn getGiveRuleIn = GetGiveRuleIn.transferByQueryGiveRuleIn(queryGiveRuleIn);
        ServiceResponse getGiveRuleRes = this.promotionCentreService.getGiveRule(this.restTemplate, session, getGiveRuleIn);
        if (!getGiveRuleRes.getReturncode().equals("0")) {
            return getGiveRuleRes;
        }
        GetGiveRuleOut getGiveRuleOut = (GetGiveRuleOut)getGiveRuleRes.getData();
        QueryGiveRuleOut queryGiveRuleOut = QueryGiveRuleOut.transferGetGiveRuleOut(getGiveRuleOut);
        return ServiceResponse.buildSuccess((Object)queryGiveRuleOut);
    }

    public ServiceResponse orderSetEatWay(ServiceSession session, JSONObject paramsObject) {
        List<Goods> goodsList;
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        String flowNo = paramsObject.getString("flowNo");
        CacheModel cm = this.cacheModelService.getCacheModelByFlowNo(flowNo);
        if (null == cm) {
            ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"flowNo=[{0}]\u4e0d\u5b58\u5728", (Object[])new Object[]{flowNo});
        }
        if (null == (goodsList = cm.getGoodsList()) || goodsList.isEmpty()) {
            ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"flowNo=[{0}]\uff0c\u6ca1\u6709\u5546\u54c1", (Object[])new Object[]{flowNo});
        }
        if (cm.getOrder().getEatWay() == 1) {
            cm.getOrder().setEatWay(2);
            for (Goods goods : goodsList) {
                goods.setEatWay(2);
            }
        } else {
            cm.getOrder().setEatWay(1);
            for (Goods goods : goodsList) {
                goods.setEatWay(1);
            }
        }
        cm.setGoodsList(goodsList);
        this.cacheModelService.saveOrUpdateCacheModel(cm);
        OrderForPos ofp = new OrderForPos();
        ofp.setEatWay(cm.getOrder().getEatWay());
        return ServiceResponse.buildSuccess((Object)ofp);
    }

    private boolean sendEleStamp(ServiceSession session, double eleStampNum, CacheModel cacheModel, String transactionType) {
        try {
            String stampOwnerID = cacheModel.getOrder().getConsumersData().getConsumersCard();
            String memberId = cacheModel.getOrder().getConsumersData().getConsumersId();
            String receiptNo = cacheModel.getOrder().getTerminalSno();
            receiptNo = receiptNo.substring(receiptNo.length() - 7, receiptNo.length());
            if (stampOwnerID != null && !"".equals(stampOwnerID.trim())) {
                UpdateStampIn in = new UpdateStampIn();
                in.setQuantity((int)eleStampNum);
                in.setMemberId(memberId);
                in.setTransactionType(transactionType);
                in.setReceiptNo(receiptNo);
                in.setRedeemItem("");
                if (eleStampNum > 0.0) {
                    in.setFlag("1");
                } else {
                    in.setFlag("0");
                }
                in.setRegisterId(cacheModel.getOrder().getTerminalNo());
                in.setStoreCode(cacheModel.getOrder().getShopCode());
                ServiceResponse resp = this.aeonIBMACMService.updateStamp(this.restTemplate, session, in);
                if (!"0".equals(resp.getReturncode())) {
                    cacheModel.getOrder().setStampStatus("P");
                    return false;
                }
                UpdateStampOut updateOut = (UpdateStampOut)resp.getData();
                if ("1".equals(updateOut.getCallstatus())) {
                    cacheModel.getOrder().setStampStatus("S");
                } else {
                    cacheModel.getOrder().setStampStatus("P");
                }
                return true;
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean sendEleStamp(ServiceSession session, double stampNum, CacheModel cacheModel, String transactionType, StampExchangeInfo stampInfo, String flag) {
        try {
            String stampOwnerID = cacheModel.getOrder().getConsumersData().getConsumersCard();
            String memberId = cacheModel.getOrder().getConsumersData().getConsumersId();
            String receiptNo = cacheModel.getOrder().getTerminalSno();
            receiptNo = receiptNo.substring(receiptNo.length() - 7, receiptNo.length());
            if (stampOwnerID != null && !"".equals(stampOwnerID.trim())) {
                ServiceResponse resp;
                UpdateStampIn in = new UpdateStampIn();
                in.setQuantity((int)stampNum);
                in.setMemberId(memberId);
                in.setTransactionType(transactionType);
                in.setReceiptNo(receiptNo);
                in.setRedeemItem("");
                if (stampNum > 0.0) {
                    in.setFlag("1");
                } else {
                    in.setFlag("0");
                }
                if (null != flag && flag.length() > 0) {
                    in.setFlag(flag);
                }
                in.setRegisterId(cacheModel.getOrder().getTerminalNo());
                in.setStoreCode(cacheModel.getOrder().getShopCode());
                if ("R".equals(transactionType)) {
                    if (null == stampInfo) {
                        return false;
                    }
                    String barcode = CastUtil.castAeonGoodsCode("210" + Convert.padLeft(stampInfo.getItemCode(), '0', 9));
                    in.setRedeemItem(barcode);
                    in.setRedeemQty(1.0);
                }
                if (!"0".equals((resp = this.aeonIBMACMService.updateStamp(this.restTemplate, session, in)).getReturncode())) {
                    return false;
                }
                UpdateStampOut updateOut = (UpdateStampOut)resp.getData();
                if ("1".equals(updateOut.getCallstatus())) {
                    cacheModel.getOrder().setStampStatus("S");
                } else {
                    cacheModel.getOrder().setStampStatus("P");
                }
                return true;
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public List<SysPara> getSyspara(ServiceSession session, List<String> code, String erpCode, String shopCode) {
        SysparaIn sysparaIn = new SysparaIn();
        sysparaIn.setCode(code);
        sysparaIn.setErpCode(erpCode);
        sysparaIn.setMkt(shopCode);
        ServiceResponse response = this.posManagerService.getSyspara(this.restTemplate, session, sysparaIn);
        if (!"0".equals(response.getReturncode())) {
            return new ArrayList<SysPara>();
        }
        SysparaOut sysparaOut = (SysparaOut)response.getData();
        if (sysparaOut == null || sysparaOut.getSyspara() == null || sysparaOut.getSyspara().size() < 1) {
            return new ArrayList<SysPara>();
        }
        ArrayList<SysPara> list = new ArrayList<SysPara>();
        for (int i = 0; i < sysparaOut.getSyspara().size(); ++i) {
            SysPara newPara = new SysPara();
            newPara.setCode(sysparaOut.getSyspara().get(i).getCode());
            newPara.setValue(sysparaOut.getSyspara().get(i).getParaValue());
            list.add(newPara);
        }
        return list;
    }

    public ServiceResponse changeOrderType(ServiceSession session, JSONObject paramsObject) {
        ChangeOrderTypeIn in = (ChangeOrderTypeIn)JSON.parseObject((String)paramsObject.toJSONString(), ChangeOrderTypeIn.class);
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        if (StringUtils.isBlank((String)paramsObject.getString("orderType"))) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4fee\u6539\u8ba2\u5355\u7c7b\u578b\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u8ba2\u5355\u7c7b\u578b"});
        }
        CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(in.getFlowNo());
        if (cacheModel == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355", (Object[])new Object[]{in.getFlowNo()});
        }
        if (!cacheModel.getOrder().getAllowEditGoods()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u8fdb\u5165\u652f\u4ed8\u73af\u8282\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u8ba2\u5355\u4fe1\u606f", (Object[])new Object[]{in.getFlowNo()});
        }
        if (cacheModel.getOrder().getSendSuccess()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u6210\u4ea4\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u8ba2\u5355\u4fe1\u606f", (Object[])new Object[]{in.getFlowNo()});
        }
        if (cacheModel.getGoodsList().size() > 0) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u6709\u5546\u54c1\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u8ba2\u5355\u4fe1\u606f", (Object[])new Object[]{in.getFlowNo()});
        }
        cacheModel.getOrder().setOrderType(in.getOrderType());
        OrderForPos ofp = OrderForPos.toOrderForPos(cacheModel);
        this.posLogicServiceImpl.calcOrderAmount(cacheModel);
        cacheModel = this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
        ofp.setSaleValue(0.0);
        ofp.setTotalDiscountValue(0.0);
        ofp.setOughtPay(0.0);
        BaseOutModel out = new BaseOutModel();
        out.setOrder(ofp);
        return ServiceResponse.buildSuccess((Object)out);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ServiceResponse changeOrderSno(ServiceSession session, JSONObject paramsObject) {
        ChangeOrderSnoIn in = (ChangeOrderSnoIn)JSON.parseObject((String)paramsObject.toJSONString(), ChangeOrderSnoIn.class);
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        if (StringUtils.isBlank((String)paramsObject.getString("terminalSno"))) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4fee\u6539\u8ba2\u5355\u7c7b\u578b\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u5c0f\u7968\u53f7"});
        }
        CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(in.getFlowNo());
        if (cacheModel == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355", (Object[])new Object[]{in.getFlowNo()});
        }
        if (!cacheModel.getOrder().getAllowEditGoods()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u8fdb\u5165\u652f\u4ed8\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u5c0f\u7968\u53f7", (Object[])new Object[]{in.getFlowNo()});
        }
        if (cacheModel.getOrder().getSendSuccess()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u6210\u4ea4\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u8ba2\u5355\u4fe1\u606f", (Object[])new Object[]{in.getFlowNo()});
        }
        cacheModel.getOrder().setTerminalSno(in.getTerminalSno());
        LocalDateTime dateTime = LocalDateTime.now();
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        String nowDateTime = dateTime.format(df).toString();
        if (in.getType() == 1) {
            Order order = cacheModel.getOrder();
            cacheModel.getOrder().setSaleExtractTime(nowDateTime);
            if (in.getTerminalOperator().equals(order.getTerminalOperator())) {
                cacheModel.setCurGrant(cacheModel.getCurSyyInfo());
            } else {
                OperUserIn posManagerOperUserIn = new OperUserIn();
                posManagerOperUserIn.setErpCode(order.getErpCode());
                posManagerOperUserIn.setCardno(in.getTerminalOperator());
                posManagerOperUserIn.setMkt(in.getShopCode());
                posManagerOperUserIn.setSyjh(in.getTerminalNo());
                posManagerOperUserIn.setFlag("N");
                ServiceResponse response = this.posManagerService.getOperUser(this.restTemplate, session, posManagerOperUserIn);
                if (!"0".equals(response.getReturncode())) return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5f53\u524d\u6536\u94f6\u5458\u6216\u6388\u6743\u4eba\u5458\u4fe1\u606f\u65e0\u6cd5\u627e\u5230");
                OperUserOut operUserOut = (OperUserOut)response.getData();
                if (operUserOut.getOperuser() == null || operUserOut.getPosrole() == null) {
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5f53\u524d\u6536\u94f6\u5458\u6216\u6388\u6743\u4eba\u5458\u4fe1\u606f\u4e0d\u5b8c\u6574");
                }
                OperUser operUser = new OperUser(operUserOut);
                cacheModel.setCurSyyInfo(operUser);
                cacheModel.setCurGrant(operUser);
            }
        } else {
            cacheModel.getOrder().setSaleDate(nowDateTime);
            cacheModel.getOrder().setSaleExtractTime(nowDateTime);
        }
        cacheModel.getOrder().setTerminalOperator(in.getTerminalOperator());
        if (StringUtils.isNotBlank((String)in.getAccreditNo())) {
            OperUserIn posManagerOperUserIn = new OperUserIn();
            posManagerOperUserIn.setErpCode(cacheModel.getOrder().getErpCode());
            posManagerOperUserIn.setCardno(in.getAccreditNo());
            posManagerOperUserIn.setMkt(in.getShopCode());
            posManagerOperUserIn.setFlag("N");
            posManagerOperUserIn.setSyjh(in.getTerminalNo());
            ServiceResponse response = this.posManagerService.getOperUser(this.restTemplate, session, posManagerOperUserIn);
            if (!"0".equals(response.getReturncode())) return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5f53\u524d\u6536\u94f6\u5458\u6216\u6388\u6743\u4eba\u5458\u4fe1\u606f\u65e0\u6cd5\u627e\u5230");
            OperUserOut posManagerOperUserOut = (OperUserOut)response.getData();
            if (posManagerOperUserOut.getOperuser() == null || posManagerOperUserOut.getPosrole() == null) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5f53\u524d\u6536\u94f6\u5458\u6216\u6388\u6743\u4eba\u5458\u4fe1\u606f\u4e0d\u5b8c\u6574");
            }
            OperUser operUser = new OperUser(posManagerOperUserOut);
            cacheModel.setCurGrant(operUser);
            if (SellType.ISBACK(cacheModel.getOrder().getOrderType())) {
                if (!posManagerOperUserOut.getPosrole().getPrivth().equals("Y")) {
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5f53\u524d\u6536\u94f6\u5458\u6216\u6388\u6743\u4eba\u5458\u6ca1\u6709\u9000\u8d27\u6743\u9650");
                }
                cacheModel.getOrder().setRefundAuthzCardNo(operUser.getGh());
            }
        }
        if (cacheModel.getPayments().size() > 0) {
            for (Payment p : cacheModel.getPayments()) {
                p.setTerminalSno(in.getTerminalSno());
            }
        }
        if (cacheModel.getGoodsList() != null && cacheModel.getGoodsList().size() > 0) {
            double tempZZk = cacheModel.getOrder().getTempZzk();
            double tempZZr = cacheModel.getOrder().getTempZzr();
            CalcsingleIn calcsingleIn = CalcsingleIn.terminalSnoChangeCreateCalcsingleIn(cacheModel.getOrder(), cacheModel.getGoodsList());
            ServiceResponse callCalcsingleResponse = this.promotionCentreService.callCalcsingle(this.restTemplate, session, calcsingleIn);
            if (!"0".equals(callCalcsingleResponse.getReturncode())) {
                return callCalcsingleResponse;
            }
            CalcsingleOut calcsingleOut = (CalcsingleOut)callCalcsingleResponse.getData();
            cacheModel.getOrder().setSeqNo(calcsingleOut.getCalcBillid());
            cacheModel = this.posLogicServiceImpl.CalcGoodsAmountAfterSingleAll(cacheModel, calcsingleOut, true);
            LOGGER.info("TempZZr:" + tempZZr);
            if (tempZZk != 100.0) {
                cacheModel = this.posLogicCompoment.CalcOrderRebateByRate(cacheModel, cacheModel.getCurGrant().getGh(), tempZZk);
            }
            if (tempZZr != 0.0) {
                cacheModel = this.posLogicCompoment.CalcOrderRebateByAmount(cacheModel, cacheModel.getCurGrant().getGh(), tempZZr);
            }
        }
        if (StringUtils.isNotBlank((String)in.getExerciseMode())) {
            cacheModel.getOrder().setExerciseMode(in.getExerciseMode());
        }
        this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
        OrderForPos ofp = OrderForPos.toOrderForPosSingle(cacheModel);
        BaseOutModel out = new BaseOutModel();
        out.setOrder(ofp);
        return ServiceResponse.buildSuccess((Object)out);
    }

    public CacheModel addOveragePopDetail(ServiceSession session, CacheModel cacheModel, boolean isNeedCalc) {
        int maxDiscRow = 0;
        int maxAmountRow = 0;
        double maxAmount = 0.0;
        double maxDisc = 0.0;
        int i = 0;
        int j = cacheModel.getGoodsList().size();
        for (i = 0; i < j; ++i) {
            if (cacheModel.getGoodsList().get(i).getTotalDiscountValue() > maxDisc && cacheModel.getGoodsList().get(i).getSaleAmount() > cacheModel.getOrder().getRoundUpOverageValue()) {
                maxDisc = cacheModel.getGoodsList().get(i).getTotalDiscountValue();
                maxDiscRow = i;
            }
            if (!(cacheModel.getGoodsList().get(i).getSaleAmount() > maxAmount) || !(cacheModel.getGoodsList().get(i).getSaleAmount() > cacheModel.getOrder().getRoundUpOverageValue())) continue;
            maxAmount = cacheModel.getGoodsList().get(i).getSaleAmount();
            maxAmountRow = i;
        }
        if (maxDisc > 0.0) {
            PopDetail pop = new PopDetail();
            pop.setDiscountAmount(cacheModel.getOrder().getRoundUpOverageValue());
            pop.setPopMode("0");
            pop.setPopPolicyGroup(YPopStatusType.pop_policy_group_overage);
            pop.setPopPolicyType(YPopStatusType.pop_type_overage);
            pop.setPopDescribe("[ROUNDING]");
            pop.setGoodsRow(maxDiscRow + 1);
            Goods good = cacheModel.getGoodsList().get(maxDiscRow);
            good.getPopDetailsInfo().add(pop);
            good.setPopDiscountValue(ManipulatePrecision.doubleConvert(good.getPopDiscountValue() + cacheModel.getOrder().getRoundUpOverageValue(), 2, 1));
            good.setTotalDiscountValue(ManipulatePrecision.doubleConvert(good.getTotalDiscountValue() + cacheModel.getOrder().getRoundUpOverageValue(), 2, 1));
            good.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(good.getTotalDiscountValue() - good.getNoDisAmountValue()));
            good.setSaleAmount(good.getSaleAmount() - cacheModel.getOrder().getRoundUpOverageValue());
            cacheModel.getGoodsList().set(maxDiscRow, good);
        } else if (maxAmount > 0.0) {
            PopDetail pop = new PopDetail();
            pop.setDiscountAmount(cacheModel.getOrder().getRoundUpOverageValue());
            pop.setPopMode("0");
            pop.setPopPolicyGroup(YPopStatusType.pop_policy_group_overage);
            pop.setPopPolicyType(YPopStatusType.pop_type_overage);
            pop.setPopDescribe("[ROUNDING]");
            pop.setGoodsRow(maxAmountRow + 1);
            Goods good = cacheModel.getGoodsList().get(maxAmountRow);
            good.getPopDetailsInfo().add(pop);
            good.setPopDiscountValue(good.getPopDiscountValue() + cacheModel.getOrder().getRoundUpOverageValue());
            good.setTotalDiscountValue(good.getTotalDiscountValue() + cacheModel.getOrder().getRoundUpOverageValue());
            good.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(good.getTotalDiscountValue() - good.getNoDisAmountValue()));
            good.setSaleAmount(good.getSaleAmount() - cacheModel.getOrder().getRoundUpOverageValue());
            cacheModel.getGoodsList().set(maxAmountRow, good);
        } else {
            Collections.sort(cacheModel.getGoodsList(), Goods.saleAmountComparator);
            double overage = cacheModel.getOrder().getRoundUpOverageValue();
            for (Goods sg : cacheModel.getGoodsList()) {
                PopDetail pop;
                if (overage > sg.getSaleAmount()) {
                    pop = new PopDetail();
                    pop.setDiscountAmount(sg.getSaleAmount());
                    pop.setPopMode("0");
                    pop.setPopPolicyGroup(YPopStatusType.pop_policy_group_overage);
                    pop.setPopPolicyType(YPopStatusType.pop_policy_group_overage);
                    pop.setPopDescribe("[ROUNDING]");
                    pop.setGoodsRow(sg.getFlowId());
                    overage -= sg.getSaleAmount();
                    sg.getPopDetailsInfo().add(pop);
                    sg.setPopDiscountValue(sg.getPopDiscountValue() + sg.getSaleAmount());
                    sg.setTotalDiscountValue(sg.getTotalDiscountValue() + sg.getSaleAmount());
                    sg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sg.getTotalDiscountValue() - sg.getNoDisAmountValue()));
                    sg.setSaleAmount(0.0);
                    continue;
                }
                pop = new PopDetail();
                pop.setDiscountAmount(overage);
                pop.setPopMode("0");
                pop.setPopPolicyGroup(YPopStatusType.pop_policy_group_overage);
                pop.setPopPolicyType(YPopStatusType.pop_policy_group_overage);
                pop.setPopDescribe("[ROUNDING]");
                pop.setGoodsRow(sg.getFlowId());
                sg.getPopDetailsInfo().add(pop);
                sg.setPopDiscountValue(sg.getPopDiscountValue() + sg.getSaleAmount());
                sg.setTotalDiscountValue(sg.getTotalDiscountValue() + sg.getSaleAmount());
                sg.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert(sg.getTotalDiscountValue() - sg.getNoDisAmountValue()));
                sg.setSaleAmount(sg.getSaleAmount() - overage);
                break;
            }
            Collections.sort(cacheModel.getGoodsList(), Goods.flowIdComparator);
        }
        this.posLogicServiceImpl.calcOrderAmount(cacheModel);
        if (isNeedCalc) {
            cacheModel = this.promotionServiceImpl.calcOrderPop(session, "6", cacheModel, true, false, false);
        }
        return cacheModel;
    }

    public ServiceResponse grantCustAmount(ServiceSession session, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        String accreditNo = paramsObject.getString("accreditNo");
        String flowNo = paramsObject.getString("flowNo");
        if (flowNo == null || flowNo.isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5355\u884c\u6298\u6263\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"flowNo\u4e0d\u80fd\u4e3a\u7a7a"});
        }
        CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(flowNo);
        if (cacheModel == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355", (Object[])new Object[]{flowNo});
        }
        if (!cacheModel.getOrder().getAllowEditGoods()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u8fdb\u5165\u652f\u4ed8\u73af\u8282\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u5546\u54c1", (Object[])new Object[]{flowNo});
        }
        if (null != cacheModel.getOrder().getConsumersData().getConsumersId() && cacheModel.getOrder().getConsumersData().getConsumersId().length() > 0) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u6709\u4f1a\u5458\uff0c\u65e0\u9700\u6388\u6743\u4f1a\u5458\u4ef7", (Object[])new Object[]{flowNo});
        }
        if (null == accreditNo || "".equals(accreditNo)) {
            accreditNo = cacheModel.getCurGrant().getGh();
        }
        if (null == cacheModel.getCurGrant().getPrivgj() || !"Y".equals(cacheModel.getCurGrant().getPrivgj())) {
            if (null != cacheModel.getCurTempGrant() && StringUtils.isNotEmpty((String)cacheModel.getCurTempGrant().getGh())) {
                this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
            }
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"1000", (String)"\u5f53\u524d\u4eba\u5458\u65e0\u624b\u5de5\u4f1a\u5458\u4ef7\u6743\u9650");
        }
        ConsumersData cust = new ConsumersData();
        cust.setConsumersType("04");
        cust.setConsumersCard("");
        cust.setConsumersId("");
        cacheModel.getOrder().setConsumersData(cust);
        cacheModel.getOrder().setMemberType(2);
        ProfileOut pout = new ProfileOut();
        pout.setMemberId("");
        if (cacheModel.getGoodsList() != null && cacheModel.getGoodsList().size() > 0) {
            cacheModel = this.memberService.calcAfterMemberLoginOrCancel(cacheModel, paramsObject, session);
        }
        if (cacheModel.getCalcResult() == -1) {
            String errCode = "100000";
            if (cacheModel.getErrCode().length() > 0) {
                errCode = cacheModel.getErrCode();
            }
            return ServiceResponse.buildFailure((ServiceSession)session, (String)errCode, (String)cacheModel.getErrMsg());
        }
        cacheModel.getOrder().setTerminalOperatorAuthzCardNo(cacheModel.getCurGrant().getGh());
        this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
        AmcMemberLoginOut memberLoginOut = new AmcMemberLoginOut();
        memberLoginOut.setMemberInfo(pout);
        memberLoginOut.setTotalValue(cacheModel.getOrder().getSaleValue());
        memberLoginOut.setDiscountValue(cacheModel.getOrder().getTotalDiscountValue());
        memberLoginOut.setOughtPay(cacheModel.getOrder().getOughtPay());
        ArrayList<Goods> gList = new ArrayList<Goods>();
        for (Goods g : cacheModel.getGoodsList()) {
            if (g.getIsNoBackGift()) continue;
            if (null != g.getPopDetailsInfo() && g.getPopDetailsInfo().size() > 0) {
                g = Goods.removeSinglePopDetails(g);
            }
            gList.add(g);
        }
        memberLoginOut.setGoodsList(gList);
        return ServiceResponse.buildSuccess((Object)memberLoginOut);
    }

    public List<BankCardInfoDef> getBankCardInfo(ServiceSession session) {
        try {
            GetBankCardInfoIn getIn = new GetBankCardInfoIn();
            getIn.setPageNo(1);
            getIn.setPageSize(1000);
            ServiceResponse response = this.posManagerService.getBankCardInfo(this.restTemplate, session, getIn);
            if (!"0".equals(response.getReturncode())) {
                return null;
            }
            GetBankCardInfoOut getBankCardInfoOut = (GetBankCardInfoOut)response.getData();
            if (null == getBankCardInfoOut.getBankCardInfo() || getBankCardInfoOut.getBankCardInfo().size() == 0) {
                return null;
            }
            return getBankCardInfoOut.getBankCardInfo();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private TransferAeonCardNoOut getOrderBankCardPrintInfo(List<BankCardInfoDef> bankInfoList, String cardType, String cardNo) {
        TransferAeonCardNoOut out = null;
        if (null == bankInfoList) {
            return out;
        }
        BankCardInfoDef matchBankInfo = null;
        for (BankCardInfoDef bankInfo : bankInfoList) {
            if (!cardType.equals(bankInfo.getType())) continue;
            matchBankInfo = bankInfo;
            break;
        }
        if (null == matchBankInfo) {
            return out;
        }
        out = new TransferAeonCardNoOut();
        out.setBankName(matchBankInfo.getPosName());
        out.setBankType(matchBankInfo.getType());
        out.setOrderName(matchBankInfo.getOrderName());
        if (matchBankInfo.getMskStart() == 0) {
            return out;
        }
        out.setBankCardNo(Convert.hideCodeNo(cardNo, matchBankInfo.getMskStart() - 1, cardNo.length() - matchBankInfo.getMskStart() - matchBankInfo.getMskLen() + 1));
        return out;
    }

    public TransferAeonCardNoOut getBankCardPrintInfo(List<BankCardInfoDef> bankInfoList, String cardNo, String payName) {
        TransferAeonCardNoOut out = null;
        if (null == bankInfoList) {
            return out;
        }
        if (null == cardNo) {
            return out;
        }
        BankCardInfoDef matchBankInfo = null;
        for (BankCardInfoDef bankInfo : bankInfoList) {
            if (cardNo.length() != bankInfo.getLen() || !cardNo.startsWith(bankInfo.getConstant())) continue;
            matchBankInfo = bankInfo;
            break;
        }
        if (null == matchBankInfo) {
            return out;
        }
        out = new TransferAeonCardNoOut();
        out.setBankName(matchBankInfo.getPosName());
        out.setOrderName(matchBankInfo.getOrderName());
        out.setBankType(matchBankInfo.getType());
        if (matchBankInfo.getMskStart() == 0) {
            return out;
        }
        out.setBankCardNo(Convert.hideCodeNo(cardNo, matchBankInfo.getMskStart() - 1, cardNo.length() - matchBankInfo.getMskStart() - matchBankInfo.getMskLen() + 1));
        return out;
    }

    private boolean isNeedHideCode(List<BankCardInfoDef> bankInfoList, String payName) {
        if (null == bankInfoList) {
            return false;
        }
        for (BankCardInfoDef bankInfo : bankInfoList) {
            if (!payName.trim().equals(bankInfo.getPosName().trim())) continue;
            return true;
        }
        return false;
    }

    private boolean isNeedEditPayname(List<BankCardInfoDef> bankInfoList, String payName) {
        if (null == bankInfoList) {
            return false;
        }
        for (BankCardInfoDef bankInfo : bankInfoList) {
            if (!payName.trim().equals(bankInfo.getOrderName().trim())) continue;
            return true;
        }
        return false;
    }

    public ServiceResponse refreshBackPrintNo(ServiceSession session, JSONObject paramsObject) {
        RefreshBackPrintInfo in = null;
        try {
            in = (RefreshBackPrintInfo)JSON.parseObject((String)paramsObject.toJSONString(), RefreshBackPrintInfo.class);
        }
        catch (Exception e) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u66f4\u65b0\u6863\u53e3\u6253\u5370\u7f16\u53f7[{0}]", (Object[])new Object[]{e.getMessage()});
        }
        String flowNo = in.getFlowNo();
        if (null == flowNo || flowNo.length() == 0) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355", (Object[])new Object[]{flowNo});
        }
        CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(flowNo);
        if (cacheModel == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355", (Object[])new Object[]{flowNo});
        }
        block2: for (BackPrintDef backPrint : in.getBackPrintInfo()) {
            if (null == backPrint.getGuid() || backPrint.getGuid().length() <= 0) continue;
            for (Goods good : cacheModel.getGoodsList()) {
                if (!backPrint.getGuid().equals(good.getGuid())) continue;
                good.setBackPrintNo(backPrint.getBackPrintNo());
                continue block2;
            }
        }
        this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
        RefreshOctopusInfoOut refreshOctopusInfoOut = new RefreshOctopusInfoOut(cacheModel);
        return ServiceResponse.buildSuccess((Object)refreshOctopusInfoOut);
    }

    public ServiceResponse backPrint(ServiceSession session, JSONObject paramsObject) {
        BackPrintIn in = (BackPrintIn)JSONObject.toJavaObject((JSON)paramsObject, BackPrintIn.class);
        if (null == in.getItems() || in.getItems().size() == 0) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u540e\u53a8\u6253\u5370\u672a\u4f20\u5165\u5546\u54c1\u4fe1\u606f");
        }
        BackPrintOut out = new BackPrintOut();
        StallBackPrintIn printIn = new StallBackPrintIn();
        printIn.setOrderno(in.getIdSheetNo());
        printIn.setPrintIp(in.getPrintIp());
        printIn.setRefno(in.getBackPrintNo());
        printIn.setStockCode(in.getStallCode());
        printIn.setTitle(in.getStallName());
        printIn.setIsCancel(in.getIsCancel());
        ArrayList<BackPrintItem> items = new ArrayList<BackPrintItem>();
        for (BackPrintGoodsInfo item : in.getItems()) {
            BackPrintItem printGoodsInfo = new BackPrintItem();
            printGoodsInfo.setName(item.getName());
            printGoodsInfo.setQty(item.getQty());
            printGoodsInfo.setEatWay(item.getEatWay());
            ArrayList<String> extParams = new ArrayList<String>();
            String printTag = "";
            for (CategoryProperty categoryProperty : item.getExtParams()) {
                if (categoryProperty.getIsGoods()) {
                    extParams.add(printTag + categoryProperty.getPropertyName());
                    continue;
                }
                extParams.add("   -" + categoryProperty.getPropertyName());
            }
            printGoodsInfo.setExtParams(extParams);
            items.add(printGoodsInfo);
        }
        printIn.setItems(items);
        ArrayList<String> codes = new ArrayList<String>();
        codes.add("BKPT");
        List<SysPara> sysPara = this.getSyspara(session, codes, in.getErpCode(), in.getShopCode());
        String paraValue = SysPara.getSysParaInfo(sysPara, "BKPT");
        ServiceResponse resp = this.mainDataCentreService.backPrint(this.restTemplate, session, printIn, paraValue);
        if (!"0".equals(resp.getReturncode())) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u540e\u53a8\u6253\u5370\u5931\u8d25");
        }
        return ServiceResponse.buildSuccess((Object)out);
    }

    public ServiceResponse temporarySaveOrder(ServiceSession session, JSONObject paramsObject) {
        String flowNo = paramsObject.getString("flowNo");
        Map<String, String> resultMap = this.cacheModelService.writeToLocalFile(flowNo);
        if ("1".equals(resultMap.get("success").toString())) {
            return ServiceResponse.buildSuccess((Object)"\u8ba2\u5355\u6682\u5b58\u6210\u529f\uff01");
        }
        String errorMsg = resultMap.get("msg").toString();
        return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)errorMsg);
    }

    public ServiceResponse flushOrderToRedis(ServiceSession session, JSONObject paramsObject) {
        int result = this.cacheModelService.flushOrderToRedis();
        if (result == 1) {
            return ServiceResponse.buildSuccess((Object)"\u8ba2\u5355\u56de\u5199\u672c\u5730redis\u6210\u529f\uff01");
        }
        return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000");
    }

    public ServiceResponse getRegionRuleNameInfo(ServiceSession session, JSONObject paramsObject) {
        if (!paramsObject.containsKey((Object)"shopCode")) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u6309\u95e8\u5e97\u67e5\u8be2\u533a\u57df\u89c4\u5219[{0}]", (Object[])new Object[]{"\u95e8\u5e97\u53f7"});
        }
        try {
            GetRegionRuleNameIn queryIn = new GetRegionRuleNameIn();
            queryIn.setShopCode(paramsObject.getString("shopCode"));
            LOGGER.info("BEGIN REGIONRULENAMEINFO");
            ServiceResponse resp = this.orderCentreSerivce.getRegionRuleNameInfo(this.restTemplate, session, queryIn);
            LOGGER.info("END REGIONRULENAMEINFO");
            if (!"0".equals(resp.getReturncode())) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u67e5\u8be2\u884c\u653f\u533a\u57df\u4fe1\u606f\u5931\u8d25");
            }
            GetRegionRuleNameOut queryOut = (GetRegionRuleNameOut)resp.getData();
            return ServiceResponse.buildSuccess((Object)queryOut);
        }
        catch (Exception e) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u67e5\u8be2\u884c\u653f\u533a\u57df\u4fe1\u606f[{0}]", (Object[])new Object[]{e.getMessage()});
        }
    }

    public ServiceResponse getRegionInfoList(ServiceSession session, JSONObject paramsObject) {
        try {
            SimpleQueryIn queryIn = new SimpleQueryIn();
            queryIn.setOrder_direction("desc");
            queryIn.setOrder_field("regionId");
            queryIn.setPage_no(1L);
            queryIn.setPage_size(100L);
            queryIn.setLevel(2L);
            ServiceResponse resp = this.mainDataCentreService.getRegionInfo(this.restTemplate, session, queryIn);
            if (!"0".equals(resp.getReturncode())) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u67e5\u8be2\u884c\u653f\u533a\u57df\u4fe1\u606f\u5931\u8d25");
            }
            GetRegionInfoOut queryOut = (GetRegionInfoOut)resp.getData();
            return ServiceResponse.buildSuccess((Object)queryOut);
        }
        catch (Exception e) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u67e5\u8be2\u884c\u653f\u533a\u57df\u4fe1\u606f[{0}]", (Object[])new Object[]{e.getMessage()});
        }
    }

    public ServiceResponse getQuotaInfoList(ServiceSession session, JSONObject paramsObject) {
        try {
            GetQuotaInfoIn queryIn = null;
            try {
                queryIn = (GetQuotaInfoIn)JSON.parseObject((String)paramsObject.toJSONString(), GetQuotaInfoIn.class);
            }
            catch (Exception e) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u9001\u8d27quota\u8ba1\u7b97[{0}]", (Object[])new Object[]{e.getMessage()});
            }
            queryIn.setLang("en");
            ServiceResponse resp = this.orderCentreSerivce.getQuotaInfo(this.restTemplate, session, queryIn);
            if (!"0".equals(resp.getReturncode())) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u89c4\u5219\u53ef\u80fd\u6709\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u89c4\u5219");
            }
            GetQuotaInfoOut queryOut = (GetQuotaInfoOut)resp.getData();
            return ServiceResponse.buildSuccess((Object)queryOut);
        }
        catch (Exception e) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u89c4\u5219\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u89c4\u5219[{0}]", (Object[])new Object[]{e.getMessage()});
        }
    }

    public void updateQuota(ServiceSession session, String shopCode, String day, String timeRangeCode, double usedQuota) {
        try {
            UpdateQuotaInfoIn in = new UpdateQuotaInfoIn();
            in.setShopCode(shopCode);
            in.setDay(day);
            in.setTimeRangeCode(timeRangeCode);
            in.setUsedQuota(usedQuota);
            ServiceResponse sp = this.orderCentreSerivce.updateQuotaInfo(this.restTemplate, session, in);
            if (!"0".equals(sp.getReturncode())) {
                LOGGER.info("\u66f4\u65b0Quota\u4fe1\u606f\u5931\u8d25" + sp.toString());
            } else {
                LOGGER.info("\u66f4\u65b0Quota\u4fe1\u606f\u6210\u529f");
            }
            return;
        }
        catch (Exception e) {
            LOGGER.info("\u66f4\u65b0Quota\u4fe1\u606f\u5f02\u5e38" + e.getMessage());
            return;
        }
    }

    public void updateQuota(ServiceSession session, CacheModel cacheModel, int flag) {
        String shopCode = null;
        String day = null;
        String timeRangeCode = null;
        if (!SellType.ISBACK(cacheModel.getOrder().getOrderType())) {
            if (null != cacheModel.getOrder().getDeliveryStartTime() && cacheModel.getOrder().getDeliveryStartTime().length() > 10) {
                shopCode = cacheModel.getOrder().getReserveLocation();
                day = cacheModel.getOrder().getDeliveryStartTime().substring(0, 10);
                timeRangeCode = cacheModel.getOrder().getInvoiceTitle();
            }
        } else if (null != cacheModel.getOrder().getOriginDeliveryStartTime() && cacheModel.getOrder().getOriginDeliveryStartTime().length() > 10) {
            shopCode = cacheModel.getOrder().getOriginReserveLocation();
            day = cacheModel.getOrder().getOriginDeliveryStartTime().substring(0, 10);
            timeRangeCode = cacheModel.getOrder().getOriginInvoiceTitle();
        } else {
            shopCode = cacheModel.getOrder().getReserveLocation();
            day = cacheModel.getOrder().getDeliveryStartTime().substring(0, 10);
            timeRangeCode = cacheModel.getOrder().getInvoiceTitle();
        }
        if (null == day) {
            return;
        }
        if (cacheModel.getOrder().getLogisticsMode() == 5) {
            shopCode = "081";
        }
        if (flag == 1) {
            this.updateQuota(session, shopCode, day, timeRangeCode, 1.0);
        } else if (flag == -1) {
            this.updateQuota(session, shopCode, day, timeRangeCode, -1.0);
        }
    }

    private CacheModel saveOrder(CacheModel cacheModel, ServiceSession session, String newTerminalSno) {
        ServiceResponse response = null;
        if (cacheModel.getPayConfirmStatus() != 0 && (cacheModel.getPopMode() == 1 || cacheModel.getPopMode() == 2 || cacheModel.getPopMode() == 3)) {
            response = this.couponConsume(cacheModel, session, cacheModel.getPayConfirmStatus());
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode(response.getReturncode());
            cacheModel.setErrMsg(response.getData().toString());
            return cacheModel;
        }
        if (!this.posLogicServiceImpl.checkOrder(cacheModel)) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("100000");
            cacheModel.setErrMsg(cacheModel.getErrMsg());
            return cacheModel;
        }
        if (StringUtils.isNotBlank((String)newTerminalSno)) {
            cacheModel = this.posLogicServiceImpl.RefreshTerminalSno(cacheModel, newTerminalSno);
            cacheModel.getOrder().setSeqNo("");
            cacheModel.getOrder().setYpopBillNo(cacheModel.getOrder().getYpopBillNo() + "1");
            cacheModel = this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
        }
        if ((cacheModel = this.promotionServiceImpl.couponuseConsumeForPay(cacheModel, session)).getCalcResult() == -1) {
            return cacheModel;
        }
        if ((cacheModel.getPopMode() == 1 || cacheModel.getPopMode() == 2 || cacheModel.getPopMode() == 3) && (cacheModel = this.promotionServiceImpl.calcCouponGain(session, cacheModel)).getCalcResult() == -1) {
            return cacheModel;
        }
        if (null != cacheModel.getOrder().getConsumersData() && StringUtils.isNotBlank((String)cacheModel.getOrder().getConsumersData().getConsumersCard())) {
            cacheModel.getOrder().setTotalPoint(cacheModel.getOrder().getConsumersData().getPoint() - cacheModel.getOrder().getThisTimeUsedPoint() + cacheModel.getOrder().getThisTimePoint());
        }
        if ((cacheModel = this.saveSaleOrder(cacheModel, session)).getCalcResult() == -1) {
            return cacheModel;
        }
        return cacheModel;
    }

    private CacheModel saveSaleOrder(CacheModel cacheModel, ServiceSession session) {
        ServiceResponse response = null;
        cacheModel.getOrder().setPayState(2);
        cacheModel.getOrder().setOrderState(7);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        cacheModel.getOrder().setPayDate(format.format(new Date()));
        cacheModel.getOrder().setCreateDate(cacheModel.getOrder().getPayDate());
        SaleOrders order = SaleOrders.fromCacheModel(cacheModel);
        CouponuseConsumeIn couponuseConsumeIn = new CouponuseConsumeIn();
        couponuseConsumeIn.setBillno(cacheModel.getOrder().getFlowNo());
        couponuseConsumeIn.setCalcBillId(cacheModel.getOrder().getSeqNo());
        couponuseConsumeIn.setType("0");
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (SellType.ISEXERCISE(cacheModel.getOrder().getOrderType())) {
            order.getOrders().setOrderType("1");
        }
        map.put("data", order);
        response = !SellType.ISEXERCISE(cacheModel.getOrder().getOrderType()) ? this.orderCentreSerivce.receiveOrderAll(this.restTemplate, session, map) : this.orderCentreSerivce.receiveOrderAll(this.restTemplate, session, map);
        SaveOrdersOut saveOrdersOut = null;
        String sheetNo = "";
        if (!"0".equals(response.getReturncode()) && !"1".equals(response.getReturncode())) {
            if ("101".equals(response.getReturncode()) || "201".equals(response.getReturncode())) {
                saveOrdersOut = (SaveOrdersOut)JSON.parseObject((String)response.getData().toString(), SaveOrdersOut.class);
                String terminalSno = saveOrdersOut.getTerminalSno();
                LOGGER.info("\u5c0f\u7968\u53f7terminalSno\uff1a" + terminalSno);
                String serviceSno = "";
                cacheModel.setErrMsg(cacheModel.getOrder().getTerminalSno());
                if (cacheModel.getPopMode() == 1 || cacheModel.getPopMode() == 2 || cacheModel.getPopMode() == 3) {
                    this.reversePromotion(session, cacheModel, couponuseConsumeIn);
                }
                if (StringUtils.isNotBlank((String)terminalSno)) {
                    serviceSno = terminalSno;
                    cacheModel.setErrMsg(serviceSno);
                }
                try {
                    if ("201".equals(response.getReturncode())) {
                        DeleteOrderLocal dol = new DeleteOrderLocal();
                        dol.setSaleMarketCode(cacheModel.getOrder().getShopCode());
                        dol.setTerminalSno(cacheModel.getOrder().getTerminalSno());
                        dol.setTerminalNo(cacheModel.getOrder().getTerminalNo());
                        response = this.orderCentreSerivce.deleteSaleOrdersLocal(this.restTemplate, session, dol);
                        for (int i = 0; !response.getReturncode().equals("0") && i < 2; ++i) {
                            response = this.orderCentreSerivce.deleteSaleOrdersLocal(this.restTemplate, session, dol);
                        }
                    }
                }
                catch (Exception e) {
                    cacheModel.setCalcResult(-1);
                    cacheModel.setErrCode("100000");
                    cacheModel.setErrMsg("\u8ba2\u5355\u4e2d\u5fc3\u4fdd\u5b58\u5931\u8d25");
                    return cacheModel;
                }
                cacheModel.setCalcResult(-1);
                cacheModel.setErrCode("2002");
                return cacheModel;
            }
            if (cacheModel.getPopMode() == 1 || cacheModel.getPopMode() == 2 || cacheModel.getPopMode() == 3) {
                ServiceResponse res = this.reversePromotion(session, cacheModel, couponuseConsumeIn);
                cacheModel.setCalcResult(-1);
                cacheModel.setErrCode(res.getReturncode());
                if ("2000".equals(res.getReturncode())) {
                    cacheModel.setErrMsg("\u8ba2\u5355\u4fdd\u5b58\u5931\u8d25\uff0c\u51b2\u6b63\u6210\u529f");
                } else {
                    cacheModel.setErrMsg("\u8ba2\u5355\u4fdd\u5b58\u5931\u8d25\uff0c\u51b2\u6b63\u5931\u8d25");
                }
                return cacheModel;
            }
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("100000");
            cacheModel.setErrMsg("\u8ba2\u5355\u4e2d\u5fc3\u4fdd\u5b58\u5931\u8d25");
            return cacheModel;
        }
        saveOrdersOut = (SaveOrdersOut)response.getData();
        sheetNo = saveOrdersOut.getSheetNo();
        if (this.excuteZuul(response.getReturncode(), sheetNo, "1")) {
            if (!SellType.ISEXERCISE(cacheModel.getOrder().getOrderType())) {
                if (cacheModel.getPopMode() == 1 || cacheModel.getPopMode() == 2 || cacheModel.getPopMode() == 3) {
                    response = this.reversePromotion(session, cacheModel, couponuseConsumeIn);
                    cacheModel.setCalcResult(-1);
                    cacheModel.setErrCode(response.getReturncode());
                    if (null == response.getData() || "".equals(response.getData().toString())) {
                        cacheModel.setErrMsg(response.getData().toString());
                    } else {
                        cacheModel.setErrMsg(response.getData().toString());
                    }
                    return cacheModel;
                }
                cacheModel.setCalcResult(-1);
                cacheModel.setErrCode("100000");
                cacheModel.setErrMsg("\u8ba2\u5355\u4e2d\u5fc3\u4fdd\u5b58\u5931\u8d25");
                return cacheModel;
            }
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode(response.getReturncode());
            if (null == response.getData() || "".equals(response.getData().toString())) {
                cacheModel.setErrMsg(response.getData().toString());
            } else {
                cacheModel.setErrMsg(response.getData().toString());
            }
            return cacheModel;
        }
        cacheModel.getOrder().setSaveStatus(response.getReturncode());
        cacheModel.getOrder().setSendSuccess(true);
        cacheModel.getOrder().setIdSheetNo(sheetNo);
        return cacheModel;
    }

    private CacheModel saveSaleReturnOrder(CacheModel cacheModel, ServiceSession session, String newTerminalSno) {
        ServiceResponse response = null;
        ServiceResponse sp = null;
        if (!(cacheModel.getPopMode() != 1 && cacheModel.getPopMode() != 2 && cacheModel.getPopMode() != 3 || "2".equals(cacheModel.getOrder().getOrderType()))) {
            if (!(cacheModel.getPayConfirmStatus() == 0 || cacheModel.getPopMode() != 1 && cacheModel.getPopMode() != 2 && cacheModel.getPopMode() != 3 || "2".equals(cacheModel.getOrder().getOrderType()))) {
                response = this.couponConsume(cacheModel, session, cacheModel.getPayConfirmStatus());
                cacheModel.setCalcResult(-1);
                cacheModel.setErrCode(response.getReturncode());
                if (null == response.getData() || "".equals(response.getData().toString())) {
                    cacheModel.setErrMsg(response.getData().toString());
                } else {
                    cacheModel.setErrMsg(response.getData().toString());
                }
                return cacheModel;
            }
            CouponuseConsumeIn couponuseConsumeIn = new CouponuseConsumeIn();
            couponuseConsumeIn.setBillno(cacheModel.getOrder().getFlowNo());
            couponuseConsumeIn.setCalcBillId(cacheModel.getOrder().getSeqNo());
            List<Payment> couponPayments = this.posLogicServiceImpl.getCouponPayments(cacheModel.getPayments());
            if (couponPayments != null && couponPayments.size() != 0) {
                couponuseConsumeIn.setSellPayments(Payment.transferSellPayment(couponPayments, SellType.ISBACK(cacheModel.getOrder().getOrderType())));
                couponuseConsumeIn.setType("0");
                cacheModel.callMarketClear();
                response = this.promotionCentreService.couponAndPointsConsume(this.restTemplate, session, couponuseConsumeIn);
                if (!"0".equals(response.getReturncode())) {
                    if (!"60003".equals(response.getReturncode())) {
                        List<SellPayment> reversePayments = couponuseConsumeIn.getSellPayments();
                        cacheModel.setReversePayments(reversePayments);
                        response = this.couponConsume(cacheModel, session, 5, response);
                        cacheModel.setCalcResult(-1);
                        cacheModel.setErrCode(response.getReturncode());
                        if (null == response.getData() || "".equals(response.getData().toString())) {
                            cacheModel.setErrMsg(response.getData().toString());
                        } else {
                            cacheModel.setErrMsg(response.getData().toString());
                        }
                        return cacheModel;
                    }
                    cacheModel.setCalcResult(-1);
                    cacheModel.setErrCode(response.getReturncode());
                    if (null == response.getData() || "".equals(response.getData().toString())) {
                        cacheModel.setErrMsg(response.getData().toString());
                    } else {
                        cacheModel.setErrMsg(response.getData().toString());
                    }
                    return cacheModel;
                }
            }
            if (StringUtils.isNotBlank((String)cacheModel.getOrder().getOriginTerminalSno())) {
                CouponGainCalcIn couponGainCalcIn = new CouponGainCalcIn();
                couponGainCalcIn.fromCacheModel(cacheModel);
                sp = this.promotionCentreService.coupongainCalc(this.restTemplate, session, couponGainCalcIn);
                if (!"0".equals(sp.getReturncode())) {
                    if (YPopStatusType.returncode_88888.equals(sp.getReturncode())) {
                        couponGainCalcIn.setCalcBillid("");
                        sp = new ServiceResponse();
                        sp = this.promotionCentreService.coupongainCalc(this.restTemplate, session, couponGainCalcIn);
                    }
                    if (!"0".equals(sp.getReturncode())) {
                        response = this.couponConsume(cacheModel, session, 7, sp);
                        cacheModel.setCalcResult(-1);
                        cacheModel.setErrCode(response.getReturncode());
                        if (null == response.getData() || "".equals(response.getData().toString())) {
                            cacheModel.setErrMsg(response.getData().toString());
                        } else {
                            cacheModel.setErrMsg(response.getData().toString());
                        }
                        return cacheModel;
                    }
                    cacheModel.setCalcResult(-1);
                    cacheModel.setErrCode(sp.getReturncode());
                    if (null == sp.getData() || "".equals(sp.getData().toString())) {
                        cacheModel.setErrMsg(sp.getData().toString());
                    } else {
                        cacheModel.setErrMsg(sp.getData().toString());
                    }
                    return cacheModel;
                }
                CouponGainCalcOut couponGainCalcOut = (CouponGainCalcOut)sp.getData();
                if ((cacheModel = this.posLogicServiceImpl.RefreshOrderAfterOrderSave(cacheModel, couponGainCalcOut)).getCalcResult() == -1) {
                    return cacheModel;
                }
                this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
            }
        }
        if (StringUtils.isNotBlank((String)newTerminalSno)) {
            cacheModel = this.posLogicServiceImpl.RefreshTerminalSno(cacheModel, newTerminalSno);
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        cacheModel.getOrder().setPayDate(format.format(new Date()));
        cacheModel.getOrder().setCreateDate(cacheModel.getOrder().getPayDate());
        for (int i = 0; i < cacheModel.getPayments().size(); ++i) {
            Payment payment = cacheModel.getPayments().get(i);
            if (!payment.getPayCode().equals("0706")) continue;
            payment.setPayNo(cacheModel.getOrder().getConsumersData().getConsumersCard());
        }
        SaleOrders order = SaleOrders.fromCacheModel(cacheModel);
        order.getOrders().setOrderState(OrderStateEnum.T_YWC.getCode());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("data", order);
        sp = this.orderCentreSerivce.receiveOrderAll(this.restTemplate, session, map);
        SaveOrdersOut saveOrdersOut = null;
        String sheetNo = "";
        if ("0".equals(sp.getReturncode()) || "1".equals(sp.getReturncode())) {
            saveOrdersOut = (SaveOrdersOut)sp.getData();
            sheetNo = saveOrdersOut.getSheetNo();
            cacheModel.getOrder().setIsAllReturn(saveOrdersOut.getIsAllReturn());
        } else if ("101".equals(sp.getReturncode()) || "201".equals(sp.getReturncode())) {
            try {
                saveOrdersOut = (SaveOrdersOut)JSON.parseObject((String)sp.getData().toString(), SaveOrdersOut.class);
                String terminalSno = saveOrdersOut.getTerminalSno();
                String serviceSno = "";
                ServiceResponse sNoResponse = new ServiceResponse();
                if (StringUtils.isNotBlank((String)terminalSno)) {
                    serviceSno = terminalSno;
                    sNoResponse.setReturncode("2002");
                    sNoResponse.setData((Object)serviceSno);
                    this.couponConsume(cacheModel, session, 8, sp);
                    cacheModel.setCalcResult(-1);
                    cacheModel.setErrCode("2002");
                    cacheModel.setErrMsg(serviceSno);
                    if ("201".equals(sp.getReturncode())) {
                        DeleteOrderLocal dol = new DeleteOrderLocal();
                        dol.setReturnMarketCode(order.getOrders().getOriginMarketCode());
                        dol.setTerminalSno(order.getOrders().getTerminalSno());
                        dol.setTerminalNo(order.getOrders().getTerminalNo());
                        ServiceResponse res = this.orderCentreSerivce.deleteReturnOrdersLocal(this.restTemplate, session, dol);
                        for (int i = 0; !res.getReturncode().equals("0") && i < 2; ++i) {
                            res = this.orderCentreSerivce.deleteReturnOrdersLocal(this.restTemplate, session, dol);
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return cacheModel;
        }
        if (this.excuteZuul(sp.getReturncode(), sheetNo, "1")) {
            ServiceResponse couponResponse = this.couponConsume(cacheModel, session, 8, sp);
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode(couponResponse.getReturncode());
            if (null == couponResponse.getData() || "".equals(couponResponse.getData().toString())) {
                cacheModel.setErrMsg(couponResponse.getData().toString());
            } else {
                cacheModel.setErrMsg(couponResponse.getData().toString());
            }
            return cacheModel;
        }
        cacheModel.getOrder().setSaveStatus(sp.getReturncode());
        cacheModel.getOrder().setSendSuccess(true);
        cacheModel.getOrder().setIdSheetNo(sheetNo);
        return cacheModel;
    }

    /*
     * WARNING - void declaration
     */
    public CacheModel TransferCacheModelForReturn(SaleOrders orderQueryOut, SaleReturnQueryIn saleReturnQueryIn, CacheModel cacheModel, boolean isHc) {
        int rowNo;
        ArrayList<Goods> goodslist = new ArrayList<Goods>();
        for (OrdersDetailModel saleDetail : orderQueryOut.getOrdersDetail()) {
            if (!isHc && saleDetail.getGoodsFlag().equals("0")) continue;
            goodslist.add(Goods.transferGoods2(saleDetail));
        }
        cacheModel.setReturnPayments(Payment.transferPayment3(orderQueryOut.getOrdersPay()));
        String orderType = "4";
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            Date saleDate = orderQueryOut.getOrders().getSaleDate();
            Date nowDate = sdf.parse(sdf.format(new Date()));
            if (cacheModel.getOrder().getOrderType().equals("2")) {
                if (saleDate.before(nowDate)) {
                    orderType = "4";
                } else {
                    orderType = "2";
                    List<Payment> list = cacheModel.getReturnPayments();
                    boolean unDis = true;
                    if (null != cacheModel.getOrder().getSysPara().getNoVoidPaymentCodes() && !cacheModel.getOrder().getSysPara().getNoVoidPaymentCodes().isEmpty()) {
                        for (Payment payment : list) {
                            if (cacheModel.getOrder().getSysPara().getNoVoidPaymentCodes().indexOf(payment.getPayCode()) == -1) continue;
                            unDis = false;
                            break;
                        }
                    }
                    if (!unDis) {
                        orderType = "4";
                    }
                }
            }
            if (orderQueryOut.getOrders().getOrderType().equals("Y1")) {
                orderType = "Y2";
            } else if ("2".equals(orderType)) {
                if ("SK1".equals(orderQueryOut.getOrders().getOrderType())) {
                    orderType = "SK2";
                } else if ("YK1".equals(orderQueryOut.getOrders().getOrderType())) {
                    orderType = "YK2";
                }
            } else if ("4".equals(orderType)) {
                if ("SK1".equals(orderQueryOut.getOrders().getOrderType())) {
                    orderType = "SK4";
                } else if ("YK1".equals(orderQueryOut.getOrders().getOrderType())) {
                    orderType = "YK4";
                }
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        cacheModel.setOrder(Order.transferRetrunOrder(orderQueryOut, cacheModel.getOrder(), orderType));
        double gainPoints = 0.0;
        if ("2".equals(cacheModel.getOrder().getOrderType())) {
            if (orderQueryOut.getOrdersGainDetail() != null && !orderQueryOut.getOrdersGainDetail().isEmpty()) {
                void var10_17;
                List<OrdersGainDetailModel> orderGainDetails = orderQueryOut.getOrdersGainDetail();
                boolean bl = false;
                while (var10_17 < orderGainDetails.size()) {
                    OrdersGainDetailModel ordersGainDetailModel = orderGainDetails.get((int)var10_17);
                    if (ordersGainDetailModel.getCouponGroup().equals("01")) {
                        gainPoints = ManipulatePrecision.add(gainPoints, ordersGainDetailModel.getAmount().doubleValue());
                    }
                    for (int j = 0; j < goodslist.size(); ++j) {
                        Goods goods = (Goods)goodslist.get(j);
                        if (goods.getFlowId() != ordersGainDetailModel.getRowNo().intValue()) continue;
                        if (goods.getCouponGains() == null) {
                            goods.setCouponGains(new ArrayList<CouponGain>());
                        }
                        goods.getCouponGains().add(Goods.transferCouponGain(ordersGainDetailModel));
                    }
                    ++var10_17;
                }
                cacheModel.getOrder().setThisTimePoint(ManipulatePrecision.getDetailOverFlow(gainPoints, "4"));
            }
            if (orderQueryOut.getOrdersGain() != null && !orderQueryOut.getOrdersGain().isEmpty()) {
                for (int i = 0; i < orderQueryOut.getOrdersGain().size(); ++i) {
                    OrdersGainModel ordersGainModel = orderQueryOut.getOrdersGain().get(i);
                    Coupon transferCoupon = Coupon.transferCoupon2(ordersGainModel);
                    if (cacheModel.getOrder().getCouponDetails() == null) {
                        cacheModel.getOrder().setCouponDetails(new ArrayList<Coupon>());
                    }
                    cacheModel.getOrder().getCouponDetails().add(transferCoupon);
                }
            }
        }
        if ("2".equals(orderType) && null != orderQueryOut.getOrdersDetailPop() && orderQueryOut.getOrdersDetailPop().size() > 0) {
            for (OrdersDetailPopModel ordersDetailPopModel : orderQueryOut.getOrdersDetailPop()) {
                rowNo = ordersDetailPopModel.getRowNo() - 1;
                if (goodslist.size() < rowNo + 1) continue;
                ((Goods)goodslist.get(rowNo)).getPopDetailsInfo().add(PopDetail.transferPopDetail(ordersDetailPopModel));
            }
        }
        if (null != orderQueryOut.getOrdersUseCoupon() && orderQueryOut.getOrdersUseCoupon().size() > 0) {
            for (OrdersUseCouponModel ordersUseCouponModel : orderQueryOut.getOrdersUseCoupon()) {
                rowNo = ordersUseCouponModel.getRowNo() - 1;
                if (goodslist.size() < rowNo + 1) continue;
                ((Goods)goodslist.get(rowNo)).getCouponUses().add(CouponUse.transferCouponUse3(ordersUseCouponModel, cacheModel.getOrder()));
            }
        }
        cacheModel.setReturnGoodsList(goodslist);
        return cacheModel;
    }

    public ServiceResponse getClearInfo(ServiceSession session, JSONObject paramsObject) {
        GetClearInfoPosIn in = null;
        try {
            if (!paramsObject.containsKey((Object)"startTime")) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u83b7\u53d6\u652f\u4ed8\u5c3e\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u8d77\u59cb\u65f6\u95f4"});
            }
            if (!paramsObject.containsKey((Object)"endTime")) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u83b7\u53d6\u652f\u4ed8\u5c3e\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u7ed3\u675f\u65f6\u95f4"});
            }
            if (!paramsObject.containsKey((Object)"erpCode")) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u83b7\u53d6\u652f\u4ed8\u5c3e\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u7ecf\u8425\u516c\u53f8"});
            }
            if (!paramsObject.containsKey((Object)"shopCode")) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u83b7\u53d6\u652f\u4ed8\u5c3e\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u95e8\u5e97\u53f7"});
            }
            if (!paramsObject.containsKey((Object)"terminalNo")) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u83b7\u53d6\u652f\u4ed8\u5c3e\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u7ec8\u7aef\u53f7"});
            }
            if (!paramsObject.containsKey((Object)"terminalOperator")) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u83b7\u53d6\u652f\u4ed8\u5c3e\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u6536\u94f6\u5458\u53f7"});
            }
            in = (GetClearInfoPosIn)JSON.parseObject((String)paramsObject.toJSONString(), GetClearInfoPosIn.class);
        }
        catch (Exception e) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u67e5\u8be2\u7f34\u6b3e\u6570\u636e[{0}]", (Object[])new Object[]{e.getMessage()});
        }
        GetClearInfoIn orderIn = new GetClearInfoIn();
        orderIn.setBusCompany(in.getErpCode());
        orderIn.setCreateDateEnd(in.getEndTime());
        orderIn.setCreateDateStart(in.getStartTime());
        orderIn.setSaleMarketCode(in.getShopCode());
        orderIn.setTerminalNo(in.getTerminalNo());
        orderIn.setTerminalOperator(in.getTerminalOperator());
        ServiceResponse resp = this.orderCentreSerivce.getClearInfo(this.restTemplate, session, orderIn);
        if (!"0".equals(resp.getReturncode())) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u67e5\u8be2\u7f34\u6b3e\u6570\u636e\u5931\u8d25");
        }
        GetClearInfoOut clearInfos = (GetClearInfoOut)resp.getData();
        GetClearInfoPosOut out = new GetClearInfoPosOut();
        out.setPaymentList(new ArrayList<PosClearInfoDef>());
        if (null == clearInfos.getClearingMachineInfo() || clearInfos.getClearingMachineInfo().size() == 0) {
            return ServiceResponse.buildSuccess((Object)out);
        }
        for (OrderClearInfoDef clearInfo : clearInfos.getClearingMachineInfo()) {
            PosClearInfoDef info = new PosClearInfoDef();
            info.setPayCode(clearInfo.getPayCode());
            info.setPayName(clearInfo.getPayName());
            info.setPayType(clearInfo.getPayType());
            info.setSumAmount(clearInfo.getSumAmount());
            out.getPaymentList().add(info);
        }
        return ServiceResponse.buildSuccess((Object)out);
    }

    public ServiceResponse getSalesStatistics(ServiceSession session, JSONObject paramsObject) {
        GetSalesStatisticsForPosIn in = null;
        try {
            if (!paramsObject.containsKey((Object)"startTime")) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u83b7\u53d6\u6536\u94f6\u673a\u9500\u552e\u7edf\u8ba1\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u8d77\u59cb\u65f6\u95f4"});
            }
            if (!paramsObject.containsKey((Object)"endTime")) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u83b7\u53d6\u6536\u94f6\u673a\u9500\u552e\u7edf\u8ba1\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u7ed3\u675f\u65f6\u95f4"});
            }
            if (!paramsObject.containsKey((Object)"erpCode")) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u83b7\u53d6\u6536\u94f6\u673a\u9500\u552e\u7edf\u8ba1\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u7ecf\u8425\u516c\u53f8"});
            }
            if (!paramsObject.containsKey((Object)"shopCode")) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u83b7\u53d6\u6536\u94f6\u673a\u9500\u552e\u7edf\u8ba1\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u95e8\u5e97\u53f7"});
            }
            if (!paramsObject.containsKey((Object)"terminalNo")) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u83b7\u53d6\u6536\u94f6\u673a\u9500\u552e\u7edf\u8ba1\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u7ec8\u7aef\u53f7"});
            }
            if (!paramsObject.containsKey((Object)"terminalOperator")) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u83b7\u53d6\u6536\u94f6\u673a\u9500\u552e\u7edf\u8ba1\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u6536\u94f6\u5458\u53f7"});
            }
            in = (GetSalesStatisticsForPosIn)JSON.parseObject((String)paramsObject.toJSONString(), GetSalesStatisticsForPosIn.class);
        }
        catch (Exception e) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u67e5\u8be2\u6536\u94f6\u673a\u7684\u9500\u552e\u7edf\u8ba1[{0}]", (Object[])new Object[]{e.getMessage()});
        }
        GetSalesStatisticsIn orderIn = new GetSalesStatisticsIn();
        orderIn.setBusCompany(in.getErpCode());
        orderIn.setCreateDateEnd(in.getEndTime());
        orderIn.setCreateDateStart(in.getStartTime());
        orderIn.setSaleMarketCode(in.getShopCode());
        orderIn.setTerminalNo(in.getTerminalNo());
        orderIn.setTerminalOperator(in.getTerminalOperator());
        ServiceResponse resp = this.orderCentreSerivce.getSalesStatistics(this.restTemplate, session, orderIn);
        if (!"0".equals(resp.getReturncode())) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u67e5\u8be2\u6536\u94f6\u673a\u7684\u9500\u552e\u7edf\u8ba1\u6570\u636e\u5931\u8d25");
        }
        GetSalesStatisticsOut salesInfos = (GetSalesStatisticsOut)resp.getData();
        GetSalesStatisticsPosOut out = new GetSalesStatisticsPosOut();
        ArrayList<SalesStatisticsDef> salesList = new ArrayList<SalesStatisticsDef>();
        out.setSalesList(salesList);
        if (null == salesInfos.getTable()) {
            return ServiceResponse.buildSuccess((Object)out);
        }
        if (salesInfos.getTable().size() == 0) {
            return ServiceResponse.buildSuccess((Object)out);
        }
        for (OrderSalesStatisticsDef salesinfo : salesInfos.getTable()) {
            SalesStatisticsDef info = new SalesStatisticsDef();
            info.setOverage(salesinfo.getCashRegisterDamageSum());
            info.setChangeValue(salesinfo.getChangeValueSum());
            info.setHcthCount(salesinfo.getHcthCount());
            info.setHcthMoneySum(salesinfo.getHcthMoneySum());
            info.setHcxsCount(salesinfo.getHcxsCount());
            info.setHcxsMoneySum(salesinfo.getHcxsMoneySum());
            info.setLsthCount(salesinfo.getLsthCount());
            info.setLsthMoneySum(salesinfo.getLsthMoneySum());
            info.setLsxsCount(salesinfo.getLsxsCount());
            info.setLsxsMoneySum(salesinfo.getLsxsMoneySum());
            info.setTerminalNo(salesinfo.getTerminalNo());
            salesList.add(info);
            out.setSalesList(salesList);
        }
        return ServiceResponse.buildSuccess((Object)out);
    }

    public ServiceResponse getSalesStatisticsForCard(ServiceSession session, JSONObject paramsObject) {
        GetSalesStatisticsForCardPosIn in = null;
        try {
            if (!paramsObject.containsKey((Object)"startTime")) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u83b7\u53d6\u4e00\u5361\u901a\u9500\u552e\u7edf\u8ba1\u6570\u636e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u8d77\u59cb\u65f6\u95f4"});
            }
            if (!paramsObject.containsKey((Object)"endTime")) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u83b7\u53d6\u4e00\u5361\u901a\u9500\u552e\u7edf\u8ba1\u6570\u636e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u7ed3\u675f\u65f6\u95f4"});
            }
            if (!paramsObject.containsKey((Object)"erpCode")) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u83b7\u53d6\u4e00\u5361\u901a\u9500\u552e\u7edf\u8ba1\u6570\u636e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u7ecf\u8425\u516c\u53f8"});
            }
            if (!paramsObject.containsKey((Object)"shopCode")) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u83b7\u53d6\u4e00\u5361\u901a\u9500\u552e\u7edf\u8ba1\u6570\u636e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u95e8\u5e97\u53f7"});
            }
            if (!paramsObject.containsKey((Object)"terminalNo")) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u83b7\u53d6\u4e00\u5361\u901a\u9500\u552e\u7edf\u8ba1\u6570\u636e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u7ec8\u7aef\u53f7"});
            }
            if (!paramsObject.containsKey((Object)"terminalOperator")) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u83b7\u53d6\u4e00\u5361\u901a\u9500\u552e\u7edf\u8ba1\u6570\u636e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u6536\u94f6\u5458\u53f7"});
            }
            if (!paramsObject.containsKey((Object)"payCode")) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u83b7\u53d6\u4e00\u5361\u901a\u9500\u552e\u7edf\u8ba1\u6570\u636e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u652f\u4ed8\u65b9\u5f0f"});
            }
            in = (GetSalesStatisticsForCardPosIn)JSON.parseObject((String)paramsObject.toJSONString(), GetSalesStatisticsForCardPosIn.class);
        }
        catch (Exception e) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u67e5\u8be2\u4e00\u5361\u901a\u9500\u552e\u7edf\u8ba1[{0}]", (Object[])new Object[]{e.getMessage()});
        }
        GetSalesStatisticsForCardIn orderIn = new GetSalesStatisticsForCardIn();
        orderIn.setBusCompany(in.getErpCode());
        orderIn.setCreateDateEnd(in.getEndTime());
        orderIn.setCreateDateStart(in.getStartTime());
        orderIn.setSaleMarketCode(in.getShopCode());
        orderIn.setTerminalNo(in.getTerminalNo());
        orderIn.setTerminalOperator(in.getTerminalOperator());
        orderIn.setPayCode(in.getPayCode());
        ServiceResponse resp = this.orderCentreSerivce.getSalesStatisticsForCard(this.restTemplate, session, orderIn);
        if (!"0".equals(resp.getReturncode())) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u67e5\u8be2\u4e00\u5361\u901a\u9500\u552e\u7edf\u8ba1\u6570\u636e\u5931\u8d25");
        }
        GetSalesStatisticsForCardOut salesInfos = (GetSalesStatisticsForCardOut)resp.getData();
        GetRateStatisticsPosOut out = new GetRateStatisticsPosOut();
        ArrayList<RatesStatisticsDef> salesListForCard = new ArrayList<RatesStatisticsDef>();
        out.setSalesListForCard(salesListForCard);
        if (null == salesInfos.getTable()) {
            return ServiceResponse.buildSuccess((Object)out);
        }
        if (salesInfos.getTable().size() == 0) {
            return ServiceResponse.buildSuccess((Object)out);
        }
        for (OrderRateStatisticsDef salesinfo : salesInfos.getTable()) {
            RatesStatisticsDef info = new RatesStatisticsDef();
            info.setCountMoney(salesinfo.getCountMoney());
            info.setOrderShift_export(salesinfo.getOrderShift_export());
            info.setPayCode(salesinfo.getPayCode());
            info.setPayName(salesinfo.getPayName());
            info.setScheduleCode(salesinfo.getOrderShift());
            info.setSumMoney(salesinfo.getSumMoney());
            info.setTerminalNo(salesinfo.getTerminalNo());
            info.setTerminalOperator(salesinfo.getTerminalOperator());
            salesListForCard.add(info);
            out.setSalesListForCard(salesListForCard);
        }
        return ServiceResponse.buildSuccess((Object)out);
    }

    private String getOrgid(ServiceSession session, String erpCode, String shopCode) {
        HashMap<String, String> params = new HashMap<String, String>();
        String orgid = "";
        params.put("erpCode", erpCode);
        params.put("shopCode", shopCode);
        try {
            ServiceResponse resp = this.mainDataCentreService.getSubCompanyByShop(this.restTemplate, session, JSON.toJSONString(params));
            if ("0".equals(resp.getReturncode())) {
                List subCompanys = (List)resp.getData();
                orgid = ((SubCompany)subCompanys.get(0)).getCompanyCode();
            }
        }
        catch (Exception e) {
            LOGGER.info("\u83b7\u53d6\u5b50\u516c\u53f8\u7f16\u7801\u5f02\u5e38:" + e.getMessage());
        }
        return orgid;
    }

    /*
     * WARNING - void declaration
     */
    private PayConfirmOut toPayConfirmOut(ServiceSession session, SaleOrders saleOrder, SaleOrders oriOrder, List<String> calcPriceType, List<String> prtSeq, String prtMode) {
        PayConfirmOut out = new PayConfirmOut();
        OrderForPos orderOut = OrderForPos.toOrderForPos(saleOrder);
        out.setRePrintCnt(saleOrder.getRePrintCnt());
        if (null != saleOrder.getOrders().getReturnReason()) {
            orderOut.setReason(saleOrder.getOrders().getReturnReason().toString());
        }
        LOGGER.info("orderOut\u9000\u8d27\u53c2\u6570\u8f6c\u6362\u5b8c\u6210");
        ArrayList<PaymentForPos> sellPayments = new ArrayList<PaymentForPos>();
        for (OrdersPayModel ordersPayModel : saleOrder.getOrdersPay()) {
            Payment p = new Payment();
            Payment.SaleOrderPayToPayment(ordersPayModel, p);
            LOGGER.info("payment\u8f6c\u6362\u5b8c\u62101");
            sellPayments.add(p);
        }
        orderOut.setSalePayments(sellPayments);
        LOGGER.info("payment\u8f6c\u6362\u5b8c\u6210");
        ArrayList<Goods> goodsList = new ArrayList<Goods>();
        for (OrdersDetailModel s : saleOrder.getOrdersDetail()) {
            Goods goods = new Goods();
            Goods.SaleOrderDetailToGoods(goods, s);
            goodsList.add(goods);
        }
        LOGGER.info("goods\u8f6c\u6362\u5b8c\u6210");
        if (null != saleOrder.getOrdersDetailPop() && saleOrder.getOrdersDetailPop().size() > 0) {
            void var11_14;
            boolean bl = false;
            while (var11_14 < goodsList.size()) {
                Goods goods = (Goods)goodsList.get((int)var11_14);
                for (OrdersDetailPopModel orderPop : saleOrder.getOrdersDetailPop()) {
                    if (goods.getFlowId() != orderPop.getRowNo().intValue()) continue;
                    goods.getPopDetailsInfo().add(PopDetail.transferPopDetail(orderPop));
                }
                ++var11_14;
            }
        }
        LOGGER.info("orderPop\u8f6c\u6362\u5b8c\u6210");
        PrintInfo printInfo = PrintInfo.convertPrintInfo(goodsList, calcPriceType, prtSeq, prtMode);
        LOGGER.info("printInfo\u8f6c\u6362\u5b8c\u6210");
        out.setPopInfo(new ArrayList<PopDetailForPos>());
        out.getPopInfo().addAll(printInfo.getMergedPopDetails());
        List<GoodsForPos> goodListPops = Goods.transferGoodsToPosGoodsListForSave(printInfo.getGoodsListForPrint(), calcPriceType, true);
        orderOut.getGoodsList().addAll(goodListPops);
        OrderGains orderGain = OrderGains.convertOrderGains(Coupon.transferCoupon3(saleOrder.getOrdersGain()));
        LOGGER.info("orderGain\u8f6c\u6362\u5b8c\u6210");
        if (null != orderGain) {
            out.setCouponGain(orderGain.getOrderCouponGains());
        }
        out.setOrder(orderOut);
        if (null != oriOrder) {
            OrderForPos oriOrderOut = OrderForPos.toOrderForPos(oriOrder);
            ArrayList<PaymentForPos> oriPayments = new ArrayList<PaymentForPos>();
            for (OrdersPayModel ordersPayModel : oriOrder.getOrdersPay()) {
                Payment p = new Payment();
                Payment.SaleOrderPayToPayment(ordersPayModel, p);
                LOGGER.info("payment\u8f6c\u6362\u5b8c\u62101");
                oriPayments.add(p);
            }
            oriOrderOut.setSalePayments(oriPayments);
            LOGGER.info("payment\u8f6c\u6362\u5b8c\u6210");
            ArrayList<Goods> origoodsList = new ArrayList<Goods>();
            for (OrdersDetailModel s : oriOrder.getOrdersDetail()) {
                Goods goods = new Goods();
                Goods.SaleOrderDetailToGoods(goods, s);
                PopDetail pop = new PopDetail();
                pop.setDiscountAmount(ManipulatePrecision.doubleConvert(goods.getRealTotalDiscountValue()));
                pop.setPopMode("0");
                pop.setPopDescribe("[\u4fc3\u9500\u4f18\u60e0]");
                pop.setPopPolicyGroup(YPopStatusType.pop_policy_group_total);
                pop.setPopPolicyType(YPopStatusType.pop_policy_group_total);
                pop.setGoodsRow(goods.getFlowId());
                goods.getPopDetailsInfo().add(pop);
                origoodsList.add(goods);
            }
            LOGGER.info("goods\u8f6c\u6362\u5b8c\u6210");
            LOGGER.info("orderPop\u8f6c\u6362\u5b8c\u6210");
            PrintInfo printInfo2 = PrintInfo.convertPrintInfo(origoodsList, calcPriceType, prtSeq, prtMode);
            LOGGER.info("printInfo\u8f6c\u6362\u5b8c\u6210");
            out.setOriginPopInfo(new ArrayList<PopDetailForPos>());
            out.getOriginPopInfo().addAll(printInfo2.getMergedPopDetails());
            List<GoodsForPos> oriGoodListPops = Goods.transferGoodsToPosGoodsList(printInfo2.getGoodsListForPrint(), calcPriceType, true);
            oriOrderOut.getGoodsList().addAll(oriGoodListPops);
            out.setOriginOrder(oriOrderOut);
        }
        return out;
    }

    private PayConfirmOut toPayConfirmOutBySave(ServiceSession session, SaleOrders oriOrder, List<String> calcPriceType, List<String> prtSeq, String prtMode) {
        PayConfirmOut out = new PayConfirmOut();
        if (null != oriOrder) {
            OrderForPos oriOrderOut = OrderForPos.toOrderForPos(oriOrder);
            ArrayList<PaymentForPos> oriPayments = new ArrayList<PaymentForPos>();
            for (OrdersPayModel ordersPayModel : oriOrder.getOrdersPay()) {
                Payment p = new Payment();
                Payment.SaleOrderPayToPayment(ordersPayModel, p);
                LOGGER.info("payment\u8f6c\u6362\u5b8c\u62101");
                oriPayments.add(p);
            }
            oriOrderOut.setSalePayments(oriPayments);
            LOGGER.info("payment\u8f6c\u6362\u5b8c\u6210");
            ArrayList<Goods> origoodsList = new ArrayList<Goods>();
            for (OrdersDetailModel s : oriOrder.getOrdersDetail()) {
                Goods goods = new Goods();
                Goods.SaleOrderDetailToGoods(goods, s);
                goods.setPopDetailsInfo(new ArrayList<PopDetail>());
                PopDetail pop = new PopDetail();
                pop.setDiscountAmount(ManipulatePrecision.doubleConvert(goods.getRealTotalDiscountValue()));
                pop.setPopMode("0");
                pop.setPopDescribe("[\u4fc3\u9500\u4f18\u60e0]");
                pop.setPopPolicyGroup(YPopStatusType.pop_policy_group_total);
                pop.setPopPolicyType(YPopStatusType.pop_policy_group_total);
                pop.setGoodsRow(goods.getFlowId());
                goods.getPopDetailsInfo().add(pop);
                origoodsList.add(goods);
            }
            LOGGER.info("goods\u8f6c\u6362\u5b8c\u6210");
            LOGGER.info("orderPop\u8f6c\u6362\u5b8c\u6210");
            PrintInfo printInfo = PrintInfo.convertPrintInfo(origoodsList, calcPriceType, prtSeq, prtMode);
            LOGGER.info("printInfo\u8f6c\u6362\u5b8c\u6210");
            out.setOriginPopInfo(new ArrayList<PopDetailForPos>());
            out.getOriginPopInfo().addAll(printInfo.getMergedPopDetails());
            List<GoodsForPos> oriGoodListPops = Goods.transferGoodsToPosGoodsList(printInfo.getGoodsListForPrint(), calcPriceType, false);
            oriOrderOut.getGoodsList().addAll(oriGoodListPops);
            out.setOriginOrder(oriOrderOut);
        }
        return out;
    }

    private SysParaInfo initSysParaInfo(ServiceSession session, String erpCode, String shopCode) {
        ArrayList<String> codes = new ArrayList<String>();
        codes.add("ZRFS");
        codes.add("BBFS");
        codes.add("4J");
        codes.add("XDFS");
        codes.add("WKFS");
        codes.add("KHTH");
        codes.add("YQSX");
        codes.add("BKPT");
        codes.add("QHRQ");
        codes.add("JYMS");
        codes.add("ZKSX");
        codes.add("ZBUP");
        codes.add("KHMS");
        codes.add("SJKDZ");
        codes.add("PRTSEQ");
        codes.add("ZBHY");
        codes.add("SYMS");
        codes.add("HYPU");
        codes.add("ZBMCID");
        codes.add("40");
        codes.add("YGGW");
        codes.add("SCHS");
        codes.add("SLXS");
        codes.add("CMJY");
        codes.add("DISCNAME");
        codes.add("POPPRTMODE");
        codes.add("CWYH");
        codes.add("ZTKEY");
        codes.add("HYQZ");
        codes.add("CMFT");
        codes.add("MSID");
        codes.add("MKEY");
        codes.add("MADR");
        List<SysPara> sysParaList = this.getSyspara(session, codes, erpCode, shopCode);
        SysParaInfo sysParaInfo = this.initSysParaInfo(sysParaList);
        return sysParaInfo;
    }

    public SysParaInfo initSysParaInfo(List<SysPara> sysParaList) {
        SysParaInfo sysParaInfo = new SysParaInfo();
        block77: for (SysPara s : sysParaList) {
            block35 : switch (s.getCode()) {
                case "MADR": {
                    sysParaInfo.setMadr(s.getValue());
                    break;
                }
                case "MSID": {
                    sysParaInfo.setMsid(s.getValue());
                    break;
                }
                case "MKEY": {
                    sysParaInfo.setMkey(s.getValue());
                    break;
                }
                case "CMFT": {
                    sysParaInfo.setCmft(s.getValue());
                    break;
                }
                case "HYQZ": {
                    sysParaInfo.setHyqz(s.getValue());
                    break;
                }
                case "ZTKEY": {
                    sysParaInfo.setZtKey(s.getValue());
                    break;
                }
                case "ZRFS": {
                    sysParaInfo.setDiscByAmountMode(s.getValue());
                    break;
                }
                case "BBFS": {
                    sysParaInfo.setBasePaymentCode(s.getValue());
                    break;
                }
                case "4J": {
                    sysParaInfo.setMaxChangeValue(CastUtil.castDouble(s.getValue()));
                    break;
                }
                case "XDFS": {
                    String[] values;
                    if (!StringUtils.isNotBlank((String)s.getValue())) break;
                    sysParaInfo.setNoVoidPaymentCodes(new ArrayList<String>());
                    for (String code : values = s.getValue().split(",")) {
                        sysParaInfo.getNoVoidPaymentCodes().add(code);
                    }
                    continue block77;
                }
                case "WKFS": {
                    sysParaInfo.setTailPaymentCode(s.getValue());
                    break;
                }
                case "KHTH": {
                    if (!"N".equals(s.getValue())) break;
                    sysParaInfo.setIsAllowDeduct(false);
                    break;
                }
                case "YQSX": {
                    sysParaInfo.setMaxCoupon(CastUtil.castInt(s.getValue()));
                    break;
                }
                case "BKPT": {
                    sysParaInfo.setBackPrintUrl(s.getValue());
                    break;
                }
                case "QHRQ": {
                    sysParaInfo.setNoRefundDate(s.getValue());
                    break;
                }
                case "JYMS": {
                    if (!"1".equals(s.getValue()) || sysParaInfo.getBarCodeMode() >= 2) break;
                    sysParaInfo.setBarCodeMode(2);
                    break;
                }
                case "ZKSX": {
                    if (!StringUtils.isNotBlank((String)s.getValue())) break;
                    sysParaInfo.setOrderDiscSeq(s.getValue());
                    break;
                }
                case "ZBUP": {
                    if (!"Y".equals(s.getValue())) break;
                    sysParaInfo.setIsSendCust(true);
                    break;
                }
                case "KHMS": {
                    sysParaInfo.setDeductMode(s.getValue());
                    break;
                }
                case "SJKDZ": {
                    sysParaInfo.setMzkUrl(s.getValue());
                    break;
                }
                case "ZBHY": {
                    if (!StringUtils.isNotBlank((String)s.getValue())) break;
                    String[] values = s.getValue().split("#");
                    if (values.length >= 1) {
                        sysParaInfo.setCustMode(values[0]);
                    }
                    if (values.length < 2) continue block77;
                    sysParaInfo.setCustUrl(values[1]);
                    break;
                }
                case "PRTSEQ": {
                    String[] values;
                    if (!StringUtils.isNotBlank((String)s.getValue())) break;
                    sysParaInfo.setPopPrtSeq(new ArrayList<String>());
                    for (String code : values = s.getValue().split(",")) {
                        sysParaInfo.getPopPrtSeq().add(code);
                    }
                    continue block77;
                }
                case "SYMS": {
                    sysParaInfo.setOverageMode(s.getValue());
                    break;
                }
                case "HYPU": {
                    sysParaInfo.setPayUrl(s.getValue());
                    break;
                }
                case "ZBMCID": {
                    sysParaInfo.setOutErpCode(s.getValue());
                    break;
                }
                case "40": {
                    sysParaInfo.setAssistantMode(s.getValue());
                    break;
                }
                case "YGGW": {
                    sysParaInfo.setStaffMode(s.getValue());
                    break;
                }
                case "SCHS": {
                    if (!StringUtils.isNotBlank((String)s.getValue())) break;
                    String[] values = s.getValue().split(",");
                    if (values.length >= 1) {
                        sysParaInfo.setMaxDelNum(CastUtil.castInt(values[0]));
                    }
                    if (values.length < 2) continue block77;
                    sysParaInfo.setMinRemainNum(CastUtil.castInt(values[1]));
                    break;
                }
                case "SLXS": {
                    if (!"Y".equals(s.getValue())) break;
                    sysParaInfo.setDecimalNum(true);
                    break;
                }
                case "CMJY": {
                    if ("1".equals(s.getValue()) && sysParaInfo.getBarCodeMode() != 2) {
                        sysParaInfo.setBarCodeMode(1);
                    } else if ("2".equals(s.getValue())) {
                        sysParaInfo.setBarCodeMode(3);
                    }
                    sysParaInfo.setEleMode(s.getValue());
                    break;
                }
                case "DISCNAME": {
                    if (!StringUtils.isNotBlank((String)s.getValue())) break;
                    String[] names = s.getValue().split("\\|");
                    block80: for (int i = 0; i < names.length; ++i) {
                        if (i > 4) break block35;
                        String name = names[i];
                        if (!StringUtils.isNotBlank((String)name)) continue;
                        switch (i) {
                            case 0: {
                                sysParaInfo.setDpRateDes(name);
                                continue block80;
                            }
                            case 1: {
                                sysParaInfo.setDpAmountDes(name);
                                continue block80;
                            }
                            case 2: {
                                sysParaInfo.setZpRateDes(name);
                                continue block80;
                            }
                            case 3: {
                                sysParaInfo.setZpAmountDes(name);
                                continue block80;
                            }
                            case 4: {
                                sysParaInfo.setBarCodeDes(name);
                            }
                        }
                    }
                    continue block77;
                }
                case "POPPRTMODE": {
                    sysParaInfo.setPopPrtMode(s.getValue());
                    break;
                }
                case "CWYH": {
                    String[] values;
                    if (!StringUtils.isNotBlank((String)s.getValue())) break;
                    sysParaInfo.setCalcPriceType(new ArrayList<String>());
                    for (String code : values = s.getValue().split(",")) {
                        sysParaInfo.getCalcPriceType().add(code);
                    }
                    continue block77;
                }
            }
        }
        return sysParaInfo;
    }

    public ServiceResponse checkOrderStatus(ServiceSession session, JSONObject paramsObject) {
        if (!paramsObject.containsKey((Object)"flowNo") || paramsObject.getString("flowNo").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u67e5\u8be2\u8ba2\u5355\u72b6\u6001\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"flowNo"});
        }
        String flowNo = paramsObject.getString("flowNo");
        CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(flowNo);
        if (cacheModel == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355!", (Object[])new Object[]{flowNo});
        }
        if (cacheModel.getOrder().getSendSuccess()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355\u5df2\u4fdd\u5b58\u6210\u529f\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u4ed8\u6b3e\u4fe1\u606f");
        }
        return ServiceResponse.buildSuccess((Object)"\u8ba2\u5355\u672a\u4fdd\u5b58\u6210\u529f\uff0c\u53ef\u4ee5\u4fee\u6539\u4ed8\u6b3e\u4fe1\u606f\uff01");
    }

    public ServiceResponse updatePaymentStatus(ServiceSession session, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        UpdatePaymentStatusIn in = (UpdatePaymentStatusIn)JSON.parseObject((String)paramsObject.toJSONString(), UpdatePaymentStatusIn.class);
        CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(in.getFlowNo());
        if (cacheModel == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355", (Object[])new Object[]{in.getFlowNo()});
        }
        if (cacheModel.getOrder().getSendSuccess()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u63d0\u4ea4\u6210\u529f\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u4ed8\u6b3e\u4fe1\u606f", (Object[])new Object[]{in.getFlowNo()});
        }
        List<PaymentInfo> successList = in.getSuccessList();
        ArrayList deletePayments = new ArrayList();
        if (null != successList && successList.size() > 0) {
            block0: for (PaymentInfo success : successList) {
                if (!StringUtils.isNotBlank((String)success.getCardNo()) || !StringUtils.isNotBlank((String)success.getAmount())) continue;
                double amount = CastUtil.castDouble(success.getAmount()) / 100.0;
                for (int i = 0; i < cacheModel.getPayments().size(); ++i) {
                    Payment p = cacheModel.getPayments().get(i);
                    if (p.getIsSuccess() || !StringUtils.isNotBlank((String)p.getPayNo()) || !p.getPayNo().equals(success.getCardNo()) || p.getAmount() != amount) continue;
                    cacheModel.getPayments().get(i).setIsSuccess(true);
                    if (StringUtils.isNotBlank((String)success.getRefCode())) {
                        cacheModel.getPayments().get(i).setRefCode(success.getRefCode());
                    }
                    cacheModel.getPayments().get(i).setAmount(amount);
                    if (StringUtils.isNotBlank((String)success.getTrace())) {
                        cacheModel.getPayments().get(i).setTrace(CastUtil.castLong(success.getTrace()));
                    }
                    if (!StringUtils.isNotBlank((String)success.getCouponBalance())) continue block0;
                    cacheModel.getPayments().get(i).setCouponBalance(CastUtil.castDouble(success.getCouponBalance()));
                    continue block0;
                }
            }
        }
        for (int i = 0; i < cacheModel.getPayments().size(); ++i) {
            Payment p = cacheModel.getPayments().get(i);
            if (p.getIsSuccess()) continue;
            cacheModel.getPayments().remove(i);
            --i;
        }
        cacheModel = this.posLogicServiceImpl.CalcOrderAmountByDeletePayReturn(cacheModel);
        this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
        BaseOutModel out = new BaseOutModel();
        out.setOrder(OrderForPos.toOrderForPos(cacheModel));
        return ServiceResponse.buildSuccess((Object)out);
    }

    public static void main(String[] args) {
        System.out.println(CastUtil.castDouble("00000001200") / 100.0);
    }
}

