/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pos.component;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.pos.component.CommonService;
import com.efuture.pos.component.PosLogicServiceImpl;
import com.efuture.pos.model.CacheModel;
import com.efuture.pos.model.Goods;
import com.efuture.pos.model.Order;
import com.efuture.pos.model.Payment;
import com.efuture.pos.model.response.DeletePaymentOut;
import com.efuture.pos.model.response.PaymentOut;
import com.efuture.pos.pay.AllVPayTools;
import com.efuture.pos.pay.model.allVpay.request.PayQueryRequest;
import com.efuture.pos.pay.model.allVpay.request.PayRequest;
import com.efuture.pos.pay.model.allVpay.request.RefundPayQueryRequest;
import com.efuture.pos.pay.model.allVpay.request.RefundPayRequest;
import com.efuture.pos.pay.model.allVpay.request.RepealPayRequest;
import com.efuture.pos.pay.model.allVpay.response.PayQueryResponse;
import com.efuture.pos.pay.model.allVpay.response.PayResponse;
import com.efuture.pos.pay.model.allVpay.response.RefundPayQueryResponse;
import com.efuture.pos.pay.model.allVpay.response.RefundPayResponse;
import com.efuture.pos.pay.model.allVpay.response.RepealPayResponse;
import com.efuture.pos.service.PayService;
import com.efuture.pos.service.common.CacheModelService;
import com.efuture.pos.util.CardNoUtils;
import com.efuture.pos.util.ParamsValidateUtils;
import com.efuture.pos.util.UUIDUtils;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.client.RestTemplate;

public class PayServiceImp
extends CommonService
implements PayService {
    @Autowired
    AllVPayTools allVPayTools;
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    CacheModelService cacheModelService;
    @Autowired
    PosLogicServiceImpl posLogicServiceImpl;
    private static final String SUCCESS = "SUCCESS";

    public ServiceResponse salePay(ServiceSession session, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        if (!paramsObject.containsKey((Object)"paycode") || paramsObject.getString("paycode").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u4ed8\u6b3e\u65b9\u5f0f\u4ee3\u7801"});
        }
        if (!paramsObject.containsKey((Object)"payName") || paramsObject.getString("payName").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u4ed8\u6b3e\u65b9\u5f0f\u4ee3\u7801"});
        }
        if (!paramsObject.containsKey((Object)"payType") || paramsObject.getString("payType").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u652f\u4ed8\u7c7b\u578b"});
        }
        if (!paramsObject.containsKey((Object)"terminalSno") || paramsObject.getString("terminalSno").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u5c0f\u7968\u53f7"});
        }
        if (!paramsObject.containsKey((Object)"payShopCode") || paramsObject.getString("payShopCode").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u652f\u4ed8\u7cfb\u7edf\u914d\u7f6e\u7684\u95e8\u5e97\u53f7"});
        }
        if (!paramsObject.containsKey((Object)"idSheetNo") || paramsObject.getString("idSheetNo").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u652f\u4ed8\u5355\u53f7"});
        }
        if (!paramsObject.containsKey((Object)"payBarCode") || paramsObject.getString("payBarCode").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u652f\u4ed8\u7801"});
        }
        if (!paramsObject.containsKey((Object)"money") || paramsObject.getString("money").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u652f\u4ed8\u91d1\u989d"});
        }
        if (!paramsObject.containsKey((Object)"rate") || paramsObject.getDouble("rate").isNaN()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u6c47\u7387"});
        }
        if (!paramsObject.containsKey((Object)"precision") || paramsObject.getString("precision").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u56db\u820d\u4e94\u5165\u7cbe\u5ea6"});
        }
        ArrayList<PayRequest.GoodsPackage> goodsPackages = new ArrayList<PayRequest.GoodsPackage>();
        List<Goods> goodsList = this.cacheModelService.getGoodsListByFlowNo(paramsObject.getString("flowNo"));
        for (Goods goods : goodsList) {
            PayRequest.GoodsPackage goodsPackage = new PayRequest.GoodsPackage();
            goodsPackage.setBarcode(goods.getBarNo());
            goodsPackage.setBrandName(goods.getBrandName());
            goodsPackage.setCategory(goods.getCategory());
            goodsPackage.setCategoryName(goods.getCategory());
            goodsPackage.setGoodsMemo(goods.getMemo() == null ? "" : goods.getMemo());
            goodsPackage.setGoodsName(goods.getGoodsName());
            goodsPackage.setGoodsNo(goods.getGoodsNo());
            goodsPackage.setQty(String.valueOf((int)goods.getQty() * 1000));
            goodsPackage.setSaleAmount(String.valueOf((int)(goods.getSaleAmount() * 100.0)));
            goodsPackage.setSaleUnit(goods.getSaleUnit());
            goodsPackages.add(goodsPackage);
        }
        PayRequest payRequest = new PayRequest(paramsObject, goodsPackages);
        try {
            PayResponse payResponse = this.allVPayTools.salePay(payRequest);
            CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(paramsObject.getString("flowNo"));
            cacheModel = this.posLogicServiceImpl.calcBalance(cacheModel);
            Order order = cacheModel.getOrder();
            if (payResponse.getReturnCode().equals(SUCCESS) && payResponse.getBusinessResult().equals(SUCCESS)) {
                Payment payment = new Payment();
                payment.setPuid(UUIDUtils.buildPuid());
                payment.setRownoId(payment.getPuid());
                payment.setPayCode(paramsObject.getString("paycode"));
                payment.setPayName(paramsObject.getString("payName"));
                payment.setPayNo(CardNoUtils.encrypt(payRequest.getIdSheetNo()));
                if (null != paramsObject.getBoolean("invoiceFlag")) {
                    payment.setInvoiceFlag(paramsObject.getBoolean("invoiceFlag"));
                }
                if (null != paramsObject.getBoolean("creditsFlag")) {
                    payment.setCreditsFlag(paramsObject.getBoolean("creditsFlag"));
                }
                payment.setAmount(Double.valueOf(payRequest.getMoney()) * 0.01);
                payment.setRate(paramsObject.getDouble("rate"));
                payment.setPrecision(paramsObject.getString("precision"));
                payment.setFlag("1");
                payment.setTerminalNo(payRequest.getTerminalNo());
                payment.setTerminalSno(payRequest.getTerminalSno());
                payment.setDiscountValue(Double.valueOf(payResponse.getDiscounts()) + Double.valueOf(payResponse.getOtherDiscounts()));
                payment.setMerchantDiscountValue(Double.valueOf(payResponse.getDiscounts()));
                payment.setPayChannelDiscountValue(Double.valueOf(payResponse.getOtherDiscounts()));
                cacheModel = this.posLogicServiceImpl.calcPayAmout(cacheModel, payment);
                this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
                payResponse.setRemainValue(order.getRemainValue());
                payResponse.setOughtPay(order.getOughtPay());
                payResponse.setOverageValue(order.getOverageValue());
                payResponse.setExistPay(order.getExistPay());
                PaymentOut out = new PaymentOut(order, cacheModel.getPayments());
                return ServiceResponse.buildSuccess((Object)out);
            }
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u652f\u4ed8\u5931\u8d25\u539f\u56e0[{0}]", (Object[])new Object[]{JSON.toJSONString((Object)payResponse)});
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u652f\u4ed8\u5931\u8d25\u539f\u56e0[{0}]", (Object[])new Object[]{e.getMessage()});
        }
    }

    public ServiceResponse salePayQuery(ServiceSession session, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        if (!paramsObject.containsKey((Object)"payType") || paramsObject.getString("payType").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u652f\u4ed8\u67e5\u8be2\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u652f\u4ed8\u7c7b\u578b"});
        }
        if (!paramsObject.containsKey((Object)"terminalSno") || paramsObject.getString("terminalSno").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u652f\u4ed8\u67e5\u8be2\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u5c0f\u7968\u53f7"});
        }
        if (!paramsObject.containsKey((Object)"payShopCode") || paramsObject.getString("payShopCode").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u652f\u4ed8\u67e5\u8be2\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u652f\u4ed8\u7cfb\u7edf\u914d\u7f6e\u7684\u95e8\u5e97\u53f7"});
        }
        if (!paramsObject.containsKey((Object)"idSheetNo") || paramsObject.getString("idSheetNo").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u652f\u4ed8\u67e5\u8be2\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u652f\u4ed8\u5355\u53f7"});
        }
        if (!paramsObject.containsKey((Object)"createTime") || paramsObject.getString("createTime").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u652f\u4ed8\u67e5\u8be2\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u652f\u4ed8\u65f6\u95f4"});
        }
        PayQueryRequest payQueryRequest = new PayQueryRequest(paramsObject);
        try {
            PayQueryResponse rayResponse = this.allVPayTools.salePayQuery(payQueryRequest);
            if (rayResponse.getReturnCode().equals(SUCCESS) && rayResponse.getBusinessResult().equals(SUCCESS)) {
                return ServiceResponse.buildSuccess((Object)rayResponse);
            }
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u652f\u4ed8\u67e5\u8be2\u5931\u8d25\u539f\u56e0[{0}]", (Object[])new Object[]{JSON.toJSONString((Object)ServiceResponse.buildSuccess((Object)rayResponse))});
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u652f\u4ed8\u67e5\u8be2\u5931\u8d25\u539f\u56e0[{0}]", (Object[])new Object[]{e.getMessage()});
        }
    }

    public ServiceResponse saleRefund(ServiceSession session, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        if (!paramsObject.containsKey((Object)"paycode") || paramsObject.getString("paycode").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u9000\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u4ed8\u6b3e\u65b9\u5f0f\u4ee3\u7801"});
        }
        if (!paramsObject.containsKey((Object)"payName") || paramsObject.getString("payName").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u9000\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u4ed8\u6b3e\u65b9\u5f0f\u4ee3\u7801"});
        }
        if (!paramsObject.containsKey((Object)"terminalSno") || paramsObject.getString("terminalSno").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u9000\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u5c0f\u7968\u53f7"});
        }
        if (!paramsObject.containsKey((Object)"payShopCode") || paramsObject.getString("payShopCode").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u9000\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u652f\u4ed8\u7cfb\u7edf\u914d\u7f6e\u7684\u95e8\u5e97\u53f7"});
        }
        if (!paramsObject.containsKey((Object)"idSheetNo") || paramsObject.getString("idSheetNo").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u9000\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u9000\u6b3e\u5355\u53f7"});
        }
        if (!paramsObject.containsKey((Object)"originalIdSheetNo") || paramsObject.getString("originalIdSheetNo").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u9000\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u539f\u5355\u53f7"});
        }
        if (!paramsObject.containsKey((Object)"payType") || paramsObject.getString("payType").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u9000\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u652f\u4ed8\u7c7b\u578b"});
        }
        if (!paramsObject.containsKey((Object)"originalCreateTime") || paramsObject.getString("originalCreateTime").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u9000\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u539f\u5355\u652f\u4ed8\u65f6\u95f4"});
        }
        if (!paramsObject.containsKey((Object)"money") || paramsObject.getString("money").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u9000\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u539f\u5355\u652f\u4ed8\u91d1\u989d"});
        }
        if (!paramsObject.containsKey((Object)"refundMoney") || paramsObject.getString("refundMoney").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u9000\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u9000\u6b3e\u91d1\u989d"});
        }
        if (!paramsObject.containsKey((Object)"rate") || paramsObject.getDouble("rate").isNaN()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u6c47\u7387"});
        }
        if (!paramsObject.containsKey((Object)"precision") || paramsObject.getString("precision").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u652f\u4ed8\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u56db\u820d\u4e94\u5165\u7cbe\u5ea6"});
        }
        RefundPayRequest refundRequest = new RefundPayRequest(paramsObject);
        CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(paramsObject.getString("flowNo"));
        cacheModel = this.posLogicServiceImpl.calcBalance(cacheModel);
        Order order = cacheModel.getOrder();
        if (Integer.parseInt(refundRequest.getMoney()) > (int)(order.getRemainValue() * 100.0)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u539f\u652f\u4ed8\u91d1\u989d\u5fc5\u987b\u5c0f\u4e8e\u8ba2\u5355\u5269\u91d1\u4ed8\u6b3e", (Object[])new Object[]{""});
        }
        if (Integer.parseInt(refundRequest.getMoney()) < Integer.parseInt(refundRequest.getRefundMoney())) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u9000\u6b3e\u91d1\u989d\u5fc5\u987b\u5c0f\u4e8e\u539f\u5355\u652f\u4ed8\u91d1\u989d", (Object[])new Object[]{""});
        }
        try {
            RefundPayResponse refundPayResponse = this.allVPayTools.saleRefundPay(refundRequest);
            if (refundPayResponse.getReturnCode().equals(SUCCESS) && refundPayResponse.getBusinessResult().equals(SUCCESS)) {
                Payment payment = new Payment();
                payment.setPuid(UUIDUtils.buildPuid());
                payment.setRownoId(payment.getPuid());
                payment.setPayCode(paramsObject.getString("paycode"));
                payment.setPayName(paramsObject.getString("payName"));
                payment.setPayNo(CardNoUtils.encrypt(refundRequest.getIdSheetNo()));
                payment.setAmount(Double.valueOf(refundRequest.getMoney()) * 0.01);
                payment.setFlag("1");
                payment.setTerminalNo(refundRequest.getTerminalNo());
                payment.setTerminalSno(refundRequest.getTerminalSno());
                payment.setRate(paramsObject.getDouble("rate"));
                payment.setPrecision(paramsObject.getString("precision"));
                payment.setRowno(cacheModel.getPayments().size());
                if (null != paramsObject.getBoolean("invoiceFlag")) {
                    payment.setInvoiceFlag(paramsObject.getBoolean("invoiceFlag"));
                }
                if (null != paramsObject.getBoolean("creditsFlag")) {
                    payment.setCreditsFlag(paramsObject.getBoolean("creditsFlag"));
                }
                cacheModel = this.posLogicServiceImpl.calcPayAmout(cacheModel, payment);
                this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
                refundPayResponse.setRemainValue(order.getRemainValue());
                refundPayResponse.setOughtPay(order.getOughtPay());
                refundPayResponse.setOverageValue(order.getOverageValue());
                refundPayResponse.setExistPay(order.getExistPay());
                return ServiceResponse.buildSuccess((Object)refundPayResponse);
            }
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u9000\u6b3e\u5931\u8d25\u539f\u56e0[{0}]", (Object[])new Object[]{JSON.toJSONString((Object)refundPayResponse)});
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u9000\u6b3e\u5931\u8d25\u539f\u56e0[{0}]", (Object[])new Object[]{e.getMessage()});
        }
    }

    public ServiceResponse saleRefundQuery(ServiceSession session, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        if (!paramsObject.containsKey((Object)"terminalSno") || paramsObject.getString("terminalSno").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u9000\u6b3e\u67e5\u8be2\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u5c0f\u7968\u53f7"});
        }
        if (!paramsObject.containsKey((Object)"payShopCode") || paramsObject.getString("payShopCode").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u9000\u6b3e\u67e5\u8be2\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u652f\u4ed8\u7cfb\u7edf\u914d\u7f6e\u7684\u95e8\u5e97\u53f7"});
        }
        if (!paramsObject.containsKey((Object)"idSheetNo") || paramsObject.getString("idSheetNo").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u9000\u6b3e\u67e5\u8be2\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u9000\u6b3e\u5355\u53f7"});
        }
        if (!paramsObject.containsKey((Object)"originalIdSheetNo") || paramsObject.getString("originalIdSheetNo").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u9000\u6b3e\u67e5\u8be2\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u539f\u5355\u53f7"});
        }
        if (!paramsObject.containsKey((Object)"payType") || paramsObject.getString("payType").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u9000\u6b3e\u67e5\u8be2\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u652f\u4ed8\u7c7b\u578b"});
        }
        if (!paramsObject.containsKey((Object)"createTime") || paramsObject.getString("createTime").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u652f\u4ed8\u67e5\u8be2\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u9000\u6b3e\u65f6\u95f4"});
        }
        RefundPayQueryRequest refundQueryRequest = new RefundPayQueryRequest(paramsObject);
        try {
            RefundPayQueryResponse refundPayQueryResponse = this.allVPayTools.saleRefundPayQuery(refundQueryRequest);
            if (refundPayQueryResponse.getReturnCode().equals(SUCCESS) && refundPayQueryResponse.getBusinessResult().equals(SUCCESS)) {
                return ServiceResponse.buildSuccess((Object)refundPayQueryResponse);
            }
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u9000\u6b3e\u67e5\u8be2\u5931\u8d25\u539f\u56e0[{0}]", (Object[])new Object[]{JSON.toJSONString((Object)ServiceResponse.buildSuccess((Object)refundPayQueryResponse))});
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u9000\u6b3e\u67e5\u8be2\u5931\u8d25\u539f\u56e0[{0}]", (Object[])new Object[]{e.getMessage()});
        }
    }

    public ServiceResponse saleRepealPay(ServiceSession session, JSONObject paramsObject) {
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        if (!paramsObject.containsKey((Object)"payType") || paramsObject.getString("payType").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u64a4\u9500\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u652f\u4ed8\u7c7b\u578b"});
        }
        if (!paramsObject.containsKey((Object)"terminalSno") || paramsObject.getString("terminalSno").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u64a4\u9500\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u5c0f\u7968\u53f7"});
        }
        if (!paramsObject.containsKey((Object)"payShopCode") || paramsObject.getString("payShopCode").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u64a4\u9500\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u652f\u4ed8\u7cfb\u7edf\u914d\u7f6e\u7684\u95e8\u5e97\u53f7"});
        }
        if (!paramsObject.containsKey((Object)"idSheetNo") || paramsObject.getString("idSheetNo").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u64a4\u9500\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u652f\u4ed8\u5355\u53f7"});
        }
        if (!paramsObject.containsKey((Object)"originalIdSheetNo") || paramsObject.getString("originalIdSheetNo").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u64a4\u9500\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u539f\u5355\u53f7"});
        }
        if (!paramsObject.containsKey((Object)"originalCreateTime") || paramsObject.getString("originalCreateTime").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u64a4\u9500\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u539f\u5355\u652f\u4ed8\u65f6\u95f4"});
        }
        if (!paramsObject.containsKey((Object)"money") || paramsObject.getString("money").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u64a4\u9500\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u652f\u4ed8\u91d1\u989d"});
        }
        if (!paramsObject.containsKey((Object)"puid") || paramsObject.getString("puid").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u64a4\u9500\u4ed8\u6b3e\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"puid"});
        }
        RepealPayRequest repealPayRequest = new RepealPayRequest(paramsObject);
        try {
            RepealPayResponse rayResponse = this.allVPayTools.repealPay(repealPayRequest);
            CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(paramsObject.getString("flowNo"));
            Order order = cacheModel.getOrder();
            if (rayResponse.getReturnCode().equals(SUCCESS) && rayResponse.getBusinessResult().equals(SUCCESS)) {
                String puid = paramsObject.getString("puid");
                DeletePaymentOut out = new DeletePaymentOut();
                Payment payment = null;
                for (Payment p : cacheModel.getPayments()) {
                    if (!p.getPuid().equals(puid)) continue;
                    payment = p;
                    break;
                }
                if (payment != null) {
                    cacheModel.getPayments().remove(payment);
                    cacheModel = this.posLogicServiceImpl.CalcOrderAmountByDeletePayReturn(cacheModel);
                    if (cacheModel.getCalcResult() == -1) {
                        String errCode = "100000";
                        if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                            errCode = cacheModel.getErrCode();
                        }
                        return ServiceResponse.buildFailure((ServiceSession)session, (String)errCode, (String)cacheModel.getErrMsg());
                    }
                    this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
                    out.setExistPay(order.getExistPay());
                    out.setFlowNo(order.getFlowNo());
                    out.setOughtPay(order.getOughtPay());
                    out.setOverageValue(order.getOverageValue());
                    out.setTotalDiscountValue(order.getTotalDiscountValue());
                    out.setRemainValue(order.getRemainValue());
                    out.setSalePayments(cacheModel.getPayments());
                    return ServiceResponse.buildSuccess((Object)out);
                }
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u64a4\u9500\u4ed8\u6b3e\u5931\u8d25\u539f\u56e0[{0}]", (Object[])new Object[]{"\u4ed8\u6b3e\u884c\u4e3a\u7a7a"});
            }
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u64a4\u9500\u4ed8\u6b3e\u5931\u8d25\u539f\u56e0[{0}]", (Object[])new Object[]{JSON.toJSONString((Object)ServiceResponse.buildSuccess((Object)rayResponse))});
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u64a4\u9500\u4ed8\u6b3e\u5931\u8d25\u539f\u56e0[{0}]", (Object[])new Object[]{e.getMessage()});
        }
    }
}

