/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pos.component;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.pos.component.CommonService;
import com.efuture.pos.component.CouponServiceImpl;
import com.efuture.pos.component.service.CnaeonCentreService;
import com.efuture.pos.service.AeonCouponService;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@ConditionalOnProperty(name={"epos.run"}, havingValue="yes", matchIfMissing=true)
@Service
public class PointConsumeReverseServiceImpl
extends CommonService
implements AeonCouponService {
    private static final Logger logger = LoggerFactory.getLogger(CouponServiceImpl.class);
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    CnaeonCentreService cnaeonCentreService;
    @Value(value="${pointconsumereverse.path}")
    private String filePath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceResponse save(ServiceSession session, JSONObject paramsObject) {
        String fileName;
        File file;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        Date date = new Date();
        String format = sdf.format(date);
        String flowNo = paramsObject.getString("flowNo");
        File f = new File(this.filePath);
        if (!f.exists()) {
            f.mkdirs();
        }
        if (!(file = new File(fileName = this.filePath + File.separator + format + flowNo + ".txt")).exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                logger.error("\u6587\u4ef6\u521b\u5efa\u5931\u8d25:", (Throwable)e);
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u6587\u4ef6\u521b\u5efa\u5931\u8d25");
            }
        }
        Writer writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            writer.write(paramsObject.toString());
            writer.write(System.getProperty("line.separator"));
        }
        catch (IOException e) {
            logger.error("\u6587\u4ef6\u5199\u5165\u5931\u8d25:", (Throwable)e);
            ServiceResponse serviceResponse = ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u6587\u4ef6\u5199\u5165\u5931\u8d25");
            return serviceResponse;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    logger.error("\u6587\u4ef6\u5173\u95ed\u5f02\u5e38:", (Throwable)e);
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u6587\u4ef6\u5199\u5165\u5173\u95ed\u5f02\u5e38");
                }
            }
        }
        return ServiceResponse.buildSuccess((Object)("\u5199\u5165\u6210\u529f:" + paramsObject));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceResponse send(ServiceSession session, JSONObject paramsObject) {
        File folder = new File(this.filePath);
        if (!folder.exists()) {
            logger.info("\u627e\u4e0d\u5230\u6307\u5b9a\u6587\u4ef6\u5939");
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u627e\u4e0d\u5230\u6307\u5b9a\u6587\u4ef6\u5939");
        }
        File[] listFiles = folder.listFiles();
        LocalDateTime dateTime = LocalDateTime.now();
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
        BufferedReader br = null;
        JSONArray array = new JSONArray();
        try {
            int i;
            for (i = 0; i < listFiles.length; ++i) {
                File file = listFiles[i];
                String name = file.getName();
                try {
                    LocalDateTime orderDateTime = LocalDateTime.parse(name.substring(0, 14), df);
                    if (orderDateTime.isBefore(dateTime.minusDays(30L))) {
                        file.delete();
                    }
                }
                catch (Exception e) {}
                continue;
                FileReader reader = new FileReader(file);
                br = new BufferedReader(reader);
                while (br.ready()) {
                    String text = br.readLine();
                    Object parse = JSON.parse((String)text);
                    array.add(parse);
                }
                br.close();
                file.delete();
            }
            for (i = 0; i < array.size(); ++i) {
                JSONObject object = (JSONObject)array.get(i);
                ServiceResponse pointConsumeReverse = this.cnaeonCentreService.pointConsumeReverse(this.restTemplate, session, object.toString());
                logger.info(pointConsumeReverse + "");
                if ("0".equals(pointConsumeReverse.getReturncode())) continue;
                this.save(session, object);
            }
        }
        catch (IOException e) {
            logger.error("\u6587\u4ef6\u8bfb\u53d6\u9519\u8bef:", (Throwable)e);
            ServiceResponse serviceResponse = ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u6587\u4ef6\u8bfb\u53d6\u9519\u8bef");
            return serviceResponse;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    logger.error("\u6587\u4ef6\u5173\u95ed\u9519\u8bef:", (Throwable)e);
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u6587\u4ef6\u5173\u95ed\u9519\u8bef");
                }
            }
        }
        return ServiceResponse.buildSuccess((Object)"\u53d1\u9001\u6210\u529f");
    }
}

