/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pos.component;

import com.efuture.pos.component.PosLogicCompoment;
import com.efuture.pos.model.CacheModel;
import com.efuture.pos.model.Gift;
import com.efuture.pos.model.Goods;
import com.efuture.pos.model.Payment;
import com.efuture.pos.model.mainDataCentre.GoodsInfo;
import com.efuture.pos.model.posManager.response.QueryAeonCouponOut;
import com.efuture.pos.model.promotionCentre.response.CalSaleReturnOut;
import com.efuture.pos.model.promotionCentre.response.CalcOut;
import com.efuture.pos.model.promotionCentre.response.CalcsingleOut;
import com.efuture.pos.model.promotionCentre.response.ConfirmAffirmreturnOut;
import com.efuture.pos.model.promotionCentre.response.CouponGainCalcOut;
import com.efuture.pos.service.common.CacheModelService;
import com.product.model.ServiceSession;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@ConditionalOnProperty(name={"epos.run"}, havingValue="yes", matchIfMissing=true)
@Service
public class PosLogicServiceImpl
extends PosLogicCompoment {
    @Autowired
    CacheModelService cacheModelService;

    public Goods CalcGoodsAmountBeforeSingle(GoodsInfo sg, String assistantId, boolean isdzcm, double dzcmsl, double dzcmjg, String mode, String originalBarNo, double qty) {
        return this.CalcGoodsAmount(sg, assistantId, isdzcm, dzcmsl, dzcmjg, mode, originalBarNo, qty);
    }

    public CacheModel CalcGoodsAmountAfterSingle(CacheModel order, CalcsingleOut promotionOut, int flowId) {
        return this.CalcResponsePopSingle(order, promotionOut, flowId);
    }

    public CacheModel CalcGoodsAmountAfterSingleAll(CacheModel order, CalcsingleOut promotionOut, boolean needCalcDisc) {
        return this.CalcResponsePopSingleAll(order, promotionOut, needCalcDisc);
    }

    public CacheModel CalcGoodsAmountAfterStampCode(CacheModel order, String stampCode) {
        return this.AddStampCodeGood(order, stampCode);
    }

    public CacheModel CalcGoodsAmountAfterOrder(CacheModel order, CalcOut promotionOut, String calcMode, boolean isCalcGifts, ServiceSession session) {
        return this.CalcResponsePopOrder(order, promotionOut, calcMode, isCalcGifts, session);
    }

    public CacheModel CalcGoodsAmountAfterOrder(CacheModel order, CalSaleReturnOut promotionOut) {
        return order;
    }

    public CacheModel CalcGoodsRebateByAmountBeforeSingle(CacheModel order, int flow_id, String accreditNo, double discountAmount, int mode, boolean isZero) {
        return this.CalcGoodsRebateByAmount(order, flow_id, accreditNo, discountAmount, mode, isZero, true);
    }

    public CacheModel CalcGoodsRebateByRateBeforeSingle(CacheModel order, int flow_id, String accreditNo, double discountRate) {
        return this.CalcGoodsRebateByRate(order, flow_id, accreditNo, discountRate, true);
    }

    public CacheModel CalcOrderRebateByRateBeforeOrder(CacheModel order, String accreditNo, double discountRate) {
        return this.CalcOrderRebateByRate(order, accreditNo, discountRate, true);
    }

    public CacheModel CalcOrderRebateByAmountBeforeOrder(CacheModel order, String accreditNo, double discountAmount, int mode) {
        return this.CalcOrderRebateByAmount(order, accreditNo, discountAmount, mode, false, true);
    }

    public CacheModel EditGoodsQtyBeforeSingle(CacheModel order, int flow_id, String accreditNo, double qty) {
        return this.EditGoodsQty(order, flow_id, accreditNo, qty);
    }

    public CacheModel EditGoodsPriceBeforeSingle(CacheModel order, int flow_id, String accreditNo, double price) {
        return this.EditGoodsPrice(order, flow_id, accreditNo, price);
    }

    public CacheModel FixGoodsPriceBeforeSingle(CacheModel order, int flow_id, String accreditNo, double price) {
        return this.FixGoodsPrice(order, flow_id, accreditNo, price);
    }

    public CacheModel RefreshOrderAfterOrderSave(CacheModel order, CouponGainCalcOut promotionOut) {
        return this.RefreshAfterOrderSave(order, promotionOut);
    }

    public CacheModel CalcOrderAmountBeforeOrder(CacheModel order) {
        this.calcOrderAmount(order);
        return order;
    }

    public CacheModel CalcOrderAmountAfterCheckReturn(CacheModel order, CalSaleReturnOut promotionOut, String calcMode, String noYpopCodes, String autoBackPayCode, String giftMode, String thMode, List<Gift> giftgoods, ServiceSession session) {
        if (calcMode.equals("0")) {
            return this.CalcOrderAfterCheckReturnMode0(order, promotionOut, noYpopCodes, session);
        }
        if (calcMode.equals("1")) {
            return this.CalcOrderAfterCheckReturnMode1(order, giftgoods, autoBackPayCode, giftMode, session);
        }
        if (calcMode.equals("2")) {
            return this.CalcOrderAfterCheckReturnMode2(order, autoBackPayCode, thMode);
        }
        return order;
    }

    public CacheModel RefreshOrderAmountAfterAffirmReturn(CacheModel order, ConfirmAffirmreturnOut promotionOut) {
        return this.CalcOrderAfterAffirmReturn(order, promotionOut);
    }

    public CacheModel CalcOrderAmountByPayReturn(CacheModel order, Payment payment) {
        return this.calcPayAmout(order, payment);
    }

    public CacheModel CalcOrderAmountByDeletePayReturn(CacheModel cacheModel) {
        return this.CalcDeletePay(cacheModel);
    }

    public double CalcPopDetail(CacheModel order) {
        return this.CalcPopDiscountAmount(order);
    }

    public boolean JYPopDetail(double discountAmount, CacheModel order) {
        return this.JYPopDiscountAmount(discountAmount, order);
    }

    public CacheModel clearPop(CacheModel order) {
        return this.clearGoodsPop(order);
    }

    public CacheModel CalcAeonOldCouponAmount(CacheModel order, QueryAeonCouponOut coupon) {
        return this.CalcAeonOldCoupon(order, coupon);
    }

    public CacheModel CalcAeonPrivilegeCouponAmount(CacheModel order, QueryAeonCouponOut coupon, String code1, String code2) {
        return this.CalcAeonPrivilegeCoupon(order, coupon, code1, code2);
    }

    public CacheModel CalcAmcPointsRenew(CacheModel order, Payment payment) {
        return this.CalcAmcPoints(order, payment);
    }

    public CacheModel RefreshTerminalSno(CacheModel cacheModel, String newTerminalSno) {
        return this.refreshTerminalSno(cacheModel, newTerminalSno);
    }
}

