/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pos.component;

import com.efuture.pos.component.CommonService;
import com.efuture.pos.component.MemberServiceImpl;
import com.efuture.pos.component.PosLogicCompoment;
import com.efuture.pos.component.PosLogicServiceImpl;
import com.efuture.pos.component.common.SellType;
import com.efuture.pos.component.common.YPopStatusType;
import com.efuture.pos.component.service.ChinaYWService;
import com.efuture.pos.model.CacheModel;
import com.efuture.pos.model.Goods;
import com.efuture.pos.model.Payment;
import com.efuture.pos.model.PopDetail;
import com.efuture.pos.model.promotionCentre.SellPayment;
import com.efuture.pos.model.promotionCentre.request.CalcIn;
import com.efuture.pos.model.promotionCentre.request.CalcsingleIn;
import com.efuture.pos.model.promotionCentre.request.CouponGainCalcIn;
import com.efuture.pos.model.promotionCentre.request.CouponuseConsumeIn;
import com.efuture.pos.model.promotionCentre.response.CalcOut;
import com.efuture.pos.model.promotionCentre.response.CalcsingleOut;
import com.efuture.pos.model.promotionCentre.response.CouponGainCalcOut;
import com.efuture.pos.service.PromotionService;
import com.efuture.pos.service.common.CacheModelService;
import com.efuture.pos.service.sync.SyncTradeService;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@ConditionalOnProperty(name={"epos.run"}, havingValue="yes", matchIfMissing=true)
@Service
public class PromotionServiceImpl
extends CommonService
implements PromotionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MemberServiceImpl.class);
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    CacheModelService cacheModelService;
    @Autowired
    PosLogicServiceImpl posLogicServiceImpl;
    @Autowired
    PosLogicCompoment posLogicCompoment;
    @Autowired
    SyncTradeService syncTradeServiceImpl;
    @Autowired
    PosLogicServiceImpl posLogicService;
    @Autowired
    private ChinaYWService chinaYWService;

    public CacheModel calcSinglePop(ServiceSession session, String calcMode, String guid, Goods goods, CacheModel cacheModel, List<PopDetail> popDetails, boolean isAdd, boolean isRefreshBillId) {
        return this.calcSinglePop(session, calcMode, guid, goods, cacheModel, popDetails, isAdd, isRefreshBillId, false);
    }

    public CacheModel calcSinglePop(ServiceSession session, String calcMode, String guid, Goods goods, CacheModel cacheModel, List<PopDetail> popDetails, boolean isAdd, boolean isRefreshBillId, boolean isNeedPopDetail) {
        Object calcResp;
        CalcsingleOut calcsingleOut = null;
        CalcsingleIn calcsingleIn = null;
        if ("0".equals(calcMode)) {
            cacheModel.callMarketClear();
            calcsingleIn = CalcsingleIn.buildGetSaleGoodsInfoCalc(session, calcMode, goods, cacheModel.getOrder(), isRefreshBillId, isNeedPopDetail);
            calcResp = this.promotionCentreService.callCalcsingle(this.restTemplate, session, calcsingleIn);
            if (!"0".equals(calcResp.getReturncode())) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrCode("100000");
                cacheModel.setErrMsg(calcResp.getData().toString());
                return cacheModel;
            }
            calcsingleOut = (CalcsingleOut)calcResp.getData();
            cacheModel.getOrder().setSeqNo(calcsingleOut.getCalcBillid());
            if (isAdd) {
                cacheModel = this.cacheModelService.addOneGoods(cacheModel, goods);
            }
        }
        if ("1".equals(calcMode)) {
            if (popDetails == null || popDetails.isEmpty()) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrCode("100000");
                cacheModel.setErrMsg("\u6ca1\u6709\u9009\u62e9\u4fc3\u9500\uff0c\u6dfb\u52a0\u5931\u8d25");
                return cacheModel;
            }
            if (guid == null || StringUtils.isBlank((String)guid)) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrCode("100000");
                cacheModel.setErrMsg("\u9009\u62e9\u4fc3\u9500\u540e\u91cd\u7b97\u5355\u884c\u5fc5\u987b\u8f93\u5165\u5305\u542bguid");
                return cacheModel;
            }
            if (cacheModel.getGoodsList() != null && cacheModel.getGoodsList().size() > 0) {
                for (Goods goodsA : cacheModel.getGoodsList()) {
                    if (!goodsA.getGuid().equals(guid)) continue;
                    goods = goodsA;
                    break;
                }
            }
            if (goods == null) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrCode("100000");
                cacheModel.setErrMsg("\u8d2d\u7269\u8f66\u4e0d\u5b58\u5728\u8be5\u5546\u54c1\u6216\u5df2\u88ab\u5220\u9664");
                return cacheModel;
            }
            goods.setPopDetailsInfo(popDetails);
            calcsingleIn = CalcsingleIn.buildGetSaleGoodsInfoCalc(session, calcMode, goods, cacheModel.getOrder(), isRefreshBillId);
            cacheModel.callMarketClear();
            calcResp = this.promotionCentreService.callCalcsingle(this.restTemplate, session, calcsingleIn);
            if (!"0".equals(calcResp.getReturncode())) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrCode("100000");
                cacheModel.setErrMsg("\u8d2d\u7269\u8f66\u4e0d\u5b58\u5728\u8be5\u5546\u54c1\u6216\u5df2\u88ab\u5220\u9664");
                return cacheModel;
            }
            calcsingleOut = (CalcsingleOut)calcResp.getData();
        }
        cacheModel = this.posLogicService.CalcGoodsAmountAfterSingle(cacheModel, calcsingleOut, goods.getFlowId());
        return cacheModel;
    }

    public CacheModel calcOrderPop(ServiceSession session, String calcMode, CacheModel cacheModel, boolean isCalcGifts, boolean isNewCalcId, boolean isRemoveAdjustDisc) {
        return this.calcOrderPop(session, calcMode, cacheModel, isCalcGifts, isNewCalcId, isRemoveAdjustDisc, false);
    }

    public CacheModel calcOrderPop(ServiceSession session, String calcMode, CacheModel cacheModel, boolean isCalcGifts, boolean isNewCalcId, boolean isRemoveAdjustDisc, boolean isNeedPopDetail) {
        CalcIn calcIn = new CalcIn();
        boolean isNeedContinue = false;
        boolean isAddGoods = false;
        isNewCalcId = false;
        cacheModel.getOrder().setCalcMarketingMode("0");
        do {
            isNeedContinue = false;
            calcIn.fromCacheModel(cacheModel, isNewCalcId, isRemoveAdjustDisc);
            cacheModel.clearOrderlist();
            cacheModel.getGiftsGroup().clear();
            calcIn.setCalcMode(calcMode);
            isNewCalcId = false;
            ServiceResponse calcOutRes = this.promotionCentreService.callCalc(this.restTemplate, session, calcIn);
            if (!calcOutRes.getReturncode().equals("0")) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrCode("100000");
                cacheModel.setErrMsg("\u8ba1\u7b97\u6574\u5355\u4f18\u60e0\u5931\u8d25");
                return cacheModel;
            }
            CalcOut calcOut = (CalcOut)calcOutRes.getData();
            if ((cacheModel = this.posLogicServiceImpl.CalcGoodsAmountAfterOrder(cacheModel, calcOut, calcMode, isCalcGifts, session)).getCalcResult() == -1) {
                return cacheModel;
            }
            cacheModel.getOrder().setSeqNo(calcOut.getCalcBillid());
            if (isCalcGifts) {
                if (!("0".equals(calcOut.getCalcResult()) || "2".equals(calcOut.getCalcResult()) || "3".equals(calcOut.getCalcResult()) || "4".equals(calcOut.getCalcResult()))) {
                    isNeedContinue = true;
                    cacheModel.getOrder().setCalcMarketingMode(calcOut.getCalcResult());
                    calcMode = calcOut.getCalcResult();
                }
                if ("4".equals(calcOut.getCalcResult()) && (null == cacheModel.getGiftsGroup() || cacheModel.getGiftsGroup().size() <= 0)) {
                    isNeedContinue = true;
                    cacheModel.getOrder().setCalcMarketingMode("7");
                    calcMode = "7";
                }
            }
            this.posLogicServiceImpl.calcOrderAmount(cacheModel);
            if (-1 == cacheModel.getCalcResult()) {
                return cacheModel;
            }
            if (!isNeedContinue) continue;
        } while (isNeedContinue || cacheModel.getCalcResult() == -999);
        if (cacheModel.getGiftsGroup().size() <= 0 && cacheModel.getExceptPayDetails().size() <= 0 && cacheModel.getLimitedPayDetails().size() <= 0 && isAddGoods) {
            this.posLogicServiceImpl.calcOrderAmount(cacheModel);
            cacheModel.setCalcResult(-3);
        }
        return cacheModel;
    }

    public CacheModel calcSinglePopAll(ServiceSession session, String calcMode, CacheModel cacheModel, boolean needCalcDisc) {
        double tempZZk = cacheModel.getOrder().getTempZzk();
        double tempZZr = cacheModel.getOrder().getTempZzr();
        CalcsingleIn calcsingleIn = CalcsingleIn.buildAddBatchGoodsCalc(session, cacheModel.getGoodsList(), cacheModel.getOrder());
        ServiceResponse calcResp = this.promotionCentreService.callCalcsingle(this.restTemplate, session, calcsingleIn);
        if (!"0".equals(calcResp.getReturncode())) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("100000");
            cacheModel.setErrMsg("\u8425\u9500\u4e2d\u5fc3\u8ba1\u7b97\u5355\u884c\u51fa\u9519");
            return cacheModel;
        }
        CalcsingleOut calcsingleOut = (CalcsingleOut)calcResp.getData();
        cacheModel = this.posLogicService.CalcGoodsAmountAfterSingleAll(cacheModel, calcsingleOut, needCalcDisc);
        if (tempZZk != 100.0) {
            cacheModel = this.posLogicCompoment.CalcOrderRebateByRate(cacheModel, cacheModel.getCurGrant().getGh(), tempZZk);
        }
        if (tempZZr != 0.0) {
            cacheModel = this.posLogicCompoment.CalcOrderRebateByAmount(cacheModel, cacheModel.getCurGrant().getGh(), tempZZr);
        }
        return cacheModel;
    }

    public CacheModel calcCouponGain(ServiceSession session, CacheModel cacheModel) {
        CouponuseConsumeIn couponuseConsumeIn = new CouponuseConsumeIn();
        couponuseConsumeIn.setBillno(cacheModel.getOrder().getFlowNo());
        couponuseConsumeIn.setCalcBillId(cacheModel.getOrder().getSeqNo());
        couponuseConsumeIn.setType("0");
        CouponGainCalcIn couponGainCalcIn = new CouponGainCalcIn();
        couponGainCalcIn.fromCacheModel(cacheModel);
        double discountAmount = this.posLogicServiceImpl.CalcPopDetail(cacheModel);
        ServiceResponse response = this.promotionCentreService.coupongainCalc(this.restTemplate, session, couponGainCalcIn);
        LOGGER.info("returncode = " + response.getReturncode());
        Object responseNew = null;
        if (!response.getReturncode().equals("0")) {
            if (YPopStatusType.returncode_88888.equals(response.getReturncode())) {
                couponGainCalcIn.setCalcBillid("");
                response = this.promotionCentreService.coupongainCalc(this.restTemplate, session, couponGainCalcIn);
                LOGGER.info("\u7b2c\u4e8c\u6b21returncode = " + response.getReturncode());
                if (!(response.getReturncode().equals("0") || "Y10".equals(cacheModel.getOrder().getOrderType()) || "Y11".equals(cacheModel.getOrder().getOrderType()) || SellType.ISEXERCISE(cacheModel.getOrder().getOrderType()))) {
                    if (!"60003".equals(response.getReturncode())) {
                        List<SellPayment> reversePayments = couponuseConsumeIn.getSellPayments();
                        cacheModel.setReversePayments(reversePayments);
                        response.setReturncode(this.couponConsume(cacheModel, session, 2).getReturncode());
                    }
                    cacheModel.setCalcResult(-1);
                    cacheModel.setErrCode(response.getReturncode());
                    cacheModel.setErrMsg("\u4fc3\u9500\u4e2d\u5fc3\u4fdd\u5b58\u8ba2\u5355\u5931\u8d25");
                    return cacheModel;
                }
            } else if (!("Y10".equals(cacheModel.getOrder().getOrderType()) || "Y11".equals(cacheModel.getOrder().getOrderType()) || SellType.ISEXERCISE(cacheModel.getOrder().getOrderType()))) {
                if (!"60003".equals(response.getReturncode())) {
                    List<SellPayment> reversePayments = couponuseConsumeIn.getSellPayments();
                    cacheModel.setReversePayments(reversePayments);
                    response.setReturncode(this.couponConsume(cacheModel, session, 2).getReturncode());
                }
                cacheModel.setCalcResult(-1);
                cacheModel.setErrCode(response.getReturncode());
                cacheModel.setErrMsg("\u4fc3\u9500\u4e2d\u5fc3\u4fdd\u5b58\u8ba2\u5355\u5931\u8d25");
                return cacheModel;
            }
        }
        LOGGER.info("\u8425\u9500\u4fdd\u5b58\u5b8c\u6bd5");
        CouponGainCalcOut couponGainCalcOut = (CouponGainCalcOut)response.getData();
        cacheModel = this.posLogicServiceImpl.RefreshOrderAfterOrderSave(cacheModel, couponGainCalcOut);
        if (cacheModel.getOrder().getThisTimePoint() > 0.0) {
            cacheModel.getOrder().getConsumersData().setMemberActionSno(cacheModel.getOrder().getTerminalNo() + new Date().getTime());
        }
        if (cacheModel == null || !this.posLogicServiceImpl.JYPopDiscountAmount(discountAmount, cacheModel)) {
            cacheModel = this.posLogicServiceImpl.deletePopDetail(cacheModel);
            List<SellPayment> reversePayments = couponuseConsumeIn.getSellPayments();
            cacheModel.setReversePayments(reversePayments);
            response = ServiceResponse.buildFailure((ServiceSession)session, (String)this.couponConsume(cacheModel, session, 3).getReturncode(), (String)"\u4fc3\u9500\u6298\u6263\u4e0d\u4e00\u81f4!");
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode(response.getReturncode());
            cacheModel.setErrMsg("\u4fc3\u9500\u6298\u6263\u4e0d\u4e00\u81f4!");
            return cacheModel;
        }
        return cacheModel;
    }

    private ServiceResponse couponConsume(CacheModel cacheModel, ServiceSession session, int payConfirmStatus) {
        try {
            CouponuseConsumeIn couponuseConsumeIn = new CouponuseConsumeIn();
            couponuseConsumeIn.setBillno(cacheModel.getOrder().getFlowNo());
            couponuseConsumeIn.setCalcBillId(cacheModel.getOrder().getSeqNo());
            couponuseConsumeIn.setType("1");
            ServiceResponse response = this.promotionCentreService.couponAndPointsConsume(this.restTemplate, session, couponuseConsumeIn);
            if ("0".equals(response.getReturncode()) || YPopStatusType.returncode_99998.equals(response.getReturncode())) {
                cacheModel.getReversePayments().clear();
                payConfirmStatus = 0;
                response.setReturncode("2000");
            } else {
                response.setReturncode("2001");
                payConfirmStatus = Integer.valueOf(payConfirmStatus + "1");
                String msg = "\u51b2\u6b63\u5931\u8d25-" + payConfirmStatus + "-" + response.getData();
                response.setData((Object)msg);
            }
            cacheModel.setPayConfirmStatus(payConfirmStatus);
            cacheModel = this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
            return response;
        }
        catch (Exception e) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)e.getMessage());
        }
    }

    public CacheModel couponuseConsumeForPay(CacheModel cacheModel, ServiceSession session) {
        try {
            CouponuseConsumeIn couponuseConsumeIn = new CouponuseConsumeIn();
            couponuseConsumeIn.setBillno(cacheModel.getOrder().getFlowNo());
            couponuseConsumeIn.setCalcBillId(cacheModel.getOrder().getSeqNo());
            couponuseConsumeIn.setType("0");
            List<Payment> couponPayments = this.posLogicServiceImpl.getCouponPayments(cacheModel.getPayments());
            if (couponPayments != null && couponPayments.size() != 0) {
                couponuseConsumeIn.setSellPayments(Payment.transferSellPayment(cacheModel.getPayments(), SellType.ISBACK(cacheModel.getOrder().getOrderType())));
                ServiceResponse response = this.promotionCentreService.cpfconsume(this.restTemplate, session, couponuseConsumeIn);
                if (!"0".equals(response.getReturncode())) {
                    cacheModel.setCalcResult(-1);
                    cacheModel.setErrCode(response.getReturncode());
                    if (null == response.getData() || "".equals(response.getData().toString())) {
                        cacheModel.setErrMsg(response.getData().toString());
                    } else {
                        cacheModel.setErrMsg(response.getData().toString());
                    }
                    return cacheModel;
                }
            }
            return cacheModel;
        }
        catch (Exception e) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("100000");
            cacheModel.setErrMsg(e.getMessage());
            return cacheModel;
        }
    }
}

