/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pos.component;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.pos.component.CommonService;
import com.efuture.pos.component.OrderServiceImpl;
import com.efuture.pos.component.PosLogicCompoment;
import com.efuture.pos.model.AnalyzeBarcodeDef;
import com.efuture.pos.model.DzcGoodsDetail;
import com.efuture.pos.model.SysPara;
import com.efuture.pos.model.posManager.ElecScaleCodeRule;
import com.efuture.pos.model.posManager.request.ElecScaleCodeRuleIn;
import com.efuture.pos.model.posManager.response.ElecScaleCodeRuleOut;
import com.efuture.pos.model.request.QueryStockIn;
import com.efuture.pos.model.request.SearchStocksIn;
import com.efuture.pos.model.response.QueryGoodWarehouseOut;
import com.efuture.pos.model.warehouseCentre.request.SearchShopStockIn;
import com.efuture.pos.model.warehouseCentre.request.SearchStocksWIn;
import com.efuture.pos.model.warehouseCentre.response.SearchShopStockOut;
import com.efuture.pos.model.warehouseCentre.response.SearchStocksOut;
import com.efuture.pos.service.WareHouseService;
import com.efuture.pos.service.common.CacheModelService;
import com.efuture.pos.util.CastUtil;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.client.RestTemplate;

public class WareHouseServiceImpl
extends CommonService
implements WareHouseService {
    private static final Logger LOGGER = LoggerFactory.getLogger(WareHouseServiceImpl.class);
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    OrderServiceImpl orderService;
    @Autowired
    CacheModelService cacheModelService;
    @Autowired
    PosLogicCompoment posLogicCompoment;

    public ServiceResponse getGoodWareHouse(ServiceSession session, JSONObject paramsObject) {
        SearchShopStockOut searchShopStockOut;
        SearchShopStockIn in;
        if (paramsObject == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50003");
        }
        Long entId = paramsObject.getLong("entId");
        if (entId == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u67e5\u8be2\u5e93\u5b58\u7684\u53c2\u6570entId\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{new Object()});
        }
        session.setEnt_id(entId.longValue());
        if (StringUtils.isEmpty((CharSequence)paramsObject.getString("erpCode"))) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"erpCode\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{new Object()});
        }
        if (StringUtils.isEmpty((CharSequence)paramsObject.getString("barNo"))) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5546\u54c1\u6761\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{new Object()});
        }
        QueryStockIn queryStockIn = (QueryStockIn)JSON.parseObject((String)paramsObject.toJSONString(), QueryStockIn.class);
        ElecScaleCodeRuleIn elecScaleCodeRuleIn = new ElecScaleCodeRuleIn();
        elecScaleCodeRuleIn.setErpCode(queryStockIn.getErpCode());
        elecScaleCodeRuleIn.setMkt(queryStockIn.getShopCode());
        ServiceResponse respElec = this.posManagerService.getElecCode(this.restTemplate, session, elecScaleCodeRuleIn);
        ArrayList<String> codes = new ArrayList<String>();
        codes.add("JYMS");
        List<SysPara> sysPara = this.orderService.getSyspara(session, codes, queryStockIn.getErpCode(), queryStockIn.getShopCode());
        String jyms = SysPara.getSysParaInfo(sysPara, "JYMS");
        boolean isdzcm = false;
        boolean isNeedFindMdm = true;
        DzcGoodsDetail dzc = null;
        boolean isNeedFindDzc = true;
        String eleMode = "";
        int priceMode = 0;
        String originalBarNo = null;
        int disMode = 0;
        double disValue = 0.0;
        int barNoMode = 0;
        ServiceResponse serviceResponse = null;
        if (isNeedFindMdm && (queryStockIn.getBarNo().startsWith("20") || queryStockIn.getBarNo().startsWith("29")) && (serviceResponse = this.warehouseCentreService.searchShopStock(this.restTemplate, session, in = new SearchShopStockIn().transferQueryStockInToGetGoodWarehouseIn(queryStockIn, barNoMode))).getReturncode().trim().equals("0") && null != (searchShopStockOut = (SearchShopStockOut)serviceResponse.getData()).getShopStockList() && searchShopStockOut.getShopStockList().size() > 0) {
            QueryGoodWarehouseOut queryGoodWarehouseOut = new QueryGoodWarehouseOut();
            queryGoodWarehouseOut.setShopStockList(searchShopStockOut.getShopStockList());
            return ServiceResponse.buildSuccess((Object)queryGoodWarehouseOut);
        }
        if (isNeedFindMdm && "0".equals(respElec.getReturncode())) {
            AnalyzeBarcodeDef codeInfo;
            ElecScaleCodeRuleOut elecCodeRuleOut = (ElecScaleCodeRuleOut)respElec.getData();
            List<ElecScaleCodeRule> elecCodeRules = elecCodeRuleOut.getElecscalecoderule();
            eleMode = elecCodeRuleOut.getCodeRule();
            if ("1".equals(eleMode)) {
                barNoMode = 1;
            }
            if ("1".equals(jyms)) {
                barNoMode = 2;
            }
            if (!(codeInfo = this.posLogicCompoment.analyzeCodeInfo(barNoMode, queryStockIn.getBarNo(), "0")).getValidate()) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8be5\u6761\u5f62\u7801\u65e0\u6cd5\u901a\u8fc7\u6821\u9a8c\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165");
            }
            queryStockIn.setBarNo(codeInfo.getBarNo());
            isNeedFindDzc = codeInfo.getIsNeedFindDzc();
            priceMode = codeInfo.getPriceMode();
            originalBarNo = codeInfo.getOriginalBarNo();
            disMode = codeInfo.getDisMode();
            disValue = codeInfo.getDisValue();
            barNoMode = codeInfo.getBarNoMode();
            if (isNeedFindDzc && elecCodeRules.size() > 0) {
                dzc = this.posLogicCompoment.analyzeBarcode(queryStockIn.getBarNo(), elecCodeRules, elecCodeRules.get(0).getExpModeMMDDDays(), elecCodeRules.get(0).getExpModeDDHHDays(), elecCodeRuleOut.getCodeRule());
                if (dzc.getRetCode() == 2) {
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8be5\u5546\u54c1\u5df2\u8fc7\u671f\uff0c\u4e0d\u5141\u8bb8\u9500\u552e");
                }
                if (dzc.getRetCode() == 1) {
                    isdzcm = true;
                }
            }
        }
        if (!(serviceResponse = this.warehouseCentreService.searchShopStock(this.restTemplate, session, in = new SearchShopStockIn().transferQueryStockInToGetGoodWarehouseIn(queryStockIn, barNoMode))).getReturncode().trim().equals("0")) {
            return serviceResponse;
        }
        searchShopStockOut = (SearchShopStockOut)serviceResponse.getData();
        QueryGoodWarehouseOut queryGoodWarehouseOut = new QueryGoodWarehouseOut();
        queryGoodWarehouseOut.setShopStockList(searchShopStockOut.getShopStockList());
        return ServiceResponse.buildSuccess((Object)queryGoodWarehouseOut);
    }

    public ServiceResponse searchStocks(ServiceSession session, JSONObject paramsObject) {
        if (paramsObject == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50003");
        }
        Long entId = paramsObject.getLong("entId");
        if (entId == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u67e5\u8be2\u5e93\u5b58\u7684\u53c2\u6570entId\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{new Object()});
        }
        session.setEnt_id(entId.longValue());
        if (StringUtils.isEmpty((CharSequence)paramsObject.getString("code"))) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"erpCode\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{new Object()});
        }
        if (StringUtils.isEmpty((CharSequence)paramsObject.getString("erpCode"))) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"erpCode\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{new Object()});
        }
        if (StringUtils.isEmpty((CharSequence)paramsObject.getString("shopCode"))) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5546\u54c1\u6761\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{new Object()});
        }
        SearchStocksIn searchStocksIn = (SearchStocksIn)JSON.parseObject((String)paramsObject.toJSONString(), SearchStocksIn.class);
        ElecScaleCodeRuleIn elecScaleCodeRuleIn = new ElecScaleCodeRuleIn();
        elecScaleCodeRuleIn.setErpCode(searchStocksIn.getErpCode());
        elecScaleCodeRuleIn.setMkt(searchStocksIn.getShopCode());
        ServiceResponse respElec = this.posManagerService.getElecCode(this.restTemplate, session, elecScaleCodeRuleIn);
        String eleMode = "";
        if ("0".equals(respElec.getReturncode())) {
            ElecScaleCodeRuleOut elecCodeRuleOut = (ElecScaleCodeRuleOut)respElec.getData();
            List<ElecScaleCodeRule> elecCodeRules = elecCodeRuleOut.getElecscalecoderule();
            eleMode = elecCodeRuleOut.getCodeRule();
            if ("1".equals(eleMode)) {
                if (searchStocksIn.getCode().length() == 13 && searchStocksIn.getCode().startsWith("210")) {
                    searchStocksIn.setCode(CastUtil.castAeonGoodsCode(searchStocksIn.getCode()));
                } else if (searchStocksIn.getCode().length() == 4) {
                    searchStocksIn.setCode(CastUtil.castAeonGoodsCode("99" + searchStocksIn.getCode()));
                }
            }
        }
        SearchStocksWIn in = new SearchStocksWIn();
        in.setCode(searchStocksIn.getCode());
        in.setErpCode(searchStocksIn.getErpCode());
        in.setShopCode(searchStocksIn.getShopCode());
        ServiceResponse serviceResponse = this.warehouseCentreService.searchStocks(this.restTemplate, session, in);
        if (!serviceResponse.getReturncode().trim().equals("0")) {
            return serviceResponse;
        }
        SearchStocksOut out = (SearchStocksOut)serviceResponse.getData();
        return ServiceResponse.buildSuccess((Object)out);
    }
}

