/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pos.component;

import ch.qos.logback.classic.Logger;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.pos.component.CommonService;
import com.efuture.pos.component.OrderServiceImpl;
import com.efuture.pos.component.PointConsumeReverseServiceImpl;
import com.efuture.pos.component.PosLogicCompoment;
import com.efuture.pos.component.PosLogicServiceImpl;
import com.efuture.pos.component.common.SellType;
import com.efuture.pos.component.service.ChinaYWService;
import com.efuture.pos.component.service.CnaeonCentreService;
import com.efuture.pos.model.BaseOutModel;
import com.efuture.pos.model.CacheModel;
import com.efuture.pos.model.ConsumersData;
import com.efuture.pos.model.CouponUse;
import com.efuture.pos.model.Goods;
import com.efuture.pos.model.Order;
import com.efuture.pos.model.OrderForPos;
import com.efuture.pos.model.Payment;
import com.efuture.pos.model.SysPara;
import com.efuture.pos.model.SysParaInfo;
import com.efuture.pos.model.promotionCentre.SellCoupon;
import com.efuture.pos.model.promotionCentre.request.CouponuseGetOnlineIn;
import com.efuture.pos.model.promotionCentre.request.PointsPayIn;
import com.efuture.pos.model.promotionCentre.request.RemovePayIn;
import com.efuture.pos.model.promotionCentre.response.CouponPayOut;
import com.efuture.pos.model.promotionCentre.response.CouponuseGetOnlineOut;
import com.efuture.pos.model.request.CouponQueryIn;
import com.efuture.pos.model.response.AddQrCodeOut;
import com.efuture.pos.model.yongwang.request.YWMemberConsumeReverseIn;
import com.efuture.pos.model.yongwang.request.YWMemberGetPointAndInvaildIn;
import com.efuture.pos.model.yongwang.request.YWMemberGiveOrReverseIn;
import com.efuture.pos.model.yongwang.request.YWMemberPointConsume;
import com.efuture.pos.model.yongwang.request.YWMemberPointConsumerIn;
import com.efuture.pos.model.yongwang.response.YWMemberOut;
import com.efuture.pos.model.yongwang.response.YWPointOut;
import com.efuture.pos.service.YWMemberPointService;
import com.efuture.pos.service.common.CacheModelService;
import com.efuture.pos.util.CnaeonSignature;
import com.efuture.pos.util.ManipulatePrecision;
import com.efuture.pos.util.ParamsValidateUtils;
import com.efuture.pos.util.UUIDUtils;
import com.efuture.pos.util.ValidateUtils;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.client.RestTemplate;

public class YWMemberPointServiceImpl
extends CommonService
implements YWMemberPointService {
    private static final Logger logger = (Logger)LoggerFactory.getLogger(YWMemberPointServiceImpl.class);
    @Autowired
    private ChinaYWService chinaYWService;
    @Autowired
    private CacheModelService cacheModelService;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    PosLogicServiceImpl posLogicServiceImpl;
    @Autowired
    PosLogicCompoment posLogicCompoment;
    @Autowired
    CnaeonCentreService cnaeonCentreService;
    @Autowired
    PointConsumeReverseServiceImpl pointConsumeReverseService;
    @Autowired
    OrderServiceImpl orderService;
    private String salt = "";

    public ServiceResponse memberPointQuery(ServiceSession session, JSONObject paramsObject) {
        YWMemberGetPointAndInvaildIn in = (YWMemberGetPointAndInvaildIn)JSONObject.toJavaObject((JSON)paramsObject, YWMemberGetPointAndInvaildIn.class);
        ServiceResponse checkParamResp = ValidateUtils.checkFieldNotNullResp(in, session);
        if (checkParamResp.getReturncode().equals("100000")) {
            return checkParamResp;
        }
        if (StringUtils.isBlank((String)in.getFlowNo())) {
            ArrayList<String> codes = new ArrayList<String>();
            codes.add("ZTKEY");
            List<SysPara> sysParaList = this.orderService.getSyspara(session, codes, in.getErpCode(), in.getShopCode());
            SysParaInfo sysPara = this.orderService.initSysParaInfo(sysParaList);
            this.salt = sysPara.getZtKey();
        } else {
            CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(in.getFlowNo());
            if (cacheModel == null) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355!", (Object[])new Object[]{in.getFlowNo()});
            }
            this.salt = cacheModel.getOrder().getSysPara().getZtKey();
        }
        if (StringUtils.isBlank((String)this.salt)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u83b7\u53d6\u7b7e\u540dkey\u5931\u8d25");
        }
        Date date = new Date();
        in.setTokenId(UUIDUtils.buildGuid());
        in.setTimestamp(date.getTime());
        in.setStoreCode(in.getShopCode());
        Map<String, Object> params = in.tranferSignMap();
        try {
            String sign = CnaeonSignature.sign(params, this.salt);
            in.setSign(sign);
        }
        catch (Exception e) {
            logger.error("\u7b7e\u540d\u5931\u8d25:", (Throwable)e);
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u7b7e\u540d\u5931\u8d25");
        }
        ServiceResponse response = this.chinaYWService.pointQuery(this.restTemplate, session, in);
        if ("0".equals(response.getReturncode())) {
            YWMemberOut res = (YWMemberOut)response.getData();
            if (200 == res.getCode() && null != res.getData()) {
                YWPointOut out = new YWPointOut();
                out.setLastConsumePoint(res.getData().getBigDecimal("lastConsumePoint"));
                out.setUnavailablePoint(res.getData().getString("unavailablePoint"));
                out.setUnavailablePointDate(res.getData().getString("unavailablePointDate"));
                return ServiceResponse.buildSuccess((Object)out);
            }
            logger.error("\u4f1a\u5458\u79ef\u5206\u67e5\u8be2\u5931\u8d25:" + res.getMessage());
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)("\u4f1a\u5458\u79ef\u5206\u67e5\u8be2\u5931\u8d25:" + res.getMessage()));
        }
        logger.error("\u4f1a\u5458\u79ef\u5206\u67e5\u8be2\u5931\u8d25" + response.getData());
        return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4f1a\u5458\u79ef\u5206\u67e5\u8be2\u5931\u8d25");
    }

    public ServiceResponse pointGiveOrReverse(ServiceSession session, JSONObject paramsObject) {
        ServiceResponse checkMember;
        YWMemberGiveOrReverseIn in = (YWMemberGiveOrReverseIn)JSONObject.toJavaObject((JSON)paramsObject, YWMemberGiveOrReverseIn.class);
        ServiceResponse checkParamResp = ValidateUtils.checkFieldNotNullResp(in, session);
        if (checkParamResp.getReturncode().equals("100000")) {
            return checkParamResp;
        }
        if (in.getOpType() != 80 && in.getOpType() != 82 && in.getOpType() != 84 && in.getOpType() != 50) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u79ef\u5206\u7c7b\u578b\u975e\u6cd5");
        }
        CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(in.getFlowNo());
        if (null == cacheModel) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u627e\u4e0d\u5230\u8d2d\u7269\u8f66");
        }
        Order order = cacheModel.getOrder();
        this.salt = cacheModel.getOrder().getSysPara().getZtKey();
        if (StringUtils.isEmpty((String)this.salt)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4ece\u603b\u90e8\u83b7\u53d6\u4e2d\u53f0\u7b7e\u540dkey\u5931\u8d25");
        }
        ConsumersData member = order.getConsumersData();
        if (member == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u6ca1\u6709\u767b\u5f55\u4f1a\u5458,\u4e0d\u80fd\u64cd\u4f5c");
        }
        if (!SellType.ISBACK(order.getOrderType()) && !(checkMember = this.checkMember(session, member)).getReturncode().equals("0")) {
            return checkMember;
        }
        List<Payment> payments = cacheModel.getPayments();
        Payment payment = null;
        if (in.getOpType() == 50 && payments != null) {
            for (int i = 0; i < payments.size(); ++i) {
                if (!in.getPuid().equals(payments.get(i).getPuid())) continue;
                payment = payments.get(i);
            }
        }
        if (in.getOpType() == 50 && payment == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u627e\u4e0d\u5230\u539f\u652f\u4ed8\u884c\uff0c\u4e0d\u80fd\u51b2\u6b63");
        }
        String channel = order.getChannel();
        Integer sourceId = Integer.valueOf(channel);
        in.setSourceId(sourceId);
        in.setTokenId(UUIDUtils.buildGuid());
        in.setTimestamp(System.currentTimeMillis());
        in.setPayNo(order.getTerminalNo() + new Date().getTime());
        in.setOrderNo(in.getFlowNo());
        in.setMemberId(member.getConsumersId());
        in.setOrgId(order.getOrgId());
        in.setStoreCode(order.getShopCode());
        in.setTransactionAmount(order.getOughtPay() + "");
        if (in.getOpType() == 80) {
            in.setPoint(order.getThisTimePoint());
        }
        Map<String, Object> params = in.transferSignMap(order, member);
        try {
            String sign = CnaeonSignature.sign(params, this.salt);
            in.setSign(sign);
        }
        catch (Exception e) {
            logger.error("\u7b7e\u540d\u5931\u8d25:", (Throwable)e);
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u7b7e\u540d\u5931\u8d25");
        }
        ServiceResponse response = this.chinaYWService.giveOrReserve(this.restTemplate, session, in);
        if ("0".equals(response.getReturncode())) {
            YWMemberOut res = (YWMemberOut)response.getData();
            if (200 == res.getCode()) {
                if (in.getOpType() == 50) {
                    for (int i = 0; i < payments.size(); ++i) {
                        if (!in.getPuid().equals(payments.get(i).getPuid())) continue;
                        for (int j = 0; j < cacheModel.getGoodsList().size(); ++j) {
                            Goods g = cacheModel.getGoodsList().get(j);
                            for (int k = 0; k < g.getOutCouponUses().size(); ++k) {
                                CouponUse couponUse = g.getOutCouponUses().get(k);
                                if (!payments.get(i).getRownoId().equals(couponUse.getRownoId())) continue;
                                g.getOutCouponUses().remove(couponUse);
                                --k;
                            }
                        }
                        payments.removeIf(p -> p.getPuid().equals(in.getPuid()));
                    }
                    if ((cacheModel = this.posLogicServiceImpl.CalcOrderAmountByDeletePayReturn(cacheModel)).getCalcResult() == -1) {
                        String errCode = "100000";
                        if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                            errCode = cacheModel.getErrCode();
                        }
                        return ServiceResponse.buildFailure((ServiceSession)session, (String)errCode, (String)cacheModel.getErrMsg());
                    }
                } else {
                    member.setMemberActionSno(in.getPayNo());
                }
                this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
                BaseOutModel out = new BaseOutModel();
                out.setOrder(OrderForPos.toOrderForPos(cacheModel));
                return ServiceResponse.buildSuccess((Object)out);
            }
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)res.getMessage());
        }
        return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)(response.getData() + ""));
    }

    public ServiceResponse pointConsumer(ServiceSession session, JSONObject paramsObject) {
        ServiceResponse checkMember;
        YWMemberPointConsumerIn in = (YWMemberPointConsumerIn)JSONObject.toJavaObject((JSON)paramsObject, YWMemberPointConsumerIn.class);
        ServiceResponse checkParamResp = ValidateUtils.checkFieldNotNullResp(in, session);
        if (checkParamResp.getReturncode().equals("100000")) {
            return checkParamResp;
        }
        if (in.getOpType() != 90 && in.getOpType() != 94 && in.getOpType() != 52 && in.getOpType() != 54 && in.getOpType() != 56) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u79ef\u5206\u7c7b\u578b\u975e\u6cd5");
        }
        CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(in.getFlowNo());
        if (null == cacheModel) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u627e\u4e0d\u5230\u8d2d\u7269\u8f66");
        }
        Order order = cacheModel.getOrder();
        this.salt = cacheModel.getOrder().getSysPara().getZtKey();
        if (StringUtils.isEmpty((String)this.salt)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4ece\u603b\u90e8\u83b7\u53d6\u4e2d\u53f0\u7b7e\u540dkey\u5931\u8d25");
        }
        ConsumersData member = order.getConsumersData();
        if (member == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u6ca1\u6709\u767b\u5f55\u4f1a\u5458\uff0c\u4e0d\u80fd\u64cd\u4f5c");
        }
        if (!SellType.ISBACK(order.getOrderType()) && !(checkMember = this.checkMember(session, member)).getReturncode().equals("0")) {
            return checkMember;
        }
        if ("1".equals(order.getExerciseMode())) {
            double remainValue = cacheModel.getOrder().getRemainValue();
            if (remainValue <= 0.0) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5df2\u4ed8\u6e05\u6b3e\u9879\uff0c\u65e0\u9700\u518d\u652f\u4ed8\uff01");
            }
            if (remainValue - in.getMoney() < 0.0) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u652f\u4ed8\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5269\u4f59\u4ed8\u6b3e\uff01");
            }
            Payment p2 = new Payment();
            p2 = YWMemberPointConsumerIn.createPointsPayment(in, cacheModel);
            p2.setMoney(ManipulatePrecision.mul(p2.getAmount(), p2.getRate()));
            p2.setPrecision(in.getPrecision());
            p2.setIsAllowCharge(in.getIsAllowCharge());
            p2.setIsOverage(in.getIsOverage());
            p2.setPrcutMode(in.getCutMode());
            p2.setRefCode(in.getTrNum());
            p2.setPayNo(cacheModel.getOrder().getConsumersData().getConsumersCard());
            p2.setConsumersId(cacheModel.getOrder().getConsumersData().getConsumersId());
            cacheModel = this.posLogicServiceImpl.calcPayAmout(cacheModel, p2);
            this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
            BaseOutModel out = new BaseOutModel();
            out.setOrder(OrderForPos.toOrderForPos(cacheModel));
            return ServiceResponse.buildSuccess((Object)out);
        }
        List<Object> payments = new ArrayList();
        Payment payment = null;
        AddQrCodeOut addQrCodeOut = null;
        if (in.getOpType() == 90 || in.getOpType() == 94 || in.getOpType() == 52) {
            double remainValue = cacheModel.getOrder().getRemainValue();
            if (remainValue <= 0.0) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5df2\u4ed8\u6e05\u6b3e\u9879\uff0c\u65e0\u9700\u518d\u652f\u4ed8\uff01");
            }
            if (remainValue - in.getMoney() < 0.0) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u652f\u4ed8\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5269\u4f59\u4ed8\u6b3e\uff01");
            }
            PointsPayIn pointsPayIn = new PointsPayIn();
            pointsPayIn.setAccntNo(in.getAccntNo());
            pointsPayIn.setPayCode(in.getPayCode());
            pointsPayIn.setPayje(in.getPoint());
            ServiceResponse pointsPay = this.pointsPay(session, cacheModel, pointsPayIn);
            logger.info("pointsPay:" + JSONObject.toJSONString((Object)pointsPay));
            if (!"0".equals(pointsPay.getReturncode())) {
                logger.info("\u8425\u9500\u79ef\u5206\u652f\u4ed8\u5931\u8d25\u8fd4\u56de\u9519\u8bef\u4fe1\u606f");
                return pointsPay;
            }
            addQrCodeOut = (AddQrCodeOut)pointsPay.getData();
            payments = addQrCodeOut.getSellPayment();
            double balance = 0.0;
            payment = (Payment)payments.get(payments.size() - 1);
            payment.setPayName(in.getPayName());
            balance = ManipulatePrecision.add(balance, payment.getMoney());
            in.setBalance(balance);
        }
        if (in.getOpType() == 56) {
            List list = cacheModel.getPayments().stream().filter(p -> p.getPuid().equals(in.getPuid())).collect(Collectors.toList());
            payment = (Payment)list.get(0);
        }
        String channel = order.getChannel();
        Integer sourceId = Integer.valueOf(channel);
        in.setSourceId(sourceId);
        YWMemberPointConsume param = new YWMemberPointConsume();
        YWMemberPointConsume.transferParams(param, in, order, payment);
        Map<String, Object> signMap = in.transferSignMap(order, member, param);
        logger.info("params:" + signMap);
        try {
            String sign = CnaeonSignature.sign(signMap, this.salt);
            param.setSign(sign);
        }
        catch (Exception e) {
            logger.error("\u7b7e\u540d\u5931\u8d25:", (Throwable)e);
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u7b7e\u540d\u5931\u8d25");
        }
        ServiceResponse response = null;
        if (in.getOpType() != 52) {
            response = this.chinaYWService.pointConsume(this.restTemplate, session, param);
        }
        return this.callBackPointConsumeHandler(session, in, response, cacheModel, payment, param, addQrCodeOut);
    }

    private ServiceResponse callBackPointConsumeHandler(ServiceSession session, YWMemberPointConsumerIn in, ServiceResponse response, CacheModel cacheModel, Payment payment, YWMemberPointConsume param, AddQrCodeOut addQrCodeOut) {
        if (in.getOpType() == 52) {
            ConsumersData member = cacheModel.getOrder().getConsumersData();
            payment.setPrecision(in.getPrecision());
            payment.setIsAllowCharge(in.getIsAllowCharge());
            payment.setIsOverage(in.getIsOverage());
            payment.setPrcutMode(in.getCutMode());
            payment.setRefCode(in.getTrNum());
            payment.setPayNo(member.getConsumersCard());
            payment.setConsumersId(member.getConsumersId());
            payment.setIsDirectDel(true);
            payment.setChargeRate(in.getChargeRate());
            payment.setMaxVal(in.getMaxVal());
            payment.setMinVal(in.getMinVal());
            payment.setInvoiceFlag(in.getInvoiceFlag());
            payment.setCreditsFlag(in.getCreditsFlag());
            payment.setPayName(in.getPayName());
            cacheModel = this.posLogicServiceImpl.calcPayAmout(cacheModel, payment);
            cacheModel.getOrder().setReturnPointFlag(1);
            this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
            BaseOutModel out = new BaseOutModel();
            out.setOrder(OrderForPos.toOrderForPos(cacheModel));
            return ServiceResponse.buildSuccess((Object)out);
        }
        if ("0".equals(response.getReturncode())) {
            YWMemberOut res = (YWMemberOut)response.getData();
            if (200 == res.getCode()) {
                if (in.getOpType() == 90 || in.getOpType() == 94) {
                    ConsumersData member = cacheModel.getOrder().getConsumersData();
                    payment.setPrecision(in.getPrecision());
                    payment.setIsAllowCharge(in.getIsAllowCharge());
                    payment.setIsOverage(in.getIsOverage());
                    payment.setPrcutMode(in.getCutMode());
                    payment.setRefCode(in.getTrNum());
                    payment.setPayNo(member.getConsumersCard());
                    payment.setConsumersId(member.getConsumersId());
                    payment.setIsDirectDel(true);
                    payment.setChargeRate(in.getChargeRate());
                    payment.setMaxVal(in.getMaxVal());
                    payment.setMinVal(in.getMinVal());
                    payment.setInvoiceFlag(in.getInvoiceFlag());
                    payment.setCreditsFlag(in.getCreditsFlag());
                    payment.setPayName(in.getPayName());
                    cacheModel = this.posLogicServiceImpl.calcPayAmout(cacheModel, payment);
                    if (cacheModel.getCalcResult() == -1 && in.getOpType() == 90) {
                        RemovePayIn removePayIn = new RemovePayIn();
                        removePayIn.setCalcBillid(addQrCodeOut.getCalcBillid());
                        removePayIn.setChannelId(cacheModel.getOrder().getChannel());
                        removePayIn.setRownoId(payment.getRownoId());
                        this.promotionCentreService.removePay(this.restTemplate, session, removePayIn);
                        HashMap<String, Object> params = new HashMap<String, Object>();
                        Date date = new Date();
                        params.put("tokenId", UUIDUtils.buildGuid());
                        params.put("timestamp", date.getTime());
                        params.put("storeCode", param.getStoreCode());
                        params.put("memberId", param.getMemberId());
                        params.put("orderNo", param.getOrderNo());
                        params.put("payNo", param.getPayNo());
                        params.put("balance", JSON.toJSONString((Object)param.getBalance()));
                        params.put("point", JSON.toJSONString((Object)param.getPoint()));
                        String sign = CnaeonSignature.sign(params, this.salt);
                        YWMemberConsumeReverseIn consumerReverse = new YWMemberConsumeReverseIn();
                        consumerReverse.setTokenId(params.get("tokenId") + "");
                        consumerReverse.setTimestamp(date.getTime());
                        consumerReverse.setStoreCode(param.getStoreCode());
                        consumerReverse.setMemberId(param.getMemberId());
                        consumerReverse.setOrderNo(param.getOrderNo());
                        consumerReverse.setPayNo(param.getPayNo());
                        consumerReverse.setBalance(param.getBalance());
                        consumerReverse.setPoint(param.getPoint());
                        consumerReverse.setSourceId(param.getSourceId());
                        consumerReverse.setOrgId(param.getOrgId());
                        consumerReverse.setSign(sign);
                        ServiceResponse pointCancelResponse = this.chinaYWService.pointCancel(this.restTemplate, session, consumerReverse);
                        if ("0".equals(pointCancelResponse.getReturncode())) {
                            YWMemberOut yWMemberOut = (YWMemberOut)pointCancelResponse.getData();
                            if (yWMemberOut.getCode() == 218872 || yWMemberOut.getMessage().equals("\u539f\u4ea4\u6613\u4e0d\u5b58\u5728")) {
                                logger.info("\u539f\u4ea4\u6613\u4e0d\u5b58\u5728\uff0c\u51b2\u6b63\u6210\u529f");
                            }
                            if (yWMemberOut.getCode() != 200) {
                                logger.info("\u4e2d\u53f0\u63a5\u53e3\u8fd4\u56de\u5931\u8d25-\u5c1d\u8bd5\u53d1\u9001MQ");
                                ServiceResponse pointConsumeReverseResponse = this.cnaeonCentreService.pointConsumeReverse(this.restTemplate, session, JSON.toJSONString(params));
                                if (!"0".equals(pointConsumeReverseResponse.getReturncode())) {
                                    logger.info("MQ\u8c03\u7528\u5931\u8d25-\u8bb0\u5f55\u672c\u5730\u6587\u4ef6");
                                    params.put("flowNo", in.getFlowNo());
                                    this.pointConsumeReverseService.save(session, (JSONObject)JSONObject.toJSON(params));
                                    logger.info("\u8bf7\u6c42\u79ef\u5206\u51b2\u6b63\u5931\u8d25,\u5df2\u8bb0\u5f55\u672c\u5730\u6587\u4ef6");
                                }
                            }
                        } else {
                            logger.info("\u4e2d\u53f0\u63a5\u53e3\u8fd4\u56de\u5931\u8d25-\u5c1d\u8bd5\u53d1\u9001MQ");
                            ServiceResponse pointConsumeReverseResponse = this.cnaeonCentreService.pointConsumeReverse(this.restTemplate, session, JSON.toJSONString(params));
                            if (!"0".equals(pointConsumeReverseResponse.getReturncode())) {
                                logger.info("MQ\u8c03\u7528\u5931\u8d25-\u8bb0\u5f55\u672c\u5730\u6587\u4ef6");
                                params.put("flowNo", in.getFlowNo());
                                this.pointConsumeReverseService.save(session, (JSONObject)JSONObject.toJSON(params));
                                logger.info("\u8bf7\u6c42\u79ef\u5206\u51b2\u6b63\u5931\u8d25,\u5df2\u8bb0\u5f55\u672c\u5730\u6587\u4ef6");
                            }
                        }
                        String errCode = "100000";
                        if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                            errCode = cacheModel.getErrCode();
                        }
                        return ServiceResponse.buildFailure((ServiceSession)session, (String)errCode, (String)cacheModel.getErrMsg());
                    }
                    if (-1 != cacheModel.getCalcResult()) {
                        cacheModel = this.posLogicCompoment.RefreshAfterPointsPay(cacheModel, addQrCodeOut);
                    }
                } else if (in.getOpType() == 56) {
                    if (cacheModel.getPayments() != null && !cacheModel.getPayments().isEmpty()) {
                        cacheModel.getPayments().removeIf(p -> p.getPuid().equals(in.getPuid()));
                    }
                    if ((cacheModel = this.posLogicServiceImpl.CalcOrderAmountByDeletePayReturn(cacheModel)).getCalcResult() == -1) {
                        String errCode = "100000";
                        if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                            errCode = cacheModel.getErrCode();
                        }
                        return ServiceResponse.buildFailure((ServiceSession)session, (String)errCode, (String)cacheModel.getErrMsg());
                    }
                }
                cacheModel.getOrder().setReturnPointFlag(0);
                this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
                BaseOutModel out = new BaseOutModel();
                out.setOrder(OrderForPos.toOrderForPos(cacheModel));
                return ServiceResponse.buildSuccess((Object)out);
            }
            logger.info("\u4e2d\u53f0\u79ef\u5206\u5229\u7528\u5931\u8d25");
            if (in.getOpType() == 90) {
                logger.info("\u4e2d\u53f0\u79ef\u5206\u5229\u7528\u5931\u8d25\u8c03\u8425\u9500\u5220\u9664\u79ef\u5206\u652f\u4ed8\u63a5\u53e3");
                RemovePayIn removePayIn = new RemovePayIn();
                removePayIn.setCalcBillid(addQrCodeOut.getCalcBillid());
                removePayIn.setChannelId(cacheModel.getOrder().getChannel());
                removePayIn.setRownoId(payment.getRownoId());
                this.promotionCentreService.removePay(this.restTemplate, session, removePayIn);
            }
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)res.getMessage());
        }
        logger.info("\u79ef\u5206\u5229\u7528\u8d85\u65f6\u51b2\u6b63");
        if (in.getOpType() == 90) {
            logger.info("\u4e2d\u53f0\u79ef\u5206\u5229\u7528\u5931\u8d25\u8c03\u8425\u9500\u5220\u9664\u79ef\u5206\u652f\u4ed8\u63a5\u53e3");
            RemovePayIn removePayIn = new RemovePayIn();
            removePayIn.setCalcBillid(addQrCodeOut.getCalcBillid());
            removePayIn.setChannelId(cacheModel.getOrder().getChannel());
            removePayIn.setRownoId(payment.getRownoId());
            logger.info("removePayIn\uff1a" + JSONObject.toJSONString((Object)removePayIn));
            this.promotionCentreService.removePay(this.restTemplate, session, removePayIn);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        Date date = new Date();
        params.put("tokenId", UUIDUtils.buildGuid());
        params.put("timestamp", date.getTime());
        params.put("storeCode", param.getStoreCode());
        params.put("memberId", param.getMemberId());
        params.put("orderNo", param.getOrderNo());
        params.put("payNo", param.getPayNo());
        params.put("balance", JSON.toJSONString((Object)param.getBalance()));
        params.put("point", JSON.toJSONString((Object)param.getPoint()));
        String sign = CnaeonSignature.sign(params, this.salt);
        YWMemberConsumeReverseIn consumerReverse = new YWMemberConsumeReverseIn();
        consumerReverse.setTokenId(params.get("tokenId") + "");
        consumerReverse.setTimestamp(date.getTime());
        consumerReverse.setStoreCode(param.getStoreCode());
        consumerReverse.setMemberId(param.getMemberId());
        consumerReverse.setOrderNo(param.getOrderNo());
        consumerReverse.setPayNo(param.getPayNo());
        consumerReverse.setBalance(param.getBalance());
        consumerReverse.setPoint(param.getPoint());
        consumerReverse.setSourceId(param.getSourceId());
        consumerReverse.setOrgId(param.getOrgId());
        consumerReverse.setSign(sign);
        logger.info("\u7ec4\u88c5\u53c2\u6570\u8c03\u7528\u4e2d\u53f0\u79ef\u5206\u6d88\u8d39\u51b2\u6b63");
        ServiceResponse pointCancelResponse = this.chinaYWService.pointCancel(this.restTemplate, session, consumerReverse);
        if ("0".equals(pointCancelResponse.getReturncode())) {
            YWMemberOut yWMemberOut = (YWMemberOut)pointCancelResponse.getData();
            if (yWMemberOut.getCode() == 218872 || yWMemberOut.getMessage().equals("\u539f\u4ea4\u6613\u4e0d\u5b58\u5728")) {
                logger.info("\u539f\u4ea4\u6613\u4e0d\u5b58\u5728\uff0c\u51b2\u6b63\u6210\u529f");
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"\u4ea4\u6613\u5f02\u5e38");
            }
            if (yWMemberOut.getCode() != 200) {
                logger.info("\u4e2d\u53f0\u63a5\u53e3\u8fd4\u56de\u5931\u8d25-\u5c1d\u8bd5\u53d1\u9001MQ");
                ServiceResponse pointConsumeReverseResponse = this.cnaeonCentreService.pointConsumeReverse(this.restTemplate, session, JSON.toJSONString(params));
                if (!"0".equals(pointConsumeReverseResponse.getReturncode())) {
                    logger.info("MQ\u8c03\u7528\u5931\u8d25-\u8bb0\u5f55\u672c\u5730\u6587\u4ef6");
                    params.put("flowNo", in.getFlowNo());
                    this.pointConsumeReverseService.save(session, (JSONObject)JSONObject.toJSON(params));
                    logger.info("\u8bf7\u6c42\u79ef\u5206\u51b2\u6b63\u5931\u8d25,\u5df2\u8bb0\u5f55\u672c\u5730\u6587\u4ef6");
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"\u4ea4\u6613\u5f02\u5e38");
                }
            }
        } else {
            logger.info("\u4e2d\u53f0\u63a5\u53e3\u8fd4\u56de\u5931\u8d25-\u5c1d\u8bd5\u53d1\u9001MQ");
            ServiceResponse pointConsumeReverseResponse = this.cnaeonCentreService.pointConsumeReverse(this.restTemplate, session, JSON.toJSONString(params));
            if (!"0".equals(pointConsumeReverseResponse.getReturncode())) {
                logger.info("MQ\u8c03\u7528\u5931\u8d25-\u8bb0\u5f55\u672c\u5730\u6587\u4ef6");
                params.put("flowNo", in.getFlowNo());
                this.pointConsumeReverseService.save(session, (JSONObject)JSONObject.toJSON(params));
                logger.info("\u8bf7\u6c42\u79ef\u5206\u51b2\u6b63\u5931\u8d25,\u5df2\u8bb0\u5f55\u672c\u5730\u6587\u4ef6");
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"\u4ea4\u6613\u5f02\u5e38");
            }
        }
        return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"\u4ea4\u6613\u5f02\u5e38");
    }

    public ServiceResponse pointConsumeReverse(ServiceSession session, JSONObject paramsObject) {
        ServiceResponse checkMember;
        YWMemberConsumeReverseIn in = (YWMemberConsumeReverseIn)JSONObject.toJavaObject((JSON)paramsObject, YWMemberConsumeReverseIn.class);
        ServiceResponse checkParamResp = ValidateUtils.checkFieldNotNullResp(in, session);
        if (checkParamResp.getReturncode().equals("100000")) {
            return checkParamResp;
        }
        CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(in.getFlowNo());
        if (null == cacheModel) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u627e\u4e0d\u5230\u8d2d\u7269\u8f66");
        }
        Order order = cacheModel.getOrder();
        ConsumersData member = order.getConsumersData();
        if (member == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u6ca1\u6709\u767b\u5f55\u4f1a\u5458\uff0c\u4e0d\u80fd\u64cd\u4f5c");
        }
        this.salt = cacheModel.getOrder().getSysPara().getZtKey();
        if (StringUtils.isEmpty((String)this.salt)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4ece\u603b\u90e8\u83b7\u53d6\u4e2d\u53f0\u7b7e\u540dkey\u5931\u8d25");
        }
        List<Payment> payments = null;
        payments = in.getIsReturn() ? cacheModel.getReturnPayments() : cacheModel.getPayments();
        Payment payment = null;
        for (int i = 0; i < payments.size(); ++i) {
            Payment p2 = payments.get(i);
            if (!p2.getPuid().equals(in.getPuid())) continue;
            payment = p2;
            break;
        }
        if (payment == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"\u627e\u4e0d\u5230\u539f\u652f\u4ed8\u884c\uff0c\u51b2\u6b63\u5931\u8d25");
        }
        if (order.getOrderType().equals("4") || "1".equals(order.getExerciseMode())) {
            if (StringUtils.isNotBlank((String)order.getOriginTerminalSno())) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"\u9000\u8d27\u4e0d\u5141\u8bb8\u5220\u9664\u79ef\u5206\u652f\u4ed8\u884c");
            }
            if (payments != null && !payments.isEmpty()) {
                payments.removeIf(p -> p.getPuid().equals(in.getPuid()));
            }
            if ((cacheModel = this.posLogicServiceImpl.CalcOrderAmountByDeletePayReturn(cacheModel)).getCalcResult() == -1) {
                String errCode = "100000";
                if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                    errCode = cacheModel.getErrCode();
                }
                return ServiceResponse.buildFailure((ServiceSession)session, (String)errCode, (String)cacheModel.getErrMsg());
            }
            List collect = payments.stream().filter(p -> p.getPayCode().equals("0706")).collect(Collectors.toList());
            if (collect == null || collect.isEmpty()) {
                cacheModel.getOrder().setReturnPointFlag(0);
            }
            this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
            BaseOutModel out = new BaseOutModel();
            out.setOrder(OrderForPos.toOrderForPos(cacheModel));
            return ServiceResponse.buildSuccess((Object)out);
        }
        if (!payment.getIsDirectDel() && !order.getOrderType().equals("2")) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"\u8be5\u4ed8\u6b3e\u884c\u4e0d\u80fd\u5220\u9664");
        }
        if (!SellType.ISBACK(order.getOrderType()) && !(checkMember = this.checkMember(session, member)).getReturncode().equals("0")) {
            return checkMember;
        }
        String channel = order.getChannel();
        Integer sourceId = Integer.valueOf(channel);
        in.setSourceId(sourceId);
        in.setTokenId(UUIDUtils.buildGuid());
        in.setPayNo(payment.getRefCode());
        Date date = new Date();
        in.setTimestamp(date.getTime());
        in.setStoreCode(order.getShopCode());
        in.setMemberId(member.getConsumersId());
        in.setOrderNo(in.getFlowNo());
        in.setOrgId(order.getOrgId());
        if (cacheModel.getOrder().getOrderType().equals("2")) {
            in.setOpType(94);
        }
        in.setSrcOrderNo(order.getOriginFlowNo());
        Map<String, Object> signMap = in.transferSignMap(order, member, payment);
        try {
            String sign = CnaeonSignature.sign(signMap, this.salt);
            in.setSign(sign);
        }
        catch (Exception e) {
            logger.error("\u7b7e\u540d\u5931\u8d25:", (Throwable)e);
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u7b7e\u540d\u5931\u8d25");
        }
        ServiceResponse response = cacheModel.getOrder().getOrderType().equals("2") ? this.chinaYWService.pointConsume(this.restTemplate, session, in) : this.chinaYWService.pointCancel(this.restTemplate, session, in);
        return this.callBackPointConsumeReverseHandler(session, in, response, cacheModel, signMap);
    }

    private ServiceResponse callBackPointConsumeReverseHandler(ServiceSession session, YWMemberConsumeReverseIn in, ServiceResponse response, CacheModel cacheModel, Map<String, Object> signMap) {
        if ("0".equals(response.getReturncode())) {
            List<Payment> payments;
            YWMemberOut res = (YWMemberOut)response.getData();
            if (200 != res.getCode()) {
                if (cacheModel.getOrder().getOrderType().equals("2")) {
                    cacheModel.getOrder().setReturnPointFlag(1);
                } else {
                    ServiceResponse save;
                    ServiceResponse pointConsumeReverse = this.cnaeonCentreService.pointConsumeReverse(this.restTemplate, session, JSON.toJSONString((Object)in));
                    logger.info(pointConsumeReverse + "");
                    if (!"0".equals(pointConsumeReverse.getReturncode()) && !"0".equals((save = this.pointConsumeReverseService.save(session, (JSONObject)JSONObject.toJSON((Object)in))).getReturncode())) {
                        return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"\u5220\u9664\u652f\u4ed8\u884c\u5931\u8d25");
                    }
                }
            }
            if ((payments = cacheModel.getPayments()) != null && !payments.isEmpty()) {
                for (Payment p2 : payments) {
                    if (!p2.getPuid().equals(in.getPuid())) continue;
                    String rownoid = p2.getRownoId();
                    RemovePayIn removePayIn = new RemovePayIn();
                    removePayIn.setCalcBillid(cacheModel.getOrder().getSeqNo());
                    removePayIn.setChannelId(cacheModel.getOrder().getChannel());
                    removePayIn.setRownoId(p2.getRownoId());
                    this.promotionCentreService.removePay(this.restTemplate, session, removePayIn);
                    payments.remove(p2);
                    for (Goods g : cacheModel.getGoodsList()) {
                        for (int i = 0; i < g.getOutCouponUses().size(); ++i) {
                            CouponUse couponUse = g.getOutCouponUses().get(i);
                            if (!rownoid.equals(couponUse.getRownoId())) continue;
                            g.getOutCouponUses().remove(i);
                            --i;
                        }
                    }
                }
            }
            if ((cacheModel = this.posLogicServiceImpl.CalcOrderAmountByDeletePayReturn(cacheModel)).getCalcResult() == -1) {
                String errCode = "100000";
                if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                    errCode = cacheModel.getErrCode();
                }
                return ServiceResponse.buildFailure((ServiceSession)session, (String)errCode, (String)cacheModel.getErrMsg());
            }
        } else {
            ServiceResponse save;
            ServiceResponse pointConsumeReverse = this.cnaeonCentreService.pointConsumeReverse(this.restTemplate, session, JSON.toJSONString((Object)in));
            logger.info(pointConsumeReverse + "");
            if (!"0".equals(pointConsumeReverse.getReturncode()) && !"0".equals((save = this.pointConsumeReverseService.save(session, (JSONObject)JSONObject.toJSON((Object)in))).getReturncode())) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"\u5220\u9664\u652f\u4ed8\u884c\u5931\u8d25");
            }
            List<Payment> payments = cacheModel.getPayments();
            if (payments != null && !payments.isEmpty()) {
                payments.removeIf(p -> p.getPuid().equals(in.getPuid()));
            }
            if ((cacheModel = this.posLogicServiceImpl.CalcOrderAmountByDeletePayReturn(cacheModel)).getCalcResult() == -1) {
                String errCode = "100000";
                if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                    errCode = cacheModel.getErrCode();
                }
                return ServiceResponse.buildFailure((ServiceSession)session, (String)errCode, (String)cacheModel.getErrMsg());
            }
        }
        this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
        BaseOutModel out = new BaseOutModel();
        out.setOrder(OrderForPos.toOrderForPos(cacheModel));
        return ServiceResponse.buildSuccess((Object)out);
    }

    public ServiceResponse availablePoint(ServiceSession session, JSONObject paramsObject) {
        ServiceResponse response;
        ServiceResponse checkMember;
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return paramsValidateUtils.getServiceResponse();
        }
        if (StringUtils.isBlank((String)paramsObject.getString("payCode"))) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u79ef\u5206\u8ba1\u7b97\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u4ed8\u6b3e\u4ee3\u7801"});
        }
        CouponQueryIn couponQueryIn = (CouponQueryIn)JSON.parseObject((String)paramsObject.toJSONString(), CouponQueryIn.class);
        if (couponQueryIn == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5165\u53c2\u8f6c\u6362\u5931\u8d25\uff01");
        }
        CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(couponQueryIn.getFlowNo());
        if (cacheModel == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355!", (Object[])new Object[]{couponQueryIn.getFlowNo()});
        }
        Order order = cacheModel.getOrder();
        ConsumersData member = order.getConsumersData();
        if (!SellType.ISBACK(order.getOrderType()) && !(checkMember = this.checkMember(session, member)).getReturncode().equals("0")) {
            return checkMember;
        }
        couponQueryIn.setChannel(order.getChannel());
        couponQueryIn.setTerminalSno(order.getTerminalSno());
        couponQueryIn.setConsumersId(member.getConsumersId());
        couponQueryIn.setCouponGroup("01");
        couponQueryIn.setDistinct("Y");
        if (SellType.ISBACK(order.getOrderType())) {
            couponQueryIn.setStatus("7");
        }
        if (!"0".equals((response = this.promotionCentreService.couponuseGetOnline(this.restTemplate, session, CouponuseGetOnlineIn.transferCouponGetIn(cacheModel, couponQueryIn))).getReturncode())) {
            return response;
        }
        CouponuseGetOnlineOut out = (CouponuseGetOnlineOut)response.getData();
        List<SellCoupon> couponUses = out.getCouponUses();
        double available = 0.0;
        String account = null;
        double maxAvailable = 0.0;
        long pointExchange = 0L;
        double pointExchangeMoney = 0.0;
        double maxRefundPoints = 0.0;
        double rate = 0.0;
        if (null != couponUses) {
            for (int i = 0; i < couponUses.size(); ++i) {
                SellCoupon couponUse = couponUses.get(i);
                if (!"01".equals(couponUse.getCouponGroup()) || !"JFXF".equals(couponUse.getCouponType()) || !"0".equals(couponUse.getMode())) continue;
                available = ManipulatePrecision.add(available, couponUse.getAvailable());
                if (!((double)couponUse.getPointExchange() > 0.0)) continue;
                String limitJe = couponUse.getLimitJe();
                if (StringUtils.isNotBlank((String)limitJe)) {
                    maxRefundPoints = Double.parseDouble(limitJe);
                }
                if ((double)couponUse.getPointExchange() > 0.0) {
                    if (order.getOrderType().equals("4")) {
                        available = maxRefundPoints;
                    }
                    maxAvailable = ManipulatePrecision.getDetailOverFlow(ManipulatePrecision.mul(ManipulatePrecision.div(available, couponUse.getPointExchange()), couponUse.getPointExchangeMoney()), "0");
                }
                account = couponUse.getAccount();
                pointExchange = couponUse.getPointExchange();
                pointExchangeMoney = couponUse.getPointExchangeMoney();
                rate = couponUse.getRate();
                break;
            }
        }
        JSONObject obj = new JSONObject();
        obj.put("available", (Object)available);
        obj.put("accntNo", account);
        obj.put("maxAvailable", (Object)maxAvailable);
        obj.put("pointExchange", (Object)pointExchange);
        obj.put("pointExchangeMoney", (Object)pointExchangeMoney);
        obj.put("rate", (Object)rate);
        obj.put("maxRefundPoints", (Object)maxRefundPoints);
        return ServiceResponse.buildSuccess((Object)obj);
    }

    private ServiceResponse pointsPay(ServiceSession session, CacheModel cacheModel, PointsPayIn pointsPayIn) {
        AddQrCodeOut addQrCodeOut;
        List<Payment> sellPayment;
        List<Goods> goods = cacheModel.getGoodsList();
        if (goods == null || goods.size() == 0) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u6ca1\u6709\u5546\u54c1\u4e0d\u5141\u8bb8\u79ef\u5206\u652f\u4ed8!");
        }
        ServiceResponse response = this.promotionCentreService.pointsPay(this.restTemplate, session, new PointsPayIn().transferPointsPayIn(cacheModel, pointsPayIn));
        if (!"0".equals(response.getReturncode().trim())) {
            return response;
        }
        if (response.getData() == null) {
            ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u79ef\u5206\u652f\u4ed8\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a!");
        }
        if ((sellPayment = (addQrCodeOut = ((CouponPayOut)response.getData()).transferToAddQrCodeOut()).getSellPayment()) == null || sellPayment.isEmpty()) {
            ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u79ef\u5206\u652f\u4ed8\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a!");
        }
        return ServiceResponse.buildSuccess((Object)addQrCodeOut);
    }

    public ServiceResponse checkMember(ServiceSession session, ConsumersData member) {
        if ("2".equals(member.getConsumsersStatus())) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8be5\u4f1a\u5458\u5df2\u8fc7\u671f,\u4e0d\u53ef\u4f7f\u7528\u79ef\u5206");
        }
        if (member.getBlackFlag() != 0) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"\u4f1a\u5458\u5361\u5f02\u5e38\u4e0d\u5141\u8bb8\u64cd\u4f5c");
        }
        if (member.getConsumsersStatus() == null || !member.getConsumsersStatus().equals("0")) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"\u4f1a\u5458\u72b6\u6001\u4e0d\u6b63\u5e38,\u4e0d\u80fd\u64cd\u4f5c");
        }
        return ServiceResponse.buildSuccess((Object)"");
    }
}

