/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pos.component;

import ch.qos.logback.classic.Logger;
import com.aeon.retail.middleend.sdk.util.SignUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.pos.component.CommonService;
import com.efuture.pos.component.MemberServiceImpl;
import com.efuture.pos.component.OrderServiceImpl;
import com.efuture.pos.component.YWMemberPointServiceImpl;
import com.efuture.pos.component.async.AsyncTask;
import com.efuture.pos.component.common.WorkLogType;
import com.efuture.pos.component.service.ChinaYWService;
import com.efuture.pos.component.service.PromotionCentreService;
import com.efuture.pos.model.BaseOutModel;
import com.efuture.pos.model.CacheModel;
import com.efuture.pos.model.ConsumersData;
import com.efuture.pos.model.Goods;
import com.efuture.pos.model.Order;
import com.efuture.pos.model.OrderForPos;
import com.efuture.pos.model.SysPara;
import com.efuture.pos.model.SysParaInfo;
import com.efuture.pos.model.cnaeon.response.SubCompany;
import com.efuture.pos.model.yongwang.OfflineMemberDef;
import com.efuture.pos.model.yongwang.YWMemberDef;
import com.efuture.pos.model.yongwang.request.DeviceRequest;
import com.efuture.pos.model.yongwang.request.YWMemberConfirmIn;
import com.efuture.pos.model.yongwang.request.YWMemberIn;
import com.efuture.pos.model.yongwang.request.YWMemberRegisterIn;
import com.efuture.pos.model.yongwang.response.OfflineMemberOut;
import com.efuture.pos.model.yongwang.response.YWMemberOut;
import com.efuture.pos.service.YWMemberService;
import com.efuture.pos.service.common.CacheModelService;
import com.efuture.pos.util.CastUtil;
import com.efuture.pos.util.UUIDUtils;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.client.RestTemplate;

public class YWMemberServiceImpl
extends CommonService
implements YWMemberService {
    private static final Logger LOGGER = (Logger)LoggerFactory.getLogger(YWMemberServiceImpl.class);
    private String salt = "";
    private String hyqz = null;
    @Autowired
    private YWMemberPointServiceImpl yWMemberPointService;
    @Autowired
    private PromotionCentreService promotionCentreService;
    @Autowired
    private ChinaYWService chinaYWService;
    @Autowired
    private CacheModelService cacheModelService;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private MemberServiceImpl memberService;
    @Autowired
    OrderServiceImpl orderService;
    @Value(value="${server.route.mode}")
    private String routeMode;
    @Autowired
    AsyncTask asyncTask;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ServiceResponse memberLogin(ServiceSession session, JSONObject paramsObject) {
        ServiceResponse response;
        String flowNo;
        YWMemberConfirmIn paraIn = (YWMemberConfirmIn)JSONObject.toJavaObject((JSON)paramsObject, YWMemberConfirmIn.class);
        if (paraIn.getCertifyType() != null && paraIn.getCertifyType().equalsIgnoreCase("CANCEL") && StringUtils.isNotBlank((String)(flowNo = paramsObject.getString("flowNo")))) {
            CacheModel cacheModel = this.cacheModelService.getCacheModelByFlowNo(flowNo);
            Order order = cacheModel.getOrder();
            order.setTotalPoint(0.0);
            order.setThisTimePoint(0.0);
            order.setConsumersData(new ConsumersData());
            cacheModel.setOrder(order);
            if (cacheModel.getGoodsList() != null && cacheModel.getGoodsList().size() > 0) {
                cacheModel = this.memberService.calcAfterMemberLoginOrCancel(cacheModel, paramsObject, session);
            }
            this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
            OrderForPos orderForPos = OrderForPos.toOrderForPos(cacheModel);
            BaseOutModel out = new BaseOutModel();
            out.setOrder(orderForPos);
            return ServiceResponse.buildSuccess((Object)out);
        }
        if (null != paraIn.getMobileNo() && paraIn.getMobileNo().length() > 11) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u767b\u5f55\u5931\u8d25\uff1a\u624b\u673a\u53f7\u8f93\u5165\u4e0d\u6b63\u786e");
        }
        if (!paramsObject.containsKey((Object)"shopCode") || paramsObject.getString("shopCode").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4f1a\u5458\u767b\u5f55\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u95e8\u5e97\u53f7"});
        }
        flowNo = paramsObject.getString("flowNo");
        String orgId = "";
        int sourceId = 90;
        CacheModel cacheModel = null;
        Order order = null;
        if (StringUtils.isBlank((String)flowNo)) {
            sourceId = CastUtil.castInt(paraIn.getChannel());
            orgId = this.getOrgid(session, paraIn.getErpCode(), paraIn.getShopCode());
            if (StringUtils.isEmpty((String)orgId)) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4ece\u4e3b\u6570\u636e\u83b7\u53d6\u6cd5\u4eba\u516c\u53f8\u4ee3\u7801\u5931\u8d25");
            }
            ArrayList codes = new ArrayList();
            codes.add("ZTKEY");
            codes.add("HYQZ");
            List<SysPara> sysParaList = this.orderService.getSyspara(session, codes, paraIn.getErpCode(), paraIn.getShopCode());
            SysParaInfo sysPara = this.orderService.initSysParaInfo(sysParaList);
            this.salt = sysPara.getZtKey();
            this.hyqz = sysPara.getHyqz();
            if (StringUtils.isBlank((String)this.salt)) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4ece\u603b\u90e8\u83b7\u53d6\u7b7e\u540dkey\u5931\u8d25");
            }
            if (StringUtils.isBlank((String)this.hyqz)) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4ece\u603b\u90e8\u83b7\u53d6\u4f1a\u5458\u5361\u524d\u7f00\u5931\u8d25");
            }
        } else {
            cacheModel = this.cacheModelService.getCacheModelByFlowNo(flowNo);
            if (cacheModel == null) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355!", (Object[])new Object[]{flowNo});
            }
            if ("Y12".equals(cacheModel.getOrder().getOrderType())) {
                for (Goods sg : cacheModel.getGoodsList()) {
                    if (!(sg.getElectronicStamp() > 0.0) && !(sg.getPhysicalStamp() > 0.0)) continue;
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5df2\u5b58\u5728\u6362\u8d2d\u4e0d\u5141\u8bb8\u518d\u5237\u4f1a\u5458\u5361");
                }
            }
            order = cacheModel.getOrder();
            this.salt = order.getSysPara().getZtKey();
            this.hyqz = order.getSysPara().getHyqz();
            if (StringUtils.isBlank((String)this.salt)) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4ece\u603b\u90e8\u83b7\u53d6\u7b7e\u540dkey\u5931\u8d25");
            }
            if (StringUtils.isBlank((String)this.hyqz)) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4ece\u603b\u90e8\u83b7\u53d6\u4f1a\u5458\u5361\u524d\u7f00\u5931\u8d25");
            }
            orgId = order.getOrgId();
            sourceId = CastUtil.castInt(order.getChannel());
            if (order.getStaffSale()) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5df2\u5237\u5458\u5de5\u5361\u4e0d\u5141\u8bb8\u5237\u4f1a\u5458\u5361");
            }
        }
        String cardNo = paraIn.getCardNo();
        boolean isCard = false;
        if (null != cardNo) {
            String mCardNo = this.checkCard(cardNo);
            if (null == mCardNo) return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5361\u53f7\u6821\u9a8c\u5931\u8d25");
            paraIn.setCardNo(mCardNo);
            isCard = true;
        }
        YWMemberIn in = new YWMemberIn(paraIn);
        in.setSourceId(sourceId);
        in.setOrgId(orgId);
        in.setTokenId(UUIDUtils.buildPuid());
        in.setTimestamp(System.currentTimeMillis());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tokenId", in.getTokenId());
        params.put("storeCode", in.getStoreCode());
        params.put("timestamp", in.getTimestamp());
        if (null != in.getMobileNo()) {
            params.put("mobileNo", in.getMobileNo());
        } else {
            params.put("cardNo", in.getCardNo());
        }
        try {
            String sign = SignUtils.getMd5Sign(params, (String)this.salt, (Integer)1);
            System.out.println(sign);
            in.setSign(sign);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LOGGER.info("\u4f1a\u5458\u8bf7\u6c42\u5165\u53c2\uff1a" + JSON.toJSONString((Object)in));
        if (StringUtils.isBlank((String)flowNo)) {
            response = this.chinaYWService.memberQuery(this.restTemplate, session, in);
            if (!"0".equals(response.getReturncode())) return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4f1a\u5458\u9a8c\u8bc1\u5931\u8d25");
            YWMemberOut res = (YWMemberOut)response.getData();
            if (200 != res.getCode() || null == res.getData()) return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)("\u4f1a\u5458\u9a8c\u8bc1\u5931\u8d25:" + res.getMessage()));
            YWMemberDef def = (YWMemberDef)JSON.parseObject((String)res.getData().toJSONString(), YWMemberDef.class);
            if (def.getStatus() == 1) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4f1a\u5458\u67e5\u8be2\u5931\u8d25\uff1a\u8be5\u4f1a\u5458\u5df2\u6ce8\u9500");
            }
            if (def.getStatus() == 2) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4f1a\u5458\u67e5\u8be2\u5931\u8d25\uff1a\u8be5\u4f1a\u5458\u5df2\u8fc7\u671f");
            }
            if (def.getBlackFlag() == 1) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4f1a\u5458\u5361\u8ba4\u8bc1\u5931\u8d25\uff0c\u8bf7\u5230\u670d\u52a1\u53f0\u5904\u7406");
            }
            BaseOutModel out = new BaseOutModel();
            OrderForPos ofs = new OrderForPos();
            ConsumersData custData = new ConsumersData();
            custData.setConsumersCard(def.getCardNo());
            custData.setConsumersCardName(def.getLevelName());
            custData.setConsumersId(String.valueOf(def.getMemberId()));
            custData.setConsumersCName(def.getMember_name());
            if (def.getMemberTypeList().size() > 0) {
                for (Object type : def.getMemberTypeList()) {
                    if ((Integer)type != 1) continue;
                    custData.setIsMami(true);
                    custData.setConsumersLevel("1");
                }
            }
            custData.setConsumersType(def.getLevelCode());
            custData.setConsumersCardExp(def.getEffectiveTime());
            custData.setMobile(def.getMobile());
            custData.setBlackFlag(def.getBlackFlag());
            custData.setPoint(CastUtil.castDouble(def.getConsumePoint()));
            custData.setCorporationCode(def.getCorporationCode());
            double bl = 0.01;
            custData.setPointMoney(CastUtil.castDouble(def.getConsumePoint()) * bl);
            ofs.setConsumersData(custData);
            out.setOrder(ofs);
            return ServiceResponse.buildSuccess((Object)out);
        }
        response = this.chinaYWService.memberQuery(this.restTemplate, session, in);
        if ("0".equals(response.getReturncode())) {
            ServiceResponse resp;
            YWMemberOut res = (YWMemberOut)response.getData();
            if (200 != res.getCode() || null == res.getData()) return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)("\u4f1a\u5458\u9a8c\u8bc1\u5931\u8d25:" + res.getMessage()));
            YWMemberDef def = (YWMemberDef)JSON.parseObject((String)res.getData().toJSONString(), YWMemberDef.class);
            ConsumersData custData = new ConsumersData();
            if (StringUtils.isBlank((String)def.getCardNo())) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4f1a\u5458\u767b\u5f55\u5931\u8d25\uff1a\u4f1a\u5458\u5361\u53f7\u5f02\u5e38");
            }
            custData.setConsumsersStatus(String.valueOf(def.getStatus()));
            custData.setConsumersCard(def.getCardNo());
            custData.setConsumersCardName(def.getLevelName());
            custData.setConsumersId(String.valueOf(def.getMemberId()));
            String name = def.getMember_name();
            if (null != name) {
                name = name.replace("\u007f", "");
            }
            custData.setConsumersCName(name);
            custData.setCorporationCode(def.getCorporationCode());
            if (def.getMemberTypeList().size() > 0) {
                for (Object type : def.getMemberTypeList()) {
                    if ((Integer)type != 1) continue;
                    custData.setIsMami(true);
                    custData.setConsumersLevel("1");
                }
            }
            if (isCard) {
                custData.setLoginType("2");
            } else {
                custData.setLoginType("1");
            }
            custData.setConsumersType(def.getLevelCode());
            custData.setConsumersCardExp(def.getEffectiveTime());
            custData.setMobile(def.getMobile());
            custData.setBlackFlag(def.getBlackFlag());
            custData.setPoint(CastUtil.castDouble(def.getConsumePoint()));
            double bl = 0.0;
            try {
                JSONObject json = new JSONObject();
                json.put("chid", (Object)sourceId);
                json.put("corp_id", (Object)paraIn.getErpCode());
                json.put("cust_type", (Object)def.getLevelCode());
                json.put("org_code", (Object)in.getStoreCode());
                resp = this.promotionCentreService.potCashrate(this.restTemplate, session, json.toJSONString());
                if ("0".equals(response.getReturncode())) {
                    JSONObject js = (JSONObject)resp.getData();
                    bl = js.getJSONObject("jfresult").getDouble("pot_cashrate");
                } else {
                    LOGGER.info("\u67e5\u8be2\u79ef\u5206\u62b5\u6263\u6bd4\u4f8b\u5931\u8d25\uff1a" + resp.getData());
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            JSONObject memberPointQueryin = new JSONObject();
            memberPointQueryin.put("shopCode", (Object)paraIn.getShopCode());
            memberPointQueryin.put("terminalNo", (Object)paraIn.getTerminalNo());
            memberPointQueryin.put("memberId", (Object)def.getMemberId());
            memberPointQueryin.put("terminalOperator", (Object)paraIn.getTerminalOperator());
            memberPointQueryin.put("erpCode", (Object)paraIn.getErpCode());
            memberPointQueryin.put("flowNo", (Object)flowNo);
            resp = this.yWMemberPointService.memberPointQuery(session, memberPointQueryin);
            if ("0".equals(resp.getReturncode())) {
                JSONObject data = JSONObject.parseObject((String)JSON.toJSONString((Object)resp.getData()));
                order.setUnavailablePointDate(data.getString("unavailablePointDate"));
                order.setUnavailablePoint(data.getDoubleValue("unavailablePoint"));
            } else {
                LOGGER.error("\u67e5\u8be2\u4f1a\u5458\u79ef\u5206\u5f02\u5e38:" + resp.getData());
            }
            custData.setPointMoney(CastUtil.castDouble(def.getConsumePoint()) * bl);
            order.setConsumersData(custData);
        } else {
            if (!isCard) return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)("\u4f1a\u5458\u9a8c\u8bc1\u5931\u8d25:" + response.getData()));
            JSONObject inData = new JSONObject();
            inData.put("erpCode", (Object)paraIn.getErpCode());
            inData.put("memberCard", (Object)paraIn.getCardNo());
            inData.put("mkt", (Object)paraIn.getShopCode());
            ServiceResponse res = this.posManagerService.getOfflineMember(this.restTemplate, session, inData.toJSONString());
            if (!"0".equals(res.getReturncode())) return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4f1a\u5458\u9a8c\u8bc1\u5931\u8d25\uff1a\u67e5\u8be2\u79bb\u7ebf\u4f1a\u5458\u5931\u8d25");
            OfflineMemberOut memberOut = (OfflineMemberOut)res.getData();
            if (null != memberOut && memberOut.getMemberprofile().size() > 0) {
                OfflineMemberDef def = memberOut.getMemberprofile().get(0);
                ConsumersData custData = new ConsumersData();
                custData.setConsumersCard(def.getMemberCard());
                custData.setConsumersCardName(def.getMemberLevelName());
                custData.setConsumersId(String.valueOf(def.getMemberId()));
                custData.setConsumersCName(def.getMemberName());
                custData.setCorporationCode(def.getCorporationCode());
                if (def.getIsMomCard() == 1) {
                    custData.setIsMami(true);
                    custData.setConsumersLevel("1");
                }
                custData.setLoginType("2");
                custData.setConsumersType(def.getMemberLevel());
                custData.setConsumersCardExp(def.getMembershipExpireDate());
                order.setConsumersData(custData);
            } else {
                ConsumersData custData = new ConsumersData();
                custData.setConsumersCard(paraIn.getCardNo());
                custData.setConsumersCardName("\u666e\u901a\u5361");
                custData.setConsumersId(paraIn.getCardNo());
                custData.setIsMami(false);
                custData.setLoginType("2");
                custData.setConsumersType("100");
                order.setConsumersData(custData);
            }
        }
        cacheModel.setOrder(order);
        if (cacheModel.getGoodsList() != null && cacheModel.getGoodsList().size() > 0) {
            cacheModel = this.memberService.calcAfterMemberLoginOrCancel(cacheModel, paramsObject, session);
        }
        this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
        OrderForPos orderForPos = OrderForPos.toOrderForPosSingle(cacheModel);
        BaseOutModel out = new BaseOutModel();
        out.setOrder(orderForPos);
        return ServiceResponse.buildSuccess((Object)out);
    }

    public ServiceResponse sendSms(ServiceSession session, JSONObject paramsObject) {
        if (!paramsObject.containsKey((Object)"shopCode") || paramsObject.getString("shopCode").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4f1a\u5458\u767b\u5f55\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u95e8\u5e97\u53f7"});
        }
        YWMemberConfirmIn paraIn = (YWMemberConfirmIn)JSONObject.toJavaObject((JSON)paramsObject, YWMemberConfirmIn.class);
        String orgId = this.getOrgid(session, paraIn.getErpCode(), paraIn.getShopCode());
        if (StringUtils.isEmpty((String)orgId)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4ece\u4e3b\u6570\u636e\u83b7\u53d6\u6cd5\u4eba\u516c\u53f8\u4ee3\u7801\u5931\u8d25");
        }
        ArrayList<String> codes = new ArrayList<String>();
        codes.add("ZTKEY");
        List<SysPara> sysParaList = this.orderService.getSyspara(session, codes, paraIn.getErpCode(), paraIn.getShopCode());
        SysParaInfo sysPara = this.orderService.initSysParaInfo(sysParaList);
        this.salt = sysPara.getZtKey();
        if (StringUtils.isBlank((String)this.salt)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4ece\u603b\u90e8\u83b7\u53d6\u7b7e\u540dkey\u5931\u8d25");
        }
        YWMemberIn in = new YWMemberIn(paraIn);
        in.setSourceId(CastUtil.castInt(paraIn.getChannel()));
        in.setOrgId(orgId);
        in.setTokenId(UUIDUtils.buildPuid());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tokenId", in.getTokenId());
        params.put("orgId", in.getOrgId());
        params.put("mobileNo", in.getMobileNo());
        params.put("storeCode", in.getStoreCode());
        params.put("timestamp", System.currentTimeMillis());
        try {
            String sign = SignUtils.getMd5Sign(params, (String)this.salt, (Integer)1);
            System.out.println(sign);
            params.put("sign", sign);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        params.put("sourceId", in.getSourceId());
        params.put("smsTemplateType", "4");
        ServiceResponse response = this.chinaYWService.sendSms(this.restTemplate, session, params);
        if ("0".equals(response.getReturncode())) {
            YWMemberOut res = (YWMemberOut)response.getData();
            if (200 == res.getCode()) {
                return ServiceResponse.buildSuccess((Object)res.getMessage());
            }
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)("\u4f1a\u5458\u77ed\u4fe1\u9a8c\u8bc1\u5931\u8d25:" + res.getMessage()));
        }
        return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4f1a\u5458\u77ed\u4fe1\u9a8c\u8bc1\u5931\u8d25");
    }

    public ServiceResponse memberRegister(ServiceSession session, JSONObject paramsObject) {
        if (!paramsObject.containsKey((Object)"shopCode") || paramsObject.getString("shopCode").isEmpty()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4f1a\u5458\u6ce8\u518c\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", (Object[])new Object[]{"\u95e8\u5e97\u53f7"});
        }
        YWMemberRegisterIn in = (YWMemberRegisterIn)JSONObject.toJavaObject((JSON)paramsObject, YWMemberRegisterIn.class);
        String orgId = this.getOrgid(session, in.getErpCode(), in.getShopCode());
        if (StringUtils.isEmpty((String)orgId)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4ece\u4e3b\u6570\u636e\u83b7\u53d6\u6cd5\u4eba\u516c\u53f8\u4ee3\u7801\u5931\u8d25");
        }
        ArrayList<String> codes = new ArrayList<String>();
        codes.add("ZTKEY");
        List<SysPara> sysParaList = this.orderService.getSyspara(session, codes, in.getErpCode(), in.getShopCode());
        SysParaInfo sysPara = this.orderService.initSysParaInfo(sysParaList);
        this.salt = sysPara.getZtKey();
        if (StringUtils.isBlank((String)this.salt)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4ece\u603b\u90e8\u83b7\u53d6\u7b7e\u540dkey\u5931\u8d25");
        }
        String shopCode = in.getShopCode();
        String terminalNo = in.getTerminalNo();
        String erpCode = in.getErpCode();
        String terminalOperator = in.getTerminalOperator();
        in.setOrgId(orgId);
        in.setTokenId(UUIDUtils.buildPuid());
        in.setTimestamp(System.currentTimeMillis());
        in.setStoreCode(in.getShopCode());
        in.setShopCode(null);
        in.setSourceId(CastUtil.castInt(in.getChannel()));
        in.setChannel(null);
        DeviceRequest req = new DeviceRequest();
        req.setDeviceCode(in.getTerminalNo());
        in.setDeviceRequest(req);
        in.setTerminalNo(null);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tokenId", in.getTokenId());
        params.put("orgId", in.getOrgId());
        params.put("timestamp", in.getTimestamp());
        params.put("storeCode", in.getStoreCode());
        params.put("mobileNo", in.getMobileNo());
        params.put("smsCaptcha", in.getSmsCaptcha());
        try {
            String sign = SignUtils.getMd5Sign(params, (String)this.salt, (Integer)1);
            System.out.println(sign);
            in.setSign(sign);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ServiceResponse response = this.chinaYWService.memberRegister(this.restTemplate, session, in);
        if ("0".equals(response.getReturncode())) {
            YWMemberOut res = (YWMemberOut)response.getData();
            if (200 == res.getCode()) {
                Order order = new Order();
                order.setShopCode(shopCode);
                order.setTerminalNo(terminalNo);
                order.setErpCode(erpCode);
                order.setTerminalOperator(terminalOperator);
                order.setTerminalSno("");
                order.setFlowNo("");
                this.asyncTask.sendWorkLog(session, order, WorkLogType.regMember);
                return ServiceResponse.buildSuccess((Object)"\u4f1a\u5458\u6ce8\u518c\u6210\u529f");
            }
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)("\u4f1a\u5458\u6ce8\u518c\u5931\u8d25:" + res.getMessage()));
        }
        return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4f1a\u5458\u6ce8\u518c\u5931\u8d25");
    }

    private String getOrgid(ServiceSession session, String erpCode, String shopCode) {
        HashMap<String, String> params = new HashMap<String, String>();
        String orgid = "";
        params.put("erpCode", erpCode);
        params.put("shopCode", shopCode);
        try {
            ServiceResponse resp = this.mainDataCentreService.getSubCompanyByShop(this.restTemplate, session, JSON.toJSONString(params));
            if ("0".equals(resp.getReturncode())) {
                List subCompanys = (List)resp.getData();
                orgid = ((SubCompany)subCompanys.get(0)).getCompanyCode();
            }
        }
        catch (Exception e) {
            LOGGER.info("\u83b7\u53d6\u5b50\u516c\u53f8\u7f16\u7801\u5f02\u5e38:" + e.getMessage());
        }
        return orgid;
    }

    private String checkCard(String cardNo) {
        String mCardNo = null;
        if (cardNo.contains("=")) {
            mCardNo = cardNo.split("=")[0];
            if (mCardNo.length() >= 16) {
                mCardNo = mCardNo.substring(mCardNo.length() - 16);
            }
        } else if ((cardNo.startsWith("93") || cardNo.startsWith("94")) && cardNo.length() >= 18) {
            mCardNo = cardNo.substring(2, 18);
        }
        if (null != mCardNo) {
            if (this.hyqz.contains(",")) {
                String[] qzs;
                for (String qz : qzs = this.hyqz.split(",")) {
                    if (!mCardNo.startsWith(qz)) continue;
                    return mCardNo;
                }
            } else if (mCardNo.startsWith(this.hyqz)) {
                return mCardNo;
            }
        }
        if (cardNo.length() == 10) {
            mCardNo = "637243" + cardNo;
            return mCardNo;
        }
        return null;
    }
}

