/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pos.component;

import ch.qos.logback.classic.Logger;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.pos.component.CommonService;
import com.efuture.pos.component.MemberServiceImpl;
import com.efuture.pos.component.OrderServiceImpl;
import com.efuture.pos.component.service.ZhongBaio2oService;
import com.efuture.pos.model.BaseOutModel;
import com.efuture.pos.model.CacheModel;
import com.efuture.pos.model.ConsumersData;
import com.efuture.pos.model.Goods;
import com.efuture.pos.model.Order;
import com.efuture.pos.model.OrderForPos;
import com.efuture.pos.model.SysPara;
import com.efuture.pos.model.request.ZBMemberConfirmIn;
import com.efuture.pos.model.zhongbai.BaseRequest;
import com.efuture.pos.model.zhongbai.BaseResponse;
import com.efuture.pos.model.zhongbai.request.ZhongBaio2oIn;
import com.efuture.pos.model.zhongbai.request.Zhongbaio2oDataIn;
import com.efuture.pos.model.zhongbai.response.ZhongbaiUsr;
import com.efuture.pos.service.ZBMemberService;
import com.efuture.pos.service.common.CacheModelService;
import com.efuture.pos.util.RSAConfig;
import com.efuture.pos.util.RSAUtil;
import com.efuture.pos.util.UUIDUtils;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.client.RestTemplate;

public class ZBMemberServiceImpl
extends CommonService
implements ZBMemberService {
    private static final Logger LOGGER = (Logger)LoggerFactory.getLogger(ZBMemberServiceImpl.class);
    @Autowired
    private ZhongBaio2oService ZhongBaiOdsiService;
    @Autowired
    private CacheModelService cacheModelService;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private MemberServiceImpl memberService;
    @Resource(name="possvRSAConfig")
    public RSAConfig rsaConfig;
    @Autowired
    OrderServiceImpl orderService;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ServiceResponse memberLogin(ServiceSession session, JSONObject paramsObject) {
        Order order;
        CacheModel cacheModel;
        String flowNo;
        ZBMemberConfirmIn paraIn = (ZBMemberConfirmIn)JSONObject.toJavaObject((JSON)paramsObject, ZBMemberConfirmIn.class);
        if (paraIn.getCertifyType() != null && paraIn.getCertifyType().equalsIgnoreCase("CANCEL") && StringUtils.isNotBlank((String)(flowNo = paramsObject.getString("flowNo")))) {
            CacheModel cacheModel2 = this.cacheModelService.getCacheModelByFlowNo(flowNo);
            Order order2 = cacheModel2.getOrder();
            order2.setTotalPoint(0.0);
            order2.setThisTimePoint(0.0);
            order2.setConsumersData(new ConsumersData());
            cacheModel2.setOrder(order2);
            if (cacheModel2.getGoodsList() != null && cacheModel2.getGoodsList().size() > 0) {
                cacheModel2 = this.memberService.calcAfterMemberLoginOrCancel(cacheModel2, paramsObject, session);
            }
            this.cacheModelService.saveOrUpdateCacheModel(cacheModel2);
            OrderForPos orderForPos = OrderForPos.toOrderForPos(cacheModel2);
            BaseOutModel out = new BaseOutModel();
            out.setOrder(orderForPos);
            return ServiceResponse.buildSuccess((Object)out);
        }
        ServiceResponse response = this.initRSAConfigByPara(session, paraIn.getShopCode(), paraIn.getErpCode());
        if (!"0".equals(response.getReturncode())) {
            return response;
        }
        ZhongBaio2oIn in = new ZhongBaio2oIn();
        Zhongbaio2oDataIn dataIn = new Zhongbaio2oDataIn();
        try {
            dataIn.setTransDate(paraIn.getTransDate());
            dataIn.setPayCode(paraIn.getConsumersCard());
            dataIn.setListNo(paraIn.getTerminalSno());
            dataIn.setStoreCode(paraIn.getShopCode());
            dataIn.setPosId(paraIn.getTerminalNo());
            dataIn.setCashier(paraIn.getTerminalOperator());
            in.setData(dataIn);
            RSAUtil.getPrivateKey(this.rsaConfig.getRSAPrivateKey());
            RSAUtil.getPublicKey(this.rsaConfig.getRSAPublicKey());
            in.setTraceId(UUIDUtils.buildGuid());
            in.setVersion(this.rsaConfig.getVersion());
            in.setMcId(this.rsaConfig.getMcId());
            in.setPactId(this.rsaConfig.getPactId());
            in.setService(BaseRequest.ZBServiceType.TransTypeQuery.code());
        }
        catch (Exception e) {
            LOGGER.info("[\u4f1a\u5458\u5165\u53c2\u4fe1\u606f\u8f6c\u6362\u5f02\u5e38]");
            e.printStackTrace();
        }
        String flowNo2 = paramsObject.getString("flowNo");
        String serviceUrl = this.ZhongBaiOdsiService.getRemotePayServiceUrl(session, paraIn.getShopCode(), paraIn.getErpCode());
        if (null == flowNo2 || "".equals(flowNo2)) {
            response = this.ZhongBaiOdsiService.execute(this.restTemplate, session, JSON.toJSONString((Object)in), BaseRequest.ZBServiceType.TransTypeQuery.desc(), serviceUrl);
            if (!"0".equals(response.getReturncode())) return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4f1a\u5458\u9a8c\u8bc1\u5931\u8d25");
            BaseResponse res = (BaseResponse)response.getData();
            if (!"SUCCESS".equals(res.getResultCode()) || null == res.getData()) return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)("\u4f1a\u5458\u9a8c\u8bc1\u5931\u8d25:" + res.getErrMsg()));
            ZhongbaiUsr usr = res.getData().getUsr();
            if (null != usr) {
                BaseOutModel out = new BaseOutModel();
                OrderForPos ofs = new OrderForPos();
                ConsumersData custData = new ConsumersData();
                custData.setConsumersCard(usr.getUserCode());
                custData.setConsumersId(usr.getUserId());
                custData.setConsumersCName(usr.getUserName());
                custData.setConsumersType(res.getData().getCodeType());
                custData.setConsumersLevel(usr.getGrade());
                ofs.setTotalPoint(usr.getPoint());
                ofs.setThisTimePoint(usr.getBcjf());
                ofs.setConsumersData(custData);
                out.setOrder(ofs);
                return ServiceResponse.buildSuccess((Object)out);
            }
        }
        if ((cacheModel = this.cacheModelService.getCacheModelByFlowNo(flowNo2)) == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u8ba2\u5355[{0}]\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u751f\u6210\u8ba2\u5355!", (Object[])new Object[]{flowNo2});
        }
        if ("Y12".equals(cacheModel.getOrder().getOrderType())) {
            for (Goods sg : cacheModel.getGoodsList()) {
                if (!(sg.getElectronicStamp() > 0.0) && !(sg.getPhysicalStamp() > 0.0)) continue;
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5df2\u5b58\u5728\u6362\u8d2d\u4e0d\u5141\u8bb8\u518d\u5237\u4f1a\u5458\u5361");
            }
        }
        if ((order = cacheModel.getOrder()).getStaffSale()) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u5df2\u5237\u5458\u5de5\u5361\u4e0d\u5141\u8bb8\u5237\u4f1a\u5458\u5361");
        }
        response = this.ZhongBaiOdsiService.execute(this.restTemplate, session, JSON.toJSONString((Object)in), BaseRequest.ZBServiceType.TransTypeQuery.desc(), serviceUrl);
        if (!"0".equals(response.getReturncode())) return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4f1a\u5458\u9a8c\u8bc1\u5931\u8d25");
        BaseResponse res = (BaseResponse)response.getData();
        if (!"SUCCESS".equals(res.getResultCode()) || null == res.getData()) return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)("\u4f1a\u5458\u9a8c\u8bc1\u5931\u8d25" + res.getErrMsg()));
        ZhongbaiUsr usr = res.getData().getUsr();
        if (null != usr) {
            ConsumersData custData = new ConsumersData();
            custData.setConsumersCard(usr.getUserCode());
            custData.setConsumersId(usr.getUserId());
            custData.setConsumersCName(usr.getUserName());
            custData.setConsumersType(res.getData().getCodeType());
            custData.setConsumersLevel(usr.getGrade());
            order.setTotalPoint(usr.getPoint());
            order.setThisTimePoint(usr.getBcjf());
            order.setConsumersData(custData);
        }
        cacheModel.setOrder(order);
        if (cacheModel.getGoodsList() != null && cacheModel.getGoodsList().size() > 0 && (cacheModel = this.memberService.calcAfterMemberLoginOrCancel(cacheModel, paramsObject, session)).getCalcResult() == -1) {
            String errCode = "100000";
            if (!StringUtils.isNotBlank((String)cacheModel.getErrCode())) return ServiceResponse.buildFailure((ServiceSession)session, (String)errCode, (String)cacheModel.getErrMsg());
            errCode = cacheModel.getErrCode();
            return ServiceResponse.buildFailure((ServiceSession)session, (String)errCode, (String)cacheModel.getErrMsg());
        }
        this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
        OrderForPos orderForPos = OrderForPos.toOrderForPos(cacheModel);
        BaseOutModel out = new BaseOutModel();
        out.setOrder(orderForPos);
        return ServiceResponse.buildSuccess((Object)out);
    }

    public ServiceResponse initRSAConfigByPara(ServiceSession session, String shopCode, String erpCode) {
        ArrayList<String> codes = new ArrayList<String>();
        codes.add("ZBMCID");
        List<SysPara> sysPara = this.orderService.getSyspara(session, codes, session.getErpCode(), shopCode);
        String mcId = SysPara.getSysParaInfo(sysPara, "ZBMCID");
        if (StringUtils.isEmpty((String)mcId)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"100000", (String)"\u4ece\u603b\u90e8\u83b7\u53d6\u5546\u6237\u7ecf\u8425\u516c\u53f8\u4ee3\u7801\u5931\u8d25");
        }
        this.rsaConfig.setMcId(mcId);
        return ServiceResponse.buildSuccess(null);
    }
}

