/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pos.component.async;

import com.efuture.pos.component.common.WorkLogType;
import com.efuture.pos.component.service.BaseService;
import com.efuture.pos.component.service.PosManagerService;
import com.efuture.pos.model.Goods;
import com.efuture.pos.model.Order;
import com.efuture.pos.model.posManager.request.SendCancelOrderLogIn;
import com.efuture.pos.model.posManager.request.SendWorkLogIn;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@ConditionalOnProperty(name={"epos.run"}, havingValue="yes", matchIfMissing=true)
@Service
public class AsyncTask
extends BaseService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncTask.class);
    @Autowired
    public PosManagerService posManagerService;
    @Autowired
    RestTemplate restTemplate;

    @Async
    public void sendWorkLog(ServiceSession session, Order order, String type) {
        this.sendWorkLog(session, order, type, null, null);
    }

    @Async
    public void sendWorkLog(ServiceSession session, Order order, String type, double amount) {
        this.sendWorkLog(session, order, type, null, 0.0, amount, null, null, false);
    }

    @Async
    public void sendOrderDiscWorkLog(ServiceSession session, Order order, String type, double amount) {
        this.sendWorkLog(session, order, type, null, 0.0, amount, null, null, true);
    }

    @Async
    public void sendWorkLog(ServiceSession session, Order order, String type, String goodsName, String goodsCode) {
        this.sendWorkLog(session, order, type, 0.0, 0.0, goodsName, goodsCode);
    }

    @Async
    public void sendWorkLog(ServiceSession session, Order order, String type, double amount, String goodsName, String goodsCode) {
        this.sendWorkLog(session, order, type, 0.0, amount, goodsName, goodsCode);
    }

    @Async
    public void sendWorkLog(ServiceSession session, Order order, String type, double count, double amount, String goodsName, String goodsCode) {
        this.sendWorkLog(session, order, type, null, count, amount, goodsName, goodsCode);
    }

    @Async
    public void sendWorkLog(ServiceSession session, Order order, String type, double count, double amount) {
        this.sendWorkLog(session, order, type, null, count, amount, null, null);
    }

    @Async
    public void sendWorkLog(ServiceSession session, Order order, String type, String info, double count, double amount, String goodsName, String goodsCode) {
        this.sendWorkLog(session, order, type, info, count, amount, goodsName, goodsCode, false);
    }

    @Async
    public void sendWorkLog(ServiceSession session, Order order, String type, String info, double count, double amount, String goodsName, String goodsCode, boolean isOrderDisc) {
        try {
            SendWorkLogIn in = new SendWorkLogIn();
            in.setErpCode(order.getErpCode());
            in.setMkt(order.getShopCode());
            in.setSyjh(order.getTerminalNo());
            in.setSyyh(order.getTerminalOperator());
            in.setBillno(order.getTerminalSno());
            if (StringUtils.isNotBlank((String)order.getFlowNo())) {
                in.setPosId(order.getFlowNo());
            }
            in.setGoodsName(goodsName);
            in.setGoodsCode(goodsCode);
            in.setLogtype(type);
            in.setLogdesc(info);
            in.setCount(count);
            in.setAmount(amount);
            if (!WorkLogType.regMember.equals(type)) {
                if (WorkLogType.refund.equals(type) || WorkLogType.voidSale.equals(type) || WorkLogType.superRefund.equals(type)) {
                    if (!StringUtils.isBlank((String)order.getRefundAuthzCardNo()) && !order.getTerminalOperator().equals(order.getRefundAuthzCardNo())) {
                        in.setAuthorizeGh(order.getRefundAuthzCardNo());
                    }
                } else if (isOrderDisc && StringUtils.isNotBlank((String)order.getTotalDiscAuthzCardNo()) && !order.getTerminalOperator().equals(order.getTotalDiscAuthzCardNo())) {
                    in.setAuthorizeGh(order.getTotalDiscAuthzCardNo());
                } else if (!StringUtils.isBlank((String)order.getTerminalOperatorAuthzCardNo()) && !order.getTerminalOperator().equals(order.getTerminalOperatorAuthzCardNo())) {
                    in.setAuthorizeGh(order.getTerminalOperatorAuthzCardNo());
                }
            }
            if (WorkLogType.delGoods.equals(type) || WorkLogType.refund.equals(type) || WorkLogType.voidSale.equals(type) || WorkLogType.superRefund.equals(type)) {
                in.setRowno(order.getFlowNo());
            }
            LocalDateTime dateTime = LocalDateTime.now();
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            String nowDateTime = dateTime.format(df).toString();
            in.setRqsj(nowDateTime);
            ServiceResponse response = this.posManagerService.sendWorkLogSync(this.restTemplate, session, in, order.getFlowNo());
            if ("0".equals(response.getReturncode())) {
                return;
            }
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stringWriter));
            return;
        }
    }

    @Async
    public void sendCancelOrderLog(ServiceSession session, Order order, List<Goods> goodsList, String type, String info) {
        try {
            SendCancelOrderLogIn in = new SendCancelOrderLogIn();
            in.setDelOrder(new ArrayList<SendWorkLogIn>());
            SendWorkLogIn inData = new SendWorkLogIn();
            inData.setErpCode(order.getErpCode());
            inData.setMkt(order.getShopCode());
            inData.setSyjh(order.getTerminalNo());
            inData.setSyyh(order.getTerminalOperator());
            inData.setBillno(order.getTerminalSno());
            inData.setLogtype(type);
            inData.setLogdesc(info);
            if (StringUtils.isNotBlank((String)order.getFlowNo())) {
                inData.setPosId(order.getFlowNo());
            }
            if (!StringUtils.isBlank((String)order.getTerminalOperatorAuthzCardNo()) && !order.getTerminalOperator().equals(order.getTerminalOperatorAuthzCardNo())) {
                inData.setAuthorizeGh(order.getTerminalOperatorAuthzCardNo());
            }
            LocalDateTime dateTime = LocalDateTime.now();
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            String nowDateTime = dateTime.format(df).toString();
            inData.setRqsj(nowDateTime);
            for (Goods sg : goodsList) {
                SendWorkLogIn realData = (SendWorkLogIn)inData.clone();
                realData.setGoodsName(sg.getGoodsName());
                realData.setGoodsCode(sg.getGoodsCode());
                realData.setAmount(sg.getSaleAmount());
                realData.setCount(sg.getQty());
                in.getDelOrder().add(realData);
            }
            ServiceResponse response = this.posManagerService.sendCancelOrderLogSync(this.restTemplate, session, in, order.getFlowNo());
            if ("0".equals(response.getReturncode())) {
                return;
            }
            return;
        }
        catch (Exception e) {
            return;
        }
    }
}

