/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pos.component.common;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.pos.model.BarcodeCacheModel;
import com.efuture.pos.model.GoodsBarcode;
import com.efuture.pos.service.common.BarcodeCacheModelService;
import com.efuture.redis.component.RedisClient;
import com.product.component.RedisCompomentServiceImpl;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;

public class BarcodeCacheModelServiceImpl
extends RedisCompomentServiceImpl<BarcodeCacheModel>
implements BarcodeCacheModelService {
    static final int DEFAULT_KEEPSECONDS = 900;
    @Autowired
    private RedisClient redisClient;
    private ServiceSession session;
    private static final Logger logger = LoggerFactory.getLogger(BarcodeCacheModelServiceImpl.class);

    public BarcodeCacheModelServiceImpl(String collectionName, String keyfieldName) {
        this(collectionName, keyfieldName, null);
    }

    public BarcodeCacheModelServiceImpl(String collectionName, String keyfieldName, Integer keepSeconds) {
        super(collectionName, keyfieldName);
        this.setKeepSeconds(keepSeconds == null ? 900 : keepSeconds);
        this.setSession(this.buildDefaultSession());
    }

    @Override
    public ServiceResponse saveOrUpdateBarcodeCacheModel(BarcodeCacheModel model) {
        if (model == null) {
            throw new RuntimeException("\u7f13\u5b58\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (model.getTradeno() == null) {
            throw new RuntimeException("tradeno\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BarcodeCacheModel barcodecacheModel = this.getBarcodeCacheModel(model.getTradeno());
        ServiceResponse resp = null;
        long BeforToJsonTime = System.currentTimeMillis();
        JSONObject jsonModel = (JSONObject)JSONObject.toJSON((Object)model);
        long AfterToJsonTime = System.currentTimeMillis();
        String tradeno = model.getTradeno();
        if (barcodecacheModel == null || null == barcodecacheModel.getTradeno()) {
            logger.info("barcodecacheModel\u8f6c\u6362json\u8017\u65f6\uff1a\u3010{}\u3011\u6beb\u79d2", (Object)(AfterToJsonTime - BeforToJsonTime));
            jsonModel.put("tradeno", (Object)tradeno);
            int n = this.onInsertd(this.session, this.getTemplate(), jsonModel, this.getCollectionName());
            if (n <= 0) {
                resp = ServiceResponse.buildFailure((ServiceSession)this.session, (String)"10011", (String)"\u66f4\u65b0\u5931\u8d25!");
            } else {
                JSONObject result = new JSONObject();
                result.put("tradeno", (Object)tradeno);
                resp = ServiceResponse.buildSuccess((Object)result);
            }
        } else {
            logger.info("barcodecacheModel\u3010{}\u3011\u8f6c\u6362json\u8017\u65f6\uff1a\u3010{}\u3011\u6beb\u79d2", (Object)tradeno, (Object)(AfterToJsonTime - BeforToJsonTime));
            jsonModel.put("tradeno", (Object)tradeno);
            resp = this.onUpdate(this.session, jsonModel);
        }
        long endTime = System.currentTimeMillis();
        logger.info("\u66f4\u65b0\u7f13\u5b58tradeno:\u3010{}\u3011,\u8017\u65f6\uff1a\u3010{}\u3011\u6beb\u79d2", (Object)tradeno, (Object)(endTime - AfterToJsonTime));
        if (!this.isHandleSuccess(resp)) {
            throw new RuntimeException("\u66f4\u65b0\u7f13\u5b58\u5931\u8d25\uff01\u8bf7\u91cd\u8bd5\uff01" + jsonModel.toJSONString());
        }
        return resp;
    }

    @Override
    public void deleteBarcodeCacheModel(String tradeno) {
        this.onDelete(this.session, this.getKey(tradeno));
    }

    @Override
    public BarcodeCacheModel getBarcodeCacheModel(String tradeno) {
        Object data;
        logger.info("tradeno:------------" + tradeno);
        ServiceResponse resp = this.onQuery(this.session, this.getKey(tradeno));
        logger.info("getBarcodeCacheModel:" + JSON.toJSONString((Object)resp.getData()));
        BarcodeCacheModel model = null;
        if (null != resp && this.isHandleSuccess(resp) && null != (data = resp.getData())) {
            model = this.convertQueryDataToBarcodeCacheModel(data);
        }
        return model;
    }

    protected RedisClient getTemplate() {
        return this.redisClient;
    }

    protected int onUpsertd(ServiceSession session, RedisClient template, Query query, Update update, String collectionName) {
        this.onUpsert(session, template, query, update, collectionName);
        return 1;
    }

    protected int onRemoved(ServiceSession session, RedisClient template, Query query, String collectionName) {
        return 0;
    }

    protected int onUpdate(ServiceSession session, RedisClient template, Query query, Update update, String collectionName) {
        return 0;
    }

    public RedisClient getRedisClient() {
        return this.redisClient;
    }

    public void setRedisClient(RedisClient redisClient) {
        this.redisClient = redisClient;
    }

    public ServiceSession getSession() {
        return this.session;
    }

    public void setSession(ServiceSession session) {
        this.session = session;
    }

    private ServiceSession buildDefaultSession() {
        ServiceSession session = new ServiceSession();
        session.setEnt_id(0L);
        session.setUser_id(0L);
        session.setUser_code("efuture");
        session.setUser_name("\u7cfb\u7edf\u7ba1\u7406\u5458");
        return session;
    }

    private JSONObject getKey(String tradeno) {
        BarcodeCacheModel keyModel = new BarcodeCacheModel();
        keyModel.setTradeno(tradeno);
        String jsonString = JSON.toJSONString((Object)keyModel);
        return JSON.parseObject((String)jsonString);
    }

    private boolean isHandleSuccess(ServiceResponse resp) {
        if (resp == null) {
            return false;
        }
        return "0".equals(resp.getReturncode());
    }

    private BarcodeCacheModel convertQueryDataToBarcodeCacheModel(Object queryData) {
        BarcodeCacheModel model = null;
        JSONObject jsonObject = (JSONObject)queryData;
        JSONArray array = jsonObject.getJSONArray(this.getCollectionName());
        if (!array.isEmpty()) {
            Field[] fields;
            JSONObject jObject = array.getJSONObject(0);
            try {
                String tradeno = jObject.getString("tradeno");
                model = new BarcodeCacheModel();
                model.setTradeno(tradeno);
            }
            catch (Exception e1) {
                return null;
            }
            Class<?> clazz = model.getClass();
            for (Field f : fields = clazz.getDeclaredFields()) {
                String fieldName = f.getName();
                if (fieldName.equals("tradeno") || fieldName.equals("serialVersionUID")) continue;
                String str = jObject.getString(f.getName());
                Class<?> type = f.getType();
                List value = null;
                if (type == List.class) {
                    JSONArray arr = (JSONArray)JSON.parse((String)str);
                    if (null != arr && arr.size() > 0) {
                        ParameterizedType pt = (ParameterizedType)f.getGenericType();
                        Class genericClazz = (Class)pt.getActualTypeArguments()[0];
                        value = JSON.parseArray((String)str, (Class)genericClazz);
                    } else {
                        value = new ArrayList();
                    }
                } else {
                    value = JSON.parseObject((String)str, type);
                }
                fieldName = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                try {
                    clazz.getMethod("set" + fieldName, type).invoke((Object)model, value);
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    logger.error("\u4ece\u7f13\u5b58\u91cc\u53d6\u51fa\u7684\u6570\u636e\u8f6c\u6362\u4e3aBarcodeCacheModel\u51fa\u9519\uff01", (Throwable)e);
                }
            }
        }
        return model;
    }

    @Override
    public ServiceResponse write() {
        BarcodeCacheModel barcodeCacheModel = new BarcodeCacheModel();
        barcodeCacheModel.setTradeno("111111");
        GoodsBarcode gb = new GoodsBarcode("01", "1");
        GoodsBarcode gb1 = new GoodsBarcode("02", "2");
        ArrayList<GoodsBarcode> list = new ArrayList<GoodsBarcode>();
        list.add(gb1);
        list.add(gb);
        barcodeCacheModel.setBarcodeList(list);
        return this.saveOrUpdateBarcodeCacheModel(barcodeCacheModel);
    }

    @Override
    public ServiceResponse read(String tradeno) {
        if (null != tradeno) {
            BarcodeCacheModel barcodeCacheModel = this.getBarcodeCacheModel(tradeno);
            if (null != barcodeCacheModel) {
                List<GoodsBarcode> list = barcodeCacheModel.getBarcodeList();
                return ServiceResponse.buildSuccess(list);
            }
            return ServiceResponse.buildFailure((ServiceSession)this.session, (String)"10000", (String)"\u672a\u67e5\u5230\u7f13\u5b58\u5bf9\u8c61");
        }
        return ServiceResponse.buildFailure((ServiceSession)this.session, (String)"10000", (String)"tradeno\u4e3a\u7a7a");
    }
}

