/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pos.component.common;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.PropertyFilter;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.efuture.pos.component.util.ReadOrWriterUtil;
import com.efuture.pos.model.CacheModel;
import com.efuture.pos.model.CacheModelBase;
import com.efuture.pos.model.Goods;
import com.efuture.pos.model.OperUser;
import com.efuture.pos.model.Order;
import com.efuture.pos.model.Payment;
import com.efuture.pos.model.RedisBaseModel;
import com.efuture.pos.model.RedisModel;
import com.efuture.pos.service.common.CacheModelService;
import com.efuture.pos.utils.LocalCacheUtils;
import com.efuture.redis.component.RedisClient;
import com.efuture.redis.constant.RedisConstant;
import com.product.component.BaseCallback;
import com.product.component.RedisCompomentServiceImpl;
import com.product.model.BeanConstant;
import com.product.model.RowMap;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import com.product.util.UniqueID;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;

public class CacheModelServiceImpl
extends RedisCompomentServiceImpl<RedisModel>
implements CacheModelService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheModelServiceImpl.class);
    @Resource
    ConfigurableEnvironment environment;
    @Autowired
    private LocalCacheUtils localCacheUtils;
    static final int DEFAULT_KEEPSECONDS = 900;
    @Autowired
    private RedisClient redisClient;
    private ServiceSession session;
    private static final Logger logger = LoggerFactory.getLogger(CacheModelServiceImpl.class);
    @Value(value="${server.route.mode}")
    private String routeMode;
    PropertyFilter filter1 = new PropertyFilter(){

        public boolean apply(Object source, String name, Object value) {
            if (value == null) {
                return false;
            }
            if (value instanceof String && ((String)value).isEmpty()) {
                return false;
            }
            return !(value instanceof List) || ((List)value).size() != 0;
        }
    };

    public CacheModelServiceImpl(String collectionName, String keyfieldName, Integer keepSeconds) {
        super(collectionName, keyfieldName);
        this.setKeepSeconds(keepSeconds == null ? 900 : keepSeconds);
        this.setSession(this.buildDefaultSession());
    }

    public CacheModelServiceImpl(String collectionName, String keyfieldName) {
        this(collectionName, keyfieldName, null);
    }

    protected RedisClient getTemplate() {
        return this.redisClient;
    }

    @Override
    public CacheModel saveOrUpdateCacheModel(CacheModel model, boolean isGrant) {
        try {
            if (model == null) {
                throw new RuntimeException("\u7f13\u5b58\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (model.getFlowNo() == null) {
                throw new RuntimeException("\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (model.getOrder() == null) {
                throw new RuntimeException("\u8ba2\u5355\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            String in = null;
            if (!isGrant && model.getIsGrant()) {
                model.setIsGrant(false);
                OperUser operUser = (OperUser)model.getCurGrant().clone();
                model.setCurGrant(model.getCurTempGrant());
                model.setCurTempGrant(operUser);
            }
            if (null == model.getCalcResult()) {
                model.setCalcResult(0);
            }
            if (null == model.getErrMsg()) {
                model.setErrMsg("");
            }
            if (null == model.getErrCode()) {
                model.setErrCode("");
            }
            RedisModel redisModel = new RedisModel();
            model.setSeqNum(model.getSeqNum() + 1);
            redisModel.setCacheModel(model);
            redisModel.setFlowNo(model.getFlowNo());
            CacheModelBase cacheModelBase = this.checkCacheModelExistByFlowNo(model.getFlowNo());
            ServiceResponse resp = null;
            JSONObject jsonModel = null;
            long BeforToJsonTime = System.currentTimeMillis();
            if (StringUtils.isNotBlank(in)) {
                jsonModel = JSON.parseObject(in);
            } else {
                in = JSON.toJSONString((Object)redisModel, (SerializeFilter)this.filter1, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
                jsonModel = JSON.parseObject((String)in);
            }
            long AfterToJsonTime = System.currentTimeMillis();
            Long cacheId = null;
            if (null == cacheModelBase) {
                cacheId = UniqueID.getUniqueID();
                jsonModel.put("cacheId", (Object)cacheId);
                logger.info("Insert cacheModel\u3010{}\u3011\u8f6c\u6362json\u8017\u65f6\uff1a\u3010{}\u3011\u6beb\u79d2", (Object)cacheId, (Object)(AfterToJsonTime - BeforToJsonTime));
                if ("0".equals(this.routeMode) && !"H1".equals(model.getOrder().getOrderType())) {
                    this.localCacheUtils.put(model.getFlowNo(), (Object)jsonModel);
                } else {
                    resp = this.onInsert(this.session, jsonModel);
                }
            } else {
                if (model.getSeqNum() <= cacheModelBase.getSeqNum()) {
                    return model;
                }
                cacheId = model.getCacheId();
                logger.info("Update cacheModel\u3010{}\u3011\u8f6c\u6362json\u8017\u65f6\uff1a\u3010{}\u3011\u6beb\u79d2", (Object)cacheId, (Object)(AfterToJsonTime - BeforToJsonTime));
                jsonModel.put("cacheId", (Object)cacheId);
                if ("0".equals(this.routeMode) && !"H1".equals(model.getOrder().getOrderType())) {
                    this.localCacheUtils.put(model.getFlowNo(), (Object)jsonModel);
                } else {
                    resp = this.onUpdate(this.session, jsonModel);
                }
            }
            long endTime = System.currentTimeMillis();
            logger.info("\u66f4\u65b0\u7f13\u5b58cacheId:\u3010{}\u3011,\u8017\u65f6\uff1a\u3010{}\u3011\u6beb\u79d2", (Object)cacheId, (Object)(endTime - AfterToJsonTime));
            if (!this.isHandleSuccess(resp)) {
                throw new RuntimeException("\u66f4\u65b0\u7f13\u5b58\u5931\u8d25\uff01\u8bf7\u91cd\u8bd5\uff01" + jsonModel.toJSONString());
            }
            return model;
        }
        catch (Exception e) {
            e.printStackTrace();
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stringWriter));
            return model;
        }
    }

    @Override
    public CacheModel saveOrUpdateCacheModel(CacheModel model) {
        return this.saveOrUpdateCacheModel(model, false);
    }

    @Override
    public CacheModel saveOrUpdateCacheModel(RedisModel redisModel) {
        CacheModel model = null;
        try {
            if (redisModel == null) {
                throw new RuntimeException("\u7f13\u5b58\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (redisModel.getFlowNo() == null) {
                throw new RuntimeException("\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (redisModel.getCacheModel() == null) {
                throw new RuntimeException("cacheModel\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (redisModel.getCacheModel().getOrder() == null) {
                throw new RuntimeException("\u8ba2\u5355\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            String in = null;
            model = redisModel.getCacheModel();
            if ("0".equals(this.routeMode)) {
                in = JSON.toJSONString((Object)redisModel, (SerializeFilter)this.filter1, (SerializerFeature[])new SerializerFeature[0]);
                ReadOrWriterUtil.write(in, redisModel.getFlowNo());
            }
            CacheModelBase modelBase = this.checkCacheModelExistByFlowNo(model.getFlowNo());
            ServiceResponse resp = null;
            JSONObject jsonModel = null;
            long BeforToJsonTime = System.currentTimeMillis();
            if (StringUtils.isNotBlank((String)in)) {
                jsonModel = JSON.parseObject((String)in);
            } else {
                in = JSON.toJSONString((Object)redisModel, (SerializeFilter)this.filter1, (SerializerFeature[])new SerializerFeature[0]);
                jsonModel = JSON.parseObject((String)in);
            }
            long AfterToJsonTime = System.currentTimeMillis();
            Long cacheId = null;
            if (null == modelBase) {
                cacheId = UniqueID.getUniqueID();
                jsonModel.put("cacheId", (Object)cacheId);
                logger.info("Insert cacheModel\u3010{}\u3011\u8f6c\u6362json\u8017\u65f6\uff1a\u3010{}\u3011\u6beb\u79d2", (Object)cacheId, (Object)(AfterToJsonTime - BeforToJsonTime));
                if ("0".equals(this.routeMode) && !"H1".equals(model.getOrder().getOrderType())) {
                    this.localCacheUtils.put(model.getFlowNo(), (Object)jsonModel);
                } else {
                    resp = this.onInsert(this.session, jsonModel);
                }
            } else {
                cacheId = model.getCacheId();
                logger.info("Update cacheModel\u3010{}\u3011\u8f6c\u6362json\u8017\u65f6\uff1a\u3010{}\u3011\u6beb\u79d2", (Object)cacheId, (Object)(AfterToJsonTime - BeforToJsonTime));
                jsonModel.put("cacheId", (Object)cacheId);
                if ("0".equals(this.routeMode) && !"H1".equals(model.getOrder().getOrderType())) {
                    this.localCacheUtils.put(model.getFlowNo(), (Object)jsonModel);
                } else {
                    resp = this.onUpdate(this.session, jsonModel);
                }
            }
            long endTime = System.currentTimeMillis();
            logger.info("\u66f4\u65b0\u7f13\u5b58cacheId:\u3010{}\u3011,\u8017\u65f6\uff1a\u3010{}\u3011\u6beb\u79d2", (Object)cacheId, (Object)(endTime - AfterToJsonTime));
            if (!this.isHandleSuccess(resp)) {
                throw new RuntimeException("\u66f4\u65b0\u7f13\u5b58\u5931\u8d25\uff01\u8bf7\u91cd\u8bd5\uff01" + jsonModel.toJSONString());
            }
            return model;
        }
        catch (Exception e) {
            e.printStackTrace();
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stringWriter));
            return model;
        }
    }

    public ServiceResponse onUpdateCallback(ServiceSession session, JSONObject paramsObject, BaseCallback callback) {
        Criteria criteria = Criteria.where((String)this.getKeyfieldName()).is(paramsObject.get((Object)this.getKeyfieldName()));
        Query query = new Query((CriteriaDefinition)criteria);
        HashMap<String, Integer> keyMap = new HashMap<String, Integer>();
        keyMap.put(this.getKeyfieldName(), 1);
        Update update = new Update();
        Set keySet = paramsObject.keySet();
        for (String keyName : keySet) {
            if (keyMap.containsKey(keyName)) continue;
            this.onAssistMap(update, (Map)paramsObject, keyName);
        }
        int n = this.doUpdate(session, this.getTemplate(), query, update, callback);
        if (n <= 0) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"update error");
        }
        return ServiceResponse.buildSuccess((Object)new JSONObject());
    }

    @Override
    public void deleteCacheModel(String flowNo) {
        this.onDelete(this.session, this.getKey(flowNo));
    }

    @Override
    public CacheModel getCacheModelByFlowNo(String flowNo) {
        try {
            long startTime = System.currentTimeMillis();
            JSONObject response = new JSONObject();
            CacheModel model = null;
            Map dataMap = null;
            try {
                String redisQuery = String.format("%1$s:%2$s:%3$s", this.getCollectionName(), "flowNo", flowNo);
                ArrayList otherKeys = new ArrayList();
                if ("0".equals(this.routeMode) && !"H1".equals(model.getOrder().getOrderType())) {
                    Object object = this.localCacheUtils.getIfPresent((Object)flowNo);
                    if (null == object) {
                        response.put(this.getCollectionName(), (Object)new RowMap());
                    }
                    JSONObject json = (JSONObject)JSONObject.toJSON((Object)object);
                    dataMap = (Map)JSONObject.parseObject((String)json.toJSONString(), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
                    response.put(this.getCollectionName(), (Object)dataMap);
                } else {
                    List dataList = this.redisClient.onQueryPageByCondition(RedisConstant.Sort.nosort, this.getCollectionName(), BeanConstant.QueryPage.DEFAULT_PAGENO.intValue(), BeanConstant.QueryPage.DEFAULT_PAGESIZE.intValue(), redisQuery, otherKeys);
                    if (dataList.size() > 0) {
                        dataMap = this.redisClient.onQueryById(this.getCollectionName(), (String)dataList.get(0));
                        response.put(this.getCollectionName(), (Object)dataMap);
                    } else {
                        response.put(this.getCollectionName(), (Object)new RowMap());
                    }
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                response.put(this.getCollectionName(), (Object)new RowMap());
            }
            RedisModel redisModel = this.convertQueryDataToRedisModel(response);
            model = redisModel.getCacheModel();
            long endTime = System.currentTimeMillis();
            logger.info("\u67e5\u627e\u7f13\u5b58\u8017\u65f6\uff1a\u3010{}\u3011\u6beb\u79d2", (Object)(endTime - startTime));
            return model;
        }
        catch (Exception e) {
            e.printStackTrace();
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stringWriter));
            return null;
        }
    }

    public CacheModelBase checkCacheModelExistByFlowNo(String flowNo) {
        try {
            CacheModelBase model;
            JSONObject response;
            long startTime;
            block7: {
                startTime = System.currentTimeMillis();
                response = new JSONObject();
                model = null;
                Map dataMap = null;
                try {
                    String redisQuery = String.format("%1$s:%2$s:%3$s", this.getCollectionName(), "flowNo", flowNo);
                    ArrayList otherKeys = new ArrayList();
                    if ("0".equals(this.routeMode)) {
                        Object object = this.localCacheUtils.getIfPresent((Object)model.getFlowNo());
                        if (null == object) {
                            response.put(this.getCollectionName(), (Object)new RowMap());
                        }
                        JSONObject json = (JSONObject)JSONObject.toJSON((Object)object);
                        dataMap = (Map)JSONObject.parseObject((String)json.toJSONString(), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
                        response.put(this.getCollectionName(), (Object)dataMap);
                        break block7;
                    }
                    List dataList = this.redisClient.onQueryPageByCondition(RedisConstant.Sort.nosort, this.getCollectionName(), BeanConstant.QueryPage.DEFAULT_PAGENO.intValue(), BeanConstant.QueryPage.DEFAULT_PAGESIZE.intValue(), redisQuery, otherKeys);
                    if (dataList.size() > 0) {
                        dataMap = this.redisClient.onQueryById(this.getCollectionName(), (String)dataList.get(0));
                        response.put(this.getCollectionName(), (Object)dataMap);
                        break block7;
                    }
                    return null;
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    response.put(this.getCollectionName(), (Object)new RowMap());
                }
            }
            RedisBaseModel redisModel = this.convertQueryDataToBaseModel(response);
            model = redisModel.getCacheModel();
            long endTime = System.currentTimeMillis();
            logger.info("\u67e5\u627e\u7f13\u5b58\u8017\u65f6\uff1a\u3010{}\u3011\u6beb\u79d2", (Object)(endTime - startTime));
            return model;
        }
        catch (Exception e) {
            e.printStackTrace();
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stringWriter));
            return null;
        }
    }

    @Override
    public CacheModel saveOrUpdateOrder(String flowNo, Order order) {
        CacheModel model = this.checkAndGetCacheModel(flowNo);
        model.setOrder(order);
        return this.saveOrUpdateCacheModel(model);
    }

    @Override
    public Order getOrderByFlowNo(String flowNo) {
        CacheModel model = this.checkAndGetCacheModel(flowNo);
        return model.getOrder();
    }

    @Override
    public CacheModel saveGoodsList(String flowNo, List<Goods> goodsList) {
        CacheModel model = this.checkAndGetCacheModel(flowNo);
        model.setGoodsList(goodsList);
        return this.saveOrUpdateCacheModel(model);
    }

    @Override
    public CacheModel deleteOneGoods(String flowNo, String guid) {
        CacheModel model = this.checkAndGetCacheModel(flowNo);
        List<Goods> goodsList = model.getGoodsList();
        if (CollectionUtils.isNotEmpty(goodsList)) {
            goodsList.removeIf(g -> guid.equals(g.getGuid()));
            CacheModelServiceImpl.sortGoodsList(goodsList);
            model.setGoodsList(goodsList);
        }
        return this.saveOrUpdateCacheModel(model);
    }

    @Override
    public CacheModel updateOneGoods(String flowNo, Goods goods) {
        if (goods == null) {
            throw new RuntimeException("\u5546\u54c1\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String guid = goods.getGuid();
        if (StringUtils.isEmpty((String)guid)) {
            throw new RuntimeException("guid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CacheModel model = this.checkAndGetCacheModel(flowNo);
        List<Goods> goodsList = model.getGoodsList();
        if (null == goodsList) {
            goodsList = new ArrayList<Goods>();
        }
        if (!goodsList.isEmpty()) {
            goodsList.removeIf(g -> goods.getGuid().equals(g.getGuid()));
        }
        goodsList.add(goods);
        CacheModelServiceImpl.sortGoodsList(goodsList);
        model.setGoodsList(goodsList);
        return this.saveOrUpdateCacheModel(model);
    }

    @Override
    public CacheModel addOneGoods(String flowNo, Goods goods) {
        if (goods == null) {
            throw new RuntimeException("\u5546\u54c1\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String guid = goods.getGuid();
        if (StringUtils.isEmpty((String)guid)) {
            throw new RuntimeException("guid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CacheModel model = this.checkAndGetCacheModel(flowNo);
        List<Goods> goodsList = model.getGoodsList();
        CacheModelServiceImpl.appendGoods(goodsList, Arrays.asList(goods));
        model.setGoodsList(goodsList);
        return this.saveOrUpdateCacheModel(model);
    }

    @Override
    public CacheModel addOneGoods(CacheModel cacheModel, Goods goods) {
        if (goods == null) {
            throw new RuntimeException("\u5546\u54c1\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String guid = goods.getGuid();
        if (StringUtils.isEmpty((String)guid)) {
            throw new RuntimeException("guid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<Goods> goodsList = cacheModel.getGoodsList();
        CacheModelServiceImpl.appendGoods(goodsList, Arrays.asList(goods));
        cacheModel.setGoodsList(goodsList);
        return cacheModel;
    }

    @Override
    public CacheModel deleteOneGoods(CacheModel cacheModel, String guid) {
        List<Goods> goodsList = cacheModel.getGoodsList();
        if (CollectionUtils.isNotEmpty(goodsList)) {
            goodsList.removeIf(g -> guid.equals(g.getGuid()));
            CacheModelServiceImpl.sortGoodsList(goodsList);
            cacheModel.setGoodsList(goodsList);
        }
        return cacheModel;
    }

    @Override
    public List<Goods> getGoodsListByFlowNo(String flowNo) {
        CacheModel model = this.checkAndGetCacheModel(flowNo);
        return model.getGoodsList();
    }

    @Override
    public List<Payment> getPaymentsByFlowNo(String flowNo) {
        CacheModel model = this.checkAndGetCacheModel(flowNo);
        return model.getPayments();
    }

    @Override
    public CacheModel savePayments(String flowNo, List<Payment> payments) {
        CacheModel model = this.checkAndGetCacheModel(flowNo);
        model.setPayments(payments);
        return this.saveOrUpdateCacheModel(model);
    }

    @Override
    public CacheModel addOnePayment(String flowNo, Payment payment) {
        if (payment == null) {
            throw new RuntimeException("\u4ed8\u6b3e\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String puid = payment.getPuid();
        if (StringUtils.isEmpty((String)puid)) {
            throw new RuntimeException("puid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CacheModel model = this.checkAndGetCacheModel(flowNo);
        List<Payment> payments = model.getPayments();
        CacheModelServiceImpl.appendPayment(payments, Arrays.asList(payment));
        model.setPayments(payments);
        return this.saveOrUpdateCacheModel(model);
    }

    @Override
    public CacheModel updateOnePayment(String flowNo, Payment payment) {
        if (payment == null) {
            throw new RuntimeException("\u4ed8\u6b3e\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String puid = payment.getPuid();
        if (StringUtils.isEmpty((String)puid)) {
            throw new RuntimeException("puid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CacheModel model = this.checkAndGetCacheModel(flowNo);
        List<Payment> payments = model.getPayments();
        if (null == payments) {
            payments = new ArrayList<Payment>();
        }
        if (!payments.isEmpty()) {
            payments.removeIf(p -> payment.getPuid().equals(p.getPuid()));
        }
        payments.add(payment);
        CacheModelServiceImpl.sortPayments(payments);
        model.setPayments(payments);
        return this.saveOrUpdateCacheModel(model);
    }

    @Override
    public CacheModel deleteOnePayment(String flowNo, String puid) {
        CacheModel model = this.checkAndGetCacheModel(flowNo);
        List<Payment> payments = model.getPayments();
        if (CollectionUtils.isNotEmpty(payments)) {
            payments.removeIf(p -> puid.equals(p.getPuid()));
            CacheModelServiceImpl.sortPayments(payments);
            model.setPayments(payments);
        }
        return this.saveOrUpdateCacheModel(model);
    }

    @Override
    public CacheModel addGoods(String flowNo, List<Goods> goodsList) {
        CacheModel model = this.checkAndGetCacheModel(flowNo);
        List<Goods> originGoodsList = model.getGoodsList();
        originGoodsList = CacheModelServiceImpl.appendGoods(originGoodsList, goodsList);
        model.setGoodsList(originGoodsList);
        return this.saveOrUpdateCacheModel(model);
    }

    @Override
    public CacheModel addPayments(String flowNo, List<Payment> payments) {
        CacheModel model = this.checkAndGetCacheModel(flowNo);
        List<Payment> originPayments = model.getPayments();
        originPayments = CacheModelServiceImpl.appendPayment(originPayments, payments);
        model.setPayments(originPayments);
        return this.saveOrUpdateCacheModel(model);
    }

    public ServiceSession getSession() {
        return this.session;
    }

    public void setSession(ServiceSession session) {
        this.session = session;
    }

    private ServiceSession buildDefaultSession() {
        ServiceSession session = new ServiceSession();
        session.setEnt_id(0L);
        session.setUser_id(0L);
        session.setUser_code("efuture");
        session.setUser_name("\u7cfb\u7edf\u7ba1\u7406\u5458");
        return session;
    }

    private JSONObject getKey(String flowNo) {
        CacheModel keyModel = new CacheModel();
        keyModel.setFlowNo(flowNo);
        String jsonString = JSON.toJSONString((Object)keyModel);
        return JSON.parseObject((String)jsonString);
    }

    private boolean isHandleSuccess(ServiceResponse resp) {
        if (resp == null) {
            return false;
        }
        return "0".equals(resp.getReturncode());
    }

    private CacheModel checkAndGetCacheModel(String flowNo) {
        CacheModel model = this.getCacheModelByFlowNo(flowNo);
        if (model == null) {
            throw new RuntimeException("\u627e\u4e0d\u5230\u7f13\u5b58\u5bf9\u8c61\uff0c\u6d41\u6c34\u53f7--\u300b" + flowNo);
        }
        return model;
    }

    private RedisModel convertQueryDataToRedisModel(Object queryData) {
        try {
            RedisModel model = null;
            JSONObject jsonObject = (JSONObject)queryData;
            JSONObject jObject = jsonObject.getJSONObject(this.getCollectionName());
            if (!jObject.isEmpty()) {
                String cacheId = jObject.getString("cacheId");
                model = new RedisModel();
                model.setCacheId(Long.parseLong(cacheId));
                String flowNo = jObject.getString("flowNo");
                model.setFlowNo(flowNo);
                String cacheModelStr = jObject.getString("cacheModel");
                CacheModel cacheModel = (CacheModel)JSON.parseObject((String)cacheModelStr, CacheModel.class);
                cacheModel.setCacheId(model.getCacheId());
                model.setCacheModel(cacheModel);
            }
            return model;
        }
        catch (Exception e) {
            e.printStackTrace();
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stringWriter));
            return null;
        }
    }

    private RedisBaseModel convertQueryDataToBaseModel(Object queryData) {
        try {
            RedisBaseModel model = null;
            JSONObject jsonObject = (JSONObject)queryData;
            JSONObject jObject = jsonObject.getJSONObject(this.getCollectionName());
            if (!jObject.isEmpty()) {
                String cacheId = jObject.getString("cacheId");
                model = new RedisBaseModel();
                model.setCacheId(Long.parseLong(cacheId));
                String flowNo = jObject.getString("flowNo");
                model.setFlowNo(flowNo);
                String cacheModelStr = jObject.getString("cacheModel");
                CacheModelBase cacheModel = (CacheModelBase)JSON.parseObject((String)cacheModelStr, CacheModelBase.class);
                cacheModel.setCacheId(model.getCacheId());
                model.setCacheModel(cacheModel);
            }
            return model;
        }
        catch (Exception e) {
            e.printStackTrace();
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stringWriter));
            return null;
        }
    }

    private static List<Payment> sortPayments(List<Payment> payments) {
        payments.sort(new Comparator<Payment>(){

            @Override
            public int compare(Payment o1, Payment o2) {
                if (o1.getRowno() < o2.getRowno()) {
                    return -1;
                }
                return 0;
            }
        });
        int size = payments.size();
        for (int i = 0; i < size; ++i) {
            payments.get(i).setRowno(i + 1);
        }
        return payments;
    }

    public static List<Goods> sortGoodsList(List<Goods> goodsList) {
        goodsList.sort(new Comparator<Goods>(){

            @Override
            public int compare(Goods o1, Goods o2) {
                if (o1.getFlowId() < o2.getFlowId()) {
                    return -1;
                }
                return 0;
            }
        });
        int size = goodsList.size();
        for (int i = 0; i < size; ++i) {
            goodsList.get(i).setFlowId(i + 1);
        }
        return goodsList;
    }

    private static List<Goods> appendGoods(List<Goods> originGoodsList, List<Goods> goodsList) {
        if (originGoodsList == null) {
            originGoodsList = new ArrayList<Goods>();
        }
        int sortStart = originGoodsList.size();
        for (Goods g : goodsList) {
            g.setFlowId(++sortStart);
        }
        originGoodsList.addAll(goodsList);
        return originGoodsList;
    }

    private static List<Payment> appendPayment(List<Payment> originPayments, List<Payment> payments) {
        if (originPayments == null) {
            originPayments = new ArrayList<Payment>();
        }
        int sortStart = originPayments.size();
        for (Payment g : payments) {
            g.setRowno(++sortStart);
        }
        originPayments.addAll(payments);
        return originPayments;
    }

    public static <T> List<T> parseJsonStr2Array(String source, Class<T> targetClazz) {
        List arr = null;
        try {
            arr = JSON.parseArray((String)source, targetClazz);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arr;
    }

    public static <T> T parseJsonStr2Object(String source, Class<T> targetClazz) {
        Object arr = null;
        try {
            arr = JSON.parseObject((String)source, targetClazz);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (T)arr;
    }

    public static CacheModel beforeSave(CacheModel model) {
        model = CacheModelServiceImpl.autoInitFields(model);
        return CacheModelServiceImpl.resetCalcResult(model);
    }

    private static CacheModel autoInitFields(CacheModel model) {
        Field[] fields;
        Class<?> clazz = model.getClass();
        for (Field f : fields = clazz.getDeclaredFields()) {
            String fieldName = f.getName();
            if ("serialVersionUID".equals(fieldName) || "cacheId".equals(fieldName)) continue;
            fieldName = fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
            try {
                Method getMethod = clazz.getMethod("get" + fieldName, null);
                Object value = getMethod.invoke((Object)model, (Object[])null);
                if (null != value) continue;
                Object setValue = null;
                Class<?> returnType = getMethod.getReturnType();
                if (returnType == List.class) {
                    setValue = new ArrayList();
                } else if (returnType == String.class) {
                    setValue = "";
                } else if (returnType == Integer.class) {
                    setValue = fieldName.equals("calcResult") ? Integer.valueOf(-2) : Integer.valueOf(0);
                } else if (returnType == Double.class) {
                    setValue = 0.0;
                } else if (returnType == Long.class) {
                    setValue = 0L;
                } else {
                    Constructor<?> constructor = returnType.getConstructor(null);
                    setValue = constructor.newInstance(null);
                }
                clazz.getMethod("set" + fieldName, returnType).invoke((Object)model, setValue);
            }
            catch (Exception e) {
                logger.error("\u4fdd\u5b58redis\u524d\u7f6e\u5904\u7406\u51fa\u9519\uff01", (Throwable)e);
            }
        }
        return model;
    }

    private static CacheModel resetCalcResult(CacheModel model) {
        Integer calcResult = model.getCalcResult();
        if (null == calcResult || model.getCalcResult() == -1) {
            model.setErrMsg("");
            model.setCalcResult(0);
            model.setErrCode("");
        }
        return model;
    }

    public static void main(String[] args) {
        CacheModel m = new CacheModel();
        String s = "j";
        Object parse = JSON.parse((String)s);
        System.out.println(parse);
    }

    @Override
    public ServiceResponse test(ServiceSession s, JSONObject p) {
        CacheModel model = new CacheModel();
        model.setFlowNo("12345900072");
        Order order = new Order();
        order.setCalcMarketingMode("993000000");
        order.setChangeValue(90.0);
        ArrayList<Goods> goods = new ArrayList<Goods>();
        Goods g = new Goods();
        g.setAdjustDiscountValue(0.0);
        g.setBarNo("099999915555");
        Goods g2 = new Goods();
        g2.setAdjustDiscountValue(9.0);
        g2.setBarNo("888888882525");
        goods.add(g2);
        goods.add(g);
        model.setGoodsList(goods);
        model.setOrder(order);
        this.saveOrUpdateCacheModel(model);
        return ServiceResponse.buildSuccess((Object)model);
    }

    protected int onUpsertd(ServiceSession session, RedisClient template, Query query, Update update, String collectionName) {
        this.onUpsert(session, template, query, update, collectionName);
        return 1;
    }

    protected int onRemoved(ServiceSession session, RedisClient template, Query query, String collectionName) {
        return 0;
    }

    protected int onUpdate(ServiceSession session, RedisClient template, Query query, Update update, String collectionName) {
        return 0;
    }

    @Override
    public Map<String, String> writeToLocalFile(String flowNo) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.put("success", "1");
        String path = this.environment.getProperty("pos.config.path") + "flowno/";
        try {
            File file;
            CacheModel model = this.checkAndGetCacheModel(flowNo);
            String jsonStr = JSONObject.toJSONString((Object)model);
            File folder = new File(path);
            if (!folder.exists()) {
                try {
                    folder.mkdirs();
                }
                catch (Exception e) {
                    LOGGER.error("\u672c\u5730\u65e0\u6cd5\u521b\u5efa\u76ee\u5f55" + folder.getAbsolutePath() + "\uff0c\u8bf7\u68c0\u67e5\uff01");
                    resultMap.put("success", "0");
                    resultMap.put("msg", "\u672c\u5730\u65e0\u6cd5\u521b\u5efa\u76ee\u5f55" + folder.getAbsolutePath() + "\uff0c\u8bf7\u68c0\u67e5\uff01");
                    return resultMap;
                }
            }
            if (!(file = new File(path + flowNo + ".txt")).exists()) {
                file.createNewFile();
            }
            try {
                FileOutputStream os = new FileOutputStream(file);
                ((OutputStream)os).write(jsonStr.getBytes());
                os.flush();
                ((OutputStream)os).close();
            }
            catch (IOException e) {
                resultMap.put("success", "0");
                resultMap.put("msg", e.getMessage());
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        catch (Exception e) {
            resultMap.put("success", "0");
            resultMap.put("msg", e.getMessage());
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return resultMap;
    }

    @Override
    public int flushOrderToRedis() {
        int flag = 1;
        String path = this.environment.getProperty("pos.config.path") + "flowno/";
        try {
            File folder = new File(path);
            if (folder.exists()) {
                File[] files;
                for (File file : files = folder.listFiles()) {
                    String jsonStr = CacheModelServiceImpl.readFile(file);
                    JSONObject json = JSON.parseObject((String)jsonStr);
                    CacheModel model = (CacheModel)JSON.toJavaObject((JSON)json, CacheModel.class);
                    try {
                        model = this.saveOrUpdateCacheModel(model);
                        if (model == null) continue;
                        file.delete();
                    }
                    catch (Exception e) {
                        flag = 0;
                        LOGGER.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            flag = 0;
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return flag;
    }

    public static String readFile(File file) {
        StringBuilder result = new StringBuilder();
        try {
            BufferedReader br = new BufferedReader(new FileReader(file));
            String s = null;
            while ((s = br.readLine()) != null) {
                result.append(System.lineSeparator() + s);
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result.toString();
    }
}

