/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pos.component.dao.impl;

import com.efuture.pos.component.dao.MzkServerDao;
import com.efuture.pos.component.dao.config.ConfigureDataSource;
import com.efuture.pos.component.dao.core.DbTools;
import com.efuture.pos.component.dao.core.MultipleDataSource;
import com.efuture.pos.model.response.MzkResultDef;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.CallableStatementCallback;
import org.springframework.jdbc.core.CallableStatementCreator;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@ConditionalOnProperty(name={"epos.run"}, havingValue="yes", matchIfMissing=true)
@Repository
public class MzkServerDaoImpl
implements MzkServerDao {
    private Logger logger = Logger.getLogger(MzkServerDaoImpl.class);
    private String dataSourceUrl;
    @Autowired
    @Qualifier(value="dzkDataSource")
    private ConfigureDataSource dzkDataSource;
    @Autowired
    @Qualifier(value="xykDataSource")
    ConfigureDataSource xykDataSource;
    @Autowired
    @Qualifier(value="hkyhDataSource")
    ConfigureDataSource hkyhDataSource;
    @Autowired
    @Qualifier(value="lmsDataSource")
    ConfigureDataSource lmsDataSource;
    @Autowired
    @Qualifier(value="xmsDataSource")
    ConfigureDataSource xmsDataSource;
    @Autowired
    MultipleDataSource multipleDataSource;
    @Autowired
    @Qualifier(value="primaryJdbcTemplate")
    private JdbcTemplate primaryJdbcTemplate;
    private DbTools dbTools = new DbTools();
    @Value(value="${java_sendmzk}")
    private String java_sendmzk;
    @Value(value="${java_sendmzkIn}")
    private String java_sendmzkIn;
    @Value(value="${java_sendmzkOut}")
    private String java_sendmzkOut;
    @Value(value="${java_senddzk}")
    private String java_senddzk;
    @Value(value="${dataCharacter}")
    private String dataCharacter;

    @Override
    public MzkResultDef sendMzk(final String json, String dataSource) {
        MultipleDataSource.setDataSourceKey(dataSource);
        HashMap ropValue = (HashMap)this.primaryJdbcTemplate.execute(new CallableStatementCreator(){

            public CallableStatement createCallableStatement(Connection con) {
                try {
                    String storedProc = MzkServerDaoImpl.this.java_sendmzk;
                    CallableStatement cs = con.prepareCall(storedProc);
                    return MzkServerDaoImpl.this.dbTools.paseCallableStatementRes(cs, json, MzkServerDaoImpl.this.java_sendmzkIn, MzkServerDaoImpl.this.java_sendmzkOut, MzkServerDaoImpl.this.dataCharacter);
                }
                catch (Exception e) {
                    MzkServerDaoImpl.this.logger.fatal((Object)e);
                    e.printStackTrace();
                    return null;
                }
            }
        }, new CallableStatementCallback(){

            public Object doInCallableStatement(CallableStatement cs) throws SQLException, DataAccessException {
                try {
                    cs.execute();
                    return MzkServerDaoImpl.this.dbTools.paseCallableStatementRop(cs, MzkServerDaoImpl.this.java_sendmzkIn, MzkServerDaoImpl.this.java_sendmzkOut, MzkServerDaoImpl.this.dataCharacter);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    MzkServerDaoImpl.this.logger.fatal((Object)e);
                    return null;
                }
            }
        });
        String retcode = "";
        if (ropValue != null && ropValue.get("retcode") != null) {
            retcode = (String)ropValue.get("retcode");
        } else {
            this.logger.fatal((Object)"sendmzksale prc return error");
        }
        MzkResultDef mzk = new MzkResultDef();
        try {
            this.logger.info((Object)("czkres:" + ropValue));
            DbTools.ConvertToObjectNoTranscoding(mzk, ropValue, MzkResultDef.ref);
            if (!retcode.equals("00")) {
                this.logger.fatal((Object)("sendmzksale proc retcode is not 0 and the proc message is: " + mzk.getRerrmsg()));
            }
        }
        catch (Exception e) {
            mzk.setRetcode("1");
            mzk.setRerrmsg("sendmzksale proc HASHMAP convert to Bean error");
            this.logger.fatal((Object)e);
        }
        MultipleDataSource.clearDataSourceType();
        return mzk;
    }

    @Override
    public MzkResultDef sendDzk(final String json) {
        MultipleDataSource.setDataSourceKey("dzkDataSource");
        HashMap ropValue = (HashMap)this.primaryJdbcTemplate.execute(new CallableStatementCreator(){

            public CallableStatement createCallableStatement(Connection con) {
                try {
                    String storedProc = MzkServerDaoImpl.this.java_senddzk;
                    CallableStatement cs = con.prepareCall(storedProc);
                    return MzkServerDaoImpl.this.dbTools.paseCallableStatementRes(cs, json, MzkServerDaoImpl.this.java_sendmzkIn, MzkServerDaoImpl.this.java_sendmzkOut, MzkServerDaoImpl.this.dataCharacter);
                }
                catch (Exception e) {
                    MzkServerDaoImpl.this.logger.fatal((Object)e);
                    e.printStackTrace();
                    return null;
                }
            }
        }, new CallableStatementCallback(){

            public Object doInCallableStatement(CallableStatement cs) throws SQLException, DataAccessException {
                try {
                    cs.execute();
                    return MzkServerDaoImpl.this.dbTools.paseCallableStatementRop(cs, MzkServerDaoImpl.this.java_sendmzkIn, MzkServerDaoImpl.this.java_sendmzkOut, MzkServerDaoImpl.this.dataCharacter);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    MzkServerDaoImpl.this.logger.fatal((Object)e);
                    return null;
                }
            }
        });
        String retcode = "";
        if (ropValue != null && ropValue.get("retcode") != null) {
            retcode = (String)ropValue.get("retcode");
        } else {
            this.logger.fatal((Object)"sendmzksale prc return error");
        }
        MzkResultDef mzk = new MzkResultDef();
        try {
            DbTools.ConvertToObjectNoTranscoding(mzk, ropValue, MzkResultDef.ref);
            if (!retcode.equals("00")) {
                this.logger.fatal((Object)("sendmzksale proc retcode is not 0 and the proc message is: " + mzk.getRerrmsg()));
            }
        }
        catch (Exception e) {
            mzk.setRetcode("1");
            mzk.setRerrmsg("sendmzksale proc HASHMAP convert to Bean error");
            this.logger.fatal((Object)e);
        }
        MultipleDataSource.clearDataSourceType();
        return mzk;
    }

    public void changeDataSource(String sysParaInfo) {
        this.logger.info((Object)("dataSourceUrl:" + this.dataSourceUrl + ";sysParaInfo:" + sysParaInfo));
        if (null == this.dataSourceUrl) {
            this.dataSourceUrl = sysParaInfo;
        } else {
            if (this.dataSourceUrl.equals(sysParaInfo)) {
                return;
            }
            this.dataSourceUrl = sysParaInfo;
        }
        if (this.dataSourceUrl.contains(",")) {
            try {
                String[] split = this.dataSourceUrl.split(",");
                if (split.length >= 5) {
                    if (!this.xykDataSource.getUrl().equals(split[0])) {
                        this.xykDataSource.setUrl(split[0]);
                        this.xykDataSource.restart();
                    }
                    if (!this.hkyhDataSource.getUrl().equals(split[1])) {
                        this.hkyhDataSource.setUrl(split[1]);
                        this.hkyhDataSource.restart();
                    }
                    if (!this.lmsDataSource.getUrl().equals(split[2])) {
                        this.lmsDataSource.setUrl(split[2]);
                        this.lmsDataSource.restart();
                    }
                    if (!this.xmsDataSource.getUrl().equals(split[3])) {
                        this.xmsDataSource.setUrl(split[3]);
                        this.xmsDataSource.restart();
                    }
                    if (!this.dzkDataSource.getUrl().equals(split[4])) {
                        this.dzkDataSource.setUrl(split[4]);
                        this.dzkDataSource.restart();
                    }
                }
            }
            catch (SQLException e) {
                this.logger.info((Object)"\u8bbe\u7f6e\u6570\u636e\u6e90\u5931\u8d25");
                e.printStackTrace();
            }
            this.logger.info((Object)("xykDataSource:" + this.xykDataSource.getUrl() + ";hkyhDataSource:" + this.hkyhDataSource.getUrl()));
            HashMap<String, ConfigureDataSource> map = new HashMap<String, ConfigureDataSource>();
            map.put("xykDataSource", this.xykDataSource);
            map.put("lmsDataSource", this.lmsDataSource);
            map.put("hkyhDataSource", this.hkyhDataSource);
            map.put("xmsDataSource", this.xmsDataSource);
            map.put("dzkDataSource", this.dzkDataSource);
            this.multipleDataSource.setTargetDataSources(map);
            this.primaryJdbcTemplate = new JdbcTemplate((DataSource)((Object)this.multipleDataSource));
            this.logger.info((Object)"\u8bbe\u7f6e\u6570\u636e\u6e90\u7ed3\u675f");
        }
    }
}

