/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pos.component.scheduled;

import com.alibaba.fastjson.JSONObject;
import com.efuture.pos.component.CouponReverseServiceImpl;
import com.efuture.pos.component.PointConsumeReverseServiceImpl;
import com.efuture.pos.component.util.ReadOrWriterUtil;
import com.efuture.pos.model.RedisModel;
import com.efuture.pos.service.common.CacheModelService;
import com.product.model.ServiceSession;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(name={"epos.run"}, havingValue="yes", matchIfMissing=true)
@Component
public class RunnerServiceImpl
implements CommandLineRunner {
    private static final Logger logger = LoggerFactory.getLogger(RunnerServiceImpl.class);
    @Autowired
    CacheModelService cacheModelService;
    @Autowired
    PointConsumeReverseServiceImpl pointConsumeReverseService;
    @Autowired
    CouponReverseServiceImpl couponReverseService;
    @Value(value="${server.route.mode}")
    private String routeMode;

    public void run(String ... strings) throws Exception {
        new Thread(){

            @Override
            public void run() {
                List<String> fileList;
                logger.info("\u542f\u52a8\u79ef\u5206\u51b2\u6b63\u5931\u8d25\u8bb0\u5f55\u53d1\u9001mq");
                ServiceSession session = new ServiceSession();
                session.setEnt_id(0L);
                RunnerServiceImpl.this.pointConsumeReverseService.send(session, new JSONObject());
                logger.info("\u79ef\u5206\u51b2\u6b63\u5931\u8d25\u8bb0\u5f55\u53d1\u9001mq\u5b8c\u6bd5");
                logger.info("\u542f\u52a8\u5238\u51b2\u6b63\u5931\u8d25\u53d1\u9001mq");
                RunnerServiceImpl.this.couponReverseService.send(session, new JSONObject());
                logger.info("\u5238\u51b2\u6b63\u5931\u8d25\u8bb0\u5f55\u53d1\u9001mq\u5b8c\u6bd5");
                if ("0".equals(RunnerServiceImpl.this.routeMode) && null != (fileList = ReadOrWriterUtil.getFileList()) && fileList.size() > 0) {
                    for (String fileName : fileList) {
                        try {
                            String modelStr;
                            if (StringUtils.isEmpty((String)fileName) || !StringUtils.isNotEmpty((String)(modelStr = ReadOrWriterUtil.read(fileName)))) continue;
                            RedisModel cacheModel = (RedisModel)JSONObject.parseObject((String)modelStr, RedisModel.class);
                            LocalDateTime dateTime = LocalDateTime.now();
                            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                            LocalDateTime orderDateTime = LocalDateTime.parse(cacheModel.getCacheModel().getOrder().getSaleDate(), df);
                            if (orderDateTime.isBefore(dateTime.minusDays(3L))) {
                                ReadOrWriterUtil.delete(fileName);
                                continue;
                            }
                            RunnerServiceImpl.this.cacheModelService.saveOrUpdateCacheModel(cacheModel);
                            logger.info("\u65ad\u7535\u4fdd\u62a4\u6587\u4ef6\u5199\u5165\u7f13\u5b58\u6210\u529f");
                        }
                        catch (Exception e) {
                            ReadOrWriterUtil.delete(fileName);
                        }
                    }
                }
            }
        }.start();
    }
}

