/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pos.component.service;

import com.alibaba.fastjson.JSON;
import com.efuture.pos.component.service.BaseService;
import com.efuture.pos.model.aeonacs.request.AcsPayIn;
import com.efuture.pos.model.aeonacs.request.GetTrackDataIn;
import com.efuture.pos.model.aeonacs.response.AcsPayOut;
import com.efuture.pos.model.aeonacs.response.GetTrackDataOut;
import com.efuture.pos.util.HttpUtils;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@ConditionalOnProperty(name={"epos.run"}, havingValue="yes", matchIfMissing=true)
@Service
public class AeonAcsService
extends BaseService {
    public static final String CIPPAY_METHOD = "acs.adpter.cipService.send";
    public static final String GETCIPPAYTRACKDATA = "acs.adpter.ciplog.search";

    public ServiceResponse cipPay(RestTemplate restTemplate, ServiceSession session, AcsPayIn in) {
        String jsonStr = JSON.toJSONString((Object)in);
        ServiceResponse resp = this.httpUtils.doPost(restTemplate, HttpUtils.RemoteService.CRM_IBM, CIPPAY_METHOD, session, jsonStr, AcsPayOut.class, "CIP\u9002\u914d\u5668", "cipPay");
        if ("0".equals(resp.getReturncode())) {
            AcsPayOut acsPayOut = (AcsPayOut)resp.getData();
            resp = AeonAcsService.resolveResponse(resp, acsPayOut);
        } else {
            resp = ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"Reject");
        }
        return resp;
    }

    public ServiceResponse getTrackData(RestTemplate restTemplate, ServiceSession session, GetTrackDataIn in) {
        String jsonStr = JSON.toJSONString((Object)in);
        ServiceResponse resp = this.httpUtils.doPost(restTemplate, HttpUtils.RemoteService.CRM_IBM, GETCIPPAYTRACKDATA, session, jsonStr, GetTrackDataOut.class, "CIP\u9002\u914d\u5668", "\u67e5\u8be2\u539f\u4ea4\u6613\u4fe1\u606f");
        return resp;
    }

    private static ServiceResponse resolveResponse(ServiceResponse originResp, AcsPayOut out) {
        ServiceResponse resp = originResp;
        String tradeReturnCode = out.getResponseCode();
        if (tradeReturnCode == null) {
            throw new RuntimeException("\u8bf7\u6c42ACS\u8fd4\u56de\u7801\u4e3a\u7a7a\uff01");
        }
        if ("00".equals(tradeReturnCode)) {
            resp.setData((Object)out);
        } else {
            String errMsg = AeonAcsService.getTradeReturnMsg(tradeReturnCode);
            resp.setReturncode(tradeReturnCode);
            resp.setData((Object)errMsg);
        }
        return resp;
    }

    private static String getTradeReturnMsg(String code) {
        switch (code) {
            case "01": {
                return "Please refer to Issuer";
            }
            case "02": {
                return "Invalid Card";
            }
            case "03": {
                return "Duplicate Transaction";
            }
        }
        return "\u672a\u77e5\u9519\u8bef";
    }
}

