/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pos.component.service;

import com.alibaba.fastjson.JSON;
import com.efuture.pos.component.service.BaseService;
import com.efuture.pos.model.aeoncrm.AeonCrmReply;
import com.efuture.pos.model.aeoncrm.request.PointCancelExchangeIn;
import com.efuture.pos.model.aeoncrm.request.PointCancelTransactionIn;
import com.efuture.pos.model.aeoncrm.request.PointExchangeIn;
import com.efuture.pos.model.aeoncrm.request.PointQueryIn;
import com.efuture.pos.model.aeoncrm.request.PointRefundExchangeIn;
import com.efuture.pos.model.aeoncrm.request.PointRefundTransactionGoodsQueryIn;
import com.efuture.pos.model.aeoncrm.request.PointRefundTransactionIn;
import com.efuture.pos.model.aeoncrm.request.PointTransactionIn;
import com.efuture.pos.model.aeoncrm.response.PointCancelExchangeOut;
import com.efuture.pos.model.aeoncrm.response.PointCancelTransactionOut;
import com.efuture.pos.model.aeoncrm.response.PointExchangeOut;
import com.efuture.pos.model.aeoncrm.response.PointQueryOut;
import com.efuture.pos.model.aeoncrm.response.PointRefundExchangeOut;
import com.efuture.pos.model.aeoncrm.response.PointRefundTransactionGoodsQueryOut;
import com.efuture.pos.model.aeoncrm.response.PointRefundTransactionOut;
import com.efuture.pos.model.aeoncrm.response.PointTransactionOut;
import com.efuture.pos.util.HttpUtils;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@ConditionalOnProperty(name={"epos.run"}, havingValue="yes", matchIfMissing=true)
@Service
public class AeonIBMCrmService
extends BaseService {
    public static final String POINT_TRANSACTION_METHOD = "crm.adpter.integralcardintegraltransaction.send";
    public static final String POINT_QUERY_METHOD = "crm.adpter.integralCardIntegralSearch.send";
    public static final String POINT_TRANSACTION_CANCEL_METHOD = "crm.adpter.integralcardintegraltransactioncancancellation.send";
    public static final String POINT_TRANSACTION_REFUND_GOODS_METHOD = "crm.adpter.integralCardIntegralTransactionReturnSearch.send";
    public static final String POINT_TRANSACTION_REFUND_METHOD = "crm.adpter.integralCardTransactionReturn.send";
    public static final String POINT_EXCHANGE_METHOD = "crm.adpter.integralcardexchangetransaction.send";
    public static final String POINT_EXCHANGE_CANCEL_METHOD = "crm.adpter.integralcardexchangetransactioncancancellation.send";
    public static final String POINT_EXCHANGE_REFUND_METHOD = "crm.adpter.integralcardexchangetransactionreturn.send";

    public ServiceResponse pointTransaction(RestTemplate restTemplate, ServiceSession session, PointTransactionIn in) {
        String jsonStr = JSON.toJSONString((Object)in);
        ServiceResponse resp = this.httpUtils.doPost(restTemplate, HttpUtils.RemoteService.CRM_IBM, POINT_TRANSACTION_METHOD, session, jsonStr, PointTransactionOut.class, "CRM\u4f1a\u5458\u7cfb\u7edf", "\u79ef\u5206\u4ea4\u6613");
        if ("0".equals(resp.getReturncode())) {
            PointTransactionOut pointQueryOut = (PointTransactionOut)resp.getData();
            resp = AeonIBMCrmService.resolveResponse(resp, pointQueryOut.getIntegralCardIntegralTransactionReply());
        }
        return resp;
    }

    public ServiceResponse pointQuery(RestTemplate restTemplate, ServiceSession session, PointQueryIn in) {
        String jsonStr = JSON.toJSONString((Object)in);
        ServiceResponse resp = this.httpUtils.doPost(restTemplate, HttpUtils.RemoteService.CRM_IBM, POINT_QUERY_METHOD, session, jsonStr, PointQueryOut.class, "CRM\u4f1a\u5458\u7cfb\u7edf", "\u79ef\u5206\u67e5\u8be2");
        if ("0".equals(resp.getReturncode())) {
            PointQueryOut pointQueryOut = (PointQueryOut)resp.getData();
            resp = AeonIBMCrmService.resolveResponse(resp, pointQueryOut.getIntegralCardIntegralSearchReply());
        }
        return resp;
    }

    public ServiceResponse pointCancelTransaction(RestTemplate restTemplate, ServiceSession session, PointCancelTransactionIn in) {
        String jsonStr = JSON.toJSONString((Object)in);
        ServiceResponse resp = this.httpUtils.doPost(restTemplate, HttpUtils.RemoteService.CRM_IBM, POINT_TRANSACTION_CANCEL_METHOD, session, jsonStr, PointCancelTransactionOut.class, "CRM\u4f1a\u5458\u7cfb\u7edf", "\u79ef\u5206\u4ea4\u6613\u53d6\u6d88");
        if ("0".equals(resp.getReturncode())) {
            PointCancelTransactionOut out = (PointCancelTransactionOut)resp.getData();
            resp = AeonIBMCrmService.resolveResponse(resp, out.getIntegralCardIntegralTransactionCancellationReply());
        }
        return resp;
    }

    public ServiceResponse pointRefundTransactionGoodsQuery(RestTemplate restTemplate, ServiceSession session, PointRefundTransactionGoodsQueryIn in) {
        String jsonStr = JSON.toJSONString((Object)in);
        ServiceResponse resp = this.httpUtils.doPost(restTemplate, HttpUtils.RemoteService.CRM_IBM, POINT_TRANSACTION_REFUND_GOODS_METHOD, session, jsonStr, PointCancelTransactionOut.class, "CRM\u4f1a\u5458\u7cfb\u7edf", "\u79ef\u5206\u4ea4\u6613\u9000\u8d27");
        if ("0".equals(resp.getReturncode())) {
            PointRefundTransactionGoodsQueryOut out = (PointRefundTransactionGoodsQueryOut)resp.getData();
            resp = AeonIBMCrmService.resolveResponse(resp, out.getIntegralCardIntegralTransactionReturnSearchReply());
        }
        return resp;
    }

    public ServiceResponse pointRefundTransaction(RestTemplate restTemplate, ServiceSession session, PointRefundTransactionIn in) {
        String jsonStr = JSON.toJSONString((Object)in);
        ServiceResponse resp = this.httpUtils.doPost(restTemplate, HttpUtils.RemoteService.CRM_IBM, POINT_TRANSACTION_REFUND_METHOD, session, jsonStr, PointCancelTransactionOut.class, "CRM\u4f1a\u5458\u7cfb\u7edf", "\u79ef\u5206\u4ea4\u6613\u9000\u8d27");
        if ("0".equals(resp.getReturncode())) {
            PointRefundTransactionOut out = (PointRefundTransactionOut)resp.getData();
            resp = AeonIBMCrmService.resolveResponse(resp, out.getIntegralCardTransactionReturnReply());
        }
        return resp;
    }

    public ServiceResponse pointExchange(RestTemplate restTemplate, ServiceSession session, PointExchangeIn in) {
        String jsonStr = JSON.toJSONString((Object)in);
        ServiceResponse resp = this.httpUtils.doPost(restTemplate, HttpUtils.RemoteService.CRM_IBM, POINT_EXCHANGE_METHOD, session, jsonStr, PointExchangeOut.class, "CRM\u4f1a\u5458\u7cfb\u7edf", "\u79ef\u5206\u5151\u6362");
        if ("0".equals(resp.getReturncode())) {
            PointExchangeOut out = (PointExchangeOut)resp.getData();
            resp = AeonIBMCrmService.resolveResponse(resp, out.getIntegralCardExchangeTransactionReply());
        }
        return resp;
    }

    public ServiceResponse pointCancelExchange(RestTemplate restTemplate, ServiceSession session, PointCancelExchangeIn in) {
        String jsonStr = JSON.toJSONString((Object)in);
        ServiceResponse resp = this.httpUtils.doPost(restTemplate, HttpUtils.RemoteService.CRM_IBM, POINT_EXCHANGE_CANCEL_METHOD, session, jsonStr, PointCancelExchangeOut.class, "CRM\u4f1a\u5458\u7cfb\u7edf", "\u79ef\u5206\u5151\u6362\u53d6\u6d88");
        if ("0".equals(resp.getReturncode())) {
            PointCancelExchangeOut out = (PointCancelExchangeOut)resp.getData();
            resp = AeonIBMCrmService.resolveResponse(resp, out.getIntegralCardExchangeTransactionCancellationReply());
        }
        return resp;
    }

    public ServiceResponse pointRefundExchange(RestTemplate restTemplate, ServiceSession session, PointRefundExchangeIn in) {
        String jsonStr = JSON.toJSONString((Object)in);
        ServiceResponse resp = this.httpUtils.doPost(restTemplate, HttpUtils.RemoteService.CRM_IBM, POINT_EXCHANGE_REFUND_METHOD, session, jsonStr, PointRefundExchangeOut.class, "CRM\u4f1a\u5458\u7cfb\u7edf", "\u79ef\u5206\u5151\u6362\u9000\u8d27");
        if ("0".equals(resp.getReturncode())) {
            PointRefundExchangeOut out = (PointRefundExchangeOut)resp.getData();
            resp = AeonIBMCrmService.resolveResponse(resp, out.getIntegralCardExchangeTransactionReturnReply());
        }
        return resp;
    }

    private static ServiceResponse resolveResponse(ServiceResponse originResp, AeonCrmReply out) {
        ServiceResponse resp = originResp;
        String tradeReturnCode = out.getTradeReturnCode();
        if (tradeReturnCode == null) {
            throw new RuntimeException("\u8bf7\u6c42\u4f1a\u5458\u7cfb\u7edf\u8fd4\u56de\u7801\u4e3a\u7a7a\uff01");
        }
        String errMsg = AeonIBMCrmService.getTradeReturnMsg(tradeReturnCode);
        if (errMsg != null) {
            resp.setReturncode(tradeReturnCode);
            resp.setData((Object)errMsg);
        } else {
            resp.setData((Object)out);
        }
        return resp;
    }

    private static String getTradeReturnMsg(String code) {
        switch (code) {
            case "01": {
                return "\u4f1a\u5458\u5361\u5df2\u6ce8\u9500/\u8fc7\u671f";
            }
            case "02": {
                return "\u4f1a\u5458\u5361\u5df2\u6ce8\u9500/\u8fc7\u671f";
            }
            case "03": {
                return "\u91cd\u590d\u4ea4\u6613";
            }
            case "04": {
                return "\u4f1a\u5458\u5df2\u6ce8\u9500";
            }
            case "05": {
                return "\u62d2\u7edd\u4ea4\u6613";
            }
            case "06": {
                return "\u79ef\u5206\u4f59\u989d\u4e0d\u8db3";
            }
            case "07": {
                return "\u7f51\u7edc\u6545\u969c";
            }
            case "08": {
                return "\u79ef\u5206\u5151\u6362\u4e0d\u8db31000\u5206";
            }
            case "09": {
                return "\u4f7f\u7528\u79ef\u5206\u975e\u6307\u5b9a\u91d1\u989d\u7684\u6574\u6570\u500d";
            }
            case "10": {
                return "\u65e0\u6709\u6548\u7535\u5b50\u5238";
            }
            case "11": {
                return "\u7535\u5b50\u5238\u4e0d\u5b58\u5728";
            }
            case "12": {
                return "\u7535\u5b50\u5238\u4e0d\u80fd\u7528\u4e8e\u672c\u4ea4\u6613";
            }
            case "13": {
                return "\u9ed1\u540d\u5355";
            }
            case "14": {
                return "\u4f1a\u5458\u5df2\u8fc7\u671f";
            }
            case "15": {
                return "\u4f1a\u5458\u4e0d\u5b58\u5728";
            }
            case "16": {
                return "\u624b\u673a\u53f7\u4e0d\u5b58\u5728";
            }
            case "17": {
                return "\u5361\u53f7\u7801\u6821\u9a8c\u9519\u8bef";
            }
            case "18": {
                return "\u95e8\u5e97\u4e0d\u5b58\u5728";
            }
            case "19": {
                return "\u539f\u5355\u53f7CRM\u7cfb\u7edf\u4e0d\u5b58\u5728";
            }
            case "20": {
                return "\u5f53\u524d\u4fe1\u606f\u4e0e\u539f\u5355\u4e0d\u7b26";
            }
            case "21": {
                return "\u7535\u5b50\u5238\u53d6\u6d88\u5931\u8d25";
            }
            case "22": {
                return "\u624b\u673a\u53f7\u4e0d\u5b58\u5728";
            }
            case "90": {
                return "CRM\u79bb\u7ebf\u6a21\u5f0f\u4e0d\u652f\u6301\u5f53\u524d\u4e1a\u52a1";
            }
            case "91": {
                return "\u8d85\u65f6";
            }
            case "92": {
                return "\u5176\u4ed6\u9519\u8bef";
            }
            case "99": {
                return "\u8bf7\u6c42\u5e97\u94fa\u670d\u52a1\u5668\u6388\u6743";
            }
        }
        return null;
    }
}

