/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pos.component.service;

import com.efuture.pos.component.service.BaseService;
import com.efuture.pos.model.cnaeon.BaseResponse;
import com.efuture.pos.util.HttpUtils;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@ConditionalOnProperty(name={"epos.run"}, havingValue="yes", matchIfMissing=true)
@Service
public class CnaeonCentreService
extends BaseService {
    public static final String CNAEON_COUPON_QUERY = "/coupon/currentAvailable";
    public static final String CNAEON_COUPON_CHECK = "/coupon/verifyCoupon";
    public static final String CNAEON_COUPON_PAY = "/coupon/payUseCouponDiscounts";
    public static final String CNAEON_COUPON_PAYSCAN = "/coupon/payScanCoupon";
    public static final String CNAEON_COUPON_BACKPAYMQ = "pro.rocketmq.discountsReversalToMQ";
    public static final String CNAEON_COUPON_BACKPAY = "/coupon/backPayCoupon";
    public static final String CNAEON_COUPON_CANCEL = "/coupon/cancelCoupon";
    public static final String CNAEON_COUPON_BACKSTAMP = "/coupon/getBackCouponBackStamp";
    public static final String CNAEON_POINT_REVERSE = "pro.rocketmq.integralReversalToMQ";

    public ServiceResponse couponQuery(RestTemplate restTemplate, ServiceSession session, String inStr) {
        ServiceResponse resp = this.httpUtils.cnaeonDoPost(restTemplate, HttpUtils.RemoteService.CNAEON, CNAEON_COUPON_QUERY, session, inStr, BaseResponse.class, "\u4e2d\u56fd\u6c38\u65fa\u4e91\u4e2d\u53f0", "\u5238\u67e5\u8be2");
        return resp;
    }

    public ServiceResponse verifyCoupon(RestTemplate restTemplate, ServiceSession session, String inStr) {
        ServiceResponse resp = this.httpUtils.cnaeonDoPost(restTemplate, HttpUtils.RemoteService.CNAEON, CNAEON_COUPON_CHECK, session, inStr, BaseResponse.class, "\u4e2d\u56fd\u6c38\u65fa\u4e91\u4e2d\u53f0", "\u5238\u6821\u9a8c");
        return resp;
    }

    public ServiceResponse couponPay(RestTemplate restTemplate, ServiceSession session, String inStr) {
        ServiceResponse resp = this.httpUtils.cnaeonDoPost(restTemplate, HttpUtils.RemoteService.CNAEON, CNAEON_COUPON_PAY, session, inStr, BaseResponse.class, "\u4e2d\u56fd\u6c38\u65fa\u4e91\u4e2d\u53f0", "\u5238\u6838\u9500");
        return resp;
    }

    public ServiceResponse couponPayScan(RestTemplate restTemplate, ServiceSession session, String inStr) {
        ServiceResponse resp = this.httpUtils.cnaeonDoPost(restTemplate, HttpUtils.RemoteService.CNAEON, CNAEON_COUPON_PAYSCAN, session, inStr, BaseResponse.class, "\u4e2d\u56fd\u6c38\u65fa\u4e91\u4e2d\u53f0", "\u626b\u7801\u7528\u5238");
        return resp;
    }

    public ServiceResponse couponBackPay(RestTemplate restTemplate, ServiceSession session, String inStr) {
        ServiceResponse resp = this.httpUtils.cnaeonDoPost(restTemplate, HttpUtils.RemoteService.CNAEON, CNAEON_COUPON_BACKPAY, session, inStr, BaseResponse.class, "\u4e2d\u56fd\u6c38\u65fa\u4e91\u4e2d\u53f0", "\u5238\u51b2\u6b63");
        return resp;
    }

    public ServiceResponse couponBackPayMQ(RestTemplate restTemplate, ServiceSession session, String inStr) {
        ServiceResponse resp = this.httpUtils.doPostZuul(restTemplate, HttpUtils.RemoteService.ROCKERMQ_PRODUCER, CNAEON_COUPON_BACKPAYMQ, session, inStr, BaseResponse.class, "\u4e2d\u56fd\u6c38\u65fa\u4e91\u4e2d\u53f0", "MQ\u5238\u51b2\u6b63");
        return resp;
    }

    public ServiceResponse couponCannelPay(RestTemplate restTemplate, ServiceSession session, String inStr) {
        ServiceResponse resp = this.httpUtils.cnaeonDoPost(restTemplate, HttpUtils.RemoteService.CNAEON, CNAEON_COUPON_CANCEL, session, inStr, BaseResponse.class, "\u4e2d\u56fd\u6c38\u65fa\u4e91\u4e2d\u53f0", "\u5238\u64a4\u9500");
        return resp;
    }

    public ServiceResponse couponBackStamp(RestTemplate restTemplate, ServiceSession session, String inStr) {
        ServiceResponse resp = this.httpUtils.cnaeonDoPost(restTemplate, HttpUtils.RemoteService.CNAEON, CNAEON_COUPON_BACKSTAMP, session, inStr, BaseResponse.class, "\u4e2d\u56fd\u6c38\u65fa\u4e91\u4e2d\u53f0", "\u8ba1\u7b97\u5370\u82b1");
        return resp;
    }

    public ServiceResponse pointConsumeReverse(RestTemplate restTemplate, ServiceSession session, String inStr) {
        ServiceResponse resp = this.httpUtils.doPostZuul(restTemplate, HttpUtils.RemoteService.ROCKERMQ_PRODUCER, CNAEON_POINT_REVERSE, session, inStr, BaseResponse.class, "\u4e2d\u56fd\u6c38\u65fa\u4e91\u4e2d\u53f0", "\u79ef\u5206\u51b2\u6b63\u53d1\u9001MQ");
        return resp;
    }
}

