/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pos.component.service;

import com.efuture.pos.component.OrderServiceImpl;
import com.efuture.pos.component.service.BaseService;
import com.efuture.pos.model.CacheModel;
import com.efuture.pos.model.Goods;
import com.efuture.pos.model.Payment;
import com.efuture.pos.model.SysPara;
import com.efuture.pos.model.zhongbai.BaseResponse;
import com.efuture.pos.util.HttpUtils;
import com.efuture.pos.util.RSAConfig;
import com.efuture.pos.util.RSAUtil;
import com.efuture.pos.util.SocketClientUtil;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.httpclient.util.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@ConditionalOnProperty(name={"epos.run"}, havingValue="yes", matchIfMissing=true)
@Service
public class ZhongBaio2oService
extends BaseService {
    @Resource(name="possvRSAConfig")
    public RSAConfig rsaConfig;
    public final String zhongbaiPayUrl = "HYPU";
    @Autowired
    OrderServiceImpl orderService;
    private static final Logger LOGGER = LoggerFactory.getLogger(ZhongBaio2oService.class);

    public ServiceResponse execute(RestTemplate restTemplate, ServiceSession session, String inStr, String serviceType, String RemoteServiceUrl) {
        BaseResponse data;
        RSAUtil.getPrivateKey(this.rsaConfig.getRSAPrivateKey());
        RSAUtil.getPublicKey(this.rsaConfig.getRSAPublicKey());
        if (StringUtils.isEmpty((Object)RemoteServiceUrl)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"\u4ece\u603b\u90e8\u83b7\u53d6\u5238\u5e73\u53f0\u8bf7\u6c42\u5730\u5740\u4e3a\u7a7a!");
        }
        ServiceResponse resp = this.httpUtils.zhongbaiDataCenterPost(restTemplate, HttpUtils.RemoteService.ZHONGBAI_DATACENTER, RemoteServiceUrl, session, inStr, BaseResponse.class, "\u4e2d\u767e\u5238\u5e73\u53f0", serviceType);
        if ("0".equals(resp.getReturncode()) && !"00".equals((data = (BaseResponse)resp.getData()).getRetCode())) {
            resp.setReturncode(data.getErrCode());
            resp.setData((Object)data.getErrMsg());
        }
        return resp;
    }

    public String getTrainID(CacheModel cacheModel, String ip, int port) {
        String tranID = "";
        try {
            StringBuffer sbuff = new StringBuffer();
            sbuff.append("MI");
            sbuff.append("|");
            sbuff.append("|");
            sbuff.append(cacheModel.getOrder().getShopCode());
            sbuff.append("|");
            sbuff.append(cacheModel.getOrder().getTerminalNo());
            sbuff.append("|");
            sbuff.append(cacheModel.getOrder().getTerminalSno().substring(cacheModel.getOrder().getTerminalSno().length() - 4, cacheModel.getOrder().getTerminalSno().length()));
            String msgStr = sbuff.toString();
            String lenStr = ZhongBaio2oService.getLenthByMsg(msgStr);
            String msg = lenStr.concat(msgStr);
            LOGGER.info("[\u4e2d\u767e\u5238\u5e73\u53f0] -->[\u83b7\u53d6\u4ea4\u6613\u8bf7\u6c42ID] ip[{}] port[{}] [{}]", new Object[]{ip, port, msg});
            String returnMsg = SocketClientUtil.sendCIPMessage(msg, ip, port, 0, this.rsaConfig.getSocketTimeout());
            LOGGER.info("[\u4e2d\u767e\u5238\u5e73\u53f0] -->[\u83b7\u53d6\u4ea4\u6613\u8bf7\u6c42ID] \u8fd4\u56de\u62a5\u6587 [{}]", (Object)returnMsg);
            tranID = ZhongBaio2oService.validateReturnMsg(returnMsg);
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("[\u4e2d\u767e\u5238\u5e73\u53f0] -->[\u83b7\u53d6\u4ea4\u6613\u8bf7\u6c42ID]  \u4e0a\u9001\u5931\u8d25{}", (Object)e.toString());
            e.printStackTrace();
        }
        catch (IOException e) {
            LOGGER.error("[\u4e2d\u767e\u5238\u5e73\u53f0] -->[\u83b7\u53d6\u4ea4\u6613\u8bf7\u6c42ID]  \u4e0a\u9001\u5931\u8d25{}", (Object)e.toString());
            e.printStackTrace();
        }
        return tranID;
    }

    private static String getLenthByMsg(String msg) throws UnsupportedEncodingException {
        byte[] msgBty = msg.getBytes("GB2312");
        return ZhongBaio2oService.getLenthByMsg(msgBty);
    }

    private static String getLenthByMsg(byte[] msgByte) throws UnsupportedEncodingException {
        StringBuffer sbuffBuffer = new StringBuffer();
        int msgLen = msgByte.length;
        String lenStr = String.valueOf(msgLen);
        for (int i = lenStr.length(); i < 6; ++i) {
            sbuffBuffer.append("0");
        }
        sbuffBuffer.append(lenStr);
        return sbuffBuffer.toString();
    }

    private static String validateReturnMsg(String returnMsg) {
        String lengStr = returnMsg.substring(0, 6);
        int leng = Integer.valueOf(lengStr);
        String msgStr = returnMsg.substring(6);
        String TranID = "";
        try {
            byte[] bt = msgStr.getBytes("GB2312");
            if (leng != bt.length) {
                LOGGER.error("\u8fd4\u56de\u62a5\u6587\u957f\u5ea6\u4e0d\u5408\u6cd5!");
                return "";
            }
            String[] returnMsgArr = returnMsg.split("\\|");
            if (!"0".equals(returnMsgArr[1])) {
                LOGGER.error("\u9a8c\u8bc1tranID\u5931\u8d25\uff0c[{}]", (Object)returnMsgArr[2]);
                return "";
            }
            TranID = returnMsgArr[2];
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("\u9a8c\u8bc1tranID\u5931\u8d25\uff0c[{}]", (Throwable)e);
            e.printStackTrace();
        }
        return TranID;
    }

    public String packageSubmitReq(CacheModel cacheModel, RSAConfig rsaConfig, String tranID) {
        String msg = "";
        try {
            StringBuffer sbuff = new StringBuffer();
            sbuff.append("MS");
            sbuff.append("|");
            sbuff.append("|");
            sbuff.append(tranID);
            sbuff.append("|");
            sbuff.append(cacheModel.getGoodsList().size());
            sbuff.append("|");
            sbuff.append(cacheModel.getPayments().size());
            sbuff.append("|");
            sbuff.append(cacheModel.getOrder().getShopCode());
            sbuff.append("|");
            sbuff.append(cacheModel.getOrder().getTerminalNo());
            sbuff.append("|");
            sbuff.append(cacheModel.getOrder().getTerminalSno());
            sbuff.append("|");
            sbuff.append(DateUtil.formatDate((Date)new Date(), (String)"yyyyMMddHHmmss"));
            sbuff.append("|");
            sbuff.append("|");
            sbuff.append("|");
            sbuff.append(cacheModel.getOrder().getTerminalOperator());
            sbuff.append("|");
            sbuff.append("|");
            if (null != cacheModel.getOrder().getConsumersData() && !StringUtils.isEmpty((Object)cacheModel.getOrder().getConsumersData().getConsumersCard())) {
                sbuff.append(cacheModel.getOrder().getConsumersData().getConsumersCard());
            }
            sbuff.append("|");
            if ("1".equals(cacheModel.getOrder().getOrderType())) {
                sbuff.append("0");
            } else {
                sbuff.append("1");
            }
            sbuff.append("|");
            sbuff.append(cacheModel.getOrder().getTerminalSno().substring(cacheModel.getOrder().getTerminalSno().length() - 4, cacheModel.getOrder().getTerminalSno().length()));
            List<Goods> goodList = cacheModel.getGoodsList();
            for (int i = 0; i < goodList.size(); ++i) {
                if (i > 0) {
                    sbuff.append(";");
                } else {
                    sbuff.append("#");
                }
                sbuff.append(goodList.get(i).getGoodsCode());
                sbuff.append("|");
                sbuff.append(goodList.get(i).getQty());
                sbuff.append("|");
                sbuff.append(goodList.get(i).getListPrice());
                sbuff.append("|");
                sbuff.append(goodList.get(i).getSalePrice());
                sbuff.append("|");
                sbuff.append(cacheModel.getOrder().getTerminalOperator());
                sbuff.append("|");
                sbuff.append(goodList.get(i).getFlowId());
                sbuff.append("|");
                sbuff.append(goodList.get(i).getGoodsType());
                sbuff.append("|");
                sbuff.append(goodList.get(i).getOrgCode());
                sbuff.append("|");
                sbuff.append("|");
                sbuff.append(goodList.get(i).getBrand());
                sbuff.append("|");
            }
            List<Payment> salePays = cacheModel.getPayments();
            for (int i = 0; i < salePays.size(); ++i) {
                if (i > 0) {
                    sbuff.append(";");
                } else {
                    sbuff.append("#");
                }
                sbuff.append(salePays.get(i).getPayCode());
                sbuff.append("|");
                sbuff.append(salePays.get(i).getMoney());
                sbuff.append("|");
                sbuff.append(salePays.get(i).getPayNo());
                sbuff.append("|");
                sbuff.append("1");
                sbuff.append("|");
                sbuff.append(salePays.get(i).getRowno());
            }
            String msgStr = sbuff.toString();
            String lenStr = ZhongBaio2oService.getLenthByMsg(msgStr);
            msg = lenStr.concat(msgStr);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return msg;
    }

    public String getRemotePayServiceUrl(ServiceSession session, String shopCode, String erpCode) {
        ArrayList<String> codes = new ArrayList<String>();
        codes.add("HYPU");
        List<SysPara> sysPara = this.orderService.getSyspara(session, codes, session.getErpCode(), shopCode);
        String url = SysPara.getSysParaInfo(sysPara, "HYPU");
        return url;
    }
}

