/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pos.model;

import com.efuture.enu.order.LogisticsModeEnum;
import com.efuture.enu.order.OrderStateEnum;
import com.efuture.enu.order.UploadErpEnum;
import com.efuture.model.order.OrdersExtModel;
import com.efuture.model.order.OrdersMemberModel;
import com.efuture.pos.component.common.SellType;
import com.efuture.pos.model.ConsumersData;
import com.efuture.pos.model.Coupon;
import com.efuture.pos.model.DelGoodsInfo;
import com.efuture.pos.model.OrderBase;
import com.efuture.pos.model.SysParaInfo;
import com.efuture.pos.model.orderCentre.OrdersModel4Pos;
import com.efuture.pos.model.orderCentre.SaleOrders;
import com.efuture.pos.model.promotionCentre.BillDetail;
import com.efuture.pos.model.promotionCentre.SellConsData;
import com.efuture.pos.util.CastUtil;
import com.efuture.pos.util.DataExchageUtils;
import com.efuture.pos.util.ManipulatePrecision;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class Order
extends OrderBase
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private String orgId;
    private List<Coupon> couponDetails;
    private String scheduleCode;
    private String posType;
    private String scanSaleUploadTime;
    private String memberActionSno;
    private double noDiscountValue;
    private String orderUploadTime;
    private String precisionMode;
    private boolean uploadErp;
    private String trackNo;
    private String originTailPayNo;
    private String calcMarketingMode;
    private String marketingConsumersCard;
    private int memberType = 1;
    private boolean allowEditGoods = true;
    private boolean sendSuccess = false;
    private double electronicStamp;
    private double physicalStamp;
    private double tempElectronicStamp;
    private double tempPhysicalStamp;
    private double tempPhyStamp;
    private String stampStatus;
    private double tempPointNum;
    private DelGoodsInfo delGoods;
    private String createDate;
    private String payDate;
    private boolean isAllReturn = true;
    private SysParaInfo sysPara;
    private int popmode = 1;

    public int getPopmode() {
        return this.popmode;
    }

    public void setPopmode(int popmode) {
        this.popmode = popmode;
    }

    public double getNoDiscountValue() {
        return this.noDiscountValue;
    }

    public void setNoDiscountValue(double noDiscountValue) {
        this.noDiscountValue = noDiscountValue;
    }

    public SysParaInfo getSysPara() {
        return this.sysPara;
    }

    public void setSysPara(SysParaInfo sysPara) {
        this.sysPara = sysPara;
    }

    public boolean getIsAllReturn() {
        return this.isAllReturn;
    }

    public void setIsAllReturn(boolean isAllReturn) {
        this.isAllReturn = isAllReturn;
    }

    public String getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(String createDate) {
        this.createDate = createDate;
    }

    public String getPayDate() {
        return this.payDate;
    }

    public void setPayDate(String payDate) {
        this.payDate = payDate;
    }

    public String getOrgId() {
        return this.orgId;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public DelGoodsInfo getDelGoods() {
        return this.delGoods;
    }

    public void setDelGoods(DelGoodsInfo delGoods) {
        this.delGoods = delGoods;
    }

    public List<Coupon> getCouponDetails() {
        return this.couponDetails;
    }

    public void setCouponDetails(List<Coupon> couponDetails) {
        this.couponDetails = couponDetails;
    }

    public String getCalcMarketingMode() {
        return this.calcMarketingMode;
    }

    public void setCalcMarketingMode(String calcMarketingMode) {
        this.calcMarketingMode = calcMarketingMode;
    }

    public String getMarketingConsumersCard() {
        return this.marketingConsumersCard;
    }

    public void setMarketingConsumersCard(String marketingConsumersCard) {
        this.marketingConsumersCard = marketingConsumersCard;
    }

    public String getOriginTailPayNo() {
        return this.originTailPayNo;
    }

    public void setOriginTailPayNo(String originTailPayNo) {
        this.originTailPayNo = originTailPayNo;
    }

    public String getMemberActionSno() {
        return this.memberActionSno;
    }

    public void setMemberActionSno(String memberActionSno) {
        this.memberActionSno = memberActionSno;
    }

    public String getScanSaleUploadTime() {
        return this.scanSaleUploadTime;
    }

    public String getScheduleCode() {
        return this.scheduleCode;
    }

    public void setScheduleCode(String scheduleCode) {
        this.scheduleCode = scheduleCode;
    }

    public String getPosType() {
        return this.posType;
    }

    public void setPosType(String posType) {
        this.posType = posType;
    }

    public void setScanSaleUploadTime(String scanSaleUploadTime) {
        this.scanSaleUploadTime = scanSaleUploadTime;
    }

    public String getPrecisionMode() {
        return this.precisionMode;
    }

    public void setPrecisionMode(String precisionMode) {
        this.precisionMode = precisionMode;
    }

    public String getOrderUploadTime() {
        return this.orderUploadTime;
    }

    public void setOrderUploadTime(String orderUploadTime) {
        this.orderUploadTime = orderUploadTime;
    }

    public boolean getUploadErp() {
        return this.uploadErp;
    }

    public void setUploadErp(boolean uploadErp) {
        this.uploadErp = uploadErp;
    }

    public String getTrackNo() {
        return this.trackNo;
    }

    public void setTrackNo(String trackNo) {
        this.trackNo = trackNo;
    }

    public int getMemberType() {
        return this.memberType;
    }

    public void setMemberType(int memberType) {
        this.memberType = memberType;
    }

    public boolean getAllowEditGoods() {
        return this.allowEditGoods;
    }

    public void setAllowEditGoods(boolean allowEditGoods) {
        this.allowEditGoods = allowEditGoods;
    }

    public boolean getSendSuccess() {
        return this.sendSuccess;
    }

    public void setSendSuccess(boolean sendSuccess) {
        this.sendSuccess = sendSuccess;
    }

    public double getElectronicStamp() {
        return this.electronicStamp;
    }

    public void setElectronicStamp(double electronicStamp) {
        this.electronicStamp = electronicStamp;
    }

    public double getPhysicalStamp() {
        return this.physicalStamp;
    }

    public void setPhysicalStamp(double physicalStamp) {
        this.physicalStamp = physicalStamp;
    }

    public double getTempElectronicStamp() {
        return this.tempElectronicStamp;
    }

    public void setTempElectronicStamp(double tempElectronicStamp) {
        this.tempElectronicStamp = tempElectronicStamp;
    }

    public double getTempPhysicalStamp() {
        return this.tempPhysicalStamp;
    }

    public void setTempPhysicalStamp(double tempPhysicalStamp) {
        this.tempPhysicalStamp = tempPhysicalStamp;
    }

    public double getTempPhyStamp() {
        return this.tempPhyStamp;
    }

    public void setTempPhyStamp(double tempPhyStamp) {
        this.tempPhyStamp = tempPhyStamp;
    }

    public String getStampStatus() {
        return this.stampStatus;
    }

    public void setStampStatus(String stampStatus) {
        this.stampStatus = stampStatus;
    }

    public double getTempPointNum() {
        return this.tempPointNum;
    }

    public void setTempPointNum(double tempPointNum) {
        this.tempPointNum = tempPointNum;
    }

    public static BillDetail transferBillDetail(Order order) {
        BillDetail billDetail = new BillDetail();
        ConsumersData consumer = order.getConsumersData();
        if (null != consumer) {
            billDetail.setConsumersId(consumer.getConsumersId());
            billDetail.setConsumersCardNo(consumer.getConsumersCard());
            billDetail.setConsumersType(consumer.getConsumersType());
            SellConsData sellConsData = new SellConsData();
            if (null != consumer.getConsumersTrgs() && consumer.getConsumersTrgs().size() > 0) {
                sellConsData.setConsumersGrps(consumer.getConsumersTrgs());
            } else {
                sellConsData.setConsumersGrps(new ArrayList<String>());
            }
            if ("04".equals(consumer.getConsumersType())) {
                billDetail.setConsumersType("01");
                billDetail.setConsumersId("1234567890");
            }
            sellConsData.setConsumersGrps(new ArrayList<String>());
            sellConsData.getConsumersGrps().add(order.getOrgId());
            if (consumer.getIsMami()) {
                sellConsData.getConsumersGrps().add("M");
            }
            billDetail.setConsumersData(sellConsData);
        }
        billDetail.setManaUnit(order.getErpCode());
        billDetail.setBillNo(order.getYpopBillNo());
        billDetail.setTermOperator(order.getTerminalOperator());
        billDetail.setOughtPay(order.getOughtPay());
        billDetail.setSswrOverage(-ManipulatePrecision.doubleConvert(order.getRoundUpOverageValue(), 4, 1));
        billDetail.setFactPay(order.getExistPay());
        billDetail.setChangePay(order.getChangeValue());
        billDetail.setFactOverage(order.getOverageValue() - order.getPayOverageValue());
        billDetail.setChannel(order.getChannel());
        billDetail.setMarket(order.getShopCode());
        billDetail.setTermNo(order.getTerminalNo());
        billDetail.setSaleDate(order.getSaleDate());
        billDetail.setTermInvoiceNo(CastUtil.castLong(order.getTerminalSno()));
        billDetail.setInvoiceType(DataExchageUtils.getDjlb(order.getOrderType()));
        billDetail.setOriginalBillNo(order.getOriginFlowNo());
        if (order.getOrderType().equals("4")) {
            billDetail.setOriginalMode("CANUSE");
        }
        return billDetail;
    }

    public static SaleOrders toSaleOrder(Order order) {
        SaleOrders saleOrders = new SaleOrders();
        OrdersModel4Pos saleOrder = new OrdersModel4Pos();
        OrdersMemberModel saleOrdersMember = new OrdersMemberModel();
        ConsumersData consumer = order.getConsumersData();
        if (null != consumer) {
            saleOrder.setCid(consumer.getConsumersId());
            saleOrder.setCusCode(consumer.getConsumersCard());
            saleOrdersMember.setCusClass(consumer.getConsumersType());
            saleOrdersMember.setCid(consumer.getConsumersId());
            saleOrdersMember.setCusCode(consumer.getConsumersCard());
            saleOrdersMember.setCusLevelName(consumer.getConsumersCardName());
            saleOrdersMember.setCusLevel(consumer.getConsumersLevel());
            saleOrdersMember.setMemberActionSno(consumer.getMemberActionSno());
            saleOrdersMember.setUnavailablePointDate(order.getUnavailablePointDate());
            saleOrdersMember.setUnavailablePoint(new Double(order.getUnavailablePoint()));
            saleOrdersMember.setThisTimeGivePoint(Double.valueOf(order.getThisTimePoint()));
            saleOrdersMember.setThisTimeUsedPoint(Double.valueOf(order.getThisTimeUsedPoint()));
            saleOrdersMember.setThisTimeUsablePoint(Double.valueOf(order.getTotalPoint()));
            saleOrdersMember.setLastTimeUsablePoint(Double.valueOf(consumer.getPoint()));
            saleOrdersMember.setMembershipExpireDate(consumer.getConsumersCardExp());
            if (consumer.getIsMami()) {
                saleOrdersMember.setCusProperty("1");
            } else {
                saleOrdersMember.setCusProperty("0");
            }
        }
        saleOrdersMember.setJfkh(order.getPointCardNo());
        saleOrdersMember.setTrackNo(order.getTrackNo());
        saleOrdersMember.setPhysicalStamp(BigDecimal.valueOf(order.getPhysicalStamp()));
        saleOrdersMember.setElectronicStamp(BigDecimal.valueOf(order.getElectronicStamp()));
        saleOrder.setCorporationCode(order.getOrgId());
        saleOrder.setOrderShift(order.getScheduleCode());
        saleOrder.setEntId(order.getEntId());
        saleOrder.setChannel(order.getChannel());
        saleOrder.setChannelSheetNo(order.getYpopBillNo());
        saleOrder.setErpCode(order.getErpCode());
        saleOrder.setTerminalNo(order.getTerminalNo());
        saleOrder.setTerminalSno(order.getTerminalSno());
        saleOrder.setTerminalOperator(order.getTerminalOperator());
        saleOrder.setBusiTakeMarket(order.getShopName());
        saleOrder.setBusiTakeMarketCode(order.getShopCode());
        saleOrder.setAdjustDiscountValue(BigDecimal.valueOf(order.getTemporaryDiscAmount()));
        saleOrder.setCustomDiscountValue(BigDecimal.valueOf(order.getMemberDiscAmount()));
        saleOrder.setPopDiscountValue(BigDecimal.valueOf(order.getPreferentialDiscAmount() - order.getNoDiscountValue()));
        saleOrder.setPayDiscountValue(BigDecimal.valueOf(order.getNoDiscountValue()));
        saleOrder.setTotalDiscountValue(BigDecimal.valueOf(order.getTotalDiscountValue()));
        saleOrder.setOverageValue(BigDecimal.valueOf(order.getOverageValue()));
        saleOrder.setRoundUpOverageValue(BigDecimal.valueOf(order.getRoundUpOverageValue()));
        saleOrder.setOrderType(order.getOrderType());
        saleOrder.setQty(order.getQty());
        saleOrder.setFactPay(BigDecimal.valueOf(order.getExistPay()));
        saleOrder.setOughtPay(BigDecimal.valueOf(ManipulatePrecision.doubleConvert(order.getOughtPay() + order.getRoundUpOverageValue())));
        saleOrder.setOriginalPay(BigDecimal.valueOf(order.getSaleValue()));
        saleOrder.setPayState(order.getPayState());
        saleOrder.setUploadErp(UploadErpEnum.DSC.getCode());
        saleOrder.setThsq(order.getRefundAuthzCardNo());
        saleOrder.setGhsq(order.getTerminalOperatorAuthzCardNo());
        saleOrder.setHysq(order.getMemberAuthzCardNo());
        saleOrder.setSqkh(order.getTotalDiscAuthzCardNo());
        saleOrder.setCalcBillId(order.getSeqNo());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date date;
            String nowDateTime = sdf.format(new Date());
            Date nowTime = sdf.parse(nowDateTime);
            if (StringUtils.isBlank((String)order.getSaleDate())) {
                saleOrder.setSaleDate(nowTime);
            } else {
                Date d = sdf.parse(order.getSaleDate());
                saleOrder.setSaleDate(d);
            }
            if (StringUtils.isBlank((String)order.getPayDate())) {
                saleOrder.setPayDate(nowTime);
            } else {
                date = sdf.parse(order.getPayDate());
                saleOrder.setPayDate(date);
            }
            if (StringUtils.isBlank((String)order.getCreateDate())) {
                saleOrder.setCreateDate(nowTime);
            } else {
                date = sdf.parse(order.getCreateDate());
                saleOrder.setCreateDate(date);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        saleOrder.setOrderState(OrderStateEnum.YWC.getCode());
        saleOrder.setMealDiscountValue(BigDecimal.valueOf(order.getMealDiscAmount()));
        if (order.getLogisticsMode() == 0) {
            order.setLogisticsMode(7);
        }
        saleOrder.setLogisticsMode(LogisticsModeEnum.WXPS.getCode());
        saleOrder.setChangeValue(BigDecimal.valueOf(order.getChangeValue()));
        saleOrder.setRoundUpOverageValue(BigDecimal.valueOf(order.getRoundUpOverageValue()));
        saleOrder.setStaffCardNo(order.getStaffCardNo());
        saleOrder.setStaffCardType(order.getStaffType());
        saleOrder.setStaffNo(order.getStaffNo());
        saleOrder.setStaffShopping(order.getStaffSale());
        saleOrder.setCallerRemark(order.getOutSideGiftsInfo());
        saleOrder.setColdStorage(order.getColdStorage());
        saleOrder.setPosId(order.getFlowNo());
        saleOrder.setBuyerReturnBankcard(CastUtil.castString(order.getPrintMode()));
        if (SellType.ISBACK(order.getOrderType())) {
            saleOrder.setOrderState(OrderStateEnum.T_YWC.getCode());
            saleOrder.setOriginSheetNo(order.getOriginIdSheetNo());
            saleOrder.setReturnReason(Integer.parseInt(order.getReason()));
            saleOrder.setOriginMarketCode(order.getOriginShopCode());
            saleOrder.setReturnApplyType(1);
        }
        OrdersExtModel orderExt = new OrdersExtModel();
        orderExt.setReceiverMobile(order.getReceiverMobile());
        orderExt.setReceiverName(order.getReceiverName());
        orderExt.setReceiverPhone(order.getReceiverPhone());
        orderExt.setInvoiceTitle(order.getInvoiceTitle());
        orderExt.setReceiverDistrict(order.getReceiverDistrict());
        orderExt.setReceiverStreet(order.getReceiverStreet());
        orderExt.setReceiverAddress(order.getReceiverAddress());
        orderExt.setOfcMarketCode(order.getReserveLocation());
        orderExt.setScanGoodOperator(order.getScanGoodOperator());
        orderExt.setGivePointFlag(Integer.valueOf(order.getGivePointFlag()));
        orderExt.setReturnCouponFlag(Integer.valueOf(order.getReturnCouponFlag()));
        orderExt.setReturnPointFlag(Integer.valueOf(order.getReturnPointFlag()));
        try {
            if (StringUtils.isNotBlank((String)order.getScanSubmitTime()) && StringUtils.isNotBlank((String)order.getSaleExtractTime())) {
                Date d = sdf.parse(order.getScanSubmitTime());
                Date d1 = sdf.parse(order.getSaleExtractTime());
                orderExt.setScanSubmitTime(d);
                orderExt.setSaleExtractTime(d1);
            } else {
                orderExt.setScanSubmitTime(saleOrder.getSaleDate());
                orderExt.setSaleExtractTime(saleOrder.getSaleDate());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        saleOrders.setOrders(saleOrder);
        saleOrders.setOrdersExt(orderExt);
        saleOrders.setOrdersMember(saleOrdersMember);
        return saleOrders;
    }

    public static Order transferRetrunOrder(SaleOrders saleOrders, Order order, String orderType) {
        OrdersModel4Pos saleOrder = saleOrders.getOrders();
        order.setOrderType(orderType);
        order.setOriginChannel(saleOrder.getChannel());
        order.setChannel(saleOrder.getChannel());
        order.setOriginIdSheetNo(saleOrder.getSheetNo());
        if (null != saleOrders.getOrdersExt() && null != saleOrders.getOrdersExt().getInvoiceTitle() && saleOrders.getOrdersExt().getInvoiceTitle().length() > 0) {
            order.setOriginInvoiceTitle(saleOrders.getOrdersExt().getInvoiceTitle());
        }
        order.setOriginTerminalNo(saleOrder.getTerminalNo());
        order.setOriginTerminalSno(saleOrder.getTerminalSno());
        order.setOriginTerminalOperator(saleOrder.getTerminalOperator());
        order.setOriginFlowNo(saleOrder.getChannelSheetNo());
        order.setOriginOrderState(saleOrder.getOrderState());
        order.setOriginShopCode(saleOrder.getBusiTakeMarketCode());
        order.setOriginShopName(saleOrder.getBusiTakeMarket());
        order.setShopName(order.getShopName());
        order.setShopCode(order.getShopCode());
        order.setShopId(order.getShopId());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            String nowDateTime = sdf.format(new Date());
            order.setSaleDate(nowDateTime);
            if (null != saleOrder.getSaleDate()) {
                String originSaleDate = sdf.format(saleOrder.getSaleDate());
                order.setOriginSaleDate(originSaleDate);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        order.setEntId(saleOrder.getEntId());
        order.setChannel(saleOrder.getChannel());
        order.setErpCode(saleOrder.getErpCode());
        ConsumersData cust = new ConsumersData();
        if (null != saleOrders.getOrdersMember()) {
            OrdersMemberModel ordersMember = saleOrders.getOrdersMember();
            cust.setConsumersId(ordersMember.getCid());
            cust.setConsumersType(ordersMember.getCusClass());
            cust.setConsumersCardName(ordersMember.getCusLevelName());
            cust.setConsumersLevel(ordersMember.getCusLevel());
            cust.setConsumersCard(ordersMember.getCusCode());
            cust.setMemberActionSno(ordersMember.getMemberActionSno());
            cust.setConsumersCardExp(ordersMember.getMembershipExpireDate());
            if ("1".equals(ordersMember.getCusProperty())) {
                cust.setIsMami(true);
            } else {
                cust.setIsMami(false);
            }
            order.setUnavailablePoint(CastUtil.castDouble(ordersMember.getUnavailablePoint()));
            order.setUnavailablePointDate(ordersMember.getUnavailablePointDate());
        }
        order.setConsumersData(cust);
        order.setTotalDiscountValue(CastUtil.castDouble(saleOrder.getTotalDiscountValue()));
        order.setTemporaryDiscAmount(CastUtil.castDouble(saleOrder.getAdjustDiscountValue()));
        order.setMemberDiscAmount(CastUtil.castDouble(saleOrder.getCustomDiscountValue()));
        order.setPreferentialDiscAmount(ManipulatePrecision.doubleConvert(CastUtil.castDouble(saleOrder.getPopDiscountValue()) + CastUtil.castDouble(saleOrder.getPayDiscountValue())));
        order.setNoDiscountValue(CastUtil.castDouble(saleOrder.getPayDiscountValue()));
        order.setOverageValue(CastUtil.castDouble(saleOrder.getOverageValue()));
        order.setChangeValue(CastUtil.castDouble(saleOrder.getChangeValue()));
        order.setRoundUpOverageValue(CastUtil.castDouble(saleOrder.getRoundUpOverageValue()));
        order.setExistPay(CastUtil.castDouble(saleOrder.getFactPay()));
        order.setOughtPay(ManipulatePrecision.doubleConvert(CastUtil.castDouble(saleOrder.getOughtPay()) - order.getRoundUpOverageValue()));
        order.setPayState(saleOrder.getPayState());
        order.setPointCardNo(saleOrders.getOrdersMember().getJfkh());
        order.setRefundAuthzCardNo(saleOrder.getThsq());
        order.setTerminalOperatorAuthzCardNo(saleOrder.getGhsq());
        order.setMemberAuthzCardNo(saleOrder.getHysq());
        order.setTotalDiscAuthzCardNo(saleOrder.getSqkh());
        order.setSeqNo(saleOrder.getCalcBillId());
        order.setTrackNo(saleOrders.getOrdersMember().getTrackNo());
        order.setStaffCardNo(saleOrder.getStaffCardNo());
        order.setStaffType(saleOrder.getStaffCardType());
        order.setStaffNo(saleOrder.getStaffNo());
        order.setStaffSale(saleOrder.getStaffShopping());
        order.setLogisticsMode(saleOrder.getLogisticsMode());
        order.setOutSideGiftsInfo(saleOrder.getCallerRemark());
        if (null != saleOrders.getOrdersExt()) {
            order.setReceiverName(saleOrders.getOrdersExt().getReceiverName());
            order.setReceiverMobile(saleOrders.getOrdersExt().getReceiverMobile());
            order.setReceiverPhone(saleOrders.getOrdersExt().getReceiverPhone());
            order.setOriginReserveLocation(saleOrders.getOrdersExt().getOfcMarketCode());
            order.setScanGoodOperator(saleOrders.getOrdersExt().getScanGoodOperator());
            order.setSaleExtractTime(saleOrders.getOrdersExt().getSaleExtractTime().toString());
        }
        return order;
    }
}

