/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pos.model.aeonacs.request;

import com.efuture.pos.model.CacheModel;
import com.efuture.pos.model.request.CipPayIn;
import com.efuture.pos.util.Convert;
import java.text.SimpleDateFormat;
import java.util.Date;

public class AcsPayIn {
    private static final long serialVersionUID = 1L;
    private static final transient SimpleDateFormat DATEFORMAT = new SimpleDateFormat("yyyyMMdd");
    private static final transient SimpleDateFormat TIMEFORMAT = new SimpleDateFormat("HHmmss");
    private String messageType;
    private String cardNumber;
    private String expiryDate;
    private String transactionDate;
    private String transactionTime;
    private String totalAmount;
    private String installmentTerms;
    private String firstInstallmentAmount;
    private String trackData;
    private String cashRegisterID;
    private String posEntryMode;
    private String deliveryDemoNumber;
    private String description;
    private String additionalData;
    private String mkt;
    private String erpCode;
    private String flowNo;

    public String getFlowNo() {
        return this.flowNo;
    }

    public void setFlowNo(String flowNo) {
        this.flowNo = flowNo;
    }

    public String getMkt() {
        return this.mkt;
    }

    public void setMkt(String mkt) {
        this.mkt = mkt;
    }

    public String getErpCode() {
        return this.erpCode;
    }

    public void setErpCode(String erpCode) {
        this.erpCode = erpCode;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    public String getCardNumber() {
        return this.cardNumber;
    }

    public void setCardNumber(String cardNumber) {
        this.cardNumber = cardNumber;
    }

    public String getExpiryDate() {
        return this.expiryDate;
    }

    public void setExpiryDate(String expiryDate) {
        this.expiryDate = expiryDate;
    }

    public String getTransactionDate() {
        return this.transactionDate;
    }

    public void setTransactionDate(String transactionDate) {
        this.transactionDate = transactionDate;
    }

    public String getTransactionTime() {
        return this.transactionTime;
    }

    public void setTransactionTime(String transactionTime) {
        this.transactionTime = transactionTime;
    }

    public String getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(String totalAmount) {
        this.totalAmount = totalAmount;
    }

    public String getInstallmentTerms() {
        return this.installmentTerms;
    }

    public void setInstallmentTerms(String installmentTerms) {
        this.installmentTerms = installmentTerms;
    }

    public String getFirstInstallmentAmount() {
        return this.firstInstallmentAmount;
    }

    public void setFirstInstallmentAmount(String firstInstallmentAmount) {
        this.firstInstallmentAmount = firstInstallmentAmount;
    }

    public String getTrackData() {
        return this.trackData;
    }

    public void setTrackData(String trackData) {
        this.trackData = trackData;
    }

    public String getCashRegisterID() {
        return this.cashRegisterID;
    }

    public void setCashRegisterID(String cashRegisterID) {
        this.cashRegisterID = cashRegisterID;
    }

    public String getPosEntryMode() {
        return this.posEntryMode;
    }

    public void setPosEntryMode(String posEntryMode) {
        this.posEntryMode = posEntryMode;
    }

    public String getDeliveryDemoNumber() {
        return this.deliveryDemoNumber;
    }

    public void setDeliveryDemoNumber(String deliveryDemoNumber) {
        this.deliveryDemoNumber = deliveryDemoNumber;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getAdditionalData() {
        return this.additionalData;
    }

    public void setAdditionalData(String additionalData) {
        this.additionalData = additionalData;
    }

    public AcsPayIn transfer(CipPayIn cipPayIn, CacheModel cacheModel) {
        AcsPayIn in = new AcsPayIn();
        in.setCardNumber(cipPayIn.getPayNo());
        in.setExpiryDate(cipPayIn.getExpiryDate());
        in.setTotalAmount(this.doubleToString(cipPayIn.getAmount(), 100));
        in.setInstallmentTerms(cipPayIn.getInstallmentTerms() + "");
        in.setFirstInstallmentAmount(this.doubleToString(cipPayIn.getFirstInstallmentAmount(), 100));
        in.setTrackData(cipPayIn.getTrackData().replaceAll("=", "D"));
        if (cipPayIn.getTerminalNo().length() > 3) {
            int end = cipPayIn.getTerminalNo().length();
            int start = end - 3;
            in.setCashRegisterID(cipPayIn.getTerminalNo().substring(start, end));
        } else {
            in.setCashRegisterID(cipPayIn.getTerminalNo());
        }
        in.setMessageType(cipPayIn.getMessageType());
        in.setPosEntryMode(cipPayIn.getPosEntryMode());
        in.setDeliveryDemoNumber(cipPayIn.getDeliveryMemoNumber());
        in.setDescription(cacheModel.getGoodsList().get(0).getEngName());
        in.setAdditionalData(cipPayIn.getAdditionalData());
        in.setFlowNo(cacheModel.getOrder().getYpopBillNo());
        in.formatFields();
        return in;
    }

    public String doubleToString(double num, int dec) {
        int numInt = (int)(num * (double)dec);
        String numStr = numInt + "";
        return numStr;
    }

    public void formatFields() {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
        String dateTimeStr = format.format(new Date());
        this.transactionDate = dateTimeStr.substring(0, 8);
        this.transactionTime = dateTimeStr.substring(8);
        this.totalAmount = Convert.padLeft(this.totalAmount, '0', 9);
        this.installmentTerms = Convert.padLeft(this.installmentTerms, '0', 2);
        this.firstInstallmentAmount = Convert.padLeft(this.firstInstallmentAmount, '0', 7);
        this.cashRegisterID = Convert.padLeft(this.cashRegisterID, '0', 3);
        this.deliveryDemoNumber = Convert.padLeft(this.deliveryDemoNumber, ' ', 7);
        this.description = Convert.padRight(this.description, ' ', 120);
        this.additionalData = Convert.padRight(this.additionalData, ' ', 50);
        this.cardNumber = Convert.padRight(this.cardNumber, '0', 16);
    }
}

