/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.pos.model.cnaeon.request;

import com.efuture.pos.model.CacheModel;
import com.efuture.pos.model.Goods;
import com.efuture.pos.model.cnaeon.request.CartItem;
import com.efuture.pos.model.cnaeon.request.CnaeonCouponModel;
import com.efuture.pos.model.request.CnaeonCouponQueryIn;
import com.efuture.pos.util.UUIDUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CouponQueryReqest
extends CnaeonCouponModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(CouponQueryReqest.class);
    private String sign;
    private String orderNo;
    private List<CartItem> cartItemList;

    @Override
    public String getSign() {
        return this.sign;
    }

    @Override
    public void setSign(String sign) {
        this.sign = sign;
    }

    public String getOrderNo() {
        return this.orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public List<CartItem> getCartItemList() {
        return this.cartItemList;
    }

    public void setCartItemList(List<CartItem> cartItemList) {
        this.cartItemList = cartItemList;
    }

    public CouponQueryReqest() {
    }

    public CouponQueryReqest(CnaeonCouponQueryIn in, CacheModel cacheModel) {
        this.setTokenId(UUIDUtils.buildGuid());
        this.setTimestamp(System.currentTimeMillis());
        this.setOrgId(cacheModel.getOrder().getOrgId());
        this.setStoreCode(in.getShopCode());
        this.setRegionalCode(in.getErpCode());
        this.setOrderNo(in.getFlowNo());
        this.setSourceId(Integer.valueOf(cacheModel.getOrder().getChannel()));
        if (cacheModel.getOrder().getConsumersData() != null && cacheModel.getOrder().getConsumersData().getConsumersId() != null) {
            this.setMemberId(Long.valueOf(cacheModel.getOrder().getConsumersData().getConsumersId()));
        }
        ArrayList<CartItem> cartItems = new ArrayList<CartItem>();
        for (Goods goods : cacheModel.getGoodsList()) {
            CartItem cartItem = new CartItem();
            cartItem.setCartItemId(String.valueOf(goods.getFlowId()));
            cartItem.setItemCode(goods.getGoodsCode());
            cartItem.setPrice(BigDecimal.valueOf(goods.getSaleValue()));
            cartItem.setPromoPrice(BigDecimal.valueOf(goods.getSaleAmount()));
            cartItem.setQuantity(BigDecimal.valueOf(goods.getQty()));
            cartItems.add(cartItem);
        }
        this.setCartItemList(cartItems);
    }
}

